 /** @type {DocData} */
 var zigAnalysis={"typeKinds":["Unanalyzed","Type","Void","Bool","NoReturn","Int","Float","Pointer","Array","Struct","ComptimeExpr","ComptimeFloat","ComptimeInt","Undefined","Null","Optional","ErrorUnion","InferredErrorUnion","ErrorSet","Enum","Union","Fn","Opaque","Frame","AnyFrame","Vector","EnumLiteral"],"rootMod":0,"params":{"zigId":"arst","zigVersion":"0.11.0","target":"arst","builds":[{"target":"arst"}]},"modules":[{"name":"std","file":0,"main":66,"table":{"std":0,"root":2,"builtin":1}},{"name":"builtin","file":0,"main":436,"table":{}},{"name":"root","file":0,"main":15010,"table":{}}],"errors":[],"astNodes":[[0,0,0,"(root)",null,"\n",[],false],[0,0,0,null,null,null,null,false],[0,1,0,null,null,null,null,false],[0,2,0,null,null,null,null,false],[0,0,0,"array_list.zig",null,"",[],false],[1,0,0,null,null,null,null,false],[1,1,0,null,null,null,null,false],[1,2,0,null,null,null,null,false],[1,3,0,null,null,null,null,false],[1,4,0,null,null,null,null,false],[1,5,0,null,null,null,null,false],[1,6,0,null,null,null,null,false],[1,13,0,null,null," A contiguous, growable list of items in memory.\n This is a wrapper around an array of T values. Initialize with `init`.\n\n This struct internally stores a `std.mem.Allocator` for memory management.\n To manually specify an allocator with each method call see `ArrayListUnmanaged`.",[13],false],[0,0,0,"T",null,"",null,true],[1,24,0,null,null," A contiguous, growable list of arbitrarily aligned items in memory.\n This is a wrapper around an array of T values aligned to `alignment`-byte\n addresses. If the specified alignment is `null`, then `@alignOf(T)` is used.\n Initialize with `init`.\n\n This struct internally stores a `std.mem.Allocator` for memory management.\n To manually specify an allocator with each method call see `ArrayListAlignedUnmanaged`.",[15,16],false],[0,0,0,"T",null,"",null,true],[0,0,0,"alignment",null,"",[152,153,155],true],[1,31,0,null,null,null,null,false],[1,47,0,null,null,null,null,false],[1,49,0,null,null,null,[20],false],[0,0,0,"s",null,"",null,true],[1,54,0,null,null," Deinitialize with `deinit` or use `toOwnedSlice`.",[22],false],[0,0,0,"allocator",null,"",null,false],[1,65,0,null,null," Initialize with capacity to hold `num` elements.\n The resulting capacity will equal `num` exactly.\n Deinitialize with `deinit` or use `toOwnedSlice`.",[24,25],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"num",null,"",null,false],[1,72,0,null,null," Release all allocated memory.",[27],false],[0,0,0,"self",null,"",null,false],[1,81,0,null,null," ArrayList takes ownership of the passed in slice. The slice must have been\n allocated with `allocator`.\n Deinitialize with `deinit` or use `toOwnedSlice`.",[29,30],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"slice",null,"",null,false],[1,92,0,null,null," ArrayList takes ownership of the passed in slice. The slice must have been\n allocated with `allocator`.\n Deinitialize with `deinit` or use `toOwnedSlice`.",[32,33,34],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"sentinel",null,"",null,true],[0,0,0,"slice",null,"",null,false],[1,102,0,null,null," Initializes an ArrayListUnmanaged with the `items` and `capacity` fields\n of this ArrayList. Empties this ArrayList.",[36],false],[0,0,0,"self",null,"",null,false],[1,111,0,null,null," The caller owns the returned memory. Empties this ArrayList,\n Its capacity is cleared, making deinit() safe but unnecessary to call.",[38],false],[0,0,0,"self",null,"",null,false],[1,129,0,null,null," The caller owns the returned memory. Empties this ArrayList.",[40,41],false],[0,0,0,"self",null,"",null,false],[0,0,0,"sentinel",null,"",null,true],[1,137,0,null,null," Creates a copy of this ArrayList, using the same allocator.",[43],false],[0,0,0,"self",null,"",null,false],[1,147,0,null,null," Insert `item` at index `n`. Moves `list[n .. list.len]` to higher indices to make room.\n If `n` is equal to the length of the list this operation is equivalent to append.\n This operation is O(N).\n Invalidates pointers if additional memory is needed.",[45,46,47],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,156,0,null,null," Insert `item` at index `n`. Moves `list[n .. list.len]` to higher indices to make room.\n If `n` is equal to the length of the list this operation is equivalent to append.\n This operation is O(N).\n Asserts that there is enough capacity for the new item.",[49,50,51],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,167,0,null,null," Insert slice `items` at index `i` by moving `list[i .. list.len]` to make room.\n This operation is O(N).\n Invalidates pointers if additional memory is needed.",[53,54,55],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,179,0,null,null," Replace range of elements `list[start..][0..len]` with `new_items`.\n Grows list if `len < new_items.len`.\n Shrinks list if `len > new_items.len`.\n Invalidates pointers if this ArrayList is resized.",[57,58,59,60],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"new_items",null,"",null,false],[1,205,0,null,null," Extend the list by 1 element. Allocates more memory as necessary.\n Invalidates pointers if additional memory is needed.",[62,63],false],[0,0,0,"self",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,213,0,null,null," Extend the list by 1 element, but assert `self.capacity`\n is sufficient to hold an additional item. **Does not**\n invalidate pointers.",[65,66],false],[0,0,0,"self",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,224,0,null,null," Remove the element at index `i`, shift elements after index\n `i` forward, and return the removed element.\n Asserts the array has at least one item.\n Invalidates pointers to end of list.\n This operation is O(N).\n This preserves item order. Use `swapRemove` if order preservation is not important.",[68,69],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[1,239,0,null,null," Removes the element at the specified index and returns it.\n The empty slot is filled from the end of the list.\n This operation is O(1).\n This may not preserve item order. Use `orderedRemove` if you need to preserve order.",[71,72],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[1,250,0,null,null," Append the slice of items to the list. Allocates more\n memory as necessary.\n Invalidates pointers if additional memory is needed.",[74,75],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,257,0,null,null," Append the slice of items to the list, asserting the capacity is already\n enough to store the new items. **Does not** invalidate pointers.",[77,78],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,269,0,null,null," Append an unaligned slice of items to the list. Allocates more\n memory as necessary. Only call this function if calling\n `appendSlice` instead would be a compile error.\n Invalidates pointers if additional memory is needed.",[80,81],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,278,0,null,null," Append the slice of items to the list, asserting the capacity is already\n enough to store the new items. **Does not** invalidate pointers.\n Only call this function if calling `appendSliceAssumeCapacity` instead\n would be a compile error.",[83,84],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,286,0,null,null,null,null,false],[1,293,0,null,null," Initializes a Writer which will append to the list.",[87],false],[0,0,0,"self",null,"",null,false],[1,300,0,null,null," Same as `append` except it returns the number of bytes written, which is always the same\n as `m.len`. The purpose of this function existing is to match `std.io.Writer` API.\n Invalidates pointers if additional memory is needed.",[89,90],false],[0,0,0,"self",null,"",null,false],[0,0,0,"m",null,"",null,false],[1,310,0,null,null," Append a value to the list `n` times.\n Allocates more memory as necessary.\n Invalidates pointers if additional memory is needed.\n The function is inline so that a comptime-known `value` parameter will\n have a more optimal memset codegen in case it has a repeated byte pattern.",[92,93,94],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,320,0,null,null," Append a value to the list `n` times.\n Asserts the capacity is enough. **Does not** invalidate pointers.\n The function is inline so that a comptime-known `value` parameter will\n have a more optimal memset codegen in case it has a repeated byte pattern.",[96,97,98],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,330,0,null,null," Adjust the list's length to `new_len`.\n Does not initialize added items if any.\n Invalidates pointers if additional memory is needed.",[100,101],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[1,337,0,null,null," Reduce allocated capacity to `new_len`.\n May invalidate element pointers.",[103,104],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[1,345,0,null,null," Reduce length to `new_len`.\n Invalidates pointers for the elements `items[new_len..]`.",[106,107],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[1,351,0,null,null," Invalidates all element pointers.",[109],false],[0,0,0,"self",null,"",null,false],[1,356,0,null,null," Invalidates all element pointers.",[111],false],[0,0,0,"self",null,"",null,false],[1,364,0,null,null," Modify the array so that it can hold at least `new_capacity` items.\n Invalidates pointers if additional memory is needed.",[113,114],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[1,385,0,null,null," Modify the array so that it can hold `new_capacity` items.\n Like `ensureTotalCapacity`, but the resulting capacity is guaranteed\n to be equal to `new_capacity`.\n Invalidates pointers if additional memory is needed.",[116,117],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[1,412,0,null,null," Modify the array so that it can hold at least `additional_count` **more** items.\n Invalidates pointers if additional memory is needed.",[119,120],false],[0,0,0,"self",null,"",null,false],[0,0,0,"additional_count",null,"",null,false],[1,418,0,null,null," Increases the array's length to match the full capacity that is already allocated.\n The new elements have `undefined` values. **Does not** invalidate pointers.",[122],false],[0,0,0,"self",null,"",null,false],[1,424,0,null,null," Increase length by 1, returning pointer to the new item.\n The returned pointer becomes invalid when the list resized.",[124],false],[0,0,0,"self",null,"",null,false],[1,433,0,null,null," Increase length by 1, returning pointer to the new item.\n Asserts that there is already space for the new item without allocating more.\n The returned pointer becomes invalid when the list is resized.\n **Does not** invalidate element pointers.",[126],false],[0,0,0,"self",null,"",null,false],[1,443,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is an array pointing to the newly allocated elements.\n The returned pointer becomes invalid when the list is resized.\n Resizes list if `self.capacity` is not large enough.",[128,129],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,true],[1,454,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is an array pointing to the newly allocated elements.\n Asserts that there is already space for the new item without allocating more.\n **Does not** invalidate element pointers.\n The returned pointer becomes invalid when the list is resized.",[131,132],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,true],[1,465,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is a slice pointing to the newly allocated elements.\n The returned pointer becomes invalid when the list is resized.\n Resizes list if `self.capacity` is not large enough.",[134,135],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,476,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is a slice pointing to the newly allocated elements.\n Asserts that there is already space for the new item without allocating more.\n **Does not** invalidate element pointers.\n The returned pointer becomes invalid when the list is resized.",[137,138],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,486,0,null,null," Remove and return the last element from the list.\n Asserts the list has at least one item.\n Invalidates pointers to the removed element.",[140],false],[0,0,0,"self",null,"",null,false],[1,495,0,null,null," Remove and return the last element from the list, or\n return `null` if list is empty.\n Invalidates pointers to the removed element, if any.",[142],false],[0,0,0,"self",null,"",null,false],[1,502,0,null,null," Returns a slice of all the items plus the extra capacity, whose memory\n contents are `undefined`.",[144],false],[0,0,0,"self",null,"",null,false],[1,511,0,null,null," Returns a slice of only the extra capacity after items.\n This can be useful for writing directly into an ArrayList.\n Note that such an operation must be followed up with a direct\n modification of `self.items.len`.",[146],false],[0,0,0,"self",null,"",null,false],[1,517,0,null,null," Return the last element from the list.\n Asserts the list has at least one item.",[148],false],[0,0,0,"self",null,"",null,false],[1,524,0,null,null," Return the last element from the list, or\n return `null` if list is empty.",[150],false],[0,0,0,"self",null,"",null,false],[1,30,0,null,null,null,null,false],[0,0,0,"items",null," Contents of the list. Pointers to elements in this slice are\n **invalid after resizing operations** on the ArrayList unless the\n operation explicitly either: (1) states otherwise or (2) lists the\n invalidated pointers.\n\n The allocator used determines how element pointers are\n invalidated, so the behavior may vary between lists. To avoid\n illegal behavior, take into account the above paragraph plus the\n explicit statements given in each method.",null,false],[0,0,0,"capacity",null," How many T values this list can hold without allocating\n additional memory.",null,false],[1,30,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[1,535,0,null,null," An ArrayList, but the allocator is passed as a parameter to the relevant functions\n rather than stored in the struct itself. The same allocator **must** be used throughout\n the entire lifetime of an ArrayListUnmanaged. Initialize directly or with\n `initCapacity`, and deinitialize with `deinit` or use `toOwnedSlice`.",[157],false],[0,0,0,"T",null,"",null,true],[1,543,0,null,null," An ArrayListAligned, but the allocator is passed as a parameter to the relevant\n functions rather than stored  in the struct itself. The same allocator **must**\n be used throughout the entire lifetime of an ArrayListAlignedUnmanaged.\n Initialize directly or with `initCapacity`, and deinitialize with `deinit` or use `toOwnedSlice`.",[159,160],false],[0,0,0,"T",null,"",null,true],[0,0,0,"alignment",null,"",[319,320],true],[1,550,0,null,null,null,null,false],[1,565,0,null,null,null,null,false],[1,567,0,null,null,null,[164],false],[0,0,0,"s",null,"",null,true],[1,574,0,null,null," Initialize with capacity to hold `num` elements.\n The resulting capacity will equal `num` exactly.\n Deinitialize with `deinit` or use `toOwnedSlice`.",[166,167],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"num",null,"",null,false],[1,581,0,null,null," Release all allocated memory.",[169,170],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[1,588,0,null,null," Convert this list into an analogous memory-managed one.\n The returned list has ownership of the underlying memory.",[172,173],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[1,595,0,null,null," ArrayListUnmanaged takes ownership of the passed in slice. The slice must have been\n allocated with `allocator`.\n Deinitialize with `deinit` or use `toOwnedSlice`.",[175],false],[0,0,0,"slice",null,"",null,false],[1,605,0,null,null," ArrayListUnmanaged takes ownership of the passed in slice. The slice must have been\n allocated with `allocator`.\n Deinitialize with `deinit` or use `toOwnedSlice`.",[177,178],false],[0,0,0,"sentinel",null,"",null,true],[0,0,0,"slice",null,"",null,false],[1,614,0,null,null," The caller owns the returned memory. Empties this ArrayList.\n Its capacity is cleared, making deinit() safe but unnecessary to call.",[180,181],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[1,630,0,null,null," The caller owns the returned memory. ArrayList becomes empty.",[183,184,185],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"sentinel",null,"",null,true],[1,638,0,null,null," Creates a copy of this ArrayList.",[187,188],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[1,648,0,null,null," Insert `item` at index `n`. Moves `list[n .. list.len]` to higher indices to make room.\n If `n` is equal to the length of the list this operation is equivalent to append.\n This operation is O(N).\n Invalidates pointers if additional memory is needed.",[190,191,192,193],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"n",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,657,0,null,null," Insert `item` at index `n`. Moves `list[n .. list.len]` to higher indices to make room.\n If `n` is equal to the length of the list this operation is equivalent to append.\n This operation is O(N).\n Asserts that there is enough capacity for the new item.",[195,196,197],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,669,0,null,null," Insert slice `items` at index `i`. Moves `list[i .. list.len]` to\n higher indicices make room.\n This operation is O(N).\n Invalidates pointers if additional memory is needed.",[199,200,201,202],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"i",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,681,0,null,null," Replace range of elements `list[start..][0..len]` with `new_items`\n Grows list if `len < new_items.len`.\n Shrinks list if `len > new_items.len`\n Invalidates pointers if this ArrayList is resized.",[204,205,206,207,208],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"start",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"new_items",null,"",null,false],[1,689,0,null,null," Extend the list by 1 element. Allocates more memory as necessary.\n Invalidates pointers if additional memory is needed.",[210,211,212],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,696,0,null,null," Extend the list by 1 element, but asserting `self.capacity`\n is sufficient to hold an additional item.",[214,215],false],[0,0,0,"self",null,"",null,false],[0,0,0,"item",null,"",null,false],[1,705,0,null,null," Remove the element at index `i` from the list and return its value.\n Asserts the array has at least one item. Invalidates pointers to\n last element.\n This operation is O(N).",[217,218],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[1,720,0,null,null," Removes the element at the specified index and returns it.\n The empty slot is filled from the end of the list.\n Invalidates pointers to last element.\n This operation is O(1).",[220,221],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[1,731,0,null,null," Append the slice of items to the list. Allocates more\n memory as necessary.\n Invalidates pointers if additional memory is needed.",[223,224,225],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,738,0,null,null," Append the slice of items to the list, asserting the capacity is enough\n to store the new items.",[227,228],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,750,0,null,null," Append the slice of items to the list. Allocates more\n memory as necessary. Only call this function if a call to `appendSlice` instead would\n be a compile error.\n Invalidates pointers if additional memory is needed.",[230,231,232],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,758,0,null,null," Append an unaligned slice of items to the list, asserting the capacity is enough\n to store the new items. Only call this function if a call to `appendSliceAssumeCapacity`\n instead would be a compile error.",[234,235],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[1,766,0,null,null,null,[238,240],false],[1,766,0,null,null,null,null,false],[0,0,0,"self",null,null,null,false],[1,766,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[1,771,0,null,null,null,null,false],[1,778,0,null,null," Initializes a Writer which will append to the list.",[243,244],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[1,785,0,null,null," Same as `append` except it returns the number of bytes written, which is always the same\n as `m.len`. The purpose of this function existing is to match `std.io.Writer` API.\n Invalidates pointers if additional memory is needed.",[246,247],false],[0,0,0,"context",null,"",null,false],[0,0,0,"m",null,"",null,false],[1,795,0,null,null," Append a value to the list `n` times.\n Allocates more memory as necessary.\n Invalidates pointers if additional memory is needed.\n The function is inline so that a comptime-known `value` parameter will\n have a more optimal memset codegen in case it has a repeated byte pattern.",[249,250,251,252],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,806,0,null,null," Append a value to the list `n` times.\n **Does not** invalidate pointers.\n Asserts the capacity is enough.\n The function is inline so that a comptime-known `value` parameter will\n have a more optimal memset codegen in case it has a repeated byte pattern.",[254,255,256],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,816,0,null,null," Adjust the list's length to `new_len`.\n Does not initialize added items, if any.\n Invalidates pointers if additional memory is needed.",[258,259,260],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[1,823,0,null,null," Reduce allocated capacity to `new_len`.\n May invalidate element pointers.",[262,263,264],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[1,855,0,null,null," Reduce length to `new_len`.\n Invalidates pointers to elements `items[new_len..]`.\n Keeps capacity the same.",[266,267],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[1,861,0,null,null," Invalidates all element pointers.",[269],false],[0,0,0,"self",null,"",null,false],[1,866,0,null,null," Invalidates all element pointers.",[271,272],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[1,874,0,null,null," Modify the array so that it can hold at least `new_capacity` items.\n Invalidates pointers if additional memory is needed.",[274,275,276],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[1,890,0,null,null," Modify the array so that it can hold `new_capacity` items.\n Like `ensureTotalCapacity`, but the resulting capacity is guaranteed\n to be equal to `new_capacity`.\n Invalidates pointers if additional memory is needed.",[278,279,280],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[1,917,0,null,null," Modify the array so that it can hold at least `additional_count` **more** items.\n Invalidates pointers if additional memory is needed.",[282,283,284],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"additional_count",null,"",null,false],[1,928,0,null,null," Increases the array's length to match the full capacity that is already allocated.\n The new elements have `undefined` values.\n **Does not** invalidate pointers.",[286],false],[0,0,0,"self",null,"",null,false],[1,934,0,null,null," Increase length by 1, returning pointer to the new item.\n The returned pointer becomes invalid when the list resized.",[288,289],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[1,944,0,null,null," Increase length by 1, returning pointer to the new item.\n Asserts that there is already space for the new item without allocating more.\n **Does not** invalidate pointers.\n The returned pointer becomes invalid when the list resized.",[291],false],[0,0,0,"self",null,"",null,false],[1,954,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is an array pointing to the newly allocated elements.\n The returned pointer becomes invalid when the list is resized.",[293,294,295],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"n",null,"",null,true],[1,965,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is an array pointing to the newly allocated elements.\n Asserts that there is already space for the new item without allocating more.\n **Does not** invalidate pointers.\n The returned pointer becomes invalid when the list is resized.",[297,298],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,true],[1,976,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is a slice pointing to the newly allocated elements.\n The returned pointer becomes invalid when the list is resized.\n Resizes list if `self.capacity` is not large enough.",[300,301,302],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,987,0,null,null," Resize the array, adding `n` new elements, which have `undefined` values.\n The return value is a slice pointing to the newly allocated elements.\n Asserts that there is already space for the new item without allocating more.\n **Does not** invalidate element pointers.\n The returned pointer becomes invalid when the list is resized.",[304,305],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,false],[1,997,0,null,null," Remove and return the last element from the list.\n Asserts the list has at least one item.\n Invalidates pointers to last element.",[307],false],[0,0,0,"self",null,"",null,false],[1,1006,0,null,null," Remove and return the last element from the list.\n If the list is empty, returns `null`.\n Invalidates pointers to last element.",[309],false],[0,0,0,"self",null,"",null,false],[1,1013,0,null,null," Returns a slice of all the items plus the extra capacity, whose memory\n contents are `undefined`.",[311],false],[0,0,0,"self",null,"",null,false],[1,1021,0,null,null," Returns a slice of only the extra capacity after items.\n This can be useful for writing directly into an ArrayList.\n Note that such an operation must be followed up with a direct\n modification of `self.items.len`.",[313],false],[0,0,0,"self",null,"",null,false],[1,1027,0,null,null," Return the last element from the list.\n Asserts the list has at least one item.",[315],false],[0,0,0,"self",null,"",null,false],[1,1034,0,null,null," Return the last element from the list, or\n return `null` if list is empty.",[317],false],[0,0,0,"self",null,"",null,false],[1,549,0,null,null,null,null,false],[0,0,0,"items",null," Contents of the list. Pointers to elements in this slice are\n **invalid after resizing operations** on the ArrayList unless the\n operation explicitly either: (1) states otherwise or (2) lists the\n invalidated pointers.\n\n The allocator used determines how element pointers are\n invalidated, so the behavior may vary between lists. To avoid\n illegal behavior, take into account the above paragraph plus the\n explicit statements given in each method.",null,false],[0,0,0,"capacity",null," How many T values this list can hold without allocating\n additional memory.",null,false],[1,1508,0,null,null,null,[322,324],false],[0,0,0,"integer",null,null,null,false],[1,1508,0,null,null,null,null,false],[0,0,0,"sub_items",null,null,null,false],[1,1513,0,null,null,null,[326,328],false],[0,0,0,"integer",null,null,null,false],[1,1513,0,null,null,null,null,false],[0,0,0,"sub_items",null,null,null,false],[0,3,0,null,null,null,null,false],[0,4,0,null,null,null,null,false],[0,5,0,null,null,null,null,false],[0,6,0,null,null,null,null,false],[0,7,0,null,null,null,null,false],[0,8,0,null,null,null,null,false],[0,9,0,null,null,null,null,false],[0,10,0,null,null,null,null,false],[0,0,0,"BitStack.zig",null," Effectively a stack of u1 values implemented using ArrayList(u8).\n",[369,370],false],[2,2,0,null,null,null,null,false],[2,4,0,null,null,null,null,false],[2,5,0,null,null,null,null,false],[2,6,0,null,null,null,null,false],[2,11,0,null,null,null,[343],false],[0,0,0,"allocator",null,"",null,false],[2,17,0,null,null,null,[345],false],[0,0,0,"self",null,"",null,false],[2,22,0,null,null,null,[347,348],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit_capcity",null,"",null,false],[2,27,0,null,null,null,[350,351],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[2,36,0,null,null,null,[353],false],[0,0,0,"self",null,"",null,false],[2,40,0,null,null,null,[355],false],[0,0,0,"self",null,"",null,false],[2,45,0,null,null," Standalone function for working with a fixed-size buffer.",[357,358,359],false],[0,0,0,"buf",null,"",null,false],[0,0,0,"bit_len",null,"",null,false],[0,0,0,"b",null,"",null,false],[2,56,0,null,null," Standalone function for working with a fixed-size buffer.",[361,362],false],[0,0,0,"buf",null,"",null,false],[0,0,0,"bit_len",null,"",null,false],[2,63,0,null,null," Standalone function for working with a fixed-size buffer.",[364,365],false],[0,0,0,"buf",null,"",null,false],[0,0,0,"bit_len",null,"",null,false],[2,69,0,null,null,null,null,false],[2,70,0,"BitStack","test BitStack {\n    var stack = BitStack.init(testing.allocator);\n    defer stack.deinit();\n\n    try stack.push(1);\n    try stack.push(0);\n    try stack.push(0);\n    try stack.push(1);\n\n    try testing.expectEqual(@as(u1, 1), stack.peek());\n    try testing.expectEqual(@as(u1, 1), stack.pop());\n    try testing.expectEqual(@as(u1, 0), stack.peek());\n    try testing.expectEqual(@as(u1, 0), stack.pop());\n    try testing.expectEqual(@as(u1, 0), stack.pop());\n    try testing.expectEqual(@as(u1, 1), stack.pop());\n}",null,null,false],[2,0,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[0,0,0,"bit_len",null,null,null,false],[0,11,0,null,null,null,null,false],[0,0,0,"bounded_array.zig",null,"",[],false],[3,0,0,null,null,null,null,false],[3,1,0,null,null,null,null,false],[3,2,0,null,null,null,null,false],[3,3,0,null,null,null,null,false],[3,17,0,null,null," A structure with an array and a length, that can be used as a slice.\n\n Useful to pass around small arrays whose exact size is only known at\n runtime, but whose maximum size is known at comptime, without requiring\n an `Allocator`.\n\n ```zig\n var actual_size = 32;\n var a = try BoundedArray(u8, 64).init(actual_size);\n var slice = a.slice(); // a slice of the 64-byte array\n var a_clone = a; // creates a copy - the structure doesn't use any internal pointers\n ```",[378,379],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer_capacity",null,"",null,true],[3,34,0,null,null," A structure with an array, length and alignment, that can be used as a\n slice.\n\n Useful to pass around small explicitly-aligned arrays whose exact size is\n only known at runtime, but whose maximum size is known at comptime, without\n requiring an `Allocator`.\n ```zig\n ```",[381,382,383],false],[0,0,0,"T",null,"",null,true],[0,0,0,"alignment",null,"",null,true],[0,0,0,"buffer_capacity",null,"",[468,470],true],[3,40,0,null,null,null,null,false],[3,41,0,null,null,null,null,false],[3,48,0,null,null," Set the actual length of the slice.\n Returns error.Overflow if it exceeds the length of the backing array.",[387],false],[0,0,0,"len",null,"",null,false],[3,54,0,null,null," View the internal array as a slice whose size was previously set.",[389],false],[0,0,0,"self",null,"",null,false],[3,63,0,null,null," View the internal array as a constant slice whose size was previously set.",[391],false],[0,0,0,"self",null,"",null,false],[3,69,0,null,null," Adjust the slice's length to `len`.\n Does not initialize added items if any.",[393,394],false],[0,0,0,"self",null,"",null,false],[0,0,0,"len",null,"",null,false],[3,75,0,null,null," Copy the content of an existing slice.",[396],false],[0,0,0,"m",null,"",null,false],[3,82,0,null,null," Return the element at index `i` of the slice.",[398,399],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[3,87,0,null,null," Set the value of the element at index `i` of the slice.",[401,402,403],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[0,0,0,"item",null,"",null,false],[3,92,0,null,null," Return the maximum length of a slice.",[405],false],[0,0,0,"self",null,"",null,false],[3,97,0,null,null," Check that the slice can hold at least `additional_count` items.",[407,408],false],[0,0,0,"self",null,"",null,false],[0,0,0,"additional_count",null,"",null,false],[3,104,0,null,null," Increase length by 1, returning a pointer to the new item.",[410],false],[0,0,0,"self",null,"",null,false],[3,111,0,null,null," Increase length by 1, returning pointer to the new item.\n Asserts that there is space for the new item.",[412],false],[0,0,0,"self",null,"",null,false],[3,119,0,null,null," Resize the slice, adding `n` new elements, which have `undefined` values.\n The return value is a slice pointing to the uninitialized elements.",[414,415],false],[0,0,0,"self",null,"",null,false],[0,0,0,"n",null,"",null,true],[3,127,0,null,null," Remove and return the last element from the slice.\n Asserts the slice has at least one item.",[417],false],[0,0,0,"self",null,"",null,false],[3,135,0,null,null," Remove and return the last element from the slice, or\n return `null` if the slice is empty.",[419],false],[0,0,0,"self",null,"",null,false],[3,143,0,null,null," Return a slice of only the extra capacity after items.\n This can be useful for writing directly into it.\n Note that such an operation must be followed up with a\n call to `resize()`",[421],false],[0,0,0,"self",null,"",null,false],[3,149,0,null,null," Insert `item` at index `i` by moving `slice[n .. slice.len]` to make room.\n This operation is O(N).",[423,424,425],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[0,0,0,"item",null,"",null,false],[3,165,0,null,null," Insert slice `items` at index `i` by moving `slice[i .. slice.len]` to make room.\n This operation is O(N).",[427,428,429],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[0,0,0,"items",null,"",null,false],[3,175,0,null,null," Replace range of elements `slice[start..][0..len]` with `new_items`.\n Grows slice if `len < new_items.len`.\n Shrinks slice if `len > new_items.len`.",[431,432,433,434],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"new_items",null,"",null,false],[3,202,0,null,null," Extend the slice by 1 element.",[436,437],false],[0,0,0,"self",null,"",null,false],[0,0,0,"item",null,"",null,false],[3,209,0,null,null," Extend the slice by 1 element, asserting the capacity is already\n enough to store the new item.",[439,440],false],[0,0,0,"self",null,"",null,false],[0,0,0,"item",null,"",null,false],[3,218,0,null,null," Remove the element at index `i`, shift elements after index\n `i` forward, and return the removed element.\n Asserts the slice has at least one item.\n This operation is O(N).",[442,443],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[3,231,0,null,null," Remove the element at the specified index and return it.\n The empty slot is filled from the end of the slice.\n This operation is O(1).",[445,446],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[3,239,0,null,null," Append the slice of items to the slice.",[448,449],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[3,246,0,null,null," Append the slice of items to the slice, asserting the capacity is already\n enough to store the new items.",[451,452],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[3,254,0,null,null," Append a value to the slice `n` times.\n Allocates more memory as necessary.",[454,455,456],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"n",null,"",null,false],[3,262,0,null,null," Append a value to the slice `n` times.\n Asserts the capacity is enough.",[458,459,460],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"n",null,"",null,false],[3,269,0,null,null,null,null,false],[3,276,0,null,null," Initializes a writer which will write into the array.",[463],false],[0,0,0,"self",null,"",null,false],[3,282,0,null,null," Same as `appendSlice` except it returns the number of bytes written, which is always the same\n as `m.len`. The purpose of this function existing is to match `std.io.Writer` API.",[465,466],false],[0,0,0,"self",null,"",null,false],[0,0,0,"m",null,"",null,false],[3,39,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[3,39,0,null,null,null,null,false],[0,0,0,"len",null,null,null,false],[0,12,0,null,null,null,null,false],[0,13,0,null,null,null,null,false],[0,0,0,"Build.zig",null,"",[3198,3200,3202,3204,3206,3208,3209,3210,3211,3212,3214,3216,3217,3218,3220,3221,3223,3225,3227,3229,3231,3233,3235,3237,3239,3241,3243,3245,3247,3249,3251,3253,3255,3257,3259,3261,3263,3265,3267,3268,3269,3270,3271,3272,3273,3274,3276,3278,3280,3282,3284],false],[4,0,0,null,null,null,null,false],[4,1,0,null,null,null,null,false],[0,0,0,"(root)",null,"",[],false],[5,0,0,null,null,null,null,false],[5,3,0,null,null," Zig version. When writing code that supports multiple versions of Zig, prefer\n feature detection (i.e. with `@hasDecl` or `@hasField`) over version checks.",null,false],[5,4,0,null,null,null,null,false],[5,5,0,null,null,null,null,false],[5,7,0,null,null,null,null,false],[5,8,0,null,null,null,null,false],[5,9,0,null,null,null,null,false],[5,10,0,null,null,null,null,false],[5,11,0,null,null,null,null,false],[5,12,0,null,null,null,null,false],[5,32,0,null,null,null,null,false],[5,54,0,null,null,null,null,false],[5,60,0,null,null,null,null,false],[5,61,0,null,null,null,null,false],[5,62,0,null,null,null,null,false],[5,63,0,null,null,null,null,false],[5,64,0,null,null,null,null,false],[5,65,0,null,null,null,null,false],[5,66,0,null,null,null,null,false],[5,67,0,null,null,null,null,false],[5,68,0,null,null,null,null,false],[5,69,0,null,null,null,null,false],[5,70,0,null,null,null,null,false],[5,71,0,null,null,null,null,false],[5,72,0,null,null,null,null,false],[5,73,0,null,null,null,null,false],[4,2,0,null,null,null,null,false],[4,3,0,null,null,null,null,false],[4,4,0,null,null,null,null,false],[4,5,0,null,null,null,null,false],[4,6,0,null,null,null,null,false],[4,7,0,null,null,null,null,false],[4,8,0,null,null,null,null,false],[4,9,0,null,null,null,null,false],[4,10,0,null,null,null,null,false],[4,11,0,null,null,null,null,false],[4,12,0,null,null,null,null,false],[4,13,0,null,null,null,null,false],[4,14,0,null,null,null,null,false],[4,15,0,null,null,null,null,false],[4,16,0,null,null,null,null,false],[4,17,0,null,null,null,null,false],[4,18,0,null,null,null,null,false],[4,19,0,null,null,null,null,false],[4,21,0,null,null,null,null,false],[0,0,0,"Build/Cache.zig",null," Manages `zig-cache` directories.\n This is not a general-purpose cache. It is designed to be fast and simple,\n not to withstand attacks using specially-crafted input.\n",[808,810,812,813,815,817,818],false],[6,4,0,null,null,null,[541,543],false],[6,11,0,null,null,null,[525,526,527],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"paths",null,"",null,false],[6,22,0,null,null,null,[529,530,531],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"paths",null,"",null,false],[6,36,0,null,null," Whether or not the handle should be closed, or the path should be freed\n is determined by usage, however this function is provided for convenience\n if it happens to be what the caller needs.",[533,534],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[6,42,0,null,null,null,[536,537,538,539],false],[0,0,0,"self",null,"",null,false],[0,0,0,"fmt_string",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"writer",null,"",null,false],[6,4,0,null,null,null,null,false],[0,0,0,"path",null," This field is redundant for operations that can act on the open directory handle\n directly, but it is needed when passing the directory to a child process.\n `null` means cwd.",null,false],[6,4,0,null,null,null,null,false],[0,0,0,"handle",null,null,null,false],[6,72,0,null,null,null,null,false],[0,0,0,"Cache/DepTokenizer.zig",null,"",[638,640,642],false],[7,0,0,null,null,null,null,false],[7,6,0,null,null,null,null,false],[7,7,0,null,null,null,null,false],[7,8,0,null,null,null,null,false],[7,10,0,null,null,null,[551],false],[0,0,0,"self",null,"",null,false],[7,268,0,null,null,null,[553,554,555],false],[0,0,0,"id",null,"",null,true],[0,0,0,"index",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[7,272,0,null,null,null,[557,558,559],false],[0,0,0,"id",null,"",null,true],[0,0,0,"index",null,"",null,false],[0,0,0,"char",null,"",null,false],[7,276,0,null,null,null,[561,562],false],[0,0,0,"must_resolve",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[7,280,0,null,null,null,[564,565,566,567,568,569,570,571,572,573,574,575,576],false],[0,0,0,"lhs",null,null,null,false],[0,0,0,"target",null,null,null,false],[0,0,0,"target_reverse_solidus",null,null,null,false],[0,0,0,"target_dollar_sign",null,null,null,false],[0,0,0,"target_colon",null,null,null,false],[0,0,0,"target_colon_reverse_solidus",null,null,null,false],[0,0,0,"rhs",null,null,null,false],[0,0,0,"rhs_continuation",null,null,null,false],[0,0,0,"rhs_continuation_linefeed",null,null,null,false],[0,0,0,"prereq_quote",null,null,null,false],[0,0,0,"prereq",null,null,null,false],[0,0,0,"prereq_continuation",null,null,null,false],[0,0,0,"prereq_continuation_linefeed",null,null,null,false],[7,296,0,null,null,null,[593,594,595,596,597,598,599,600,601,602],false],[7,310,0,null,null,null,[579,580],false],[0,0,0,"index",null,null,null,false],[0,0,0,"char",null,null,null,false],[7,315,0,null,null,null,[582,584],false],[0,0,0,"index",null,null,null,false],[7,315,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[7,321,0,null,null," Resolve escapes in target. Only valid with .target_must_resolve.",[586,587],false],[0,0,0,"self",null,"",null,false],[0,0,0,"writer",null,"",null,false],[7,359,0,null,null,null,[589,590],false],[0,0,0,"self",null,"",null,false],[0,0,0,"writer",null,"",null,false],[7,387,0,null,null,null,[592],false],[0,0,0,"self",null,"",null,false],[0,0,0,"target",null,null,null,false],[0,0,0,"target_must_resolve",null,null,null,false],[0,0,0,"prereq",null,null,null,false],[0,0,0,"incomplete_quoted_prerequisite",null,null,null,false],[0,0,0,"incomplete_target",null,null,null,false],[0,0,0,"invalid_target",null,null,null,false],[0,0,0,"bad_target_escape",null,null,null,false],[0,0,0,"expected_dollar_sign",null,null,null,false],[0,0,0,"continuation_eol",null,null,null,false],[0,0,0,"incomplete_escape",null,null,null,false],[7,888,0,null,null,null,[604,605],false],[0,0,0,"input",null,"",null,false],[0,0,0,"expect",null,"",null,false],[7,942,0,null,null,null,[607,608,609],false],[0,0,0,"out",null,"",null,false],[0,0,0,"label",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[7,950,0,null,null,null,[611,612,613],false],[0,0,0,"out",null,"",null,false],[0,0,0,"label",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[7,962,0,null,null,null,[615],false],[0,0,0,"out",null,"",null,false],[7,971,0,null,null,null,[617,618],false],[0,0,0,"out",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[7,1018,0,null,null,null,[620,621,622],false],[0,0,0,"out",null,"",null,false],[0,0,0,"offset",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[7,1036,0,null,null,null,[624,625,626],false],[0,0,0,"out",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"width",null,"",null,false],[7,1042,0,null,null,null,[628,629,630],false],[0,0,0,"out",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"width",null,"",null,false],[7,1048,0,null,null,null,[632,633],false],[0,0,0,"out",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[7,1054,0,null,null,null,[635,636],false],[0,0,0,"out",null,"",null,false],[0,0,0,"char",null,"",null,false],[7,1063,0,null,null,null,null,false],[0,0,0,"index",null,null,null,false],[7,0,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[7,0,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[6,74,0,null,null,null,null,false],[6,75,0,null,null,null,null,false],[6,76,0,null,null,null,null,false],[6,77,0,null,null,null,null,false],[6,78,0,null,null,null,null,false],[6,79,0,null,null,null,null,false],[6,80,0,null,null,null,null,false],[6,81,0,null,null,null,null,false],[6,82,0,null,null,null,null,false],[6,83,0,null,null,null,null,false],[6,84,0,null,null,null,null,false],[6,86,0,null,null,null,[655,656],false],[0,0,0,"cache",null,"",null,false],[0,0,0,"directory",null,"",null,false],[6,92,0,null,null," Be sure to call `Manifest.deinit` after successful initialization.",[658],false],[0,0,0,"cache",null,"",null,false],[6,102,0,null,null,null,[660],false],[0,0,0,"cache",null,"",null,false],[6,106,0,null,null,null,[662,664],false],[0,0,0,"prefix",null,null,null,false],[6,106,0,null,null,null,null,false],[0,0,0,"sub_path",null,null,null,false],[6,111,0,null,null,null,[666,667],false],[0,0,0,"cache",null,"",null,false],[0,0,0,"file_path",null,"",null,false],[6,119,0,null,null," Takes ownership of `resolved_path` on success.",[669,670],false],[0,0,0,"cache",null,"",null,false],[0,0,0,"resolved_path",null,"",null,false],[6,143,0,null,null," This is 128 bits - Even with 2^54 cache entries, the probably of a collision would be under 10^-6",null,false],[6,144,0,null,null,null,null,false],[6,145,0,null,null,null,null,false],[6,148,0,null,null," This is currently just an arbitrary non-empty string that can't match another manifest line.",null,false],[6,149,0,null,null,null,null,false],[6,154,0,null,null," The type used for hashing file contents. Currently, this is SipHash128(1, 3), because it\n provides enough collision resistance for the Manifest use cases, while being one of our\n fastest options right now.",null,false],[6,159,0,null,null," Initial state with random bytes, that can be copied.\n Refresh this with new random bytes when the manifest\n format is modified in a non-backwards-compatible way.",null,false],[6,166,0,null,null,null,[688,690,692,694,696],false],[6,173,0,null,null,null,[681,682,683],false],[6,173,0,null,null,null,null,false],[0,0,0,"inode",null,null,null,false],[0,0,0,"size",null,null,null,false],[0,0,0,"mtime",null,null,null,false],[6,179,0,null,null,null,[685,686],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[6,166,0,null,null,null,null,false],[0,0,0,"prefixed_path",null,null,null,false],[6,166,0,null,null,null,null,false],[0,0,0,"max_file_size",null,null,null,false],[6,166,0,null,null,null,null,false],[0,0,0,"stat",null,null,null,false],[6,166,0,null,null,null,null,false],[0,0,0,"bin_digest",null,null,null,false],[6,166,0,null,null,null,null,false],[0,0,0,"contents",null,null,null,false],[6,192,0,null,null,null,[720],false],[6,196,0,null,null," Record a slice of bytes as a dependency of the process being cached.",[699,700],false],[0,0,0,"hh",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[6,201,0,null,null,null,[702,703],false],[0,0,0,"hh",null,"",null,false],[0,0,0,"optional_bytes",null,"",null,false],[6,206,0,null,null,null,[705,706],false],[0,0,0,"hh",null,"",null,false],[0,0,0,"list_of_bytes",null,"",null,false],[6,212,0,null,null," Convert the input value into bytes and record it as a dependency of the process being cached.",[708,709],false],[0,0,0,"hh",null,"",null,false],[0,0,0,"x",null,"",null,false],[6,248,0,null,null,null,[711,712],false],[0,0,0,"hh",null,"",null,false],[0,0,0,"optional",null,"",null,false],[6,254,0,null,null," Returns a hex encoded hash of the inputs, without modifying state.",[714],false],[0,0,0,"hh",null,"",null,false],[6,259,0,null,null,null,[716],false],[0,0,0,"hh",null,"",null,false],[6,267,0,null,null," Returns a hex encoded hash of the inputs, mutating the state of the hasher.",[718],false],[0,0,0,"hh",null,"",null,false],[6,192,0,null,null,null,null,false],[0,0,0,"hasher",null,null,null,false],[6,281,0,null,null,null,[725],false],[6,284,0,null,null,null,[723],false],[0,0,0,"lock",null,"",null,false],[6,281,0,null,null,null,null,false],[0,0,0,"manifest_file",null,null,null,false],[6,296,0,null,null,null,[778,780,782,783,784,785,786,788,790,792,793],false],[6,335,0,null,null," Add a file as a dependency of process being cached. When `hit` is\n called, the file's contents will be checked to ensure that it matches\n the contents from previous times.\n\n Max file size will be used to determine the amount of space the file contents\n are allowed to take up in memory. If max_file_size is null, then the contents\n will not be loaded into memory.\n\n Returns the index of the entry in the `files` array list. You can use it\n to access the contents of the file after calling `hit()` like so:\n\n ```\n var file_contents = cache_hash.files.items[file_index].contents.?;\n ```",[728,729,730],false],[0,0,0,"self",null,"",null,false],[0,0,0,"file_path",null,"",null,false],[0,0,0,"max_file_size",null,"",null,false],[6,357,0,null,null,null,[732,733],false],[0,0,0,"self",null,"",null,false],[0,0,0,"optional_file_path",null,"",null,false],[6,363,0,null,null,null,[735,736],false],[0,0,0,"self",null,"",null,false],[0,0,0,"list_of_files",null,"",null,false],[6,382,0,null,null," Check the cache to see if the input exists in it. If it exists, returns `true`.\n A hex encoding of its hash is available by calling `final`.\n\n This function will also acquire an exclusive lock to the manifest file. This means\n that a process holding a Manifest will block any other process attempting to\n acquire the lock. If `want_shared_lock` is `true`, a cache hit guarantees the\n manifest file to be locked in shared mode, and a cache miss guarantees the manifest\n file to be locked in exclusive mode.\n\n The lock on the manifest file is released when `deinit` is called. As another\n option, one may call `toOwnedLock` to obtain a smaller object which can represent\n the lock. `deinit` is safe to call whether or not `toOwnedLock` has been called.",[738],false],[0,0,0,"self",null,"",null,false],[6,581,0,null,null,null,[740,741,742],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bin_digest",null,"",null,false],[0,0,0,"input_file_count",null,"",null,false],[6,597,0,null,null,null,[744,745],false],[0,0,0,"man",null,"",null,false],[0,0,0,"file_time",null,"",null,false],[6,631,0,null,null,null,[747,748],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ch_file",null,"",null,false],[6,683,0,null,null," Add a file as a dependency of process being cached, after the initial hash has been\n calculated. This is useful for processes that don't know all the files that\n are depended on ahead of time. For example, a source file that can import other files\n will need to be recompiled if the imported file is changed.",[750,751,752],false],[0,0,0,"self",null,"",null,false],[0,0,0,"file_path",null,"",null,false],[0,0,0,"max_file_size",null,"",null,false],[6,709,0,null,null," Add a file as a dependency of process being cached, after the initial hash has been\n calculated. This is useful for processes that don't know the all the files that\n are depended on ahead of time. For example, a source file that can import other files\n will need to be recompiled if the imported file is changed.",[754,755],false],[0,0,0,"self",null,"",null,false],[0,0,0,"file_path",null,"",null,false],[6,731,0,null,null," Like `addFilePost` but when the file contents have already been loaded from disk.\n On success, cache takes ownership of `resolved_path`.",[757,758,759,760],false],[0,0,0,"self",null,"",null,false],[0,0,0,"resolved_path",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"stat",null,"",null,false],[6,769,0,null,null,null,[762,763,764],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dir",null,"",null,false],[0,0,0,"dep_file_basename",null,"",null,false],[6,805,0,null,null," Returns a hex encoded hash of the inputs.",[766],false],[0,0,0,"self",null,"",null,false],[6,829,0,null,null," If `want_shared_lock` is true, this function automatically downgrades the\n lock from exclusive to shared.",[768],false],[0,0,0,"self",null,"",null,false],[6,861,0,null,null,null,[770],false],[0,0,0,"self",null,"",null,false],[6,875,0,null,null,null,[772],false],[0,0,0,"self",null,"",null,false],[6,896,0,null,null," Obtain only the data needed to maintain a lock on the manifest file.\n The `Manifest` remains safe to deinit.\n Don't forget to call `writeManifest` before this!",[774],false],[0,0,0,"self",null,"",null,false],[6,908,0,null,null," Releases the manifest file and frees any memory the Manifest was using.\n `Manifest.hit` must be called first.\n Don't forget to call `writeManifest` before this!",[776],false],[0,0,0,"self",null,"",null,false],[6,296,0,null,null,null,null,false],[0,0,0,"cache",null,null,null,false],[6,296,0,null,null,null,null,false],[0,0,0,"hash",null," Current state for incremental hashing.",null,false],[6,296,0,null,null,null,null,false],[0,0,0,"manifest_file",null,null,null,false],[0,0,0,"manifest_dirty",null,null,null,false],[0,0,0,"want_shared_lock",null," Set this flag to true before calling hit() in order to indicate that\n upon a cache hit, the code using the cache will not modify the files\n within the cache directory. This allows multiple processes to utilize\n the same cache directory at the same time.",null,false],[0,0,0,"have_exclusive_lock",null,null,null,false],[0,0,0,"want_refresh_timestamp",null,null,null,false],[6,296,0,null,null,null,null,false],[0,0,0,"files",null,null,null,false],[6,296,0,null,null,null,null,false],[0,0,0,"hex_digest",null,null,null,false],[6,296,0,null,null,null,null,false],[0,0,0,"failed_file_index",null," Populated when hit() returns an error because of one\n of the files listed in the manifest.",null,false],[0,0,0,"recent_problematic_timestamp",null," Keeps track of the last time we performed a file system write to observe\n what time the file system thinks it is, according to its own granularity.",null,false],[6,927,0,null,null," On operating systems that support symlinks, does a readlink. On other operating systems,\n uses the file contents. Windows supports symlinks but only with elevated privileges, so\n it is treated as not supporting symlinks.",[795,796,797],false],[0,0,0,"dir",null,"",null,false],[0,0,0,"sub_path",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[6,939,0,null,null," On operating systems that support symlinks, does a symlink. On other operating systems,\n uses the file contents. Windows supports symlinks but only with elevated privileges, so\n it is treated as not supporting symlinks.\n `data` must be a valid UTF-8 encoded file path and 255 bytes or fewer.",[799,800,801],false],[0,0,0,"dir",null,"",null,false],[0,0,0,"sub_path",null,"",null,false],[0,0,0,"data",null,"",null,false],[6,948,0,null,null,null,[803,804],false],[0,0,0,"file",null,"",null,false],[0,0,0,"bin_digest",null,"",null,false],[6,962,0,null,null,null,[806],false],[0,0,0,"dir",null,"",null,false],[6,0,0,null,null,null,null,false],[0,0,0,"gpa",null,null,null,false],[6,0,0,null,null,null,null,false],[0,0,0,"manifest_dir",null,null,null,false],[6,0,0,null,null,null,null,false],[0,0,0,"hash",null,null,null,false],[0,0,0,"recent_problematic_timestamp",null," This value is accessed from multiple threads, protected by mutex.",null,false],[6,0,0,null,null,null,null,false],[0,0,0,"mutex",null,null,null,false],[6,0,0,null,null,null,null,false],[0,0,0,"prefixes_buffer",null," A set of strings such as the zig library directory or project source root, which\n are stripped from the file paths before putting into the cache. They\n are replaced with single-character indicators. This is not to save\n space but to eliminate absolute file paths. This improves portability\n and usefulness of the cache for advanced use cases.",null,false],[0,0,0,"prefixes_len",null,null,null,false],[4,24,0,null,null," deprecated: use `Step.Compile`.",null,false],[4,26,0,null,null," deprecated: use `Build`.",null,false],[4,28,0,null,null," deprecated: use `Step.InstallDir.Options`",null,false],[4,30,0,null,null,null,null,false],[0,0,0,"Build/Step.zig",null,"",[2619,2621,2623,2625,2627,2629,2631,2632,2634,2636,2637,2639,2640,2642,2644],false],[8,43,0,null,null,null,[829,830,831,832],false],[8,49,0,null,null,null,[826],false],[0,0,0,"tr",null,"",null,false],[8,53,0,null,null,null,[828],false],[0,0,0,"tr",null,"",null,false],[0,0,0,"fail_count",null,null,null,false],[0,0,0,"skip_count",null,null,null,false],[0,0,0,"leak_count",null,null,null,false],[0,0,0,"test_count",null,null,null,false],[8,58,0,null,null,null,[834,835],false],[0,0,0,"self",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[8,60,0,null,null,null,null,false],[8,62,0,null,null,null,[838,839,840,841,842,843,844,845],false],[0,0,0,"precheck_unstarted",null,null,null,false],[0,0,0,"precheck_started",null,null,null,false],[0,0,0,"precheck_done",null,null,null,false],[0,0,0,"running",null,null,null,false],[0,0,0,"dependency_failure",null,null,null,false],[0,0,0,"success",null,null,null,false],[0,0,0,"failure",null,null,null,false],[0,0,0,"skipped",null," This state indicates that the step did not complete, however, it also did not fail,\n and it is safe to continue executing its dependencies.",null,false],[8,75,0,null,null,null,[849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864],false],[8,93,0,null,null,null,[848],false],[0,0,0,"id",null,"",null,true],[0,0,0,"top_level",null,null,null,false],[0,0,0,"compile",null,null,null,false],[0,0,0,"install_artifact",null,null,null,false],[0,0,0,"install_file",null,null,null,false],[0,0,0,"install_dir",null,null,null,false],[0,0,0,"remove_dir",null,null,null,false],[0,0,0,"fmt",null,null,null,false],[0,0,0,"translate_c",null,null,null,false],[0,0,0,"write_file",null,null,null,false],[0,0,0,"run",null,null,null,false],[0,0,0,"check_file",null,null,null,false],[0,0,0,"check_object",null,null,null,false],[0,0,0,"config_header",null,null,null,false],[0,0,0,"objcopy",null,null,null,false],[0,0,0,"options",null,null,null,false],[0,0,0,"custom",null,null,null,false],[8,115,0,null,null,null,null,false],[0,0,0,"Step/CheckFile.zig",null," Fail the build step if a file does not match certain checks.\n TODO: make this more flexible, supporting more kinds of checks.\n TODO: generalize the code in std.testing.expectEqualStrings and make this\n CheckFile step produce those helpful diagnostics when there is not a match.\n",[889,891,893,895,896],false],[9,4,0,null,null,null,null,false],[9,5,0,null,null,null,null,false],[9,6,0,null,null,null,null,false],[9,7,0,null,null,null,null,false],[9,8,0,null,null,null,null,false],[9,16,0,null,null,null,null,false],[9,18,0,null,null,null,[875,877],false],[9,18,0,null,null,null,null,false],[0,0,0,"expected_matches",null,null,null,false],[9,18,0,null,null,null,null,false],[0,0,0,"expected_exact",null,null,null,false],[9,23,0,null,null,null,[879,880,881],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"options",null,"",null,false],[9,44,0,null,null,null,[883,884],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[9,48,0,null,null,null,[886,887],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[9,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[9,0,0,null,null,null,null,false],[0,0,0,"expected_matches",null,null,null,false],[9,0,0,null,null,null,null,false],[0,0,0,"expected_exact",null,null,null,false],[9,0,0,null,null,null,null,false],[0,0,0,"source",null,null,null,false],[0,0,0,"max_bytes",null,null,null,false],[8,116,0,null,null,null,null,false],[0,0,0,"Step/CheckObject.zig",null,"",[1195,1197,1198,1200,1202],false],[10,0,0,null,null,null,null,false],[10,1,0,null,null,null,null,false],[10,2,0,null,null,null,null,false],[10,3,0,null,null,null,null,false],[10,4,0,null,null,null,null,false],[10,5,0,null,null,null,null,false],[10,6,0,null,null,null,null,false],[10,7,0,null,null,null,null,false],[10,9,0,null,null,null,null,false],[10,11,0,null,null,null,null,false],[10,12,0,null,null,null,null,false],[10,14,0,null,null,null,null,false],[10,22,0,null,null,null,[912,913,914],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"obj_format",null,"",null,false],[10,44,0,null,null,null,[921,923],false],[10,48,0,null,null,null,[917,918,919],false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"step",null,"",null,false],[10,44,0,null,null,null,null,false],[0,0,0,"string",null,null,null,false],[10,44,0,null,null,null,null,false],[0,0,0,"file_source",null,null,null,false],[10,65,0,null,null," There five types of actions currently supported:\n .exact - will do an exact match against the haystack\n .contains - will check for existence within the haystack\n .not_present - will check for non-existence within the haystack\n .extract - will do an exact match and extract into a variable enclosed within `{name}` braces\n .compute_cmp - will perform an operation on the extracted global variables\n using the MatchAction. It currently only supports an addition. The operation is required\n to be specified in Reverse Polish Notation to ease in operator-precedence parsing (well,\n to avoid any parsing really).\n For example, if the two extracted values were saved as `vmaddr` and `entryoff` respectively\n they could then be added with this simple program `vmaddr entryoff +`.",[957,959,961],false],[10,71,0,null,null," Returns true if the `phrase` is an exact match with the haystack and variable was successfully extracted.",[926,927,928,929,930],false],[0,0,0,"act",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"step",null,"",null,false],[0,0,0,"haystack",null,"",null,false],[0,0,0,"global_vars",null,"",null,false],[10,112,0,null,null," Returns true if the `phrase` is an exact match with the haystack.",[932,933,934,935],false],[0,0,0,"act",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"step",null,"",null,false],[0,0,0,"haystack",null,"",null,false],[10,125,0,null,null," Returns true if the `phrase` exists within the haystack.",[937,938,939,940],false],[0,0,0,"act",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"step",null,"",null,false],[0,0,0,"haystack",null,"",null,false],[10,138,0,null,null," Returns true if the `phrase` does not exist within the haystack.",[942,943,944,945],false],[0,0,0,"act",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"step",null,"",null,false],[0,0,0,"haystack",null,"",null,false],[10,155,0,null,null," Will return true if the `phrase` is correctly parsed into an RPN program and\n its reduced, computed value compares using `op` with the expected value, either\n a literal or another extracted variable.",[947,948,949,950],false],[0,0,0,"act",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"step",null,"",null,false],[0,0,0,"global_vars",null,"",null,false],[10,65,0,null,null,null,[952,953,954,955,956],false],[0,0,0,"exact",null,null,null,false],[0,0,0,"contains",null,null,null,false],[0,0,0,"not_present",null,null,null,false],[0,0,0,"extract",null,null,null,false],[0,0,0,"compute_cmp",null,null,null,false],[0,0,0,"tag",null,null,null,false],[10,65,0,null,null,null,null,false],[0,0,0,"phrase",null,null,null,false],[10,65,0,null,null,null,null,false],[0,0,0,"expected",null,null,null,false],[10,224,0,null,null,null,[969,973],false],[10,231,0,null,null,null,[964,965,966,967],false],[0,0,0,"value",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,224,0,null,null,null,null,false],[0,0,0,"op",null,null,null,false],[10,224,0,null,null,null,[971,972],false],[0,0,0,"variable",null,null,null,false],[0,0,0,"literal",null,null,null,false],[0,0,0,"value",null,null,null,false],[10,247,0,null,null,null,[994],false],[10,250,0,null,null,null,[976],false],[0,0,0,"allocator",null,"",null,false],[10,256,0,null,null,null,[978,979],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,263,0,null,null,null,[981,982],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,270,0,null,null,null,[984,985],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,277,0,null,null,null,[987,988],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,284,0,null,null,null,[990,991,992],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"expected",null,"",null,false],[10,247,0,null,null,null,null,false],[0,0,0,"actions",null,null,null,false],[10,294,0,null,null," Creates a new empty sequence of actions.",[996],false],[0,0,0,"self",null,"",null,false],[10,300,0,null,null," Adds an exact match phrase to the latest created Check with `CheckObject.checkStart()`.",[998,999],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,306,0,null,null," Like `checkExact()` but takes an additional argument `LazyPath` which will be\n resolved to a full search query in `make()`.",[1001,1002,1003],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,310,0,null,null,null,[1005,1006,1007],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,317,0,null,null," Adds a fuzzy match phrase to the latest created Check with `CheckObject.checkStart()`.",[1009,1010],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,323,0,null,null," Like `checkContains()` but takes an additional argument `FileSource` which will be\n resolved to a full search query in `make()`.",[1012,1013,1014],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,327,0,null,null,null,[1016,1017,1018],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,335,0,null,null," Adds an exact match phrase with variable extractor to the latest created Check\n with `CheckObject.checkStart()`.",[1020,1021],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,341,0,null,null," Like `checkExtract()` but takes an additional argument `FileSource` which will be\n resolved to a full search query in `make()`.",[1023,1024,1025],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,345,0,null,null,null,[1027,1028,1029],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,353,0,null,null," Adds another searched phrase to the latest created Check with `CheckObject.checkStart(...)`\n however ensures there is no matching phrase in the output.",[1031,1032],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[10,359,0,null,null," Like `checkExtract()` but takes an additional argument `FileSource` which will be\n resolved to a full search query in `make()`.",[1034,1035,1036],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,363,0,null,null,null,[1038,1039,1040],false],[0,0,0,"self",null,"",null,false],[0,0,0,"phrase",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[10,371,0,null,null," Creates a new check checking specifically symbol table parsed and dumped from the object\n file.",[1042],false],[0,0,0,"self",null,"",null,false],[10,386,0,null,null," Creates a new check checking specifically dynamic symbol table parsed and dumped from the object\n file.\n This check is target-dependent and applicable to ELF only.",[1044],false],[0,0,0,"self",null,"",null,false],[10,398,0,null,null," Creates a new check checking specifically dynamic section parsed and dumped from the object\n file.\n This check is target-dependent and applicable to ELF only.",[1046],false],[0,0,0,"self",null,"",null,false],[10,410,0,null,null," Creates a new standalone, singular check which allows running simple binary operations\n on the extracted variables. It will then compare the reduced program with the value of\n the expected variable.",[1048,1049,1050],false],[0,0,0,"self",null,"",null,false],[0,0,0,"program",null,"",null,false],[0,0,0,"expected",null,"",null,false],[10,420,0,null,null,null,[1052,1053],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[10,532,0,null,null,null,[],false],[10,533,0,null,null,null,null,false],[10,534,0,null,null,null,null,false],[10,536,0,null,null,null,[1059,1061],false],[10,536,0,null,null,null,null,false],[0,0,0,"symbols",null,null,null,false],[10,536,0,null,null,null,null,false],[0,0,0,"strings",null,null,null,false],[10,541,0,null,null,null,[1063,1064],false],[0,0,0,"step",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[10,600,0,null,null,null,[1066,1067,1068],false],[0,0,0,"lc",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,772,0,null,null,null,[1070,1071,1072,1073],false],[0,0,0,"sections",null,"",null,false],[0,0,0,"imports",null,"",null,false],[0,0,0,"symtab",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,828,0,null,null,null,[],false],[10,829,0,null,null,null,null,false],[10,830,0,null,null,null,null,false],[10,831,0,null,null,null,null,false],[10,833,0,null,null,null,[1086,1088],false],[10,837,0,null,null,null,[1080,1081],false],[0,0,0,"st",null,"",null,false],[0,0,0,"index",null,"",null,false],[10,842,0,null,null,null,[1083,1084],false],[0,0,0,"st",null,"",null,false],[0,0,0,"index",null,"",null,false],[10,833,0,null,null,null,null,false],[0,0,0,"symbols",null,null,null,false],[10,833,0,null,null,null,null,false],[0,0,0,"strings",null,null,null,false],[10,848,0,null,null,null,[1091,1093,1095,1097,1099,1101,1103,1105],false],[10,848,0,null,null,null,null,false],[0,0,0,"gpa",null,null,null,false],[10,848,0,null,null,null,null,false],[0,0,0,"data",null,null,null,false],[10,848,0,null,null,null,null,false],[0,0,0,"hdr",null,null,null,false],[10,848,0,null,null,null,null,false],[0,0,0,"shdrs",null,null,null,false],[10,848,0,null,null,null,null,false],[0,0,0,"phdrs",null,null,null,false],[10,848,0,null,null,null,null,false],[0,0,0,"shstrtab",null,null,null,false],[10,848,0,null,null,null,null,false],[0,0,0,"symtab",null,null,null,false],[10,848,0,null,null,null,null,false],[0,0,0,"dysymtab",null,null,null,false],[10,859,0,null,null,null,[1107,1108],false],[0,0,0,"step",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[10,922,0,null,null,null,[1110,1111],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"shndx",null,"",null,false],[10,927,0,null,null,null,[1113,1114],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"shndx",null,"",null,false],[10,934,0,null,null,null,[1116,1117],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"name",null,"",null,false],[10,940,0,null,null,null,[1119,1120],false],[0,0,0,"strtab",null,"",null,false],[0,0,0,"off",null,"",null,false],[10,945,0,null,null,null,[1122,1123],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,951,0,null,null,null,[1125,1126],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,968,0,null,null,null,[1128,1129],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1107,0,null,null,null,[1131],false],[0,0,0,"sh_type",null,"",null,false],[10,1111,0,null,null,null,[1133,1134,1135,1136],false],[0,0,0,"sh_type",null,"",null,false],[0,0,0,"unused_fmt_string",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1154,0,null,null,null,[1138,1139],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1193,0,null,null,null,[1141],false],[0,0,0,"ph_type",null,"",null,false],[10,1197,0,null,null,null,[1143,1144,1145,1146],false],[0,0,0,"ph_type",null,"",null,false],[0,0,0,"unused_fmt_string",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1227,0,null,null,null,[1148,1149,1152],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"type",null,"",[1150,1151],true],[0,0,0,"symtab",null,null,null,false],[0,0,0,"dysymtab",null,null,null,false],[0,0,0,"writer",null,"",null,false],[10,1310,0,null,null,null,[],false],[10,1311,0,null,null,null,null,false],[10,1313,0,null,null,null,[1156,1157],false],[0,0,0,"step",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[10,1343,0,null,null,null,[1159,1160,1161,1162],false],[0,0,0,"step",null,"",null,false],[0,0,0,"section",null,"",null,false],[0,0,0,"data",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1400,0,null,null,null,[1164,1165,1166,1167,1168],false],[0,0,0,"step",null,"",null,false],[0,0,0,"section",null,"",null,false],[0,0,0,"data",null,"",null,false],[0,0,0,"entries",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1546,0,null,null,null,[1170,1171,1172,1173],false],[0,0,0,"step",null,"",null,false],[0,0,0,"WasmType",null,"",null,true],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1554,0,null,null,null,[1175,1176],false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1564,0,null,null,null,[1178,1179,1180],false],[0,0,0,"step",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[10,1583,0,null,null,null,[1182,1183,1184,1185],false],[0,0,0,"step",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"data",null,"",null,false],[10,1610,0,null,null,null,[1187,1188,1189],false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"data",null,"",null,false],[10,1644,0,null,null,null,[1191,1192,1193],false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"data",null,"",null,false],[10,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[10,0,0,null,null,null,null,false],[0,0,0,"source",null,null,null,false],[0,0,0,"max_bytes",null,null,null,false],[10,0,0,null,null,null,null,false],[0,0,0,"checks",null,null,null,false],[10,0,0,null,null,null,null,false],[0,0,0,"obj_format",null,null,null,false],[8,117,0,null,null,null,null,false],[0,0,0,"Step/ConfigHeader.zig",null,"",[1287,1289,1291,1293,1294,1296],false],[11,0,0,null,null,null,null,false],[11,1,0,null,null,null,null,false],[11,2,0,null,null,null,null,false],[11,3,0,null,null,null,null,false],[11,5,0,null,null,null,[1213,1214,1215,1216],false],[11,18,0,null,null," deprecated: use `getPath`",null,false],[11,20,0,null,null,null,[1212],false],[0,0,0,"style",null,"",null,false],[0,0,0,"autoconf",null," The configure format supported by autotools. It uses `#undef foo` to\n mark lines that can be substituted with different values.",null,false],[0,0,0,"cmake",null," The configure format supported by CMake. It uses `@@FOO@@` and\n `#cmakedefine` for template substitution.",null,false],[0,0,0,"blank",null," Instead of starting with an input file, start with nothing.",null,false],[0,0,0,"nasm",null," Start with nothing, like blank, and output a nasm .asm file.",null,false],[11,28,0,null,null,null,[1218,1219,1220,1221,1222,1223],false],[0,0,0,"undef",null,null,null,false],[0,0,0,"defined",null,null,null,false],[0,0,0,"boolean",null,null,null,false],[0,0,0,"int",null,null,null,false],[0,0,0,"ident",null,null,null,false],[0,0,0,"string",null,null,null,false],[11,45,0,null,null,null,null,false],[11,47,0,null,null,null,[1227,1228,1230,1232],false],[11,47,0,null,null,null,null,false],[0,0,0,"style",null,null,null,false],[0,0,0,"max_bytes",null,null,null,false],[11,47,0,null,null,null,null,false],[0,0,0,"include_path",null,null,null,false],[11,47,0,null,null,null,null,false],[0,0,0,"first_ret_addr",null,null,null,false],[11,54,0,null,null,null,[1234,1235],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"options",null,"",null,false],[11,99,0,null,null,null,[1237,1238],false],[0,0,0,"self",null,"",null,false],[0,0,0,"values",null,"",null,false],[11,104,0,null,null," deprecated: use `getOutput`",null,false],[11,106,0,null,null,null,[1241],false],[0,0,0,"self",null,"",null,false],[11,110,0,null,null,null,[1243,1244],false],[0,0,0,"self",null,"",null,false],[0,0,0,"values",null,"",null,false],[11,116,0,null,null,null,[1246,1247,1248,1249],false],[0,0,0,"self",null,"",null,false],[0,0,0,"field_name",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"v",null,"",null,false],[11,166,0,null,null,null,[1251,1252],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[11,247,0,null,null,null,[1254,1255,1256,1257,1258],false],[0,0,0,"step",null,"",null,false],[0,0,0,"contents",null,"",null,false],[0,0,0,"output",null,"",null,false],[0,0,0,"values",null,"",null,false],[0,0,0,"src_path",null,"",null,false],[11,294,0,null,null,null,[1260,1261,1262,1263,1264],false],[0,0,0,"step",null,"",null,false],[0,0,0,"contents",null,"",null,false],[0,0,0,"output",null,"",null,false],[0,0,0,"values",null,"",null,false],[0,0,0,"src_path",null,"",null,false],[11,414,0,null,null,null,[1266,1267,1268],false],[0,0,0,"output",null,"",null,false],[0,0,0,"defines",null,"",null,false],[0,0,0,"include_path",null,"",null,false],[11,444,0,null,null,null,[1270,1271],false],[0,0,0,"output",null,"",null,false],[0,0,0,"defines",null,"",null,false],[11,451,0,null,null,null,[1273,1274,1275],false],[0,0,0,"output",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"value",null,"",null,false],[11,481,0,null,null,null,[1277,1278,1279],false],[0,0,0,"output",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"value",null,"",null,false],[11,511,0,null,null,null,[1281,1282,1283,1284,1285],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"contents",null,"",null,false],[0,0,0,"values",null,"",null,false],[0,0,0,"prefix",null,"",null,false],[0,0,0,"suffix",null,"",null,false],[11,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[11,0,0,null,null,null,null,false],[0,0,0,"values",null,null,null,false],[11,0,0,null,null,null,null,false],[0,0,0,"output_file",null,null,null,false],[11,0,0,null,null,null,null,false],[0,0,0,"style",null,null,null,false],[0,0,0,"max_bytes",null,null,null,false],[11,0,0,null,null,null,null,false],[0,0,0,"include_path",null,null,null,false],[8,118,0,null,null,null,null,false],[0,0,0,"Step/Fmt.zig",null," This step has two modes:\n * Modify mode: directly modify source files, formatting them in place.\n * Check mode: fail the step if a non-conforming file is found.\n",[1316,1318,1320,1321],false],[12,3,0,null,null,null,null,false],[12,4,0,null,null,null,null,false],[12,5,0,null,null,null,null,false],[12,12,0,null,null,null,null,false],[12,14,0,null,null,null,[1305,1307,1308],false],[12,14,0,null,null,null,null,false],[0,0,0,"paths",null,null,null,false],[12,14,0,null,null,null,null,false],[0,0,0,"exclude_paths",null,null,null,false],[0,0,0,"check",null," If true, fails the build step when any non-conforming files are encountered.",null,false],[12,21,0,null,null,null,[1310,1311],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"options",null,"",null,false],[12,38,0,null,null,null,[1313,1314],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[12,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[12,0,0,null,null,null,null,false],[0,0,0,"paths",null,null,null,false],[12,0,0,null,null,null,null,false],[0,0,0,"exclude_paths",null,null,null,false],[0,0,0,"check",null,null,null,false],[8,119,0,null,null,null,null,false],[0,0,0,"Step/InstallArtifact.zig",null,"",[1361,1363,1365,1367,1369,1371,1373,1375,1377,1379,1381,1383],false],[13,0,0,null,null,null,null,false],[13,1,0,null,null,null,null,false],[13,2,0,null,null,null,null,false],[13,3,0,null,null,null,null,false],[13,4,0,null,null,null,null,false],[13,5,0,null,null,null,null,false],[13,26,0,null,null,null,[1332,1334],false],[13,26,0,null,null,null,null,false],[0,0,0,"major_only_filename",null,null,null,false],[13,26,0,null,null,null,null,false],[0,0,0,"name_only_filename",null,null,null,false],[13,31,0,null,null,null,null,false],[13,33,0,null,null,null,[1342,1344,1346,1348,1350,1352],false],[13,46,0,null,null,null,[1338,1339,1340],false],[0,0,0,"disabled",null,null,null,false],[0,0,0,"default",null,null,null,false],[0,0,0,"override",null,null,null,false],[13,33,0,null,null,null,null,false],[0,0,0,"dest_dir",null," Which installation directory to put the main output file into.",null,false],[13,33,0,null,null,null,null,false],[0,0,0,"pdb_dir",null,null,null,false],[13,33,0,null,null,null,null,false],[0,0,0,"h_dir",null,null,null,false],[13,33,0,null,null,null,null,false],[0,0,0,"implib_dir",null,null,null,false],[13,33,0,null,null,null,null,false],[0,0,0,"dylib_symlinks",null," Whether to install symlinks along with dynamic libraries.",null,false],[13,33,0,null,null,null,null,false],[0,0,0,"dest_sub_path",null," If non-null, adds additional path components relative to bin dir, and\n overrides the basename of the Compile step for installation purposes.",null,false],[13,53,0,null,null,null,[1354,1355,1356],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"artifact",null,"",null,false],[0,0,0,"options",null,"",null,false],[13,121,0,null,null,null,[1358,1359],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[13,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"dest_dir",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"dest_sub_path",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"emitted_bin",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"implib_dir",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"emitted_implib",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"pdb_dir",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"emitted_pdb",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"h_dir",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"emitted_h",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"dylib_symlinks",null,null,null,false],[13,0,0,null,null,null,null,false],[0,0,0,"artifact",null,null,null,false],[8,120,0,null,null,null,null,false],[0,0,0,"Step/InstallDir.zig",null,"",[1415,1417,1419],false],[14,0,0,null,null,null,null,false],[14,1,0,null,null,null,null,false],[14,2,0,null,null,null,null,false],[14,3,0,null,null,null,null,false],[14,4,0,null,null,null,null,false],[14,5,0,null,null,null,null,false],[14,6,0,null,null,null,null,false],[14,14,0,null,null,null,null,false],[14,16,0,null,null,null,[1399,1401,1403,1405,1407],false],[14,30,0,null,null,null,[1396,1397],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[14,16,0,null,null,null,null,false],[0,0,0,"source_dir",null,null,null,false],[14,16,0,null,null,null,null,false],[0,0,0,"install_dir",null,null,null,false],[14,16,0,null,null,null,null,false],[0,0,0,"install_subdir",null,null,null,false],[14,16,0,null,null,null,null,false],[0,0,0,"exclude_extensions",null," File paths which end in any of these suffixes will be excluded\n from being installed.",null,false],[14,16,0,null,null,null,null,false],[0,0,0,"blank_extensions",null," File paths which end in any of these suffixes will result in\n empty files being installed. This is mainly intended for large\n test.zig files in order to prevent needless installation bloat.\n However if the files were not present at all, then\n `@import(\"test.zig\")` would be a compile error.",null,false],[14,41,0,null,null,null,[1409,1410],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"options",null,"",null,false],[14,58,0,null,null,null,[1412,1413],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[14,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[14,0,0,null,null,null,null,false],[0,0,0,"options",null,null,null,false],[14,0,0,null,null,null,null,false],[0,0,0,"dest_builder",null," This is used by the build system when a file being installed comes from one\n package but is being installed by another.",null,false],[8,121,0,null,null,null,null,false],[0,0,0,"Step/InstallFile.zig",null,"",[1438,1440,1442,1444,1446],false],[15,0,0,null,null,null,null,false],[15,1,0,null,null,null,null,false],[15,2,0,null,null,null,null,false],[15,3,0,null,null,null,null,false],[15,4,0,null,null,null,null,false],[15,5,0,null,null,null,null,false],[15,7,0,null,null,null,null,false],[15,17,0,null,null,null,[1430,1431,1432,1433],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"dir",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[15,42,0,null,null,null,[1435,1436],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[15,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[15,0,0,null,null,null,null,false],[0,0,0,"source",null,null,null,false],[15,0,0,null,null,null,null,false],[0,0,0,"dir",null,null,null,false],[15,0,0,null,null,null,null,false],[0,0,0,"dest_rel_path",null,null,null,false],[15,0,0,null,null,null,null,false],[0,0,0,"dest_builder",null," This is used by the build system when a file being installed comes from one\n package but is being installed by another.",null,false],[8,122,0,null,null,null,null,false],[0,0,0,"Step/ObjCopy.zig",null,"",[1485,1487,1489,1491,1493,1495,1497],false],[16,0,0,null,null,null,null,false],[16,1,0,null,null,null,null,false],[16,3,0,null,null,null,null,false],[16,4,0,null,null,null,null,false],[16,5,0,null,null,null,null,false],[16,6,0,null,null,null,null,false],[16,7,0,null,null,null,null,false],[16,8,0,null,null,null,null,false],[16,9,0,null,null,null,null,false],[16,10,0,null,null,null,null,false],[16,11,0,null,null,null,null,false],[16,12,0,null,null,null,null,false],[16,14,0,null,null,null,null,false],[16,16,0,null,null,null,[1463,1464],false],[0,0,0,"bin",null,null,null,false],[0,0,0,"hex",null,null,null,false],[16,30,0,null,null,null,[1467,1469,1471,1473],false],[16,30,0,null,null,null,null,false],[0,0,0,"basename",null,null,null,false],[16,30,0,null,null,null,null,false],[0,0,0,"format",null,null,null,false],[16,30,0,null,null,null,null,false],[0,0,0,"only_section",null,null,null,false],[16,30,0,null,null,null,null,false],[0,0,0,"pad_to",null,null,null,false],[16,37,0,null,null,null,[1475,1476,1477],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"input_file",null,"",null,false],[0,0,0,"options",null,"",null,false],[16,63,0,null,null," deprecated: use getOutput",null,false],[16,65,0,null,null,null,[1480],false],[0,0,0,"self",null,"",null,false],[16,69,0,null,null,null,[1482,1483],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[16,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[16,0,0,null,null,null,null,false],[0,0,0,"input_file",null,null,null,false],[16,0,0,null,null,null,null,false],[0,0,0,"basename",null,null,null,false],[16,0,0,null,null,null,null,false],[0,0,0,"output_file",null,null,null,false],[16,0,0,null,null,null,null,false],[0,0,0,"format",null,null,null,false],[16,0,0,null,null,null,null,false],[0,0,0,"only_section",null,null,null,false],[16,0,0,null,null,null,null,false],[0,0,0,"pad_to",null,null,null,false],[8,123,0,null,null,null,null,false],[0,0,0,"Step/Compile.zig",null,"",[1894,1896,1898,1900,1902,1904,1906,1908,1910,1912,1914,1916,1918,1920,1922,1926,1928,1930,1932,1934,1935,1936,1938,1940,1942,1943,1944,1945,1946,1948,1949,1950,1951,1952,1953,1955,1957,1958,1960,1962,1964,1966,1968,1970,1971,1973,1975,1977,1979,1981,1983,1985,1987,1989,1991,1993,1994,1995,1997,1999,2001,2003,2005,2007,2009,2010,2011,2012,2014,2015,2017,2018,2019,2020,2022,2024,2026,2028,2030,2032,2033,2034,2036,2038,2040,2042,2044,2046,2048,2050,2052,2054,2056,2058,2060,2062,2064,2066,2068,2070,2072,2074,2076,2078],false],[17,0,0,null,null,null,null,false],[17,1,0,null,null,null,null,false],[17,2,0,null,null,null,null,false],[17,3,0,null,null,null,null,false],[17,4,0,null,null,null,null,false],[17,5,0,null,null,null,null,false],[17,6,0,null,null,null,null,false],[17,7,0,null,null,null,null,false],[17,8,0,null,null,null,null,false],[17,9,0,null,null,null,null,false],[17,10,0,null,null,null,null,false],[17,11,0,null,null,null,null,false],[17,12,0,null,null,null,null,false],[17,13,0,null,null,null,null,false],[17,14,0,null,null,null,null,false],[17,15,0,null,null,null,null,false],[17,16,0,null,null,null,null,false],[17,17,0,null,null,null,null,false],[17,18,0,null,null,null,null,false],[17,19,0,null,null,null,null,false],[17,20,0,null,null,null,null,false],[17,21,0,null,null,null,null,false],[17,23,0,null,null,null,null,false],[17,206,0,null,null,null,[1525,1527],false],[17,206,0,null,null,null,null,false],[0,0,0,"files",null," Relative to the build root.",null,false],[17,206,0,null,null,null,null,false],[0,0,0,"flags",null,null,null,false],[17,212,0,null,null,null,[1533,1535],false],[17,216,0,null,null,null,[1530,1531],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[17,212,0,null,null,null,null,false],[0,0,0,"file",null,null,null,false],[17,212,0,null,null,null,null,false],[0,0,0,"flags",null,null,null,false],[17,224,0,null,null,null,[1537,1538,1539,1540,1541,1542],false],[0,0,0,"static_path",null,null,null,false],[0,0,0,"other_step",null,null,null,false],[0,0,0,"system_lib",null,null,null,false],[0,0,0,"assembly_file",null,null,null,false],[0,0,0,"c_source_file",null,null,null,false],[0,0,0,"c_source_files",null,null,null,false],[17,233,0,null,null,null,[1553,1554,1555,1557,1559,1561],false],[17,241,0,null,null,null,[1545,1546,1547],false],[0,0,0,"no",null," Don't use pkg-config, just pass -lfoo where foo is name.",null,false],[0,0,0,"yes",null," Try to get information on how to link the library from pkg-config.\n If that fails, fall back to passing -lfoo where foo is name.",null,false],[0,0,0,"force",null," Try to get information on how to link the library from pkg-config.\n If that fails, error out.",null,false],[17,252,0,null,null,null,[1549,1550,1551],false],[0,0,0,"paths_first",null,null,null,false],[0,0,0,"mode_first",null,null,null,false],[0,0,0,"no_fallback",null,null,null,false],[17,233,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"needed",null,null,null,false],[0,0,0,"weak",null,null,null,false],[17,233,0,null,null,null,null,false],[0,0,0,"use_pkg_config",null,null,null,false],[17,233,0,null,null,null,null,false],[0,0,0,"preferred_link_mode",null,null,null,false],[17,233,0,null,null,null,null,false],[0,0,0,"search_strategy",null,null,null,false],[17,255,0,null,null,null,[1563,1564],false],[0,0,0,"needed",null,null,null,false],[0,0,0,"weak",null,null,null,false],[17,260,0,null,null,null,[1566,1567,1568,1569],false],[0,0,0,"path",null,null,null,false],[0,0,0,"path_system",null,null,null,false],[0,0,0,"other_step",null,null,null,false],[0,0,0,"config_header_step",null,null,null,false],[17,267,0,null,null,null,[1572,1574,1576,1578,1580,1582,1584,1585,1587,1589,1591,1593,1595,1597,1599,1601],false],[17,267,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"root_source_file",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"kind",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"linkage",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"version",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"filter",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"test_runner",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"link_libc",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"single_threaded",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"use_llvm",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"use_lld",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[17,267,0,null,null,null,null,false],[0,0,0,"main_pkg_path",null,null,null,false],[17,286,0,null,null,null,[1617,1618,1619,1620,1621,1622],false],[17,294,0,null,null,null,[1604,1605],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[17,304,0,null,null,null,[1610,1611],false],[17,309,0,null,null," Result is byte values, *not* hex-encoded.",[1608],false],[0,0,0,"hs",null,"",null,false],[17,304,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[0,0,0,"len",null,null,null,false],[17,316,0,null,null," Input is byte values, *not* hex-encoded.\n Asserts `bytes` fits inside `HexString`",[1613],false],[0,0,0,"bytes",null,"",null,false],[17,326,0,null,null," Converts UTF-8 text to a `BuildId`.",[1615],false],[0,0,0,"text",null,"",null,false],[17,346,0,"parse","test parse {\n        try std.testing.expectEqual(BuildId.md5, try parse(\"md5\"));\n        try std.testing.expectEqual(BuildId.none, try parse(\"none\"));\n        try std.testing.expectEqual(BuildId.fast, try parse(\"fast\"));\n        try std.testing.expectEqual(BuildId.uuid, try parse(\"uuid\"));\n        try std.testing.expectEqual(BuildId.sha1, try parse(\"sha1\"));\n        try std.testing.expectEqual(BuildId.sha1, try parse(\"tree\"));\n\n        try std.testing.expect(BuildId.initHexString(\"\").eql(try parse(\"0x\")));\n        try std.testing.expect(BuildId.initHexString(\"\\x12\\x34\\x56\").eql(try parse(\"0x123456\")));\n        try std.testing.expectError(error.InvalidLength, parse(\"0x12-34\"));\n        try std.testing.expectError(error.InvalidCharacter, parse(\"0xfoobbb\"));\n        try std.testing.expectError(error.InvalidBuildIdStyle, parse(\"yaddaxxx\"));\n    }",null,null,false],[0,0,0,"none",null,null,null,false],[0,0,0,"fast",null,null,null,false],[0,0,0,"uuid",null,null,null,false],[0,0,0,"sha1",null,null,null,false],[0,0,0,"md5",null,null,null,false],[0,0,0,"hexstring",null,null,null,false],[17,362,0,null,null,null,[1624,1625,1626,1627],false],[0,0,0,"exe",null,null,null,false],[0,0,0,"lib",null,null,null,false],[0,0,0,"obj",null,null,null,false],[0,0,0,"test",null,null,null,false],[17,369,0,null,null,null,[1629,1630],false],[0,0,0,"dynamic",null,null,null,false],[0,0,0,"static",null,null,null,false],[17,371,0,null,null,null,[1632,1633],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"options",null,"",null,false],[17,522,0,null,null,null,[1635,1636,1637],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"src_path",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[17,529,0,null,null,null,[1640,1642],false],[17,529,0,null,null,null,null,false],[0,0,0,"install_dir",null,null,null,false],[17,529,0,null,null,null,null,false],[0,0,0,"dest_rel_path",null,null,null,false],[17,534,0,null,null,null,[1644,1645,1646],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"config_header",null,"",null,false],[0,0,0,"options",null,"",null,false],[17,551,0,null,null,null,[1648,1649,1650],false],[0,0,0,"a",null,"",null,false],[0,0,0,"src_dir_path",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[17,563,0,null,null,null,[1652,1653],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"options",null,"",null,false],[17,573,0,null,null,null,[1655,1656],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"l",null,"",null,false],[17,596,0,null,null,null,[1658,1659],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"options",null,"",null,false],[17,611,0,null,null," This function would run in the context of the package that created the executable,\n which is undesirable when running an executable provided by a dependency package.",null,false],[17,615,0,null,null," This function would install in the context of the package that created the artifact,\n which is undesirable when installing an artifact provided by a dependency package.",null,false],[17,617,0,null,null,null,[1663],false],[0,0,0,"self",null,"",null,false],[17,622,0,null,null," deprecated: use `setLinkerScript`",null,false],[17,624,0,null,null,null,[1666,1667],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[17,630,0,null,null,null,[1669,1670],false],[0,0,0,"self",null,"",null,false],[0,0,0,"symbol_name",null,"",null,false],[17,635,0,null,null,null,[1672,1673],false],[0,0,0,"self",null,"",null,false],[0,0,0,"framework_name",null,"",null,false],[17,640,0,null,null,null,[1675,1676],false],[0,0,0,"self",null,"",null,false],[0,0,0,"framework_name",null,"",null,false],[17,647,0,null,null,null,[1678,1679],false],[0,0,0,"self",null,"",null,false],[0,0,0,"framework_name",null,"",null,false],[17,655,0,null,null," Returns whether the library, executable, or object depends on a particular system library.",[1681,1682],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[17,671,0,null,null,null,[1684,1685],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lib",null,"",null,false],[17,676,0,null,null,null,[1687],false],[0,0,0,"self",null,"",null,false],[17,680,0,null,null,null,[1689],false],[0,0,0,"self",null,"",null,false],[17,684,0,null,null,null,[1691],false],[0,0,0,"self",null,"",null,false],[17,693,0,null,null,null,[1693],false],[0,0,0,"self",null,"",null,false],[17,697,0,null,null,null,[1695],false],[0,0,0,"self",null,"",null,false],[17,701,0,null,null,null,[1697],false],[0,0,0,"self",null,"",null,false],[17,707,0,null,null," If the value is omitted, it is set to 1.\n `name` and `value` need not live longer than the function call.",[1699,1700,1701],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"value",null,"",null,false],[17,714,0,null,null," name_and_value looks like [name]=[value]. If the value is omitted, it is set to 1.",[1703,1704],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name_and_value",null,"",null,false],[17,720,0,null,null," deprecated: use linkSystemLibrary2",[1706,1707],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[17,725,0,null,null," deprecated: use linkSystemLibrary2",[1709,1710],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[17,730,0,null,null," deprecated: use linkSystemLibrary2",[1712,1713],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[17,735,0,null,null," deprecated: use linkSystemLibrary2",[1715,1716],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lib_name",null,"",null,false],[17,740,0,null,null," deprecated: use linkSystemLibrary2",[1718,1719],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lib_name",null,"",null,false],[17,746,0,null,null," Run pkg-config for the given library name and parse the output, returning the arguments\n that should be passed to zig to link the given library.",[1721,1722],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lib_name",null,"",null,false],[17,840,0,null,null,null,[1724,1725],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[17,845,0,null,null," deprecated: use linkSystemLibrary2",[1727,1728],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[17,850,0,null,null," deprecated: use linkSystemLibrary2",[1730,1731],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[17,854,0,null,null,null,[1733,1734,1736,1738,1740],false],[0,0,0,"needed",null,null,null,false],[0,0,0,"weak",null,null,null,false],[17,854,0,null,null,null,null,false],[0,0,0,"use_pkg_config",null,null,null,false],[17,854,0,null,null,null,null,false],[0,0,0,"preferred_link_mode",null,null,null,false],[17,854,0,null,null,null,null,false],[0,0,0,"search_strategy",null,null,null,false],[17,862,0,null,null,null,[1742,1743,1744],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"options",null,"",null,false],[17,890,0,null,null," Handy when you have many C/C++ source files and want them all to have the same flags.",[1746,1747,1748],false],[0,0,0,"self",null,"",null,false],[0,0,0,"files",null,"",null,false],[0,0,0,"flags",null,"",null,false],[17,904,0,null,null,null,[1750,1751],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[17,912,0,null,null,null,[1753,1754],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[17,916,0,null,null,null,[1756,1757],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[17,920,0,null,null,null,[1759,1760],false],[0,0,0,"self",null,"",null,false],[0,0,0,"libc_file",null,"",null,false],[17,925,0,null,null,null,[1762,1763],false],[0,0,0,"self",null,"",null,false],[0,0,0,"output_file",null,"",null,false],[17,937,0,null,null," deprecated: use `getEmittedBinDirectory`",null,false],[17,940,0,null,null," Returns the path to the directory that contains the emitted binary file.",[1766],false],[0,0,0,"self",null,"",null,false],[17,946,0,null,null," deprecated: use `getEmittedBin`",null,false],[17,950,0,null,null," Returns the path to the generated executable, library or object file.\n To run an executable built with zig build, use `run`, or create an install step and invoke it.",[1769],false],[0,0,0,"self",null,"",null,false],[17,955,0,null,null," deprecated: use `getEmittedImplib`",null,false],[17,959,0,null,null," Returns the path to the generated import library.\n This function can only be called for libraries.",[1772],false],[0,0,0,"self",null,"",null,false],[17,965,0,null,null," deprecated: use `getEmittedH`",null,false],[17,969,0,null,null," Returns the path to the generated header file.\n This function can only be called for libraries or objects.",[1775],false],[0,0,0,"self",null,"",null,false],[17,975,0,null,null," deprecated: use `getEmittedPdb`.",null,false],[17,980,0,null,null," Returns the generated PDB file.\n If the compilation does not produce a PDB file, this causes a FileNotFound error\n at build time.",[1778],false],[0,0,0,"self",null,"",null,false],[17,986,0,null,null," Returns the path to the generated documentation directory.",[1780],false],[0,0,0,"self",null,"",null,false],[17,991,0,null,null," Returns the path to the generated assembly code.",[1782],false],[0,0,0,"self",null,"",null,false],[17,996,0,null,null," Returns the path to the generated LLVM IR.",[1784],false],[0,0,0,"self",null,"",null,false],[17,1001,0,null,null," Returns the path to the generated LLVM BC.",[1786],false],[0,0,0,"self",null,"",null,false],[17,1005,0,null,null,null,[1788,1789],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[17,1012,0,null,null,null,[1791,1792],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[17,1018,0,null,null,null,[1794,1795],false],[0,0,0,"self",null,"",null,false],[0,0,0,"obj",null,"",null,false],[17,1023,0,null,null,null,[1797,1798],false],[0,0,0,"self",null,"",null,false],[0,0,0,"path",null,"",null,false],[17,1029,0,null,null,null,[1800,1801],false],[0,0,0,"self",null,"",null,false],[0,0,0,"path",null,"",null,false],[17,1035,0,null,null,null,[1803,1804],false],[0,0,0,"self",null,"",null,false],[0,0,0,"config_header",null,"",null,false],[17,1040,0,null,null,null,[1806,1807],false],[0,0,0,"self",null,"",null,false],[0,0,0,"directory_source",null,"",null,false],[17,1046,0,null,null,null,[1809,1810],false],[0,0,0,"self",null,"",null,false],[0,0,0,"directory_source",null,"",null,false],[17,1052,0,null,null,null,[1812,1813],false],[0,0,0,"self",null,"",null,false],[0,0,0,"directory_source",null,"",null,false],[17,1060,0,null,null," Adds a module to be used with `@import` and exposing it in the current\n package's module table using `name`.",[1815,1816,1817],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"module",null,"",null,false],[17,1071,0,null,null," Adds a module to be used with `@import` without exposing it in the current\n package's module table.",[1819,1820,1821],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"options",null,"",null,false],[17,1077,0,null,null,null,[1823,1824,1825],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"module_name",null,"",null,false],[0,0,0,"options",null,"",null,false],[17,1081,0,null,null,null,[1827,1828,1829],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"module",null,"",null,false],[0,0,0,"done",null,"",null,false],[17,1092,0,null,null," If Vcpkg was found on the system, it will be added to include and lib\n paths for the specified target.",[1831,1832],false],[0,0,0,"self",null,"",null,false],[0,0,0,"linkage",null,"",null,false],[17,1128,0,null,null,null,[1834,1835],false],[0,0,0,"self",null,"",null,false],[0,0,0,"args",null,"",null,false],[17,1138,0,null,null,null,[1837,1838],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[17,1152,0,null,null,null,[1840,1841],false],[0,0,0,"cs",null,"",null,false],[0,0,0,"zig_args",null,"",null,false],[17,1239,0,null,null,null,[1843,1844,1845],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"mod_names",null,"",null,false],[0,0,0,"deps",null,"",null,false],[17,1262,0,null,null,null,[1847,1848,1849],false],[0,0,0,"self",null,"",null,false],[0,0,0,"tag_name",null,"",null,true],[0,0,0,"asking_step",null,"",null,false],[17,1286,0,null,null,null,[1851,1852],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[17,2086,0,null,null,null,[1854],false],[0,0,0,"name",null,"",null,false],[17,2095,0,null,null,null,[1856],false],[0,0,0,"name",null,"",null,false],[17,2105,0,null,null," Returned slice must be freed by the caller.",[1858],false],[0,0,0,"allocator",null,"",null,false],[17,2123,0,null,null,null,[1860,1861,1862,1863],false],[0,0,0,"step",null,"",null,false],[0,0,0,"output_path",null,"",null,false],[0,0,0,"filename_major_only",null,"",null,false],[0,0,0,"filename_name_only",null,"",null,false],[17,2148,0,null,null,null,[1865,1866],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out_code",null,"",null,false],[17,2164,0,null,null,null,[1868],false],[0,0,0,"self",null,"",null,false],[17,2187,0,null,null,null,[1870,1871,1872],false],[0,0,0,"args",null,"",null,false],[0,0,0,"name",null,"",null,true],[0,0,0,"opt",null,"",null,false],[17,2197,0,null,null,null,[1882,1884,1886,1887,1888,1890],false],[17,2205,0,null,null,null,[1875,1876],false],[0,0,0,"td",null,"",null,false],[0,0,0,"link_objects",null,"",null,false],[17,2217,0,null,null,null,[1878,1879,1880],false],[0,0,0,"td",null,"",null,false],[0,0,0,"other",null,"",null,false],[0,0,0,"dyn",null,"",null,false],[17,2197,0,null,null,null,null,false],[0,0,0,"link_objects",null,null,null,false],[17,2197,0,null,null,null,null,false],[0,0,0,"seen_system_libs",null,null,null,false],[17,2197,0,null,null,null,null,false],[0,0,0,"seen_steps",null,null,null,false],[0,0,0,"is_linking_libcpp",null,null,null,false],[0,0,0,"is_linking_libc",null,null,null,false],[17,2197,0,null,null,null,null,false],[0,0,0,"frameworks",null,null,null,false],[17,2258,0,null,null,null,[1892],false],[0,0,0,"self",null,"",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"target_info",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"linker_script",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"version_script",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"out_filename",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"linkage",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"version",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"kind",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"major_only_filename",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"name_only_filename",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"strip",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"unwind_tables",null,null,null,false],[17,0,0,null,null,null,[1924,1925],false],[0,0,0,"none",null,null,null,false],[0,0,0,"zlib",null,null,null,false],[0,0,0,"compress_debug_sections",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"lib_paths",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"rpaths",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"framework_dirs",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"frameworks",null,null,null,false],[0,0,0,"verbose_link",null,null,null,false],[0,0,0,"verbose_cc",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"bundle_compiler_rt",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"single_threaded",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"stack_protector",null,null,null,false],[0,0,0,"disable_stack_probing",null,null,null,false],[0,0,0,"disable_sanitize_c",null,null,null,false],[0,0,0,"sanitize_thread",null,null,null,false],[0,0,0,"rdynamic",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"dwarf_format",null,null,null,false],[0,0,0,"import_memory",null,null,null,false],[0,0,0,"export_memory",null,null,null,false],[0,0,0,"import_symbols",null," For WebAssembly targets, this will allow for undefined symbols to\n be imported from the host environment.",null,false],[0,0,0,"import_table",null,null,null,false],[0,0,0,"export_table",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"initial_memory",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"max_memory",null,null,null,false],[0,0,0,"shared_memory",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"global_base",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"c_std",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null," Set via options; intended to be read-only after that.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"main_pkg_path",null," Set via options; intended to be read-only after that.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"exec_cmd_args",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"filter",null,null,null,false],[0,0,0,"test_evented_io",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"test_runner",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"code_model",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"wasi_exec_model",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"export_symbol_names",null," Symbols to be exported when compiling to wasm",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"root_src",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"out_lib_filename",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"modules",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"link_objects",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"include_dirs",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"c_macros",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"installed_headers",null,null,null,false],[0,0,0,"is_linking_libc",null,null,null,false],[0,0,0,"is_linking_libcpp",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"vcpkg_bin_path",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"installed_path",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"image_base",null," Base address for an executable image.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"libc_file",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"valgrind_support",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"each_lib_rpath",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"build_id",null," On ELF targets, this will emit a link section called \".note.gnu.build-id\"\n which can be used to coordinate a stripped binary with its debug symbols.\n As an example, the bloaty project refuses to work unless its inputs have\n build ids, in order to prevent accidental mismatches.\n The default is to not include this section because it slows down linking.",null,false],[0,0,0,"link_eh_frame_hdr",null," Create a .eh_frame_hdr section and a PT_GNU_EH_FRAME segment in the ELF\n file.",null,false],[0,0,0,"link_emit_relocs",null,null,null,false],[0,0,0,"link_function_sections",null," Place every function in its own section so that unused ones may be\n safely garbage-collected during the linking phase.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"link_gc_sections",null," Remove functions and data that are unreachable by the entry point or\n exported symbols.",null,false],[0,0,0,"linker_dynamicbase",null," (Windows) Whether or not to enable ASLR. Maps to the /DYNAMICBASE[:NO] linker argument.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"linker_allow_shlib_undefined",null,null,null,false],[0,0,0,"link_z_notext",null," Permit read-only relocations in read-only segments. Disallowed by default.",null,false],[0,0,0,"link_z_relro",null," Force all relocations to be read-only after processing.",null,false],[0,0,0,"link_z_lazy",null," Allow relocations to be lazily processed after load.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"link_z_common_page_size",null," Common page size",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"link_z_max_page_size",null," Maximum page size",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"install_name",null," (Darwin) Install name for the dylib",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"entitlements",null," (Darwin) Path to entitlements file",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"pagezero_size",null," (Darwin) Size of the pagezero segment.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"headerpad_size",null," (Darwin) Set size of the padding between the end of load commands\n and start of `__TEXT,__text` section.",null,false],[0,0,0,"headerpad_max_install_names",null," (Darwin) Automatically Set size of the padding between the end of load commands\n and start of `__TEXT,__text` section to a value fitting all paths expanded to MAXPATHLEN.",null,false],[0,0,0,"dead_strip_dylibs",null," (Darwin) Remove dylibs that are unreachable by the entry point or exported symbols.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"force_pic",null," Position Independent Code",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"pie",null," Position Independent Executable",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"red_zone",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"omit_frame_pointer",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"dll_export_fns",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"subsystem",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"entry_symbol_name",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"force_undefined_symbols",null," List of symbols forced as undefined in the symbol table\n thus forcing their resolution by the linker.\n Corresponds to `-u <symbol>` for ELF/MachO and `/include:<symbol>` for COFF/PE.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"stack_size",null," Overrides the default stack size",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"want_lto",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"use_llvm",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"use_lld",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"expect_errors",null," This is an advanced setting that can change the intent of this Compile step.\n If this slice has nonzero length, it means that this Compile step exists to\n check for compile errors and return *success* if they match, and failure\n otherwise.",null,false],[17,0,0,null,null,null,null,false],[0,0,0,"emit_directory",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_docs",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_asm",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_bin",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_pdb",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_implib",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_llvm_bc",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_llvm_ir",null,null,null,false],[17,0,0,null,null,null,null,false],[0,0,0,"generated_h",null,null,null,false],[8,124,0,null,null,null,null,false],[0,0,0,"Step/Options.zig",null,"",[2129,2131,2133,2135],false],[18,0,0,null,null,null,null,false],[18,1,0,null,null,null,null,false],[18,2,0,null,null,null,null,false],[18,3,0,null,null,null,null,false],[18,4,0,null,null,null,null,false],[18,5,0,null,null,null,null,false],[18,7,0,null,null,null,null,false],[18,9,0,null,null,null,null,false],[18,17,0,null,null,null,[2090],false],[0,0,0,"owner",null,"",null,false],[18,35,0,null,null,null,[2092,2093,2094,2095],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"name",null,"",null,false],[0,0,0,"value",null,"",null,false],[18,39,0,null,null,null,[2097,2098,2099,2100],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"name",null,"",null,false],[0,0,0,"value",null,"",null,false],[18,124,0,null,null,null,[2102,2103,2104],false],[0,0,0,"out",null,"",null,false],[0,0,0,"val",null,"",null,false],[0,0,0,"indent",null,"",null,false],[18,169,0,null,null," deprecated: use `addOptionPath`",null,false],[18,173,0,null,null," The value is the path in the cache dir.\n Adds a dependency automatically.",[2107,2108,2109],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"path",null,"",null,false],[18,186,0,null,null," Deprecated: use `addOptionPath(options, name, artifact.getEmittedBin())` instead.",[2111,2112,2113],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"artifact",null,"",null,false],[18,190,0,null,null,null,[2115],false],[0,0,0,"self",null,"",null,false],[18,198,0,null,null," deprecated: use `getOutput`",null,false],[18,200,0,null,null,null,[2118],false],[0,0,0,"self",null,"",null,false],[18,204,0,null,null,null,[2120,2121],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[18,290,0,null,null,null,[2124,2126],false],[18,290,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[18,290,0,null,null,null,null,false],[0,0,0,"path",null,null,null,false],[18,295,0,"Options","test Options {\n    if (builtin.os.tag == .wasi) return error.SkipZigTest;\n\n    var arena = std.heap.ArenaAllocator.init(std.testing.allocator);\n    defer arena.deinit();\n\n    const host = try std.zig.system.NativeTargetInfo.detect(.{});\n\n    var cache: std.Build.Cache = .{\n        .gpa = arena.allocator(),\n        .manifest_dir = std.fs.cwd(),\n    };\n\n    var builder = try std.Build.create(\n        arena.allocator(),\n        \"test\",\n        .{ .path = \"test\", .handle = std.fs.cwd() },\n        .{ .path = \"test\", .handle = std.fs.cwd() },\n        .{ .path = \"test\", .handle = std.fs.cwd() },\n        host,\n        &cache,\n    );\n    defer builder.destroy();\n\n    const options = builder.addOptions();\n\n    // TODO this regressed at some point\n    //const KeywordEnum = enum {\n    //    @\"0.8.1\",\n    //};\n\n    const nested_array = [2][2]u16{\n        [2]u16{ 300, 200 },\n        [2]u16{ 300, 200 },\n    };\n    const nested_slice: []const []const u16 = &[_][]const u16{ &nested_array[0], &nested_array[1] };\n\n    options.addOption(usize, \"option1\", 1);\n    options.addOption(?usize, \"option2\", null);\n    options.addOption(?usize, \"option3\", 3);\n    options.addOption(comptime_int, \"option4\", 4);\n    options.addOption([]const u8, \"string\", \"zigisthebest\");\n    options.addOption(?[]const u8, \"optional_string\", null);\n    options.addOption([2][2]u16, \"nested_array\", nested_array);\n    options.addOption([]const []const u16, \"nested_slice\", nested_slice);\n    //options.addOption(KeywordEnum, \"keyword_enum\", .@\"0.8.1\");\n    options.addOption(std.SemanticVersion, \"semantic_version\", try std.SemanticVersion.parse(\"0.1.2-foo+bar\"));\n\n    try std.testing.expectEqualStrings(\n        \\\\pub const option1: usize = 1;\n        \\\\pub const option2: ?usize = null;\n        \\\\pub const option3: ?usize = 3;\n        \\\\pub const option4: comptime_int = 4;\n        \\\\pub const string: []const u8 = \"zigisthebest\";\n        \\\\pub const optional_string: ?[]const u8 = null;\n        \\\\pub const nested_array: [2][2]u16 = [2][2]u16 {\n        \\\\    [2]u16 {\n        \\\\        300,\n        \\\\        200,\n        \\\\    },\n        \\\\    [2]u16 {\n        \\\\        300,\n        \\\\        200,\n        \\\\    },\n        \\\\};\n        \\\\pub const nested_slice: []const []const u16 = &[_][]const u16 {\n        \\\\    &[_]u16 {\n        \\\\        300,\n        \\\\        200,\n        \\\\    },\n        \\\\    &[_]u16 {\n        \\\\        300,\n        \\\\        200,\n        \\\\    },\n        \\\\};\n        //\\\\pub const KeywordEnum = enum {\n        //\\\\    @\"0.8.1\",\n        //\\\\};\n        //\\\\pub const keyword_enum: KeywordEnum = KeywordEnum.@\"0.8.1\";\n        \\\\pub const semantic_version: @import(\"std\").SemanticVersion = .{\n        \\\\    .major = 0,\n        \\\\    .minor = 1,\n        \\\\    .patch = 2,\n        \\\\    .pre = \"foo\",\n        \\\\    .build = \"bar\",\n        \\\\};\n        \\\\\n    , options.contents.items);\n\n    _ = try std.zig.Ast.parse(arena.allocator(), try options.contents.toOwnedSliceSentinel(0), .zig);\n}",null,null,false],[18,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[18,0,0,null,null,null,null,false],[0,0,0,"generated_file",null,null,null,false],[18,0,0,null,null,null,null,false],[0,0,0,"contents",null,null,null,false],[18,0,0,null,null,null,null,false],[0,0,0,"args",null,null,null,false],[8,125,0,null,null,null,null,false],[0,0,0,"Step/RemoveDir.zig",null,"",[2150,2152],false],[19,0,0,null,null,null,null,false],[19,1,0,null,null,null,null,false],[19,2,0,null,null,null,null,false],[19,3,0,null,null,null,null,false],[19,5,0,null,null,null,null,false],[19,10,0,null,null,null,[2144,2145],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"dir_path",null,"",null,false],[19,22,0,null,null,null,[2147,2148],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[19,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[19,0,0,null,null,null,null,false],[0,0,0,"dir_path",null,null,null,false],[8,126,0,null,null,null,null,false],[0,0,0,"Step/Run.zig",null,"",[2372,2374,2376,2378,2380,2382,2384,2385,2386,2387,2388,2390,2392,2393],false],[20,0,0,null,null,null,null,false],[20,1,0,null,null,null,null,false],[20,2,0,null,null,null,null,false],[20,3,0,null,null,null,null,false],[20,4,0,null,null,null,null,false],[20,5,0,null,null,null,null,false],[20,6,0,null,null,null,null,false],[20,7,0,null,null,null,null,false],[20,8,0,null,null,null,null,false],[20,9,0,null,null,null,null,false],[20,10,0,null,null,null,null,false],[20,12,0,null,null,null,null,false],[20,14,0,null,null,null,null,false],[20,81,0,null,null,null,[2169,2170,2171],false],[0,0,0,"none",null,null,null,false],[0,0,0,"bytes",null,null,null,false],[0,0,0,"lazy_path",null,null,null,false],[20,87,0,null,null,null,[2179,2180,2181,2182],false],[20,111,0,null,null,null,[2174,2175,2176,2177,2178],false],[0,0,0,"expect_stderr_exact",null,null,null,false],[0,0,0,"expect_stderr_match",null,null,null,false],[0,0,0,"expect_stdout_exact",null,null,null,false],[0,0,0,"expect_stdout_match",null,null,null,false],[0,0,0,"expect_term",null,null,null,false],[0,0,0,"infer_from_args",null," Whether the Run step has side-effects will be determined by whether or not one\n of the args is an output file (added with `addOutputFileArg`).\n If the Run step is determined to have side-effects, this is the same as `inherit`.\n The step will fail if the subprocess crashes or returns a non-zero exit code.",null,false],[0,0,0,"inherit",null," Causes the Run step to be considered to have side-effects, and therefore\n always execute when it appears in the build graph.\n It also means that this step will obtain a global lock to prevent other\n steps from running in the meantime.\n The step will fail if the subprocess crashes or returns a non-zero exit code.",null,false],[0,0,0,"check",null," Causes the Run step to be considered to *not* have side-effects. The\n process will be re-executed if any of the input dependencies are\n modified. The exit code and standard I/O streams will be checked for\n certain conditions, and the step will succeed or fail based on these\n conditions.\n Note that an explicit check for exit code 0 needs to be added to this\n list if such a check is desirable.",null,false],[0,0,0,"zig_test",null," This Run step is running a zig unit test binary and will communicate\n extra metadata over the IPC protocol.",null,false],[20,120,0,null,null,null,[2184,2185,2186,2187,2188],false],[0,0,0,"artifact",null,null,null,false],[0,0,0,"lazy_path",null,null,null,false],[0,0,0,"directory_source",null,null,null,false],[0,0,0,"bytes",null,null,null,false],[0,0,0,"output",null,null,null,false],[20,128,0,null,null,null,[2191,2193],false],[20,128,0,null,null,null,null,false],[0,0,0,"prefix",null,null,null,false],[20,128,0,null,null,null,null,false],[0,0,0,"lazy_path",null,null,null,false],[20,133,0,null,null,null,[2196,2198,2200],false],[20,133,0,null,null,null,null,false],[0,0,0,"generated_file",null,null,null,false],[20,133,0,null,null,null,null,false],[0,0,0,"prefix",null,null,null,false],[20,133,0,null,null,null,null,false],[0,0,0,"basename",null,null,null,false],[20,139,0,null,null,null,[2202,2203],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"name",null,"",null,false],[20,155,0,null,null,null,[2205,2206],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[20,160,0,null,null,null,[2208],false],[0,0,0,"self",null,"",null,false],[20,165,0,null,null,null,[2210,2211],false],[0,0,0,"self",null,"",null,false],[0,0,0,"artifact",null,"",null,false],[20,174,0,null,null," This provides file path as a command line argument to the command being\n run, and returns a LazyPath which can be used as inputs to other APIs\n throughout the build system.",[2213,2214],false],[0,0,0,"self",null,"",null,false],[0,0,0,"basename",null,"",null,false],[20,178,0,null,null,null,[2216,2217,2218],false],[0,0,0,"self",null,"",null,false],[0,0,0,"prefix",null,"",null,false],[0,0,0,"basename",null,"",null,false],[20,201,0,null,null," deprecated: use `addFileArg`",null,false],[20,203,0,null,null,null,[2221,2222],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lp",null,"",null,false],[20,208,0,null,null,null,null,false],[20,210,0,null,null,null,[2225,2226,2227],false],[0,0,0,"self",null,"",null,false],[0,0,0,"prefix",null,"",null,false],[0,0,0,"lp",null,"",null,false],[20,222,0,null,null," deprecated: use `addDirectoryArg`",null,false],[20,224,0,null,null,null,[2230,2231],false],[0,0,0,"self",null,"",null,false],[0,0,0,"directory_source",null,"",null,false],[20,229,0,null,null,null,null,false],[20,231,0,null,null,null,[2234,2235,2236],false],[0,0,0,"self",null,"",null,false],[0,0,0,"prefix",null,"",null,false],[0,0,0,"directory_source",null,"",null,false],[20,242,0,null,null,null,[2238,2239],false],[0,0,0,"self",null,"",null,false],[0,0,0,"arg",null,"",null,false],[20,246,0,null,null,null,[2241,2242],false],[0,0,0,"self",null,"",null,false],[0,0,0,"args",null,"",null,false],[20,252,0,null,null,null,[2244,2245],false],[0,0,0,"self",null,"",null,false],[0,0,0,"stdin",null,"",null,false],[20,260,0,null,null,null,[2247],false],[0,0,0,"self",null,"",null,false],[20,267,0,null,null,null,[2249,2250],false],[0,0,0,"self",null,"",null,false],[0,0,0,"search_path",null,"",null,false],[20,282,0,null,null,null,[2252],false],[0,0,0,"self",null,"",null,false],[20,286,0,null,null,null,[2254],false],[0,0,0,"self",null,"",null,false],[20,296,0,null,null,null,[2256,2257,2258],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[20,302,0,null,null,null,[2260,2261],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[20,307,0,null,null," Adds a check for exact stderr match. Does not add any other checks.",[2263,2264],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[20,314,0,null,null," Adds a check for exact stdout match as well as a check for exit code 0, if\n there is not already an expected termination check.",[2266,2267],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[20,322,0,null,null,null,[2269,2270],false],[0,0,0,"self",null,"",null,false],[0,0,0,"code",null,"",null,false],[20,327,0,null,null,null,[2272],false],[0,0,0,"self",null,"",null,false],[20,335,0,null,null,null,[2274,2275],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_check",null,"",null,false],[20,346,0,null,null,null,[2277],false],[0,0,0,"self",null,"",null,false],[20,361,0,null,null,null,[2279],false],[0,0,0,"self",null,"",null,false],[20,377,0,null,null," Returns whether the Run step has side effects *other than* updating the output arguments.",[2281],false],[0,0,0,"self",null,"",null,false],[20,387,0,null,null,null,[2283],false],[0,0,0,"self",null,"",null,false],[20,397,0,null,null,null,[2285],false],[0,0,0,"checks",null,"",null,false],[20,411,0,null,null,null,[2287],false],[0,0,0,"checks",null,"",null,false],[20,425,0,null,null,null,[2289,2290],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[20,564,0,null,null,null,[2292,2293,2294,2295],false],[0,0,0,"term",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"writer",null,"",null,false],[20,581,0,null,null,null,[2297],false],[0,0,0,"term",null,"",null,false],[20,585,0,null,null,null,[2299,2300],false],[0,0,0,"expected",null,"",null,false],[0,0,0,"actual",null,"",null,false],[20,609,0,null,null,null,[2302,2303,2304,2305,2306],false],[0,0,0,"self",null,"",null,false],[0,0,0,"argv",null,"",null,false],[0,0,0,"has_side_effects",null,"",null,false],[0,0,0,"digest",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[20,915,0,null,null,null,[2309,2310,2311,2313],false],[20,915,0,null,null,null,null,false],[0,0,0,"term",null,null,null,false],[0,0,0,"elapsed_ns",null,null,null,false],[0,0,0,"peak_rss",null,null,null,false],[20,915,0,null,null,null,null,false],[0,0,0,"stdio",null,null,null,false],[20,923,0,null,null,null,[2315,2316,2317,2318],false],[0,0,0,"self",null,"",null,false],[0,0,0,"argv",null,"",null,false],[0,0,0,"has_side_effects",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[20,986,0,null,null,null,[2321,2323,2325,2327],false],[20,986,0,null,null,null,null,false],[0,0,0,"stdout",null,null,null,false],[20,986,0,null,null,null,null,false],[0,0,0,"stderr",null,null,null,false],[20,986,0,null,null,null,null,false],[0,0,0,"test_results",null,null,null,false],[20,986,0,null,null,null,null,false],[0,0,0,"test_metadata",null,null,null,false],[20,993,0,null,null,null,[2329,2330,2331],false],[0,0,0,"self",null,"",null,false],[0,0,0,"child",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[20,1128,0,null,null,null,[2337,2339,2341,2343,2344,2346],false],[20,1136,0,null,null,null,[2334,2335],false],[0,0,0,"tm",null,"",null,false],[0,0,0,"index",null,"",null,false],[20,1128,0,null,null,null,null,false],[0,0,0,"names",null,null,null,false],[20,1128,0,null,null,null,null,false],[0,0,0,"async_frame_lens",null,null,null,false],[20,1128,0,null,null,null,null,false],[0,0,0,"expected_panic_msgs",null,null,null,false],[20,1128,0,null,null,null,null,false],[0,0,0,"string_bytes",null,null,null,false],[0,0,0,"next_index",null,null,null,false],[20,1128,0,null,null,null,null,false],[0,0,0,"prog_node",null,null,null,false],[20,1141,0,null,null,null,[2348,2349,2350],false],[0,0,0,"in",null,"",null,false],[0,0,0,"metadata",null,"",null,false],[0,0,0,"sub_prog_node",null,"",null,false],[20,1160,0,null,null,null,[2352,2353],false],[0,0,0,"file",null,"",null,false],[0,0,0,"tag",null,"",null,false],[20,1168,0,null,null,null,[2355,2356],false],[0,0,0,"file",null,"",null,false],[0,0,0,"index",null,"",null,false],[20,1177,0,null,null,null,[2358,2359],false],[0,0,0,"self",null,"",null,false],[0,0,0,"child",null,"",null,false],[20,1249,0,null,null,null,[2361,2362],false],[0,0,0,"self",null,"",null,false],[0,0,0,"artifact",null,"",null,false],[20,1264,0,null,null,null,[2364,2365,2366,2367],false],[0,0,0,"self",null,"",null,false],[0,0,0,"suggested_flag",null,"",null,false],[0,0,0,"argv0",null,"",null,false],[0,0,0,"exe",null,"",null,false],[20,1290,0,null,null,null,[2369,2370],false],[0,0,0,"hh",null,"",null,false],[0,0,0,"stdio",null,"",null,false],[20,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[20,0,0,null,null,null,null,false],[0,0,0,"argv",null," See also addArg and addArgs to modifying this directly",null,false],[20,0,0,null,null,null,null,false],[0,0,0,"cwd",null," Set this to modify the current working directory\n TODO change this to a Build.Cache.Directory to better integrate with\n future child process cwd API.",null,false],[20,0,0,null,null,null,null,false],[0,0,0,"env_map",null," Override this field to modify the environment, or use setEnvironmentVariable",null,false],[20,0,0,null,null,null,null,false],[0,0,0,"stdio",null," Configures whether the Run step is considered to have side-effects, and also\n whether the Run step will inherit stdio streams, forwarding them to the\n parent process, in which case will require a global lock to prevent other\n steps from interfering with stdio while the subprocess associated with this\n Run step is running.\n If the Run step is determined to not have side-effects, then execution will\n be skipped if all output files are up-to-date and input files are\n unchanged.",null,false],[20,0,0,null,null,null,null,false],[0,0,0,"stdin",null," This field must be `.none` if stdio is `inherit`.\n It should be only set using `setStdIn`.",null,false],[20,0,0,null,null,null,null,false],[0,0,0,"extra_file_dependencies",null," Additional file paths relative to build.zig that, when modified, indicate\n that the Run step should be re-executed.\n If the Run step is determined to have side-effects, this field is ignored\n and the Run step is always executed when it appears in the build graph.",null,false],[0,0,0,"rename_step_with_output_arg",null," After adding an output argument, this step will by default rename itself\n for a better display name in the build summary.\n This can be disabled by setting this to false.",null,false],[0,0,0,"skip_foreign_checks",null," If this is true, a Run step which is configured to check the output of the\n executed binary will not fail the build if the binary cannot be executed\n due to being for a foreign binary to the host system which is running the\n build graph.\n Command-line arguments such as -fqemu and -fwasmtime may affect whether a\n binary is detected as foreign, as well as system configuration such as\n Rosetta (macOS) and binfmt_misc (Linux).\n If this Run step is considered to have side-effects, then this flag does\n nothing.",null,false],[0,0,0,"failing_to_execute_foreign_is_an_error",null," If this is true, failing to execute a foreign binary will be considered an\n error. However if this is false, the step will be skipped on failure instead.\n\n This allows for a Run step to attempt to execute a foreign binary using an\n external executor (such as qemu) but not fail if the executor is unavailable.",null,false],[0,0,0,"max_stdio_size",null," If stderr or stdout exceeds this amount, the child process is killed and\n the step fails.",null,false],[20,0,0,null,null,null,null,false],[0,0,0,"captured_stdout",null,null,null,false],[20,0,0,null,null,null,null,false],[0,0,0,"captured_stderr",null,null,null,false],[0,0,0,"has_side_effects",null,null,null,false],[8,127,0,null,null,null,null,false],[0,0,0,"Step/TranslateC.zig",null,"",[2451,2453,2455,2457,2459,2461,2463,2465],false],[21,0,0,null,null,null,null,false],[21,1,0,null,null,null,null,false],[21,2,0,null,null,null,null,false],[21,3,0,null,null,null,null,false],[21,4,0,null,null,null,null,false],[21,6,0,null,null,null,null,false],[21,8,0,null,null,null,null,false],[21,19,0,null,null,null,[2405,2407,2409],false],[21,19,0,null,null,null,null,false],[0,0,0,"source_file",null,null,null,false],[21,19,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[21,19,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[21,25,0,null,null,null,[2411,2412],false],[0,0,0,"owner",null,"",null,false],[0,0,0,"options",null,"",null,false],[21,47,0,null,null,null,[2415,2417,2419,2421,2423],false],[21,47,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[21,47,0,null,null,null,null,false],[0,0,0,"version",null,null,null,false],[21,47,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[21,47,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[21,47,0,null,null,null,null,false],[0,0,0,"linkage",null,null,null,false],[21,55,0,null,null,null,[2425],false],[0,0,0,"self",null,"",null,false],[21,60,0,null,null," Creates a step to build an executable from the translated source.",[2427,2428],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,false],[21,74,0,null,null," Creates a module from the translated source and adds it to the package's\n module set making it available to other packages which depend on this one.\n `createModule` can be used instead to create a private module.",[2430,2431],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[21,83,0,null,null," Creates a private module from the translated source to be used by the\n current package, but not exposed to other packages depending on this one.\n `addModule` can be used instead to create a public module.",[2433],false],[0,0,0,"self",null,"",null,false],[21,95,0,null,null,null,[2435,2436],false],[0,0,0,"self",null,"",null,false],[0,0,0,"include_dir",null,"",null,false],[21,99,0,null,null,null,[2438,2439],false],[0,0,0,"self",null,"",null,false],[0,0,0,"expected_matches",null,"",null,false],[21,109,0,null,null," If the value is omitted, it is set to 1.\n `name` and `value` need not live longer than the function call.",[2441,2442,2443],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"value",null,"",null,false],[21,115,0,null,null," name_and_value looks like [name]=[value]. If the value is omitted, it is set to 1.",[2445,2446],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name_and_value",null,"",null,false],[21,119,0,null,null,null,[2448,2449],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[21,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[21,0,0,null,null,null,null,false],[0,0,0,"source",null,null,null,false],[21,0,0,null,null,null,null,false],[0,0,0,"include_dirs",null,null,null,false],[21,0,0,null,null,null,null,false],[0,0,0,"c_macros",null,null,null,false],[21,0,0,null,null,null,null,false],[0,0,0,"out_basename",null,null,null,false],[21,0,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[21,0,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[21,0,0,null,null,null,null,false],[0,0,0,"output_file",null,null,null,false],[8,128,0,null,null,null,null,false],[0,0,0,"Step/WriteFile.zig",null," WriteFile is primarily used to create a directory in an appropriate\n location inside the local cache which has a set of files that have either\n been generated during the build, or are copied from the source package.\n\n However, this step has an additional capability of writing data to paths\n relative to the package root, effectively mutating the package's source\n files. Be careful with the latter functionality; it should not be used\n during the normal build process, but as a utility run by a developer with\n intention to update source files, which will then be committed to version\n control.\n",[2520,2522,2524,2526],false],[22,10,0,null,null,null,null,false],[22,11,0,null,null,null,null,false],[22,12,0,null,null,null,null,false],[22,13,0,null,null,null,null,false],[22,14,0,null,null,null,null,false],[22,23,0,null,null,null,null,false],[22,25,0,null,null,null,[2479,2481,2483],false],[22,31,0,null,null," deprecated: use `getPath`",null,false],[22,33,0,null,null,null,[2477],false],[0,0,0,"self",null,"",null,false],[22,25,0,null,null,null,null,false],[0,0,0,"generated_file",null,null,null,false],[22,25,0,null,null,null,null,false],[0,0,0,"sub_path",null,null,null,false],[22,25,0,null,null,null,null,false],[0,0,0,"contents",null,null,null,false],[22,38,0,null,null,null,[2486,2488],false],[22,38,0,null,null,null,null,false],[0,0,0,"contents",null,null,null,false],[22,38,0,null,null,null,null,false],[0,0,0,"sub_path",null,null,null,false],[22,43,0,null,null,null,[2490,2491],false],[0,0,0,"bytes",null,null,null,false],[0,0,0,"copy",null,null,null,false],[22,48,0,null,null,null,[2493],false],[0,0,0,"owner",null,"",null,false],[22,64,0,null,null,null,[2495,2496,2497],false],[0,0,0,"wf",null,"",null,false],[0,0,0,"sub_path",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[22,85,0,null,null," Place the file into the generated directory within the local cache,\n along with all the rest of the files added to this step. The parameter\n here is the destination path relative to the local cache directory\n associated with this WriteFile. It may be a basename, or it may\n include sub-directories, in which case this step will ensure the\n required sub-path exists.\n This is the option expected to be used most commonly with `addCopyFile`.",[2499,2500,2501],false],[0,0,0,"wf",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"sub_path",null,"",null,false],[22,106,0,null,null," A path relative to the package root.\n Be careful with this because it updates source files. This should not be\n used as part of the normal build process, but as a utility occasionally\n run by a developer with intent to modify source files and then commit\n those changes to version control.",[2503,2504,2505],false],[0,0,0,"wf",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"sub_path",null,"",null,false],[22,120,0,null,null," A path relative to the package root.\n Be careful with this because it updates source files. This should not be\n used as part of the normal build process, but as a utility occasionally\n run by a developer with intent to modify source files and then commit\n those changes to version control.",[2507,2508,2509],false],[0,0,0,"wf",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"sub_path",null,"",null,false],[22,128,0,null,null,null,null,false],[22,130,0,null,null,null,null,false],[22,134,0,null,null," Returns a `LazyPath` representing the base directory that contains all the\n files from this `WriteFile`.",[2513],false],[0,0,0,"wf",null,"",null,false],[22,138,0,null,null,null,[2515],false],[0,0,0,"wf",null,"",null,false],[22,147,0,null,null,null,[2517,2518],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[22,0,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[22,0,0,null,null,null,null,false],[0,0,0,"files",null," The elements here are pointers because we need stable pointers for the\n GeneratedFile field.",null,false],[22,0,0,null,null,null,null,false],[0,0,0,"output_source_files",null,null,null,false],[22,0,0,null,null,null,null,false],[0,0,0,"generated_directory",null,null,null,false],[8,130,0,null,null,null,[2529,2531,2533,2535,2537,2538],false],[8,130,0,null,null,null,null,false],[0,0,0,"id",null,null,null,false],[8,130,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[8,130,0,null,null,null,null,false],[0,0,0,"owner",null,null,null,false],[8,130,0,null,null,null,null,false],[0,0,0,"makeFn",null,null,null,false],[8,130,0,null,null,null,null,false],[0,0,0,"first_ret_addr",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[8,139,0,null,null,null,[2540],false],[0,0,0,"options",null,"",null,false],[8,172,0,null,null," If the Step's `make` function reports `error.MakeFailed`, it indicates they\n have already reported the error. Otherwise, we add a simple error report\n here.",[2542,2543],false],[0,0,0,"s",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[8,197,0,null,null,null,[2545,2546],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[8,201,0,null,null,null,[2548],false],[0,0,0,"s",null,"",null,false],[8,213,0,null,null,null,[2550,2551],false],[0,0,0,"step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[8,225,0,null,null,null,[2553,2554],false],[0,0,0,"step",null,"",null,false],[0,0,0,"T",null,"",null,true],[8,233,0,null,null," For debugging purposes, prints identifying information about this Step.",[2556],false],[0,0,0,"step",null,"",null,false],[8,254,0,null,null,null,null,false],[8,255,0,null,null,null,null,false],[8,256,0,null,null,null,null,false],[8,257,0,null,null,null,null,false],[8,258,0,null,null,null,null,false],[8,259,0,null,null,null,null,false],[8,261,0,null,null,null,[2564,2565],false],[0,0,0,"s",null,"",null,false],[0,0,0,"argv",null,"",null,false],[8,279,0,null,null,null,[2567,2568,2569],false],[0,0,0,"step",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"args",null,"",null,false],[8,284,0,null,null,null,[2571,2572,2573],false],[0,0,0,"step",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"args",null,"",null,false],[8,292,0,null,null," Assumes that argv contains `--listen=-` and that the process being spawned\n is the zig compiler - the same version that compiled the build runner.",[2575,2576,2577],false],[0,0,0,"s",null,"",null,false],[0,0,0,"argv",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[8,428,0,null,null,null,[2579,2580],false],[0,0,0,"file",null,"",null,false],[0,0,0,"tag",null,"",null,false],[8,436,0,null,null,null,[2582,2583,2584],false],[0,0,0,"b",null,"",null,false],[0,0,0,"opt_cwd",null,"",null,false],[0,0,0,"argv",null,"",null,false],[8,444,0,null,null,null,[2586,2587,2588,2589],false],[0,0,0,"b",null,"",null,false],[0,0,0,"opt_cwd",null,"",null,false],[0,0,0,"opt_env",null,"",null,false],[0,0,0,"argv",null,"",null,false],[8,458,0,null,null,null,[2591,2592,2593],false],[0,0,0,"s",null,"",null,false],[0,0,0,"opt_cwd",null,"",null,false],[0,0,0,"argv",null,"",null,false],[8,471,0,null,null,null,[2595,2596,2597,2598],false],[0,0,0,"s",null,"",null,false],[0,0,0,"term",null,"",null,false],[0,0,0,"opt_cwd",null,"",null,false],[0,0,0,"argv",null,"",null,false],[8,496,0,null,null,null,[2600,2601,2602],false],[0,0,0,"arena",null,"",null,false],[0,0,0,"opt_cwd",null,"",null,false],[0,0,0,"argv",null,"",null,false],[8,504,0,null,null,null,[2604,2605,2606,2607],false],[0,0,0,"arena",null,"",null,false],[0,0,0,"opt_cwd",null,"",null,false],[0,0,0,"opt_env",null,"",null,false],[0,0,0,"argv",null,"",null,false],[8,530,0,null,null,null,[2609,2610],false],[0,0,0,"s",null,"",null,false],[0,0,0,"man",null,"",null,false],[8,535,0,null,null,null,[2612,2613,2614],false],[0,0,0,"s",null,"",null,false],[0,0,0,"man",null,"",null,false],[0,0,0,"err",null,"",null,false],[8,542,0,null,null,null,[2616,2617],false],[0,0,0,"s",null,"",null,false],[0,0,0,"man",null,"",null,false],[8,0,0,null,null,null,null,false],[0,0,0,"id",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"owner",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"makeFn",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"dependencies",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"dependants",null," This field is empty during execution of the user's build script, and\n then populated during dependency loop checking in the build runner.",null,false],[8,0,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[0,0,0,"max_rss",null," Set this field to declare an upper bound on the amount of bytes of memory it will\n take to run the step. Zero means no limit.\n\n The idea to annotate steps that might use a high amount of RAM with an\n upper bound. For example, perhaps a particular set of unit tests require 4\n GiB of RAM, and those tests will be run under 4 different build\n configurations at once. This would potentially require 16 GiB of memory on\n the system if all 4 steps executed simultaneously, which could easily be\n greater than what is actually available, potentially causing the system to\n crash when using `zig build` at the default concurrency level.\n\n This field causes the build runner to do two things:\n 1. ulimit child processes, so that they will fail if it would exceed this\n memory limit. This serves to enforce that this upper bound value is\n correct.\n 2. Ensure that the set of concurrent steps at any given time have a total\n max_rss value that does not exceed the `max_total_rss` value of the build\n runner. This value is configurable on the command line, and defaults to the\n total system memory available.",null,false],[8,0,0,null,null,null,null,false],[0,0,0,"result_error_msgs",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"result_error_bundle",null,null,null,false],[0,0,0,"result_cached",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"result_duration_ns",null,null,null,false],[0,0,0,"result_peak_rss",null," 0 means unavailable or not reported.",null,false],[8,0,0,null,null,null,null,false],[0,0,0,"test_results",null,null,null,false],[8,0,0,null,null,null,null,false],[0,0,0,"debug_stack_trace",null," The return address associated with creation of this step that can be useful\n to print along with debugging messages.",null,false],[4,32,0,null,null," deprecated: use `Step.CheckFile`.",null,false],[4,34,0,null,null," deprecated: use `Step.CheckObject`.",null,false],[4,36,0,null,null," deprecated: use `Step.ConfigHeader`.",null,false],[4,38,0,null,null," deprecated: use `Step.Fmt`.",null,false],[4,40,0,null,null," deprecated: use `Step.InstallArtifact`.",null,false],[4,42,0,null,null," deprecated: use `Step.InstallDir`.",null,false],[4,44,0,null,null," deprecated: use `Step.InstallFile`.",null,false],[4,46,0,null,null," deprecated: use `Step.ObjCopy`.",null,false],[4,48,0,null,null," deprecated: use `Step.Compile`.",null,false],[4,50,0,null,null," deprecated: use `Step.Options`.",null,false],[4,52,0,null,null," deprecated: use `Step.RemoveDir`.",null,false],[4,54,0,null,null," deprecated: use `Step.Run`.",null,false],[4,56,0,null,null," deprecated: use `Step.TranslateC`.",null,false],[4,58,0,null,null," deprecated: use `Step.WriteFile`.",null,false],[4,60,0,null,null," deprecated: use `LazyPath`.",null,false],[4,131,0,null,null,null,null,false],[4,138,0,null,null,null,null,false],[4,145,0,null,null,null,[2664,2666],false],[4,145,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,145,0,null,null,null,null,false],[0,0,0,"desc",null,null,null,false],[4,150,0,null,null,null,[2668,2669,2670],false],[0,0,0,"C89",null,null,null,false],[0,0,0,"C99",null,null,null,false],[0,0,0,"C11",null,null,null,false],[4,156,0,null,null,null,null,false],[4,157,0,null,null,null,null,false],[4,159,0,null,null,null,[2675,2677,2679,2681],false],[4,159,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,159,0,null,null,null,null,false],[0,0,0,"type_id",null,null,null,false],[4,159,0,null,null,null,null,false],[0,0,0,"description",null,null,null,false],[4,159,0,null,null,null,null,false],[0,0,0,"enum_options",null," If the `type_id` is `enum` this provides the list of enum options",null,false],[4,167,0,null,null,null,[2684,2686,2687],false],[4,167,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,167,0,null,null,null,null,false],[0,0,0,"value",null,null,null,false],[0,0,0,"used",null,null,null,false],[4,173,0,null,null,null,[2689,2690,2691,2692],false],[0,0,0,"flag",null,null,null,false],[0,0,0,"scalar",null,null,null,false],[0,0,0,"list",null,null,null,false],[0,0,0,"map",null,null,null,false],[4,180,0,null,null,null,[2694,2695,2696,2697,2698,2699,2700],false],[0,0,0,"bool",null,null,null,false],[0,0,0,"int",null,null,null,false],[0,0,0,"float",null,null,null,false],[0,0,0,"enum",null,null,null,false],[0,0,0,"string",null,null,null,false],[0,0,0,"list",null,null,null,false],[0,0,0,"build_id",null,null,null,false],[4,190,0,null,null,null,[2704,2706],false],[4,191,0,null,null,null,null,false],[4,190,0,null,null,null,null,false],[0,0,0,"step",null,null,null,false],[4,190,0,null,null,null,null,false],[0,0,0,"description",null,null,null,false],[4,197,0,null,null,null,[2709,2711,2713],false],[4,197,0,null,null,null,null,false],[0,0,0,"lib_dir",null,null,null,false],[4,197,0,null,null,null,null,false],[0,0,0,"exe_dir",null,null,null,false],[4,197,0,null,null,null,null,false],[0,0,0,"include_dir",null,null,null,false],[4,203,0,null,null,null,[2715,2716,2717,2718,2719,2720,2721],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"zig_exe",null,"",null,false],[0,0,0,"build_root",null,"",null,false],[0,0,0,"cache_root",null,"",null,false],[0,0,0,"global_cache_root",null,"",null,false],[0,0,0,"host",null,"",null,false],[0,0,0,"cache",null,"",null,false],[4,278,0,null,null,null,[2723,2724,2725,2726],false],[0,0,0,"parent",null,"",null,false],[0,0,0,"dep_name",null,"",null,false],[0,0,0,"build_root",null,"",null,false],[0,0,0,"args",null,"",null,false],[4,289,0,null,null,null,[2728,2729,2730],false],[0,0,0,"parent",null,"",null,false],[0,0,0,"dep_name",null,"",null,false],[0,0,0,"build_root",null,"",null,false],[4,363,0,null,null,null,[2732,2733],false],[0,0,0,"b",null,"",null,false],[0,0,0,"args",null,"",null,false],[4,427,0,null,null,null,[2735],false],[0,0,0,"b",null,"",null,false],[4,434,0,null,null," This function is intended to be called by lib/build_runner.zig, not a build.zig file.",[2737,2738,2739],false],[0,0,0,"self",null,"",null,false],[0,0,0,"install_prefix",null,"",null,false],[0,0,0,"dir_list",null,"",null,false],[4,468,0,null,null,null,[2741],false],[0,0,0,"self",null,"",null,false],[4,472,0,null,null,null,[2744,2746,2748,2750,2752,2754,2755,2757,2759,2761,2763,2765,2767],false],[4,472,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"root_source_file",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"version",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"linkage",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"link_libc",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"single_threaded",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"use_llvm",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"use_lld",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[4,472,0,null,null,null,null,false],[0,0,0,"main_pkg_path",null,null,null,false],[4,488,0,null,null,null,[2769,2770],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,507,0,null,null,null,[2773,2775,2777,2779,2780,2782,2784,2786,2788,2790,2792],false],[4,507,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"root_source_file",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"link_libc",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"single_threaded",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"use_llvm",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"use_lld",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[4,507,0,null,null,null,null,false],[0,0,0,"main_pkg_path",null,null,null,false],[4,521,0,null,null,null,[2794,2795],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,538,0,null,null,null,[2798,2800,2802,2804,2806,2807,2809,2811,2813,2815,2817,2819],false],[4,538,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"root_source_file",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"version",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"link_libc",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"single_threaded",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"use_llvm",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"use_lld",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[4,538,0,null,null,null,null,false],[0,0,0,"main_pkg_path",null,null,null,false],[4,553,0,null,null,null,[2821,2822],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,572,0,null,null,null,[2825,2827,2829,2831,2833,2834,2836,2838,2840,2842,2844,2846],false],[4,572,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"root_source_file",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"version",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"link_libc",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"single_threaded",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"use_llvm",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"use_lld",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[4,572,0,null,null,null,null,false],[0,0,0,"main_pkg_path",null,null,null,false],[4,587,0,null,null,null,[2848,2849],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,606,0,null,null,null,[2852,2854,2856,2858,2860,2861,2863,2865,2867,2869,2871,2873,2875,2877],false],[4,606,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"root_source_file",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"version",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"filter",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"test_runner",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"link_libc",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"single_threaded",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"use_llvm",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"use_lld",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[4,606,0,null,null,null,null,false],[0,0,0,"main_pkg_path",null,null,null,false],[4,623,0,null,null,null,[2879,2880],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,642,0,null,null,null,[2883,2885,2887,2889,2890,2892],false],[4,642,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,642,0,null,null,null,null,false],[0,0,0,"source_file",null,null,null,false],[4,642,0,null,null,null,null,false],[0,0,0,"target",null,null,null,false],[4,642,0,null,null,null,null,false],[0,0,0,"optimize",null,null,null,false],[0,0,0,"max_rss",null,null,null,false],[4,642,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[4,651,0,null,null,null,[2894,2895],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,668,0,null,null," This function creates a module and adds it to the package's module set, making\n it available to other packages which depend on this one.\n `createModule` can be used instead to create a private module.",[2897,2898,2899],false],[0,0,0,"b",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,674,0,null,null,null,[2902,2904],false],[4,674,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[4,674,0,null,null,null,null,false],[0,0,0,"module",null,null,null,false],[4,679,0,null,null,null,[2907,2909],false],[4,679,0,null,null,null,null,false],[0,0,0,"source_file",null,null,null,false],[4,679,0,null,null,null,null,false],[0,0,0,"dependencies",null,null,null,false],[4,687,0,null,null," This function creates a private module, to be used by the current package,\n but not exposed to other packages depending on this one.\n `addModule` can be used instead to create a public module.",[2911,2912],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,697,0,null,null,null,[2914,2915],false],[0,0,0,"arena",null,"",null,false],[0,0,0,"deps",null,"",null,false],[4,710,0,null,null," Initializes a `Step.Run` with argv, which must at least have the path to the\n executable. More command line arguments can be added with `addArg`,\n `addArgs`, and `addArtifactArg`.\n Be careful using this function, as it introduces a system dependency.\n To run an executable built with zig build, see `Step.Compile.run`.",[2917,2918],false],[0,0,0,"self",null,"",null,false],[0,0,0,"argv",null,"",null,false],[4,719,0,null,null," Creates a `Step.Run` with an executable built with `addExecutable`.\n Add command line arguments with methods of `Step.Run`.",[2920,2921],false],[0,0,0,"b",null,"",null,false],[0,0,0,"exe",null,"",null,false],[4,742,0,null,null," Using the `values` provided, produces a C header file, possibly based on a\n template input file (e.g. config.h.in).\n When an input template file is provided, this function will fail the build\n when an option not found in the input file is provided in `values`, and\n when an option found in the input file is missing from `values`.",[2923,2924,2925],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[0,0,0,"values",null,"",null,false],[4,757,0,null,null," Allocator.dupe without the need to handle out of memory.",[2927,2928],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[4,762,0,null,null," Duplicates an array of strings without the need to handle out of memory.",[2930,2931],false],[0,0,0,"self",null,"",null,false],[0,0,0,"strings",null,"",null,false],[4,771,0,null,null," Duplicates a path and converts all slashes to the OS's canonical path separator.",[2933,2934],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[4,782,0,null,null,null,[2936,2937,2938],false],[0,0,0,"self",null,"",null,false],[0,0,0,"file_path",null,"",null,false],[0,0,0,"data",null,"",null,false],[4,788,0,null,null,null,[2940],false],[0,0,0,"b",null,"",null,false],[4,792,0,null,null,null,[2942,2943],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dir_path",null,"",null,false],[4,798,0,null,null,null,[2945,2946],false],[0,0,0,"b",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,802,0,null,null,null,[2948,2949],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,806,0,null,null,null,[2951],false],[0,0,0,"self",null,"",null,false],[4,810,0,null,null,null,[2953],false],[0,0,0,"self",null,"",null,false],[4,814,0,null,null,null,[2955,2956],false],[0,0,0,"uninstall_step",null,"",null,false],[0,0,0,"prog_node",null,"",null,false],[4,830,0,null,null,null,[2958,2959,2960,2961],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"name_raw",null,"",null,false],[0,0,0,"description_raw",null,"",null,false],[4,982,0,null,null,null,[2963,2964,2965],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"description",null,"",null,false],[4,1001,0,null,null,null,[2968],false],[4,1001,0,null,null,null,null,false],[0,0,0,"preferred_optimize_mode",null,null,null,false],[4,1005,0,null,null,null,[2970,2971],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,1021,0,null,null,null,[2974,2976],false],[4,1021,0,null,null,null,null,false],[0,0,0,"whitelist",null,null,null,false],[4,1021,0,null,null,null,null,false],[0,0,0,"default_target",null,null,null,false],[4,1028,0,null,null," Exposes standard `zig build` options for choosing a target.",[2978,2979],false],[0,0,0,"self",null,"",null,false],[0,0,0,"args",null,"",null,false],[4,1159,0,null,null,null,[2981,2982,2983],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name_raw",null,"",null,false],[0,0,0,"value_raw",null,"",null,false],[4,1207,0,null,null,null,[2985,2986],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name_raw",null,"",null,false],[4,1234,0,null,null,null,[2988],false],[0,0,0,"T",null,"",null,true],[4,1251,0,null,null,null,[2990],false],[0,0,0,"self",null,"",null,false],[4,1255,0,null,null,null,[2992],false],[0,0,0,"self",null,"",null,false],[4,1268,0,null,null,null,[2994,2995,2996],false],[0,0,0,"ally",null,"",null,false],[0,0,0,"opt_cwd",null,"",null,false],[0,0,0,"argv",null,"",null,false],[4,1277,0,null,null,null,[2998,2999,3000],false],[0,0,0,"ally",null,"",null,false],[0,0,0,"cwd",null,"",null,false],[0,0,0,"argv",null,"",null,false],[4,1285,0,null,null," This creates the install step and adds it to the dependencies of the\n top-level install step, using all the default options.\n See `addInstallArtifact` for a more flexible function.",[3002,3003],false],[0,0,0,"self",null,"",null,false],[0,0,0,"artifact",null,"",null,false],[4,1291,0,null,null," This merely creates the step; it does not add it to the dependencies of the\n top-level install step.",[3005,3006,3007],false],[0,0,0,"self",null,"",null,false],[0,0,0,"artifact",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,1300,0,null,null,"`dest_rel_path` is relative to prefix path",[3009,3010,3011],false],[0,0,0,"self",null,"",null,false],[0,0,0,"src_path",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1304,0,null,null,null,[3013,3014],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,1309,0,null,null,"`dest_rel_path` is relative to bin path",[3016,3017,3018],false],[0,0,0,"self",null,"",null,false],[0,0,0,"src_path",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1314,0,null,null,"`dest_rel_path` is relative to lib path",[3020,3021,3022],false],[0,0,0,"self",null,"",null,false],[0,0,0,"src_path",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1318,0,null,null,null,[3024,3025,3026],false],[0,0,0,"b",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,1323,0,null,null,"`dest_rel_path` is relative to install prefix path",[3028,3029,3030],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1328,0,null,null,"`dest_rel_path` is relative to bin path",[3032,3033,3034],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1333,0,null,null,"`dest_rel_path` is relative to lib path",[3036,3037,3038],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1337,0,null,null,null,[3040,3041,3042],false],[0,0,0,"b",null,"",null,false],[0,0,0,"src_path",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1341,0,null,null,null,[3044,3045,3046,3047],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"install_dir",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1350,0,null,null,null,[3049,3050],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,1354,0,null,null,null,[3052,3053,3054],false],[0,0,0,"b",null,"",null,false],[0,0,0,"file_source",null,"",null,false],[0,0,0,"options",null,"",null,false],[4,1363,0,null,null," deprecated: https://github.com/ziglang/zig/issues/14943",[3056,3057,3058],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dir",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1371,0,null,null,null,[3060,3061],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest_path",null,"",null,false],[4,1388,0,null,null,null,[3063,3064],false],[0,0,0,"b",null,"",null,false],[0,0,0,"p",null,"",null,false],[4,1392,0,null,null,null,[3066,3067],false],[0,0,0,"b",null,"",null,false],[0,0,0,"p",null,"",null,false],[4,1397,0,null,null,null,[3069,3070],false],[0,0,0,"self",null,"",null,false],[0,0,0,"paths",null,"",null,false],[4,1401,0,null,null,null,[3072,3073,3074],false],[0,0,0,"self",null,"",null,false],[0,0,0,"format",null,"",null,true],[0,0,0,"args",null,"",null,false],[4,1405,0,null,null,null,[3076,3077,3078],false],[0,0,0,"self",null,"",null,false],[0,0,0,"names",null,"",null,false],[0,0,0,"paths",null,"",null,false],[4,1451,0,null,null,null,[3080,3081,3082,3083],false],[0,0,0,"self",null,"",null,false],[0,0,0,"argv",null,"",null,false],[0,0,0,"out_code",null,"",null,false],[0,0,0,"stderr_behavior",null,"",null,false],[4,1495,0,null,null," This is a helper function to be called from build.zig scripts, *not* from\n inside step make() functions. If any errors occur, it fails the build with\n a helpful message.",[3085,3086],false],[0,0,0,"b",null,"",null,false],[0,0,0,"argv",null,"",null,false],[4,1513,0,null,null,null,[3088,3089],false],[0,0,0,"self",null,"",null,false],[0,0,0,"search_prefix",null,"",null,false],[4,1517,0,null,null,null,[3091,3092,3093],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dir",null,"",null,false],[0,0,0,"dest_rel_path",null,"",null,false],[4,1532,0,null,null,null,[3102],false],[4,1535,0,null,null,null,[3096,3097],false],[0,0,0,"d",null,"",null,false],[0,0,0,"name",null,"",null,false],[4,1553,0,null,null,null,[3099,3100],false],[0,0,0,"d",null,"",null,false],[0,0,0,"name",null,"",null,false],[4,1532,0,null,null,null,null,false],[0,0,0,"builder",null,null,null,false],[4,1560,0,null,null,null,[3104,3105,3106],false],[0,0,0,"b",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"args",null,"",null,false],[4,1580,0,null,null,null,[3108,3109,3110,3111],false],[0,0,0,"b",null,"",null,false],[0,0,0,"relative_build_root",null," The path to the directory containing the dependency's build.zig file,\n relative to the current package's build.zig.",null,false],[0,0,0,"build_zig",null," A direct `@import` of the build.zig of the dependency.\n",null,true],[0,0,0,"args",null,"",null,false],[4,1599,0,null,null,null,[3113,3114,3115,3116,3117],false],[0,0,0,"b",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"build_root_string",null,"",null,false],[0,0,0,"build_zig",null,"",null,true],[0,0,0,"args",null,"",null,false],[4,1635,0,null,null,null,[3119,3120],false],[0,0,0,"b",null,"",null,false],[0,0,0,"build_zig",null,"",null,false],[4,1643,0,null,null,null,[3123,3125,3127],false],[4,1643,0,null,null,null,null,false],[0,0,0,"builder",null,null,null,false],[4,1643,0,null,null,null,null,false],[0,0,0,"source_file",null," This could either be a generated file, in which case the module\n contains exactly one file, or it could be a path to the root source\n file of directory of files which constitute the module.",null,false],[4,1643,0,null,null,null,null,false],[0,0,0,"dependencies",null,null,null,false],[4,1654,0,null,null," A file that is generated by a build step.\n This struct is an interface that is meant to be used with `@fieldParentPtr` to implement the actual path logic.",[3132,3134],false],[4,1662,0,null,null,null,[3130],false],[0,0,0,"self",null,"",null,false],[4,1654,0,null,null,null,null,false],[0,0,0,"step",null," The step that generates the file",null,false],[4,1654,0,null,null,null,null,false],[0,0,0,"path",null," The path to the generated file. Must be either absolute or relative to the build root.\n This value must be set in the `fn make()` of the `step` and must not be `null` afterwards.",null,false],[4,1671,0,null,null," A reference to an existing or future path.",[3153,3154,3155],false],[4,1691,0,null,null," Returns a new file source that will have a relative path to the build root guaranteed.\n Asserts the parameter is not an absolute path.",[3137],false],[0,0,0,"path",null,"",null,false],[4,1698,0,null,null," Returns a string that can be shown to represent the file source.\n Either returns the path or `\"generated\"`.",[3139],false],[0,0,0,"self",null,"",null,false],[4,1706,0,null,null," Adds dependencies this file source implies to the given step.",[3141,3142],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other_step",null,"",null,false],[4,1715,0,null,null," Returns an absolute path.\n Intended to be used during the make phase only.",[3144,3145],false],[0,0,0,"self",null,"",null,false],[0,0,0,"src_builder",null,"",null,false],[4,1724,0,null,null," Returns an absolute path.\n Intended to be used during the make phase only.\n\n `asking_step` is only used for debugging purposes; it's the step being\n run that is asking for the path.",[3147,3148,3149],false],[0,0,0,"self",null,"",null,false],[0,0,0,"src_builder",null,"",null,false],[0,0,0,"asking_step",null,"",null,false],[4,1738,0,null,null," Duplicates the file source for a given builder.",[3151,3152],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"path",null," A source file path relative to build root.\n This should not be an absolute path, but in an older iteration of the zig build\n system API, it was allowed to be absolute. Absolute paths should use `cwd_relative`.",null,false],[0,0,0,"generated",null," A file that is generated by an interface. Those files usually are\n not available until built by a build step.",null,false],[0,0,0,"cwd_relative",null," An absolute path or a path relative to the current working directory of\n the build runner process.\n This is uncommon but used for system environment paths such as `--zig-lib-dir` which\n ignore the file system path of build.zig and instead are relative to the directory from\n which `zig build` was invoked.\n Use of this tag indicates a dependency on the host system.",null,false],[4,1748,0,null,null," In this function the stderr mutex has already been locked.",[3157,3158,3159,3160],false],[0,0,0,"s",null,"",null,false],[0,0,0,"stderr",null,"",null,false],[0,0,0,"src_builder",null,"",null,false],[0,0,0,"asking_step",null,"",null,false],[4,1798,0,null,null," Allocates a new string for assigning a value to a named macro.\n If the value is omitted, it is set to 1.\n `name` and `value` need not live longer than the function call.",[3162,3163,3164],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"value",null,"",null,false],[4,1811,0,null,null,null,[3166,3167,3168],false],[0,0,0,"unattempted",null,null,null,false],[0,0,0,"not_found",null,null,null,false],[0,0,0,"found",null,null,null,false],[4,1817,0,null,null,null,[3170,3171,3172],false],[0,0,0,"unattempted",null,null,null,false],[0,0,0,"not_found",null,null,null,false],[0,0,0,"found",null,null,null,false],[4,1823,0,null,null,null,[3177,3178,3179,3180,3181],false],[4,1832,0,null,null," Duplicates the install directory including the path if set to custom.",[3175,3176],false],[0,0,0,"self",null,"",null,false],[0,0,0,"builder",null,"",null,false],[0,0,0,"prefix",null,null,null,false],[0,0,0,"lib",null,null,null,false],[0,0,0,"bin",null,null,null,false],[0,0,0,"header",null,null,null,false],[0,0,0,"custom",null," A path relative to the prefix",null,false],[4,1841,0,null,null,null,[3187,3189],false],[4,1846,0,null,null," Duplicates the installed file path and directory.",[3184,3185],false],[0,0,0,"self",null,"",null,false],[0,0,0,"builder",null,"",null,false],[4,1841,0,null,null,null,null,false],[0,0,0,"dir",null,null,null,false],[4,1841,0,null,null,null,null,false],[0,0,0,"path",null,null,null,false],[4,1854,0,null,null,null,[3191,3192],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"cpu",null,"",null,false],[4,1886,0,null,null," This function is intended to be called in the `configure` phase only.\n It returns an absolute directory path, which is potentially going to be a\n source of API breakage in the future, so keep that in mind when using this\n function.",[3194],false],[0,0,0,"b",null,"",null,false],[4,1900,0,null,null," There are a few copies of this function in miscellaneous places. Would be nice to find\n a home for them.",[3196],false],[0,0,0,"x",null,"",null,false],[4,0,0,null,null,null,null,false],[0,0,0,"install_tls",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"uninstall_tls",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"user_input_options",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"available_options_map",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"available_options_list",null,null,null,false],[0,0,0,"verbose",null,null,null,false],[0,0,0,"verbose_link",null,null,null,false],[0,0,0,"verbose_cc",null,null,null,false],[0,0,0,"verbose_air",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"verbose_llvm_ir",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"verbose_llvm_bc",null,null,null,false],[0,0,0,"verbose_cimport",null,null,null,false],[0,0,0,"verbose_llvm_cpu_features",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"reference_trace",null,null,null,false],[0,0,0,"invalid_user_input",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"zig_exe",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"default_step",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"env_map",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"top_level_steps",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"install_prefix",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"dest_dir",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"lib_dir",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"exe_dir",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"h_dir",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"install_path",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"sysroot",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"search_prefixes",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"libc_file",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"installed_files",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"build_root",null," Path to the directory containing build.zig.",null,false],[4,0,0,null,null,null,null,false],[0,0,0,"cache_root",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"global_cache_root",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"cache",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"zig_lib_dir",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"vcpkg_root",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"pkg_config_pkg_list",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"args",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"debug_log_scopes",null,null,null,false],[0,0,0,"debug_compile_errors",null,null,null,false],[0,0,0,"debug_pkg_config",null,null,null,false],[0,0,0,"enable_darling",null," Experimental. Use system Darling installation to run cross compiled macOS build artifacts.",null,false],[0,0,0,"enable_qemu",null," Use system QEMU installation to run cross compiled foreign architecture build artifacts.",null,false],[0,0,0,"enable_rosetta",null," Darwin. Use Rosetta to run x86_64 macOS build artifacts on arm64 macOS.",null,false],[0,0,0,"enable_wasmtime",null," Use system Wasmtime installation to run cross compiled wasm/wasi build artifacts.",null,false],[0,0,0,"enable_wine",null," Use system Wine installation to run cross compiled Windows build artifacts.",null,false],[4,0,0,null,null,null,null,false],[0,0,0,"glibc_runtimes_dir",null," After following the steps in https://github.com/ziglang/zig/wiki/Updating-libc#glibc,\n this will be the directory $glibc-build-dir/install/glibcs\n Given the example of the aarch64 target, this is the directory\n that contains the path `aarch64-linux-gnu/lib/ld-linux-aarch64.so.1`.",null,false],[4,0,0,null,null,null,null,false],[0,0,0,"host",null," Information about the native target. Computed before build() is invoked.",null,false],[4,0,0,null,null,null,null,false],[0,0,0,"dep_prefix",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"modules",null,null,null,false],[4,0,0,null,null,null,null,false],[0,0,0,"initialized_deps",null," A map from build root dirs to the corresponding `*Dependency`. This is shared with all child\n `Build`s.",null,false],[0,14,0,null,null,null,null,false],[0,0,0,"buf_map.zig",null,"",[],false],[23,0,0,null,null,null,null,false],[23,1,0,null,null,null,null,false],[23,2,0,null,null,null,null,false],[23,3,0,null,null,null,null,false],[23,4,0,null,null,null,null,false],[23,8,0,null,null," BufMap copies keys and values before they go into the map and\n frees them when they get removed.",[3326],false],[23,11,0,null,null,null,null,false],[23,16,0,null,null," Create a BufMap backed by a specific allocator.\n That allocator will be used for both backing allocations\n and string deduplication.",[3295],false],[0,0,0,"allocator",null,"",null,false],[23,23,0,null,null," Free the backing storage of the map, as well as all\n of the stored keys and values.",[3297],false],[0,0,0,"self",null,"",null,false],[23,36,0,null,null," Same as `put` but the key and value become owned by the BufMap rather\n than being copied.\n If `putMove` fails, the ownership of key and value does not transfer.",[3299,3300,3301],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[23,47,0,null,null," `key` and `value` are copied into the BufMap.",[3303,3304,3305],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[23,64,0,null,null," Find the address of the value associated with a key.\n The returned pointer is invalidated if the map resizes.",[3307,3308],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[23,71,0,null,null," Return the map's copy of the value associated with\n a key.  The returned string is invalidated if this\n key is removed from the map.",[3310,3311],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[23,77,0,null,null," Removes the item from the map and frees its value.\n This invalidates the value returned by get() for this key.",[3313,3314],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[23,84,0,null,null," Returns the number of KV pairs stored in the map.",[3316],false],[0,0,0,"self",null,"",null,false],[23,89,0,null,null," Returns an iterator over entries in the map.",[3318],false],[0,0,0,"self",null,"",null,false],[23,93,0,null,null,null,[3320,3321],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[23,97,0,null,null,null,[3323,3324],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[23,8,0,null,null,null,null,false],[0,0,0,"hash_map",null,null,null,false],[0,15,0,null,null,null,null,false],[0,0,0,"buf_set.zig",null,"",[],false],[24,0,0,null,null,null,null,false],[24,1,0,null,null,null,null,false],[24,2,0,null,null,null,null,false],[0,0,0,"mem.zig",null,"",[],false],[25,0,0,null,null,null,null,false],[25,1,0,null,null,null,null,false],[25,2,0,null,null,null,null,false],[25,3,0,null,null,null,null,false],[25,4,0,null,null,null,null,false],[25,5,0,null,null,null,null,false],[25,6,0,null,null,null,null,false],[25,7,0,null,null,null,null,false],[25,8,0,null,null,null,null,false],[25,9,0,null,null,null,null,false],[25,10,0,null,null,null,null,false],[25,14,0,null,null," Compile time known minimum page size.\n https://github.com/ziglang/zig/issues/4082",null,false],[25,30,0,null,null," The standard library currently thoroughly depends on byte size\n being 8 bits.  (see the use of u8 throughout allocation code as\n the \"byte\" type.)  Code which depends on this can reference this\n declaration.  If we ever try to port the standard library to a\n non-8-bit-byte platform, this will allow us to search for things\n which need to be updated.",null,false],[25,32,0,null,null,null,null,false],[0,0,0,"mem/Allocator.zig",null," The standard memory allocation interface.\n",[3484,3486],false],[26,2,0,null,null,null,null,false],[26,3,0,null,null,null,null,false],[26,4,0,null,null,null,null,false],[26,5,0,null,null,null,null,false],[26,6,0,null,null,null,null,false],[26,7,0,null,null,null,null,false],[26,9,0,null,null,null,null,false],[26,10,0,null,null,null,null,false],[26,16,0,null,null,null,[3362,3369,3375],false],[26,16,0,null,null,null,[3358,3359,3360,3361],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"ptr_align",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[0,0,0,"alloc",null," Attempt to allocate exactly `len` bytes aligned to `1 << ptr_align`.\n\n `ret_addr` is optionally provided as the first return address of the\n allocation call stack. If the value is `0` it means no return address\n has been provided.",null,false],[26,16,0,null,null,null,[3364,3365,3366,3367,3368],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"buf_align",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[0,0,0,"resize",null," Attempt to expand or shrink memory in place. `buf.len` must equal the\n length requested from the most recent successful call to `alloc` or\n `resize`. `buf_align` must equal the same value that was passed as the\n `ptr_align` parameter to the original `alloc` call.\n\n A result of `true` indicates the resize was successful and the\n allocation now has the same address but a size of `new_len`. `false`\n indicates the resize could not be completed without moving the\n allocation to a different address.\n\n `new_len` must be greater than zero.\n\n `ret_addr` is optionally provided as the first return address of the\n allocation call stack. If the value is `0` it means no return address\n has been provided.",null,false],[26,16,0,null,null,null,[3371,3372,3373,3374],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"buf_align",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[0,0,0,"free",null," Free and invalidate a buffer.\n\n `buf.len` must equal the most recent length returned by `alloc` or\n given to a successful `resize` call.\n\n `buf_align` must equal the same value that was passed as the\n `ptr_align` parameter to the original `alloc` call.\n\n `ret_addr` is optionally provided as the first return address of the\n allocation call stack. If the value is `0` it means no return address\n has been provided.",null,false],[26,55,0,null,null,null,[3377,3378,3379,3380,3381],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"log2_buf_align",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[26,70,0,null,null,null,[3383,3384,3385,3386],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"log2_buf_align",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[26,84,0,null,null," This function is not intended to be called except from within the\n implementation of an Allocator",[3388,3389,3390,3391],false],[0,0,0,"self",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"ptr_align",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[26,90,0,null,null," This function is not intended to be called except from within the\n implementation of an Allocator",[3393,3394,3395,3396,3397],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"log2_buf_align",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[26,96,0,null,null," This function is not intended to be called except from within the\n implementation of an Allocator",[3399,3400,3401,3402],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"log2_buf_align",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[26,102,0,null,null," Returns a pointer to undefined memory.\n Call `destroy` with the result to free the memory.",[3404,3405],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[26,110,0,null,null," `ptr` should be the return value of `create`, or otherwise\n have the same address and alignment property.",[3407,3408],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ptr",null,"",null,false],[26,127,0,null,null," Allocates an array of `n` items of type `T` and sets all the\n items to `undefined`. Depending on the Allocator\n implementation, it may be required to call `free` once the\n memory is no longer needed, to avoid a resource leak. If the\n `Allocator` implementation is unknown, then correct code will\n call `free` when done.\n\n For allocating a single item, see `create`.",[3410,3411,3412],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"n",null,"",null,false],[26,131,0,null,null,null,[3414,3415,3416,3417,3418],false],[0,0,0,"self",null,"",null,false],[0,0,0,"Elem",null,"",null,true],[0,0,0,"n",null,"",null,false],[0,0,0,"optional_alignment",null," null means naturally aligned\n",null,true],[0,0,0,"optional_sentinel",null,"",null,true],[26,142,0,null,null,null,[3420,3421,3422,3423,3424,3425],false],[0,0,0,"self",null,"",null,false],[0,0,0,"Elem",null,"",null,true],[0,0,0,"n",null,"",null,false],[0,0,0,"optional_alignment",null," null means naturally aligned\n",null,true],[0,0,0,"optional_sentinel",null,"",null,true],[0,0,0,"return_address",null,"",null,false],[26,160,0,null,null,null,[3427,3428,3429],false],[0,0,0,"Elem",null,"",null,true],[0,0,0,"alignment",null,"",null,true],[0,0,0,"sentinel",null,"",null,true],[26,176,0,null,null," Allocates an array of `n + 1` items of type `T` and sets the first `n`\n items to `undefined` and the last item to `sentinel`. Depending on the\n Allocator implementation, it may be required to call `free` once the\n memory is no longer needed, to avoid a resource leak. If the\n `Allocator` implementation is unknown, then correct code will\n call `free` when done.\n\n For allocating a single item, see `create`.",[3431,3432,3433,3434],false],[0,0,0,"self",null,"",null,false],[0,0,0,"Elem",null,"",null,true],[0,0,0,"n",null,"",null,false],[0,0,0,"sentinel",null,"",null,true],[26,185,0,null,null,null,[3436,3437,3438,3439],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"alignment",null," null means naturally aligned\n",null,true],[0,0,0,"n",null,"",null,false],[26,195,0,null,null,null,[3441,3442,3443,3444,3445],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"alignment",null," null means naturally aligned\n",null,true],[0,0,0,"n",null,"",null,false],[0,0,0,"return_address",null,"",null,false],[26,208,0,null,null,null,[3447,3448,3449,3450,3451],false],[0,0,0,"self",null,"",null,false],[0,0,0,"size",null,"",null,true],[0,0,0,"alignment",null,"",null,true],[0,0,0,"n",null,"",null,false],[0,0,0,"return_address",null,"",null,false],[26,213,0,null,null,null,[3453,3454,3455,3456],false],[0,0,0,"self",null,"",null,false],[0,0,0,"alignment",null,"",null,true],[0,0,0,"byte_count",null,"",null,false],[0,0,0,"return_address",null,"",null,false],[26,233,0,null,null," Requests to modify the size of an allocation. It is guaranteed to not move\n the pointer, however the allocator implementation may refuse the resize\n request by returning `false`.",[3458,3459,3460],false],[0,0,0,"self",null,"",null,false],[0,0,0,"old_mem",null,"",null,false],[0,0,0,"new_n",null,"",null,false],[26,254,0,null,null," This function requests a new byte size for an existing allocation, which\n can be larger, smaller, or the same size as the old memory allocation.\n If `new_n` is 0, this is the same as `free` and it always succeeds.",[3462,3463,3464],false],[0,0,0,"self",null,"",null,false],[0,0,0,"old_mem",null,"",null,false],[0,0,0,"new_n",null,"",null,false],[26,261,0,null,null,null,[3466,3467,3468,3469],false],[0,0,0,"self",null,"",null,false],[0,0,0,"old_mem",null,"",null,false],[0,0,0,"new_n",null,"",null,false],[0,0,0,"return_address",null,"",null,false],[26,305,0,null,null," Free an array allocated with `alloc`. To free a single item,\n see `destroy`.",[3471,3472],false],[0,0,0,"self",null,"",null,false],[0,0,0,"memory",null,"",null,false],[26,317,0,null,null," Copies `m` to newly allocated memory. Caller owns the memory.",[3474,3475,3476],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"m",null,"",null,false],[26,324,0,null,null," Copies `m` to newly allocated memory, with a null-terminated element. Caller owns the memory.",[3478,3479,3480],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"m",null,"",null,false],[26,333,0,null,null," TODO replace callsites with `@log2` after this proposal is implemented:\n https://github.com/ziglang/zig/issues/13642",[3482],false],[0,0,0,"x",null,"",null,false],[26,0,0,null,null,null,null,false],[0,0,0,"ptr",null,null,null,false],[26,0,0,null,null,null,null,false],[0,0,0,"vtable",null,null,null,false],[25,36,0,null,null," Detects and asserts if the std.mem.Allocator interface is violated by the caller\n or the allocator.",[3488],false],[0,0,0,"T",null,"",[3515],true],[25,38,0,null,null,null,null,false],[25,42,0,null,null,null,[3491],false],[0,0,0,"underlying_allocator",null,"",null,false],[25,48,0,null,null,null,[3493],false],[0,0,0,"self",null,"",null,false],[25,59,0,null,null,null,[3495],false],[0,0,0,"self",null,"",null,false],[25,64,0,null,null,null,[3497,3498,3499,3500],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"n",null,"",null,false],[0,0,0,"log2_ptr_align",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[25,79,0,null,null,null,[3502,3503,3504,3505,3506],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"log2_buf_align",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[25,92,0,null,null,null,[3508,3509,3510,3511],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"log2_buf_align",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[25,104,0,null,null,null,[3513],false],[0,0,0,"self",null,"",null,false],[25,37,0,null,null,null,null,false],[0,0,0,"underlying_allocator",null,null,null,false],[25,110,0,null,null,null,[3517],false],[0,0,0,"allocator",null,"",null,false],[25,118,0,null,null," An allocator helper function.  Adjusts an allocation length satisfy `len_align`.\n `full_len` should be the full capacity of the allocation which may be greater\n than the `len` that was requested.  This function should only be used by allocators\n that are unaffected by `len_align`.",[3519,3520,3521],false],[0,0,0,"full_len",null,"",null,false],[0,0,0,"alloc_len",null,"",null,false],[0,0,0,"len_align",null,"",null,false],[25,129,0,null,null,null,null,false],[25,134,0,null,null,null,null,false],[25,140,0,null,null,null,[3525,3526,3527,3528],false],[0,0,0,"",null,"",null,false],[0,0,0,"n",null,"",null,false],[0,0,0,"log2_alignment",null,"",null,false],[0,0,0,"ra",null,"",null,false],[25,196,0,null,null," Deprecated: use `@memcpy` if the arguments do not overlap, or\n `copyForwards` if they do.",null,false],[25,201,0,null,null," Copy all of source into dest at position 0.\n dest.len must be >= source.len.\n If the slices overlap, dest.ptr must be <= src.ptr.",[3531,3532,3533],false],[0,0,0,"T",null,"",null,true],[0,0,0,"dest",null,"",null,false],[0,0,0,"source",null,"",null,false],[25,208,0,null,null," Copy all of source into dest at position 0.\n dest.len must be >= source.len.\n If the slices overlap, dest.ptr must be >= src.ptr.",[3535,3536,3537],false],[0,0,0,"T",null,"",null,true],[0,0,0,"dest",null,"",null,false],[0,0,0,"source",null,"",null,false],[25,221,0,null,null,null,null,false],[25,229,0,null,null," Generally, Zig users are encouraged to explicitly initialize all fields of a struct explicitly rather than using this function.\n However, it is recognized that there are sometimes use cases for initializing all fields to a \"zero\" value. For example, when\n interfacing with a C API where this practice is more common and relied upon. If you are performing code review and see this\n function used, examine closely - it may be a code smell.\n Zero initializes the type.\n This can be used to zero-initialize any type for which it makes sense. Structs will be initialized recursively.",[3540],false],[0,0,0,"T",null,"",null,true],[25,421,0,null,null," Initializes all fields of the struct with their default value, or zero values if no default value is present.\n If the field is present in the provided initial values, it will have that value instead.\n Structs are initialized recursively.",[3542,3543],false],[0,0,0,"T",null,"",null,true],[0,0,0,"init",null,"",null,false],[25,569,0,null,null,null,[3545,3546,3547,3548],false],[0,0,0,"T",null,"",null,true],[0,0,0,"items",null,"",null,false],[0,0,0,"context",null,"",null,false],[0,0,0,"lessThanFn",null,"",[3549,3550,3551],true],[0,0,0,"",null,"",null,false],[0,0,0,"lhs",null,"",null,false],[0,0,0,"rhs",null,"",null,false],[25,578,0,null,null,null,[3553,3554,3555,3556],false],[0,0,0,"T",null,"",null,true],[0,0,0,"items",null,"",null,false],[0,0,0,"context",null,"",null,false],[0,0,0,"lessThanFn",null,"",[3557,3558,3559],true],[0,0,0,"",null,"",null,false],[0,0,0,"lhs",null,"",null,false],[0,0,0,"rhs",null,"",null,false],[25,589,0,null,null," TODO: currently this just calls `insertionSortContext`. The block sort implementation\n in this file needs to be adapted to use the sort context.",[3561,3562,3563],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"context",null,"",null,false],[25,593,0,null,null,null,[3565,3566,3567],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"context",null,"",null,false],[25,598,0,null,null," Compares two slices of numbers lexicographically. O(n).",[3569,3570,3571],false],[0,0,0,"T",null,"",null,true],[0,0,0,"lhs",null,"",null,false],[0,0,0,"rhs",null,"",null,false],[25,611,0,null,null," Compares two many-item pointers with NUL-termination lexicographically.",[3573,3574,3575],false],[0,0,0,"T",null,"",null,true],[0,0,0,"lhs",null,"",null,false],[0,0,0,"rhs",null,"",null,false],[25,631,0,null,null," Returns true if lhs < rhs, false otherwise",[3577,3578,3579],false],[0,0,0,"T",null,"",null,true],[0,0,0,"lhs",null,"",null,false],[0,0,0,"rhs",null,"",null,false],[25,644,0,null,null," Compares two slices and returns whether they are equal.",[3581,3582,3583],false],[0,0,0,"T",null,"",null,true],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[25,655,0,null,null," Compares two slices and returns the index of the first inequality.\n Returns null if the slices are equal.",[3585,3586,3587],false],[0,0,0,"T",null,"",null,true],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[25,674,0,null,null," Takes a sentinel-terminated pointer and returns a slice preserving pointer attributes.\n `[*c]` pointers are assumed to be 0-terminated and assumed to not be allowzero.",[3589],false],[0,0,0,"T",null,"",null,true],[25,712,0,null,null," Takes a sentinel-terminated pointer and returns a slice, iterating over the\n memory to find the sentinel and determine the length.\n Pointer attributes such as const are preserved.\n `[*c]` pointers are assumed to be non-null and 0-terminated.",[3591],false],[0,0,0,"ptr",null,"",null,false],[25,739,0,null,null," Helper for the return type of sliceTo()",[3593,3594],false],[0,0,0,"T",null,"",null,true],[0,0,0,"end",null,"",null,true],[25,799,0,null,null," Takes an array, a pointer to an array, a sentinel-terminated pointer, or a slice and\n iterates searching for the first occurrence of `end`, returning the scanned slice.\n If `end` is not found, the full length of the array/slice/sentinel terminated pointer is returned.\n If the pointer type is sentinel terminated and `end` matches that terminator, the\n resulting slice is also sentinel terminated.\n Pointer properties such as mutability and alignment are preserved.\n C pointers are assumed to be non-null.",[3596,3597],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"end",null,"",null,true],[25,855,0,null,null," Private helper for sliceTo(). If you want the length, use sliceTo(foo, x).len",[3599,3600],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"end",null,"",null,true],[25,934,0,null,null," Takes a sentinel-terminated pointer and iterates over the memory to find the\n sentinel and determine the length.\n `[*c]` pointers are assumed to be non-null and 0-terminated.",[3602],false],[0,0,0,"value",null,"",null,false],[25,961,0,null,null,null,[3604,3605,3606],false],[0,0,0,"Elem",null,"",null,true],[0,0,0,"sentinel",null,"",null,true],[0,0,0,"ptr",null,"",null,false],[25,970,0,null,null," Returns true if all elements in a slice are equal to the scalar value provided",[3608,3609,3610],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"scalar",null,"",null,false],[25,978,0,null,null," Remove a set of values from the beginning of a slice.",[3612,3613,3614],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"values_to_strip",null,"",null,false],[25,985,0,null,null," Remove a set of values from the end of a slice.",[3616,3617,3618],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"values_to_strip",null,"",null,false],[25,992,0,null,null," Remove a set of values from the beginning and end of a slice.",[3620,3621,3622],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"values_to_strip",null,"",null,false],[25,1008,0,null,null," Linear search for the index of a scalar value inside a slice.",[3624,3625,3626],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1013,0,null,null," Linear search for the last index of a scalar value inside a slice.",[3628,3629,3630],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1022,0,null,null,null,[3632,3633,3634,3635],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1030,0,null,null,null,[3637,3638,3639],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"values",null,"",null,false],[25,1034,0,null,null,null,[3641,3642,3643],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"values",null,"",null,false],[25,1045,0,null,null,null,[3645,3646,3647,3648],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[0,0,0,"values",null,"",null,false],[25,1058,0,null,null," Find the first item in `slice` which is not contained in `values`.\n\n Comparable to `strspn` in the C standard library.",[3650,3651,3652],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"values",null,"",null,false],[25,1065,0,null,null," Find the last item in `slice` which is not contained in `values`.\n\n Like `strspn` in the C standard library, but searches from the end.",[3654,3655,3656],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"values",null,"",null,false],[25,1081,0,null,null," Find the first item in `slice[start_index..]` which is not contained in `values`.\n The returned index will be relative to the start of `slice`, and never less than `start_index`.\n\n Comparable to `strspn` in the C standard library.",[3658,3659,3660,3661],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[0,0,0,"values",null,"",null,false],[25,1103,0,null,null,null,[3663,3664,3665],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,1111,0,null,null," Find the index in a slice of a sub-slice, searching from the end backwards.\n To start looking at a different index, slice the haystack first.\n Consider using `lastIndexOf` instead of this, which will automatically use a\n more sophisticated algorithm on larger inputs.",[3667,3668,3669],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,1121,0,null,null," Consider using `indexOfPos` instead of this, which will automatically use a\n more sophisticated algorithm on larger inputs.",[3671,3672,3673,3674],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,1130,0,null,null,null,[3676,3677],false],[0,0,0,"pattern",null,"",null,false],[0,0,0,"table",null,"",null,false],[25,1143,0,null,null,null,[3679,3680],false],[0,0,0,"pattern",null,"",null,false],[0,0,0,"table",null,"",null,false],[25,1160,0,null,null," Find the index in a slice of a sub-slice, searching from the end backwards.\n To start looking at a different index, slice the haystack first.\n Uses the Reverse Boyer-Moore-Horspool algorithm on large inputs;\n `lastIndexOfLinear` on small inputs.",[3682,3683,3684],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,1187,0,null,null," Uses Boyer-Moore-Horspool algorithm on large inputs; `indexOfPosLinear` on small inputs.",[3686,3687,3688,3689],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,1271,0,null,null," Returns the number of needles inside the haystack\n needle.len must be > 0\n does not count overlapping needles",[3691,3692,3693],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,1301,0,null,null," Returns true if the haystack contains expected_count or more needles\n needle.len must be > 0\n does not count overlapping needles",[3695,3696,3697,3698],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"expected_count",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,1335,0,null,null," Reads an integer from memory with size equal to bytes.len.\n T specifies the return type, which must be large enough to store\n the result.",[3700,3701,3702],false],[0,0,0,"ReturnType",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1361,0,null,null," Loads an integer from packed memory with provided bit_count, bit_offset, and signedness.\n Asserts that T is large enough to store the read value.\n\n Example:\n     const T = packed struct(u16){ a: u3, b: u7, c: u6 };\n     var st = T{ .a = 1, .b = 2, .c = 4 };\n     const b_field = readVarPackedInt(u64, std.mem.asBytes(&st), @bitOffsetOf(T, \"b\"), 7, builtin.cpu.arch.endian(), .unsigned);\n",[3704,3705,3706,3707,3708,3709],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"bit_count",null,"",null,false],[0,0,0,"endian",null,"",null,false],[0,0,0,"signedness",null,"",null,false],[25,1428,0,null,null," Reads an integer from memory with bit count specified by T.\n The bit count of T must be evenly divisible by 8.\n This function cannot fail and cannot cause undefined behavior.\n Assumes the endianness of memory is native. This means the function can\n simply pointer cast memory.",[3711,3712],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[25,1436,0,null,null," Reads an integer from memory with bit count specified by T.\n The bit count of T must be evenly divisible by 8.\n This function cannot fail and cannot cause undefined behavior.\n Assumes the endianness of memory is foreign, so it must byte-swap.",[3714,3715],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[25,1440,0,null,null,null,null,false],[25,1445,0,null,null,null,null,false],[25,1455,0,null,null," Asserts that bytes.len >= @typeInfo(T).Int.bits / 8. Reads the integer starting from index 0\n and ignores extra bytes.\n The bit count of T must be evenly divisible by 8.\n Assumes the endianness of memory is native. This means the function can\n simply pointer cast memory.",[3719,3720],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[25,1465,0,null,null," Asserts that bytes.len >= @typeInfo(T).Int.bits / 8. Reads the integer starting from index 0\n and ignores extra bytes.\n The bit count of T must be evenly divisible by 8.\n Assumes the endianness of memory is foreign, so it must byte-swap.",[3722,3723],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[25,1469,0,null,null,null,null,false],[25,1474,0,null,null,null,null,false],[25,1482,0,null,null," Reads an integer from memory with bit count specified by T.\n The bit count of T must be evenly divisible by 8.\n This function cannot fail and cannot cause undefined behavior.",[3727,3728,3729],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1490,0,null,null,null,[3731,3732,3733],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[25,1516,0,null,null,null,[3735,3736,3737],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[25,1543,0,null,null,null,null,false],[25,1548,0,null,null,null,null,false],[25,1561,0,null,null," Loads an integer from packed memory.\n Asserts that buffer contains at least bit_offset + @bitSizeOf(T) bits.\n\n Example:\n     const T = packed struct(u16){ a: u3, b: u7, c: u6 };\n     var st = T{ .a = 1, .b = 2, .c = 4 };\n     const b_field = readPackedInt(u7, std.mem.asBytes(&st), @bitOffsetOf(T, \"b\"), builtin.cpu.arch.endian());\n",[3741,3742,3743,3744],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1571,0,null,null," Asserts that bytes.len >= @typeInfo(T).Int.bits / 8. Reads the integer starting from index 0\n and ignores extra bytes.\n The bit count of T must be evenly divisible by 8.",[3746,3747,3748],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1619,0,null,null," Writes an integer to memory, storing it in twos-complement.\n This function always succeeds, has defined behavior for all inputs, and\n accepts any integer bit width.\n This function stores in native endian, which means it is implemented as a simple\n memory store.",[3750,3751,3752],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buf",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1627,0,null,null," Writes an integer to memory, storing it in twos-complement.\n This function always succeeds, has defined behavior for all inputs, but\n the integer bit width must be divisible by 8.\n This function stores in foreign endian, which means it does a @byteSwap first.",[3754,3755,3756],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buf",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1631,0,null,null,null,null,false],[25,1636,0,null,null,null,null,false],[25,1644,0,null,null," Writes an integer to memory, storing it in twos-complement.\n This function always succeeds, has defined behavior for all inputs, but\n the integer bit width must be divisible by 8.",[3760,3761,3762,3763],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1652,0,null,null,null,[3765,3766,3767,3768],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1685,0,null,null,null,[3770,3771,3772,3773],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1720,0,null,null,null,null,false],[25,1725,0,null,null,null,null,false],[25,1739,0,null,null," Stores an integer to packed memory.\n Asserts that buffer contains at least bit_offset + @bitSizeOf(T) bits.\n\n Example:\n     const T = packed struct(u16){ a: u3, b: u7, c: u6 };\n     var st = T{ .a = 1, .b = 2, .c = 4 };\n     // st.b = 0x7f;\n     writePackedInt(u7, std.mem.asBytes(&st), @bitOffsetOf(T, \"b\"), 0x7f, builtin.cpu.arch.endian());\n",[3777,3778,3779,3780,3781],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1752,0,null,null," Writes a twos-complement little-endian integer to memory.\n Asserts that buf.len >= @typeInfo(T).Int.bits / 8.\n The bit count of T must be divisible by 8.\n Any extra bytes in buffer after writing the integer are set to zero. To\n avoid the branch to check for extra buffer bytes, use writeIntLittle\n instead.",[3783,3784,3785],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1776,0,null,null," Writes a twos-complement big-endian integer to memory.\n Asserts that buffer.len >= @typeInfo(T).Int.bits / 8.\n The bit count of T must be divisible by 8.\n Any extra bytes in buffer before writing the integer are set to zero. To\n avoid the branch to check for extra buffer bytes, use writeIntBig instead.",[3787,3788,3789],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"value",null,"",null,false],[25,1798,0,null,null,null,null,false],[25,1803,0,null,null,null,null,false],[25,1814,0,null,null," Writes a twos-complement integer to memory, with the specified endianness.\n Asserts that buf.len >= @typeInfo(T).Int.bits / 8.\n The bit count of T must be evenly divisible by 8.\n Any extra bytes in buffer not part of the integer are set to zero, with\n respect to endianness. To avoid the branch to check for extra buffer bytes,\n use writeInt instead.",[3793,3794,3795,3796],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1832,0,null,null," Stores an integer to packed memory with provided bit_count, bit_offset, and signedness.\n If negative, the written value is sign-extended.\n\n Example:\n     const T = packed struct(u16){ a: u3, b: u7, c: u6 };\n     var st = T{ .a = 1, .b = 2, .c = 4 };\n     // st.b = 0x7f;\n     var value: u64 = 0x7f;\n     writeVarPackedInt(std.mem.asBytes(&st), @bitOffsetOf(T, \"b\"), 7, value, builtin.cpu.arch.endian());\n",[3798,3799,3800,3801,3802],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"bit_count",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"endian",null,"",null,false],[25,1925,0,null,null," Swap the byte order of all the members of the fields of a struct\n (Changing their endianness)",[3804,3805],false],[0,0,0,"S",null,"",null,true],[0,0,0,"ptr",null,"",null,false],[25,1972,0,null,null," Deprecated: use `tokenizeAny`, `tokenizeSequence`, or `tokenizeScalar`",null,false],[25,1987,0,null,null," Returns an iterator that iterates over the slices of `buffer` that are not\n any of the items in `delimiters`.\n\n `tokenizeAny(u8, \"   abc|def ||  ghi  \", \" |\")` will return slices\n for \"abc\", \"def\", \"ghi\", null, in that order.\n\n If `buffer` is empty, the iterator will return null.\n If none of `delimiters` exist in buffer,\n the iterator will return `buffer`, null, in that order.\n\n See also: `tokenizeSequence`, `tokenizeScalar`,\n           `splitSequence`,`splitAny`, `splitScalar`,\n           `splitBackwardsSequence`, `splitBackwardsAny`, and `splitBackwardsScalar`",[3808,3809,3810],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiters",null,"",null,false],[25,2009,0,null,null," Returns an iterator that iterates over the slices of `buffer` that are not\n the sequence in `delimiter`.\n\n `tokenizeSequence(u8, \"<>abc><def<><>ghi\", \"<>\")` will return slices\n for \"abc><def\", \"ghi\", null, in that order.\n\n If `buffer` is empty, the iterator will return null.\n If `delimiter` does not exist in buffer,\n the iterator will return `buffer`, null, in that order.\n The delimiter length must not be zero.\n\n See also: `tokenizeAny`, `tokenizeScalar`,\n           `splitSequence`,`splitAny`, and `splitScalar`\n           `splitBackwardsSequence`, `splitBackwardsAny`, and `splitBackwardsScalar`",[3812,3813,3814],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiter",null,"",null,false],[25,2031,0,null,null," Returns an iterator that iterates over the slices of `buffer` that are not\n `delimiter`.\n\n `tokenizeScalar(u8, \"   abc def     ghi  \", ' ')` will return slices\n for \"abc\", \"def\", \"ghi\", null, in that order.\n\n If `buffer` is empty, the iterator will return null.\n If `delimiter` does not exist in buffer,\n the iterator will return `buffer`, null, in that order.\n\n See also: `tokenizeAny`, `tokenizeSequence`,\n           `splitSequence`,`splitAny`, and `splitScalar`\n           `splitBackwardsSequence`, `splitBackwardsAny`, and `splitBackwardsScalar`",[3816,3817,3818],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiter",null,"",null,false],[25,2173,0,null,null," Deprecated: use `splitSequence`, `splitAny`, or `splitScalar`",null,false],[25,2188,0,null,null," Returns an iterator that iterates over the slices of `buffer` that\n are separated by the byte sequence in `delimiter`.\n\n `splitSequence(u8, \"abc||def||||ghi\", \"||\")` will return slices\n for \"abc\", \"def\", \"\", \"ghi\", null, in that order.\n\n If `delimiter` does not exist in buffer,\n the iterator will return `buffer`, null, in that order.\n The delimiter length must not be zero.\n\n See also: `splitAny`, `splitScalar`, `splitBackwardsSequence`,\n           `splitBackwardsAny`,`splitBackwardsScalar`,\n           `tokenizeAny`, `tokenizeSequence`, and `tokenizeScalar`.",[3821,3822,3823],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiter",null,"",null,false],[25,2209,0,null,null," Returns an iterator that iterates over the slices of `buffer` that\n are separated by any item in `delimiters`.\n\n `splitAny(u8, \"abc,def||ghi\", \"|,\")` will return slices\n for \"abc\", \"def\", \"\", \"ghi\", null, in that order.\n\n If none of `delimiters` exist in buffer,\n the iterator will return `buffer`, null, in that order.\n\n See also: `splitSequence`, `splitScalar`, `splitBackwardsSequence`,\n           `splitBackwardsAny`,`splitBackwardsScalar`,\n           `tokenizeAny`, `tokenizeSequence`, and `tokenizeScalar`.",[3825,3826,3827],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiters",null,"",null,false],[25,2229,0,null,null," Returns an iterator that iterates over the slices of `buffer` that\n are separated by `delimiter`.\n\n `splitScalar(u8, \"abc|def||ghi\", '|')` will return slices\n for \"abc\", \"def\", \"\", \"ghi\", null, in that order.\n\n If `delimiter` does not exist in buffer,\n the iterator will return `buffer`, null, in that order.\n\n See also: `splitSequence`, `splitAny`, `splitBackwardsSequence`,\n           `splitBackwardsAny`,`splitBackwardsScalar`,\n           `tokenizeAny`, `tokenizeSequence`, and `tokenizeScalar`.",[3829,3830,3831],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiter",null,"",null,false],[25,2375,0,null,null," Deprecated: use `splitBackwardsSequence`, `splitBackwardsAny`, or `splitBackwardsScalar`",null,false],[25,2390,0,null,null," Returns an iterator that iterates backwards over the slices of `buffer` that\n are separated by the sequence in `delimiter`.\n\n `splitBackwardsSequence(u8, \"abc||def||||ghi\", \"||\")` will return slices\n for \"ghi\", \"\", \"def\", \"abc\", null, in that order.\n\n If `delimiter` does not exist in buffer,\n the iterator will return `buffer`, null, in that order.\n The delimiter length must not be zero.\n\n See also: `splitBackwardsAny`, `splitBackwardsScalar`,\n           `splitSequence`, `splitAny`,`splitScalar`,\n           `tokenizeAny`, `tokenizeSequence`, and `tokenizeScalar`.",[3834,3835,3836],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiter",null,"",null,false],[25,2411,0,null,null," Returns an iterator that iterates backwards over the slices of `buffer` that\n are separated by any item in `delimiters`.\n\n `splitBackwardsAny(u8, \"abc,def||ghi\", \"|,\")` will return slices\n for \"ghi\", \"\", \"def\", \"abc\", null, in that order.\n\n If none of `delimiters` exist in buffer,\n the iterator will return `buffer`, null, in that order.\n\n See also: `splitBackwardsSequence`, `splitBackwardsScalar`,\n           `splitSequence`, `splitAny`,`splitScalar`,\n           `tokenizeAny`, `tokenizeSequence`, and `tokenizeScalar`.",[3838,3839,3840],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiters",null,"",null,false],[25,2431,0,null,null," Returns an iterator that iterates backwards over the slices of `buffer` that\n are separated by `delimiter`.\n\n `splitBackwardsScalar(u8, \"abc|def||ghi\", '|')` will return slices\n for \"ghi\", \"\", \"def\", \"abc\", null, in that order.\n\n If `delimiter` does not exist in buffer,\n the iterator will return `buffer`, null, in that order.\n\n See also: `splitBackwardsSequence`, `splitBackwardsAny`,\n           `splitSequence`, `splitAny`,`splitScalar`,\n           `tokenizeAny`, `tokenizeSequence`, and `tokenizeScalar`.",[3842,3843,3844],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"delimiter",null,"",null,false],[25,2607,0,null,null," Returns an iterator with a sliding window of slices for `buffer`.\n The sliding window has length `size` and on every iteration moves\n forward by `advance`.\n\n Extract data for moving average with:\n `window(u8, \"abcdefg\", 3, 1)` will return slices\n \"abc\", \"bcd\", \"cde\", \"def\", \"efg\", null, in that order.\n\n Chunk or split every N items with:\n `window(u8, \"abcdefg\", 3, 3)` will return slices\n \"abc\", \"def\", \"g\", null, in that order.\n\n Pick every even index with:\n `window(u8, \"abcdefg\", 1, 2)` will return slices\n \"a\", \"c\", \"e\", \"g\" null, in that order.\n\n The `size` and `advance` must be not be zero.",[3846,3847,3848,3849],false],[0,0,0,"T",null,"",null,true],[0,0,0,"buffer",null,"",null,false],[0,0,0,"size",null,"",null,false],[0,0,0,"advance",null,"",null,false],[25,2701,0,null,null,null,[3851],false],[0,0,0,"T",null,"",[3860,3862,3863,3864],true],[25,2708,0,null,null,null,null,false],[25,2713,0,null,null," Returns a slice of the first window. This never fails.\n Call this only to get the first window and then use `next` to get\n all subsequent windows.",[3854],false],[0,0,0,"self",null,"",null,false],[25,2719,0,null,null," Returns a slice of the next window, or null if window is at end.",[3856],false],[0,0,0,"self",null,"",null,false],[25,2734,0,null,null," Resets the iterator to the initial window.",[3858],false],[0,0,0,"self",null,"",null,false],[25,2702,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[25,2702,0,null,null,null,null,false],[0,0,0,"index",null,null,null,false],[0,0,0,"size",null,null,null,false],[0,0,0,"advance",null,null,null,false],[25,2740,0,null,null,null,[3866,3867,3868],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,2749,0,null,null,null,[3870,3871,3872],false],[0,0,0,"T",null,"",null,true],[0,0,0,"haystack",null,"",null,false],[0,0,0,"needle",null,"",null,false],[25,2758,0,null,null,null,[3874,3875,3876],false],[0,0,0,"sequence",null,null,null,false],[0,0,0,"any",null,null,null,false],[0,0,0,"scalar",null,null,null,false],[25,2760,0,null,null,null,[3878,3879],false],[0,0,0,"T",null,"",null,true],[0,0,0,"delimiter_type",null,"",[3893,3895,3896],true],[25,2769,0,null,null,null,null,false],[25,2773,0,null,null," Returns a slice of the current token, or null if tokenization is\n complete, and advances to the next token.",[3882],false],[0,0,0,"self",null,"",null,false],[25,2781,0,null,null," Returns a slice of the current token, or null if tokenization is\n complete. Does not advance to the next token.",[3884],false],[0,0,0,"self",null,"",null,false],[25,2800,0,null,null," Returns a slice of the remaining bytes. Does not affect iterator state.",[3886],false],[0,0,0,"self",null,"",null,false],[25,2811,0,null,null," Resets the iterator to the initial token.",[3888],false],[0,0,0,"self",null,"",null,false],[25,2815,0,null,null,null,[3890,3891],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[25,2761,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[25,2761,0,null,null,null,null,false],[0,0,0,"delimiter",null,null,null,false],[0,0,0,"index",null,null,null,false],[25,2833,0,null,null,null,[3898,3899],false],[0,0,0,"T",null,"",null,true],[0,0,0,"delimiter_type",null,"",[3912,3914,3916],true],[25,2842,0,null,null,null,null,false],[25,2846,0,null,null," Returns a slice of the first field. This never fails.\n Call this only to get the first field and then use `next` to get all subsequent fields.",[3902],false],[0,0,0,"self",null,"",null,false],[25,2852,0,null,null," Returns a slice of the next field, or null if splitting is complete.",[3904],false],[0,0,0,"self",null,"",null,false],[25,2873,0,null,null," Returns a slice of the next field, or null if splitting is complete.\n This method does not alter self.index.",[3906],false],[0,0,0,"self",null,"",null,false],[25,2884,0,null,null," Returns a slice of the remaining bytes. Does not affect iterator state.",[3908],false],[0,0,0,"self",null,"",null,false],[25,2891,0,null,null," Resets the iterator to the initial slice.",[3910],false],[0,0,0,"self",null,"",null,false],[25,2834,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[25,2834,0,null,null,null,null,false],[0,0,0,"index",null,null,null,false],[25,2834,0,null,null,null,null,false],[0,0,0,"delimiter",null,null,null,false],[25,2897,0,null,null,null,[3918,3919],false],[0,0,0,"T",null,"",null,true],[0,0,0,"delimiter_type",null,"",[3930,3932,3934],true],[25,2906,0,null,null,null,null,false],[25,2910,0,null,null," Returns a slice of the first field. This never fails.\n Call this only to get the first field and then use `next` to get all subsequent fields.",[3922],false],[0,0,0,"self",null,"",null,false],[25,2916,0,null,null," Returns a slice of the next field, or null if splitting is complete.",[3924],false],[0,0,0,"self",null,"",null,false],[25,2936,0,null,null," Returns a slice of the remaining bytes. Does not affect iterator state.",[3926],false],[0,0,0,"self",null,"",null,false],[25,2942,0,null,null," Resets the iterator to the initial slice.",[3928],false],[0,0,0,"self",null,"",null,false],[25,2898,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[25,2898,0,null,null,null,null,false],[0,0,0,"index",null,null,null,false],[25,2898,0,null,null,null,null,false],[0,0,0,"delimiter",null,null,null,false],[25,2950,0,null,null," Naively combines a series of slices with a separator.\n Allocates memory for the result, which must be freed by the caller.",[3936,3937,3938],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"separator",null,"",null,false],[0,0,0,"slices",null,"",null,false],[25,2956,0,null,null," Naively combines a series of slices with a separator and null terminator.\n Allocates memory for the result, which must be freed by the caller.",[3940,3941,3942],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"separator",null,"",null,false],[0,0,0,"slices",null,"",null,false],[25,2961,0,null,null,null,[3944,3945,3946,3947],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"separator",null,"",null,false],[0,0,0,"slices",null,"",null,false],[0,0,0,"zero",null,"",null,false],[25,3040,0,null,null," Copies each T from slices into a new slice that exactly holds all the elements.",[3949,3950,3951],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"slices",null,"",null,false],[25,3045,0,null,null," Copies each T from slices into a new slice that exactly holds all the elements.",[3953,3954,3955,3956],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"slices",null,"",null,false],[0,0,0,"s",null,"",null,true],[25,3051,0,null,null," Copies each T from slices into a new slice that exactly holds all the elements as well as the sentinel.",[3958,3959,3960,3961],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"slices",null,"",null,false],[0,0,0,"s",null,"",null,true],[25,3132,0,null,null,null,[],false],[25,3183,0,null,null,null,[],false],[25,3321,0,null,null," Returns the smallest number in a slice. O(n).\n `slice` must not be empty.",[3965,3966],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[25,3338,0,null,null," Returns the largest number in a slice. O(n).\n `slice` must not be empty.",[3968,3969],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[25,3356,0,null,null," Finds the smallest and largest number in a slice. O(n).\n Returns an anonymous struct with the fields `min` and `max`.\n `slice` must not be empty.",[3971,3972],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",[3974,3976],false],[25,3356,0,null,null,null,null,false],[0,0,0,"min",null,null,null,false],[25,3356,0,null,null,null,null,false],[0,0,0,"max",null,null,null,false],[25,3375,0,null,null," Returns the index of the smallest number in a slice. O(n).\n `slice` must not be empty.",[3978,3979],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[25,3396,0,null,null," Returns the index of the largest number in a slice. O(n).\n `slice` must not be empty.",[3981,3982],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[25,3418,0,null,null," Finds the indices of the smallest and largest number in a slice. O(n).\n Returns an anonymous struct with the fields `index_min` and `index_max`.\n `slice` must not be empty.",[3984,3985],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",[3986,3987],false],[0,0,0,"index_min",null,null,null,false],[0,0,0,"index_max",null,null,null,false],[25,3443,0,null,null,null,[3989,3990,3991],false],[0,0,0,"T",null,"",null,true],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[25,3450,0,null,null," In-place order reversal of a slice",[3993,3994],false],[0,0,0,"T",null,"",null,true],[0,0,0,"items",null,"",null,false],[25,3465,0,null,null,null,[3996],false],[0,0,0,"T",null,"",[4002,4003],true],[25,3495,0,null,null,null,[3998],false],[0,0,0,"self",null,"",null,false],[25,3500,0,null,null,null,[4000],false],[0,0,0,"self",null,"",null,false],[25,3492,0,null,null,null,null,false],[0,0,0,"ptr",null,null,null,false],[0,0,0,"index",null,null,null,false],[25,3509,0,null,null," Iterates over a slice in reverse.",[4005],false],[0,0,0,"slice",null,"",null,false],[25,3571,0,null,null," In-place rotation of the values in an array ([0 1 2 3] becomes [1 2 3 0] if we rotate by 1)\n Assumes 0 <= amount <= items.len",[4007,4008,4009],false],[0,0,0,"T",null,"",null,true],[0,0,0,"items",null,"",null,false],[0,0,0,"amount",null,"",null,false],[25,3588,0,null,null," Replace needle with replacement as many times as possible, writing to an output buffer which is assumed to be of\n appropriate size. Use replacementSize to calculate an appropriate buffer size.\n The needle must not be empty.\n Returns the number of replacements made.",[4011,4012,4013,4014,4015],false],[0,0,0,"T",null,"",null,true],[0,0,0,"input",null,"",null,false],[0,0,0,"needle",null,"",null,false],[0,0,0,"replacement",null,"",null,false],[0,0,0,"output",null,"",null,false],[25,3643,0,null,null," Replace all occurrences of `needle` with `replacement`.",[4017,4018,4019,4020],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"needle",null,"",null,false],[0,0,0,"replacement",null,"",null,false],[25,3652,0,null,null," Collapse consecutive duplicate elements into one entry.",[4022,4023,4024],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"elem",null,"",null,false],[25,3666,0,null,null," Collapse consecutive duplicate elements into one entry.",[4026,4027,4028],false],[0,0,0,"T",null,"",null,true],[0,0,0,"slice",null,"",null,false],[0,0,0,"elem",null,"",null,false],[25,3670,0,null,null,null,[4030,4031,4032],false],[0,0,0,"str",null,"",null,false],[0,0,0,"elem",null,"",null,false],[0,0,0,"expected",null,"",null,false],[25,3691,0,null,null," Calculate the size needed in an output buffer to perform a replacement.\n The needle must not be empty.",[4034,4035,4036,4037],false],[0,0,0,"T",null,"",null,true],[0,0,0,"input",null,"",null,false],[0,0,0,"needle",null,"",null,false],[0,0,0,"replacement",null,"",null,false],[25,3723,0,null,null," Perform a replacement on an allocated buffer of pre-determined size. Caller must free returned memory.",[4039,4040,4041,4042,4043],false],[0,0,0,"T",null,"",null,true],[0,0,0,"allocator",null,"",null,false],[0,0,0,"input",null,"",null,false],[0,0,0,"needle",null,"",null,false],[0,0,0,"replacement",null,"",null,false],[25,3742,0,null,null," Converts a little-endian integer to host endianness.",[4045,4046],false],[0,0,0,"T",null,"",null,true],[0,0,0,"x",null,"",null,false],[25,3750,0,null,null," Converts a big-endian integer to host endianness.",[4048,4049],false],[0,0,0,"T",null,"",null,true],[0,0,0,"x",null,"",null,false],[25,3758,0,null,null," Converts an integer from specified endianness to host endianness.",[4051,4052,4053],false],[0,0,0,"T",null,"",null,true],[0,0,0,"x",null,"",null,false],[0,0,0,"endianness_of_x",null,"",null,false],[25,3766,0,null,null," Converts an integer which has host endianness to the desired endianness.",[4055,4056,4057],false],[0,0,0,"T",null,"",null,true],[0,0,0,"x",null,"",null,false],[0,0,0,"desired_endianness",null,"",null,false],[25,3774,0,null,null," Converts an integer which has host endianness to little endian.",[4059,4060],false],[0,0,0,"T",null,"",null,true],[0,0,0,"x",null,"",null,false],[25,3782,0,null,null," Converts an integer which has host endianness to big endian.",[4062,4063],false],[0,0,0,"T",null,"",null,true],[0,0,0,"x",null,"",null,false],[25,3795,0,null,null," Returns the number of elements that, if added to the given pointer, align it\n to a multiple of the given quantity, or `null` if one of the following\n conditions is met:\n - The aligned pointer would not fit the address space,\n - The delta required to align the pointer is not a multiple of the pointee's\n   type.",[4065,4066],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"align_to",null,"",null,false],[25,3827,0,null,null," Aligns a given pointer value to a specified alignment factor.\n Returns an aligned pointer or null if one of the following conditions is\n met:\n - The aligned pointer would not fit the address space,\n - The delta required to align the pointer is not a multiple of the pointee's\n   type.",[4068,4069],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"align_to",null,"",null,false],[25,3852,0,null,null,null,[4071,4072,4073],false],[0,0,0,"source",null,"",null,true],[0,0,0,"size",null,"",null,true],[0,0,0,"child",null,"",null,true],[25,3872,0,null,null,null,[4075],false],[0,0,0,"P",null,"",null,true],[25,3882,0,null,null," Given a pointer to a single item, returns a slice of the underlying bytes, preserving pointer attributes.",[4077],false],[0,0,0,"ptr",null,"",null,false],[25,3942,0,null,null," Given any value, returns a copy of its bytes in an array.",[4079],false],[0,0,0,"value",null,"",null,false],[25,3960,0,null,null,null,[4081,4082],false],[0,0,0,"T",null,"",null,true],[0,0,0,"B",null,"",null,true],[25,3974,0,null,null," Given a pointer to an array of bytes, returns a pointer to a value of the specified type\n backed by those bytes, preserving pointer attributes.",[4084,4085],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[25,4034,0,null,null," Given a pointer to an array of bytes, returns a value of the specified type backed by a\n copy of those bytes.",[4087,4088],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[25,4047,0,null,null,null,[4090,4091],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytesType",null,"",null,true],[25,4061,0,null,null," Given a slice of bytes, returns a slice of the specified type\n backed by those bytes, preserving pointer attributes.",[4093,4094],false],[0,0,0,"T",null,"",null,true],[0,0,0,"bytes",null,"",null,false],[25,4140,0,null,null,null,[4096],false],[0,0,0,"sliceType",null,"",null,true],[25,4149,0,null,null," Given a slice, returns a slice of the underlying bytes, preserving pointer attributes.",[4098],false],[0,0,0,"slice",null,"",null,false],[25,4239,0,null,null," Round an address up to the next (or current) aligned address.\n The alignment must be a power of 2 and greater than 0.\n Asserts that rounding up the address does not cause integer overflow.",[4100,4101,4102],false],[0,0,0,"T",null,"",null,true],[0,0,0,"addr",null,"",null,false],[0,0,0,"alignment",null,"",null,false],[25,4244,0,null,null,null,[4104,4105],false],[0,0,0,"addr",null,"",null,false],[0,0,0,"log2_alignment",null,"",null,false],[25,4249,0,null,null,null,null,false],[25,4255,0,null,null," Force an evaluation of the expression; this tries to prevent\n the compiler from optimizing the computation away even if the\n result eventually gets discarded.",[4108],false],[0,0,0,"val",null,"",null,false],[25,4307,0,null,null," .stage2_c doesn't support asm blocks yet, so use volatile stores instead",null,false],[25,4308,0,null,null,null,[4111],false],[0,0,0,"ptr",null,"",null,false],[25,4358,0,null,null," Round an address down to the previous (or current) aligned address.\n Unlike `alignBackward`, `alignment` can be any positive number, not just a power of 2.",[4113,4114],false],[0,0,0,"i",null,"",null,false],[0,0,0,"alignment",null,"",null,false],[25,4367,0,null,null," Round an address down to the previous (or current) aligned address.\n The alignment must be a power of 2 and greater than 0.",[4116,4117,4118],false],[0,0,0,"T",null,"",null,true],[0,0,0,"addr",null,"",null,false],[0,0,0,"alignment",null,"",null,false],[25,4375,0,null,null,null,null,false],[25,4379,0,null,null," Returns whether `alignment` is a valid alignment, meaning it is\n a positive power of 2.",[4121],false],[0,0,0,"alignment",null,"",null,false],[25,4385,0,null,null," Returns whether `alignment` is a valid alignment, meaning it is\n a positive power of 2.",[4123,4124],false],[0,0,0,"T",null,"",null,true],[0,0,0,"alignment",null,"",null,false],[25,4389,0,null,null,null,[4126,4127],false],[0,0,0,"i",null,"",null,false],[0,0,0,"alignment",null,"",null,false],[25,4396,0,null,null,null,[4129,4130],false],[0,0,0,"addr",null,"",null,false],[0,0,0,"log2_alignment",null,"",null,false],[25,4402,0,null,null," Given an address and an alignment, return true if the address is a multiple of the alignment\n The alignment must be a power of 2 and greater than 0.",[4132,4133],false],[0,0,0,"addr",null,"",null,false],[0,0,0,"alignment",null,"",null,false],[25,4406,0,null,null,null,[4135,4136,4137],false],[0,0,0,"T",null,"",null,true],[0,0,0,"addr",null,"",null,false],[0,0,0,"alignment",null,"",null,false],[25,4433,0,null,null," Returns a slice with the given new alignment,\n all other pointer attributes copied from `AttributeSource`.",[4139,4140],false],[0,0,0,"AttributeSource",null,"",null,true],[0,0,0,"new_alignment",null,"",null,true],[25,4451,0,null,null," Returns the largest slice in the given bytes that conforms to the new alignment,\n or `null` if the given bytes contain no conforming address.",[4142,4143],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"new_alignment",null,"",null,true],[25,4465,0,null,null," Returns the largest sub-slice within the given slice that conforms to the new alignment,\n or `null` if the given slice contains no conforming address.",[4145,4146],false],[0,0,0,"slice",null,"",null,false],[0,0,0,"new_alignment",null,"",null,true],[25,3179,0,"writeIntSlice","test writeIntSlice {\n    try testWriteIntImpl();\n    try comptime testWriteIntImpl();\n}",null,null,false],[24,3,0,null,null,null,null,false],[24,4,0,null,null,null,null,false],[24,9,0,null,null," A BufSet is a set of strings.  The BufSet duplicates\n strings internally, and never takes ownership of strings\n which are passed to it.",[4184],false],[24,12,0,null,null,null,null,false],[24,13,0,null,null,null,null,false],[24,18,0,null,null," Create a BufSet using an allocator.  The allocator will\n be used internally for both backing allocations and\n string duplication.",[4154],false],[0,0,0,"a",null,"",null,false],[24,24,0,null,null," Free a BufSet along with all stored keys.",[4156],false],[0,0,0,"self",null,"",null,false],[24,36,0,null,null," Insert an item into the BufSet.  The item will be\n copied, so the caller may delete or reuse the\n passed string immediately.",[4158,4159],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[24,47,0,null,null," Check if the set contains an item matching the passed string",[4161,4162],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[24,52,0,null,null," Remove an item from the set.",[4164,4165],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[24,58,0,null,null," Returns the number of items stored in the set",[4167],false],[0,0,0,"self",null,"",null,false],[24,64,0,null,null," Returns an iterator over the items stored in the set.\n Iteration order is arbitrary.",[4169],false],[0,0,0,"self",null,"",null,false],[24,69,0,null,null," Get the allocator used by this set",[4171],false],[0,0,0,"self",null,"",null,false],[24,74,0,null,null," Creates a copy of this BufSet, using a specified allocator.",[4173,4174],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_allocator",null,"",null,false],[24,89,0,null,null," Creates a copy of this BufSet, using the same allocator.",[4176],false],[0,0,0,"self",null,"",null,false],[24,93,0,null,null,null,[4178,4179],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[24,97,0,null,null,null,[4181,4182],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[24,9,0,null,null,null,null,false],[0,0,0,"hash_map",null,null,null,false],[0,17,0,null,null," Deprecated: use `process.Child`.",null,false],[0,0,0,"child_process.zig",null,"",[],false],[27,0,0,null,null,null,null,false],[27,1,0,null,null,null,null,false],[27,2,0,null,null,null,null,false],[27,3,0,null,null,null,null,false],[27,4,0,null,null,null,null,false],[27,5,0,null,null,null,null,false],[27,6,0,null,null,null,null,false],[27,7,0,null,null,null,null,false],[27,8,0,null,null,null,null,false],[27,9,0,null,null,null,null,false],[27,10,0,null,null,null,null,false],[27,11,0,null,null,null,null,false],[27,12,0,null,null,null,null,false],[27,13,0,null,null,null,null,false],[27,14,0,null,null,null,null,false],[27,15,0,null,null,null,null,false],[27,16,0,null,null,null,null,false],[27,17,0,null,null,null,null,false],[27,19,0,null,null,null,[4302,4304,4306,4308,4310,4312,4314,4316,4318,4320,4322,4324,4326,4328,4330,4332,4334,4336,4337,4338,4339,4341],false],[27,20,0,null,null,null,null,false],[27,85,0,null,null,null,[4212],false],[27,90,0,null,null," Returns the peak resident set size of the child process, in bytes,\n if available.",[4209],false],[0,0,0,"rus",null,"",null,false],[27,118,0,null,null,null,null,false],[27,85,0,null,null,null,null,false],[0,0,0,"rusage",null,null,null,false],[27,125,0,null,null,null,null,false],[27,127,0,null,null,null,null,false],[27,148,0,null,null,null,[4216,4217,4218,4219],false],[0,0,0,"Exited",null,null,null,false],[0,0,0,"Signal",null,null,null,false],[0,0,0,"Stopped",null,null,null,false],[0,0,0,"Unknown",null,null,null,false],[27,155,0,null,null,null,[4221,4222,4223,4224],false],[0,0,0,"Inherit",null,null,null,false],[0,0,0,"Ignore",null,null,null,false],[0,0,0,"Pipe",null,null,null,false],[0,0,0,"Close",null,null,null,false],[27,163,0,null,null," First argument in argv is the executable.",[4226,4227],false],[0,0,0,"argv",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[27,185,0,null,null,null,[4229,4230],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[27,193,0,null,null," On success must call `kill` or `wait`.\n After spawning the `id` is available.",[4232],false],[0,0,0,"self",null,"",null,false],[27,205,0,null,null,null,[4234],false],[0,0,0,"self",null,"",null,false],[27,211,0,null,null," Forcibly terminates child process and then cleans up all resources.",[4236],false],[0,0,0,"self",null,"",null,false],[27,219,0,null,null,null,[4238,4239],false],[0,0,0,"self",null,"",null,false],[0,0,0,"exit_code",null,"",null,false],[27,230,0,null,null,null,[4241],false],[0,0,0,"self",null,"",null,false],[27,241,0,null,null," Blocks until child process terminates and then cleans up all resources.",[4243],false],[0,0,0,"self",null,"",null,false],[27,252,0,null,null,null,[4246,4248,4250],false],[27,252,0,null,null,null,null,false],[0,0,0,"term",null,null,null,false],[27,252,0,null,null,null,null,false],[0,0,0,"stdout",null,null,null,false],[27,252,0,null,null,null,null,false],[0,0,0,"stderr",null,null,null,false],[27,258,0,null,null,null,[4252],false],[0,0,0,"fifo",null,"",null,false],[27,276,0,null,null," Collect the output from the process's stdout and stderr. Will return once all output\n has been collected. This does not mean that the process has ended. `wait` should still\n be called to wait for and clean up the process.\n\n The process must be started with stdout_behavior and stderr_behavior == .Pipe",[4254,4255,4256,4257],false],[0,0,0,"child",null,"",null,false],[0,0,0,"stdout",null,"",null,false],[0,0,0,"stderr",null,"",null,false],[0,0,0,"max_output_bytes",null,"",null,false],[27,307,0,null,null,null,null,false],[27,314,0,null,null," Spawns a child process, waits for it, collecting stdout and stderr, and then returns.\n If it succeeds, the caller owns result.stdout and result.stderr memory.",[4260],false],[0,0,0,"args",null,"",[4262,4264,4266,4268,4270,4271,4273],false],[27,314,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[27,314,0,null,null,null,null,false],[0,0,0,"argv",null,null,null,false],[27,314,0,null,null,null,null,false],[0,0,0,"cwd",null,null,null,false],[27,314,0,null,null,null,null,false],[0,0,0,"cwd_dir",null,null,null,false],[27,314,0,null,null,null,null,false],[0,0,0,"env_map",null,null,null,false],[0,0,0,"max_output_bytes",null,null,null,false],[27,314,0,null,null,null,null,false],[0,0,0,"expand_arg0",null,null,null,false],[27,349,0,null,null,null,[4275],false],[0,0,0,"self",null,"",null,false],[27,359,0,null,null,null,[4277],false],[0,0,0,"self",null,"",null,false],[27,369,0,null,null,null,[4279],false],[0,0,0,"self",null,"",null,false],[27,391,0,null,null,null,[4281],false],[0,0,0,"self",null,"",null,false],[27,412,0,null,null,null,[4283,4284],false],[0,0,0,"self",null,"",null,false],[0,0,0,"status",null,"",null,false],[27,416,0,null,null,null,[4286],false],[0,0,0,"self",null,"",null,false],[27,431,0,null,null,null,[4288,4289],false],[0,0,0,"self",null,"",null,false],[0,0,0,"status",null,"",null,false],[27,471,0,null,null,null,[4291],false],[0,0,0,"status",null,"",null,false],[27,482,0,null,null,null,[4293],false],[0,0,0,"self",null,"",null,false],[27,639,0,null,null,null,[4295],false],[0,0,0,"self",null,"",null,false],[27,906,0,null,null,null,[4297,4298,4299,4300],false],[0,0,0,"stdio",null,"",null,false],[0,0,0,"pipe_fd",null,"",null,false],[0,0,0,"std_fileno",null,"",null,false],[0,0,0,"dev_null_fd",null,"",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"id",null," Available after calling `spawn()`. This becomes `undefined` after calling `wait()`.\n On Windows this is the hProcess.\n On POSIX this is the pid.",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"thread_handle",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"stdin",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"stdout",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"stderr",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"term",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"argv",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"env_map",null," Leave as null to use the current env map using the supplied allocator.",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"stdin_behavior",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"stdout_behavior",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"stderr_behavior",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"uid",null," Set to change the user id when spawning the child process.",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"gid",null," Set to change the group id when spawning the child process.",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"cwd",null," Set to change the current working directory when spawning the child process.",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"cwd_dir",null," Set to change the current working directory when spawning the child process.\n This is not yet implemented for Windows. See https://github.com/ziglang/zig/issues/5190\n Once that is done, `cwd` will be deprecated in favor of this field.",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"err_pipe",null,null,null,false],[27,19,0,null,null,null,null,false],[0,0,0,"expand_arg0",null,null,null,false],[0,0,0,"disable_aslr",null," Darwin-only. Disable ASLR for the child process.",null,false],[0,0,0,"start_suspended",null," Darwin-only. Start child process in suspended state as if SIGSTOP was sent.",null,false],[0,0,0,"request_resource_usage_statistics",null," Set to true to obtain rusage information for the child process.\n Depending on the target platform and implementation status, the\n requested statistics may or may not be available. If they are\n available, then the `resource_usage_statistics` field will be populated\n after calling `wait`.\n On Linux and Darwin, this obtains rusage statistics from wait4().",null,false],[27,19,0,null,null,null,null,false],[0,0,0,"resource_usage_statistics",null," This is available after calling wait if\n `request_resource_usage_statistics` was set to `true` before calling\n `spawn`.",null,false],[27,920,0,null,null," Expects `app_buf` to contain exactly the app name, and `dir_buf` to contain exactly the dir path.\n After return, `app_buf` will always contain exactly the app name and `dir_buf` will always contain exactly the dir path.\n Note: `app_buf` should not contain any leading path separators.\n Note: If the dir is the cwd, dir_buf should be empty (len = 0).",[4343,4344,4345,4346,4347,4348,4349,4350,4351],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"dir_buf",null,"",null,false],[0,0,0,"app_buf",null,"",null,false],[0,0,0,"pathext",null,"",null,false],[0,0,0,"cmd_line",null,"",null,false],[0,0,0,"envp_ptr",null,"",null,false],[0,0,0,"cwd_ptr",null,"",null,false],[0,0,0,"lpStartupInfo",null,"",null,false],[0,0,0,"lpProcessInformation",null,"",null,false],[27,1121,0,null,null,null,[4353,4354,4355,4356,4357,4358],false],[0,0,0,"app_name",null,"",null,false],[0,0,0,"cmd_line",null,"",null,false],[0,0,0,"envp_ptr",null,"",null,false],[0,0,0,"cwd_ptr",null,"",null,false],[0,0,0,"lpStartupInfo",null,"",null,false],[0,0,0,"lpProcessInformation",null,"",null,false],[27,1154,0,null,null,null,[4360,4361,4362,4363],false],[0,0,0,"bat",null,null,null,false],[0,0,0,"cmd",null,null,null,false],[0,0,0,"com",null,null,null,false],[0,0,0,"exe",null,null,null,false],[27,1162,0,null,null," Case-insensitive UTF-16 lookup",[4365],false],[0,0,0,"ext",null,"",null,false],[27,1226,0,null,null," Caller must dealloc.",[4367,4368],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"argv",null,"",null,false],[27,1260,0,null,null,null,[4370,4371],false],[0,0,0,"rd",null,"",null,false],[0,0,0,"wr",null,"",null,false],[27,1265,0,null,null,null,[4373,4374,4375],false],[0,0,0,"rd",null,"",null,false],[0,0,0,"wr",null,"",null,false],[0,0,0,"sattr",null,"",null,false],[27,1275,0,null,null,null,null,false],[27,1277,0,null,null,null,[4378,4379,4380],false],[0,0,0,"rd",null,"",null,false],[0,0,0,"wr",null,"",null,false],[0,0,0,"sattr",null,"",null,false],[27,1338,0,null,null,null,[4382],false],[0,0,0,"pipe",null,"",null,false],[27,1345,0,null,null,null,[4384,4385],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"err",null,"",null,false],[27,1358,0,null,null,null,null,false],[27,1360,0,null,null,null,[4388,4389],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"value",null,"",null,false],[27,1369,0,null,null,null,[4391],false],[0,0,0,"fd",null,"",null,false],[27,1379,0,null,null," Caller must free result.",[4393,4394],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"env_map",null,"",null,false],[27,1415,0,null,null,null,[4396,4397],false],[0,0,0,"arena",null,"",null,false],[0,0,0,"env_map",null,"",null,false],[0,18,0,null,null,null,null,false],[0,0,0,"comptime_string_map.zig",null,"",[],false],[28,0,0,null,null,null,null,false],[28,1,0,null,null,null,null,false],[28,9,0,null,null," Comptime string map optimized for small sets of disparate string keys.\n Works by separating the keys by length at comptime and only checking strings of\n equal length at runtime.\n\n `kvs_list` expects a list of `struct { []const u8, V }` (key-value pair) tuples.\n You can pass `struct { []const u8 }` (only keys) tuples if `V` is `void`.",[4403,4404],false],[0,0,0,"V",null,"",null,true],[0,0,0,"kvs_list",null,"",[],true],[28,61,0,null,null," Array of `struct { key: []const u8, value: V }` where `value` is `void{}` if `V` is `void`.\n Sorted by `key` length.",null,false],[28,64,0,null,null," Checks if the map has a value for the key.",[4407],false],[0,0,0,"str",null,"",null,false],[28,69,0,null,null," Returns the value for the key if any, else null.",[4409],false],[0,0,0,"str",null,"",null,false],[28,88,0,null,null,null,[4411,4412,4413,4414,4415],false],[0,0,0,"A",null,null,null,false],[0,0,0,"B",null,null,null,false],[0,0,0,"C",null,null,null,false],[0,0,0,"D",null,null,null,false],[0,0,0,"E",null,null,null,false],[28,135,0,null,null,null,[4417],false],[0,0,0,"map",null,"",null,true],[28,172,0,null,null,null,[4419],false],[0,0,0,"map",null,"",null,true],[0,19,0,null,null,null,null,false],[0,0,0,"dynamic_library.zig",null,"",[],false],[29,0,0,null,null,null,null,false],[29,1,0,null,null,null,null,false],[29,2,0,null,null,null,null,false],[29,3,0,null,null,null,null,false],[29,4,0,null,null,null,null,false],[29,5,0,null,null,null,null,false],[29,6,0,null,null,null,null,false],[29,7,0,null,null,null,null,false],[29,8,0,null,null,null,null,false],[29,9,0,null,null,null,null,false],[29,11,0,null,null,null,null,false],[29,23,0,null,null,null,[4441,4443,4445,4447,4449],false],[29,30,0,null,null,null,[4440],false],[29,33,0,null,null,null,[4436],false],[0,0,0,"self",null,"",null,false],[29,37,0,null,null,null,[4438],false],[0,0,0,"self",null,"",null,false],[29,30,0,null,null,null,null,false],[0,0,0,"current",null,null,null,false],[0,0,0,"l_addr",null,null,null,false],[29,23,0,null,null,null,null,false],[0,0,0,"l_name",null,null,null,false],[29,23,0,null,null,null,null,false],[0,0,0,"l_ld",null,null,null,false],[29,23,0,null,null,null,null,false],[0,0,0,"l_next",null,null,null,false],[29,23,0,null,null,null,null,false],[0,0,0,"l_prev",null,null,null,false],[29,47,0,null,null,null,[4451,4453,4454,4455],false],[0,0,0,"r_version",null,null,null,false],[29,47,0,null,null,null,null,false],[0,0,0,"r_map",null,null,null,false],[0,0,0,"r_brk",null,null,null,false],[0,0,0,"r_ldbase",null,null,null,false],[29,56,0,null,null," TODO make it possible to reference this same external symbol 2x so we don't need this\n helper function.",[],false],[29,60,0,null,null,null,[4458],false],[0,0,0,"phdrs",null,"",null,false],[29,96,0,null,null,null,[4478,4480,4482,4484,4486,4488],false],[29,104,0,null,null,null,null,false],[29,115,0,null,null," Trusts the file. Malicious file will be able to execute arbitrary code.",[4462],false],[0,0,0,"path",null,"",null,false],[29,251,0,null,null," Trusts the file. Malicious file will be able to execute arbitrary code.",[4464],false],[0,0,0,"path_c",null,"",null,false],[29,256,0,null,null," Trusts the file",[4466],false],[0,0,0,"self",null,"",null,false],[29,261,0,null,null,null,[4468,4469,4470],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"name",null,"",null,false],[29,270,0,null,null," Returns the address of the symbol",[4472,4473,4474],false],[0,0,0,"self",null,"",null,false],[0,0,0,"vername",null,"",null,false],[0,0,0,"name",null,"",null,false],[29,292,0,null,null,null,[4476],false],[0,0,0,"elf_prot",null,"",null,false],[29,96,0,null,null,null,null,false],[0,0,0,"strings",null,null,null,false],[29,96,0,null,null,null,null,false],[0,0,0,"syms",null,null,null,false],[29,96,0,null,null,null,null,false],[0,0,0,"hashtab",null,null,null,false],[29,96,0,null,null,null,null,false],[0,0,0,"versym",null,null,null,false],[29,96,0,null,null,null,null,false],[0,0,0,"verdef",null,null,null,false],[29,96,0,null,null,null,null,false],[0,0,0,"memory",null,null,null,false],[29,301,0,null,null,null,[4490,4491,4492,4493],false],[0,0,0,"def_arg",null,"",null,false],[0,0,0,"vsym_arg",null,"",null,false],[0,0,0,"vername",null,"",null,false],[0,0,0,"strings",null,"",null,false],[29,315,0,null,null,null,[4509],false],[29,316,0,null,null,null,null,false],[29,320,0,null,null,null,[4497],false],[0,0,0,"path",null,"",null,false],[29,325,0,null,null,null,[4499],false],[0,0,0,"path_c",null,"",null,false],[29,330,0,null,null,null,[4501],false],[0,0,0,"path_w",null,"",null,false],[29,342,0,null,null,null,[4503],false],[0,0,0,"self",null,"",null,false],[29,347,0,null,null,null,[4505,4506,4507],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"name",null,"",null,false],[29,315,0,null,null,null,null,false],[0,0,0,"dll",null,null,null,false],[29,356,0,null,null,null,[4523],false],[29,357,0,null,null,null,null,false],[29,361,0,null,null,null,[4513],false],[0,0,0,"path",null,"",null,false],[29,366,0,null,null,null,[4515],false],[0,0,0,"path_c",null,"",null,false],[29,374,0,null,null,null,[4517],false],[0,0,0,"self",null,"",null,false],[29,379,0,null,null,null,[4519,4520,4521],false],[0,0,0,"self",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"name",null,"",null,false],[29,356,0,null,null,null,null,false],[0,0,0,"handle",null,null,null,false],[0,20,0,null,null,null,null,false],[0,21,0,null,null,null,null,false],[0,22,0,null,null,null,null,false],[0,23,0,null,null,null,null,false],[0,24,0,null,null,null,null,false],[0,25,0,null,null,null,null,false],[0,26,0,null,null,null,null,false],[0,27,0,null,null,null,null,false],[0,0,0,"Ini.zig",null,"",[4552],false],[30,2,0,null,null,null,[4537,4539,4541],false],[30,7,0,null,null,null,[4535],false],[0,0,0,"it",null,"",null,false],[30,2,0,null,null,null,null,false],[0,0,0,"ini",null,null,null,false],[30,2,0,null,null,null,null,false],[0,0,0,"next_index",null,null,null,false],[30,2,0,null,null,null,null,false],[0,0,0,"header",null,null,null,false],[30,23,0,null,null," Asserts that `header` includes \"\\n[\" at the beginning and \"]\\n\" at the end.\n `header` must remain valid for the lifetime of the iterator.",[4543,4544],false],[0,0,0,"ini",null,"",null,false],[0,0,0,"header",null,"",null,false],[30,38,0,null,null,null,null,false],[30,39,0,null,null,null,null,false],[30,40,0,null,null,null,null,false],[30,41,0,null,null,null,null,false],[30,42,0,null,null,null,null,false],[30,44,0,"iterateSection","test iterateSection {\n    const example =\n        \\\\[package]\n        \\\\name=libffmpeg\n        \\\\version=5.1.2\n        \\\\\n        \\\\[dependency]\n        \\\\id=libz\n        \\\\url=url1\n        \\\\\n        \\\\[dependency]\n        \\\\id=libmp3lame\n        \\\\url=url2\n    ;\n    var ini: Ini = .{ .bytes = example };\n    var it = ini.iterateSection(\"\\n[dependency]\\n\");\n    const section1 = it.next() orelse return error.TestFailed;\n    try testing.expectEqualStrings(\"id=libz\\nurl=url1\\n\", section1);\n    const section2 = it.next() orelse return error.TestFailed;\n    try testing.expectEqualStrings(\"id=libmp3lame\\nurl=url2\", section2);\n    try testing.expect(it.next() == null);\n}",null,null,false],[30,0,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[0,28,0,null,null,null,null,false],[0,0,0,"multi_array_list.zig",null,"",[],false],[31,0,0,null,null,null,null,false],[31,1,0,null,null,null,null,false],[31,2,0,null,null,null,null,false],[31,3,0,null,null,null,null,false],[31,4,0,null,null,null,null,false],[31,5,0,null,null,null,null,false],[31,6,0,null,null,null,null,false],[31,19,0,null,null," A MultiArrayList stores a list of a struct or tagged union type.\n Instead of storing a single list of items, MultiArrayList\n stores separate lists for each field of the struct or\n lists of tags and bare unions.\n This allows for memory savings if the struct or union has padding,\n and also improves cache usage if only some fields or just tags\n are needed for a computation.  The primary API for accessing fields is\n the `slice()` function, which computes the start pointers\n for the array of each field.  From the slice you can call\n `.items(.<field_name>)` to obtain a slice of field values.\n For unions you can call `.items(.tags)` or `.items(.data)`.",[4563],false],[0,0,0,"T",null,"",[4705,4706,4707],true],[31,25,0,null,null,null,null,false],[31,58,0,null,null,null,null,false],[31,64,0,null,null," A MultiArrayList.Slice contains cached start pointers for each field in the list.\n These pointers are not normally stored to reduce the size of the list in memory.\n If you are accessing multiple fields, call slice() first to compute the pointers,\n and then get the field arrays from the slice.",[4588,4589,4590],false],[31,71,0,null,null,null,[4568,4569],false],[0,0,0,"self",null,"",null,false],[0,0,0,"field",null,"",null,true],[31,84,0,null,null,null,[4571,4572,4573],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"elem",null,"",null,false],[31,95,0,null,null,null,[4575,4576],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[31,107,0,null,null,null,[4578],false],[0,0,0,"self",null,"",null,false],[31,120,0,null,null,null,[4580,4581],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[31,128,0,null,null," This function is used in the debugger pretty formatters in tools/ to fetch the\n child field order and entry type to facilitate fancy debug printing for this type.",[4583,4584,4585,4586],false],[0,0,0,"self",null,"",null,false],[0,0,0,"child",null,"",null,false],[0,0,0,"field",null,"",null,false],[0,0,0,"entry",null,"",null,false],[31,64,0,null,null,null,null,false],[0,0,0,"ptrs",null," This array is indexed by the field index which can be obtained\n by using @intFromEnum() on the Field enum",null,false],[0,0,0,"len",null,null,null,false],[0,0,0,"capacity",null,null,null,false],[31,136,0,null,null,null,null,false],[31,138,0,null,null,null,null,false],[31,141,0,null,null," `sizes.bytes` is an array of @sizeOf each T field. Sorted by alignment, descending.\n `sizes.fields` is an array mapping from `sizes.bytes` array index to field index.",null,false],[31,175,0,null,null," Release all allocated memory.",[4595,4596],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[31,181,0,null,null," The caller owns the returned memory. Empties this MultiArrayList.",[4598],false],[0,0,0,"self",null,"",null,false],[31,190,0,null,null," Compute pointers to the start of each field of the array.\n If you need to access multiple fields, calling this may\n be more efficient than calling `items()` multiple times.",[4600],false],[0,0,0,"self",null,"",null,false],[31,207,0,null,null," Get the slice of values for a specified field.\n If you need multiple fields, consider calling slice()\n instead.",[4602,4603],false],[0,0,0,"self",null,"",null,false],[0,0,0,"field",null,"",null,true],[31,212,0,null,null," Overwrite one array element with new data.",[4605,4606,4607],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"elem",null,"",null,false],[31,218,0,null,null," Obtain all the data for one array element.",[4609,4610],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[31,223,0,null,null," Extend the list by 1 element. Allocates more memory as necessary.",[4612,4613,4614],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[0,0,0,"elem",null,"",null,false],[31,230,0,null,null," Extend the list by 1 element, but asserting `self.capacity`\n is sufficient to hold an additional item.",[4616,4617],false],[0,0,0,"self",null,"",null,false],[0,0,0,"elem",null,"",null,false],[31,239,0,null,null," Extend the list by 1 element, returning the newly reserved\n index with uninitialized data.\n Allocates more memory as necesasry.",[4619,4620],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[31,247,0,null,null," Extend the list by 1 element, asserting `self.capacity`\n is sufficient to hold an additional item.  Returns the\n newly reserved index with uninitialized data.",[4622],false],[0,0,0,"self",null,"",null,false],[31,257,0,null,null," Remove and return the last element from the list.\n Asserts the list has at least one item.\n Invalidates pointers to fields of the removed element.",[4624],false],[0,0,0,"self",null,"",null,false],[31,266,0,null,null," Remove and return the last element from the list, or\n return `null` if list is empty.\n Invalidates pointers to fields of the removed element, if any.",[4626],false],[0,0,0,"self",null,"",null,false],[31,275,0,null,null," Inserts an item into an ordered list.  Shifts all elements\n after and including the specified index back by one and\n sets the given index to the specified element.  May reallocate\n and invalidate iterators.",[4628,4629,4630,4631],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"elem",null,"",null,false],[31,284,0,null,null," Inserts an item into an ordered list which has room for it.\n Shifts all elements after and including the specified index\n back by one and sets the given index to the specified element.\n Will not reallocate the array, does not invalidate iterators.",[4633,4634,4635],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"elem",null,"",null,false],[31,307,0,null,null," Remove the specified item from the list, swapping the last\n item in the list into its position.  Fast, but does not\n retain list ordering.",[4637,4638],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[31,319,0,null,null," Remove the specified item from the list, shifting items\n after it to preserve order.",[4640,4641],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[31,334,0,null,null," Adjust the list's length to `new_len`.\n Does not initialize added items, if any.",[4643,4644,4645],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[31,342,0,null,null," Attempt to reduce allocated capacity to `new_len`.\n If `new_len` is greater than zero, this may fail to reduce the capacity,\n but the data remains intact and the length is updated to new_len.",[4647,4648,4649],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[31,391,0,null,null," Reduce length to `new_len`.\n Invalidates pointers to elements `items[new_len..]`.\n Keeps capacity the same.",[4651,4652],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[31,398,0,null,null," Modify the array so that it can hold at least `new_capacity` items.\n Implements super-linear growth to achieve amortized O(1) append operations.\n Invalidates pointers if additional memory is needed.",[4654,4655,4656],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[31,412,0,null,null," Modify the array so that it can hold at least `additional_count` **more** items.\n Invalidates pointers if additional memory is needed.",[4658,4659,4660],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[0,0,0,"additional_count",null,"",null,false],[31,419,0,null,null," Modify the array so that it can hold exactly `new_capacity` items.\n Invalidates pointers if additional memory is needed.\n `new_capacity` must be greater or equal to `len`.",[4662,4663,4664],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[31,451,0,null,null," Create a copy of this list with a new backing store,\n using the specified allocator.",[4666,4667],false],[0,0,0,"self",null,"",null,false],[0,0,0,"gpa",null,"",null,false],[31,469,0,null,null," `ctx` has the following method:\n `fn lessThan(ctx: @TypeOf(ctx), a_index: usize, b_index: usize) bool`",[4669,4670,4671,4672,4673],false],[0,0,0,"self",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"mode",null,"",[4674,4675],true],[0,0,0,"stable",null,null,null,false],[0,0,0,"unstable",null,null,null,false],[31,503,0,null,null," This function guarantees a stable sort, i.e the relative order of equal elements is preserved during sorting.\n Read more about stable sorting here: https://en.wikipedia.org/wiki/Sorting_algorithm#Stability\n If this guarantee does not matter, `sortUnstable` might be a faster alternative.\n `ctx` has the following method:\n `fn lessThan(ctx: @TypeOf(ctx), a_index: usize, b_index: usize) bool`",[4677,4678],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[31,513,0,null,null," Sorts only the subsection of items between indices `a` and `b` (excluding `b`)\n This function guarantees a stable sort, i.e the relative order of equal elements is preserved during sorting.\n Read more about stable sorting here: https://en.wikipedia.org/wiki/Sorting_algorithm#Stability\n If this guarantee does not matter, `sortSpanUnstable` might be a faster alternative.\n `ctx` has the following method:\n `fn lessThan(ctx: @TypeOf(ctx), a_index: usize, b_index: usize) bool`",[4680,4681,4682,4683],false],[0,0,0,"self",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[31,522,0,null,null," This function does NOT guarantee a stable sort, i.e the relative order of equal elements may change during sorting.\n Due to the weaker guarantees of this function, this may be faster than the stable `sort` method.\n Read more about stable sorting here: https://en.wikipedia.org/wiki/Sorting_algorithm#Stability\n `ctx` has the following method:\n `fn lessThan(ctx: @TypeOf(ctx), a_index: usize, b_index: usize) bool`",[4685,4686],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[31,532,0,null,null," Sorts only the subsection of items between indices `a` and `b` (excluding `b`)\n This function does NOT guarantee a stable sort, i.e the relative order of equal elements may change during sorting.\n Due to the weaker guarantees of this function, this may be faster than the stable `sortSpan` method.\n Read more about stable sorting here: https://en.wikipedia.org/wiki/Sorting_algorithm#Stability\n `ctx` has the following method:\n `fn lessThan(ctx: @TypeOf(ctx), a_index: usize, b_index: usize) bool`",[4688,4689,4690,4691],false],[0,0,0,"self",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[31,536,0,null,null,null,[4693],false],[0,0,0,"capacity",null,"",null,false],[31,542,0,null,null,null,[4695],false],[0,0,0,"self",null,"",null,false],[31,546,0,null,null,null,[4697],false],[0,0,0,"field",null,"",null,true],[31,550,0,null,null,null,null,false],[31,568,0,null,null," This function is used in the debugger pretty formatters in tools/ to fetch the\n child field order and entry type to facilitate fancy debug printing for this type.",[4700,4701,4702,4703],false],[0,0,0,"self",null,"",null,false],[0,0,0,"child",null,"",null,false],[0,0,0,"field",null,"",null,false],[0,0,0,"entry",null,"",null,false],[31,20,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[0,0,0,"len",null,null,null,false],[0,0,0,"capacity",null,null,null,false],[0,29,0,null,null,null,null,false],[0,0,0,"packed_int_array.zig",null," A set of array and slice types that bit-pack integer elements. A normal [12]u3\n takes up 12 bytes of memory since u3's alignment is 1. PackedArray(u3, 12) only\n takes up 4 bytes of memory.\n",[],false],[32,4,0,null,null,null,null,false],[32,5,0,null,null,null,null,false],[32,6,0,null,null,null,null,false],[32,7,0,null,null,null,null,false],[32,8,0,null,null,null,null,false],[32,9,0,null,null,null,null,false],[32,13,0,null,null," Provides a set of functions for reading and writing packed integers from a\n slice of bytes.",[4717,4718],false],[0,0,0,"Int",null,"",null,true],[0,0,0,"endian",null,"",[],true],[32,55,0,null,null," Retrieves the integer at `index` from the packed data beginning at `bit_offset`\n within `bytes`.",[4720,4721,4722],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[32,66,0,null,null,null,[4724,4725,4726],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"Container",null,"",null,true],[0,0,0,"bit_index",null,"",null,false],[32,98,0,null,null," Sets the integer at `index` to `val` within the packed data beginning\n at `bit_offset` into `bytes`.",[4728,4729,4730,4731],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"int",null,"",null,false],[32,109,0,null,null,null,[4733,4734,4735,4736],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"Container",null,"",null,true],[0,0,0,"bit_index",null,"",null,false],[0,0,0,"int",null,"",null,false],[32,146,0,null,null," Provides a PackedIntSlice of the packed integers in `bytes` (which begins at `bit_offset`)\n from the element specified by `start` to the element specified by `end`.",[4738,4739,4740,4741],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"start",null,"",null,false],[0,0,0,"end",null,"",null,false],[32,165,0,null,null," Recasts a packed slice to a version with elements of type `NewInt` and endianness `new_endian`.\n Slice will begin at `bit_offset` within `bytes` and the new length will be automatically\n calculated from `old_len` using the sizes of the current integer type and `NewInt`.",[4743,4744,4745,4746,4747],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"NewInt",null,"",null,true],[0,0,0,"new_endian",null,"",null,true],[0,0,0,"bit_offset",null,"",null,false],[0,0,0,"old_len",null,"",null,false],[32,187,0,null,null," Creates a bit-packed array of `Int`. Non-byte-multiple integers\n will take up less memory in PackedIntArray than in a normal array.\n Elements are packed using native endianness and without storing any\n meta data. PackedArray(i3, 8) will occupy exactly 3 bytes\n of memory.",[4749,4750],false],[0,0,0,"Int",null,"",null,true],[0,0,0,"int_count",null,"",null,true],[32,195,0,null,null," Creates a bit-packed array of `Int` with bit order specified by `endian`.\n Non-byte-multiple integers will take up less memory in PackedIntArrayEndian\n than in a normal array. Elements are packed without storing any meta data.\n PackedIntArrayEndian(i3, 8) will occupy exactly 3 bytes of memory.",[4752,4753,4754],false],[0,0,0,"Int",null,"",null,true],[0,0,0,"endian",null,"",null,true],[0,0,0,"int_count",null,"",[4783,4784],true],[32,203,0,null,null,null,null,false],[32,211,0,null,null," The integer type of the packed array.",null,false],[32,215,0,null,null," Initialize a packed array using an unpacked array\n or, more likely, an array literal.",[4758],false],[0,0,0,"ints",null,"",null,false],[32,222,0,null,null," Initialize all entries of a packed array to the same value.",[4760],false],[0,0,0,"int",null,"",null,false],[32,230,0,null,null," Return the integer stored at `index`.",[4762,4763],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[32,236,0,null,null,"Copy the value of `int` into the array at `index`.",[4765,4766,4767],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"int",null,"",null,false],[32,242,0,null,null," Set all entries of a packed array to the value of `int`.",[4769,4770],false],[0,0,0,"self",null,"",null,false],[0,0,0,"int",null,"",null,false],[32,250,0,null,null," Create a PackedIntSlice of the array from `start` to `end`.",[4772,4773,4774],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start",null,"",null,false],[0,0,0,"end",null,"",null,false],[32,258,0,null,null," Create a PackedIntSlice of the array using `NewInt` as the integer type.\n `NewInt`'s bit width must fit evenly within the array's `Int`'s total bits.",[4776,4777],false],[0,0,0,"self",null,"",null,false],[0,0,0,"NewInt",null,"",null,true],[32,265,0,null,null," Create a PackedIntSliceEndian of the array using `NewInt` as the integer type\n and `new_endian` as the new endianness. `NewInt`'s bit width must fit evenly\n within the array's `Int`'s total bits.",[4779,4780,4781],false],[0,0,0,"self",null,"",null,false],[0,0,0,"NewInt",null,"",null,true],[0,0,0,"new_endian",null,"",null,true],[32,202,0,null,null,null,null,false],[0,0,0,"bytes",null," The byte buffer containing the packed data.",null,false],[0,0,0,"len",null," The number of elements in the packed array.",null,false],[32,272,0,null,null," A type representing a sub range of a PackedIntArray.",[4786],false],[0,0,0,"Int",null,"",null,true],[32,277,0,null,null," A type representing a sub range of a PackedIntArrayEndian.",[4788,4789],false],[0,0,0,"Int",null,"",null,true],[0,0,0,"endian",null,"",[4816,4818,4819],true],[32,282,0,null,null,null,null,false],[32,289,0,null,null," The integer type of the packed slice.",null,false],[32,293,0,null,null," Calculates the number of bytes required to store a desired count\n of `Int`s.",[4793],false],[0,0,0,"int_count",null,"",null,false],[32,302,0,null,null," Initialize a packed slice using the memory at `bytes`, with `int_count`\n elements. `bytes` must be large enough to accommodate the requested\n count.",[4795,4796],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"int_count",null,"",null,false],[32,313,0,null,null," Return the integer stored at `index`.",[4798,4799],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[32,319,0,null,null," Copy `int` into the slice at `index`.",[4801,4802,4803],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"int",null,"",null,false],[32,325,0,null,null," Create a PackedIntSlice of this slice from `start` to `end`.",[4805,4806,4807],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start",null,"",null,false],[0,0,0,"end",null,"",null,false],[32,333,0,null,null," Create a PackedIntSlice of the sclice using `NewInt` as the integer type.\n `NewInt`'s bit width must fit evenly within the slice's `Int`'s total bits.",[4809,4810],false],[0,0,0,"self",null,"",null,false],[0,0,0,"NewInt",null,"",null,true],[32,340,0,null,null," Create a PackedIntSliceEndian of the slice using `NewInt` as the integer type\n and `new_endian` as the new endianness. `NewInt`'s bit width must fit evenly\n within the slice's `Int`'s total bits.",[4812,4813,4814],false],[0,0,0,"self",null,"",null,false],[0,0,0,"NewInt",null,"",null,true],[0,0,0,"new_endian",null,"",null,true],[32,281,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[32,281,0,null,null,null,null,false],[0,0,0,"bit_offset",null,null,null,false],[0,0,0,"len",null,null,null,false],[0,30,0,null,null,null,null,false],[0,31,0,null,null,null,null,false],[0,32,0,null,null,null,null,false],[0,33,0,null,null,null,null,false],[0,0,0,"priority_queue.zig",null,"",[],false],[33,0,0,null,null,null,null,false],[33,1,0,null,null,null,null,false],[33,2,0,null,null,null,null,false],[33,3,0,null,null,null,null,false],[33,4,0,null,null,null,null,false],[33,5,0,null,null,null,null,false],[33,6,0,null,null,null,null,false],[33,7,0,null,null,null,null,false],[33,16,0,null,null," Priority queue for storing generic data. Initialize with `init`.\n Provide `compareFn` that returns `Order.lt` when its second\n argument should get popped before its third argument,\n `Order.eq` if the arguments are of equal priority, or `Order.gt`\n if the third argument should be popped first.\n For example, to make `pop` return the smallest number, provide\n `fn lessThan(context: void, a: T, b: T) Order { _ = context; return std.math.order(a, b); }`",[4834,4835,4836],false],[0,0,0,"T",null,"",null,true],[0,0,0,"Context",null,"",null,true],[0,0,0,"compareFn",null,"",[4837,4838,4839],true],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",[4904,4905,4907,4909],false],[33,18,0,null,null,null,null,false],[33,26,0,null,null," Initialize and return a priority queue.",[4842,4843],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"context",null,"",null,false],[33,36,0,null,null," Free memory used by the queue.",[4845],false],[0,0,0,"self",null,"",null,false],[33,41,0,null,null," Insert a new element, maintaining priority.",[4847,4848],false],[0,0,0,"self",null,"",null,false],[0,0,0,"elem",null,"",null,false],[33,46,0,null,null,null,[4850,4851],false],[0,0,0,"self",null,"",null,false],[0,0,0,"elem",null,"",null,false],[33,52,0,null,null,null,[4853,4854],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[33,66,0,null,null," Add each element in `items` to the queue.",[4856,4857],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[33,75,0,null,null," Look at the highest priority element in the queue. Returns\n `null` if empty.",[4859],false],[0,0,0,"self",null,"",null,false],[33,81,0,null,null," Pop the highest priority element from the queue. Returns\n `null` if empty.",[4861],false],[0,0,0,"self",null,"",null,false],[33,87,0,null,null," Remove and return the highest priority element from the\n queue.",[4863],false],[0,0,0,"self",null,"",null,false],[33,94,0,null,null," Remove and return element at index. Indices are in the\n same order as iterator, which is not necessarily priority\n order.",[4865,4866],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[33,118,0,null,null," Return the number of elements remaining in the priority\n queue.",[4868],false],[0,0,0,"self",null,"",null,false],[33,124,0,null,null," Return the number of elements that can be added to the\n queue before more memory is allocated.",[4870],false],[0,0,0,"self",null,"",null,false],[33,128,0,null,null,null,[4872,4873],false],[0,0,0,"self",null,"",null,false],[0,0,0,"target_index",null,"",null,false],[33,151,0,null,null," PriorityQueue takes ownership of the passed in slice. The slice must have been\n allocated with `allocator`.\n Deinitialize with `deinit`.",[4875,4876,4877],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"items",null,"",null,false],[0,0,0,"context",null,"",null,false],[33,168,0,null,null," Ensure that the queue can fit at least `new_capacity` items.",[4879,4880],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[33,179,0,null,null," Ensure that the queue can fit at least `additional_count` **more** item.",[4882,4883],false],[0,0,0,"self",null,"",null,false],[0,0,0,"additional_count",null,"",null,false],[33,184,0,null,null," Reduce allocated capacity to `new_len`.",[4885,4886],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[33,198,0,null,null,null,[4888,4889,4890],false],[0,0,0,"self",null,"",null,false],[0,0,0,"elem",null,"",null,false],[0,0,0,"new_elem",null,"",null,false],[33,216,0,null,null,null,[4897,4898],false],[33,220,0,null,null,null,[4893],false],[0,0,0,"it",null,"",null,false],[33,227,0,null,null,null,[4895],false],[0,0,0,"it",null,"",null,false],[33,216,0,null,null,null,null,false],[0,0,0,"queue",null,null,null,false],[0,0,0,"count",null,null,null,false],[33,234,0,null,null," Return an iterator that walks the queue without consuming\n it. Invalidated if the heap is modified.",[4900],false],[0,0,0,"self",null,"",null,false],[33,241,0,null,null,null,[4902],false],[0,0,0,"self",null,"",null,false],[33,17,0,null,null,null,null,false],[0,0,0,"items",null,null,null,false],[0,0,0,"len",null,null,null,false],[33,17,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[33,17,0,null,null,null,null,false],[0,0,0,"context",null,null,null,false],[33,260,0,null,null,null,[4911,4912,4913],false],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[33,265,0,null,null,null,[4915,4916,4917],false],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[33,269,0,null,null,null,null,false],[33,270,0,null,null,null,null,false],[33,598,0,null,null,null,[4921,4922,4923],false],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[33,602,0,null,null,null,null,false],[0,34,0,null,null,null,null,false],[0,0,0,"priority_dequeue.zig",null,"",[],false],[34,0,0,null,null,null,null,false],[34,1,0,null,null,null,null,false],[34,2,0,null,null,null,null,false],[34,3,0,null,null,null,null,false],[34,4,0,null,null,null,null,false],[34,5,0,null,null,null,null,false],[34,6,0,null,null,null,null,false],[34,7,0,null,null,null,null,false],[34,17,0,null,null," Priority Dequeue for storing generic data. Initialize with `init`.\n Provide `compareFn` that returns `Order.lt` when its second\n argument should get min-popped before its third argument,\n `Order.eq` if the arguments are of equal priority, or `Order.gt`\n if the third argument should be min-popped second.\n Popping the max element works in reverse. For example,\n to make `popMin` return the smallest number, provide\n `fn lessThan(context: void, a: T, b: T) Order { _ = context; return std.math.order(a, b); }`",[4936,4937,4938],false],[0,0,0,"T",null,"",null,true],[0,0,0,"Context",null,"",null,true],[0,0,0,"compareFn",null,"",[4939,4940,4941],true],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",[5068,5069,5071,5073],false],[34,19,0,null,null,null,null,false],[34,27,0,null,null," Initialize and return a new priority dequeue.",[4944,4945],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"context",null,"",null,false],[34,37,0,null,null," Free memory used by the dequeue.",[4947],false],[0,0,0,"self",null,"",null,false],[34,42,0,null,null," Insert a new element, maintaining priority.",[4949,4950],false],[0,0,0,"self",null,"",null,false],[0,0,0,"elem",null,"",null,false],[34,48,0,null,null," Add each element in `items` to the dequeue.",[4952,4953],false],[0,0,0,"self",null,"",null,false],[0,0,0,"items",null,"",null,false],[34,55,0,null,null,null,[4955,4956],false],[0,0,0,"self",null,"",null,false],[0,0,0,"elem",null,"",null,false],[34,66,0,null,null,null,[4958],false],[0,0,0,"index",null,"",null,false],[34,74,0,null,null,null,[4960],false],[0,0,0,"self",null,"",null,false],[34,78,0,null,null,null,[4962,4963],false],[0,0,0,"index",null,null,null,false],[0,0,0,"min_layer",null,null,null,false],[34,83,0,null,null,null,[4965,4966,4967],false],[0,0,0,"self",null,"",null,false],[0,0,0,"child",null,"",null,false],[0,0,0,"index",null,"",null,false],[34,106,0,null,null,null,[4969,4970],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start",null,"",null,false],[34,114,0,null,null,null,[4972,4973,4974],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[0,0,0,"target_order",null,"",null,false],[34,133,0,null,null," Look at the smallest element in the dequeue. Returns\n `null` if empty.",[4976],false],[0,0,0,"self",null,"",null,false],[34,139,0,null,null," Look at the largest element in the dequeue. Returns\n `null` if empty.",[4978],false],[0,0,0,"self",null,"",null,false],[34,146,0,null,null,null,[4980],false],[0,0,0,"self",null,"",null,false],[34,155,0,null,null," Pop the smallest element from the dequeue. Returns\n `null` if empty.",[4982],false],[0,0,0,"self",null,"",null,false],[34,161,0,null,null," Remove and return the smallest element from the\n dequeue.",[4984],false],[0,0,0,"self",null,"",null,false],[34,167,0,null,null," Pop the largest element from the dequeue. Returns\n `null` if empty.",[4986],false],[0,0,0,"self",null,"",null,false],[34,173,0,null,null," Remove and return the largest element from the\n dequeue.",[4988],false],[0,0,0,"self",null,"",null,false],[34,180,0,null,null," Remove and return element at index. Indices are in the\n same order as iterator, which is not necessarily priority\n order.",[4990,4991],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[34,192,0,null,null,null,[4993,4994],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[34,200,0,null,null,null,[4996,4997,4998],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[0,0,0,"target_order",null,"",null,false],[34,257,0,null,null,null,[5000,5001,5002,5003],false],[0,0,0,"self",null,"",null,false],[0,0,0,"child",null,"",null,false],[0,0,0,"child_index",null,"",null,false],[0,0,0,"target_order",null,"",null,false],[34,267,0,null,null,null,[5006,5007],false],[34,267,0,null,null,null,null,false],[0,0,0,"item",null,null,null,false],[0,0,0,"index",null,null,null,false],[34,272,0,null,null,null,[5009,5010],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[34,279,0,null,null,null,[5012,5013,5014,5015],false],[0,0,0,"self",null,"",null,false],[0,0,0,"item1",null,"",null,false],[0,0,0,"item2",null,"",null,false],[0,0,0,"target_order",null,"",null,false],[34,287,0,null,null,null,[5017,5018,5019,5020],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index1",null,"",null,false],[0,0,0,"index2",null,"",null,false],[0,0,0,"target_order",null,"",null,false],[34,293,0,null,null,null,[5022,5023,5024,5025],false],[0,0,0,"self",null,"",null,false],[0,0,0,"first_child_index",null,"",null,false],[0,0,0,"first_grandchild_index",null,"",null,false],[0,0,0,"target_order",null,"",null,false],[34,325,0,null,null," Return the number of elements remaining in the dequeue",[5027],false],[0,0,0,"self",null,"",null,false],[34,331,0,null,null," Return the number of elements that can be added to the\n dequeue before more memory is allocated.",[5029],false],[0,0,0,"self",null,"",null,false],[34,338,0,null,null," Dequeue takes ownership of the passed in slice. The slice must have been\n allocated with `allocator`.\n De-initialize with `deinit`.",[5031,5032,5033],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"items",null,"",null,false],[0,0,0,"context",null,"",null,false],[34,358,0,null,null," Ensure that the dequeue can fit at least `new_capacity` items.",[5035,5036],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[34,369,0,null,null," Ensure that the dequeue can fit at least `additional_count` **more** items.",[5038,5039],false],[0,0,0,"self",null,"",null,false],[0,0,0,"additional_count",null,"",null,false],[34,374,0,null,null," Reduce allocated capacity to `new_len`.",[5041,5042],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[34,388,0,null,null,null,[5044,5045,5046],false],[0,0,0,"self",null,"",null,false],[0,0,0,"elem",null,"",null,false],[0,0,0,"new_elem",null,"",null,false],[34,401,0,null,null,null,[5053,5054],false],[34,405,0,null,null,null,[5049],false],[0,0,0,"it",null,"",null,false],[34,412,0,null,null,null,[5051],false],[0,0,0,"it",null,"",null,false],[34,401,0,null,null,null,null,false],[0,0,0,"queue",null,null,null,false],[0,0,0,"count",null,null,null,false],[34,419,0,null,null," Return an iterator that walks the queue without consuming\n it. Invalidated if the queue is modified.",[5056],false],[0,0,0,"self",null,"",null,false],[34,426,0,null,null,null,[5058],false],[0,0,0,"self",null,"",null,false],[34,443,0,null,null,null,[5060],false],[0,0,0,"index",null,"",null,false],[34,447,0,null,null,null,[5062],false],[0,0,0,"index",null,"",null,false],[34,451,0,null,null,null,[5064],false],[0,0,0,"index",null,"",null,false],[34,455,0,null,null,null,[5066],false],[0,0,0,"index",null,"",null,false],[34,18,0,null,null,null,null,false],[0,0,0,"items",null,null,null,false],[0,0,0,"len",null,null,null,false],[34,18,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[34,18,0,null,null,null,null,false],[0,0,0,"context",null,null,null,false],[34,461,0,null,null,null,[5075,5076,5077],false],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[34,466,0,null,null,null,null,false],[34,879,0,null,null,null,[5080,5081],false],[0,0,0,"rng",null,"",null,false],[0,0,0,"queue_size",null,"",null,true],[34,908,0,null,null,null,[5083,5084],false],[0,0,0,"rng",null,"",null,false],[0,0,0,"queue_size",null,"",null,false],[34,937,0,null,null,null,[5086,5087],false],[0,0,0,"rng",null,"",null,false],[0,0,0,"queue_size",null,"",null,false],[34,964,0,null,null,null,[5089,5090,5091],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"rng",null,"",null,false],[0,0,0,"size",null,"",null,false],[34,977,0,null,null,null,[5093,5094,5095],false],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[34,981,0,null,null,null,null,false],[34,1005,0,null,null,null,null,false],[0,35,0,null,null,null,null,false],[0,0,0,"Progress.zig",null," This API non-allocating, non-fallible, and thread-safe.\n The tradeoff is that users of this API must provide the storage\n for each `Progress.Node`.\n\n Initialize the struct directly, overriding these fields as desired:\n * `refresh_rate_ms`\n * `initial_delay_ms`\n",[5171,5172,5173,5174,5176,5178,5179,5181,5182,5183,5184,5186,5187],false],[35,8,0,null,null,null,null,false],[35,9,0,null,null,null,null,false],[35,10,0,null,null,null,null,false],[35,11,0,null,null,null,null,false],[35,12,0,null,null,null,null,false],[35,13,0,null,null,null,null,false],[35,66,0,null,null," Represents one unit of progress. Each node can have children nodes, or\n one can use integers with `update`.",[5130,5132,5134,5136,5138,5139,5140],false],[35,84,0,null,null," Create a new child progress node. Thread-safe.\n Call `Node.end` when done.\n TODO solve https://github.com/ziglang/zig/issues/2765 and then change this\n API to set `self.parent.recently_updated_child` with the return value.\n Until that is fixed you probably want to call `activate` on the return value.\n Passing 0 for `estimated_total_items` means unknown.",[5108,5109,5110],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"estimated_total_items",null,"",null,false],[35,95,0,null,null," This is the same as calling `start` and then `end` on the returned `Node`. Thread-safe.",[5112],false],[0,0,0,"self",null,"",null,false],[35,104,0,null,null," Finish a started `Node`. Thread-safe.",[5114],false],[0,0,0,"self",null,"",null,false],[35,122,0,null,null," Tell the parent node that this node is actively being worked on. Thread-safe.",[5116],false],[0,0,0,"self",null,"",null,false],[35,130,0,null,null," Thread-safe.",[5118,5119],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[35,145,0,null,null," Thread-safe.",[5121,5122],false],[0,0,0,"self",null,"",null,false],[0,0,0,"unit",null,"",null,false],[35,160,0,null,null," Thread-safe. 0 means unknown.",[5124,5125],false],[0,0,0,"self",null,"",null,false],[0,0,0,"count",null,"",null,false],[35,165,0,null,null," Thread-safe.",[5127,5128],false],[0,0,0,"self",null,"",null,false],[0,0,0,"completed_items",null,"",null,false],[35,66,0,null,null,null,null,false],[0,0,0,"context",null,null,null,false],[35,66,0,null,null,null,null,false],[0,0,0,"parent",null,null,null,false],[35,66,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[35,66,0,null,null,null,null,false],[0,0,0,"unit",null,null,null,false],[35,66,0,null,null,null,null,false],[0,0,0,"recently_updated_child",null," Must be handled atomically to be thread-safe.",null,false],[0,0,0,"unprotected_estimated_total_items",null," Must be handled atomically to be thread-safe. 0 means null.",null,false],[0,0,0,"unprotected_completed_items",null," Must be handled atomically to be thread-safe.",null,false],[35,175,0,null,null," Create a new progress node.\n Call `Node.end` when done.\n TODO solve https://github.com/ziglang/zig/issues/2765 and then change this\n API to return Progress rather than accept it as a parameter.\n `estimated_total_items` value of 0 means unknown.",[5142,5143,5144],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[0,0,0,"estimated_total_items",null,"",null,false],[35,203,0,null,null," Updates the terminal if enough time has passed since last update. Thread-safe.",[5146],false],[0,0,0,"self",null,"",null,false],[35,211,0,null,null,null,[5148,5149],false],[0,0,0,"self",null,"",null,false],[0,0,0,"timer",null,"",null,false],[35,222,0,null,null," Updates the terminal and resets `self.next_refresh_timestamp`. Thread-safe.",[5151],false],[0,0,0,"self",null,"",null,false],[35,229,0,null,null,null,[5153,5154],false],[0,0,0,"p",null,"",null,false],[0,0,0,"end_ptr",null,"",null,false],[35,298,0,null,null,null,[5156],false],[0,0,0,"self",null,"",null,false],[35,349,0,null,null,null,[5158,5159,5160],false],[0,0,0,"self",null,"",null,false],[0,0,0,"format",null,"",null,true],[0,0,0,"args",null,"",null,false],[35,364,0,null,null," Allows the caller to freely write to stderr until unlock_stderr() is called.\n During the lock, the progress information is cleared from the terminal.",[5162],false],[0,0,0,"p",null,"",null,false],[35,377,0,null,null,null,[5164],false],[0,0,0,"p",null,"",null,false],[35,382,0,null,null,null,[5166,5167,5168,5169],false],[0,0,0,"self",null,"",null,false],[0,0,0,"end",null,"",null,false],[0,0,0,"format",null,"",null,true],[0,0,0,"args",null,"",null,false],[35,0,0,null,null,null,null,false],[0,0,0,"terminal",null," `null` if the current node (and its children) should\n not print on update()",null,false],[0,0,0,"is_windows_terminal",null," Is this a windows API terminal (note: this is not the same as being run on windows\n because other terminals exist like MSYS/git-bash)",null,false],[0,0,0,"supports_ansi_escape_codes",null," Whether the terminal supports ANSI escape codes.",null,false],[0,0,0,"dont_print_on_dumb",null," If the terminal is \"dumb\", don't print output.\n This can be useful if you don't want to print all\n the stages of code generation if there are a lot.\n You should not use it if the user should see output\n for example showing the user what tests run.",null,false],[35,0,0,null,null,null,null,false],[0,0,0,"root",null,null,null,false],[35,0,0,null,null,null,null,false],[0,0,0,"timer",null," Keeps track of how much time has passed since the beginning.\n Used to compare with `initial_delay_ms` and `refresh_rate_ms`.",null,false],[0,0,0,"prev_refresh_timestamp",null," When the previous refresh was written to the terminal.\n Used to compare with `refresh_rate_ms`.",null,false],[35,0,0,null,null,null,null,false],[0,0,0,"output_buffer",null," This buffer represents the maximum number of bytes written to the terminal\n with each refresh.",null,false],[0,0,0,"refresh_rate_ns",null," How many nanoseconds between writing updates to the terminal.",null,false],[0,0,0,"initial_delay_ns",null," How many nanoseconds to keep the output hidden",null,false],[0,0,0,"done",null,null,null,false],[35,0,0,null,null,null,null,false],[0,0,0,"update_mutex",null," Protects the `refresh` function, as well as `node.recently_updated_child`.\n Without this, callsites would call `Node.end` and then free `Node` memory\n while it was still being accessed by the `refresh` function.",null,false],[0,0,0,"columns_written",null," Keeps track of how many columns in the terminal have been output, so that\n we can move the cursor back later.",null,false],[0,36,0,null,null,null,null,false],[0,0,0,"RingBuffer.zig",null," This ring buffer stores read and write indices while being able to utilise\n the full backing slice by incrementing the indices modulo twice the slice's\n length and reducing indices modulo the slice's length on slice access. This\n means that whether the ring buffer is full or empty can be distinguished by\n looking at the difference between the read and write indices without adding\n an extra boolean flag or having to reserve a slot in the buffer.\n\n This ring buffer has not been implemented with thread safety in mind, and\n therefore should not be assumed to be suitable for use cases involving\n separate reader and writer threads.\n",[5241,5242,5243],false],[36,11,0,null,null,null,null,false],[36,12,0,null,null,null,null,false],[36,14,0,null,null,null,null,false],[36,20,0,null,null,null,null,false],[36,23,0,null,null," Allocate a new `RingBuffer`; `deinit()` should be called to free the buffer.",[5195,5196],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"capacity",null,"",null,false],[36,34,0,null,null," Free the data backing a `RingBuffer`; must be passed the same `Allocator` as\n `init()`.",[5198,5199],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[36,40,0,null,null," Returns `index` modulo the length of the backing slice.",[5201,5202],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[36,45,0,null,null," Returns `index` modulo twice the length of the backing slice.",[5204,5205],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[36,51,0,null,null," Write `byte` into the ring buffer. Returns `error.Full` if the ring\n buffer is full.",[5207,5208],false],[0,0,0,"self",null,"",null,false],[0,0,0,"byte",null,"",null,false],[36,58,0,null,null," Write `byte` into the ring buffer. If the ring buffer is full, the\n oldest byte is overwritten.",[5210,5211],false],[0,0,0,"self",null,"",null,false],[0,0,0,"byte",null,"",null,false],[36,65,0,null,null," Write `bytes` into the ring buffer. Returns `error.Full` if the ring\n buffer does not have enough space, without writing any data.",[5213,5214],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[36,72,0,null,null," Write `bytes` into the ring buffer. If there is not enough space, older\n bytes will be overwritten.",[5216,5217],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[36,78,0,null,null," Consume a byte from the ring buffer and return it. Returns `null` if the\n ring buffer is empty.",[5219],false],[0,0,0,"self",null,"",null,false],[36,85,0,null,null," Consume a byte from the ring buffer and return it; asserts that the buffer\n is not empty.",[5221],false],[0,0,0,"self",null,"",null,false],[36,93,0,null,null," Returns `true` if the ring buffer is empty and `false` otherwise.",[5223],false],[0,0,0,"self",null,"",null,false],[36,98,0,null,null," Returns `true` if the ring buffer is full and `false` otherwise.",[5225],false],[0,0,0,"self",null,"",null,false],[36,103,0,null,null," Returns the length",[5227],false],[0,0,0,"self",null,"",null,false],[36,112,0,null,null," A `Slice` represents a region of a ring buffer. The region is split into two\n sections as the ring buffer data will not be contiguous if the desired\n region wraps to the start of the backing slice.",[5230,5232],false],[36,112,0,null,null,null,null,false],[0,0,0,"first",null,null,null,false],[36,112,0,null,null,null,null,false],[0,0,0,"second",null,null,null,false],[36,119,0,null,null," Returns a `Slice` for the region of the ring buffer starting at\n `self.mask(start_unmasked)` with the specified length.",[5234,5235,5236],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start_unmasked",null,"",null,false],[0,0,0,"length",null,"",null,false],[36,133,0,null,null," Returns a `Slice` for the last `length` bytes written to the ring buffer.\n Does not check that any bytes have been written into the region.",[5238,5239],false],[0,0,0,"self",null,"",null,false],[0,0,0,"length",null,"",null,false],[36,0,0,null,null,null,null,false],[0,0,0,"data",null,null,null,false],[0,0,0,"read_index",null,null,null,false],[0,0,0,"write_index",null,null,null,false],[0,37,0,null,null,null,null,false],[0,0,0,"segmented_list.zig",null,"",[],false],[37,0,0,null,null,null,null,false],[37,1,0,null,null,null,null,false],[37,2,0,null,null,null,null,false],[37,3,0,null,null,null,null,false],[37,4,0,null,null,null,null,false],[37,77,0,null,null," This is a stack data structure where pointers to indexes have the same lifetime as the data structure\n itself, unlike ArrayList where append() invalidates all existing element pointers.\n The tradeoff is that elements are not guaranteed to be contiguous. For that, use ArrayList.\n Note however that most elements are contiguous, making this data structure cache-friendly.\n\n Because it never has to copy elements from an old location to a new location, it does not require\n its elements to be copyable, and it avoids wasting memory when backed by an ArenaAllocator.\n Note that the append() and pop() convenience methods perform a copy, but you can instead use\n addOne(), at(), setCapacity(), and shrinkCapacity() to avoid copying items.\n\n This data structure has O(1) append and O(1) pop.\n\n It supports preallocated elements, making it especially well suited when the expected maximum\n size is small. `prealloc_item_count` must be 0, or a power of 2.",[5252,5253],false],[0,0,0,"T",null,"",null,true],[0,0,0,"prealloc_item_count",null,"",[5353,5355,5356],true],[37,79,0,null,null,null,null,false],[37,80,0,null,null,null,null,false],[37,82,0,null,null,null,null,false],[37,98,0,null,null,null,null,false],[37,100,0,null,null,null,[5259],false],[0,0,0,"SelfType",null,"",null,true],[37,108,0,null,null,null,[5261,5262],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[37,114,0,null,null,null,[5264,5265],false],[0,0,0,"self",null,"",null,false],[0,0,0,"i",null,"",null,false],[37,119,0,null,null,null,[5267],false],[0,0,0,"self",null,"",null,false],[37,123,0,null,null,null,[5269,5270,5271],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"item",null,"",null,false],[37,128,0,null,null,null,[5273,5274,5275],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"items",null,"",null,false],[37,134,0,null,null,null,[5277],false],[0,0,0,"self",null,"",null,false],[37,143,0,null,null,null,[5279,5280],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[37,153,0,null,null," Reduce length to `new_len`.\n Invalidates pointers for the elements at index new_len and beyond.",[5282,5283],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[37,159,0,null,null," Invalidates all element pointers.",[5285],false],[0,0,0,"self",null,"",null,false],[37,164,0,null,null," Invalidates all element pointers.",[5287,5288],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[37,171,0,null,null," Grows or shrinks capacity to match usage.\n TODO update this and related methods to match the conventions set by ArrayList",[5290,5291,5292],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[37,181,0,null,null," Only grows capacity, or retains current capacity.",[5294,5295,5296],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[37,206,0,null,null," Only shrinks capacity or retains current capacity.\n It may fail to reduce the capacity in which case the capacity will remain unchanged.",[5298,5299,5300],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[37,238,0,null,null,null,[5302,5303],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[37,244,0,null,null,null,[5305,5306,5307],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"start",null,"",null,false],[37,269,0,null,null,null,[5309,5310],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[37,278,0,null,null,null,[5312],false],[0,0,0,"box_count",null,"",null,false],[37,285,0,null,null,null,[5314],false],[0,0,0,"shelf_index",null,"",null,false],[37,292,0,null,null,null,[5316],false],[0,0,0,"list_index",null,"",null,false],[37,299,0,null,null,null,[5318,5319],false],[0,0,0,"list_index",null,"",null,false],[0,0,0,"shelf_index",null,"",null,false],[37,306,0,null,null,null,[5321,5322,5323,5324],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"from_count",null,"",null,false],[0,0,0,"to_count",null,"",null,false],[37,314,0,null,null,null,null,false],[37,315,0,null,null,null,null,false],[37,316,0,null,null,null,[5328,5329],false],[0,0,0,"SelfType",null,"",null,true],[0,0,0,"ElementPtr",null,"",[5340,5341,5342,5344,5345],true],[37,324,0,null,null,null,[5331],false],[0,0,0,"it",null,"",null,false],[37,348,0,null,null,null,[5333],false],[0,0,0,"it",null,"",null,false],[37,365,0,null,null,null,[5335],false],[0,0,0,"it",null,"",null,false],[37,374,0,null,null,null,[5337,5338],false],[0,0,0,"it",null,"",null,false],[0,0,0,"index",null,"",null,false],[37,317,0,null,null,null,null,false],[0,0,0,"list",null,null,null,false],[0,0,0,"index",null,null,null,false],[0,0,0,"box_index",null,null,null,false],[37,317,0,null,null,null,null,false],[0,0,0,"shelf_index",null,null,null,false],[0,0,0,"shelf_size",null,null,null,false],[37,384,0,null,null,null,[5347,5348],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[37,396,0,null,null,null,[5350,5351],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start_index",null,"",null,false],[37,78,0,null,null,null,null,false],[0,0,0,"prealloc_segment",null,null,null,false],[37,78,0,null,null,null,null,false],[0,0,0,"dynamic_segments",null,null,null,false],[0,0,0,"len",null,null,null,false],[37,419,0,null,null,null,[5358],false],[0,0,0,"prealloc",null,"",null,true],[37,524,0,null,null," TODO look into why this std.math function was changed in\n fc9430f56798a53f9393a697f4ccd6bf9981b970.",[5360,5361],false],[0,0,0,"T",null,"",null,true],[0,0,0,"x",null,"",null,false],[0,38,0,null,null,null,null,false],[0,0,0,"SemanticVersion.zig",null," A software version formatted according to the Semantic Versioning 2.0.0 specification.\n\n See: https://semver.org\n",[5391,5392,5393,5395,5397],false],[38,4,0,null,null,null,null,false],[38,5,0,null,null,null,null,false],[38,13,0,null,null,null,[5374,5376],false],[38,17,0,null,null,null,[5368,5369],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ver",null,"",null,false],[38,25,0,null,null," Checks if system is guaranteed to be at least `version` or older than `version`.\n Returns `null` if a runtime check is required.",[5371,5372],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ver",null,"",null,false],[38,13,0,null,null,null,null,false],[0,0,0,"min",null,null,null,false],[38,13,0,null,null,null,null,false],[0,0,0,"max",null,null,null,false],[38,32,0,null,null,null,[5378,5379],false],[0,0,0,"lhs",null,"",null,false],[0,0,0,"rhs",null,"",null,false],[38,84,0,null,null,null,[5381],false],[0,0,0,"text",null,"",null,false],[38,142,0,null,null,null,[5383],false],[0,0,0,"text",null,"",null,false],[38,152,0,null,null,null,[5385,5386,5387,5388],false],[0,0,0,"self",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"out_stream",null,"",null,false],[38,165,0,null,null,null,null,false],[38,166,0,null,null,null,null,false],[0,0,0,"major",null,null,null,false],[0,0,0,"minor",null,null,null,false],[0,0,0,"patch",null,null,null,false],[38,0,0,null,null,null,null,false],[0,0,0,"pre",null,null,null,false],[38,0,0,null,null,null,null,false],[0,0,0,"build",null,null,null,false],[0,39,0,null,null,null,null,false],[0,0,0,"linked_list.zig",null,"",[],false],[39,0,0,null,null,null,null,false],[39,1,0,null,null,null,null,false],[39,2,0,null,null,null,null,false],[39,3,0,null,null,null,null,false],[39,12,0,null,null," A singly-linked list is headed by a single forward pointer. The elements\n are singly linked for minimum space and pointer manipulation overhead at\n the expense of O(n) removal for arbitrary elements. New elements can be\n added to the list after an existing element or at the head of the list.\n A singly-linked list may only be traversed in the forward direction.\n Singly-linked lists are ideal for applications with large datasets and\n few or no removals or for implementing a LIFO queue.",[5405],false],[0,0,0,"T",null,"",[5435],true],[39,14,0,null,null,null,null,false],[39,17,0,null,null," Node inside the linked list wrapping the actual data.",[5421,5423],false],[39,21,0,null,null,null,null,false],[39,27,0,null,null," Insert a new node after the current one.\n\n Arguments:\n     new_node: Pointer to the new node to insert.",[5410,5411],false],[0,0,0,"node",null,"",null,false],[0,0,0,"new_node",null,"",null,false],[39,38,0,null,null," Remove a node from the list.\n\n Arguments:\n     node: Pointer to the node to be removed.\n Returns:\n     node removed",[5413],false],[0,0,0,"node",null,"",null,false],[39,46,0,null,null," Iterate over the singly-linked list from this node, until the final node is found.\n This operation is O(N).",[5415],false],[0,0,0,"node",null,"",null,false],[39,55,0,null,null," Iterate over each next node, returning the count of all nodes except the starting one.\n This operation is O(N).",[5417],false],[0,0,0,"node",null,"",null,false],[39,66,0,null,null," Reverse the list starting from this node in-place.\n This operation is O(N).",[5419],false],[0,0,0,"indirect",null,"",null,false],[39,17,0,null,null,null,null,false],[0,0,0,"next",null,null,null,false],[39,17,0,null,null,null,null,false],[0,0,0,"data",null,null,null,false],[39,85,0,null,null," Insert a new node at the head.\n\n Arguments:\n     new_node: Pointer to the new node to insert.",[5425,5426],false],[0,0,0,"list",null,"",null,false],[0,0,0,"new_node",null,"",null,false],[39,94,0,null,null," Remove a node from the list.\n\n Arguments:\n     node: Pointer to the node to be removed.",[5428,5429],false],[0,0,0,"list",null,"",null,false],[0,0,0,"node",null,"",null,false],[39,110,0,null,null," Remove and return the first node in the list.\n\n Returns:\n     A pointer to the first node in the list.",[5431],false],[0,0,0,"list",null,"",null,false],[39,118,0,null,null," Iterate over all nodes, returning the count.\n This operation is O(N).",[5433],false],[0,0,0,"list",null,"",null,false],[39,13,0,null,null,null,null,false],[0,0,0,"first",null,null,null,false],[39,179,0,null,null," A tail queue is headed by a pair of pointers, one to the head of the\n list and the other to the tail of the list. The elements are doubly\n linked so that an arbitrary element can be removed without a need to\n traverse the list. New elements can be added to the list before or\n after an existing element, at the head of the list, or at the end of\n the list. A tail queue may be traversed in either direction.",[5437],false],[0,0,0,"T",null,"",[5471,5473,5474],true],[39,181,0,null,null,null,null,false],[39,184,0,null,null," Node inside the linked list wrapping the actual data.",[5441,5443,5445],false],[39,184,0,null,null,null,null,false],[0,0,0,"prev",null,null,null,false],[39,184,0,null,null,null,null,false],[0,0,0,"next",null,null,null,false],[39,184,0,null,null,null,null,false],[0,0,0,"data",null,null,null,false],[39,199,0,null,null," Insert a new node after an existing one.\n\n Arguments:\n     node: Pointer to a node in the list.\n     new_node: Pointer to the new node to insert.",[5447,5448,5449],false],[0,0,0,"list",null,"",null,false],[0,0,0,"node",null,"",null,false],[0,0,0,"new_node",null,"",null,false],[39,220,0,null,null," Insert a new node before an existing one.\n\n Arguments:\n     node: Pointer to a node in the list.\n     new_node: Pointer to the new node to insert.",[5451,5452,5453],false],[0,0,0,"list",null,"",null,false],[0,0,0,"node",null,"",null,false],[0,0,0,"new_node",null,"",null,false],[39,241,0,null,null," Concatenate list2 onto the end of list1, removing all entries from the former.\n\n Arguments:\n     list1: the list to concatenate onto\n     list2: the list to be concatenated",[5455,5456],false],[0,0,0,"list1",null,"",null,false],[0,0,0,"list2",null,"",null,false],[39,262,0,null,null," Insert a new node at the end of the list.\n\n Arguments:\n     new_node: Pointer to the new node to insert.",[5458,5459],false],[0,0,0,"list",null,"",null,false],[0,0,0,"new_node",null,"",null,false],[39,276,0,null,null," Insert a new node at the beginning of the list.\n\n Arguments:\n     new_node: Pointer to the new node to insert.",[5461,5462],false],[0,0,0,"list",null,"",null,false],[0,0,0,"new_node",null,"",null,false],[39,295,0,null,null," Remove a node from the list.\n\n Arguments:\n     node: Pointer to the node to be removed.",[5464,5465],false],[0,0,0,"list",null,"",null,false],[0,0,0,"node",null,"",null,false],[39,320,0,null,null," Remove and return the last node in the list.\n\n Returns:\n     A pointer to the last node in the list.",[5467],false],[0,0,0,"list",null,"",null,false],[39,330,0,null,null," Remove and return the first node in the list.\n\n Returns:\n     A pointer to the first node in the list.",[5469],false],[0,0,0,"list",null,"",null,false],[39,180,0,null,null,null,null,false],[0,0,0,"first",null,null,null,false],[39,180,0,null,null,null,null,false],[0,0,0,"last",null,null,null,false],[0,0,0,"len",null,null,null,false],[0,40,0,null,null,null,null,false],[0,41,0,null,null,null,null,false],[0,42,0,null,null,null,null,false],[0,43,0,null,null,null,null,false],[0,44,0,null,null,null,null,false],[0,45,0,null,null,null,null,false],[0,46,0,null,null,null,null,false],[0,0,0,"target.zig",null,"",[],false],[40,0,0,null,null,null,null,false],[40,1,0,null,null,null,null,false],[40,2,0,null,null,null,null,false],[40,3,0,null,null,null,null,false],[40,5,0,null,null,null,[8761,8763,8765,8767],false],[40,11,0,null,null,null,[5617,5619],false],[40,15,0,null,null,null,[5499,5500,5501,5502,5503,5504,5505,5506,5507,5508,5509,5510,5511,5512,5513,5514,5515,5516,5517,5518,5519,5520,5521,5522,5523,5524,5525,5526,5527,5528,5529,5530,5531,5532,5533,5534,5535,5536,5537,5538,5539,5540,5541,5542],false],[40,61,0,null,null,null,[5491],false],[0,0,0,"tag",null,"",null,false],[40,68,0,null,null,null,[5493],false],[0,0,0,"tag",null,"",null,false],[40,75,0,null,null,null,[5495],false],[0,0,0,"tag",null,"",null,false],[40,85,0,null,null,null,[5497,5498],false],[0,0,0,"tag",null,"",null,false],[0,0,0,"arch",null,"",null,false],[0,0,0,"freestanding",null,null,null,false],[0,0,0,"ananas",null,null,null,false],[0,0,0,"cloudabi",null,null,null,false],[0,0,0,"dragonfly",null,null,null,false],[0,0,0,"freebsd",null,null,null,false],[0,0,0,"fuchsia",null,null,null,false],[0,0,0,"ios",null,null,null,false],[0,0,0,"kfreebsd",null,null,null,false],[0,0,0,"linux",null,null,null,false],[0,0,0,"lv2",null,null,null,false],[0,0,0,"macos",null,null,null,false],[0,0,0,"netbsd",null,null,null,false],[0,0,0,"openbsd",null,null,null,false],[0,0,0,"solaris",null,null,null,false],[0,0,0,"windows",null,null,null,false],[0,0,0,"zos",null,null,null,false],[0,0,0,"haiku",null,null,null,false],[0,0,0,"minix",null,null,null,false],[0,0,0,"rtems",null,null,null,false],[0,0,0,"nacl",null,null,null,false],[0,0,0,"aix",null,null,null,false],[0,0,0,"cuda",null,null,null,false],[0,0,0,"nvcl",null,null,null,false],[0,0,0,"amdhsa",null,null,null,false],[0,0,0,"ps4",null,null,null,false],[0,0,0,"ps5",null,null,null,false],[0,0,0,"elfiamcu",null,null,null,false],[0,0,0,"tvos",null,null,null,false],[0,0,0,"watchos",null,null,null,false],[0,0,0,"driverkit",null,null,null,false],[0,0,0,"mesa3d",null,null,null,false],[0,0,0,"contiki",null,null,null,false],[0,0,0,"amdpal",null,null,null,false],[0,0,0,"hermit",null,null,null,false],[0,0,0,"hurd",null,null,null,false],[0,0,0,"wasi",null,null,null,false],[0,0,0,"emscripten",null,null,null,false],[0,0,0,"shadermodel",null,null,null,false],[0,0,0,"uefi",null,null,null,false],[0,0,0,"opencl",null,null,null,false],[0,0,0,"glsl450",null,null,null,false],[0,0,0,"vulkan",null,null,null,false],[0,0,0,"plan9",null,null,null,false],[0,0,0,"other",null,null,null,false],[40,95,0,null,null," Based on NTDDI version constants from\n https://docs.microsoft.com/en-us/cpp/porting/modifying-winver-and-win32-winnt",[5565,5566,5567,5568,5569,5570,5571,5572,5573,5574,5575,5576,5577,5578,5579,5580,5581,5582,5583],false],[40,118,0,null,null," Latest Windows version that the Zig Standard Library is aware of",null,false],[40,122,0,null,null," Compared against build numbers reported by the runtime to distinguish win10 versions,\n where 0x0A000000 + index corresponds to the WindowsVersion u32 value.",null,false],[40,137,0,null,null," Returns whether the first version `self` is newer (greater) than or equal to the second version `ver`.",[5547,5548],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ver",null,"",null,false],[40,141,0,null,null,null,[5557,5559],false],[40,145,0,null,null,null,[5551,5552],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ver",null,"",null,false],[40,151,0,null,null," Checks if system is guaranteed to be at least `version` or older than `version`.\n Returns `null` if a runtime check is required.",[5554,5555],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ver",null,"",null,false],[40,141,0,null,null,null,null,false],[0,0,0,"min",null,null,null,false],[40,141,0,null,null,null,null,false],[0,0,0,"max",null,null,null,false],[40,160,0,null,null," This function is defined to serialize a Zig source code representation of this\n type, that, when parsed, will deserialize into the same data.",[5561,5562,5563,5564],false],[0,0,0,"self",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"",null,"",null,false],[0,0,0,"out_stream",null,"",null,false],[0,0,0,"nt4",null,null,null,false],[0,0,0,"win2k",null,null,null,false],[0,0,0,"xp",null,null,null,false],[0,0,0,"ws2003",null,null,null,false],[0,0,0,"vista",null,null,null,false],[0,0,0,"win7",null,null,null,false],[0,0,0,"win8",null,null,null,false],[0,0,0,"win8_1",null,null,null,false],[0,0,0,"win10",null,null,null,false],[0,0,0,"win10_th2",null,null,null,false],[0,0,0,"win10_rs1",null,null,null,false],[0,0,0,"win10_rs2",null,null,null,false],[0,0,0,"win10_rs3",null,null,null,false],[0,0,0,"win10_rs4",null,null,null,false],[0,0,0,"win10_rs5",null,null,null,false],[0,0,0,"win10_19h1",null,null,null,false],[0,0,0,"win10_vb",null,null,null,false],[0,0,0,"win10_mn",null,null,null,false],[0,0,0,"win10_fe",null,null,null,false],[40,185,0,null,null,null,[5592,5594],false],[40,189,0,null,null,null,[5586,5587],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ver",null,"",null,false],[40,195,0,null,null," Checks if system is guaranteed to be at least `version` or older than `version`.\n Returns `null` if a runtime check is required.",[5589,5590],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ver",null,"",null,false],[40,185,0,null,null,null,null,false],[0,0,0,"range",null,null,null,false],[40,185,0,null,null,null,null,false],[0,0,0,"glibc",null,null,null,false],[40,224,0,null,null," The version ranges here represent the minimum OS version to be supported\n and the maximum OS version to be supported. The default values represent\n the range that the Zig Standard Library bases its abstractions on.\n\n The minimum version of the range is the main setting to tweak for a target.\n Usually, the maximum target OS version will remain the default, which is\n the latest released version of the OS.\n\n To test at compile time if the target is guaranteed to support a given OS feature,\n one should check that the minimum version of the range is greater than or equal to\n the version the feature was introduced in.\n\n To test at compile time if the target certainly will not support a given OS feature,\n one should check that the maximum version of the range is less than the version the\n feature was introduced in.\n\n If neither of these cases apply, a runtime check should be used to determine if the\n target supports a given OS feature.\n\n Binaries built with a given maximum version will continue to function on newer\n operating system versions. However, such a binary may not take full advantage of the\n newer operating system APIs.\n\n See `Os.isAtLeast`.",[5599,5600,5601,5602],false],[40,232,0,null,null," The default `VersionRange` represents the range that the Zig Standard Library\n bases its abstractions on.",[5597,5598],false],[0,0,0,"tag",null,"",null,false],[0,0,0,"arch",null,"",null,false],[0,0,0,"none",null,null,null,false],[0,0,0,"semver",null,null,null,false],[0,0,0,"linux",null,null,null,false],[0,0,0,"windows",null,null,null,false],[40,353,0,null,null,null,[5604,5605,5606,5607],false],[0,0,0,"none",null,null,null,false],[0,0,0,"semver",null,null,null,false],[0,0,0,"linux",null,null,null,false],[0,0,0,"windows",null,null,null,false],[40,362,0,null,null," Provides a tagged union. `Target` does not store the tag because it is\n redundant with the OS tag; this function abstracts that part away.",[5609],false],[0,0,0,"self",null,"",null,false],[40,384,0,null,null," Checks if system is guaranteed to be at least `version` or older than `version`.\n Returns `null` if a runtime check is required.",[5611,5612,5613],false],[0,0,0,"self",null,"",null,false],[0,0,0,"tag",null,"",null,true],[0,0,0,"version",null,"",null,false],[40,397,0,null,null," On Darwin, we always link libSystem which contains libc.\n Similarly on FreeBSD and NetBSD we always link system libc\n since this is the stable syscall interface.",[5615],false],[0,0,0,"os",null,"",null,false],[40,11,0,null,null,null,null,false],[0,0,0,"tag",null,null,null,false],[40,11,0,null,null,null,null,false],[0,0,0,"version_range",null,null,null,false],[40,450,0,null,null,null,null,false],[0,0,0,"target/aarch64.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[41,2,0,null,null,null,null,false],[41,3,0,null,null,null,null,false],[41,4,0,null,null,null,null,false],[41,6,0,null,null,null,[5626,5627,5628,5629,5630,5631,5632,5633,5634,5635,5636,5637,5638,5639,5640,5641,5642,5643,5644,5645,5646,5647,5648,5649,5650,5651,5652,5653,5654,5655,5656,5657,5658,5659,5660,5661,5662,5663,5664,5665,5666,5667,5668,5669,5670,5671,5672,5673,5674,5675,5676,5677,5678,5679,5680,5681,5682,5683,5684,5685,5686,5687,5688,5689,5690,5691,5692,5693,5694,5695,5696,5697,5698,5699,5700,5701,5702,5703,5704,5705,5706,5707,5708,5709,5710,5711,5712,5713,5714,5715,5716,5717,5718,5719,5720,5721,5722,5723,5724,5725,5726,5727,5728,5729,5730,5731,5732,5733,5734,5735,5736,5737,5738,5739,5740,5741,5742,5743,5744,5745,5746,5747,5748,5749,5750,5751,5752,5753,5754,5755,5756,5757,5758,5759,5760,5761,5762,5763,5764,5765,5766,5767,5768,5769,5770,5771,5772,5773,5774,5775,5776,5777,5778,5779,5780,5781,5782,5783,5784,5785,5786,5787,5788,5789,5790,5791,5792,5793,5794,5795,5796,5797,5798,5799,5800,5801,5802,5803,5804,5805,5806,5807,5808,5809,5810,5811,5812,5813,5814,5815,5816,5817,5818,5819,5820,5821,5822,5823],false],[0,0,0,"a510",null,null,null,false],[0,0,0,"a65",null,null,null,false],[0,0,0,"a710",null,null,null,false],[0,0,0,"a76",null,null,null,false],[0,0,0,"a78",null,null,null,false],[0,0,0,"a78c",null,null,null,false],[0,0,0,"aes",null,null,null,false],[0,0,0,"aggressive_fma",null,null,null,false],[0,0,0,"alternate_sextload_cvt_f32_pattern",null,null,null,false],[0,0,0,"altnzcv",null,null,null,false],[0,0,0,"am",null,null,null,false],[0,0,0,"amvs",null,null,null,false],[0,0,0,"arith_bcc_fusion",null,null,null,false],[0,0,0,"arith_cbz_fusion",null,null,null,false],[0,0,0,"ascend_store_address",null,null,null,false],[0,0,0,"b16b16",null,null,null,false],[0,0,0,"balance_fp_ops",null,null,null,false],[0,0,0,"bf16",null,null,null,false],[0,0,0,"brbe",null,null,null,false],[0,0,0,"bti",null,null,null,false],[0,0,0,"call_saved_x10",null,null,null,false],[0,0,0,"call_saved_x11",null,null,null,false],[0,0,0,"call_saved_x12",null,null,null,false],[0,0,0,"call_saved_x13",null,null,null,false],[0,0,0,"call_saved_x14",null,null,null,false],[0,0,0,"call_saved_x15",null,null,null,false],[0,0,0,"call_saved_x18",null,null,null,false],[0,0,0,"call_saved_x8",null,null,null,false],[0,0,0,"call_saved_x9",null,null,null,false],[0,0,0,"ccdp",null,null,null,false],[0,0,0,"ccidx",null,null,null,false],[0,0,0,"ccpp",null,null,null,false],[0,0,0,"clrbhb",null,null,null,false],[0,0,0,"cmp_bcc_fusion",null,null,null,false],[0,0,0,"complxnum",null,null,null,false],[0,0,0,"contextidr_el2",null,null,null,false],[0,0,0,"cortex_r82",null,null,null,false],[0,0,0,"crc",null,null,null,false],[0,0,0,"crypto",null,null,null,false],[0,0,0,"cssc",null,null,null,false],[0,0,0,"custom_cheap_as_move",null,null,null,false],[0,0,0,"d128",null,null,null,false],[0,0,0,"disable_latency_sched_heuristic",null,null,null,false],[0,0,0,"dit",null,null,null,false],[0,0,0,"dotprod",null,null,null,false],[0,0,0,"ecv",null,null,null,false],[0,0,0,"el2vmsa",null,null,null,false],[0,0,0,"el3",null,null,null,false],[0,0,0,"enable_select_opt",null,null,null,false],[0,0,0,"ete",null,null,null,false],[0,0,0,"exynos_cheap_as_move",null,null,null,false],[0,0,0,"f32mm",null,null,null,false],[0,0,0,"f64mm",null,null,null,false],[0,0,0,"fgt",null,null,null,false],[0,0,0,"fix_cortex_a53_835769",null,null,null,false],[0,0,0,"flagm",null,null,null,false],[0,0,0,"fmv",null,null,null,false],[0,0,0,"force_32bit_jump_tables",null,null,null,false],[0,0,0,"fp16fml",null,null,null,false],[0,0,0,"fp_armv8",null,null,null,false],[0,0,0,"fptoint",null,null,null,false],[0,0,0,"fullfp16",null,null,null,false],[0,0,0,"fuse_address",null,null,null,false],[0,0,0,"fuse_adrp_add",null,null,null,false],[0,0,0,"fuse_aes",null,null,null,false],[0,0,0,"fuse_arith_logic",null,null,null,false],[0,0,0,"fuse_crypto_eor",null,null,null,false],[0,0,0,"fuse_csel",null,null,null,false],[0,0,0,"fuse_literals",null,null,null,false],[0,0,0,"harden_sls_blr",null,null,null,false],[0,0,0,"harden_sls_nocomdat",null,null,null,false],[0,0,0,"harden_sls_retbr",null,null,null,false],[0,0,0,"hbc",null,null,null,false],[0,0,0,"hcx",null,null,null,false],[0,0,0,"i8mm",null,null,null,false],[0,0,0,"ite",null,null,null,false],[0,0,0,"jsconv",null,null,null,false],[0,0,0,"lor",null,null,null,false],[0,0,0,"ls64",null,null,null,false],[0,0,0,"lse",null,null,null,false],[0,0,0,"lse128",null,null,null,false],[0,0,0,"lse2",null,null,null,false],[0,0,0,"lsl_fast",null,null,null,false],[0,0,0,"mec",null,null,null,false],[0,0,0,"mops",null,null,null,false],[0,0,0,"mpam",null,null,null,false],[0,0,0,"mte",null,null,null,false],[0,0,0,"neon",null,null,null,false],[0,0,0,"nmi",null,null,null,false],[0,0,0,"no_bti_at_return_twice",null,null,null,false],[0,0,0,"no_neg_immediates",null,null,null,false],[0,0,0,"no_zcz_fp",null,null,null,false],[0,0,0,"nv",null,null,null,false],[0,0,0,"outline_atomics",null,null,null,false],[0,0,0,"pan",null,null,null,false],[0,0,0,"pan_rwv",null,null,null,false],[0,0,0,"pauth",null,null,null,false],[0,0,0,"perfmon",null,null,null,false],[0,0,0,"predictable_select_expensive",null,null,null,false],[0,0,0,"predres",null,null,null,false],[0,0,0,"prfm_slc_target",null,null,null,false],[0,0,0,"rand",null,null,null,false],[0,0,0,"ras",null,null,null,false],[0,0,0,"rasv2",null,null,null,false],[0,0,0,"rcpc",null,null,null,false],[0,0,0,"rcpc3",null,null,null,false],[0,0,0,"rcpc_immo",null,null,null,false],[0,0,0,"rdm",null,null,null,false],[0,0,0,"reserve_x1",null,null,null,false],[0,0,0,"reserve_x10",null,null,null,false],[0,0,0,"reserve_x11",null,null,null,false],[0,0,0,"reserve_x12",null,null,null,false],[0,0,0,"reserve_x13",null,null,null,false],[0,0,0,"reserve_x14",null,null,null,false],[0,0,0,"reserve_x15",null,null,null,false],[0,0,0,"reserve_x18",null,null,null,false],[0,0,0,"reserve_x2",null,null,null,false],[0,0,0,"reserve_x20",null,null,null,false],[0,0,0,"reserve_x21",null,null,null,false],[0,0,0,"reserve_x22",null,null,null,false],[0,0,0,"reserve_x23",null,null,null,false],[0,0,0,"reserve_x24",null,null,null,false],[0,0,0,"reserve_x25",null,null,null,false],[0,0,0,"reserve_x26",null,null,null,false],[0,0,0,"reserve_x27",null,null,null,false],[0,0,0,"reserve_x28",null,null,null,false],[0,0,0,"reserve_x3",null,null,null,false],[0,0,0,"reserve_x30",null,null,null,false],[0,0,0,"reserve_x4",null,null,null,false],[0,0,0,"reserve_x5",null,null,null,false],[0,0,0,"reserve_x6",null,null,null,false],[0,0,0,"reserve_x7",null,null,null,false],[0,0,0,"reserve_x9",null,null,null,false],[0,0,0,"rme",null,null,null,false],[0,0,0,"sb",null,null,null,false],[0,0,0,"sel2",null,null,null,false],[0,0,0,"sha2",null,null,null,false],[0,0,0,"sha3",null,null,null,false],[0,0,0,"slow_misaligned_128store",null,null,null,false],[0,0,0,"slow_paired_128",null,null,null,false],[0,0,0,"slow_strqro_store",null,null,null,false],[0,0,0,"sm4",null,null,null,false],[0,0,0,"sme",null,null,null,false],[0,0,0,"sme2",null,null,null,false],[0,0,0,"sme2p1",null,null,null,false],[0,0,0,"sme_f16f16",null,null,null,false],[0,0,0,"sme_f64f64",null,null,null,false],[0,0,0,"sme_i16i64",null,null,null,false],[0,0,0,"spe",null,null,null,false],[0,0,0,"spe_eef",null,null,null,false],[0,0,0,"specres2",null,null,null,false],[0,0,0,"specrestrict",null,null,null,false],[0,0,0,"ssbs",null,null,null,false],[0,0,0,"strict_align",null,null,null,false],[0,0,0,"sve",null,null,null,false],[0,0,0,"sve2",null,null,null,false],[0,0,0,"sve2_aes",null,null,null,false],[0,0,0,"sve2_bitperm",null,null,null,false],[0,0,0,"sve2_sha3",null,null,null,false],[0,0,0,"sve2_sm4",null,null,null,false],[0,0,0,"sve2p1",null,null,null,false],[0,0,0,"tagged_globals",null,null,null,false],[0,0,0,"the",null,null,null,false],[0,0,0,"tlb_rmi",null,null,null,false],[0,0,0,"tme",null,null,null,false],[0,0,0,"tpidr_el1",null,null,null,false],[0,0,0,"tpidr_el2",null,null,null,false],[0,0,0,"tpidr_el3",null,null,null,false],[0,0,0,"tracev8_4",null,null,null,false],[0,0,0,"trbe",null,null,null,false],[0,0,0,"uaops",null,null,null,false],[0,0,0,"use_experimental_zeroing_pseudos",null,null,null,false],[0,0,0,"use_postra_scheduler",null,null,null,false],[0,0,0,"use_reciprocal_square_root",null,null,null,false],[0,0,0,"use_scalar_inc_vl",null,null,null,false],[0,0,0,"v8_1a",null,null,null,false],[0,0,0,"v8_2a",null,null,null,false],[0,0,0,"v8_3a",null,null,null,false],[0,0,0,"v8_4a",null,null,null,false],[0,0,0,"v8_5a",null,null,null,false],[0,0,0,"v8_6a",null,null,null,false],[0,0,0,"v8_7a",null,null,null,false],[0,0,0,"v8_8a",null,null,null,false],[0,0,0,"v8_9a",null,null,null,false],[0,0,0,"v8a",null,null,null,false],[0,0,0,"v8r",null,null,null,false],[0,0,0,"v9_1a",null,null,null,false],[0,0,0,"v9_2a",null,null,null,false],[0,0,0,"v9_3a",null,null,null,false],[0,0,0,"v9_4a",null,null,null,false],[0,0,0,"v9a",null,null,null,false],[0,0,0,"vh",null,null,null,false],[0,0,0,"wfxt",null,null,null,false],[0,0,0,"xs",null,null,null,false],[0,0,0,"zcm",null,null,null,false],[0,0,0,"zcz",null,null,null,false],[0,0,0,"zcz_fp_workaround",null,null,null,false],[0,0,0,"zcz_gp",null,null,null,false],[41,207,0,null,null,null,null,false],[41,208,0,null,null,null,null,false],[41,209,0,null,null,null,null,false],[41,210,0,null,null,null,null,false],[41,212,0,null,null,null,null,false],[41,1444,0,null,null,null,[],false],[41,1445,0,null,null,null,null,false],[41,1460,0,null,null,null,null,false],[41,1479,0,null,null,null,null,false],[41,1500,0,null,null,null,null,false],[41,1522,0,null,null,null,null,false],[41,1540,0,null,null,null,null,false],[41,1558,0,null,null,null,null,false],[41,1577,0,null,null,null,null,false],[41,1609,0,null,null,null,null,false],[41,1632,0,null,null,null,null,false],[41,1656,0,null,null,null,null,false],[41,1674,0,null,null,null,null,false],[41,1692,0,null,null,null,null,false],[41,1710,0,null,null,null,null,false],[41,1734,0,null,null,null,null,false],[41,1766,0,null,null,null,null,false],[41,1789,0,null,null,null,null,false],[41,1807,0,null,null,null,null,false],[41,1825,0,null,null,null,null,false],[41,1834,0,null,null,null,null,false],[41,1844,0,null,null,null,null,false],[41,1854,0,null,null,null,null,false],[41,1869,0,null,null,null,null,false],[41,1884,0,null,null,null,null,false],[41,1900,0,null,null,null,null,false],[41,1918,0,null,null,null,null,false],[41,1932,0,null,null,null,null,false],[41,1946,0,null,null,null,null,false],[41,1961,0,null,null,null,null,false],[41,1982,0,null,null,null,null,false],[41,1996,0,null,null,null,null,false],[41,2009,0,null,null,null,null,false],[41,2024,0,null,null,null,null,false],[41,2038,0,null,null,null,null,false],[41,2052,0,null,null,null,null,false],[41,2070,0,null,null,null,null,false],[41,2085,0,null,null,null,null,false],[41,2102,0,null,null,null,null,false],[41,2115,0,null,null,null,null,false],[41,2135,0,null,null,null,null,false],[41,2158,0,null,null,null,null,false],[41,2178,0,null,null,null,null,false],[41,2198,0,null,null,null,null,false],[41,2216,0,null,null,null,null,false],[41,2226,0,null,null,null,null,false],[41,2243,0,null,null,null,null,false],[41,2259,0,null,null,null,null,false],[41,2279,0,null,null,null,null,false],[41,2303,0,null,null,null,null,false],[41,2327,0,null,null,null,null,false],[41,2344,0,null,null,null,null,false],[41,2356,0,null,null,null,null,false],[41,2371,0,null,null,null,null,false],[41,2393,0,null,null,null,null,false],[41,2409,0,null,null,null,null,false],[41,2428,0,null,null,null,null,false],[41,2447,0,null,null,null,null,false],[41,2469,0,null,null,null,null,false],[41,2489,0,null,null,null,null,false],[41,2504,0,null,null,null,null,false],[41,2516,0,null,null,null,null,false],[41,2528,0,null,null,null,null,false],[41,2543,0,null,null,null,null,false],[41,2555,0,null,null,null,null,false],[41,2567,0,null,null,null,null,false],[41,2579,0,null,null,null,null,false],[41,2594,0,null,null,null,null,false],[40,451,0,null,null,null,null,false],[0,0,0,"target/arc.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[42,2,0,null,null,null,null,false],[42,3,0,null,null,null,null,false],[42,4,0,null,null,null,null,false],[42,6,0,null,null,null,[5903],false],[0,0,0,"norm",null,null,null,false],[42,10,0,null,null,null,null,false],[42,11,0,null,null,null,null,false],[42,12,0,null,null,null,null,false],[42,13,0,null,null,null,null,false],[42,15,0,null,null,null,null,false],[42,32,0,null,null,null,[],false],[42,33,0,null,null,null,null,false],[40,452,0,null,null,null,null,false],[0,0,0,"target/amdgpu.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[43,2,0,null,null,null,null,false],[43,3,0,null,null,null,null,false],[43,4,0,null,null,null,null,false],[43,6,0,null,null,null,[5917,5918,5919,5920,5921,5922,5923,5924,5925,5926,5927,5928,5929,5930,5931,5932,5933,5934,5935,5936,5937,5938,5939,5940,5941,5942,5943,5944,5945,5946,5947,5948,5949,5950,5951,5952,5953,5954,5955,5956,5957,5958,5959,5960,5961,5962,5963,5964,5965,5966,5967,5968,5969,5970,5971,5972,5973,5974,5975,5976,5977,5978,5979,5980,5981,5982,5983,5984,5985,5986,5987,5988,5989,5990,5991,5992,5993,5994,5995,5996,5997,5998,5999,6000,6001,6002,6003,6004,6005,6006,6007,6008,6009,6010,6011,6012,6013,6014,6015,6016,6017,6018,6019,6020,6021,6022,6023,6024,6025,6026,6027,6028,6029,6030,6031,6032,6033,6034,6035,6036,6037,6038,6039,6040,6041,6042,6043,6044,6045,6046,6047,6048,6049,6050,6051,6052,6053,6054,6055,6056,6057,6058,6059,6060,6061,6062],false],[0,0,0,"16_bit_insts",null,null,null,false],[0,0,0,"a16",null,null,null,false],[0,0,0,"add_no_carry_insts",null,null,null,false],[0,0,0,"aperture_regs",null,null,null,false],[0,0,0,"architected_flat_scratch",null,null,null,false],[0,0,0,"atomic_fadd_no_rtn_insts",null,null,null,false],[0,0,0,"atomic_fadd_rtn_insts",null,null,null,false],[0,0,0,"atomic_pk_fadd_no_rtn_insts",null,null,null,false],[0,0,0,"auto_waitcnt_before_barrier",null,null,null,false],[0,0,0,"back_off_barrier",null,null,null,false],[0,0,0,"ci_insts",null,null,null,false],[0,0,0,"cumode",null,null,null,false],[0,0,0,"dl_insts",null,null,null,false],[0,0,0,"dot1_insts",null,null,null,false],[0,0,0,"dot2_insts",null,null,null,false],[0,0,0,"dot3_insts",null,null,null,false],[0,0,0,"dot4_insts",null,null,null,false],[0,0,0,"dot5_insts",null,null,null,false],[0,0,0,"dot6_insts",null,null,null,false],[0,0,0,"dot7_insts",null,null,null,false],[0,0,0,"dot8_insts",null,null,null,false],[0,0,0,"dot9_insts",null,null,null,false],[0,0,0,"dpp",null,null,null,false],[0,0,0,"dpp8",null,null,null,false],[0,0,0,"dpp_64bit",null,null,null,false],[0,0,0,"ds128",null,null,null,false],[0,0,0,"ds_src2_insts",null,null,null,false],[0,0,0,"extended_image_insts",null,null,null,false],[0,0,0,"fast_denormal_f32",null,null,null,false],[0,0,0,"fast_fmaf",null,null,null,false],[0,0,0,"flat_address_space",null,null,null,false],[0,0,0,"flat_atomic_fadd_f32_inst",null,null,null,false],[0,0,0,"flat_for_global",null,null,null,false],[0,0,0,"flat_global_insts",null,null,null,false],[0,0,0,"flat_inst_offsets",null,null,null,false],[0,0,0,"flat_scratch",null,null,null,false],[0,0,0,"flat_scratch_insts",null,null,null,false],[0,0,0,"flat_segment_offset_bug",null,null,null,false],[0,0,0,"fma_mix_insts",null,null,null,false],[0,0,0,"fmacf64_inst",null,null,null,false],[0,0,0,"fmaf",null,null,null,false],[0,0,0,"fp64",null,null,null,false],[0,0,0,"fp8_insts",null,null,null,false],[0,0,0,"full_rate_64_ops",null,null,null,false],[0,0,0,"g16",null,null,null,false],[0,0,0,"gcn3_encoding",null,null,null,false],[0,0,0,"get_wave_id_inst",null,null,null,false],[0,0,0,"gfx10",null,null,null,false],[0,0,0,"gfx10_3_insts",null,null,null,false],[0,0,0,"gfx10_a_encoding",null,null,null,false],[0,0,0,"gfx10_b_encoding",null,null,null,false],[0,0,0,"gfx10_insts",null,null,null,false],[0,0,0,"gfx11",null,null,null,false],[0,0,0,"gfx11_full_vgprs",null,null,null,false],[0,0,0,"gfx11_insts",null,null,null,false],[0,0,0,"gfx7_gfx8_gfx9_insts",null,null,null,false],[0,0,0,"gfx8_insts",null,null,null,false],[0,0,0,"gfx9",null,null,null,false],[0,0,0,"gfx90a_insts",null,null,null,false],[0,0,0,"gfx940_insts",null,null,null,false],[0,0,0,"gfx9_insts",null,null,null,false],[0,0,0,"half_rate_64_ops",null,null,null,false],[0,0,0,"image_gather4_d16_bug",null,null,null,false],[0,0,0,"image_insts",null,null,null,false],[0,0,0,"image_store_d16_bug",null,null,null,false],[0,0,0,"inst_fwd_prefetch_bug",null,null,null,false],[0,0,0,"int_clamp_insts",null,null,null,false],[0,0,0,"inv_2pi_inline_imm",null,null,null,false],[0,0,0,"lds_branch_vmem_war_hazard",null,null,null,false],[0,0,0,"lds_misaligned_bug",null,null,null,false],[0,0,0,"ldsbankcount16",null,null,null,false],[0,0,0,"ldsbankcount32",null,null,null,false],[0,0,0,"load_store_opt",null,null,null,false],[0,0,0,"localmemorysize32768",null,null,null,false],[0,0,0,"localmemorysize65536",null,null,null,false],[0,0,0,"mad_intra_fwd_bug",null,null,null,false],[0,0,0,"mad_mac_f32_insts",null,null,null,false],[0,0,0,"mad_mix_insts",null,null,null,false],[0,0,0,"mai_insts",null,null,null,false],[0,0,0,"max_private_element_size_16",null,null,null,false],[0,0,0,"max_private_element_size_4",null,null,null,false],[0,0,0,"max_private_element_size_8",null,null,null,false],[0,0,0,"mfma_inline_literal_bug",null,null,null,false],[0,0,0,"mimg_r128",null,null,null,false],[0,0,0,"movrel",null,null,null,false],[0,0,0,"negative_scratch_offset_bug",null,null,null,false],[0,0,0,"negative_unaligned_scratch_offset_bug",null,null,null,false],[0,0,0,"no_data_dep_hazard",null,null,null,false],[0,0,0,"no_sdst_cmpx",null,null,null,false],[0,0,0,"nsa_clause_bug",null,null,null,false],[0,0,0,"nsa_encoding",null,null,null,false],[0,0,0,"nsa_max_size_13",null,null,null,false],[0,0,0,"nsa_max_size_5",null,null,null,false],[0,0,0,"nsa_to_vmem_bug",null,null,null,false],[0,0,0,"offset_3f_bug",null,null,null,false],[0,0,0,"packed_fp32_ops",null,null,null,false],[0,0,0,"packed_tid",null,null,null,false],[0,0,0,"pk_fmac_f16_inst",null,null,null,false],[0,0,0,"promote_alloca",null,null,null,false],[0,0,0,"prt_strict_null",null,null,null,false],[0,0,0,"r128_a16",null,null,null,false],[0,0,0,"s_memrealtime",null,null,null,false],[0,0,0,"s_memtime_inst",null,null,null,false],[0,0,0,"scalar_atomics",null,null,null,false],[0,0,0,"scalar_flat_scratch_insts",null,null,null,false],[0,0,0,"scalar_stores",null,null,null,false],[0,0,0,"sdwa",null,null,null,false],[0,0,0,"sdwa_mav",null,null,null,false],[0,0,0,"sdwa_omod",null,null,null,false],[0,0,0,"sdwa_out_mods_vopc",null,null,null,false],[0,0,0,"sdwa_scalar",null,null,null,false],[0,0,0,"sdwa_sdst",null,null,null,false],[0,0,0,"sea_islands",null,null,null,false],[0,0,0,"sgpr_init_bug",null,null,null,false],[0,0,0,"shader_cycles_register",null,null,null,false],[0,0,0,"si_scheduler",null,null,null,false],[0,0,0,"smem_to_vector_write_hazard",null,null,null,false],[0,0,0,"southern_islands",null,null,null,false],[0,0,0,"sramecc",null,null,null,false],[0,0,0,"sramecc_support",null,null,null,false],[0,0,0,"tgsplit",null,null,null,false],[0,0,0,"trap_handler",null,null,null,false],[0,0,0,"trig_reduced_range",null,null,null,false],[0,0,0,"true16",null,null,null,false],[0,0,0,"unaligned_access_mode",null,null,null,false],[0,0,0,"unaligned_buffer_access",null,null,null,false],[0,0,0,"unaligned_ds_access",null,null,null,false],[0,0,0,"unaligned_scratch_access",null,null,null,false],[0,0,0,"unpacked_d16_vmem",null,null,null,false],[0,0,0,"unsafe_ds_offset_folding",null,null,null,false],[0,0,0,"user_sgpr_init16_bug",null,null,null,false],[0,0,0,"valu_trans_use_hazard",null,null,null,false],[0,0,0,"vcmpx_exec_war_hazard",null,null,null,false],[0,0,0,"vcmpx_permlane_hazard",null,null,null,false],[0,0,0,"vgpr_index_mode",null,null,null,false],[0,0,0,"vmem_to_scalar_write_hazard",null,null,null,false],[0,0,0,"volcanic_islands",null,null,null,false],[0,0,0,"vop3_literal",null,null,null,false],[0,0,0,"vop3p",null,null,null,false],[0,0,0,"vopd",null,null,null,false],[0,0,0,"vscnt",null,null,null,false],[0,0,0,"wavefrontsize16",null,null,null,false],[0,0,0,"wavefrontsize32",null,null,null,false],[0,0,0,"wavefrontsize64",null,null,null,false],[0,0,0,"xnack",null,null,null,false],[0,0,0,"xnack_support",null,null,null,false],[43,155,0,null,null,null,null,false],[43,156,0,null,null,null,null,false],[43,157,0,null,null,null,null,false],[43,158,0,null,null,null,null,false],[43,160,0,null,null,null,null,false],[43,1085,0,null,null,null,[],false],[43,1086,0,null,null,null,null,false],[43,1094,0,null,null,null,null,false],[43,1106,0,null,null,null,null,false],[43,1115,0,null,null,null,null,false],[43,1122,0,null,null,null,null,false],[43,1130,0,null,null,null,null,false],[43,1162,0,null,null,null,null,false],[43,1199,0,null,null,null,null,false],[43,1236,0,null,null,null,null,false],[43,1269,0,null,null,null,null,false],[43,1291,0,null,null,null,null,false],[43,1313,0,null,null,null,null,false],[43,1335,0,null,null,null,null,false],[43,1357,0,null,null,null,null,false],[43,1379,0,null,null,null,null,false],[43,1401,0,null,null,null,null,false],[43,1423,0,null,null,null,null,false],[43,1451,0,null,null,null,null,false],[43,1478,0,null,null,null,null,false],[43,1505,0,null,null,null,null,false],[43,1531,0,null,null,null,null,false],[43,1540,0,null,null,null,null,false],[43,1547,0,null,null,null,null,false],[43,1554,0,null,null,null,null,false],[43,1562,0,null,null,null,null,false],[43,1572,0,null,null,null,null,false],[43,1581,0,null,null,null,null,false],[43,1589,0,null,null,null,null,false],[43,1597,0,null,null,null,null,false],[43,1605,0,null,null,null,null,false],[43,1617,0,null,null,null,null,false],[43,1627,0,null,null,null,null,false],[43,1636,0,null,null,null,null,false],[43,1646,0,null,null,null,null,false],[43,1657,0,null,null,null,null,false],[43,1671,0,null,null,null,null,false],[43,1685,0,null,null,null,null,false],[43,1699,0,null,null,null,null,false],[43,1719,0,null,null,null,null,false],[43,1748,0,null,null,null,null,false],[43,1762,0,null,null,null,null,false],[43,1794,0,null,null,null,null,false],[43,1808,0,null,null,null,null,false],[43,1842,0,null,null,null,null,false],[43,1849,0,null,null,null,null,false],[43,1859,0,null,null,null,null,false],[43,1869,0,null,null,null,null,false],[43,1877,0,null,null,null,null,false],[43,1885,0,null,null,null,null,false],[43,1893,0,null,null,null,null,false],[43,1900,0,null,null,null,null,false],[43,1907,0,null,null,null,null,false],[43,1916,0,null,null,null,null,false],[43,1925,0,null,null,null,null,false],[43,1936,0,null,null,null,null,false],[43,1945,0,null,null,null,null,false],[43,1955,0,null,null,null,null,false],[43,1965,0,null,null,null,null,false],[40,453,0,null,null,null,null,false],[0,0,0,"target/arm.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[44,2,0,null,null,null,null,false],[44,3,0,null,null,null,null,false],[44,4,0,null,null,null,null,false],[44,6,0,null,null,null,[6133,6134,6135,6136,6137,6138,6139,6140,6141,6142,6143,6144,6145,6146,6147,6148,6149,6150,6151,6152,6153,6154,6155,6156,6157,6158,6159,6160,6161,6162,6163,6164,6165,6166,6167,6168,6169,6170,6171,6172,6173,6174,6175,6176,6177,6178,6179,6180,6181,6182,6183,6184,6185,6186,6187,6188,6189,6190,6191,6192,6193,6194,6195,6196,6197,6198,6199,6200,6201,6202,6203,6204,6205,6206,6207,6208,6209,6210,6211,6212,6213,6214,6215,6216,6217,6218,6219,6220,6221,6222,6223,6224,6225,6226,6227,6228,6229,6230,6231,6232,6233,6234,6235,6236,6237,6238,6239,6240,6241,6242,6243,6244,6245,6246,6247,6248,6249,6250,6251,6252,6253,6254,6255,6256,6257,6258,6259,6260,6261,6262,6263,6264,6265,6266,6267,6268,6269,6270,6271,6272,6273,6274,6275,6276,6277,6278,6279,6280,6281,6282,6283,6284,6285,6286,6287,6288,6289,6290,6291,6292,6293,6294,6295,6296,6297,6298,6299,6300,6301,6302,6303,6304,6305,6306,6307,6308,6309,6310,6311,6312,6313,6314,6315,6316,6317,6318,6319,6320,6321,6322,6323,6324,6325,6326,6327,6328,6329],false],[0,0,0,"32bit",null,null,null,false],[0,0,0,"8msecext",null,null,null,false],[0,0,0,"a76",null,null,null,false],[0,0,0,"aapcs_frame_chain",null,null,null,false],[0,0,0,"aapcs_frame_chain_leaf",null,null,null,false],[0,0,0,"aclass",null,null,null,false],[0,0,0,"acquire_release",null,null,null,false],[0,0,0,"aes",null,null,null,false],[0,0,0,"atomics_32",null,null,null,false],[0,0,0,"avoid_movs_shop",null,null,null,false],[0,0,0,"avoid_partial_cpsr",null,null,null,false],[0,0,0,"bf16",null,null,null,false],[0,0,0,"big_endian_instructions",null,null,null,false],[0,0,0,"cde",null,null,null,false],[0,0,0,"cdecp0",null,null,null,false],[0,0,0,"cdecp1",null,null,null,false],[0,0,0,"cdecp2",null,null,null,false],[0,0,0,"cdecp3",null,null,null,false],[0,0,0,"cdecp4",null,null,null,false],[0,0,0,"cdecp5",null,null,null,false],[0,0,0,"cdecp6",null,null,null,false],[0,0,0,"cdecp7",null,null,null,false],[0,0,0,"cheap_predicable_cpsr",null,null,null,false],[0,0,0,"clrbhb",null,null,null,false],[0,0,0,"crc",null,null,null,false],[0,0,0,"crypto",null,null,null,false],[0,0,0,"d32",null,null,null,false],[0,0,0,"db",null,null,null,false],[0,0,0,"dfb",null,null,null,false],[0,0,0,"disable_postra_scheduler",null,null,null,false],[0,0,0,"dont_widen_vmovs",null,null,null,false],[0,0,0,"dotprod",null,null,null,false],[0,0,0,"dsp",null,null,null,false],[0,0,0,"execute_only",null,null,null,false],[0,0,0,"expand_fp_mlx",null,null,null,false],[0,0,0,"exynos",null,null,null,false],[0,0,0,"fix_cmse_cve_2021_35465",null,null,null,false],[0,0,0,"fix_cortex_a57_aes_1742098",null,null,null,false],[0,0,0,"fp16",null,null,null,false],[0,0,0,"fp16fml",null,null,null,false],[0,0,0,"fp64",null,null,null,false],[0,0,0,"fp_armv8",null,null,null,false],[0,0,0,"fp_armv8d16",null,null,null,false],[0,0,0,"fp_armv8d16sp",null,null,null,false],[0,0,0,"fp_armv8sp",null,null,null,false],[0,0,0,"fpao",null,null,null,false],[0,0,0,"fpregs",null,null,null,false],[0,0,0,"fpregs16",null,null,null,false],[0,0,0,"fpregs64",null,null,null,false],[0,0,0,"fullfp16",null,null,null,false],[0,0,0,"fuse_aes",null,null,null,false],[0,0,0,"fuse_literals",null,null,null,false],[0,0,0,"harden_sls_blr",null,null,null,false],[0,0,0,"harden_sls_nocomdat",null,null,null,false],[0,0,0,"harden_sls_retbr",null,null,null,false],[0,0,0,"has_v4t",null,null,null,false],[0,0,0,"has_v5t",null,null,null,false],[0,0,0,"has_v5te",null,null,null,false],[0,0,0,"has_v6",null,null,null,false],[0,0,0,"has_v6k",null,null,null,false],[0,0,0,"has_v6m",null,null,null,false],[0,0,0,"has_v6t2",null,null,null,false],[0,0,0,"has_v7",null,null,null,false],[0,0,0,"has_v7clrex",null,null,null,false],[0,0,0,"has_v8",null,null,null,false],[0,0,0,"has_v8_1a",null,null,null,false],[0,0,0,"has_v8_1m_main",null,null,null,false],[0,0,0,"has_v8_2a",null,null,null,false],[0,0,0,"has_v8_3a",null,null,null,false],[0,0,0,"has_v8_4a",null,null,null,false],[0,0,0,"has_v8_5a",null,null,null,false],[0,0,0,"has_v8_6a",null,null,null,false],[0,0,0,"has_v8_7a",null,null,null,false],[0,0,0,"has_v8_8a",null,null,null,false],[0,0,0,"has_v8_9a",null,null,null,false],[0,0,0,"has_v8m",null,null,null,false],[0,0,0,"has_v8m_main",null,null,null,false],[0,0,0,"has_v9_1a",null,null,null,false],[0,0,0,"has_v9_2a",null,null,null,false],[0,0,0,"has_v9_3a",null,null,null,false],[0,0,0,"has_v9_4a",null,null,null,false],[0,0,0,"has_v9a",null,null,null,false],[0,0,0,"hwdiv",null,null,null,false],[0,0,0,"hwdiv_arm",null,null,null,false],[0,0,0,"i8mm",null,null,null,false],[0,0,0,"iwmmxt",null,null,null,false],[0,0,0,"iwmmxt2",null,null,null,false],[0,0,0,"lob",null,null,null,false],[0,0,0,"long_calls",null,null,null,false],[0,0,0,"loop_align",null,null,null,false],[0,0,0,"m3",null,null,null,false],[0,0,0,"mclass",null,null,null,false],[0,0,0,"mp",null,null,null,false],[0,0,0,"muxed_units",null,null,null,false],[0,0,0,"mve",null,null,null,false],[0,0,0,"mve1beat",null,null,null,false],[0,0,0,"mve2beat",null,null,null,false],[0,0,0,"mve4beat",null,null,null,false],[0,0,0,"mve_fp",null,null,null,false],[0,0,0,"nacl_trap",null,null,null,false],[0,0,0,"neon",null,null,null,false],[0,0,0,"neon_fpmovs",null,null,null,false],[0,0,0,"neonfp",null,null,null,false],[0,0,0,"no_branch_predictor",null,null,null,false],[0,0,0,"no_bti_at_return_twice",null,null,null,false],[0,0,0,"no_movt",null,null,null,false],[0,0,0,"no_neg_immediates",null,null,null,false],[0,0,0,"noarm",null,null,null,false],[0,0,0,"nonpipelined_vfp",null,null,null,false],[0,0,0,"pacbti",null,null,null,false],[0,0,0,"perfmon",null,null,null,false],[0,0,0,"prefer_ishst",null,null,null,false],[0,0,0,"prefer_vmovsr",null,null,null,false],[0,0,0,"prof_unpr",null,null,null,false],[0,0,0,"r4",null,null,null,false],[0,0,0,"ras",null,null,null,false],[0,0,0,"rclass",null,null,null,false],[0,0,0,"read_tp_hard",null,null,null,false],[0,0,0,"reserve_r9",null,null,null,false],[0,0,0,"ret_addr_stack",null,null,null,false],[0,0,0,"sb",null,null,null,false],[0,0,0,"sha2",null,null,null,false],[0,0,0,"slow_fp_brcc",null,null,null,false],[0,0,0,"slow_load_D_subreg",null,null,null,false],[0,0,0,"slow_odd_reg",null,null,null,false],[0,0,0,"slow_vdup32",null,null,null,false],[0,0,0,"slow_vgetlni32",null,null,null,false],[0,0,0,"slowfpvfmx",null,null,null,false],[0,0,0,"slowfpvmlx",null,null,null,false],[0,0,0,"soft_float",null,null,null,false],[0,0,0,"splat_vfp_neon",null,null,null,false],[0,0,0,"strict_align",null,null,null,false],[0,0,0,"swift",null,null,null,false],[0,0,0,"thumb2",null,null,null,false],[0,0,0,"thumb_mode",null,null,null,false],[0,0,0,"trustzone",null,null,null,false],[0,0,0,"use_mipipeliner",null,null,null,false],[0,0,0,"use_misched",null,null,null,false],[0,0,0,"v2",null,null,null,false],[0,0,0,"v2a",null,null,null,false],[0,0,0,"v3",null,null,null,false],[0,0,0,"v3m",null,null,null,false],[0,0,0,"v4",null,null,null,false],[0,0,0,"v4t",null,null,null,false],[0,0,0,"v5t",null,null,null,false],[0,0,0,"v5te",null,null,null,false],[0,0,0,"v5tej",null,null,null,false],[0,0,0,"v6",null,null,null,false],[0,0,0,"v6j",null,null,null,false],[0,0,0,"v6k",null,null,null,false],[0,0,0,"v6kz",null,null,null,false],[0,0,0,"v6m",null,null,null,false],[0,0,0,"v6sm",null,null,null,false],[0,0,0,"v6t2",null,null,null,false],[0,0,0,"v7a",null,null,null,false],[0,0,0,"v7em",null,null,null,false],[0,0,0,"v7k",null,null,null,false],[0,0,0,"v7m",null,null,null,false],[0,0,0,"v7r",null,null,null,false],[0,0,0,"v7s",null,null,null,false],[0,0,0,"v7ve",null,null,null,false],[0,0,0,"v8_1a",null,null,null,false],[0,0,0,"v8_1m_main",null,null,null,false],[0,0,0,"v8_2a",null,null,null,false],[0,0,0,"v8_3a",null,null,null,false],[0,0,0,"v8_4a",null,null,null,false],[0,0,0,"v8_5a",null,null,null,false],[0,0,0,"v8_6a",null,null,null,false],[0,0,0,"v8_7a",null,null,null,false],[0,0,0,"v8_8a",null,null,null,false],[0,0,0,"v8_9a",null,null,null,false],[0,0,0,"v8a",null,null,null,false],[0,0,0,"v8m",null,null,null,false],[0,0,0,"v8m_main",null,null,null,false],[0,0,0,"v8r",null,null,null,false],[0,0,0,"v9_1a",null,null,null,false],[0,0,0,"v9_2a",null,null,null,false],[0,0,0,"v9_3a",null,null,null,false],[0,0,0,"v9_4a",null,null,null,false],[0,0,0,"v9a",null,null,null,false],[0,0,0,"vfp2",null,null,null,false],[0,0,0,"vfp2sp",null,null,null,false],[0,0,0,"vfp3",null,null,null,false],[0,0,0,"vfp3d16",null,null,null,false],[0,0,0,"vfp3d16sp",null,null,null,false],[0,0,0,"vfp3sp",null,null,null,false],[0,0,0,"vfp4",null,null,null,false],[0,0,0,"vfp4d16",null,null,null,false],[0,0,0,"vfp4d16sp",null,null,null,false],[0,0,0,"vfp4sp",null,null,null,false],[0,0,0,"virtualization",null,null,null,false],[0,0,0,"vldn_align",null,null,null,false],[0,0,0,"vmlx_forwarding",null,null,null,false],[0,0,0,"vmlx_hazards",null,null,null,false],[0,0,0,"wide_stride_vfp",null,null,null,false],[0,0,0,"xscale",null,null,null,false],[0,0,0,"zcz",null,null,null,false],[44,206,0,null,null,null,null,false],[44,207,0,null,null,null,null,false],[44,208,0,null,null,null,null,false],[44,209,0,null,null,null,null,false],[44,211,0,null,null,null,null,false],[44,1705,0,null,null,null,[],false],[44,1706,0,null,null,null,null,false],[44,1713,0,null,null,null,null,false],[44,1720,0,null,null,null,null,false],[44,1727,0,null,null,null,null,false],[44,1734,0,null,null,null,null,false],[44,1741,0,null,null,null,null,false],[44,1748,0,null,null,null,null,false],[44,1757,0,null,null,null,null,false],[44,1764,0,null,null,null,null,false],[44,1773,0,null,null,null,null,false],[44,1780,0,null,null,null,null,false],[44,1789,0,null,null,null,null,false],[44,1796,0,null,null,null,null,false],[44,1803,0,null,null,null,null,false],[44,1810,0,null,null,null,null,false],[44,1817,0,null,null,null,null,false],[44,1824,0,null,null,null,null,false],[44,1831,0,null,null,null,null,false],[44,1838,0,null,null,null,null,false],[44,1845,0,null,null,null,null,false],[44,1852,0,null,null,null,null,false],[44,1859,0,null,null,null,null,false],[44,1866,0,null,null,null,null,false],[44,1873,0,null,null,null,null,false],[44,1880,0,null,null,null,null,false],[44,1887,0,null,null,null,null,false],[44,1894,0,null,null,null,null,false],[44,1901,0,null,null,null,null,false],[44,1908,0,null,null,null,null,false],[44,1915,0,null,null,null,null,false],[44,1929,0,null,null,null,null,false],[44,1945,0,null,null,null,null,false],[44,1959,0,null,null,null,null,false],[44,1966,0,null,null,null,null,false],[44,1973,0,null,null,null,null,false],[44,1988,0,null,null,null,null,false],[44,1996,0,null,null,null,null,false],[44,2004,0,null,null,null,null,false],[44,2015,0,null,null,null,null,false],[44,2032,0,null,null,null,null,false],[44,2042,0,null,null,null,null,false],[44,2050,0,null,null,null,null,false],[44,2057,0,null,null,null,null,false],[44,2065,0,null,null,null,null,false],[44,2075,0,null,null,null,null,false],[44,2085,0,null,null,null,null,false],[44,2094,0,null,null,null,null,false],[44,2103,0,null,null,null,null,false],[44,2112,0,null,null,null,null,false],[44,2127,0,null,null,null,null,false],[44,2146,0,null,null,null,null,false],[44,2154,0,null,null,null,null,false],[44,2162,0,null,null,null,null,false],[44,2170,0,null,null,null,null,false],[44,2179,0,null,null,null,null,false],[44,2190,0,null,null,null,null,false],[44,2205,0,null,null,null,null,false],[44,2220,0,null,null,null,null,false],[44,2233,0,null,null,null,null,false],[44,2247,0,null,null,null,null,false],[44,2257,0,null,null,null,null,false],[44,2268,0,null,null,null,null,false],[44,2278,0,null,null,null,null,false],[44,2292,0,null,null,null,null,false],[44,2306,0,null,null,null,null,false],[44,2315,0,null,null,null,null,false],[44,2331,0,null,null,null,null,false],[44,2347,0,null,null,null,null,false],[44,2356,0,null,null,null,null,false],[44,2365,0,null,null,null,null,false],[44,2382,0,null,null,null,null,false],[44,2389,0,null,null,null,null,false],[44,2397,0,null,null,null,null,false],[44,2405,0,null,null,null,null,false],[44,2413,0,null,null,null,null,false],[44,2423,0,null,null,null,null,false],[44,2433,0,null,null,null,null,false],[44,2438,0,null,null,null,null,false],[44,2445,0,null,null,null,null,false],[44,2460,0,null,null,null,null,false],[44,2467,0,null,null,null,null,false],[44,2476,0,null,null,null,null,false],[44,2483,0,null,null,null,null,false],[44,2491,0,null,null,null,null,false],[44,2500,0,null,null,null,null,false],[44,2510,0,null,null,null,null,false],[44,2518,0,null,null,null,null,false],[44,2528,0,null,null,null,null,false],[44,2535,0,null,null,null,null,false],[44,2542,0,null,null,null,null,false],[44,2549,0,null,null,null,null,false],[44,2556,0,null,null,null,null,false],[44,2584,0,null,null,null,null,false],[40,454,0,null,null,null,null,false],[0,0,0,"target/avr.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[45,2,0,null,null,null,null,false],[45,3,0,null,null,null,null,false],[45,4,0,null,null,null,null,false],[45,6,0,null,null,null,[6435,6436,6437,6438,6439,6440,6441,6442,6443,6444,6445,6446,6447,6448,6449,6450,6451,6452,6453,6454,6455,6456,6457,6458,6459,6460,6461,6462,6463,6464,6465,6466,6467,6468,6469,6470],false],[0,0,0,"addsubiw",null,null,null,false],[0,0,0,"avr0",null,null,null,false],[0,0,0,"avr1",null,null,null,false],[0,0,0,"avr2",null,null,null,false],[0,0,0,"avr25",null,null,null,false],[0,0,0,"avr3",null,null,null,false],[0,0,0,"avr31",null,null,null,false],[0,0,0,"avr35",null,null,null,false],[0,0,0,"avr4",null,null,null,false],[0,0,0,"avr5",null,null,null,false],[0,0,0,"avr51",null,null,null,false],[0,0,0,"avr6",null,null,null,false],[0,0,0,"avrtiny",null,null,null,false],[0,0,0,"break",null,null,null,false],[0,0,0,"des",null,null,null,false],[0,0,0,"eijmpcall",null,null,null,false],[0,0,0,"elpm",null,null,null,false],[0,0,0,"elpmx",null,null,null,false],[0,0,0,"ijmpcall",null,null,null,false],[0,0,0,"jmpcall",null,null,null,false],[0,0,0,"lpm",null,null,null,false],[0,0,0,"lpmx",null,null,null,false],[0,0,0,"memmappedregs",null,null,null,false],[0,0,0,"movw",null,null,null,false],[0,0,0,"mul",null,null,null,false],[0,0,0,"progmem",null,null,null,false],[0,0,0,"rmw",null,null,null,false],[0,0,0,"smallstack",null,null,null,false],[0,0,0,"special",null,null,null,false],[0,0,0,"spm",null,null,null,false],[0,0,0,"spmx",null,null,null,false],[0,0,0,"sram",null,null,null,false],[0,0,0,"tinyencoding",null,null,null,false],[0,0,0,"xmega",null,null,null,false],[0,0,0,"xmega3",null,null,null,false],[0,0,0,"xmegau",null,null,null,false],[45,45,0,null,null,null,null,false],[45,46,0,null,null,null,null,false],[45,47,0,null,null,null,null,false],[45,48,0,null,null,null,null,false],[45,50,0,null,null,null,null,false],[45,348,0,null,null,null,[],false],[45,349,0,null,null,null,null,false],[45,356,0,null,null,null,null,false],[45,363,0,null,null,null,null,false],[45,370,0,null,null,null,null,false],[45,379,0,null,null,null,null,false],[45,386,0,null,null,null,null,false],[45,393,0,null,null,null,null,false],[45,400,0,null,null,null,null,false],[45,407,0,null,null,null,null,false],[45,414,0,null,null,null,null,false],[45,421,0,null,null,null,null,false],[45,428,0,null,null,null,null,false],[45,435,0,null,null,null,null,false],[45,442,0,null,null,null,null,false],[45,449,0,null,null,null,null,false],[45,456,0,null,null,null,null,false],[45,463,0,null,null,null,null,false],[45,470,0,null,null,null,null,false],[45,478,0,null,null,null,null,false],[45,486,0,null,null,null,null,false],[45,494,0,null,null,null,null,false],[45,502,0,null,null,null,null,false],[45,510,0,null,null,null,null,false],[45,518,0,null,null,null,null,false],[45,526,0,null,null,null,null,false],[45,534,0,null,null,null,null,false],[45,541,0,null,null,null,null,false],[45,548,0,null,null,null,null,false],[45,555,0,null,null,null,null,false],[45,562,0,null,null,null,null,false],[45,569,0,null,null,null,null,false],[45,576,0,null,null,null,null,false],[45,583,0,null,null,null,null,false],[45,590,0,null,null,null,null,false],[45,597,0,null,null,null,null,false],[45,607,0,null,null,null,null,false],[45,614,0,null,null,null,null,false],[45,621,0,null,null,null,null,false],[45,628,0,null,null,null,null,false],[45,635,0,null,null,null,null,false],[45,642,0,null,null,null,null,false],[45,649,0,null,null,null,null,false],[45,656,0,null,null,null,null,false],[45,663,0,null,null,null,null,false],[45,670,0,null,null,null,null,false],[45,677,0,null,null,null,null,false],[45,684,0,null,null,null,null,false],[45,691,0,null,null,null,null,false],[45,698,0,null,null,null,null,false],[45,705,0,null,null,null,null,false],[45,712,0,null,null,null,null,false],[45,719,0,null,null,null,null,false],[45,726,0,null,null,null,null,false],[45,733,0,null,null,null,null,false],[45,740,0,null,null,null,null,false],[45,747,0,null,null,null,null,false],[45,754,0,null,null,null,null,false],[45,761,0,null,null,null,null,false],[45,768,0,null,null,null,null,false],[45,775,0,null,null,null,null,false],[45,782,0,null,null,null,null,false],[45,789,0,null,null,null,null,false],[45,796,0,null,null,null,null,false],[45,803,0,null,null,null,null,false],[45,810,0,null,null,null,null,false],[45,817,0,null,null,null,null,false],[45,824,0,null,null,null,null,false],[45,831,0,null,null,null,null,false],[45,838,0,null,null,null,null,false],[45,849,0,null,null,null,null,false],[45,856,0,null,null,null,null,false],[45,867,0,null,null,null,null,false],[45,874,0,null,null,null,null,false],[45,881,0,null,null,null,null,false],[45,888,0,null,null,null,null,false],[45,895,0,null,null,null,null,false],[45,902,0,null,null,null,null,false],[45,909,0,null,null,null,null,false],[45,916,0,null,null,null,null,false],[45,923,0,null,null,null,null,false],[45,930,0,null,null,null,null,false],[45,937,0,null,null,null,null,false],[45,944,0,null,null,null,null,false],[45,951,0,null,null,null,null,false],[45,958,0,null,null,null,null,false],[45,965,0,null,null,null,null,false],[45,972,0,null,null,null,null,false],[45,979,0,null,null,null,null,false],[45,986,0,null,null,null,null,false],[45,993,0,null,null,null,null,false],[45,1000,0,null,null,null,null,false],[45,1007,0,null,null,null,null,false],[45,1014,0,null,null,null,null,false],[45,1021,0,null,null,null,null,false],[45,1028,0,null,null,null,null,false],[45,1035,0,null,null,null,null,false],[45,1042,0,null,null,null,null,false],[45,1049,0,null,null,null,null,false],[45,1056,0,null,null,null,null,false],[45,1063,0,null,null,null,null,false],[45,1070,0,null,null,null,null,false],[45,1077,0,null,null,null,null,false],[45,1084,0,null,null,null,null,false],[45,1091,0,null,null,null,null,false],[45,1098,0,null,null,null,null,false],[45,1105,0,null,null,null,null,false],[45,1112,0,null,null,null,null,false],[45,1119,0,null,null,null,null,false],[45,1126,0,null,null,null,null,false],[45,1133,0,null,null,null,null,false],[45,1140,0,null,null,null,null,false],[45,1147,0,null,null,null,null,false],[45,1154,0,null,null,null,null,false],[45,1161,0,null,null,null,null,false],[45,1168,0,null,null,null,null,false],[45,1175,0,null,null,null,null,false],[45,1182,0,null,null,null,null,false],[45,1189,0,null,null,null,null,false],[45,1196,0,null,null,null,null,false],[45,1203,0,null,null,null,null,false],[45,1210,0,null,null,null,null,false],[45,1217,0,null,null,null,null,false],[45,1224,0,null,null,null,null,false],[45,1231,0,null,null,null,null,false],[45,1238,0,null,null,null,null,false],[45,1245,0,null,null,null,null,false],[45,1252,0,null,null,null,null,false],[45,1259,0,null,null,null,null,false],[45,1266,0,null,null,null,null,false],[45,1273,0,null,null,null,null,false],[45,1280,0,null,null,null,null,false],[45,1287,0,null,null,null,null,false],[45,1294,0,null,null,null,null,false],[45,1301,0,null,null,null,null,false],[45,1308,0,null,null,null,null,false],[45,1315,0,null,null,null,null,false],[45,1322,0,null,null,null,null,false],[45,1329,0,null,null,null,null,false],[45,1336,0,null,null,null,null,false],[45,1343,0,null,null,null,null,false],[45,1350,0,null,null,null,null,false],[45,1357,0,null,null,null,null,false],[45,1364,0,null,null,null,null,false],[45,1371,0,null,null,null,null,false],[45,1378,0,null,null,null,null,false],[45,1385,0,null,null,null,null,false],[45,1392,0,null,null,null,null,false],[45,1399,0,null,null,null,null,false],[45,1406,0,null,null,null,null,false],[45,1413,0,null,null,null,null,false],[45,1420,0,null,null,null,null,false],[45,1427,0,null,null,null,null,false],[45,1434,0,null,null,null,null,false],[45,1441,0,null,null,null,null,false],[45,1448,0,null,null,null,null,false],[45,1455,0,null,null,null,null,false],[45,1462,0,null,null,null,null,false],[45,1469,0,null,null,null,null,false],[45,1476,0,null,null,null,null,false],[45,1483,0,null,null,null,null,false],[45,1490,0,null,null,null,null,false],[45,1497,0,null,null,null,null,false],[45,1504,0,null,null,null,null,false],[45,1511,0,null,null,null,null,false],[45,1518,0,null,null,null,null,false],[45,1525,0,null,null,null,null,false],[45,1532,0,null,null,null,null,false],[45,1539,0,null,null,null,null,false],[45,1550,0,null,null,null,null,false],[45,1557,0,null,null,null,null,false],[45,1564,0,null,null,null,null,false],[45,1575,0,null,null,null,null,false],[45,1586,0,null,null,null,null,false],[45,1593,0,null,null,null,null,false],[45,1600,0,null,null,null,null,false],[45,1607,0,null,null,null,null,false],[45,1614,0,null,null,null,null,false],[45,1621,0,null,null,null,null,false],[45,1632,0,null,null,null,null,false],[45,1639,0,null,null,null,null,false],[45,1646,0,null,null,null,null,false],[45,1653,0,null,null,null,null,false],[45,1660,0,null,null,null,null,false],[45,1667,0,null,null,null,null,false],[45,1675,0,null,null,null,null,false],[45,1683,0,null,null,null,null,false],[45,1691,0,null,null,null,null,false],[45,1699,0,null,null,null,null,false],[45,1707,0,null,null,null,null,false],[45,1714,0,null,null,null,null,false],[45,1721,0,null,null,null,null,false],[45,1728,0,null,null,null,null,false],[45,1735,0,null,null,null,null,false],[45,1742,0,null,null,null,null,false],[45,1749,0,null,null,null,null,false],[45,1756,0,null,null,null,null,false],[45,1763,0,null,null,null,null,false],[45,1770,0,null,null,null,null,false],[45,1777,0,null,null,null,null,false],[45,1784,0,null,null,null,null,false],[45,1791,0,null,null,null,null,false],[45,1798,0,null,null,null,null,false],[45,1805,0,null,null,null,null,false],[45,1812,0,null,null,null,null,false],[45,1819,0,null,null,null,null,false],[45,1827,0,null,null,null,null,false],[45,1835,0,null,null,null,null,false],[45,1843,0,null,null,null,null,false],[45,1851,0,null,null,null,null,false],[45,1859,0,null,null,null,null,false],[45,1867,0,null,null,null,null,false],[45,1876,0,null,null,null,null,false],[45,1884,0,null,null,null,null,false],[45,1892,0,null,null,null,null,false],[45,1900,0,null,null,null,null,false],[45,1907,0,null,null,null,null,false],[45,1914,0,null,null,null,null,false],[45,1921,0,null,null,null,null,false],[45,1928,0,null,null,null,null,false],[45,1935,0,null,null,null,null,false],[45,1942,0,null,null,null,null,false],[45,1949,0,null,null,null,null,false],[45,1956,0,null,null,null,null,false],[45,1963,0,null,null,null,null,false],[45,1970,0,null,null,null,null,false],[45,1977,0,null,null,null,null,false],[45,1984,0,null,null,null,null,false],[45,1991,0,null,null,null,null,false],[45,1998,0,null,null,null,null,false],[45,2005,0,null,null,null,null,false],[45,2012,0,null,null,null,null,false],[45,2019,0,null,null,null,null,false],[45,2026,0,null,null,null,null,false],[45,2033,0,null,null,null,null,false],[45,2040,0,null,null,null,null,false],[45,2047,0,null,null,null,null,false],[45,2054,0,null,null,null,null,false],[45,2061,0,null,null,null,null,false],[45,2068,0,null,null,null,null,false],[45,2075,0,null,null,null,null,false],[45,2082,0,null,null,null,null,false],[45,2089,0,null,null,null,null,false],[45,2096,0,null,null,null,null,false],[45,2103,0,null,null,null,null,false],[45,2110,0,null,null,null,null,false],[45,2117,0,null,null,null,null,false],[45,2124,0,null,null,null,null,false],[45,2131,0,null,null,null,null,false],[45,2138,0,null,null,null,null,false],[45,2145,0,null,null,null,null,false],[45,2152,0,null,null,null,null,false],[45,2159,0,null,null,null,null,false],[45,2166,0,null,null,null,null,false],[45,2173,0,null,null,null,null,false],[45,2180,0,null,null,null,null,false],[45,2187,0,null,null,null,null,false],[45,2194,0,null,null,null,null,false],[45,2201,0,null,null,null,null,false],[45,2208,0,null,null,null,null,false],[45,2215,0,null,null,null,null,false],[45,2222,0,null,null,null,null,false],[45,2229,0,null,null,null,null,false],[45,2236,0,null,null,null,null,false],[45,2243,0,null,null,null,null,false],[45,2250,0,null,null,null,null,false],[45,2257,0,null,null,null,null,false],[45,2264,0,null,null,null,null,false],[45,2271,0,null,null,null,null,false],[45,2278,0,null,null,null,null,false],[45,2285,0,null,null,null,null,false],[45,2292,0,null,null,null,null,false],[45,2299,0,null,null,null,null,false],[45,2306,0,null,null,null,null,false],[45,2313,0,null,null,null,null,false],[45,2320,0,null,null,null,null,false],[45,2327,0,null,null,null,null,false],[45,2334,0,null,null,null,null,false],[45,2341,0,null,null,null,null,false],[45,2348,0,null,null,null,null,false],[45,2355,0,null,null,null,null,false],[45,2362,0,null,null,null,null,false],[45,2369,0,null,null,null,null,false],[45,2376,0,null,null,null,null,false],[45,2383,0,null,null,null,null,false],[45,2390,0,null,null,null,null,false],[45,2397,0,null,null,null,null,false],[45,2404,0,null,null,null,null,false],[45,2411,0,null,null,null,null,false],[45,2418,0,null,null,null,null,false],[45,2425,0,null,null,null,null,false],[45,2432,0,null,null,null,null,false],[45,2439,0,null,null,null,null,false],[45,2446,0,null,null,null,null,false],[45,2453,0,null,null,null,null,false],[45,2460,0,null,null,null,null,false],[45,2467,0,null,null,null,null,false],[45,2474,0,null,null,null,null,false],[45,2481,0,null,null,null,null,false],[45,2488,0,null,null,null,null,false],[45,2495,0,null,null,null,null,false],[45,2502,0,null,null,null,null,false],[45,2509,0,null,null,null,null,false],[45,2516,0,null,null,null,null,false],[45,2523,0,null,null,null,null,false],[45,2530,0,null,null,null,null,false],[45,2537,0,null,null,null,null,false],[45,2544,0,null,null,null,null,false],[45,2551,0,null,null,null,null,false],[45,2558,0,null,null,null,null,false],[45,2565,0,null,null,null,null,false],[45,2572,0,null,null,null,null,false],[45,2579,0,null,null,null,null,false],[45,2586,0,null,null,null,null,false],[45,2593,0,null,null,null,null,false],[45,2600,0,null,null,null,null,false],[40,455,0,null,null,null,null,false],[0,0,0,"target/bpf.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[46,2,0,null,null,null,null,false],[46,3,0,null,null,null,null,false],[46,4,0,null,null,null,null,false],[46,6,0,null,null,null,[6798,6799,6800],false],[0,0,0,"alu32",null,null,null,false],[0,0,0,"dummy",null,null,null,false],[0,0,0,"dwarfris",null,null,null,false],[46,12,0,null,null,null,null,false],[46,13,0,null,null,null,null,false],[46,14,0,null,null,null,null,false],[46,15,0,null,null,null,null,false],[46,17,0,null,null,null,null,false],[46,44,0,null,null,null,[],false],[46,45,0,null,null,null,null,false],[46,50,0,null,null,null,null,false],[46,55,0,null,null,null,null,false],[46,60,0,null,null,null,null,false],[46,65,0,null,null,null,null,false],[40,456,0,null,null,null,null,false],[0,0,0,"target/csky.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[47,2,0,null,null,null,null,false],[47,3,0,null,null,null,null,false],[47,4,0,null,null,null,null,false],[47,6,0,null,null,null,[6818,6819,6820,6821,6822,6823,6824,6825,6826,6827,6828,6829,6830,6831,6832,6833,6834,6835,6836,6837,6838,6839,6840,6841,6842,6843,6844,6845,6846,6847,6848,6849,6850,6851,6852,6853,6854,6855,6856,6857,6858,6859,6860,6861,6862,6863,6864,6865,6866,6867,6868,6869,6870,6871,6872,6873,6874,6875,6876,6877,6878,6879,6880],false],[0,0,0,"10e60",null,null,null,false],[0,0,0,"2e3",null,null,null,false],[0,0,0,"3e3r1",null,null,null,false],[0,0,0,"3e3r2",null,null,null,false],[0,0,0,"3e3r3",null,null,null,false],[0,0,0,"3e7",null,null,null,false],[0,0,0,"7e10",null,null,null,false],[0,0,0,"btst16",null,null,null,false],[0,0,0,"cache",null,null,null,false],[0,0,0,"ccrt",null,null,null,false],[0,0,0,"ck801",null,null,null,false],[0,0,0,"ck802",null,null,null,false],[0,0,0,"ck803",null,null,null,false],[0,0,0,"ck803s",null,null,null,false],[0,0,0,"ck804",null,null,null,false],[0,0,0,"ck805",null,null,null,false],[0,0,0,"ck807",null,null,null,false],[0,0,0,"ck810",null,null,null,false],[0,0,0,"ck810v",null,null,null,false],[0,0,0,"ck860",null,null,null,false],[0,0,0,"ck860v",null,null,null,false],[0,0,0,"constpool",null,null,null,false],[0,0,0,"doloop",null,null,null,false],[0,0,0,"dsp1e2",null,null,null,false],[0,0,0,"dsp_silan",null,null,null,false],[0,0,0,"dspe60",null,null,null,false],[0,0,0,"dspv2",null,null,null,false],[0,0,0,"e1",null,null,null,false],[0,0,0,"e2",null,null,null,false],[0,0,0,"edsp",null,null,null,false],[0,0,0,"elrw",null,null,null,false],[0,0,0,"fdivdu",null,null,null,false],[0,0,0,"float1e2",null,null,null,false],[0,0,0,"float1e3",null,null,null,false],[0,0,0,"float3e4",null,null,null,false],[0,0,0,"float7e60",null,null,null,false],[0,0,0,"floate1",null,null,null,false],[0,0,0,"fpuv2_df",null,null,null,false],[0,0,0,"fpuv2_sf",null,null,null,false],[0,0,0,"fpuv3_df",null,null,null,false],[0,0,0,"fpuv3_hf",null,null,null,false],[0,0,0,"fpuv3_hi",null,null,null,false],[0,0,0,"fpuv3_sf",null,null,null,false],[0,0,0,"hard_float",null,null,null,false],[0,0,0,"hard_float_abi",null,null,null,false],[0,0,0,"hard_tp",null,null,null,false],[0,0,0,"high_registers",null,null,null,false],[0,0,0,"hwdiv",null,null,null,false],[0,0,0,"istack",null,null,null,false],[0,0,0,"java",null,null,null,false],[0,0,0,"mp",null,null,null,false],[0,0,0,"mp1e2",null,null,null,false],[0,0,0,"multiple_stld",null,null,null,false],[0,0,0,"nvic",null,null,null,false],[0,0,0,"pushpop",null,null,null,false],[0,0,0,"smart",null,null,null,false],[0,0,0,"soft_tp",null,null,null,false],[0,0,0,"stack_size",null,null,null,false],[0,0,0,"trust",null,null,null,false],[0,0,0,"vdsp2e3",null,null,null,false],[0,0,0,"vdsp2e60f",null,null,null,false],[0,0,0,"vdspv1",null,null,null,false],[0,0,0,"vdspv2",null,null,null,false],[47,72,0,null,null,null,null,false],[47,73,0,null,null,null,null,false],[47,74,0,null,null,null,null,false],[47,75,0,null,null,null,null,false],[47,77,0,null,null,null,null,false],[47,425,0,null,null,null,[],false],[47,426,0,null,null,null,null,false],[47,444,0,null,null,null,null,false],[47,469,0,null,null,null,null,false],[47,493,0,null,null,null,null,false],[47,517,0,null,null,null,null,false],[47,543,0,null,null,null,null,false],[47,569,0,null,null,null,null,false],[47,594,0,null,null,null,null,false],[47,622,0,null,null,null,null,false],[47,632,0,null,null,null,null,false],[47,642,0,null,null,null,null,false],[47,653,0,null,null,null,null,false],[47,665,0,null,null,null,null,false],[47,676,0,null,null,null,null,false],[47,688,0,null,null,null,null,false],[47,703,0,null,null,null,null,false],[47,721,0,null,null,null,null,false],[47,739,0,null,null,null,null,false],[47,760,0,null,null,null,null,false],[47,782,0,null,null,null,null,false],[47,804,0,null,null,null,null,false],[47,822,0,null,null,null,null,false],[47,843,0,null,null,null,null,false],[47,865,0,null,null,null,null,false],[47,887,0,null,null,null,null,false],[47,908,0,null,null,null,null,false],[47,930,0,null,null,null,null,false],[47,952,0,null,null,null,null,false],[47,970,0,null,null,null,null,false],[47,991,0,null,null,null,null,false],[47,1013,0,null,null,null,null,false],[47,1035,0,null,null,null,null,false],[47,1050,0,null,null,null,null,false],[47,1069,0,null,null,null,null,false],[47,1088,0,null,null,null,null,false],[47,1107,0,null,null,null,null,false],[47,1122,0,null,null,null,null,false],[47,1141,0,null,null,null,null,false],[47,1160,0,null,null,null,null,false],[47,1179,0,null,null,null,null,false],[47,1198,0,null,null,null,null,false],[47,1217,0,null,null,null,null,false],[47,1236,0,null,null,null,null,false],[47,1251,0,null,null,null,null,false],[47,1270,0,null,null,null,null,false],[47,1289,0,null,null,null,null,false],[47,1308,0,null,null,null,null,false],[47,1323,0,null,null,null,null,false],[47,1338,0,null,null,null,null,false],[47,1356,0,null,null,null,null,false],[47,1374,0,null,null,null,null,false],[47,1392,0,null,null,null,null,false],[47,1410,0,null,null,null,null,false],[47,1428,0,null,null,null,null,false],[47,1446,0,null,null,null,null,false],[47,1461,0,null,null,null,null,false],[47,1478,0,null,null,null,null,false],[47,1496,0,null,null,null,null,false],[47,1514,0,null,null,null,null,false],[47,1526,0,null,null,null,null,false],[47,1541,0,null,null,null,null,false],[47,1556,0,null,null,null,null,false],[47,1571,0,null,null,null,null,false],[47,1583,0,null,null,null,null,false],[47,1598,0,null,null,null,null,false],[47,1613,0,null,null,null,null,false],[47,1628,0,null,null,null,null,false],[47,1643,0,null,null,null,null,false],[47,1658,0,null,null,null,null,false],[47,1673,0,null,null,null,null,false],[47,1687,0,null,null,null,null,false],[47,1704,0,null,null,null,null,false],[47,1724,0,null,null,null,null,false],[47,1745,0,null,null,null,null,false],[47,1766,0,null,null,null,null,false],[47,1786,0,null,null,null,null,false],[47,1804,0,null,null,null,null,false],[47,1821,0,null,null,null,null,false],[47,1839,0,null,null,null,null,false],[47,1854,0,null,null,null,null,false],[47,1869,0,null,null,null,null,false],[47,1883,0,null,null,null,null,false],[47,1895,0,null,null,null,null,false],[47,1910,0,null,null,null,null,false],[47,1925,0,null,null,null,null,false],[47,1940,0,null,null,null,null,false],[47,1955,0,null,null,null,null,false],[47,1972,0,null,null,null,null,false],[47,1992,0,null,null,null,null,false],[47,2012,0,null,null,null,null,false],[47,2032,0,null,null,null,null,false],[47,2052,0,null,null,null,null,false],[47,2069,0,null,null,null,null,false],[47,2086,0,null,null,null,null,false],[47,2103,0,null,null,null,null,false],[47,2121,0,null,null,null,null,false],[47,2139,0,null,null,null,null,false],[47,2157,0,null,null,null,null,false],[47,2172,0,null,null,null,null,false],[47,2187,0,null,null,null,null,false],[47,2202,0,null,null,null,null,false],[47,2220,0,null,null,null,null,false],[47,2239,0,null,null,null,null,false],[47,2261,0,null,null,null,null,false],[47,2283,0,null,null,null,null,false],[47,2302,0,null,null,null,null,false],[47,2323,0,null,null,null,null,false],[47,2344,0,null,null,null,null,false],[47,2362,0,null,null,null,null,false],[47,2380,0,null,null,null,null,false],[47,2398,0,null,null,null,null,false],[47,2423,0,null,null,null,null,false],[47,2448,0,null,null,null,null,false],[47,2467,0,null,null,null,null,false],[47,2486,0,null,null,null,null,false],[47,2510,0,null,null,null,null,false],[47,2534,0,null,null,null,null,false],[47,2560,0,null,null,null,null,false],[47,2586,0,null,null,null,null,false],[47,2605,0,null,null,null,null,false],[47,2626,0,null,null,null,null,false],[47,2647,0,null,null,null,null,false],[47,2671,0,null,null,null,null,false],[47,2695,0,null,null,null,null,false],[47,2721,0,null,null,null,null,false],[47,2747,0,null,null,null,null,false],[47,2766,0,null,null,null,null,false],[47,2787,0,null,null,null,null,false],[47,2808,0,null,null,null,null,false],[47,2828,0,null,null,null,null,false],[47,2853,0,null,null,null,null,false],[47,2881,0,null,null,null,null,false],[47,2904,0,null,null,null,null,false],[47,2914,0,null,null,null,null,false],[47,2925,0,null,null,null,null,false],[47,2936,0,null,null,null,null,false],[47,2950,0,null,null,null,null,false],[47,2964,0,null,null,null,null,false],[47,2981,0,null,null,null,null,false],[47,3001,0,null,null,null,null,false],[47,3021,0,null,null,null,null,false],[47,3038,0,null,null,null,null,false],[47,3056,0,null,null,null,null,false],[47,3074,0,null,null,null,null,false],[47,3081,0,null,null,null,null,false],[47,3099,0,null,null,null,null,false],[47,3120,0,null,null,null,null,false],[47,3138,0,null,null,null,null,false],[47,3163,0,null,null,null,null,false],[47,3174,0,null,null,null,null,false],[47,3185,0,null,null,null,null,false],[47,3199,0,null,null,null,null,false],[40,457,0,null,null,null,null,false],[0,0,0,"target/hexagon.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[48,2,0,null,null,null,null,false],[48,3,0,null,null,null,null,false],[48,4,0,null,null,null,null,false],[48,6,0,null,null,null,[7045,7046,7047,7048,7049,7050,7051,7052,7053,7054,7055,7056,7057,7058,7059,7060,7061,7062,7063,7064,7065,7066,7067,7068,7069,7070,7071,7072,7073,7074,7075,7076,7077,7078,7079,7080,7081,7082,7083,7084,7085,7086],false],[0,0,0,"audio",null,null,null,false],[0,0,0,"cabac",null,null,null,false],[0,0,0,"compound",null,null,null,false],[0,0,0,"duplex",null,null,null,false],[0,0,0,"hvx",null,null,null,false],[0,0,0,"hvx_ieee_fp",null,null,null,false],[0,0,0,"hvx_length128b",null,null,null,false],[0,0,0,"hvx_length64b",null,null,null,false],[0,0,0,"hvx_qfloat",null,null,null,false],[0,0,0,"hvxv60",null,null,null,false],[0,0,0,"hvxv62",null,null,null,false],[0,0,0,"hvxv65",null,null,null,false],[0,0,0,"hvxv66",null,null,null,false],[0,0,0,"hvxv67",null,null,null,false],[0,0,0,"hvxv68",null,null,null,false],[0,0,0,"hvxv69",null,null,null,false],[0,0,0,"hvxv71",null,null,null,false],[0,0,0,"hvxv73",null,null,null,false],[0,0,0,"long_calls",null,null,null,false],[0,0,0,"mem_noshuf",null,null,null,false],[0,0,0,"memops",null,null,null,false],[0,0,0,"noreturn_stack_elim",null,null,null,false],[0,0,0,"nvj",null,null,null,false],[0,0,0,"nvs",null,null,null,false],[0,0,0,"packets",null,null,null,false],[0,0,0,"prev65",null,null,null,false],[0,0,0,"reserved_r19",null,null,null,false],[0,0,0,"small_data",null,null,null,false],[0,0,0,"tinycore",null,null,null,false],[0,0,0,"unsafe_fp",null,null,null,false],[0,0,0,"v5",null,null,null,false],[0,0,0,"v55",null,null,null,false],[0,0,0,"v60",null,null,null,false],[0,0,0,"v62",null,null,null,false],[0,0,0,"v65",null,null,null,false],[0,0,0,"v66",null,null,null,false],[0,0,0,"v67",null,null,null,false],[0,0,0,"v68",null,null,null,false],[0,0,0,"v69",null,null,null,false],[0,0,0,"v71",null,null,null,false],[0,0,0,"v73",null,null,null,false],[0,0,0,"zreg",null,null,null,false],[48,51,0,null,null,null,null,false],[48,52,0,null,null,null,null,false],[48,53,0,null,null,null,null,false],[48,54,0,null,null,null,null,false],[48,56,0,null,null,null,null,false],[48,305,0,null,null,null,[],false],[48,306,0,null,null,null,null,false],[48,323,0,null,null,null,null,false],[48,338,0,null,null,null,null,false],[48,354,0,null,null,null,null,false],[48,371,0,null,null,null,null,false],[48,389,0,null,null,null,null,false],[48,408,0,null,null,null,null,false],[48,428,0,null,null,null,null,false],[48,449,0,null,null,null,null,false],[48,469,0,null,null,null,null,false],[48,491,0,null,null,null,null,false],[48,514,0,null,null,null,null,false],[48,538,0,null,null,null,null,false],[48,561,0,null,null,null,null,false],[40,458,0,null,null,null,null,false],[0,0,0,"target/loongarch.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[49,2,0,null,null,null,null,false],[49,3,0,null,null,null,null,false],[49,4,0,null,null,null,null,false],[49,6,0,null,null,null,[7113,7114,7115,7116,7117,7118,7119,7120,7121,7122,7123],false],[0,0,0,"32bit",null,null,null,false],[0,0,0,"64bit",null,null,null,false],[0,0,0,"d",null,null,null,false],[0,0,0,"f",null,null,null,false],[0,0,0,"la_global_with_abs",null,null,null,false],[0,0,0,"la_global_with_pcrel",null,null,null,false],[0,0,0,"la_local_with_abs",null,null,null,false],[0,0,0,"lasx",null,null,null,false],[0,0,0,"lbt",null,null,null,false],[0,0,0,"lsx",null,null,null,false],[0,0,0,"lvz",null,null,null,false],[49,20,0,null,null,null,null,false],[49,21,0,null,null,null,null,false],[49,22,0,null,null,null,null,false],[49,23,0,null,null,null,null,false],[49,25,0,null,null,null,null,false],[49,98,0,null,null,null,[],false],[49,99,0,null,null,null,null,false],[49,104,0,null,null,null,null,false],[49,111,0,null,null,null,null,false],[49,118,0,null,null,null,null,false],[40,459,0,null,null,null,null,false],[0,0,0,"target/m68k.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[50,2,0,null,null,null,null,false],[50,3,0,null,null,null,null,false],[50,4,0,null,null,null,null,false],[50,6,0,null,null,null,[7140,7141,7142,7143,7144,7145,7146,7147,7148,7149,7150,7151,7152,7153,7154,7155,7156,7157,7158,7159,7160],false],[0,0,0,"isa_68000",null,null,null,false],[0,0,0,"isa_68010",null,null,null,false],[0,0,0,"isa_68020",null,null,null,false],[0,0,0,"isa_68030",null,null,null,false],[0,0,0,"isa_68040",null,null,null,false],[0,0,0,"isa_68060",null,null,null,false],[0,0,0,"reserve_a0",null,null,null,false],[0,0,0,"reserve_a1",null,null,null,false],[0,0,0,"reserve_a2",null,null,null,false],[0,0,0,"reserve_a3",null,null,null,false],[0,0,0,"reserve_a4",null,null,null,false],[0,0,0,"reserve_a5",null,null,null,false],[0,0,0,"reserve_a6",null,null,null,false],[0,0,0,"reserve_d0",null,null,null,false],[0,0,0,"reserve_d1",null,null,null,false],[0,0,0,"reserve_d2",null,null,null,false],[0,0,0,"reserve_d3",null,null,null,false],[0,0,0,"reserve_d4",null,null,null,false],[0,0,0,"reserve_d5",null,null,null,false],[0,0,0,"reserve_d6",null,null,null,false],[0,0,0,"reserve_d7",null,null,null,false],[50,30,0,null,null,null,null,false],[50,31,0,null,null,null,null,false],[50,32,0,null,null,null,null,false],[50,33,0,null,null,null,null,false],[50,35,0,null,null,null,null,false],[50,162,0,null,null,null,[],false],[50,163,0,null,null,null,null,false],[50,170,0,null,null,null,null,false],[50,177,0,null,null,null,null,false],[50,184,0,null,null,null,null,false],[50,191,0,null,null,null,null,false],[50,198,0,null,null,null,null,false],[50,205,0,null,null,null,null,false],[40,460,0,null,null,null,null,false],[0,0,0,"target/mips.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[51,2,0,null,null,null,null,false],[51,3,0,null,null,null,null,false],[51,4,0,null,null,null,null,false],[51,6,0,null,null,null,[7180,7181,7182,7183,7184,7185,7186,7187,7188,7189,7190,7191,7192,7193,7194,7195,7196,7197,7198,7199,7200,7201,7202,7203,7204,7205,7206,7207,7208,7209,7210,7211,7212,7213,7214,7215,7216,7217,7218,7219,7220,7221,7222,7223,7224,7225,7226,7227,7228,7229,7230,7231],false],[0,0,0,"abs2008",null,null,null,false],[0,0,0,"cnmips",null,null,null,false],[0,0,0,"cnmipsp",null,null,null,false],[0,0,0,"crc",null,null,null,false],[0,0,0,"dsp",null,null,null,false],[0,0,0,"dspr2",null,null,null,false],[0,0,0,"dspr3",null,null,null,false],[0,0,0,"eva",null,null,null,false],[0,0,0,"fp64",null,null,null,false],[0,0,0,"fpxx",null,null,null,false],[0,0,0,"ginv",null,null,null,false],[0,0,0,"gp64",null,null,null,false],[0,0,0,"long_calls",null,null,null,false],[0,0,0,"micromips",null,null,null,false],[0,0,0,"mips1",null,null,null,false],[0,0,0,"mips16",null,null,null,false],[0,0,0,"mips2",null,null,null,false],[0,0,0,"mips3",null,null,null,false],[0,0,0,"mips32",null,null,null,false],[0,0,0,"mips32r2",null,null,null,false],[0,0,0,"mips32r3",null,null,null,false],[0,0,0,"mips32r5",null,null,null,false],[0,0,0,"mips32r6",null,null,null,false],[0,0,0,"mips3_32",null,null,null,false],[0,0,0,"mips3_32r2",null,null,null,false],[0,0,0,"mips3d",null,null,null,false],[0,0,0,"mips4",null,null,null,false],[0,0,0,"mips4_32",null,null,null,false],[0,0,0,"mips4_32r2",null,null,null,false],[0,0,0,"mips5",null,null,null,false],[0,0,0,"mips5_32r2",null,null,null,false],[0,0,0,"mips64",null,null,null,false],[0,0,0,"mips64r2",null,null,null,false],[0,0,0,"mips64r3",null,null,null,false],[0,0,0,"mips64r5",null,null,null,false],[0,0,0,"mips64r6",null,null,null,false],[0,0,0,"msa",null,null,null,false],[0,0,0,"mt",null,null,null,false],[0,0,0,"nan2008",null,null,null,false],[0,0,0,"noabicalls",null,null,null,false],[0,0,0,"nomadd4",null,null,null,false],[0,0,0,"nooddspreg",null,null,null,false],[0,0,0,"p5600",null,null,null,false],[0,0,0,"ptr64",null,null,null,false],[0,0,0,"single_float",null,null,null,false],[0,0,0,"soft_float",null,null,null,false],[0,0,0,"sym32",null,null,null,false],[0,0,0,"use_indirect_jump_hazard",null,null,null,false],[0,0,0,"use_tcc_in_div",null,null,null,false],[0,0,0,"vfpu",null,null,null,false],[0,0,0,"virt",null,null,null,false],[0,0,0,"xgot",null,null,null,false],[51,61,0,null,null,null,null,false],[51,62,0,null,null,null,null,false],[51,63,0,null,null,null,null,false],[51,64,0,null,null,null,null,false],[51,66,0,null,null,null,null,false],[51,396,0,null,null,null,[],false],[51,397,0,null,null,null,null,false],[51,404,0,null,null,null,null,false],[51,411,0,null,null,null,null,false],[51,418,0,null,null,null,null,false],[51,425,0,null,null,null,null,false],[51,432,0,null,null,null,null,false],[51,439,0,null,null,null,null,false],[51,446,0,null,null,null,null,false],[51,453,0,null,null,null,null,false],[51,460,0,null,null,null,null,false],[51,467,0,null,null,null,null,false],[51,474,0,null,null,null,null,false],[51,481,0,null,null,null,null,false],[51,488,0,null,null,null,null,false],[51,495,0,null,null,null,null,false],[51,502,0,null,null,null,null,false],[51,509,0,null,null,null,null,false],[51,516,0,null,null,null,null,false],[51,523,0,null,null,null,null,false],[40,461,0,null,null,null,null,false],[0,0,0,"target/msp430.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[52,2,0,null,null,null,null,false],[52,3,0,null,null,null,null,false],[52,4,0,null,null,null,null,false],[52,6,0,null,null,null,[7263,7264,7265,7266],false],[0,0,0,"ext",null,null,null,false],[0,0,0,"hwmult16",null,null,null,false],[0,0,0,"hwmult32",null,null,null,false],[0,0,0,"hwmultf5",null,null,null,false],[52,13,0,null,null,null,null,false],[52,14,0,null,null,null,null,false],[52,15,0,null,null,null,null,false],[52,16,0,null,null,null,null,false],[52,18,0,null,null,null,null,false],[52,50,0,null,null,null,[],false],[52,51,0,null,null,null,null,false],[52,56,0,null,null,null,null,false],[52,61,0,null,null,null,null,false],[40,462,0,null,null,null,null,false],[0,0,0,"target/nvptx.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[53,2,0,null,null,null,null,false],[53,3,0,null,null,null,null,false],[53,4,0,null,null,null,null,false],[53,6,0,null,null,null,[7282,7283,7284,7285,7286,7287,7288,7289,7290,7291,7292,7293,7294,7295,7296,7297,7298,7299,7300,7301,7302,7303,7304,7305,7306,7307,7308,7309,7310,7311,7312,7313,7314,7315,7316,7317,7318,7319,7320,7321],false],[0,0,0,"ptx32",null,null,null,false],[0,0,0,"ptx40",null,null,null,false],[0,0,0,"ptx41",null,null,null,false],[0,0,0,"ptx42",null,null,null,false],[0,0,0,"ptx43",null,null,null,false],[0,0,0,"ptx50",null,null,null,false],[0,0,0,"ptx60",null,null,null,false],[0,0,0,"ptx61",null,null,null,false],[0,0,0,"ptx63",null,null,null,false],[0,0,0,"ptx64",null,null,null,false],[0,0,0,"ptx65",null,null,null,false],[0,0,0,"ptx70",null,null,null,false],[0,0,0,"ptx71",null,null,null,false],[0,0,0,"ptx72",null,null,null,false],[0,0,0,"ptx73",null,null,null,false],[0,0,0,"ptx74",null,null,null,false],[0,0,0,"ptx75",null,null,null,false],[0,0,0,"ptx76",null,null,null,false],[0,0,0,"ptx77",null,null,null,false],[0,0,0,"ptx78",null,null,null,false],[0,0,0,"sm_20",null,null,null,false],[0,0,0,"sm_21",null,null,null,false],[0,0,0,"sm_30",null,null,null,false],[0,0,0,"sm_32",null,null,null,false],[0,0,0,"sm_35",null,null,null,false],[0,0,0,"sm_37",null,null,null,false],[0,0,0,"sm_50",null,null,null,false],[0,0,0,"sm_52",null,null,null,false],[0,0,0,"sm_53",null,null,null,false],[0,0,0,"sm_60",null,null,null,false],[0,0,0,"sm_61",null,null,null,false],[0,0,0,"sm_62",null,null,null,false],[0,0,0,"sm_70",null,null,null,false],[0,0,0,"sm_72",null,null,null,false],[0,0,0,"sm_75",null,null,null,false],[0,0,0,"sm_80",null,null,null,false],[0,0,0,"sm_86",null,null,null,false],[0,0,0,"sm_87",null,null,null,false],[0,0,0,"sm_89",null,null,null,false],[0,0,0,"sm_90",null,null,null,false],[53,49,0,null,null,null,null,false],[53,50,0,null,null,null,null,false],[53,51,0,null,null,null,null,false],[53,52,0,null,null,null,null,false],[53,54,0,null,null,null,null,false],[53,266,0,null,null,null,[],false],[53,267,0,null,null,null,null,false],[53,275,0,null,null,null,null,false],[53,283,0,null,null,null,null,false],[53,290,0,null,null,null,null,false],[53,298,0,null,null,null,null,false],[53,306,0,null,null,null,null,false],[53,314,0,null,null,null,null,false],[53,322,0,null,null,null,null,false],[53,330,0,null,null,null,null,false],[53,338,0,null,null,null,null,false],[53,346,0,null,null,null,null,false],[53,354,0,null,null,null,null,false],[53,362,0,null,null,null,null,false],[53,370,0,null,null,null,null,false],[53,378,0,null,null,null,null,false],[53,386,0,null,null,null,null,false],[53,394,0,null,null,null,null,false],[53,402,0,null,null,null,null,false],[53,410,0,null,null,null,null,false],[53,418,0,null,null,null,null,false],[40,463,0,null,null,null,null,false],[0,0,0,"target/powerpc.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[54,2,0,null,null,null,null,false],[54,3,0,null,null,null,null,false],[54,4,0,null,null,null,null,false],[54,6,0,null,null,null,[7354,7355,7356,7357,7358,7359,7360,7361,7362,7363,7364,7365,7366,7367,7368,7369,7370,7371,7372,7373,7374,7375,7376,7377,7378,7379,7380,7381,7382,7383,7384,7385,7386,7387,7388,7389,7390,7391,7392,7393,7394,7395,7396,7397,7398,7399,7400,7401,7402,7403,7404,7405,7406,7407,7408,7409,7410,7411,7412,7413,7414,7415,7416,7417,7418,7419,7420,7421,7422,7423,7424,7425,7426,7427,7428,7429,7430,7431,7432,7433,7434],false],[0,0,0,"64bit",null,null,null,false],[0,0,0,"64bitregs",null,null,null,false],[0,0,0,"aix",null,null,null,false],[0,0,0,"allow_unaligned_fp_access",null,null,null,false],[0,0,0,"altivec",null,null,null,false],[0,0,0,"booke",null,null,null,false],[0,0,0,"bpermd",null,null,null,false],[0,0,0,"cmpb",null,null,null,false],[0,0,0,"crbits",null,null,null,false],[0,0,0,"crypto",null,null,null,false],[0,0,0,"direct_move",null,null,null,false],[0,0,0,"e500",null,null,null,false],[0,0,0,"efpu2",null,null,null,false],[0,0,0,"extdiv",null,null,null,false],[0,0,0,"fast_MFLR",null,null,null,false],[0,0,0,"fcpsgn",null,null,null,false],[0,0,0,"float128",null,null,null,false],[0,0,0,"fpcvt",null,null,null,false],[0,0,0,"fprnd",null,null,null,false],[0,0,0,"fpu",null,null,null,false],[0,0,0,"fre",null,null,null,false],[0,0,0,"fres",null,null,null,false],[0,0,0,"frsqrte",null,null,null,false],[0,0,0,"frsqrtes",null,null,null,false],[0,0,0,"fsqrt",null,null,null,false],[0,0,0,"fuse_add_logical",null,null,null,false],[0,0,0,"fuse_addi_load",null,null,null,false],[0,0,0,"fuse_addis_load",null,null,null,false],[0,0,0,"fuse_arith_add",null,null,null,false],[0,0,0,"fuse_back2back",null,null,null,false],[0,0,0,"fuse_cmp",null,null,null,false],[0,0,0,"fuse_logical",null,null,null,false],[0,0,0,"fuse_logical_add",null,null,null,false],[0,0,0,"fuse_sha3",null,null,null,false],[0,0,0,"fuse_store",null,null,null,false],[0,0,0,"fuse_wideimm",null,null,null,false],[0,0,0,"fuse_zeromove",null,null,null,false],[0,0,0,"fusion",null,null,null,false],[0,0,0,"hard_float",null,null,null,false],[0,0,0,"htm",null,null,null,false],[0,0,0,"icbt",null,null,null,false],[0,0,0,"invariant_function_descriptors",null,null,null,false],[0,0,0,"isa_future_instructions",null,null,null,false],[0,0,0,"isa_v206_instructions",null,null,null,false],[0,0,0,"isa_v207_instructions",null,null,null,false],[0,0,0,"isa_v30_instructions",null,null,null,false],[0,0,0,"isa_v31_instructions",null,null,null,false],[0,0,0,"isel",null,null,null,false],[0,0,0,"ldbrx",null,null,null,false],[0,0,0,"lfiwax",null,null,null,false],[0,0,0,"longcall",null,null,null,false],[0,0,0,"mfocrf",null,null,null,false],[0,0,0,"mma",null,null,null,false],[0,0,0,"modern_aix_as",null,null,null,false],[0,0,0,"msync",null,null,null,false],[0,0,0,"paired_vector_memops",null,null,null,false],[0,0,0,"partword_atomics",null,null,null,false],[0,0,0,"pcrelative_memops",null,null,null,false],[0,0,0,"popcntd",null,null,null,false],[0,0,0,"power10_vector",null,null,null,false],[0,0,0,"power8_altivec",null,null,null,false],[0,0,0,"power8_vector",null,null,null,false],[0,0,0,"power9_altivec",null,null,null,false],[0,0,0,"power9_vector",null,null,null,false],[0,0,0,"ppc4xx",null,null,null,false],[0,0,0,"ppc6xx",null,null,null,false],[0,0,0,"ppc_postra_sched",null,null,null,false],[0,0,0,"ppc_prera_sched",null,null,null,false],[0,0,0,"predictable_select_expensive",null,null,null,false],[0,0,0,"prefix_instrs",null,null,null,false],[0,0,0,"privileged",null,null,null,false],[0,0,0,"quadword_atomics",null,null,null,false],[0,0,0,"recipprec",null,null,null,false],[0,0,0,"rop_protect",null,null,null,false],[0,0,0,"secure_plt",null,null,null,false],[0,0,0,"slow_popcntd",null,null,null,false],[0,0,0,"spe",null,null,null,false],[0,0,0,"stfiwx",null,null,null,false],[0,0,0,"two_const_nr",null,null,null,false],[0,0,0,"vectors_use_two_units",null,null,null,false],[0,0,0,"vsx",null,null,null,false],[54,90,0,null,null,null,null,false],[54,91,0,null,null,null,null,false],[54,92,0,null,null,null,null,false],[54,93,0,null,null,null,null,false],[54,95,0,null,null,null,null,false],[54,607,0,null,null,null,[],false],[54,608,0,null,null,null,null,false],[54,618,0,null,null,null,null,false],[54,628,0,null,null,null,null,false],[54,635,0,null,null,null,null,false],[54,642,0,null,null,null,null,false],[54,650,0,null,null,null,null,false],[54,658,0,null,null,null,null,false],[54,666,0,null,null,null,null,false],[54,674,0,null,null,null,null,false],[54,682,0,null,null,null,null,false],[54,690,0,null,null,null,null,false],[54,699,0,null,null,null,null,false],[54,708,0,null,null,null,null,false],[54,716,0,null,null,null,null,false],[54,729,0,null,null,null,null,false],[54,754,0,null,null,null,null,false],[54,763,0,null,null,null,null,false],[54,772,0,null,null,null,null,false],[54,783,0,null,null,null,null,false],[54,832,0,null,null,null,null,false],[54,840,0,null,null,null,null,false],[54,849,0,null,null,null,null,false],[54,858,0,null,null,null,null,false],[54,871,0,null,null,null,null,false],[54,878,0,null,null,null,null,false],[54,885,0,null,null,null,null,false],[54,898,0,null,null,null,null,false],[54,938,0,null,null,null,null,false],[54,986,0,null,null,null,null,false],[54,998,0,null,null,null,null,false],[54,1011,0,null,null,null,null,false],[54,1026,0,null,null,null,null,false],[54,1042,0,null,null,null,null,false],[54,1062,0,null,null,null,null,false],[54,1082,0,null,null,null,null,false],[54,1111,0,null,null,null,null,false],[54,1151,0,null,null,null,null,false],[40,464,0,null,null,null,null,false],[0,0,0,"target/riscv.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[55,2,0,null,null,null,null,false],[55,3,0,null,null,null,null,false],[55,4,0,null,null,null,null,false],[55,6,0,null,null,null,[7484,7485,7486,7487,7488,7489,7490,7491,7492,7493,7494,7495,7496,7497,7498,7499,7500,7501,7502,7503,7504,7505,7506,7507,7508,7509,7510,7511,7512,7513,7514,7515,7516,7517,7518,7519,7520,7521,7522,7523,7524,7525,7526,7527,7528,7529,7530,7531,7532,7533,7534,7535,7536,7537,7538,7539,7540,7541,7542,7543,7544,7545,7546,7547,7548,7549,7550,7551,7552,7553,7554,7555,7556,7557,7558,7559,7560,7561,7562,7563,7564,7565,7566,7567,7568,7569,7570,7571,7572,7573,7574,7575,7576,7577,7578,7579,7580,7581,7582,7583,7584,7585,7586,7587,7588,7589,7590,7591],false],[0,0,0,"32bit",null,null,null,false],[0,0,0,"64bit",null,null,null,false],[0,0,0,"a",null,null,null,false],[0,0,0,"c",null,null,null,false],[0,0,0,"d",null,null,null,false],[0,0,0,"e",null,null,null,false],[0,0,0,"experimental_zawrs",null,null,null,false],[0,0,0,"experimental_zca",null,null,null,false],[0,0,0,"experimental_zcd",null,null,null,false],[0,0,0,"experimental_zcf",null,null,null,false],[0,0,0,"experimental_zihintntl",null,null,null,false],[0,0,0,"experimental_ztso",null,null,null,false],[0,0,0,"experimental_zvfh",null,null,null,false],[0,0,0,"f",null,null,null,false],[0,0,0,"forced_atomics",null,null,null,false],[0,0,0,"h",null,null,null,false],[0,0,0,"lui_addi_fusion",null,null,null,false],[0,0,0,"m",null,null,null,false],[0,0,0,"no_default_unroll",null,null,null,false],[0,0,0,"no_optimized_zero_stride_load",null,null,null,false],[0,0,0,"no_rvc_hints",null,null,null,false],[0,0,0,"relax",null,null,null,false],[0,0,0,"reserve_x1",null,null,null,false],[0,0,0,"reserve_x10",null,null,null,false],[0,0,0,"reserve_x11",null,null,null,false],[0,0,0,"reserve_x12",null,null,null,false],[0,0,0,"reserve_x13",null,null,null,false],[0,0,0,"reserve_x14",null,null,null,false],[0,0,0,"reserve_x15",null,null,null,false],[0,0,0,"reserve_x16",null,null,null,false],[0,0,0,"reserve_x17",null,null,null,false],[0,0,0,"reserve_x18",null,null,null,false],[0,0,0,"reserve_x19",null,null,null,false],[0,0,0,"reserve_x2",null,null,null,false],[0,0,0,"reserve_x20",null,null,null,false],[0,0,0,"reserve_x21",null,null,null,false],[0,0,0,"reserve_x22",null,null,null,false],[0,0,0,"reserve_x23",null,null,null,false],[0,0,0,"reserve_x24",null,null,null,false],[0,0,0,"reserve_x25",null,null,null,false],[0,0,0,"reserve_x26",null,null,null,false],[0,0,0,"reserve_x27",null,null,null,false],[0,0,0,"reserve_x28",null,null,null,false],[0,0,0,"reserve_x29",null,null,null,false],[0,0,0,"reserve_x3",null,null,null,false],[0,0,0,"reserve_x30",null,null,null,false],[0,0,0,"reserve_x31",null,null,null,false],[0,0,0,"reserve_x4",null,null,null,false],[0,0,0,"reserve_x5",null,null,null,false],[0,0,0,"reserve_x6",null,null,null,false],[0,0,0,"reserve_x7",null,null,null,false],[0,0,0,"reserve_x8",null,null,null,false],[0,0,0,"reserve_x9",null,null,null,false],[0,0,0,"save_restore",null,null,null,false],[0,0,0,"short_forward_branch_opt",null,null,null,false],[0,0,0,"svinval",null,null,null,false],[0,0,0,"svnapot",null,null,null,false],[0,0,0,"svpbmt",null,null,null,false],[0,0,0,"tagged_globals",null,null,null,false],[0,0,0,"unaligned_scalar_mem",null,null,null,false],[0,0,0,"v",null,null,null,false],[0,0,0,"xtheadvdot",null,null,null,false],[0,0,0,"xventanacondops",null,null,null,false],[0,0,0,"zba",null,null,null,false],[0,0,0,"zbb",null,null,null,false],[0,0,0,"zbc",null,null,null,false],[0,0,0,"zbkb",null,null,null,false],[0,0,0,"zbkc",null,null,null,false],[0,0,0,"zbkx",null,null,null,false],[0,0,0,"zbs",null,null,null,false],[0,0,0,"zdinx",null,null,null,false],[0,0,0,"zfh",null,null,null,false],[0,0,0,"zfhmin",null,null,null,false],[0,0,0,"zfinx",null,null,null,false],[0,0,0,"zhinx",null,null,null,false],[0,0,0,"zhinxmin",null,null,null,false],[0,0,0,"zicbom",null,null,null,false],[0,0,0,"zicbop",null,null,null,false],[0,0,0,"zicboz",null,null,null,false],[0,0,0,"zihintpause",null,null,null,false],[0,0,0,"zk",null,null,null,false],[0,0,0,"zkn",null,null,null,false],[0,0,0,"zknd",null,null,null,false],[0,0,0,"zkne",null,null,null,false],[0,0,0,"zknh",null,null,null,false],[0,0,0,"zkr",null,null,null,false],[0,0,0,"zks",null,null,null,false],[0,0,0,"zksed",null,null,null,false],[0,0,0,"zksh",null,null,null,false],[0,0,0,"zkt",null,null,null,false],[0,0,0,"zmmul",null,null,null,false],[0,0,0,"zve32f",null,null,null,false],[0,0,0,"zve32x",null,null,null,false],[0,0,0,"zve64d",null,null,null,false],[0,0,0,"zve64f",null,null,null,false],[0,0,0,"zve64x",null,null,null,false],[0,0,0,"zvl1024b",null,null,null,false],[0,0,0,"zvl128b",null,null,null,false],[0,0,0,"zvl16384b",null,null,null,false],[0,0,0,"zvl2048b",null,null,null,false],[0,0,0,"zvl256b",null,null,null,false],[0,0,0,"zvl32768b",null,null,null,false],[0,0,0,"zvl32b",null,null,null,false],[0,0,0,"zvl4096b",null,null,null,false],[0,0,0,"zvl512b",null,null,null,false],[0,0,0,"zvl64b",null,null,null,false],[0,0,0,"zvl65536b",null,null,null,false],[0,0,0,"zvl8192b",null,null,null,false],[55,117,0,null,null,null,null,false],[55,118,0,null,null,null,null,false],[55,119,0,null,null,null,null,false],[55,120,0,null,null,null,null,false],[55,122,0,null,null,null,null,false],[55,745,0,null,null,null,[],false],[55,746,0,null,null,null,null,false],[55,757,0,null,null,null,null,false],[55,768,0,null,null,null,null,false],[55,773,0,null,null,null,null,false],[55,780,0,null,null,null,null,false],[55,787,0,null,null,null,null,false],[55,792,0,null,null,null,null,false],[55,799,0,null,null,null,null,false],[55,806,0,null,null,null,null,false],[55,814,0,null,null,null,null,false],[55,823,0,null,null,null,null,false],[55,833,0,null,null,null,null,false],[55,844,0,null,null,null,null,false],[55,854,0,null,null,null,null,false],[55,865,0,null,null,null,null,false],[55,878,0,null,null,null,null,false],[55,888,0,null,null,null,null,false],[55,898,0,null,null,null,null,false],[55,909,0,null,null,null,null,false],[55,922,0,null,null,null,null,false],[55,933,0,null,null,null,null,false],[55,946,0,null,null,null,null,false],[55,955,0,null,null,null,null,false],[40,465,0,null,null,null,null,false],[0,0,0,"target/sparc.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[56,2,0,null,null,null,null,false],[56,3,0,null,null,null,null,false],[56,4,0,null,null,null,null,false],[56,6,0,null,null,null,[7627,7628,7629,7630,7631,7632,7633,7634,7635,7636,7637,7638,7639,7640,7641,7642,7643,7644,7645],false],[0,0,0,"deprecated_v8",null,null,null,false],[0,0,0,"detectroundchange",null,null,null,false],[0,0,0,"fixallfdivsqrt",null,null,null,false],[0,0,0,"hard_quad_float",null,null,null,false],[0,0,0,"hasleoncasa",null,null,null,false],[0,0,0,"hasumacsmac",null,null,null,false],[0,0,0,"insertnopload",null,null,null,false],[0,0,0,"leon",null,null,null,false],[0,0,0,"leoncyclecounter",null,null,null,false],[0,0,0,"leonpwrpsr",null,null,null,false],[0,0,0,"no_fmuls",null,null,null,false],[0,0,0,"no_fsmuld",null,null,null,false],[0,0,0,"popc",null,null,null,false],[0,0,0,"soft_float",null,null,null,false],[0,0,0,"soft_mul_div",null,null,null,false],[0,0,0,"v9",null,null,null,false],[0,0,0,"vis",null,null,null,false],[0,0,0,"vis2",null,null,null,false],[0,0,0,"vis3",null,null,null,false],[56,28,0,null,null,null,null,false],[56,29,0,null,null,null,null,false],[56,30,0,null,null,null,null,false],[56,31,0,null,null,null,null,false],[56,33,0,null,null,null,null,false],[56,140,0,null,null,null,[],false],[56,141,0,null,null,null,null,false],[56,149,0,null,null,null,null,false],[56,157,0,null,null,null,null,false],[56,162,0,null,null,null,null,false],[56,167,0,null,null,null,null,false],[56,175,0,null,null,null,null,false],[56,186,0,null,null,null,null,false],[56,191,0,null,null,null,null,false],[56,198,0,null,null,null,null,false],[56,206,0,null,null,null,null,false],[56,215,0,null,null,null,null,false],[56,223,0,null,null,null,null,false],[56,231,0,null,null,null,null,false],[56,239,0,null,null,null,null,false],[56,247,0,null,null,null,null,false],[56,255,0,null,null,null,null,false],[56,263,0,null,null,null,null,false],[56,271,0,null,null,null,null,false],[56,279,0,null,null,null,null,false],[56,287,0,null,null,null,null,false],[56,295,0,null,null,null,null,false],[56,303,0,null,null,null,null,false],[56,311,0,null,null,null,null,false],[56,319,0,null,null,null,null,false],[56,327,0,null,null,null,null,false],[56,335,0,null,null,null,null,false],[56,345,0,null,null,null,null,false],[56,356,0,null,null,null,null,false],[56,367,0,null,null,null,null,false],[56,379,0,null,null,null,null,false],[56,384,0,null,null,null,null,false],[56,389,0,null,null,null,null,false],[56,394,0,null,null,null,null,false],[56,399,0,null,null,null,null,false],[56,404,0,null,null,null,null,false],[56,413,0,null,null,null,null,false],[56,423,0,null,null,null,null,false],[56,434,0,null,null,null,null,false],[56,442,0,null,null,null,null,false],[56,447,0,null,null,null,null,false],[40,466,0,null,null,null,null,false],[0,0,0,"target/spirv.zig",null," This file is auto-generated by tools/update_spirv_features.zig.\n TODO: Dependencies of capabilities on extensions.\n TODO: Dependencies of extensions on extensions.\n TODO: Dependencies of extensions on versions.\n",[],false],[57,5,0,null,null,null,null,false],[57,6,0,null,null,null,null,false],[57,7,0,null,null,null,null,false],[57,9,0,null,null,null,[7698,7699,7700,7701,7702,7703,7704,7705,7706,7707,7708,7709,7710,7711,7712,7713,7714,7715,7716,7717,7718,7719,7720,7721,7722,7723,7724,7725,7726,7727,7728,7729,7730,7731,7732,7733,7734,7735,7736,7737,7738,7739,7740,7741,7742,7743,7744,7745,7746,7747,7748,7749,7750,7751,7752,7753,7754,7755,7756,7757,7758,7759,7760,7761,7762,7763,7764,7765,7766,7767,7768,7769,7770,7771,7772,7773,7774,7775,7776,7777,7778,7779,7780,7781,7782,7783,7784,7785,7786,7787,7788,7789,7790,7791,7792,7793,7794,7795,7796,7797,7798,7799,7800,7801,7802,7803,7804,7805,7806,7807,7808,7809,7810,7811,7812,7813,7814,7815,7816,7817,7818,7819,7820,7821,7822,7823,7824,7825,7826,7827,7828,7829,7830,7831,7832,7833,7834,7835,7836,7837,7838,7839,7840,7841,7842,7843,7844,7845,7846,7847,7848,7849,7850,7851,7852,7853,7854,7855,7856,7857,7858,7859,7860,7861,7862,7863,7864,7865,7866,7867,7868,7869,7870,7871,7872,7873,7874,7875,7876,7877,7878,7879,7880,7881,7882,7883,7884,7885,7886,7887,7888,7889,7890,7891,7892,7893,7894,7895,7896,7897,7898,7899,7900,7901,7902,7903,7904,7905,7906,7907,7908,7909,7910,7911,7912,7913,7914,7915,7916,7917,7918,7919,7920,7921,7922,7923,7924,7925,7926,7927,7928,7929,7930,7931,7932,7933,7934,7935,7936,7937,7938,7939,7940,7941,7942,7943,7944,7945,7946,7947,7948,7949,7950,7951,7952,7953,7954,7955,7956,7957,7958,7959,7960,7961,7962,7963,7964,7965,7966,7967,7968,7969,7970,7971,7972,7973,7974,7975,7976,7977,7978,7979,7980,7981],false],[0,0,0,"v1_1",null,null,null,false],[0,0,0,"v1_2",null,null,null,false],[0,0,0,"v1_3",null,null,null,false],[0,0,0,"v1_4",null,null,null,false],[0,0,0,"v1_5",null,null,null,false],[0,0,0,"SPV_AMD_shader_fragment_mask",null,null,null,false],[0,0,0,"SPV_AMD_gpu_shader_int16",null,null,null,false],[0,0,0,"SPV_AMD_gpu_shader_half_float",null,null,null,false],[0,0,0,"SPV_AMD_texture_gather_bias_lod",null,null,null,false],[0,0,0,"SPV_AMD_shader_ballot",null,null,null,false],[0,0,0,"SPV_AMD_gcn_shader",null,null,null,false],[0,0,0,"SPV_AMD_shader_image_load_store_lod",null,null,null,false],[0,0,0,"SPV_AMD_shader_explicit_vertex_parameter",null,null,null,false],[0,0,0,"SPV_AMD_shader_trinary_minmax",null,null,null,false],[0,0,0,"SPV_AMD_gpu_shader_half_float_fetch",null,null,null,false],[0,0,0,"SPV_GOOGLE_hlsl_functionality1",null,null,null,false],[0,0,0,"SPV_GOOGLE_user_type",null,null,null,false],[0,0,0,"SPV_GOOGLE_decorate_string",null,null,null,false],[0,0,0,"SPV_EXT_demote_to_helper_invocation",null,null,null,false],[0,0,0,"SPV_EXT_descriptor_indexing",null,null,null,false],[0,0,0,"SPV_EXT_fragment_fully_covered",null,null,null,false],[0,0,0,"SPV_EXT_shader_stencil_export",null,null,null,false],[0,0,0,"SPV_EXT_physical_storage_buffer",null,null,null,false],[0,0,0,"SPV_EXT_shader_atomic_float_add",null,null,null,false],[0,0,0,"SPV_EXT_shader_atomic_float_min_max",null,null,null,false],[0,0,0,"SPV_EXT_shader_image_int64",null,null,null,false],[0,0,0,"SPV_EXT_fragment_shader_interlock",null,null,null,false],[0,0,0,"SPV_EXT_fragment_invocation_density",null,null,null,false],[0,0,0,"SPV_EXT_shader_viewport_index_layer",null,null,null,false],[0,0,0,"SPV_INTEL_loop_fuse",null,null,null,false],[0,0,0,"SPV_INTEL_fpga_dsp_control",null,null,null,false],[0,0,0,"SPV_INTEL_fpga_reg",null,null,null,false],[0,0,0,"SPV_INTEL_fpga_memory_accesses",null,null,null,false],[0,0,0,"SPV_INTEL_fpga_loop_controls",null,null,null,false],[0,0,0,"SPV_INTEL_io_pipes",null,null,null,false],[0,0,0,"SPV_INTEL_unstructured_loop_controls",null,null,null,false],[0,0,0,"SPV_INTEL_blocking_pipes",null,null,null,false],[0,0,0,"SPV_INTEL_device_side_avc_motion_estimation",null,null,null,false],[0,0,0,"SPV_INTEL_fpga_memory_attributes",null,null,null,false],[0,0,0,"SPV_INTEL_fp_fast_math_mode",null,null,null,false],[0,0,0,"SPV_INTEL_media_block_io",null,null,null,false],[0,0,0,"SPV_INTEL_shader_integer_functions2",null,null,null,false],[0,0,0,"SPV_INTEL_subgroups",null,null,null,false],[0,0,0,"SPV_INTEL_fpga_cluster_attributes",null,null,null,false],[0,0,0,"SPV_INTEL_kernel_attributes",null,null,null,false],[0,0,0,"SPV_INTEL_arbitrary_precision_integers",null,null,null,false],[0,0,0,"SPV_KHR_8bit_storage",null,null,null,false],[0,0,0,"SPV_KHR_shader_clock",null,null,null,false],[0,0,0,"SPV_KHR_device_group",null,null,null,false],[0,0,0,"SPV_KHR_16bit_storage",null,null,null,false],[0,0,0,"SPV_KHR_variable_pointers",null,null,null,false],[0,0,0,"SPV_KHR_no_integer_wrap_decoration",null,null,null,false],[0,0,0,"SPV_KHR_subgroup_vote",null,null,null,false],[0,0,0,"SPV_KHR_multiview",null,null,null,false],[0,0,0,"SPV_KHR_shader_ballot",null,null,null,false],[0,0,0,"SPV_KHR_vulkan_memory_model",null,null,null,false],[0,0,0,"SPV_KHR_physical_storage_buffer",null,null,null,false],[0,0,0,"SPV_KHR_workgroup_memory_explicit_layout",null,null,null,false],[0,0,0,"SPV_KHR_fragment_shading_rate",null,null,null,false],[0,0,0,"SPV_KHR_shader_atomic_counter_ops",null,null,null,false],[0,0,0,"SPV_KHR_shader_draw_parameters",null,null,null,false],[0,0,0,"SPV_KHR_storage_buffer_storage_class",null,null,null,false],[0,0,0,"SPV_KHR_linkonce_odr",null,null,null,false],[0,0,0,"SPV_KHR_terminate_invocation",null,null,null,false],[0,0,0,"SPV_KHR_non_semantic_info",null,null,null,false],[0,0,0,"SPV_KHR_post_depth_coverage",null,null,null,false],[0,0,0,"SPV_KHR_expect_assume",null,null,null,false],[0,0,0,"SPV_KHR_ray_tracing",null,null,null,false],[0,0,0,"SPV_KHR_ray_query",null,null,null,false],[0,0,0,"SPV_KHR_float_controls",null,null,null,false],[0,0,0,"SPV_NV_viewport_array2",null,null,null,false],[0,0,0,"SPV_NV_shader_subgroup_partitioned",null,null,null,false],[0,0,0,"SPV_NVX_multiview_per_view_attributes",null,null,null,false],[0,0,0,"SPV_NV_ray_tracing",null,null,null,false],[0,0,0,"SPV_NV_shader_image_footprint",null,null,null,false],[0,0,0,"SPV_NV_shading_rate",null,null,null,false],[0,0,0,"SPV_NV_stereo_view_rendering",null,null,null,false],[0,0,0,"SPV_NV_compute_shader_derivatives",null,null,null,false],[0,0,0,"SPV_NV_shader_sm_builtins",null,null,null,false],[0,0,0,"SPV_NV_mesh_shader",null,null,null,false],[0,0,0,"SPV_NV_geometry_shader_passthrough",null,null,null,false],[0,0,0,"SPV_NV_fragment_shader_barycentric",null,null,null,false],[0,0,0,"SPV_NV_cooperative_matrix",null,null,null,false],[0,0,0,"SPV_NV_sample_mask_override_coverage",null,null,null,false],[0,0,0,"Matrix",null,null,null,false],[0,0,0,"Shader",null,null,null,false],[0,0,0,"Geometry",null,null,null,false],[0,0,0,"Tessellation",null,null,null,false],[0,0,0,"Addresses",null,null,null,false],[0,0,0,"Linkage",null,null,null,false],[0,0,0,"Kernel",null,null,null,false],[0,0,0,"Vector16",null,null,null,false],[0,0,0,"Float16Buffer",null,null,null,false],[0,0,0,"Float16",null,null,null,false],[0,0,0,"Float64",null,null,null,false],[0,0,0,"Int64",null,null,null,false],[0,0,0,"Int64Atomics",null,null,null,false],[0,0,0,"ImageBasic",null,null,null,false],[0,0,0,"ImageReadWrite",null,null,null,false],[0,0,0,"ImageMipmap",null,null,null,false],[0,0,0,"Pipes",null,null,null,false],[0,0,0,"Groups",null,null,null,false],[0,0,0,"DeviceEnqueue",null,null,null,false],[0,0,0,"LiteralSampler",null,null,null,false],[0,0,0,"AtomicStorage",null,null,null,false],[0,0,0,"Int16",null,null,null,false],[0,0,0,"TessellationPointSize",null,null,null,false],[0,0,0,"GeometryPointSize",null,null,null,false],[0,0,0,"ImageGatherExtended",null,null,null,false],[0,0,0,"StorageImageMultisample",null,null,null,false],[0,0,0,"UniformBufferArrayDynamicIndexing",null,null,null,false],[0,0,0,"SampledImageArrayDynamicIndexing",null,null,null,false],[0,0,0,"StorageBufferArrayDynamicIndexing",null,null,null,false],[0,0,0,"StorageImageArrayDynamicIndexing",null,null,null,false],[0,0,0,"ClipDistance",null,null,null,false],[0,0,0,"CullDistance",null,null,null,false],[0,0,0,"ImageCubeArray",null,null,null,false],[0,0,0,"SampleRateShading",null,null,null,false],[0,0,0,"ImageRect",null,null,null,false],[0,0,0,"SampledRect",null,null,null,false],[0,0,0,"GenericPointer",null,null,null,false],[0,0,0,"Int8",null,null,null,false],[0,0,0,"InputAttachment",null,null,null,false],[0,0,0,"SparseResidency",null,null,null,false],[0,0,0,"MinLod",null,null,null,false],[0,0,0,"Sampled1D",null,null,null,false],[0,0,0,"Image1D",null,null,null,false],[0,0,0,"SampledCubeArray",null,null,null,false],[0,0,0,"SampledBuffer",null,null,null,false],[0,0,0,"ImageBuffer",null,null,null,false],[0,0,0,"ImageMSArray",null,null,null,false],[0,0,0,"StorageImageExtendedFormats",null,null,null,false],[0,0,0,"ImageQuery",null,null,null,false],[0,0,0,"DerivativeControl",null,null,null,false],[0,0,0,"InterpolationFunction",null,null,null,false],[0,0,0,"TransformFeedback",null,null,null,false],[0,0,0,"GeometryStreams",null,null,null,false],[0,0,0,"StorageImageReadWithoutFormat",null,null,null,false],[0,0,0,"StorageImageWriteWithoutFormat",null,null,null,false],[0,0,0,"MultiViewport",null,null,null,false],[0,0,0,"SubgroupDispatch",null,null,null,false],[0,0,0,"NamedBarrier",null,null,null,false],[0,0,0,"PipeStorage",null,null,null,false],[0,0,0,"GroupNonUniform",null,null,null,false],[0,0,0,"GroupNonUniformVote",null,null,null,false],[0,0,0,"GroupNonUniformArithmetic",null,null,null,false],[0,0,0,"GroupNonUniformBallot",null,null,null,false],[0,0,0,"GroupNonUniformShuffle",null,null,null,false],[0,0,0,"GroupNonUniformShuffleRelative",null,null,null,false],[0,0,0,"GroupNonUniformClustered",null,null,null,false],[0,0,0,"GroupNonUniformQuad",null,null,null,false],[0,0,0,"ShaderLayer",null,null,null,false],[0,0,0,"ShaderViewportIndex",null,null,null,false],[0,0,0,"FragmentShadingRateKHR",null,null,null,false],[0,0,0,"SubgroupBallotKHR",null,null,null,false],[0,0,0,"DrawParameters",null,null,null,false],[0,0,0,"WorkgroupMemoryExplicitLayoutKHR",null,null,null,false],[0,0,0,"WorkgroupMemoryExplicitLayout8BitAccessKHR",null,null,null,false],[0,0,0,"WorkgroupMemoryExplicitLayout16BitAccessKHR",null,null,null,false],[0,0,0,"SubgroupVoteKHR",null,null,null,false],[0,0,0,"StorageBuffer16BitAccess",null,null,null,false],[0,0,0,"StorageUniformBufferBlock16",null,null,null,false],[0,0,0,"UniformAndStorageBuffer16BitAccess",null,null,null,false],[0,0,0,"StorageUniform16",null,null,null,false],[0,0,0,"StoragePushConstant16",null,null,null,false],[0,0,0,"StorageInputOutput16",null,null,null,false],[0,0,0,"DeviceGroup",null,null,null,false],[0,0,0,"MultiView",null,null,null,false],[0,0,0,"VariablePointersStorageBuffer",null,null,null,false],[0,0,0,"VariablePointers",null,null,null,false],[0,0,0,"AtomicStorageOps",null,null,null,false],[0,0,0,"SampleMaskPostDepthCoverage",null,null,null,false],[0,0,0,"StorageBuffer8BitAccess",null,null,null,false],[0,0,0,"UniformAndStorageBuffer8BitAccess",null,null,null,false],[0,0,0,"StoragePushConstant8",null,null,null,false],[0,0,0,"DenormPreserve",null,null,null,false],[0,0,0,"DenormFlushToZero",null,null,null,false],[0,0,0,"SignedZeroInfNanPreserve",null,null,null,false],[0,0,0,"RoundingModeRTE",null,null,null,false],[0,0,0,"RoundingModeRTZ",null,null,null,false],[0,0,0,"RayQueryProvisionalKHR",null,null,null,false],[0,0,0,"RayQueryKHR",null,null,null,false],[0,0,0,"RayTraversalPrimitiveCullingKHR",null,null,null,false],[0,0,0,"RayTracingKHR",null,null,null,false],[0,0,0,"Float16ImageAMD",null,null,null,false],[0,0,0,"ImageGatherBiasLodAMD",null,null,null,false],[0,0,0,"FragmentMaskAMD",null,null,null,false],[0,0,0,"StencilExportEXT",null,null,null,false],[0,0,0,"ImageReadWriteLodAMD",null,null,null,false],[0,0,0,"Int64ImageEXT",null,null,null,false],[0,0,0,"ShaderClockKHR",null,null,null,false],[0,0,0,"SampleMaskOverrideCoverageNV",null,null,null,false],[0,0,0,"GeometryShaderPassthroughNV",null,null,null,false],[0,0,0,"ShaderViewportIndexLayerEXT",null,null,null,false],[0,0,0,"ShaderViewportIndexLayerNV",null,null,null,false],[0,0,0,"ShaderViewportMaskNV",null,null,null,false],[0,0,0,"ShaderStereoViewNV",null,null,null,false],[0,0,0,"PerViewAttributesNV",null,null,null,false],[0,0,0,"FragmentFullyCoveredEXT",null,null,null,false],[0,0,0,"MeshShadingNV",null,null,null,false],[0,0,0,"ImageFootprintNV",null,null,null,false],[0,0,0,"FragmentBarycentricNV",null,null,null,false],[0,0,0,"ComputeDerivativeGroupQuadsNV",null,null,null,false],[0,0,0,"FragmentDensityEXT",null,null,null,false],[0,0,0,"ShadingRateNV",null,null,null,false],[0,0,0,"GroupNonUniformPartitionedNV",null,null,null,false],[0,0,0,"ShaderNonUniform",null,null,null,false],[0,0,0,"ShaderNonUniformEXT",null,null,null,false],[0,0,0,"RuntimeDescriptorArray",null,null,null,false],[0,0,0,"RuntimeDescriptorArrayEXT",null,null,null,false],[0,0,0,"InputAttachmentArrayDynamicIndexing",null,null,null,false],[0,0,0,"InputAttachmentArrayDynamicIndexingEXT",null,null,null,false],[0,0,0,"UniformTexelBufferArrayDynamicIndexing",null,null,null,false],[0,0,0,"UniformTexelBufferArrayDynamicIndexingEXT",null,null,null,false],[0,0,0,"StorageTexelBufferArrayDynamicIndexing",null,null,null,false],[0,0,0,"StorageTexelBufferArrayDynamicIndexingEXT",null,null,null,false],[0,0,0,"UniformBufferArrayNonUniformIndexing",null,null,null,false],[0,0,0,"UniformBufferArrayNonUniformIndexingEXT",null,null,null,false],[0,0,0,"SampledImageArrayNonUniformIndexing",null,null,null,false],[0,0,0,"SampledImageArrayNonUniformIndexingEXT",null,null,null,false],[0,0,0,"StorageBufferArrayNonUniformIndexing",null,null,null,false],[0,0,0,"StorageBufferArrayNonUniformIndexingEXT",null,null,null,false],[0,0,0,"StorageImageArrayNonUniformIndexing",null,null,null,false],[0,0,0,"StorageImageArrayNonUniformIndexingEXT",null,null,null,false],[0,0,0,"InputAttachmentArrayNonUniformIndexing",null,null,null,false],[0,0,0,"InputAttachmentArrayNonUniformIndexingEXT",null,null,null,false],[0,0,0,"UniformTexelBufferArrayNonUniformIndexing",null,null,null,false],[0,0,0,"UniformTexelBufferArrayNonUniformIndexingEXT",null,null,null,false],[0,0,0,"StorageTexelBufferArrayNonUniformIndexing",null,null,null,false],[0,0,0,"StorageTexelBufferArrayNonUniformIndexingEXT",null,null,null,false],[0,0,0,"RayTracingNV",null,null,null,false],[0,0,0,"VulkanMemoryModel",null,null,null,false],[0,0,0,"VulkanMemoryModelKHR",null,null,null,false],[0,0,0,"VulkanMemoryModelDeviceScope",null,null,null,false],[0,0,0,"VulkanMemoryModelDeviceScopeKHR",null,null,null,false],[0,0,0,"PhysicalStorageBufferAddresses",null,null,null,false],[0,0,0,"PhysicalStorageBufferAddressesEXT",null,null,null,false],[0,0,0,"ComputeDerivativeGroupLinearNV",null,null,null,false],[0,0,0,"RayTracingProvisionalKHR",null,null,null,false],[0,0,0,"CooperativeMatrixNV",null,null,null,false],[0,0,0,"FragmentShaderSampleInterlockEXT",null,null,null,false],[0,0,0,"FragmentShaderShadingRateInterlockEXT",null,null,null,false],[0,0,0,"ShaderSMBuiltinsNV",null,null,null,false],[0,0,0,"FragmentShaderPixelInterlockEXT",null,null,null,false],[0,0,0,"DemoteToHelperInvocationEXT",null,null,null,false],[0,0,0,"SubgroupShuffleINTEL",null,null,null,false],[0,0,0,"SubgroupBufferBlockIOINTEL",null,null,null,false],[0,0,0,"SubgroupImageBlockIOINTEL",null,null,null,false],[0,0,0,"SubgroupImageMediaBlockIOINTEL",null,null,null,false],[0,0,0,"RoundToInfinityINTEL",null,null,null,false],[0,0,0,"FloatingPointModeINTEL",null,null,null,false],[0,0,0,"IntegerFunctions2INTEL",null,null,null,false],[0,0,0,"FunctionPointersINTEL",null,null,null,false],[0,0,0,"IndirectReferencesINTEL",null,null,null,false],[0,0,0,"AsmINTEL",null,null,null,false],[0,0,0,"AtomicFloat32MinMaxEXT",null,null,null,false],[0,0,0,"AtomicFloat64MinMaxEXT",null,null,null,false],[0,0,0,"AtomicFloat16MinMaxEXT",null,null,null,false],[0,0,0,"VectorComputeINTEL",null,null,null,false],[0,0,0,"VectorAnyINTEL",null,null,null,false],[0,0,0,"ExpectAssumeKHR",null,null,null,false],[0,0,0,"SubgroupAvcMotionEstimationINTEL",null,null,null,false],[0,0,0,"SubgroupAvcMotionEstimationIntraINTEL",null,null,null,false],[0,0,0,"SubgroupAvcMotionEstimationChromaINTEL",null,null,null,false],[0,0,0,"VariableLengthArrayINTEL",null,null,null,false],[0,0,0,"FunctionFloatControlINTEL",null,null,null,false],[0,0,0,"FPGAMemoryAttributesINTEL",null,null,null,false],[0,0,0,"FPFastMathModeINTEL",null,null,null,false],[0,0,0,"ArbitraryPrecisionIntegersINTEL",null,null,null,false],[0,0,0,"UnstructuredLoopControlsINTEL",null,null,null,false],[0,0,0,"FPGALoopControlsINTEL",null,null,null,false],[0,0,0,"KernelAttributesINTEL",null,null,null,false],[0,0,0,"FPGAKernelAttributesINTEL",null,null,null,false],[0,0,0,"FPGAMemoryAccessesINTEL",null,null,null,false],[0,0,0,"FPGAClusterAttributesINTEL",null,null,null,false],[0,0,0,"LoopFuseINTEL",null,null,null,false],[0,0,0,"FPGABufferLocationINTEL",null,null,null,false],[0,0,0,"USMStorageClassesINTEL",null,null,null,false],[0,0,0,"IOPipesINTEL",null,null,null,false],[0,0,0,"BlockingPipesINTEL",null,null,null,false],[0,0,0,"FPGARegINTEL",null,null,null,false],[0,0,0,"AtomicFloat32AddEXT",null,null,null,false],[0,0,0,"AtomicFloat64AddEXT",null,null,null,false],[0,0,0,"LongConstantCompositeINTEL",null,null,null,false],[57,296,0,null,null,null,null,false],[57,297,0,null,null,null,null,false],[57,298,0,null,null,null,null,false],[57,299,0,null,null,null,null,false],[57,301,0,null,null,null,null,false],[57,2084,0,null,null,null,[],false],[57,2085,0,null,null,null,null,false],[40,467,0,null,null,null,null,false],[0,0,0,"target/s390x.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[58,2,0,null,null,null,null,false],[58,3,0,null,null,null,null,false],[58,4,0,null,null,null,null,false],[58,6,0,null,null,null,[7995,7996,7997,7998,7999,8000,8001,8002,8003,8004,8005,8006,8007,8008,8009,8010,8011,8012,8013,8014,8015,8016,8017,8018,8019,8020,8021,8022,8023,8024,8025,8026,8027,8028,8029,8030,8031,8032,8033,8034,8035],false],[0,0,0,"bear_enhancement",null,null,null,false],[0,0,0,"deflate_conversion",null,null,null,false],[0,0,0,"dfp_packed_conversion",null,null,null,false],[0,0,0,"dfp_zoned_conversion",null,null,null,false],[0,0,0,"distinct_ops",null,null,null,false],[0,0,0,"enhanced_dat_2",null,null,null,false],[0,0,0,"enhanced_sort",null,null,null,false],[0,0,0,"execution_hint",null,null,null,false],[0,0,0,"fast_serialization",null,null,null,false],[0,0,0,"fp_extension",null,null,null,false],[0,0,0,"guarded_storage",null,null,null,false],[0,0,0,"high_word",null,null,null,false],[0,0,0,"insert_reference_bits_multiple",null,null,null,false],[0,0,0,"interlocked_access1",null,null,null,false],[0,0,0,"load_and_trap",null,null,null,false],[0,0,0,"load_and_zero_rightmost_byte",null,null,null,false],[0,0,0,"load_store_on_cond",null,null,null,false],[0,0,0,"load_store_on_cond_2",null,null,null,false],[0,0,0,"message_security_assist_extension3",null,null,null,false],[0,0,0,"message_security_assist_extension4",null,null,null,false],[0,0,0,"message_security_assist_extension5",null,null,null,false],[0,0,0,"message_security_assist_extension7",null,null,null,false],[0,0,0,"message_security_assist_extension8",null,null,null,false],[0,0,0,"message_security_assist_extension9",null,null,null,false],[0,0,0,"miscellaneous_extensions",null,null,null,false],[0,0,0,"miscellaneous_extensions_2",null,null,null,false],[0,0,0,"miscellaneous_extensions_3",null,null,null,false],[0,0,0,"nnp_assist",null,null,null,false],[0,0,0,"population_count",null,null,null,false],[0,0,0,"processor_activity_instrumentation",null,null,null,false],[0,0,0,"processor_assist",null,null,null,false],[0,0,0,"reset_dat_protection",null,null,null,false],[0,0,0,"reset_reference_bits_multiple",null,null,null,false],[0,0,0,"soft_float",null,null,null,false],[0,0,0,"transactional_execution",null,null,null,false],[0,0,0,"vector",null,null,null,false],[0,0,0,"vector_enhancements_1",null,null,null,false],[0,0,0,"vector_enhancements_2",null,null,null,false],[0,0,0,"vector_packed_decimal",null,null,null,false],[0,0,0,"vector_packed_decimal_enhancement",null,null,null,false],[0,0,0,"vector_packed_decimal_enhancement_2",null,null,null,false],[58,50,0,null,null,null,null,false],[58,51,0,null,null,null,null,false],[58,52,0,null,null,null,null,false],[58,53,0,null,null,null,null,false],[58,55,0,null,null,null,null,false],[58,272,0,null,null,null,[],false],[58,273,0,null,null,null,null,false],[58,296,0,null,null,null,null,false],[58,324,0,null,null,null,null,false],[58,359,0,null,null,null,null,false],[58,400,0,null,null,null,null,false],[58,446,0,null,null,null,null,false],[58,451,0,null,null,null,null,false],[58,467,0,null,null,null,null,false],[58,472,0,null,null,null,null,false],[58,477,0,null,null,null,null,false],[58,505,0,null,null,null,null,false],[58,540,0,null,null,null,null,false],[58,581,0,null,null,null,null,false],[58,627,0,null,null,null,null,false],[58,643,0,null,null,null,null,false],[40,468,0,null,null,null,null,false],[0,0,0,"target/ve.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[59,2,0,null,null,null,null,false],[59,3,0,null,null,null,null,false],[59,4,0,null,null,null,null,false],[59,6,0,null,null,null,[8063],false],[0,0,0,"vpu",null,null,null,false],[59,10,0,null,null,null,null,false],[59,11,0,null,null,null,null,false],[59,12,0,null,null,null,null,false],[59,13,0,null,null,null,null,false],[59,15,0,null,null,null,null,false],[59,32,0,null,null,null,[],false],[59,33,0,null,null,null,null,false],[40,469,0,null,null,null,null,false],[0,0,0,"target/wasm.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[60,2,0,null,null,null,null,false],[60,3,0,null,null,null,null,false],[60,4,0,null,null,null,null,false],[60,6,0,null,null,null,[8077,8078,8079,8080,8081,8082,8083,8084,8085,8086,8087,8088],false],[0,0,0,"atomics",null,null,null,false],[0,0,0,"bulk_memory",null,null,null,false],[0,0,0,"exception_handling",null,null,null,false],[0,0,0,"extended_const",null,null,null,false],[0,0,0,"multivalue",null,null,null,false],[0,0,0,"mutable_globals",null,null,null,false],[0,0,0,"nontrapping_fptoint",null,null,null,false],[0,0,0,"reference_types",null,null,null,false],[0,0,0,"relaxed_simd",null,null,null,false],[0,0,0,"sign_ext",null,null,null,false],[0,0,0,"simd128",null,null,null,false],[0,0,0,"tail_call",null,null,null,false],[60,21,0,null,null,null,null,false],[60,22,0,null,null,null,null,false],[60,23,0,null,null,null,null,false],[60,24,0,null,null,null,null,false],[60,26,0,null,null,null,null,false],[60,98,0,null,null,null,[],false],[60,99,0,null,null,null,null,false],[60,112,0,null,null,null,null,false],[60,120,0,null,null,null,null,false],[40,470,0,null,null,null,null,false],[0,0,0,"target/x86.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[61,2,0,null,null,null,null,false],[61,3,0,null,null,null,null,false],[61,4,0,null,null,null,null,false],[61,6,0,null,null,null,[8104,8105,8106,8107,8108,8109,8110,8111,8112,8113,8114,8115,8116,8117,8118,8119,8120,8121,8122,8123,8124,8125,8126,8127,8128,8129,8130,8131,8132,8133,8134,8135,8136,8137,8138,8139,8140,8141,8142,8143,8144,8145,8146,8147,8148,8149,8150,8151,8152,8153,8154,8155,8156,8157,8158,8159,8160,8161,8162,8163,8164,8165,8166,8167,8168,8169,8170,8171,8172,8173,8174,8175,8176,8177,8178,8179,8180,8181,8182,8183,8184,8185,8186,8187,8188,8189,8190,8191,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8203,8204,8205,8206,8207,8208,8209,8210,8211,8212,8213,8214,8215,8216,8217,8218,8219,8220,8221,8222,8223,8224,8225,8226,8227,8228,8229,8230,8231,8232,8233,8234,8235,8236,8237,8238,8239,8240,8241,8242,8243,8244,8245,8246,8247,8248,8249,8250,8251,8252,8253,8254,8255,8256,8257,8258,8259,8260,8261,8262,8263,8264,8265],false],[0,0,0,"16bit_mode",null,null,null,false],[0,0,0,"32bit_mode",null,null,null,false],[0,0,0,"3dnow",null,null,null,false],[0,0,0,"3dnowa",null,null,null,false],[0,0,0,"64bit",null,null,null,false],[0,0,0,"adx",null,null,null,false],[0,0,0,"aes",null,null,null,false],[0,0,0,"allow_light_256_bit",null,null,null,false],[0,0,0,"amx_bf16",null,null,null,false],[0,0,0,"amx_fp16",null,null,null,false],[0,0,0,"amx_int8",null,null,null,false],[0,0,0,"amx_tile",null,null,null,false],[0,0,0,"avx",null,null,null,false],[0,0,0,"avx2",null,null,null,false],[0,0,0,"avx512bf16",null,null,null,false],[0,0,0,"avx512bitalg",null,null,null,false],[0,0,0,"avx512bw",null,null,null,false],[0,0,0,"avx512cd",null,null,null,false],[0,0,0,"avx512dq",null,null,null,false],[0,0,0,"avx512er",null,null,null,false],[0,0,0,"avx512f",null,null,null,false],[0,0,0,"avx512fp16",null,null,null,false],[0,0,0,"avx512ifma",null,null,null,false],[0,0,0,"avx512pf",null,null,null,false],[0,0,0,"avx512vbmi",null,null,null,false],[0,0,0,"avx512vbmi2",null,null,null,false],[0,0,0,"avx512vl",null,null,null,false],[0,0,0,"avx512vnni",null,null,null,false],[0,0,0,"avx512vp2intersect",null,null,null,false],[0,0,0,"avx512vpopcntdq",null,null,null,false],[0,0,0,"avxifma",null,null,null,false],[0,0,0,"avxneconvert",null,null,null,false],[0,0,0,"avxvnni",null,null,null,false],[0,0,0,"avxvnniint8",null,null,null,false],[0,0,0,"bmi",null,null,null,false],[0,0,0,"bmi2",null,null,null,false],[0,0,0,"branchfusion",null,null,null,false],[0,0,0,"cldemote",null,null,null,false],[0,0,0,"clflushopt",null,null,null,false],[0,0,0,"clwb",null,null,null,false],[0,0,0,"clzero",null,null,null,false],[0,0,0,"cmov",null,null,null,false],[0,0,0,"cmpccxadd",null,null,null,false],[0,0,0,"crc32",null,null,null,false],[0,0,0,"cx16",null,null,null,false],[0,0,0,"cx8",null,null,null,false],[0,0,0,"enqcmd",null,null,null,false],[0,0,0,"ermsb",null,null,null,false],[0,0,0,"f16c",null,null,null,false],[0,0,0,"false_deps_getmant",null,null,null,false],[0,0,0,"false_deps_lzcnt_tzcnt",null,null,null,false],[0,0,0,"false_deps_mulc",null,null,null,false],[0,0,0,"false_deps_mullq",null,null,null,false],[0,0,0,"false_deps_perm",null,null,null,false],[0,0,0,"false_deps_popcnt",null,null,null,false],[0,0,0,"false_deps_range",null,null,null,false],[0,0,0,"fast_11bytenop",null,null,null,false],[0,0,0,"fast_15bytenop",null,null,null,false],[0,0,0,"fast_7bytenop",null,null,null,false],[0,0,0,"fast_bextr",null,null,null,false],[0,0,0,"fast_gather",null,null,null,false],[0,0,0,"fast_hops",null,null,null,false],[0,0,0,"fast_lzcnt",null,null,null,false],[0,0,0,"fast_movbe",null,null,null,false],[0,0,0,"fast_scalar_fsqrt",null,null,null,false],[0,0,0,"fast_scalar_shift_masks",null,null,null,false],[0,0,0,"fast_shld_rotate",null,null,null,false],[0,0,0,"fast_variable_crosslane_shuffle",null,null,null,false],[0,0,0,"fast_variable_perlane_shuffle",null,null,null,false],[0,0,0,"fast_vector_fsqrt",null,null,null,false],[0,0,0,"fast_vector_shift_masks",null,null,null,false],[0,0,0,"fma",null,null,null,false],[0,0,0,"fma4",null,null,null,false],[0,0,0,"fsgsbase",null,null,null,false],[0,0,0,"fsrm",null,null,null,false],[0,0,0,"fxsr",null,null,null,false],[0,0,0,"gfni",null,null,null,false],[0,0,0,"harden_sls_ijmp",null,null,null,false],[0,0,0,"harden_sls_ret",null,null,null,false],[0,0,0,"hreset",null,null,null,false],[0,0,0,"idivl_to_divb",null,null,null,false],[0,0,0,"idivq_to_divl",null,null,null,false],[0,0,0,"invpcid",null,null,null,false],[0,0,0,"kl",null,null,null,false],[0,0,0,"lea_sp",null,null,null,false],[0,0,0,"lea_uses_ag",null,null,null,false],[0,0,0,"lvi_cfi",null,null,null,false],[0,0,0,"lvi_load_hardening",null,null,null,false],[0,0,0,"lwp",null,null,null,false],[0,0,0,"lzcnt",null,null,null,false],[0,0,0,"macrofusion",null,null,null,false],[0,0,0,"mmx",null,null,null,false],[0,0,0,"movbe",null,null,null,false],[0,0,0,"movdir64b",null,null,null,false],[0,0,0,"movdiri",null,null,null,false],[0,0,0,"mwaitx",null,null,null,false],[0,0,0,"nopl",null,null,null,false],[0,0,0,"pad_short_functions",null,null,null,false],[0,0,0,"pclmul",null,null,null,false],[0,0,0,"pconfig",null,null,null,false],[0,0,0,"pku",null,null,null,false],[0,0,0,"popcnt",null,null,null,false],[0,0,0,"prefer_128_bit",null,null,null,false],[0,0,0,"prefer_256_bit",null,null,null,false],[0,0,0,"prefer_mask_registers",null,null,null,false],[0,0,0,"prefetchi",null,null,null,false],[0,0,0,"prefetchwt1",null,null,null,false],[0,0,0,"prfchw",null,null,null,false],[0,0,0,"ptwrite",null,null,null,false],[0,0,0,"raoint",null,null,null,false],[0,0,0,"rdpid",null,null,null,false],[0,0,0,"rdpru",null,null,null,false],[0,0,0,"rdrnd",null,null,null,false],[0,0,0,"rdseed",null,null,null,false],[0,0,0,"retpoline",null,null,null,false],[0,0,0,"retpoline_external_thunk",null,null,null,false],[0,0,0,"retpoline_indirect_branches",null,null,null,false],[0,0,0,"retpoline_indirect_calls",null,null,null,false],[0,0,0,"rtm",null,null,null,false],[0,0,0,"sahf",null,null,null,false],[0,0,0,"sbb_dep_breaking",null,null,null,false],[0,0,0,"serialize",null,null,null,false],[0,0,0,"seses",null,null,null,false],[0,0,0,"sgx",null,null,null,false],[0,0,0,"sha",null,null,null,false],[0,0,0,"shstk",null,null,null,false],[0,0,0,"slow_3ops_lea",null,null,null,false],[0,0,0,"slow_incdec",null,null,null,false],[0,0,0,"slow_lea",null,null,null,false],[0,0,0,"slow_pmaddwd",null,null,null,false],[0,0,0,"slow_pmulld",null,null,null,false],[0,0,0,"slow_shld",null,null,null,false],[0,0,0,"slow_two_mem_ops",null,null,null,false],[0,0,0,"slow_unaligned_mem_16",null,null,null,false],[0,0,0,"slow_unaligned_mem_32",null,null,null,false],[0,0,0,"soft_float",null,null,null,false],[0,0,0,"sse",null,null,null,false],[0,0,0,"sse2",null,null,null,false],[0,0,0,"sse3",null,null,null,false],[0,0,0,"sse4_1",null,null,null,false],[0,0,0,"sse4_2",null,null,null,false],[0,0,0,"sse4a",null,null,null,false],[0,0,0,"sse_unaligned_mem",null,null,null,false],[0,0,0,"ssse3",null,null,null,false],[0,0,0,"tagged_globals",null,null,null,false],[0,0,0,"tbm",null,null,null,false],[0,0,0,"tsxldtrk",null,null,null,false],[0,0,0,"uintr",null,null,null,false],[0,0,0,"use_glm_div_sqrt_costs",null,null,null,false],[0,0,0,"use_slm_arith_costs",null,null,null,false],[0,0,0,"vaes",null,null,null,false],[0,0,0,"vpclmulqdq",null,null,null,false],[0,0,0,"vzeroupper",null,null,null,false],[0,0,0,"waitpkg",null,null,null,false],[0,0,0,"wbnoinvd",null,null,null,false],[0,0,0,"widekl",null,null,null,false],[0,0,0,"x87",null,null,null,false],[0,0,0,"xop",null,null,null,false],[0,0,0,"xsave",null,null,null,false],[0,0,0,"xsavec",null,null,null,false],[0,0,0,"xsaveopt",null,null,null,false],[0,0,0,"xsaves",null,null,null,false],[61,171,0,null,null,null,null,false],[61,172,0,null,null,null,null,false],[61,173,0,null,null,null,null,false],[61,174,0,null,null,null,null,false],[61,176,0,null,null,null,null,false],[61,1110,0,null,null,null,[],false],[61,1111,0,null,null,null,null,false],[61,1175,0,null,null,null,null,false],[61,1197,0,null,null,null,null,false],[61,1211,0,null,null,null,null,false],[61,1230,0,null,null,null,null,false],[61,1249,0,null,null,null,null,false],[61,1265,0,null,null,null,null,false],[61,1284,0,null,null,null,null,false],[61,1300,0,null,null,null,null,false],[61,1314,0,null,null,null,null,false],[61,1330,0,null,null,null,null,false],[61,1354,0,null,null,null,null,false],[61,1376,0,null,null,null,null,false],[61,1405,0,null,null,null,null,false],[61,1440,0,null,null,null,null,false],[61,1476,0,null,null,null,null,false],[61,1517,0,null,null,null,null,false],[61,1541,0,null,null,null,null,false],[61,1585,0,null,null,null,null,false],[61,1610,0,null,null,null,null,false],[61,1644,0,null,null,null,null,false],[61,1654,0,null,null,null,null,false],[61,1668,0,null,null,null,null,false],[61,1721,0,null,null,null,null,false],[61,1775,0,null,null,null,null,false],[61,1829,0,null,null,null,null,false],[61,1847,0,null,null,null,null,false],[61,1888,0,null,null,null,null,false],[61,1918,0,null,null,null,null,false],[61,1937,0,null,null,null,null,false],[61,1965,0,null,null,null,null,false],[61,2045,0,null,null,null,null,false],[61,2060,0,null,null,null,null,false],[61,2071,0,null,null,null,null,false],[61,2107,0,null,null,null,null,false],[61,2144,0,null,null,null,null,false],[61,2205,0,null,null,null,null,false],[61,2287,0,null,null,null,null,false],[61,2328,0,null,null,null,null,false],[61,2337,0,null,null,null,null,false],[61,2346,0,null,null,null,null,false],[61,2356,0,null,null,null,null,false],[61,2367,0,null,null,null,null,false],[61,2426,0,null,null,null,null,false],[61,2488,0,null,null,null,null,false],[61,2518,0,null,null,null,null,false],[61,2529,0,null,null,null,null,false],[61,2540,0,null,null,null,null,false],[61,2551,0,null,null,null,null,false],[61,2570,0,null,null,null,null,false],[61,2589,0,null,null,null,null,false],[61,2629,0,null,null,null,null,false],[61,2670,0,null,null,null,null,false],[61,2680,0,null,null,null,null,false],[61,2744,0,null,null,null,null,false],[61,2763,0,null,null,null,null,false],[61,2779,0,null,null,null,null,false],[61,2798,0,null,null,null,null,false],[61,2817,0,null,null,null,null,false],[61,2835,0,null,null,null,null,false],[61,2845,0,null,null,null,null,false],[61,2859,0,null,null,null,null,false],[61,2874,0,null,null,null,null,false],[61,2889,0,null,null,null,null,false],[61,2904,0,null,null,null,null,false],[61,2919,0,null,null,null,null,false],[61,2934,0,null,null,null,null,false],[61,2945,0,null,null,null,null,false],[61,2957,0,null,null,null,null,false],[61,2972,0,null,null,null,null,false],[61,3036,0,null,null,null,null,false],[61,3095,0,null,null,null,null,false],[61,3123,0,null,null,null,null,false],[61,3203,0,null,null,null,null,false],[61,3263,0,null,null,null,null,false],[61,3294,0,null,null,null,null,false],[61,3347,0,null,null,null,null,false],[61,3396,0,null,null,null,null,false],[61,3449,0,null,null,null,null,false],[61,3480,0,null,null,null,null,false],[61,3544,0,null,null,null,null,false],[61,3583,0,null,null,null,null,false],[61,3603,0,null,null,null,null,false],[61,3613,0,null,null,null,null,false],[61,3623,0,null,null,null,null,false],[61,3642,0,null,null,null,null,false],[61,3668,0,null,null,null,null,false],[61,3704,0,null,null,null,null,false],[61,3743,0,null,null,null,null,false],[61,3758,0,null,null,null,null,false],[61,3809,0,null,null,null,null,false],[61,3864,0,null,null,null,null,false],[61,3923,0,null,null,null,null,false],[40,471,0,null,null,null,null,false],[0,0,0,"target/xtensa.zig",null," This file is auto-generated by tools/update_cpu_features.zig.\n",[],false],[62,2,0,null,null,null,null,false],[62,3,0,null,null,null,null,false],[62,4,0,null,null,null,null,false],[62,6,0,null,null,null,[8371],false],[0,0,0,"density",null,null,null,false],[62,10,0,null,null,null,null,false],[62,11,0,null,null,null,null,false],[62,12,0,null,null,null,null,false],[62,13,0,null,null,null,null,false],[62,15,0,null,null,null,null,false],[62,32,0,null,null,null,[],false],[62,33,0,null,null,null,null,false],[40,473,0,null,null,null,[8389,8390,8391,8392,8393,8394,8395,8396,8397,8398,8399,8400,8401,8402,8403,8404,8405,8406,8407,8408,8409,8410,8411,8412,8413,8414,8415,8416,8417,8418,8419,8420,8421,8422,8423,8424,8425,8426,8427,8428],false],[40,515,0,null,null,null,[8381,8382],false],[0,0,0,"arch",null,"",null,false],[0,0,0,"target_os",null,"",null,false],[40,571,0,null,null,null,[8384],false],[0,0,0,"abi",null,"",null,false],[40,578,0,null,null,null,[8386],false],[0,0,0,"abi",null,"",null,false],[40,585,0,null,null,null,[8388],false],[0,0,0,"abi",null,"",null,false],[0,0,0,"none",null,null,null,false],[0,0,0,"gnu",null,null,null,false],[0,0,0,"gnuabin32",null,null,null,false],[0,0,0,"gnuabi64",null,null,null,false],[0,0,0,"gnueabi",null,null,null,false],[0,0,0,"gnueabihf",null,null,null,false],[0,0,0,"gnuf32",null,null,null,false],[0,0,0,"gnuf64",null,null,null,false],[0,0,0,"gnusf",null,null,null,false],[0,0,0,"gnux32",null,null,null,false],[0,0,0,"gnuilp32",null,null,null,false],[0,0,0,"code16",null,null,null,false],[0,0,0,"eabi",null,null,null,false],[0,0,0,"eabihf",null,null,null,false],[0,0,0,"android",null,null,null,false],[0,0,0,"musl",null,null,null,false],[0,0,0,"musleabi",null,null,null,false],[0,0,0,"musleabihf",null,null,null,false],[0,0,0,"muslx32",null,null,null,false],[0,0,0,"msvc",null,null,null,false],[0,0,0,"itanium",null,null,null,false],[0,0,0,"cygnus",null,null,null,false],[0,0,0,"coreclr",null,null,null,false],[0,0,0,"simulator",null,null,null,false],[0,0,0,"macabi",null,null,null,false],[0,0,0,"pixel",null,null,null,false],[0,0,0,"vertex",null,null,null,false],[0,0,0,"geometry",null,null,null,false],[0,0,0,"hull",null,null,null,false],[0,0,0,"domain",null,null,null,false],[0,0,0,"compute",null,null,null,false],[0,0,0,"library",null,null,null,false],[0,0,0,"raygeneration",null,null,null,false],[0,0,0,"intersection",null,null,null,false],[0,0,0,"anyhit",null,null,null,false],[0,0,0,"closesthit",null,null,null,false],[0,0,0,"miss",null,null,null,false],[0,0,0,"callable",null,null,null,false],[0,0,0,"mesh",null,null,null,false],[0,0,0,"amplification",null,null,null,false],[40,596,0,null,null,null,[8436,8437,8438,8439,8440,8441,8442,8443,8444,8445,8446],false],[40,620,0,null,null,null,[8431,8432],false],[0,0,0,"of",null,"",null,false],[0,0,0,"cpu_arch",null,"",null,false],[40,634,0,null,null,null,[8434,8435],false],[0,0,0,"os_tag",null,"",null,false],[0,0,0,"cpu_arch",null,"",null,false],[0,0,0,"coff",null," Common Object File Format (Windows)",null,false],[0,0,0,"dxcontainer",null," DirectX Container",null,false],[0,0,0,"elf",null," Executable and Linking Format",null,false],[0,0,0,"macho",null," macOS relocatables",null,false],[0,0,0,"spirv",null," Standard, Portable Intermediate Representation V",null,false],[0,0,0,"wasm",null," WebAssembly",null,false],[0,0,0,"c",null," C source code",null,false],[0,0,0,"hex",null," Intel IHEX",null,false],[0,0,0,"raw",null," Machine code with no metadata.",null,false],[0,0,0,"plan9",null," Plan 9 from Bell Labs",null,false],[0,0,0,"nvptx",null," Nvidia PTX format",null,false],[40,649,0,null,null,null,[8448,8449,8450,8451,8452,8453,8454,8455],false],[0,0,0,"Console",null,null,null,false],[0,0,0,"Windows",null,null,null,false],[0,0,0,"Posix",null,null,null,false],[0,0,0,"Native",null,null,null,false],[0,0,0,"EfiApplication",null,null,null,false],[0,0,0,"EfiBootServiceDriver",null,null,null,false],[0,0,0,"EfiRom",null,null,null,false],[0,0,0,"EfiRuntimeDriver",null,null,null,false],[40,660,0,null,null,null,[8645,8647,8649],false],[40,671,0,null,null,null,[8509,8511,8513,8515,8517],false],[40,691,0,null,null," A bit set of all the features.",[8494],false],[40,694,0,null,null,null,null,false],[40,695,0,null,null,null,null,false],[40,696,0,null,null,null,null,false],[40,697,0,null,null,null,null,false],[40,698,0,null,null,null,null,false],[40,700,0,null,null,null,null,false],[40,702,0,null,null,null,[8466],false],[0,0,0,"set",null,"",null,false],[40,708,0,null,null,null,[8468,8469],false],[0,0,0,"set",null,"",null,false],[0,0,0,"arch_feature_index",null,"",null,false],[40,715,0,null,null," Adds the specified feature but not its dependencies.",[8471,8472],false],[0,0,0,"set",null,"",null,false],[0,0,0,"arch_feature_index",null,"",null,false],[40,722,0,null,null," Adds the specified feature set but not its dependencies.",[8474,8475],false],[0,0,0,"set",null,"",null,false],[0,0,0,"other_set",null,"",null,false],[40,727,0,null,null," Removes the specified feature but not its dependents.",[8477,8478],false],[0,0,0,"set",null,"",null,false],[0,0,0,"arch_feature_index",null,"",null,false],[40,734,0,null,null," Removes the specified feature but not its dependents.",[8480,8481],false],[0,0,0,"set",null,"",null,false],[0,0,0,"other_set",null,"",null,false],[40,738,0,null,null,null,[8483,8484],false],[0,0,0,"set",null,"",null,false],[0,0,0,"all_features_list",null,"",null,false],[40,755,0,null,null,null,[8486],false],[0,0,0,"set",null,"",null,false],[40,759,0,null,null,null,[8488,8489],false],[0,0,0,"set",null,"",null,false],[0,0,0,"other_set",null,"",null,false],[40,763,0,null,null,null,[8491,8492],false],[0,0,0,"set",null,"",null,false],[0,0,0,"other_set",null,"",null,false],[40,691,0,null,null,null,null,false],[0,0,0,"ints",null,null,null,false],[40,771,0,null,null,null,[8496],false],[0,0,0,"F",null,"",[],true],[40,774,0,null,null," Populates only the feature bits specified.",[8498],false],[0,0,0,"features",null,"",null,false],[40,783,0,null,null," Returns true if the specified feature is enabled.",[8500,8501],false],[0,0,0,"set",null,"",null,false],[0,0,0,"feature",null,"",null,false],[40,788,0,null,null," Returns true if any specified feature is enabled.",[8503,8504],false],[0,0,0,"set",null,"",null,false],[0,0,0,"features",null,"",null,false],[40,797,0,null,null," Returns true if every specified feature is enabled.",[8506,8507],false],[0,0,0,"set",null,"",null,false],[0,0,0,"features",null,"",null,false],[40,671,0,null,null,null,null,false],[0,0,0,"index",null," The bit index into `Set`. Has a default value of `undefined` because the canonical\n structures are populated via comptime logic.",null,false],[40,671,0,null,null,null,null,false],[0,0,0,"name",null," Has a default value of `undefined` because the canonical\n structures are populated via comptime logic.",null,false],[40,671,0,null,null,null,null,false],[0,0,0,"llvm_name",null," If this corresponds to an LLVM-recognized feature, this will be populated;\n otherwise null.",null,false],[40,671,0,null,null,null,null,false],[0,0,0,"description",null," Human-friendly UTF-8 text.",null,false],[40,671,0,null,null,null,null,false],[0,0,0,"dependencies",null," Sparse `Set` of features this depends on.",null,false],[40,808,0,null,null,null,[8567,8568,8569,8570,8571,8572,8573,8574,8575,8576,8577,8578,8579,8580,8581,8582,8583,8584,8585,8586,8587,8588,8589,8590,8591,8592,8593,8594,8595,8596,8597,8598,8599,8600,8601,8602,8603,8604,8605,8606,8607,8608,8609,8610,8611,8612,8613,8614,8615,8616,8617,8618,8619,8620,8621,8622,8623,8624,8625,8626,8627],false],[40,873,0,null,null,null,[8520],false],[0,0,0,"arch",null,"",null,false],[40,880,0,null,null,null,[8522],false],[0,0,0,"arch",null,"",null,false],[40,887,0,null,null,null,[8524],false],[0,0,0,"arch",null,"",null,false],[40,894,0,null,null,null,[8526],false],[0,0,0,"arch",null,"",null,false],[40,901,0,null,null,null,[8528],false],[0,0,0,"arch",null,"",null,false],[40,905,0,null,null,null,[8530],false],[0,0,0,"arch",null,"",null,false],[40,912,0,null,null,null,[8532],false],[0,0,0,"arch",null,"",null,false],[40,919,0,null,null,null,[8534],false],[0,0,0,"arch",null,"",null,false],[40,926,0,null,null,null,[8536],false],[0,0,0,"arch",null,"",null,false],[40,933,0,null,null,null,[8538],false],[0,0,0,"arch",null,"",null,false],[40,940,0,null,null,null,[8540],false],[0,0,0,"arch",null,"",null,false],[40,947,0,null,null,null,[8542],false],[0,0,0,"arch",null,"",null,false],[40,954,0,null,null,null,[8544],false],[0,0,0,"arch",null,"",null,false],[40,961,0,null,null,null,[8546],false],[0,0,0,"arch",null,"",null,false],[40,968,0,null,null,null,[8548,8549],false],[0,0,0,"arch",null,"",null,false],[0,0,0,"cpu_name",null,"",null,false],[40,977,0,null,null,null,[8551],false],[0,0,0,"arch",null,"",null,false],[40,1042,0,null,null,null,[8553],false],[0,0,0,"arch",null,"",null,false],[40,1107,0,null,null,null,[8555],false],[0,0,0,"arch",null,"",null,false],[40,1178,0,null,null," Returns whether this architecture supports the address space",[8557,8558],false],[0,0,0,"arch",null,"",null,false],[0,0,0,"address_space",null,"",null,false],[40,1193,0,null,null," Returns a name that matches the lib/std/target/* source file name.",[8560],false],[0,0,0,"arch",null,"",null,false],[40,1214,0,null,null," All CPU features Zig is aware of, sorted lexicographically by name.",[8562],false],[0,0,0,"arch",null,"",null,false],[40,1244,0,null,null," All processors Zig is aware of, sorted lexicographically by name.",[8564],false],[0,0,0,"arch",null,"",null,false],[40,1273,0,null,null,null,[8566],false],[0,0,0,"cpus",null,"",null,true],[0,0,0,"arm",null,null,null,false],[0,0,0,"armeb",null,null,null,false],[0,0,0,"aarch64",null,null,null,false],[0,0,0,"aarch64_be",null,null,null,false],[0,0,0,"aarch64_32",null,null,null,false],[0,0,0,"arc",null,null,null,false],[0,0,0,"avr",null,null,null,false],[0,0,0,"bpfel",null,null,null,false],[0,0,0,"bpfeb",null,null,null,false],[0,0,0,"csky",null,null,null,false],[0,0,0,"dxil",null,null,null,false],[0,0,0,"hexagon",null,null,null,false],[0,0,0,"loongarch32",null,null,null,false],[0,0,0,"loongarch64",null,null,null,false],[0,0,0,"m68k",null,null,null,false],[0,0,0,"mips",null,null,null,false],[0,0,0,"mipsel",null,null,null,false],[0,0,0,"mips64",null,null,null,false],[0,0,0,"mips64el",null,null,null,false],[0,0,0,"msp430",null,null,null,false],[0,0,0,"powerpc",null,null,null,false],[0,0,0,"powerpcle",null,null,null,false],[0,0,0,"powerpc64",null,null,null,false],[0,0,0,"powerpc64le",null,null,null,false],[0,0,0,"r600",null,null,null,false],[0,0,0,"amdgcn",null,null,null,false],[0,0,0,"riscv32",null,null,null,false],[0,0,0,"riscv64",null,null,null,false],[0,0,0,"sparc",null,null,null,false],[0,0,0,"sparc64",null,null,null,false],[0,0,0,"sparcel",null,null,null,false],[0,0,0,"s390x",null,null,null,false],[0,0,0,"tce",null,null,null,false],[0,0,0,"tcele",null,null,null,false],[0,0,0,"thumb",null,null,null,false],[0,0,0,"thumbeb",null,null,null,false],[0,0,0,"x86",null,null,null,false],[0,0,0,"x86_64",null,null,null,false],[0,0,0,"xcore",null,null,null,false],[0,0,0,"xtensa",null,null,null,false],[0,0,0,"nvptx",null,null,null,false],[0,0,0,"nvptx64",null,null,null,false],[0,0,0,"le32",null,null,null,false],[0,0,0,"le64",null,null,null,false],[0,0,0,"amdil",null,null,null,false],[0,0,0,"amdil64",null,null,null,false],[0,0,0,"hsail",null,null,null,false],[0,0,0,"hsail64",null,null,null,false],[0,0,0,"spir",null,null,null,false],[0,0,0,"spir64",null,null,null,false],[0,0,0,"spirv32",null,null,null,false],[0,0,0,"spirv64",null,null,null,false],[0,0,0,"kalimba",null,null,null,false],[0,0,0,"shave",null,null,null,false],[0,0,0,"lanai",null,null,null,false],[0,0,0,"wasm32",null,null,null,false],[0,0,0,"wasm64",null,null,null,false],[0,0,0,"renderscript32",null,null,null,false],[0,0,0,"renderscript64",null,null,null,false],[0,0,0,"ve",null,null,null,false],[0,0,0,"spu_2",null,null,null,false],[40,1283,0,null,null,null,[8637,8639,8641],false],[40,1288,0,null,null,null,[8630,8631],false],[0,0,0,"model",null,"",null,false],[0,0,0,"arch",null,"",null,false],[40,1298,0,null,null,null,[8633],false],[0,0,0,"arch",null,"",null,false],[40,1339,0,null,null,null,[8635],false],[0,0,0,"arch",null,"",null,false],[40,1283,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[40,1283,0,null,null,null,null,false],[0,0,0,"llvm_name",null,null,null,false],[40,1283,0,null,null,null,null,false],[0,0,0,"features",null,null,null,false],[40,1355,0,null,null," The \"default\" set of CPU features for cross-compiling. A conservative set\n of features that is expected to be supported on most available hardware.",[8643],false],[0,0,0,"arch",null,"",null,false],[40,660,0,null,null,null,null,false],[0,0,0,"arch",null," Architecture",null,false],[40,660,0,null,null,null,null,false],[0,0,0,"model",null," The CPU model to target. It has a set of features\n which are overridden with the `features` field.",null,false],[40,660,0,null,null,null,null,false],[0,0,0,"features",null," An explicit list of the entire CPU feature set. It may differ from the specific CPU model's features.",null,false],[40,1360,0,null,null,null,[8651,8652],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[40,1364,0,null,null,null,[8654,8655,8656,8657],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"cpu_arch",null,"",null,false],[0,0,0,"os_tag",null,"",null,false],[0,0,0,"abi",null,"",null,false],[40,1368,0,null,null,null,[8659,8660],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[40,1372,0,null,null,null,[8662,8663],false],[0,0,0,"cpu_arch",null,"",null,false],[0,0,0,"os_tag",null,"",null,false],[40,1384,0,null,null,null,[8665],false],[0,0,0,"self",null,"",null,false],[40,1388,0,null,null,null,[8667,8668],false],[0,0,0,"os_tag",null,"",null,false],[0,0,0,"abi",null,"",null,false],[40,1398,0,null,null,null,[8670],false],[0,0,0,"self",null,"",null,false],[40,1402,0,null,null,null,[8672],false],[0,0,0,"self",null,"",null,false],[40,1406,0,null,null,null,[8674,8675],false],[0,0,0,"os_tag",null,"",null,false],[0,0,0,"abi",null,"",null,false],[40,1416,0,null,null,null,[8677],false],[0,0,0,"self",null,"",null,false],[40,1420,0,null,null,null,[8679],false],[0,0,0,"self",null,"",null,false],[40,1424,0,null,null,null,[8681],false],[0,0,0,"self",null,"",null,false],[40,1428,0,null,null,null,[8683],false],[0,0,0,"self",null,"",null,false],[40,1432,0,null,null,null,[8685],false],[0,0,0,"self",null,"",null,false],[40,1436,0,null,null,null,[8687],false],[0,0,0,"self",null,"",null,false],[40,1440,0,null,null,null,[8689],false],[0,0,0,"self",null,"",null,false],[40,1444,0,null,null,null,[8691],false],[0,0,0,"self",null,"",null,false],[40,1448,0,null,null,null,[8693],false],[0,0,0,"self",null,"",null,false],[40,1452,0,null,null,null,[8695,8696],false],[0,0,0,"os_tag",null,"",null,false],[0,0,0,"abi",null,"",null,false],[40,1456,0,null,null,null,[8698],false],[0,0,0,"self",null,"",null,false],[40,1460,0,null,null,null,[8700],false],[0,0,0,"self",null,"",null,false],[40,1464,0,null,null,null,[8702],false],[0,0,0,"self",null,"",null,false],[40,1468,0,null,null,null,[8704,8705,8706],false],[0,0,0,"hard",null,null,null,false],[0,0,0,"soft",null,null,null,false],[0,0,0,"soft_fp",null,null,null,false],[40,1474,0,null,null,null,[8708],false],[0,0,0,"self",null,"",null,false],[40,1478,0,null,null,null,[8710],false],[0,0,0,"self",null,"",null,false],[40,1501,0,null,null,null,[8720,8722],false],[40,1511,0,null,null," Asserts that the length is less than or equal to 255 bytes.",[8713],false],[0,0,0,"dl_or_null",null,"",null,false],[40,1518,0,null,null," The returned memory has the same lifetime as the `DynamicLinker`.",[8715],false],[0,0,0,"self",null,"",null,false],[40,1524,0,null,null," Asserts that the length is less than or equal to 255 bytes.",[8717,8718],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dl_or_null",null,"",null,false],[40,1501,0,null,null,null,null,false],[0,0,0,"buffer",null," Contains the memory used to store the dynamic linker path. This field should\n not be used directly. See `get` and `set`. This field exists so that this API requires no allocator.",null,false],[40,1501,0,null,null,null,null,false],[0,0,0,"max_byte",null," Used to construct the dynamic linker path. This field should not be used\n directly. See `get` and `set`.",null,false],[40,1534,0,null,null,null,[8724],false],[0,0,0,"self",null,"",null,false],[40,1730,0,null,null," 0c spim    little-endian MIPS 3000 family\n 1c 68000   Motorola MC68000\n 2c 68020   Motorola MC68020\n 5c arm     little-endian ARM\n 6c amd64   AMD64 and compatibles (e.g., Intel EM64T)\n 7c arm64   ARM64 (ARMv8)\n 8c 386     Intel x86, i486, Pentium, etc.\n kc sparc   Sun SPARC\n qc power   Power PC\n vc mips    big-endian MIPS 3000 family",[8726],false],[0,0,0,"cpu_arch",null,"",null,false],[40,1744,0,null,null,null,[8728],false],[0,0,0,"target",null,"",null,false],[40,1834,0,null,null,null,[8730],false],[0,0,0,"target",null,"",null,false],[40,1911,0,null,null,null,[8732],false],[0,0,0,"target",null,"",null,false],[40,1956,0,null,null," Default signedness of `char` for the native C compiler for this target\n Note that char signedness is implementation-defined and many compilers provide\n an option to override the default signedness e.g. GCC's -funsigned-char / -fsigned-char",[8734],false],[0,0,0,"target",null,"",null,false],[40,1980,0,null,null,null,[8736,8737,8738,8739,8740,8741,8742,8743,8744,8745,8746,8747],false],[0,0,0,"char",null,null,null,false],[0,0,0,"short",null,null,null,false],[0,0,0,"ushort",null,null,null,false],[0,0,0,"int",null,null,null,false],[0,0,0,"uint",null,null,null,false],[0,0,0,"long",null,null,null,false],[0,0,0,"ulong",null,null,null,false],[0,0,0,"longlong",null,null,null,false],[0,0,0,"ulonglong",null,null,null,false],[0,0,0,"float",null,null,null,false],[0,0,0,"double",null,null,null,false],[0,0,0,"longdouble",null,null,null,false],[40,1995,0,null,null,null,[8749,8750],false],[0,0,0,"t",null,"",null,false],[0,0,0,"c_type",null,"",null,false],[40,2021,0,null,null,null,[8752,8753],false],[0,0,0,"target",null,"",null,false],[0,0,0,"c_type",null,"",null,false],[40,2335,0,null,null,null,[8755,8756],false],[0,0,0,"target",null,"",null,false],[0,0,0,"c_type",null,"",null,false],[40,2442,0,null,null,null,[8758,8759],false],[0,0,0,"target",null,"",null,false],[0,0,0,"c_type",null,"",null,false],[40,5,0,null,null,null,null,false],[0,0,0,"cpu",null,null,null,false],[40,5,0,null,null,null,null,false],[0,0,0,"os",null,null,null,false],[40,5,0,null,null,null,null,false],[0,0,0,"abi",null,null,null,false],[40,5,0,null,null,null,null,false],[0,0,0,"ofmt",null,null,null,false],[0,47,0,null,null,null,null,false],[0,0,0,"Thread.zig",null," This struct represents a kernel thread, and acts as a namespace for concurrency\n primitives that operate on kernel threads. For concurrency primitives that support\n both evented I/O and async I/O, see the respective names in the top level std namespace.\n",[9508],false],[63,4,0,null,null,null,null,false],[63,5,0,null,null,null,null,false],[63,6,0,null,null,null,null,false],[63,7,0,null,null,null,null,false],[63,8,0,null,null,null,null,false],[63,9,0,null,null,null,null,false],[63,10,0,null,null,null,null,false],[63,12,0,null,null,null,null,false],[0,0,0,"Thread/Futex.zig",null," Futex is a mechanism used to block (`wait`) and unblock (`wake`) threads using a 32bit memory address as hints.\n Blocking a thread is acknowledged only if the 32bit memory address is equal to a given value.\n This check helps avoid block/unblock deadlocks which occur if a `wake()` happens before a `wait()`.\n Using Futex, other Thread synchronization primitives can be built which efficiently wait for cross-thread events or signals.\n",[],false],[64,5,0,null,null,null,null,false],[64,6,0,null,null,null,null,false],[64,7,0,null,null,null,null,false],[64,9,0,null,null,null,null,false],[64,10,0,null,null,null,null,false],[64,11,0,null,null,null,null,false],[64,12,0,null,null,null,null,false],[64,21,0,null,null," Checks if `ptr` still contains the value `expect` and, if so, blocks the caller until either:\n - The value at `ptr` is no longer equal to `expect`.\n - The caller is unblocked by a matching `wake()`.\n - The caller is unblocked spuriously (\"at random\").\n\n The checking of `ptr` and `expect`, along with blocking the caller, is done atomically\n and totally ordered (sequentially consistent) with respect to other wait()/wake() calls on the same `ptr`.",[8787,8788],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[64,37,0,null,null," Checks if `ptr` still contains the value `expect` and, if so, blocks the caller until either:\n - The value at `ptr` is no longer equal to `expect`.\n - The caller is unblocked by a matching `wake()`.\n - The caller is unblocked spuriously (\"at random\").\n - The caller blocks for longer than the given timeout. In which case, `error.Timeout` is returned.\n\n The checking of `ptr` and `expect`, along with blocking the caller, is done atomically\n and totally ordered (sequentially consistent) with respect to other wait()/wake() calls on the same `ptr`.",[8790,8791,8792],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout_ns",null,"",null,false],[64,50,0,null,null," Unblocks at most `max_waiters` callers blocked in a `wait()` call on `ptr`.",[8794,8795],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,61,0,null,null,null,null,false],[64,84,0,null,null," We can't do @compileError() in the `Impl` switch statement above as its eagerly evaluated.\n So instead, we @compileError() on the methods themselves for platforms which don't support futex.",[],false],[64,85,0,null,null,null,[8799,8800,8801],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,89,0,null,null,null,[8803,8804],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,93,0,null,null,null,[8806],false],[0,0,0,"unused",null,"",null,false],[64,99,0,null,null,null,[],false],[64,100,0,null,null,null,[8809,8810,8811],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,115,0,null,null,null,[8813,8814],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,124,0,null,null,null,[],false],[64,125,0,null,null,null,[8817,8818,8819],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,154,0,null,null,null,[8821,8822],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,165,0,null,null,null,[],false],[64,166,0,null,null,null,[8825,8826,8827],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,222,0,null,null,null,[8829,8830],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,245,0,null,null,null,[],false],[64,246,0,null,null,null,[8833,8834,8835],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,274,0,null,null,null,[8837,8838],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,291,0,null,null,null,[],false],[64,292,0,null,null,null,[8841,8842,8843],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,328,0,null,null,null,[8845,8846],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,347,0,null,null,null,[],false],[64,348,0,null,null,null,[8849,8850,8851],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,379,0,null,null,null,[8853,8854],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,394,0,null,null,null,[],false],[64,395,0,null,null,null,[8857,8858,8859],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,437,0,null,null,null,[8861,8862],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,450,0,null,null,null,[],false],[64,451,0,null,null,null,[8865,8866,8867],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,475,0,null,null,null,[8869,8870],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,496,0,null,null," Modified version of linux's futex and Go's sema to implement userspace wait queues with pthread:\n https://code.woboq.org/linux/linux/kernel/futex.c.html\n https://go.dev/src/runtime/sema.go",[],false],[64,497,0,null,null,null,[8883,8885,8890],false],[64,502,0,null,null,null,[8874],false],[0,0,0,"self",null,"",null,false],[64,509,0,null,null,null,[8876],false],[0,0,0,"self",null,"",null,false],[64,520,0,null,null,null,[8878,8879],false],[0,0,0,"self",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,575,0,null,null,null,[8881],false],[0,0,0,"self",null,"",null,false],[64,497,0,null,null,null,null,false],[0,0,0,"cond",null,null,null,false],[64,497,0,null,null,null,null,false],[0,0,0,"mutex",null,null,null,false],[64,497,0,null,null,null,[8887,8888,8889],false],[0,0,0,"empty",null,null,null,false],[0,0,0,"waiting",null,null,null,false],[0,0,0,"notified",null,null,null,false],[0,0,0,"state",null,null,null,false],[64,593,0,null,null,null,null,false],[64,594,0,null,null,null,[8894,8896,8898,8900,8901,8903],false],[64,594,0,null,null,null,null,false],[0,0,0,"node",null,null,null,false],[64,594,0,null,null,null,null,false],[0,0,0,"prev",null,null,null,false],[64,594,0,null,null,null,null,false],[0,0,0,"next",null,null,null,false],[64,594,0,null,null,null,null,false],[0,0,0,"tail",null,null,null,false],[0,0,0,"is_queued",null,null,null,false],[64,594,0,null,null,null,null,false],[0,0,0,"event",null,null,null,false],[64,604,0,null,null,null,[8911,8912],false],[64,608,0,null,null,null,[8906,8907],false],[0,0,0,"self",null,"",null,false],[0,0,0,"waiter",null,"",null,false],[64,614,0,null,null,null,[8909],false],[0,0,0,"self",null,"",null,false],[64,604,0,null,null,null,null,false],[0,0,0,"top",null,null,null,false],[0,0,0,"len",null,null,null,false],[64,622,0,null,null,null,[],false],[64,623,0,null,null,null,[8915,8916,8917],false],[0,0,0,"treap",null,"",null,false],[0,0,0,"address",null,"",null,false],[0,0,0,"waiter",null,"",null,false],[64,648,0,null,null,null,[8919,8920,8921],false],[0,0,0,"treap",null,"",null,false],[0,0,0,"address",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,677,0,null,null,null,[8923,8924,8925],false],[0,0,0,"treap",null,"",null,false],[0,0,0,"address",null,"",null,false],[0,0,0,"waiter",null,"",null,false],[64,733,0,null,null,null,[8931,8933,8935],false],[64,740,0,null,null,null,null,false],[64,743,0,null,null,null,[8929],false],[0,0,0,"address",null,"",null,false],[64,733,0,null,null,null,null,false],[0,0,0,"mutex",null,null,null,false],[64,733,0,null,null,null,null,false],[0,0,0,"pending",null,null,null,false],[64,733,0,null,null,null,null,false],[0,0,0,"treap",null,null,null,false],[64,758,0,null,null,null,[],false],[64,759,0,null,null,null,[8938],false],[0,0,0,"ptr",null,"",null,false],[64,772,0,null,null,null,[8940,8941,8942],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[64,833,0,null,null,null,[8944,8945],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"max_waiters",null,"",null,false],[64,1015,0,null,null," Deadline is used to wait efficiently for a pointer's value to change using Futex and a fixed timeout.\n\n Futex's timedWait() api uses a relative duration which suffers from over-waiting\n when used in a loop which is often required due to the possibility of spurious wakeups.\n\n Deadline instead converts the relative timeout to an absolute one so that multiple calls\n to Futex timedWait() can block for and report more accurate error.Timeouts.",[8954,8956],false],[64,1021,0,null,null," Create the deadline to expire after the given amount of time in nanoseconds passes.\n Pass in `null` to have the deadline call `Futex.wait()` and never expire.",[8948],false],[0,0,0,"expires_in_ns",null,"",null,false],[64,1038,0,null,null," Wait until either:\n - the `ptr`'s value changes from `expect`.\n - `Futex.wake()` is called on the `ptr`.\n - A spurious wake occurs.\n - The deadline expires; In which case `error.Timeout` is returned.",[8950,8951,8952],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"expect",null,"",null,false],[64,1015,0,null,null,null,null,false],[0,0,0,"timeout",null,null,null,false],[64,1015,0,null,null,null,null,false],[0,0,0,"started",null,null,null,false],[63,13,0,null,null,null,null,false],[0,0,0,"Thread/ResetEvent.zig",null," ResetEvent is a thread-safe bool which can be set to true/false (\"set\"/\"unset\").\n It can also block threads until the \"bool\" is set with cancellation via timed waits.\n ResetEvent can be statically initialized and is at most `@sizeOf(u64)` large.\n",[9009],false],[65,4,0,null,null,null,null,false],[65,5,0,null,null,null,null,false],[65,6,0,null,null,null,null,false],[65,8,0,null,null,null,null,false],[65,9,0,null,null,null,null,false],[65,10,0,null,null,null,null,false],[65,11,0,null,null,null,null,false],[65,12,0,null,null,null,null,false],[65,19,0,null,null," Returns if the ResetEvent was set().\n Once reset() is called, this returns false until the next set().\n The memory accesses before the set() can be said to happen before isSet() returns true.",[8968],false],[0,0,0,"self",null,"",null,false],[65,26,0,null,null," Block's the callers thread until the ResetEvent is set().\n This is effectively a more efficient version of `while (!isSet()) {}`.\n The memory accesses before the set() can be said to happen before wait() returns.",[8970],false],[0,0,0,"self",null,"",null,false],[65,36,0,null,null," Block's the callers thread until the ResetEvent is set(), or until the corresponding timeout expires.\n If the timeout expires before the ResetEvent is set, `error.Timeout` is returned.\n This is effectively a more efficient version of `while (!isSet()) {}`.\n The memory accesses before the set() can be said to happen before timedWait() returns without error.",[8972,8973],false],[0,0,0,"self",null,"",null,false],[0,0,0,"timeout_ns",null,"",null,false],[65,43,0,null,null," Marks the ResetEvent as \"set\" and unblocks any threads in `wait()` or `timedWait()` to observe the new state.\n The ResetEvent says \"set\" until reset() is called, making future set() calls do nothing semantically.\n The memory accesses before set() can be said to happen before isSet() returns true or wait()/timedWait() return successfully.",[8975],false],[0,0,0,"self",null,"",null,false],[65,50,0,null,null," Unmarks the ResetEvent from its \"set\" state if set() was called previously.\n It is undefined behavior is reset() is called while threads are blocked in wait() or timedWait().\n Concurrent calls to set(), isSet() and reset() are allowed.",[8977],false],[0,0,0,"self",null,"",null,false],[65,54,0,null,null,null,null,false],[65,59,0,null,null,null,[8989],false],[65,62,0,null,null,null,[8981],false],[0,0,0,"self",null,"",null,false],[65,66,0,null,null,null,[8983,8984],false],[0,0,0,"self",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[65,81,0,null,null,null,[8986],false],[0,0,0,"self",null,"",null,false],[65,85,0,null,null,null,[8988],false],[0,0,0,"self",null,"",null,false],[0,0,0,"is_set",null,null,null,false],[65,90,0,null,null,null,[9007],false],[65,93,0,null,null,null,null,false],[65,94,0,null,null,null,null,false],[65,95,0,null,null,null,null,false],[65,97,0,null,null,null,[8995],false],[0,0,0,"self",null,"",null,false],[65,102,0,null,null,null,[8997,8998],false],[0,0,0,"self",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[65,109,0,null,null,null,[9000,9001],false],[0,0,0,"self",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[65,141,0,null,null,null,[9003],false],[0,0,0,"self",null,"",null,false],[65,155,0,null,null,null,[9005],false],[0,0,0,"self",null,"",null,false],[65,90,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[65,0,0,null,null,null,null,false],[0,0,0,"impl",null,null,null,false],[63,14,0,null,null,null,null,false],[0,0,0,"Thread/Mutex.zig",null," Mutex is a synchronization primitive which enforces atomic access to a shared region of code known as the \"critical section\".\n It does this by blocking ensuring only one thread is in the critical section at any given point in time by blocking the others.\n Mutex can be statically initialized and is at most `@sizeOf(u64)` large.\n Use `lock()` or `tryLock()` to enter the critical section and `unlock()` to leave it.\n\n Example:\n ```\n var m = Mutex{};\n\n {\n     m.lock();\n     defer m.unlock();\n     // ... critical section code\n }\n\n if (m.tryLock()) {\n     defer m.unlock();\n     // ... critical section code\n }\n ```\n",[9091],false],[66,21,0,null,null,null,null,false],[66,22,0,null,null,null,null,false],[66,23,0,null,null,null,null,false],[66,25,0,null,null,null,null,false],[66,26,0,null,null,null,null,false],[66,27,0,null,null,null,null,false],[66,28,0,null,null,null,null,false],[66,29,0,null,null,null,null,false],[66,30,0,null,null,null,null,false],[66,37,0,null,null," Tries to acquire the mutex without blocking the caller's thread.\n Returns `false` if the calling thread would have to block to acquire it.\n Otherwise, returns `true` and the caller should `unlock()` the Mutex to release it.",[9022],false],[0,0,0,"self",null,"",null,false],[66,44,0,null,null," Acquires the mutex, blocking the caller's thread until it can.\n It is undefined behavior if the mutex is already held by the caller's thread.\n Once acquired, call `unlock()` on the Mutex to release it.",[9024],false],[0,0,0,"self",null,"",null,false],[66,50,0,null,null," Releases the mutex which was previously acquired with `lock()` or `tryLock()`.\n It is undefined behavior if the mutex is unlocked from a different thread that it was locked from.",[9026],false],[0,0,0,"self",null,"",null,false],[66,54,0,null,null,null,null,false],[66,59,0,null,null,null,null,false],[66,68,0,null,null,null,[9037,9039],false],[66,72,0,null,null,null,[9031],false],[0,0,0,"self",null,"",null,false],[66,80,0,null,null,null,[9033],false],[0,0,0,"self",null,"",null,false],[66,89,0,null,null,null,[9035],false],[0,0,0,"self",null,"",null,false],[66,68,0,null,null,null,null,false],[0,0,0,"locking_thread",null,null,null,false],[66,68,0,null,null,null,null,false],[0,0,0,"impl",null,null,null,false],[66,96,0,null,null,null,[9047],false],[66,99,0,null,null,null,[9042],false],[0,0,0,"self",null,"",null,false],[66,105,0,null,null,null,[9044],false],[0,0,0,"self",null,"",null,false],[66,111,0,null,null,null,[9046],false],[0,0,0,"self",null,"",null,false],[0,0,0,"is_locked",null,null,null,false],[66,119,0,null,null,null,[9056],false],[66,122,0,null,null,null,[9050],false],[0,0,0,"self",null,"",null,false],[66,126,0,null,null,null,[9052],false],[0,0,0,"self",null,"",null,false],[66,130,0,null,null,null,[9054],false],[0,0,0,"self",null,"",null,false],[66,119,0,null,null,null,null,false],[0,0,0,"srwlock",null,null,null,false],[66,136,0,null,null,null,[9065],false],[66,139,0,null,null,null,[9059],false],[0,0,0,"self",null,"",null,false],[66,143,0,null,null,null,[9061],false],[0,0,0,"self",null,"",null,false],[66,147,0,null,null,null,[9063],false],[0,0,0,"self",null,"",null,false],[66,136,0,null,null,null,null,false],[0,0,0,"oul",null,null,null,false],[66,152,0,null,null,null,[9082],false],[66,155,0,null,null,null,null,false],[66,156,0,null,null,null,null,false],[66,157,0,null,null,null,null,false],[66,159,0,null,null,null,[9071],false],[0,0,0,"self",null,"",null,false],[66,164,0,null,null,null,[9073],false],[0,0,0,"self",null,"",null,false],[66,171,0,null,null,null,[9075,9076],false],[0,0,0,"self",null,"",null,false],[0,0,0,"cas_fn_name",null,"",null,true],[66,186,0,null,null,null,[9078],false],[0,0,0,"self",null,"",null,false],[66,209,0,null,null,null,[9080],false],[0,0,0,"self",null,"",null,false],[66,152,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[66,239,0,null,null,null,[9089],false],[66,243,0,null,null,null,[9085],false],[0,0,0,"self",null,"",null,false],[66,247,0,null,null,null,[9087],false],[0,0,0,"self",null,"",null,false],[66,239,0,null,null,null,null,false],[0,0,0,"value",null,null,null,false],[66,0,0,null,null,null,null,false],[0,0,0,"impl",null,null,null,false],[63,15,0,null,null,null,null,false],[0,0,0,"Thread/Semaphore.zig",null," A semaphore is an unsigned integer that blocks the kernel thread if\n the number would become negative.\n This API supports static initialization and does not require deinitialization.\n",[9105,9107,9108],false],[67,9,0,null,null,null,null,false],[67,10,0,null,null,null,null,false],[67,11,0,null,null,null,null,false],[67,12,0,null,null,null,null,false],[67,13,0,null,null,null,null,false],[67,14,0,null,null,null,null,false],[67,16,0,null,null,null,[9101],false],[0,0,0,"sem",null,"",null,false],[67,28,0,null,null,null,[9103],false],[0,0,0,"sem",null,"",null,false],[67,0,0,null,null,null,null,false],[0,0,0,"mutex",null,null,null,false],[67,0,0,null,null,null,null,false],[0,0,0,"cond",null,null,null,false],[0,0,0,"permits",null," It is OK to initialize this field to any value.",null,false],[63,16,0,null,null,null,null,false],[0,0,0,"Thread/Condition.zig",null," Condition variables are used with a Mutex to efficiently wait for an arbitrary condition to occur.\n It does this by atomically unlocking the mutex, blocking the thread until notified, and finally re-locking the mutex.\n Condition can be statically initialized and is at most `@sizeOf(u64)` large.\n\n Example:\n ```\n var m = Mutex{};\n var c = Condition{};\n var predicate = false;\n\n fn consumer() void {\n     m.lock();\n     defer m.unlock();\n\n     while (!predicate) {\n         c.wait(&m);\n     }\n }\n\n fn producer() void {\n     {\n         m.lock();\n         defer m.unlock();\n         predicate = true;\n     }\n     c.signal();\n }\n\n const thread = try std.Thread.spawn(.{}, producer, .{});\n consumer();\n thread.join();\n ```\n\n Note that condition variables can only reliably unblock threads that are sequenced before them using the same Mutex.\n This means that the following is allowed to deadlock:\n ```\n thread-1: mutex.lock()\n thread-1: condition.wait(&mutex)\n\n thread-2: // mutex.lock() (without this, the following signal may not see the waiting thread-1)\n thread-2: // mutex.unlock() (this is optional for correctness once locked above, as signal can be called while holding the mutex)\n thread-2: condition.signal()\n ```\n",[9170],false],[68,44,0,null,null,null,null,false],[68,45,0,null,null,null,null,false],[68,46,0,null,null,null,null,false],[68,47,0,null,null,null,null,false],[68,49,0,null,null,null,null,false],[68,50,0,null,null,null,null,false],[68,51,0,null,null,null,null,false],[68,52,0,null,null,null,null,false],[68,53,0,null,null,null,null,false],[68,71,0,null,null," Atomically releases the Mutex, blocks the caller thread, then re-acquires the Mutex on return.\n \"Atomically\" here refers to accesses done on the Condition after acquiring the Mutex.\n\n The Mutex must be locked by the caller's thread when this function is called.\n A Mutex can have multiple Conditions waiting with it concurrently, but not the opposite.\n It is undefined behavior for multiple threads to wait ith different mutexes using the same Condition concurrently.\n Once threads have finished waiting with one Mutex, the Condition can be used to wait with another Mutex.\n\n A blocking call to wait() is unblocked from one of the following conditions:\n - a spurious (\"at random\") wake up occurs\n - a future call to `signal()` or `broadcast()` which has acquired the Mutex and is sequenced after this `wait()`.\n\n Given wait() can be interrupted spuriously, the blocking condition should be checked continuously\n irrespective of any notifications from `signal()` or `broadcast()`.",[9121,9122],false],[0,0,0,"self",null,"",null,false],[0,0,0,"mutex",null,"",null,false],[68,92,0,null,null," Atomically releases the Mutex, blocks the caller thread, then re-acquires the Mutex on return.\n \"Atomically\" here refers to accesses done on the Condition after acquiring the Mutex.\n\n The Mutex must be locked by the caller's thread when this function is called.\n A Mutex can have multiple Conditions waiting with it concurrently, but not the opposite.\n It is undefined behavior for multiple threads to wait ith different mutexes using the same Condition concurrently.\n Once threads have finished waiting with one Mutex, the Condition can be used to wait with another Mutex.\n\n A blocking call to `timedWait()` is unblocked from one of the following conditions:\n - a spurious (\"at random\") wake occurs\n - the caller was blocked for around `timeout_ns` nanoseconds, in which `error.Timeout` is returned.\n - a future call to `signal()` or `broadcast()` which has acquired the Mutex and is sequenced after this `timedWait()`.\n\n Given `timedWait()` can be interrupted spuriously, the blocking condition should be checked continuously\n irrespective of any notifications from `signal()` or `broadcast()`.",[9124,9125,9126],false],[0,0,0,"self",null,"",null,false],[0,0,0,"mutex",null,"",null,false],[0,0,0,"timeout_ns",null,"",null,false],[68,99,0,null,null," Unblocks at least one thread blocked in a call to `wait()` or `timedWait()` with a given Mutex.\n The blocked thread must be sequenced before this call with respect to acquiring the same Mutex in order to be observable for unblocking.\n `signal()` can be called with or without the relevant Mutex being acquired and have no \"effect\" if there's no observable blocked threads.",[9128],false],[0,0,0,"self",null,"",null,false],[68,106,0,null,null," Unblocks all threads currently blocked in a call to `wait()` or `timedWait()` with a given Mutex.\n The blocked threads must be sequenced before this call with respect to acquiring the same Mutex in order to be observable for unblocking.\n `broadcast()` can be called with or without the relevant Mutex being acquired and have no \"effect\" if there's no observable blocked threads.",[9130],false],[0,0,0,"self",null,"",null,false],[68,110,0,null,null,null,null,false],[68,117,0,null,null,null,[9133,9134],false],[0,0,0,"one",null,null,null,false],[0,0,0,"all",null,null,null,false],[68,122,0,null,null,null,[],false],[68,123,0,null,null,null,[9137,9138,9139],false],[0,0,0,"self",null,"",null,false],[0,0,0,"mutex",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[68,137,0,null,null,null,[9141,9142],false],[0,0,0,"self",null,"",null,false],[0,0,0,"notify",null,"",null,true],[68,144,0,null,null,null,[9152],false],[68,147,0,null,null,null,[9145,9146,9147],false],[0,0,0,"self",null,"",null,false],[0,0,0,"mutex",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[68,186,0,null,null,null,[9149,9150],false],[0,0,0,"self",null,"",null,false],[0,0,0,"notify",null,"",null,true],[68,144,0,null,null,null,null,false],[0,0,0,"condition",null,null,null,false],[68,194,0,null,null,null,[9166,9168],false],[68,198,0,null,null,null,null,false],[68,199,0,null,null,null,null,false],[68,201,0,null,null,null,null,false],[68,202,0,null,null,null,null,false],[68,204,0,null,null,null,[9159,9160,9161],false],[0,0,0,"self",null,"",null,false],[0,0,0,"mutex",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[68,256,0,null,null,null,[9163,9164],false],[0,0,0,"self",null,"",null,false],[0,0,0,"notify",null,"",null,true],[68,194,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[68,194,0,null,null,null,null,false],[0,0,0,"epoch",null,null,null,false],[68,0,0,null,null,null,null,false],[0,0,0,"impl",null,null,null,false],[63,17,0,null,null,null,null,false],[0,0,0,"Thread/RwLock.zig",null," A lock that supports one writer or many readers.\n This API is for kernel threads, not evented I/O.\n This API requires being initialized at runtime, and initialization\n can fail. Once initialized, the core operations cannot fail.\n",[9250],false],[69,7,0,null,null,null,null,false],[69,8,0,null,null,null,null,false],[69,9,0,null,null,null,null,false],[69,10,0,null,null,null,null,false],[69,11,0,null,null,null,null,false],[69,13,0,null,null,null,null,false],[69,22,0,null,null," Attempts to obtain exclusive lock ownership.\n Returns `true` if the lock is obtained, `false` otherwise.",[9180],false],[0,0,0,"rwl",null,"",null,false],[69,27,0,null,null," Blocks until exclusive lock ownership is acquired.",[9182],false],[0,0,0,"rwl",null,"",null,false],[69,33,0,null,null," Releases a held exclusive lock.\n Asserts the lock is held exclusively.",[9184],false],[0,0,0,"rwl",null,"",null,false],[69,39,0,null,null," Attempts to obtain shared lock ownership.\n Returns `true` if the lock is obtained, `false` otherwise.",[9186],false],[0,0,0,"rwl",null,"",null,false],[69,44,0,null,null," Blocks until shared lock ownership is acquired.",[9188],false],[0,0,0,"rwl",null,"",null,false],[69,49,0,null,null," Releases a held shared lock.",[9190],false],[0,0,0,"rwl",null,"",null,false],[69,55,0,null,null," Single-threaded applications use this for deadlock checks in\n debug mode, and no-ops in release modes.",[9208,9209],false],[69,61,0,null,null," Attempts to obtain exclusive lock ownership.\n Returns `true` if the lock is obtained, `false` otherwise.",[9193],false],[0,0,0,"rwl",null,"",null,false],[69,73,0,null,null," Blocks until exclusive lock ownership is acquired.",[9195],false],[0,0,0,"rwl",null,"",null,false],[69,81,0,null,null," Releases a held exclusive lock.\n Asserts the lock is held exclusively.",[9197],false],[0,0,0,"rwl",null,"",null,false],[69,89,0,null,null," Attempts to obtain shared lock ownership.\n Returns `true` if the lock is obtained, `false` otherwise.",[9199],false],[0,0,0,"rwl",null,"",null,false],[69,106,0,null,null," Blocks until shared lock ownership is acquired.",[9201],false],[0,0,0,"rwl",null,"",null,false],[69,121,0,null,null," Releases a held shared lock.",[9203],false],[0,0,0,"rwl",null,"",null,false],[69,55,0,null,null,null,[9205,9206,9207],false],[0,0,0,"unlocked",null,null,null,false],[0,0,0,"locked_exclusive",null,null,null,false],[0,0,0,"locked_shared",null,null,null,false],[0,0,0,"state",null,null,null,false],[0,0,0,"shared_count",null,null,null,false],[69,135,0,null,null,null,[9224],false],[69,138,0,null,null,null,[9212],false],[0,0,0,"rwl",null,"",null,false],[69,142,0,null,null,null,[9214],false],[0,0,0,"rwl",null,"",null,false],[69,147,0,null,null,null,[9216],false],[0,0,0,"rwl",null,"",null,false],[69,152,0,null,null,null,[9218],false],[0,0,0,"rwl",null,"",null,false],[69,156,0,null,null,null,[9220],false],[0,0,0,"rwl",null,"",null,false],[69,161,0,null,null,null,[9222],false],[0,0,0,"rwl",null,"",null,false],[69,135,0,null,null,null,null,false],[0,0,0,"rwlock",null,null,null,false],[69,167,0,null,null,null,[9244,9246,9248],false],[69,172,0,null,null,null,null,false],[69,173,0,null,null,null,null,false],[69,174,0,null,null,null,null,false],[69,175,0,null,null,null,null,false],[69,176,0,null,null,null,null,false],[69,177,0,null,null,null,null,false],[69,179,0,null,null,null,[9233],false],[0,0,0,"rwl",null,"",null,false],[69,193,0,null,null,null,[9235],false],[0,0,0,"rwl",null,"",null,false],[69,202,0,null,null,null,[9237],false],[0,0,0,"rwl",null,"",null,false],[69,207,0,null,null,null,[9239],false],[0,0,0,"rwl",null,"",null,false],[69,229,0,null,null,null,[9241],false],[0,0,0,"rwl",null,"",null,false],[69,247,0,null,null,null,[9243],false],[0,0,0,"rwl",null,"",null,false],[0,0,0,"state",null,null,null,false],[69,167,0,null,null,null,null,false],[0,0,0,"mutex",null,null,null,false],[69,167,0,null,null,null,null,false],[0,0,0,"semaphore",null,null,null,false],[69,0,0,null,null,null,null,false],[0,0,0,"impl",null,null,null,false],[63,18,0,null,null,null,null,false],[0,0,0,"Thread/Pool.zig",null,"",[9307,9309,9311,9312,9314,9316],false],[70,0,0,null,null,null,null,false],[70,1,0,null,null,null,null,false],[70,2,0,null,null,null,null,false],[70,3,0,null,null,null,null,false],[0,0,0,"WaitGroup.zig",null,"",[9275,9277],false],[71,0,0,null,null,null,null,false],[71,1,0,null,null,null,null,false],[71,2,0,null,null,null,null,false],[71,3,0,null,null,null,null,false],[71,5,0,null,null,null,null,false],[71,6,0,null,null,null,null,false],[71,11,0,null,null,null,[9265],false],[0,0,0,"self",null,"",null,false],[71,16,0,null,null,null,[9267],false],[0,0,0,"self",null,"",null,false],[71,26,0,null,null,null,[9269],false],[0,0,0,"self",null,"",null,false],[71,35,0,null,null,null,[9271],false],[0,0,0,"self",null,"",null,false],[71,40,0,null,null,null,[9273],false],[0,0,0,"wg",null,"",null,false],[71,0,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[71,0,0,null,null,null,null,false],[0,0,0,"event",null,null,null,false],[70,12,0,null,null,null,null,false],[70,13,0,null,null,null,[9281],false],[70,13,0,null,null,null,null,false],[0,0,0,"runFn",null,null,null,false],[70,17,0,null,null,null,[9283],false],[0,0,0,"",null,"",null,false],[70,19,0,null,null,null,[9286,9288],false],[70,19,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[70,19,0,null,null,null,null,false],[0,0,0,"n_jobs",null,null,null,false],[70,24,0,null,null,null,[9290,9291],false],[0,0,0,"pool",null,"",null,false],[0,0,0,"options",null,"",null,false],[70,50,0,null,null,null,[9293],false],[0,0,0,"pool",null,"",null,false],[70,55,0,null,null,null,[9295,9296],false],[0,0,0,"pool",null,"",null,false],[0,0,0,"spawned",null,"",null,false],[70,78,0,null,null,null,[9298,9299,9300],false],[0,0,0,"pool",null,"",null,false],[0,0,0,"func",null,"",null,true],[0,0,0,"args",null,"",null,false],[70,121,0,null,null,null,[9302],false],[0,0,0,"pool",null,"",null,false],[70,144,0,null,null,null,[9304,9305],false],[0,0,0,"pool",null,"",null,false],[0,0,0,"wait_group",null,"",null,false],[70,0,0,null,null,null,null,false],[0,0,0,"mutex",null,null,null,false],[70,0,0,null,null,null,null,false],[0,0,0,"cond",null,null,null,false],[70,0,0,null,null,null,null,false],[0,0,0,"run_queue",null,null,null,false],[0,0,0,"is_running",null,null,null,false],[70,0,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[70,0,0,null,null,null,null,false],[0,0,0,"threads",null,null,null,false],[63,19,0,null,null,null,null,false],[63,21,0,null,null,null,null,false],[63,23,0,null,null,null,null,false],[63,24,0,null,null,null,null,false],[63,37,0,null,null,null,null,false],[63,49,0,null,null,null,null,false],[63,55,0,null,null,null,[9324,9325],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,false],[63,159,0,null,null,null,null,false],[63,171,0,null,null,null,[9328,9329],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buffer_ptr",null,"",null,false],[63,263,0,null,null," Represents an ID per thread guaranteed to be unique only within a process.",null,false],[63,279,0,null,null," Returns the platform ID of the callers thread.\n Attempts to use thread locals and avoid syscalls when possible.",[],false],[63,283,0,null,null,null,null,false],[63,290,0,null,null," Returns the platforms view on the number of logical CPU cores available.",[],false],[63,295,0,null,null," Configuration options for hints on how to spawn threads.",[9335,9337],false],[0,0,0,"stack_size",null," Size in bytes of the Thread's stack",null,false],[63,295,0,null,null,null,null,false],[0,0,0,"allocator",null," The allocator to be used to allocate memory for the to-be-spawned thread",null,false],[63,305,0,null,null,null,null,false],[63,339,0,null,null," Spawns a new thread which executes `function` using `args` and returns a handle to the spawned thread.\n `config` can be used as hints to the platform for now to spawn and execute the `function`.\n The caller must eventually either call `join()` to wait for the thread to finish and free its resources\n or call `detach()` to excuse the caller from calling `join()` and have the thread clean up its resources on completion.",[9340,9341,9342],false],[0,0,0,"config",null,"",null,false],[0,0,0,"function",null,"",null,true],[0,0,0,"args",null,"",null,false],[63,350,0,null,null," Represents a kernel thread handle.\n May be an integer or a pointer depending on the platform.",null,false],[63,353,0,null,null," Returns the handle of this thread",[9345],false],[0,0,0,"self",null,"",null,false],[63,359,0,null,null," Release the obligation of the caller to call `join()` and have the thread clean up its own resources on completion.\n Once called, this consumes the Thread object and invoking any other functions on it is considered undefined behavior.",[9347],false],[0,0,0,"self",null,"",null,false],[63,365,0,null,null," Waits for the thread to complete, then deallocates any resources created on `spawn()`.\n Once called, this consumes the Thread object and invoking any other functions on it is considered undefined behavior.",[9349],false],[0,0,0,"self",null,"",null,false],[63,369,0,null,null,null,null,false],[63,375,0,null,null," Yields the current thread potentially allowing other threads to run.",[],false],[63,390,0,null,null," State to synchronize detachment of spawner thread to spawned thread",[9353,9354,9355],false],[0,0,0,"running",null,null,null,false],[0,0,0,"detached",null,null,null,false],[0,0,0,"completed",null,null,null,false],[63,397,0,null,null," Used by the Thread implementations to call the spawned function with the arguments.",[9357,9358],false],[0,0,0,"f",null,"",null,true],[0,0,0,"args",null,"",null,false],[63,449,0,null,null," We can't compile error in the `Impl` switch statement as its eagerly evaluated.\n So instead, we compile-error on the methods themselves for platforms which don't support threads.",[],false],[63,450,0,null,null,null,null,false],[63,452,0,null,null,null,[],false],[63,456,0,null,null,null,[],false],[63,460,0,null,null,null,[9364,9365,9366],false],[0,0,0,"config",null,"",null,false],[0,0,0,"f",null,"",null,true],[0,0,0,"args",null,"",null,false],[63,464,0,null,null,null,[9368],false],[0,0,0,"self",null,"",null,false],[63,468,0,null,null,null,[9370],false],[0,0,0,"self",null,"",null,false],[63,472,0,null,null,null,[9372],false],[0,0,0,"self",null,"",null,false],[63,476,0,null,null,null,[9374],false],[0,0,0,"unused",null,"",null,false],[63,482,0,null,null,null,[9402],false],[63,483,0,null,null,null,null,false],[63,485,0,null,null,null,null,false],[63,487,0,null,null,null,[],false],[63,491,0,null,null,null,[],false],[63,498,0,null,null,null,[9384,9386,9388,9390],false],[63,504,0,null,null,null,[9382],false],[0,0,0,"self",null,"",null,false],[63,498,0,null,null,null,null,false],[0,0,0,"completion",null,null,null,false],[63,498,0,null,null,null,null,false],[0,0,0,"heap_ptr",null,null,null,false],[63,498,0,null,null,null,null,false],[0,0,0,"heap_handle",null,null,null,false],[63,498,0,null,null,null,null,false],[0,0,0,"thread_handle",null,null,null,false],[63,510,0,null,null,null,[9392,9393,9394],false],[0,0,0,"config",null,"",null,false],[0,0,0,"f",null,"",null,true],[0,0,0,"args",null,"",null,false],[63,565,0,null,null,null,[9396],false],[0,0,0,"self",null,"",null,false],[63,569,0,null,null,null,[9398],false],[0,0,0,"self",null,"",null,false],[63,578,0,null,null,null,[9400],false],[0,0,0,"self",null,"",null,false],[63,482,0,null,null,null,null,false],[0,0,0,"thread",null,null,null,false],[63,586,0,null,null,null,[9419],false],[63,587,0,null,null,null,null,false],[63,589,0,null,null,null,null,false],[63,591,0,null,null,null,[],false],[63,623,0,null,null,null,[],false],[63,671,0,null,null,null,[9409,9410,9411],false],[0,0,0,"config",null,"",null,false],[0,0,0,"f",null,"",null,true],[0,0,0,"args",null,"",null,false],[63,716,0,null,null,null,[9413],false],[0,0,0,"self",null,"",null,false],[63,720,0,null,null,null,[9415],false],[0,0,0,"self",null,"",null,false],[63,729,0,null,null,null,[9417],false],[0,0,0,"self",null,"",null,false],[63,586,0,null,null,null,null,false],[0,0,0,"handle",null,null,null,false],[63,740,0,null,null,null,[9473],false],[63,743,0,null,null,null,null,false],[63,744,0,null,null,null,null,false],[63,746,0,null,null,null,[9425,9427,9429,9431],false],[63,746,0,null,null,null,null,false],[0,0,0,"tid",null," Thread ID",null,false],[63,746,0,null,null,null,null,false],[0,0,0,"memory",null," Contains all memory which was allocated to bootstrap this thread, including:\n - Guard page\n - Stack\n - TLS segment\n - `Instance`\n All memory is freed upon call to `join`",null,false],[63,746,0,null,null,null,null,false],[0,0,0,"allocator",null," The allocator used to allocate the thread's memory,\n which is also used during `join` to ensure clean-up.",null,false],[63,746,0,null,null,null,null,false],[0,0,0,"state",null," The current state of the thread.",null,false],[63,764,0,null,null," A meta-data structure used to bootstrap a thread",[9434,9435,9436,9437,9440,9442],false],[63,764,0,null,null,null,null,false],[0,0,0,"thread",null,null,null,false],[0,0,0,"tls_offset",null," Contains the offset to the new __tls_base.\n The offset starting from the memory's base.",null,false],[0,0,0,"stack_offset",null," Contains the offset to the stack for the newly spawned thread.\n The offset is calculated starting from the memory's base.",null,false],[0,0,0,"raw_ptr",null," Contains the raw pointer value to the wrapper which holds all arguments\n for the callback.",null,false],[63,764,0,null,null,null,[9439],false],[0,0,0,"",null,"",null,false],[0,0,0,"call_back",null," Function pointer to a wrapping function which will call the user's\n function upon thread spawn. The above mentioned pointer will be passed\n to this function pointer as its argument.",null,false],[63,764,0,null,null,null,null,false],[0,0,0,"original_stack_pointer",null," When a thread is in `detached` state, we must free all of its memory\n upon thread completion. However, as this is done while still within\n the thread, we must first jump back to the main thread's stack or else\n we end up freeing the stack that we're currently using.",null,false],[63,786,0,null,null,null,[9444,9445,9446],false],[0,0,0,"running",null,null,null,false],[0,0,0,"completed",null,null,null,false],[0,0,0,"detached",null,null,null,false],[63,788,0,null,null,null,[],false],[63,792,0,null,null,null,[9449],false],[0,0,0,"self",null,"",null,false],[63,796,0,null,null,null,[9451],false],[0,0,0,"self",null,"",null,false],[63,804,0,null,null,null,[9453],false],[0,0,0,"self",null,"",null,false],[63,844,0,null,null,null,[9455,9456,9457],false],[0,0,0,"config",null,"",null,false],[0,0,0,"f",null,"",null,true],[0,0,0,"args",null,"",null,false],[63,920,0,null,null," Bootstrap procedure, called by the host environment after thread creation.",[9459,9460],false],[0,0,0,"tid",null,"",null,false],[0,0,0,"arg",null,"",null,false],[63,968,0,null,null," Asks the host to create a new thread for us.\n Newly created thread will call `wasi_tread_start` with the thread ID as well\n as the input `arg` that was provided to `spawnWasiThread`",null,false],[63,969,0,null,null,null,[9463],false],[0,0,0,"arg",null,"",null,false],[63,973,0,null,null," Initializes the TLS data segment starting at `memory`.\n This is a synthetic function, generated by the linker.",[9465],false],[0,0,0,"memory",null,"",null,false],[63,976,0,null,null," Returns a pointer to the base of the TLS data segment for the current thread",[],false],[63,986,0,null,null," Returns the size of the TLS segment",[],false],[63,996,0,null,null," Returns the alignment of the TLS segment",[],false],[63,1006,0,null,null," Allows for setting the stack pointer in the WebAssembly module.",[9470],false],[0,0,0,"addr",null,"",null,false],[63,1016,0,null,null," Returns the current value of the stack pointer",[],false],[63,740,0,null,null,null,null,false],[0,0,0,"thread",null,null,null,false],[63,1025,0,null,null,null,[9501],false],[63,1026,0,null,null,null,null,false],[63,1028,0,null,null,null,null,false],[63,1030,0,null,null,null,null,false],[63,1032,0,null,null,null,[],false],[63,1040,0,null,null,null,[],false],[63,1048,0,null,null,null,[9484,9486,9487,9489],false],[63,1057,0,null,null," Calls `munmap(mapped.ptr, mapped.len)` then `exit(1)` without touching the stack (which lives in `mapped.ptr`).\n Ported over from musl libc's pthread detached implementation:\n https://github.com/ifduyue/musl/search?q=__unmapself",[9482],false],[0,0,0,"self",null,"",null,false],[63,1048,0,null,null,null,null,false],[0,0,0,"completion",null,null,null,false],[63,1048,0,null,null,null,null,false],[0,0,0,"child_tid",null,null,null,false],[0,0,0,"parent_tid",null,null,null,false],[63,1048,0,null,null,null,null,false],[0,0,0,"mapped",null,null,null,false],[63,1195,0,null,null,null,[9491,9492,9493],false],[0,0,0,"config",null,"",null,false],[0,0,0,"f",null,"",null,true],[0,0,0,"args",null,"",null,false],[63,1319,0,null,null,null,[9495],false],[0,0,0,"self",null,"",null,false],[63,1323,0,null,null,null,[9497],false],[0,0,0,"self",null,"",null,false],[63,1331,0,null,null,null,[9499],false],[0,0,0,"self",null,"",null,false],[63,1025,0,null,null,null,null,false],[0,0,0,"thread",null,null,null,false],[63,1362,0,null,null,null,[9503],false],[0,0,0,"thread",null,"",null,false],[63,1445,0,null,null,null,[9505,9506],false],[0,0,0,"value",null,"",null,false],[0,0,0,"event",null,"",null,false],[63,0,0,null,null,null,null,false],[0,0,0,"impl",null,null,null,false],[0,48,0,null,null,null,null,false],[0,0,0,"treap.zig",null,"",[],false],[72,0,0,null,null,null,null,false],[72,1,0,null,null,null,null,false],[72,2,0,null,null,null,null,false],[72,3,0,null,null,null,null,false],[72,5,0,null,null,null,[9516,9517],false],[0,0,0,"Key",null,"",null,true],[0,0,0,"compareFn",null,"",[9580,9582],true],[72,7,0,null,null,null,null,false],[72,11,0,null,null,null,[9520,9521],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[72,21,0,null,null," A customized pseudo random number generator for the treap.\n This just helps reducing the memory size of the treap itself\n as std.rand.DefaultPrng requires larger state (while producing better entropy for randomness to be fair).",[9526],false],[72,24,0,null,null,null,[9524,9525],false],[0,0,0,"self",null,"",null,false],[0,0,0,"seed",null,"",null,false],[0,0,0,"xorshift",null,null,null,false],[72,48,0,null,null," A Node represents an item or point in the treap with a uniquely associated key.",[9529,9530,9532,9534],false],[72,48,0,null,null,null,null,false],[0,0,0,"key",null,null,null,false],[0,0,0,"priority",null,null,null,false],[72,48,0,null,null,null,null,false],[0,0,0,"parent",null,null,null,false],[72,48,0,null,null,null,null,false],[0,0,0,"children",null,null,null,false],[72,57,0,null,null," Returns the smallest Node by key in the treap if there is one.\n Use `getEntryForExisting()` to replace/remove this Node from the treap.",[9536],false],[0,0,0,"self",null,"",null,false],[72,67,0,null,null," Returns the largest Node by key in the treap if there is one.\n Use `getEntryForExisting()` to replace/remove this Node from the treap.",[9538],false],[0,0,0,"self",null,"",null,false],[72,77,0,null,null," Lookup the Entry for the given key in the treap.\n The Entry act's as a slot in the treap to insert/replace/remove the node associated with the key.",[9540,9541],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[72,92,0,null,null," Get an entry for a Node that currently exists in the treap.\n It is undefined behavior if the Node is not currently inserted in the treap.\n The Entry act's as a slot in the treap to insert/replace/remove the node associated with the key.",[9543,9544],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[72,104,0,null,null," An Entry represents a slot in the treap associated with a given key.",[9550,9552,9554,9558],false],[72,120,0,null,null," Update's the Node at this Entry in the treap with the new node.",[9547,9548],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_node",null,"",null,false],[72,104,0,null,null,null,null,false],[0,0,0,"key",null," The associated key for this entry.",null,false],[72,104,0,null,null,null,null,false],[0,0,0,"treap",null," A reference to the treap this entry is apart of.",null,false],[72,104,0,null,null,null,null,false],[0,0,0,"node",null," The current node at this entry.",null,false],[72,104,0,null,null,null,[9556,9557],false],[0,0,0,"inserted_under",null," A find() was called for this entry and the position in the treap is known.",null,false],[0,0,0,"removed",null," The entry's node was removed from the treap and a lookup must occur again for modification.",null,false],[0,0,0,"context",null," The current state of the entry.",null,false],[72,151,0,null,null,null,[9560,9561,9562],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"parent_ref",null,"",null,false],[72,167,0,null,null,null,[9564,9565,9566,9567],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"parent",null,"",null,false],[0,0,0,"node",null,"",null,false],[72,191,0,null,null,null,[9569,9570,9571],false],[0,0,0,"self",null,"",null,false],[0,0,0,"old",null,"",null,false],[0,0,0,"new",null,"",null,false],[72,211,0,null,null,null,[9573,9574],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[72,233,0,null,null,null,[9576,9577,9578],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[0,0,0,"right",null,"",null,false],[72,6,0,null,null,null,null,false],[0,0,0,"root",null,null,null,false],[72,6,0,null,null,null,null,false],[0,0,0,"prng",null,null,null,false],[72,264,0,null,null,null,[9584],false],[0,0,0,"T",null,"",[9594,9596,9597,9598,9599],true],[72,272,0,null,null,null,null,false],[72,274,0,null,null,null,[9587,9588],false],[0,0,0,"slice",null,"",null,false],[0,0,0,"rng",null,"",null,false],[72,294,0,null,null,null,[9590],false],[0,0,0,"self",null,"",null,false],[72,299,0,null,null,null,[9592],false],[0,0,0,"self",null,"",null,false],[72,265,0,null,null,null,null,false],[0,0,0,"rng",null,null,null,false],[72,265,0,null,null,null,null,false],[0,0,0,"slice",null,null,null,false],[0,0,0,"index",null,null,null,false],[0,0,0,"offset",null,null,null,false],[0,0,0,"co_prime",null,null,null,false],[72,307,0,null,null,null,null,false],[72,308,0,null,null,null,null,false],[0,49,0,null,null,null,null,false],[0,50,0,null,null,null,null,false],[0,0,0,"Uri.zig",null," Uniform Resource Identifier (URI) parsing roughly adhering to <https://tools.ietf.org/html/rfc3986>.\n Does not do perfect grammar and character class checking, but should be robust against URIs in the wild.\n",[9699,9701,9703,9705,9707,9709,9711,9713],false],[73,3,0,null,null,null,null,false],[73,4,0,null,null,null,null,false],[73,5,0,null,null,null,null,false],[73,17,0,null,null," Applies URI encoding and replaces all reserved characters with their respective %XX code.",[9609,9610],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"input",null,"",null,false],[73,21,0,null,null,null,[9612,9613],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"input",null,"",null,false],[73,25,0,null,null,null,[9615,9616],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"input",null,"",null,false],[73,29,0,null,null,null,[9618,9619],false],[0,0,0,"writer",null,"",null,false],[0,0,0,"input",null,"",null,false],[73,33,0,null,null,null,[9621,9622],false],[0,0,0,"writer",null,"",null,false],[0,0,0,"input",null,"",null,false],[73,37,0,null,null,null,[9624,9625],false],[0,0,0,"writer",null,"",null,false],[0,0,0,"input",null,"",null,false],[73,41,0,null,null,null,[9627,9628,9629],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"input",null,"",null,false],[0,0,0,"keepUnescaped",null,"",[9630],true],[0,0,0,"c",null,"",null,false],[73,66,0,null,null,null,[9632,9633,9634],false],[0,0,0,"writer",null,"",null,false],[0,0,0,"input",null,"",null,false],[0,0,0,"keepUnescaped",null,"",[9635],true],[0,0,0,"c",null,"",null,false],[73,78,0,null,null," Parses a URI string and unescapes all %XX where XX is a valid hex number. Otherwise, verbatim copies\n them to the output.",[9637,9638],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"input",null,"",null,false],[73,128,0,null,null,null,null,false],[73,134,0,null,null," Parses the URI or returns an error. This function is not compliant, but is required to parse\n some forms of URIs in the wild. Such as HTTP Location headers.\n The return value will contain unescaped strings pointing into the\n original `text`. Each component that is provided, will be non-`null`.",[9641],false],[0,0,0,"text",null,"",null,false],[73,208,0,null,null,null,[9643,9644,9645,9646],false],[0,0,0,"uri",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"writer",null,"",null,false],[73,268,0,null,null," Parses the URI or returns an error.\n The return value will contain unescaped strings pointing into the\n original `text`. Each component that is provided, will be non-`null`.",[9648],false],[0,0,0,"text",null,"",null,false],[73,288,0,null,null," Resolves a URI against a base URI, conforming to RFC 3986, Section 5.\n arena owns any memory allocated by this function.",[9650,9651,9652,9653],false],[0,0,0,"Base",null,"",null,false],[0,0,0,"R",null,"",null,false],[0,0,0,"strict",null,"",null,false],[0,0,0,"arena",null,"",null,false],[73,335,0,null,null,null,[9674,9675],false],[73,336,0,null,null,null,null,false],[73,341,0,null,null,null,[9657],false],[0,0,0,"self",null,"",null,false],[73,349,0,null,null,null,[9659],false],[0,0,0,"self",null,"",null,false],[73,355,0,null,null,null,[9661,9662],false],[0,0,0,"self",null,"",null,false],[0,0,0,"predicate",null,"",[9663],true],[0,0,0,"",null,"",null,false],[73,365,0,null,null,null,[9665,9666],false],[0,0,0,"self",null,"",null,false],[0,0,0,"predicate",null,"",[9667],true],[0,0,0,"",null,"",null,false],[73,375,0,null,null,null,[9669],false],[0,0,0,"self",null,"",null,false],[73,381,0,null,null,null,[9671,9672],false],[0,0,0,"self",null,"",null,false],[0,0,0,"prefix",null,"",null,false],[73,335,0,null,null,null,null,false],[0,0,0,"slice",null,null,null,false],[0,0,0,"offset",null,null,null,false],[73,389,0,null,null," scheme      = ALPHA *( ALPHA / DIGIT / \"+\" / \"-\" / \".\" )",[9677],false],[0,0,0,"c",null,"",null,false],[73,396,0,null,null,null,[9679],false],[0,0,0,"c",null,"",null,false],[73,404,0,null,null," reserved    = gen-delims / sub-delims",[9681],false],[0,0,0,"c",null,"",null,false],[73,409,0,null,null," gen-delims  = \":\" / \"/\" / \"?\" / \"#\" / \"[\" / \"]\" / \"@\"",[9683],false],[0,0,0,"c",null,"",null,false],[73,418,0,null,null," sub-delims  = \"!\" / \"$\" / \"&\" / \"'\" / \"(\" / \")\"\n             / \"*\" / \"+\" / \",\" / \";\" / \"=\"",[9685],false],[0,0,0,"c",null,"",null,false],[73,426,0,null,null," unreserved  = ALPHA / DIGIT / \"-\" / \".\" / \"_\" / \"~\"",[9687],false],[0,0,0,"c",null,"",null,false],[73,433,0,null,null,null,[9689],false],[0,0,0,"c",null,"",null,false],[73,440,0,null,null,null,[9691],false],[0,0,0,"c",null,"",null,false],[73,444,0,null,null,null,[9693],false],[0,0,0,"c",null,"",null,false],[73,448,0,null,null,null,[9695],false],[0,0,0,"c",null,"",null,false],[73,523,0,null,null,null,[9697],false],[0,0,0,"hostlist",null,"",null,true],[73,0,0,null,null,null,null,false],[0,0,0,"scheme",null,null,null,false],[73,0,0,null,null,null,null,false],[0,0,0,"user",null,null,null,false],[73,0,0,null,null,null,null,false],[0,0,0,"password",null,null,null,false],[73,0,0,null,null,null,null,false],[0,0,0,"host",null,null,null,false],[73,0,0,null,null,null,null,false],[0,0,0,"port",null,null,null,false],[73,0,0,null,null,null,null,false],[0,0,0,"path",null,null,null,false],[73,0,0,null,null,null,null,false],[0,0,0,"query",null,null,null,false],[73,0,0,null,null,null,null,false],[0,0,0,"fragment",null,null,null,false],[0,52,0,null,null,null,null,false],[0,0,0,"array_hash_map.zig",null,"",[],false],[74,0,0,null,null,null,null,false],[74,1,0,null,null,null,null,false],[74,2,0,null,null,null,null,false],[74,3,0,null,null,null,null,false],[74,4,0,null,null,null,null,false],[74,5,0,null,null,null,null,false],[74,6,0,null,null,null,null,false],[74,7,0,null,null,null,null,false],[74,8,0,null,null,null,null,false],[74,9,0,null,null,null,null,false],[74,10,0,null,null,null,null,false],[74,11,0,null,null,null,null,false],[74,15,0,null,null," An ArrayHashMap with default hash and equal functions.\n See AutoContext for a description of the hash and equal implementations.",[9729,9730],false],[0,0,0,"K",null,"",null,true],[0,0,0,"V",null,"",null,true],[74,21,0,null,null," An ArrayHashMapUnmanaged with default hash and equal functions.\n See AutoContext for a description of the hash and equal implementations.",[9732,9733],false],[0,0,0,"K",null,"",null,true],[0,0,0,"V",null,"",null,true],[74,26,0,null,null," Builtin hashmap for strings as keys.",[9735],false],[0,0,0,"V",null,"",null,true],[74,30,0,null,null,null,[9737],false],[0,0,0,"V",null,"",null,true],[74,34,0,null,null,null,[],false],[74,35,0,null,null,null,[9740,9741],false],[0,0,0,"self",null,"",null,false],[0,0,0,"s",null,"",null,false],[74,39,0,null,null,null,[9743,9744,9745,9746],false],[0,0,0,"self",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"b_index",null,"",null,false],[74,46,0,null,null,null,[9748,9749],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[74,50,0,null,null,null,[9751],false],[0,0,0,"s",null,"",null,false],[74,73,0,null,null," Insertion order is preserved.\n Deletions perform a \"swap removal\" on the entries list.\n Modifying the hash map while iterating is allowed, however, one must understand\n the (well defined) behavior when mixing insertions and deletions with iteration.\n For a hash map that can be initialized directly that does not store an Allocator\n field, see `ArrayHashMapUnmanaged`.\n When `store_hash` is `false`, this data structure is biased towards cheap `eql`\n functions. It does not store each item's hash in the table. Setting `store_hash`\n to `true` incurs slightly more memory cost by storing each key's hash in the table\n but only has to call `eql` for hash collisions.\n If typical operations (except iteration over entries) need to be faster, prefer\n the alternative `std.HashMap`.\n Context must be a struct type with two member functions:\n   hash(self, K) u32\n   eql(self, K, K, usize) bool\n Adapted variants of many functions are provided.  These variants\n take a pseudo key instead of a key.  Their context must have the functions:\n   hash(self, PseudoKey) u32\n   eql(self, PseudoKey, K, usize) bool",[9753,9754,9755,9756],false],[0,0,0,"K",null,"",null,true],[0,0,0,"V",null,"",null,true],[0,0,0,"Context",null,"",null,true],[0,0,0,"store_hash",null,"",[9948,9950,9952],true],[74,85,0,null,null," The ArrayHashMapUnmanaged type using the same settings as this managed map.",null,false],[74,92,0,null,null," Pointers to a key and value in the backing store of this map.\n Modifying the key is allowed only if it does not change the hash.\n Modifying the value is allowed.\n Entry pointers become invalid whenever this ArrayHashMap is modified,\n unless `ensureTotalCapacity`/`ensureUnusedCapacity` was previously used.",null,false],[74,95,0,null,null," A KV pair which has been copied out of the backing store",null,false],[74,98,0,null,null," The Data type used for the MultiArrayList backing this map",null,false],[74,100,0,null,null," The MultiArrayList type backing this map",null,false],[74,103,0,null,null," The stored hash type, either u32 or void.",null,false],[74,112,0,null,null," getOrPut variants return this structure, with pointers\n to the backing store and a flag to indicate whether an\n existing entry was found.\n Modifying the key is allowed only if it does not change the hash.\n Modifying the value is allowed.\n Entry pointers become invalid whenever this ArrayHashMap is modified,\n unless `ensureTotalCapacity`/`ensureUnusedCapacity` was previously used.",null,false],[74,115,0,null,null," An Iterator over Entry pointers.",null,false],[74,117,0,null,null,null,null,false],[74,120,0,null,null," Create an ArrayHashMap instance which will use a specified allocator.",[9767],false],[0,0,0,"allocator",null,"",null,false],[74,125,0,null,null,null,[9769,9770],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,136,0,null,null," Frees the backing allocation and leaves the map in an undefined state.\n Note that this does not free keys or values.  You must take care of that\n before calling this function, if it is needed.",[9772],false],[0,0,0,"self",null,"",null,false],[74,142,0,null,null," Clears the map but retains the backing allocation for future use.",[9774],false],[0,0,0,"self",null,"",null,false],[74,147,0,null,null," Clears the map and releases the backing allocation",[9776],false],[0,0,0,"self",null,"",null,false],[74,152,0,null,null," Returns the number of KV pairs stored in this map.",[9778],false],[0,0,0,"self",null,"",null,false],[74,158,0,null,null," Returns the backing array of keys in this map.\n Modifying the map may invalidate this array.",[9780],false],[0,0,0,"self",null,"",null,false],[74,163,0,null,null," Returns the backing array of values in this map.\n Modifying the map may invalidate this array.",[9782],false],[0,0,0,"self",null,"",null,false],[74,169,0,null,null," Returns an iterator over the pairs in this map.\n Modifying the map may invalidate this iterator.",[9784],false],[0,0,0,"self",null,"",null,false],[74,179,0,null,null," If key exists this function cannot fail.\n If there is an existing item with `key`, then the result\n `Entry` pointer points to it, and found_existing is true.\n Otherwise, puts a new item with undefined value, and\n the `Entry` pointer points to it. Caller should then initialize\n the value (but not the key).",[9786,9787],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,182,0,null,null,null,[9789,9790,9791],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,193,0,null,null," If there is an existing item with `key`, then the result\n `Entry` pointer points to it, and found_existing is true.\n Otherwise, puts a new item with undefined value, and\n the `Entry` pointer points to it. Caller should then initialize\n the value (but not the key).\n If a new entry needs to be stored, this function asserts there\n is enough capacity to store it.",[9793,9794],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,196,0,null,null,null,[9796,9797,9798],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,199,0,null,null,null,[9800,9801,9802],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,205,0,null,null," Increases capacity, guaranteeing that insertions up until the\n `expected_count` will not cause an allocation, and therefore cannot fail.",[9804,9805],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[74,212,0,null,null," Increases capacity, guaranteeing that insertions up until\n `additional_count` **more** items will not cause an allocation, and\n therefore cannot fail.",[9807,9808],false],[0,0,0,"self",null,"",null,false],[0,0,0,"additional_count",null,"",null,false],[74,218,0,null,null," Returns the number of total elements which may be present before it is\n no longer guaranteed that no allocations will be performed.",[9810],false],[0,0,0,"self",null,"",null,false],[74,224,0,null,null," Clobbers any existing data. To detect if a put would clobber\n existing data, see `getOrPut`.",[9812,9813,9814],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,230,0,null,null," Inserts a key-value pair into the hash map, asserting that no previous\n entry with the same key is already present",[9816,9817,9818],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,237,0,null,null," Asserts there is enough capacity to store the new key-value pair.\n Clobbers any existing data. To detect if a put would clobber\n existing data, see `getOrPutAssumeCapacity`.",[9820,9821,9822],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,244,0,null,null," Asserts there is enough capacity to store the new key-value pair.\n Asserts that it does not clobber any existing data.\n To detect if a put would clobber existing data, see `getOrPutAssumeCapacity`.",[9824,9825,9826],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,249,0,null,null," Inserts a new `Entry` into the hash map, returning the previous one, if any.",[9828,9829,9830],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,255,0,null,null," Inserts a new `Entry` into the hash map, returning the previous one, if any.\n If insertion happuns, asserts there is enough capacity without allocating.",[9832,9833,9834],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,260,0,null,null," Finds pointers to the key and value storage associated with a key.",[9836,9837],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,263,0,null,null,null,[9839,9840,9841],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,268,0,null,null," Finds the index in the `entries` array where a key is stored",[9843,9844],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,271,0,null,null,null,[9846,9847,9848],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,276,0,null,null," Find the value associated with a key",[9850,9851],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,279,0,null,null,null,[9853,9854,9855],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,284,0,null,null," Find a pointer to the value associated with a key",[9857,9858],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,287,0,null,null,null,[9860,9861,9862],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,292,0,null,null," Find the actual key associated with an adapted key",[9864,9865],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,295,0,null,null,null,[9867,9868,9869],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,300,0,null,null," Find a pointer to the actual key associated with an adapted key",[9871,9872],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,303,0,null,null,null,[9874,9875,9876],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,308,0,null,null," Check whether a key is stored in the map",[9878,9879],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,311,0,null,null,null,[9881,9882,9883],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,319,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map, and then returned from this function. The entry is\n removed from the underlying array by swapping it with the last\n element.",[9885,9886],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,322,0,null,null,null,[9888,9889,9890],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,330,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map, and then returned from this function. The entry is\n removed from the underlying array by shifting all elements forward\n thereby maintaining the current ordering.",[9892,9893],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,333,0,null,null,null,[9895,9896,9897],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,341,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map. The entry is removed from the underlying array\n by swapping it with the last element.  Returns true if an entry\n was removed, false otherwise.",[9899,9900],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,344,0,null,null,null,[9902,9903,9904],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,352,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map. The entry is removed from the underlying array\n by shifting all elements forward, thereby maintaining the\n current ordering.  Returns true if an entry was removed, false otherwise.",[9906,9907],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,355,0,null,null,null,[9909,9910,9911],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,362,0,null,null," Deletes the item at the specified index in `entries` from\n the hash map. The entry is removed from the underlying array\n by swapping it with the last element.",[9913,9914],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[74,370,0,null,null," Deletes the item at the specified index in `entries` from\n the hash map. The entry is removed from the underlying array\n by shifting all elements forward, thereby maintaining the\n current ordering.",[9916,9917],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[74,376,0,null,null," Create a copy of the hash map which can be modified separately.\n The copy uses the same context and allocator as this instance.",[9919],false],[0,0,0,"self",null,"",null,false],[74,383,0,null,null," Create a copy of the hash map which can be modified separately.\n The copy uses the same context as this instance, but the specified\n allocator.",[9921,9922],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[74,390,0,null,null," Create a copy of the hash map which can be modified separately.\n The copy uses the same allocator as this instance, but the\n specified context.",[9924,9925],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,396,0,null,null," Create a copy of the hash map which can be modified separately.\n The copy uses the specified allocator and context.",[9927,9928,9929],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,403,0,null,null," Set the map to an empty state, making deinitialization a no-op, and\n returning a copy of the original.",[9931],false],[0,0,0,"self",null,"",null,false],[74,411,0,null,null," Rebuilds the key indexes. If the underlying entries has been modified directly, users\n can call `reIndex` to update the indexes to account for these new entries.",[9933],false],[0,0,0,"self",null,"",null,false],[74,418,0,null,null," Sorts the entries and then rebuilds the index.\n `sort_ctx` must have this method:\n `fn lessThan(ctx: @TypeOf(ctx), a_index: usize, b_index: usize) bool`",[9935,9936],false],[0,0,0,"self",null,"",null,false],[0,0,0,"sort_ctx",null,"",null,false],[74,424,0,null,null," Shrinks the underlying `Entry` array to `new_len` elements and discards any associated\n index entries. Keeps capacity the same.",[9938,9939],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[74,430,0,null,null," Shrinks the underlying `Entry` array to `new_len` elements and discards any associated\n index entries. Reduces allocated capacity.",[9941,9942],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[74,435,0,null,null," Removes the last inserted `Entry` in the hash map and returns it.",[9944],false],[0,0,0,"self",null,"",null,false],[74,441,0,null,null," Removes the last inserted `Entry` in the hash map and returns it if count is nonzero.\n Otherwise returns null.",[9946],false],[0,0,0,"self",null,"",null,false],[74,79,0,null,null,null,null,false],[0,0,0,"unmanaged",null,null,null,false],[74,79,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[74,79,0,null,null,null,null,false],[0,0,0,"ctx",null,null,null,false],[74,471,0,null,null," General purpose hash table.\n Insertion order is preserved.\n Deletions perform a \"swap removal\" on the entries list.\n Modifying the hash map while iterating is allowed, however, one must understand\n the (well defined) behavior when mixing insertions and deletions with iteration.\n This type does not store an Allocator field - the Allocator must be passed in\n with each function call that requires it. See `ArrayHashMap` for a type that stores\n an Allocator field for convenience.\n Can be initialized directly using the default field values.\n This type is designed to have low overhead for small numbers of entries. When\n `store_hash` is `false` and the number of entries in the map is less than 9,\n the overhead cost of using `ArrayHashMapUnmanaged` rather than `std.ArrayList` is\n only a single pointer-sized integer.\n When `store_hash` is `false`, this data structure is biased towards cheap `eql`\n functions. It does not store each item's hash in the table. Setting `store_hash`\n to `true` incurs slightly more memory cost by storing each key's hash in the table\n but guarantees only one call to `eql` per insertion/deletion.\n Context must be a struct type with two member functions:\n   hash(self, K) u32\n   eql(self, K, K) bool\n Adapted variants of many functions are provided.  These variants\n take a pseudo key instead of a key.  Their context must have the functions:\n   hash(self, PseudoKey) u32\n   eql(self, PseudoKey, K) bool",[9954,9955,9956,9957],false],[0,0,0,"K",null,"",null,true],[0,0,0,"V",null,"",null,true],[0,0,0,"Context",null,"",null,true],[0,0,0,"store_hash",null,"",[10487,10489],true],[74,495,0,null,null," Modifying the key is allowed only if it does not change the hash.\n Modifying the value is allowed.\n Entry pointers become invalid whenever this ArrayHashMap is modified,\n unless `ensureTotalCapacity`/`ensureUnusedCapacity` was previously used.",[9960,9962],false],[74,495,0,null,null,null,null,false],[0,0,0,"key_ptr",null,null,null,false],[74,495,0,null,null,null,null,false],[0,0,0,"value_ptr",null,null,null,false],[74,501,0,null,null," A KV pair which has been copied out of the backing store",[9965,9967],false],[74,501,0,null,null,null,null,false],[0,0,0,"key",null,null,null,false],[74,501,0,null,null,null,null,false],[0,0,0,"value",null,null,null,false],[74,507,0,null,null," The Data type used for the MultiArrayList backing this map",[9970,9972,9974],false],[74,507,0,null,null,null,null,false],[0,0,0,"hash",null,null,null,false],[74,507,0,null,null,null,null,false],[0,0,0,"key",null,null,null,false],[74,507,0,null,null,null,null,false],[0,0,0,"value",null,null,null,false],[74,514,0,null,null," The MultiArrayList type backing this map",null,false],[74,517,0,null,null," The stored hash type, either u32 or void.",null,false],[74,526,0,null,null," getOrPut variants return this structure, with pointers\n to the backing store and a flag to indicate whether an\n existing entry was found.\n Modifying the key is allowed only if it does not change the hash.\n Modifying the value is allowed.\n Entry pointers become invalid whenever this ArrayHashMap is modified,\n unless `ensureTotalCapacity`/`ensureUnusedCapacity` was previously used.",[9979,9981,9982,9983],false],[74,526,0,null,null,null,null,false],[0,0,0,"key_ptr",null,null,null,false],[74,526,0,null,null,null,null,false],[0,0,0,"value_ptr",null,null,null,false],[0,0,0,"found_existing",null,null,null,false],[0,0,0,"index",null,null,null,false],[74,534,0,null,null," The ArrayHashMap type using the same settings as this managed map.",null,false],[74,538,0,null,null," Some functions require a context only if hashes are not stored.\n To keep the api simple, this type is only used internally.",null,false],[74,540,0,null,null,null,null,false],[74,542,0,null,null,null,null,false],[74,544,0,null,null,null,[9989,9990],false],[0,0,0,"swap",null,null,null,false],[0,0,0,"ordered",null,null,null,false],[74,551,0,null,null," Convert from an unmanaged map to a managed map.  After calling this,\n the promoted map should no longer be used.",[9992,9993],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[74,556,0,null,null,null,[9995,9996,9997],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,567,0,null,null," Frees the backing allocation and leaves the map in an undefined state.\n Note that this does not free keys or values.  You must take care of that\n before calling this function, if it is needed.",[9999,10000],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[74,576,0,null,null," Clears the map but retains the backing allocation for future use.",[10002],false],[0,0,0,"self",null,"",null,false],[74,588,0,null,null," Clears the map and releases the backing allocation",[10004,10005],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[74,597,0,null,null," Returns the number of KV pairs stored in this map.",[10007],false],[0,0,0,"self",null,"",null,false],[74,603,0,null,null," Returns the backing array of keys in this map.\n Modifying the map may invalidate this array.",[10009],false],[0,0,0,"self",null,"",null,false],[74,608,0,null,null," Returns the backing array of values in this map.\n Modifying the map may invalidate this array.",[10011],false],[0,0,0,"self",null,"",null,false],[74,614,0,null,null," Returns an iterator over the pairs in this map.\n Modifying the map may invalidate this iterator.",[10013],false],[0,0,0,"self",null,"",null,false],[74,622,0,null,null,null,[10020,10022,10023,10024],false],[74,628,0,null,null,null,[10016],false],[0,0,0,"it",null,"",null,false],[74,640,0,null,null," Reset the iterator to the initial index",[10018],false],[0,0,0,"it",null,"",null,false],[74,622,0,null,null,null,null,false],[0,0,0,"keys",null,null,null,false],[74,622,0,null,null,null,null,false],[0,0,0,"values",null,null,null,false],[0,0,0,"len",null,null,null,false],[0,0,0,"index",null,null,null,false],[74,651,0,null,null," If key exists this function cannot fail.\n If there is an existing item with `key`, then the result\n `Entry` pointer points to it, and found_existing is true.\n Otherwise, puts a new item with undefined value, and\n the `Entry` pointer points to it. Caller should then initialize\n the value (but not the key).",[10026,10027,10028],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,656,0,null,null,null,[10030,10031,10032,10033],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,663,0,null,null,null,[10035,10036,10037,10038],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[74,668,0,null,null,null,[10040,10041,10042,10043,10044],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,691,0,null,null," If there is an existing item with `key`, then the result\n `Entry` pointer points to it, and found_existing is true.\n Otherwise, puts a new item with undefined value, and\n the `Entry` pointer points to it. Caller should then initialize\n the value (but not the key).\n If a new entry needs to be stored, this function asserts there\n is enough capacity to store it.",[10046,10047],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,696,0,null,null,null,[10049,10050,10051],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,710,0,null,null," If there is an existing item with `key`, then the result\n `Entry` pointers point to it, and found_existing is true.\n Otherwise, puts a new item with undefined key and value, and\n the `Entry` pointers point to it. Caller must then initialize\n both the key and the value.\n If a new entry needs to be stored, this function asserts there\n is enough capacity to store it.",[10053,10054,10055],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,749,0,null,null,null,[10057,10058,10059,10060],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,754,0,null,null,null,[10062,10063,10064,10065,10066],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,765,0,null,null," Increases capacity, guaranteeing that insertions up until the\n `expected_count` will not cause an allocation, and therefore cannot fail.",[10068,10069,10070],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[74,770,0,null,null,null,[10072,10073,10074,10075],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_capacity",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,795,0,null,null," Increases capacity, guaranteeing that insertions up until\n `additional_count` **more** items will not cause an allocation, and\n therefore cannot fail.",[10077,10078,10079],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"additional_capacity",null,"",null,false],[74,804,0,null,null,null,[10081,10082,10083,10084],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"additional_capacity",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,815,0,null,null," Returns the number of total elements which may be present before it is\n no longer guaranteed that no allocations will be performed.",[10086],false],[0,0,0,"self",null,"",null,false],[74,824,0,null,null," Clobbers any existing data. To detect if a put would clobber\n existing data, see `getOrPut`.",[10088,10089,10090,10091],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,829,0,null,null,null,[10093,10094,10095,10096,10097],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,836,0,null,null," Inserts a key-value pair into the hash map, asserting that no previous\n entry with the same key is already present",[10099,10100,10101,10102],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,841,0,null,null,null,[10104,10105,10106,10107,10108],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,850,0,null,null," Asserts there is enough capacity to store the new key-value pair.\n Clobbers any existing data. To detect if a put would clobber\n existing data, see `getOrPutAssumeCapacity`.",[10110,10111,10112],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,855,0,null,null,null,[10114,10115,10116,10117],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,863,0,null,null," Asserts there is enough capacity to store the new key-value pair.\n Asserts that it does not clobber any existing data.\n To detect if a put would clobber existing data, see `getOrPutAssumeCapacity`.",[10119,10120,10121],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,868,0,null,null,null,[10123,10124,10125,10126],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,875,0,null,null," Inserts a new `Entry` into the hash map, returning the previous one, if any.",[10128,10129,10130,10131],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,880,0,null,null,null,[10133,10134,10135,10136,10137],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,895,0,null,null," Inserts a new `Entry` into the hash map, returning the previous one, if any.\n If insertion happens, asserts there is enough capacity without allocating.",[10139,10140,10141],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[74,900,0,null,null,null,[10143,10144,10145,10146],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,914,0,null,null," Finds pointers to the key and value storage associated with a key.",[10148,10149],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,919,0,null,null,null,[10151,10152,10153],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,922,0,null,null,null,[10155,10156,10157],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,933,0,null,null," Finds the index in the `entries` array where a key is stored",[10159,10160],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,938,0,null,null,null,[10162,10163,10164],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,941,0,null,null,null,[10166,10167,10168],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,961,0,null,null,null,[10170,10171,10172,10173,10174],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[74,968,0,null,null," Find the value associated with a key",[10176,10177],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,973,0,null,null,null,[10179,10180,10181],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,976,0,null,null,null,[10183,10184,10185],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,982,0,null,null," Find a pointer to the value associated with a key",[10187,10188],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,987,0,null,null,null,[10190,10191,10192],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,990,0,null,null,null,[10194,10195,10196],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,997,0,null,null," Find the actual key associated with an adapted key",[10198,10199],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1002,0,null,null,null,[10201,10202,10203],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1005,0,null,null,null,[10205,10206,10207],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1011,0,null,null," Find a pointer to the actual key associated with an adapted key",[10209,10210],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1016,0,null,null,null,[10212,10213,10214],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1019,0,null,null,null,[10216,10217,10218],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1025,0,null,null," Check whether a key is stored in the map",[10220,10221],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1030,0,null,null,null,[10223,10224,10225],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1033,0,null,null,null,[10227,10228,10229],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1041,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map, and then returned from this function. The entry is\n removed from the underlying array by swapping it with the last\n element.",[10231,10232],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1046,0,null,null,null,[10234,10235,10236],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1049,0,null,null,null,[10238,10239,10240],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1054,0,null,null,null,[10242,10243,10244,10245],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1062,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map, and then returned from this function. The entry is\n removed from the underlying array by shifting all elements forward\n thereby maintaining the current ordering.",[10247,10248],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1067,0,null,null,null,[10250,10251,10252],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1070,0,null,null,null,[10254,10255,10256],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1075,0,null,null,null,[10258,10259,10260,10261],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1083,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map. The entry is removed from the underlying array\n by swapping it with the last element.  Returns true if an entry\n was removed, false otherwise.",[10263,10264],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1088,0,null,null,null,[10266,10267,10268],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1091,0,null,null,null,[10270,10271,10272],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1096,0,null,null,null,[10274,10275,10276,10277],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1104,0,null,null," If there is an `Entry` with a matching key, it is deleted from\n the hash map. The entry is removed from the underlying array\n by shifting all elements forward, thereby maintaining the\n current ordering.  Returns true if an entry was removed, false otherwise.",[10279,10280],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1109,0,null,null,null,[10282,10283,10284],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1112,0,null,null,null,[10286,10287,10288],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1117,0,null,null,null,[10290,10291,10292,10293],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1124,0,null,null," Deletes the item at the specified index in `entries` from\n the hash map. The entry is removed from the underlying array\n by swapping it with the last element.",[10295,10296],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[74,1129,0,null,null,null,[10298,10299,10300],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1137,0,null,null," Deletes the item at the specified index in `entries` from\n the hash map. The entry is removed from the underlying array\n by shifting all elements forward, thereby maintaining the\n current ordering.",[10302,10303],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[74,1142,0,null,null,null,[10305,10306,10307],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1149,0,null,null," Create a copy of the hash map which can be modified separately.\n The copy uses the same context as this instance, but is allocated\n with the provided allocator.",[10309,10310],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[74,1154,0,null,null,null,[10312,10313,10314],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1171,0,null,null," Set the map to an empty state, making deinitialization a no-op, and\n returning a copy of the original.",[10316],false],[0,0,0,"self",null,"",null,false],[74,1179,0,null,null," Rebuilds the key indexes. If the underlying entries has been modified directly, users\n can call `reIndex` to update the indexes to account for these new entries.",[10318,10319],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[74,1185,0,null,null,null,[10321,10322,10323],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1199,0,null,null," Sorts the entries and then rebuilds the index.\n `sort_ctx` must have this method:\n `fn lessThan(ctx: @TypeOf(ctx), a_index: usize, b_index: usize) bool`",[10325,10326],false],[0,0,0,"self",null,"",null,false],[0,0,0,"sort_ctx",null,"",null,false],[74,1205,0,null,null,null,[10328,10329,10330],false],[0,0,0,"self",null,"",null,false],[0,0,0,"sort_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1214,0,null,null," Shrinks the underlying `Entry` array to `new_len` elements and discards any associated\n index entries. Keeps capacity the same.",[10332,10333],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[74,1219,0,null,null,null,[10335,10336,10337],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1233,0,null,null," Shrinks the underlying `Entry` array to `new_len` elements and discards any associated\n index entries. Reduces allocated capacity.",[10339,10340,10341],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[74,1238,0,null,null,null,[10343,10344,10345,10346],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1251,0,null,null," Removes the last inserted `Entry` in the hash map and returns it.",[10348],false],[0,0,0,"self",null,"",null,false],[74,1256,0,null,null,null,[10350,10351],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1269,0,null,null," Removes the last inserted `Entry` in the hash map and returns it if count is nonzero.\n Otherwise returns null.",[10353],false],[0,0,0,"self",null,"",null,false],[74,1274,0,null,null,null,[10355,10356],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[74,1280,0,null,null,null,[10358,10359,10360,10361,10362],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"removal_type",null,"",null,true],[74,1309,0,null,null,null,[10364,10365,10366,10367,10368,10369,10370],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"removal_type",null,"",null,true],[74,1321,0,null,null,null,[10372,10373,10374,10375,10376],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"removal_type",null,"",null,true],[74,1346,0,null,null,null,[10378,10379,10380,10381,10382,10383,10384],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"key_ctx",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"removal_type",null,"",null,true],[74,1353,0,null,null,null,[10386,10387,10388,10389],false],[0,0,0,"self",null,"",null,false],[0,0,0,"entry_index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"removal_type",null,"",null,true],[74,1368,0,null,null,null,[10391,10392,10393,10394,10395,10396],false],[0,0,0,"self",null,"",null,false],[0,0,0,"entry_index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"removal_type",null,"",null,true],[74,1374,0,null,null,null,[10398,10399,10400,10401,10402,10403,10404],false],[0,0,0,"self",null,"",null,false],[0,0,0,"entry_index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"indexes",null,"",null,false],[0,0,0,"removal_type",null,"",null,true],[74,1401,0,null,null,null,[10406,10407,10408,10409,10410,10411,10412],false],[0,0,0,"self",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"old_entry_index",null,"",null,false],[0,0,0,"new_entry_index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"indexes",null,"",null,false],[74,1414,0,null,null,null,[10414,10415,10416,10417],false],[0,0,0,"self",null,"",null,false],[0,0,0,"entry_index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[74,1421,0,null,null,null,[10419,10420,10421,10422,10423,10424],false],[0,0,0,"self",null,"",null,false],[0,0,0,"entry_index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"indexes",null,"",null,false],[74,1426,0,null,null,null,[10426,10427,10428,10429,10430,10431],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"indexes",null,"",null,false],[74,1433,0,null,null,null,[10433,10434,10435,10436],false],[0,0,0,"removed_slot",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"indexes",null,"",null,false],[74,1455,0,null,null,null,[10438,10439,10440,10441,10442,10443],false],[0,0,0,"self",null,"",null,false],[0,0,0,"entry_index",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"indexes",null,"",null,false],[74,1483,0,null,null," Must `ensureTotalCapacity`/`ensureUnusedCapacity` before calling this.",[10445,10446,10447,10448,10449],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[74,1596,0,null,null,null,[10451,10452,10453,10454,10455,10456],false],[0,0,0,"self",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[0,0,0,"indexes",null,"",null,false],[74,1624,0,null,null,null,[10458,10459,10460],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[74,1631,0,null,null,null,[10462,10463,10464,10465],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[74,1669,0,null,null,null,[10467,10468],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"key",null,"",null,false],[74,1680,0,null,null,null,[10470,10471,10472,10473],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"b_index",null,"",null,false],[74,1692,0,null,null,null,[10475,10476,10477],false],[0,0,0,"self",null,"",null,false],[0,0,0,"keyFmt",null,"",null,true],[0,0,0,"valueFmt",null,"",null,true],[74,1697,0,null,null,null,[10479,10480,10481,10482],false],[0,0,0,"self",null,"",null,false],[0,0,0,"keyFmt",null,"",null,true],[0,0,0,"valueFmt",null,"",null,true],[0,0,0,"ctx",null,"",null,false],[74,1728,0,null,null,null,[10484,10485],false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[74,477,0,null,null,null,null,false],[0,0,0,"entries",null," It is permitted to access this field directly.",null,false],[74,477,0,null,null,null,null,false],[0,0,0,"index_header",null," When entries length is less than `linear_scan_max`, this remains `null`.\n Once entries length grows big enough, this field is allocated. There is\n an IndexHeader followed by an array of Index(I) structs, where I is defined\n by how many total indexes there are.",null,false],[74,1752,0,null,null,null,[10491,10492,10493],false],[0,0,0,"u8",null,null,null,false],[0,0,0,"u16",null,null,null,false],[0,0,0,"u32",null,null,null,false],[74,1754,0,null,null,null,[10495],false],[0,0,0,"bit_index",null,"",null,false],[74,1763,0,null,null,null,[10497],false],[0,0,0,"bit_index",null,"",null,false],[74,1777,0,null,null," @truncate fails if the target type is larger than the\n target value.  This causes problems when one of the types\n is usize, which may be larger or smaller than u32 on different\n systems.  This version of truncate is safe to use if either\n parameter has dynamic size, and will perform widening conversion\n when needed.  Both arguments must have the same signedness.",[10499,10500],false],[0,0,0,"T",null,"",null,true],[0,0,0,"val",null,"",null,false],[74,1786,0,null,null," A single entry in the lookup acceleration structure.  These structs\n are found in an array after the IndexHeader.  Hashes index into this\n array, and linear probing is used for collisions.",[10502],false],[0,0,0,"I",null,"",[10511,10513],true],[74,1788,0,null,null,null,null,false],[74,1800,0,null,null," The special entry_index value marking an empty slot.",null,false],[74,1803,0,null,null," A constant empty index",null,false],[74,1809,0,null,null," Checks if a slot is empty",[10507],false],[0,0,0,"idx",null,"",null,false],[74,1814,0,null,null," Sets a slot to empty",[10509],false],[0,0,0,"idx",null,"",null,false],[74,1787,0,null,null,null,null,false],[0,0,0,"entry_index",null," The index of this entry in the backing store.  If the index is\n empty, this is empty_sentinel.",null,false],[74,1787,0,null,null,null,null,false],[0,0,0,"distance_from_start_index",null," The distance between this slot and its ideal placement.  This is\n used to keep maximum scan length small.  This value is undefined\n if the index is empty.",null,false],[74,1824,0,null,null," the byte size of the index must fit in a usize.  This is a power of two\n length * the size of an Index(u32).  The index is 8 bytes (3 bits repr)\n and max_usize + 1 is not representable, so we need to subtract out 4 bits.",null,false],[74,1825,0,null,null,null,null,false],[74,1826,0,null,null,null,null,false],[74,1827,0,null,null,null,null,false],[74,1828,0,null,null,null,null,false],[74,1846,0,null,null," This struct is trailed by two arrays of length indexes_len\n of integers, whose integer size is determined by indexes_len.\n These arrays are indexed by constrainIndex(hash).  The\n entryIndexes array contains the index in the dense backing store\n where the entry's data can be found.  Entries which are not in\n use have their index value set to emptySentinel(I).\n The entryDistances array stores the distance between an entry\n and its ideal hash bucket.  This is used when adding elements\n to balance the maximum scan length.",[10544],false],[74,1853,0,null,null," Map from an incrementing index to an index slot in the attached arrays.",[10521,10522],false],[0,0,0,"header",null,"",null,false],[0,0,0,"i",null,"",null,false],[74,1861,0,null,null," Returns the attached array of indexes.  I must match the type\n returned by capacityIndexType.",[10524,10525],false],[0,0,0,"header",null,"",null,false],[0,0,0,"I",null,"",null,true],[74,1867,0,null,null," Returns the type used for the index arrays.",[10527],false],[0,0,0,"header",null,"",null,false],[74,1871,0,null,null,null,[10529],false],[0,0,0,"self",null,"",null,false],[74,1874,0,null,null,null,[10531],false],[0,0,0,"self",null,"",null,false],[74,1877,0,null,null,null,[10533],false],[0,0,0,"self",null,"",null,false],[74,1881,0,null,null,null,[10535],false],[0,0,0,"desired_capacity",null,"",null,false],[74,1892,0,null,null," Allocates an index header, and fills the entryIndexes array with empty.\n The distance array contents are undefined.",[10537,10538],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_bit_index",null,"",null,false],[74,1906,0,null,null," Releases the memory for a header and its associated arrays.",[10540,10541],false],[0,0,0,"header",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[74,1914,0,null,null," Puts an IndexHeader into the state that it would be in after being freshly allocated.",[10543],false],[0,0,0,"header",null,"",null,false],[0,0,0,"bit_index",null," This field tracks the total number of items in the arrays following\n this header.  It is the bit index of the power of two number of indices.\n This value is between min_bit_index and max_bit_index, inclusive.",null,false],[74,2310,0,null,null,null,[10546,10547],false],[0,0,0,"K",null,"",null,true],[0,0,0,"Context",null,"",[10548,10549],true],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[74,2319,0,null,null,null,[10551,10552],false],[0,0,0,"K",null,"",null,true],[0,0,0,"Context",null,"",[10553,10554,10555],true],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[74,2328,0,null,null,null,[10557],false],[0,0,0,"K",null,"",[],true],[74,2330,0,null,null,null,null,false],[74,2331,0,null,null,null,null,false],[74,2335,0,null,null,null,[10561,10562],false],[0,0,0,"K",null,"",null,true],[0,0,0,"Context",null,"",[10563,10564],true],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[74,2350,0,null,null,null,[10566,10567],false],[0,0,0,"K",null,"",null,true],[0,0,0,"Context",null,"",[10568,10569,10570,10571],true],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[74,2360,0,null,null,null,[10573],false],[0,0,0,"K",null,"",null,true],[74,2378,0,null,null,null,[10575,10576,10577],false],[0,0,0,"K",null,"",null,true],[0,0,0,"Context",null,"",null,true],[0,0,0,"strategy",null,"",[10578,10579],true],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[0,53,0,null,null,null,null,false],[0,0,0,"atomic.zig",null,"",[],false],[75,0,0,null,null,null,null,false],[75,1,0,null,null,null,null,false],[75,3,0,null,null,null,null,false],[75,5,0,null,null,null,null,false],[0,0,0,"atomic/stack.zig",null,"",[],false],[76,0,0,null,null,null,null,false],[76,1,0,null,null,null,null,false],[76,2,0,null,null,null,null,false],[76,3,0,null,null,null,null,false],[76,8,0,null,null," Many reader, many writer, non-allocating, thread-safe\n Uses a spinlock to protect push() and pop()\n When building in single threaded mode, this is a simple linked list.",[10592],false],[0,0,0,"T",null,"",[10612,10614],true],[76,13,0,null,null,null,null,false],[76,15,0,null,null,null,null,false],[76,17,0,null,null,null,[10597,10599],false],[76,17,0,null,null,null,null,false],[0,0,0,"next",null,null,null,false],[76,17,0,null,null,null,null,false],[0,0,0,"data",null,null,null,false],[76,22,0,null,null,null,[],false],[76,31,0,null,null," push operation, but only if you are the first item in the stack. if you did not succeed in\n being the first item in the stack, returns the other item that was there.",[10602,10603],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[76,36,0,null,null,null,[10605,10606],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[76,49,0,null,null,null,[10608],false],[0,0,0,"self",null,"",null,false],[76,64,0,null,null,null,[10610],false],[0,0,0,"self",null,"",null,false],[76,9,0,null,null,null,null,false],[0,0,0,"root",null,null,null,false],[76,9,0,null,null,null,null,false],[0,0,0,"lock",null,null,null,false],[76,70,0,null,null,null,[10617,10619,10620,10621,10622,10623],false],[76,70,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[76,70,0,null,null,null,null,false],[0,0,0,"stack",null,null,null,false],[0,0,0,"put_sum",null,null,null,false],[0,0,0,"get_sum",null,null,null,false],[0,0,0,"get_count",null,null,null,false],[0,0,0,"puts_done",null,null,null,false],[76,83,0,null,null,null,null,false],[76,84,0,null,null,null,null,false],[76,147,0,null,null,null,[10627],false],[0,0,0,"ctx",null,"",null,false],[76,165,0,null,null,null,[10629],false],[0,0,0,"ctx",null,"",null,false],[75,6,0,null,null,null,null,false],[0,0,0,"atomic/queue.zig",null,"",[],false],[77,0,0,null,null,null,null,false],[77,1,0,null,null,null,null,false],[77,2,0,null,null,null,null,false],[77,3,0,null,null,null,null,false],[77,9,0,null,null," Many producer, many consumer, non-allocating, thread-safe.\n Uses a mutex to protect access.\n The queue does not manage ownership and the user is responsible to\n manage the storage of the nodes.",[10637],false],[0,0,0,"T",null,"",[10660,10662,10664],true],[77,15,0,null,null,null,null,false],[77,16,0,null,null,null,null,false],[77,20,0,null,null," Initializes a new queue. The queue does not provide a `deinit()`\n function, so the user must take care of cleaning up the queue elements.",[],false],[77,30,0,null,null," Appends `node` to the queue.\n The lifetime of `node` must be longer than lifetime of queue.",[10642,10643],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[77,49,0,null,null," Gets a previously inserted node or returns `null` if there is none.\n It is safe to `get()` a node from the queue while another thread tries\n to `remove()` the same node at the same time.",[10645],false],[0,0,0,"self",null,"",null,false],[77,68,0,null,null," Prepends `node` to the front of the queue.\n The lifetime of `node` must be longer than the lifetime of the queue.",[10647,10648],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[77,87,0,null,null," Removes a node from the queue, returns whether node was actually removed.\n It is safe to `remove()` a node from the queue while another thread tries\n to `get()` the same node at the same time.",[10650,10651],false],[0,0,0,"self",null,"",null,false],[0,0,0,"node",null,"",null,false],[77,113,0,null,null," Returns `true` if the queue is currently empty.\n Note that in a multi-consumer environment a return value of `false`\n does not mean that `get` will yield a non-`null` value!",[10653],false],[0,0,0,"self",null,"",null,false],[77,120,0,null,null," Dumps the contents of the queue to `stderr`.",[10655],false],[0,0,0,"self",null,"",null,false],[77,127,0,null,null," Dumps the contents of the queue to `stream`.\n Up to 4 elements from the head are dumped and the tail of the queue is\n dumped as well.",[10657,10658],false],[0,0,0,"self",null,"",null,false],[0,0,0,"stream",null,"",null,false],[77,10,0,null,null,null,null,false],[0,0,0,"head",null,null,null,false],[77,10,0,null,null,null,null,false],[0,0,0,"tail",null,null,null,false],[77,10,0,null,null,null,null,false],[0,0,0,"mutex",null,null,null,false],[77,159,0,null,null,null,[10667,10669,10670,10671,10672,10673],false],[77,159,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[77,159,0,null,null,null,null,false],[0,0,0,"queue",null,null,null,false],[0,0,0,"put_sum",null,null,null,false],[0,0,0,"get_sum",null,null,null,false],[0,0,0,"get_count",null,null,null,false],[0,0,0,"puts_done",null,null,null,false],[77,173,0,null,null,null,null,false],[77,174,0,null,null,null,null,false],[77,244,0,null,null,null,[10677],false],[0,0,0,"ctx",null,"",null,false],[77,263,0,null,null,null,[10679],false],[0,0,0,"ctx",null,"",null,false],[75,7,0,null,null,null,null,false],[0,0,0,"atomic/Atomic.zig",null,"",[],false],[78,0,0,null,null,null,null,false],[78,1,0,null,null,null,null,false],[78,3,0,null,null,null,null,false],[78,4,0,null,null,null,null,false],[78,6,0,null,null,null,[10687],false],[0,0,0,"T",null,"",[10799],true],[78,159,0,null,null,null,[],false],[78,160,0,null,null,null,[10690,10691,10692],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,164,0,null,null,null,[10694,10695,10696],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,168,0,null,null,null,[10698,10699,10700],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,172,0,null,null,null,[10702,10703,10704],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,177,0,null,null,null,[],false],[78,178,0,null,null,null,[10707,10708,10709],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,182,0,null,null,null,[10711,10712,10713],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,186,0,null,null,null,[10715,10716,10717],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,190,0,null,null,null,[10719,10720,10721],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,194,0,null,null,null,null,false],[78,195,0,null,null,null,[10724,10725,10726],false],[0,0,0,"Set",null,null,null,false],[0,0,0,"Reset",null,null,null,false],[0,0,0,"Toggle",null,null,null,false],[78,201,0,null,null,null,[10728,10729,10730],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,205,0,null,null,null,[10732,10733,10734],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,209,0,null,null,null,[10736,10737,10738],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,213,0,null,null,null,[10740,10741,10742,10743],false],[0,0,0,"self",null,"",null,false],[0,0,0,"op",null,"",null,true],[0,0,0,"bit",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,232,0,null,null,null,[10745,10746,10747,10748],false],[0,0,0,"self",null,"",null,false],[0,0,0,"op",null,"",null,true],[0,0,0,"bit",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,10,0,null,null,null,null,false],[78,12,0,null,null,null,[10751],false],[0,0,0,"value",null,"",null,false],[78,40,0,null,null," Perform an atomic fence which uses the atomic value as a hint for the modification order.\n Use this when you want to imply a fence on an atomic variable without necessarily performing a memory access.\n\n Example:\n ```\n const RefCount = struct {\n     count: Atomic(usize),\n     dropFn: *const fn(*RefCount) void,\n\n     fn ref(self: *RefCount) void {\n         _ =  self.count.fetchAdd(1, .Monotonic); // no ordering necessary, just updating a counter\n     }\n\n     fn unref(self: *RefCount) void {\n         // Release ensures code before unref() happens-before the count is decremented as dropFn could be called by then.\n         if (self.count.fetchSub(1, .Release)) {\n             // Acquire ensures count decrement and code before previous unrefs()s happens-before we call dropFn below.\n             // NOTE: another alternative is to use .AcqRel on the fetchSub count decrement but it's extra barrier in possibly hot path.\n             self.count.fence(.Acquire);\n             (self.dropFn)(self);\n         }\n     }\n };\n ```",[10753,10754],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,65,0,null,null," Non-atomically load from the atomic value without synchronization.\n Care must be taken to avoid data-races when interacting with other atomic operations.",[10756],false],[0,0,0,"self",null,"",null,false],[78,71,0,null,null," Non-atomically store to the atomic value without synchronization.\n Care must be taken to avoid data-races when interacting with other atomic operations.",[10758,10759],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[78,75,0,null,null,null,[10761,10762],false],[0,0,0,"self",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,83,0,null,null,null,[10764,10765,10766],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,91,0,null,null,null,[10768,10769,10770],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,95,0,null,null,null,[10772,10773,10774,10775,10776],false],[0,0,0,"self",null,"",null,false],[0,0,0,"compare",null,"",null,false],[0,0,0,"exchange",null,"",null,false],[0,0,0,"success",null,"",null,true],[0,0,0,"failure",null,"",null,true],[78,105,0,null,null,null,[10778,10779,10780,10781,10782],false],[0,0,0,"self",null,"",null,false],[0,0,0,"compare",null,"",null,false],[0,0,0,"exchange",null,"",null,false],[0,0,0,"success",null,"",null,true],[0,0,0,"failure",null,"",null,true],[78,115,0,null,null,null,[10784,10785,10786,10787,10788,10789],false],[0,0,0,"self",null,"",null,false],[0,0,0,"is_strong",null,"",null,true],[0,0,0,"compare",null,"",null,false],[0,0,0,"exchange",null,"",null,false],[0,0,0,"success",null,"",null,true],[0,0,0,"failure",null,"",null,true],[78,146,0,null,null,null,[10791,10792,10793,10794],false],[0,0,0,"self",null,"",null,false],[0,0,0,"op",null,"",null,true],[0,0,0,"value",null,"",null,false],[0,0,0,"ordering",null,"",null,true],[78,155,0,null,null,null,[10796,10797],false],[0,0,0,"condition",null,"",null,true],[0,0,0,"functions",null,"",null,true],[78,7,0,null,null,null,null,false],[0,0,0,"value",null,null,null,false],[78,322,0,null,null,null,[],false],[78,367,0,null,null,null,null,false],[78,399,0,null,null,null,null,false],[75,15,0,null,null,null,[10804],false],[0,0,0,"ordering",null,"",null,true],[75,26,0,null,null,null,[10806],false],[0,0,0,"ordering",null,"",null,true],[75,41,0,null,null," Signals to the processor that the caller is inside a busy-wait spin-loop.",[],false],[75,89,0,null,null," The estimated size of the CPU's cache line when atomically updating memory.\n Add this much padding or align to this boundary to avoid atomically-updated\n memory from forcing cache invalidations on near, but non-atomic, memory.\n",null,false],[0,54,0,null,null,null,null,false],[0,0,0,"base64.zig",null,"",[],false],[79,0,0,null,null,null,null,false],[79,1,0,null,null,null,null,false],[79,2,0,null,null,null,null,false],[79,3,0,null,null,null,null,false],[79,5,0,null,null,null,null,false],[79,11,0,null,null,null,[10817],false],[0,0,0,"ignore",null,"",null,false],[79,14,0,null,null," Base64 codecs",[10820,10822,10824,10826,10828],false],[79,14,0,null,null,null,null,false],[0,0,0,"alphabet_chars",null,null,null,false],[79,14,0,null,null,null,null,false],[0,0,0,"pad_char",null,null,null,false],[79,14,0,null,null,null,null,false],[0,0,0,"decoderWithIgnore",null,null,null,false],[79,14,0,null,null,null,null,false],[0,0,0,"Encoder",null,null,null,false],[79,14,0,null,null,null,null,false],[0,0,0,"Decoder",null,null,null,false],[79,22,0,null,null,null,null,false],[79,23,0,null,null,null,[10831],false],[0,0,0,"ignore",null,"",null,false],[79,28,0,null,null," Standard Base64 codecs, with padding",null,false],[79,37,0,null,null," Standard Base64 codecs, without padding",null,false],[79,45,0,null,null,null,null,false],[79,46,0,null,null,null,[10836],false],[0,0,0,"ignore",null,"",null,false],[79,51,0,null,null," URL-safe Base64 codecs, with padding",null,false],[79,60,0,null,null," URL-safe Base64 codecs, without padding",null,false],[79,68,0,null,null,null,[10851,10853],false],[79,73,0,null,null," A bunch of assertions, then simply pass the data right through.",[10841,10842],false],[0,0,0,"alphabet_chars",null,"",null,false],[0,0,0,"pad_char",null,"",null,false],[79,88,0,null,null," Compute the encoded length",[10844,10845],false],[0,0,0,"encoder",null,"",null,false],[0,0,0,"source_len",null,"",null,false],[79,98,0,null,null," dest.len must at least be what you get from ::calcSize.",[10847,10848,10849],false],[0,0,0,"encoder",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"source",null,"",null,false],[79,68,0,null,null,null,null,false],[0,0,0,"alphabet_chars",null,null,null,false],[79,68,0,null,null,null,null,false],[0,0,0,"pad_char",null,null,null,false],[79,127,0,null,null,null,[10870,10872],false],[79,128,0,null,null,null,null,false],[79,135,0,null,null,null,[10857,10858],false],[0,0,0,"alphabet_chars",null,"",null,false],[0,0,0,"pad_char",null,"",null,false],[79,154,0,null,null," Return the maximum possible decoded size for a given input length - The actual length may be less if the input includes padding.\n `InvalidPadding` is returned if the input length is not valid.",[10860,10861],false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"source_len",null,"",null,false],[79,168,0,null,null," Return the exact decoded size for a slice.\n `InvalidPadding` is returned if the input length is not valid.",[10863,10864],false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"source",null,"",null,false],[79,181,0,null,null," dest.len must be what you get from ::calcSize.\n invalid characters result in error.InvalidCharacter.\n invalid padding results in error.InvalidPadding.",[10866,10867,10868],false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"source",null,"",null,false],[79,127,0,null,null,null,null,false],[0,0,0,"char_to_index",null," e.g. 'A' => 0.\n `invalid_char` for any value not in the 64 alphabet chars.",null,false],[79,127,0,null,null,null,null,false],[0,0,0,"pad_char",null,null,null,false],[79,221,0,null,null,null,[10886,10888],false],[79,225,0,null,null,null,[10875,10876,10877],false],[0,0,0,"alphabet_chars",null,"",null,false],[0,0,0,"pad_char",null,"",null,false],[0,0,0,"ignore_chars",null,"",null,false],[79,241,0,null,null," Return the maximum possible decoded size for a given input length - The actual length may be less if the input includes padding\n `InvalidPadding` is returned if the input length is not valid.",[10879,10880],false],[0,0,0,"decoder_with_ignore",null,"",null,false],[0,0,0,"source_len",null,"",null,false],[79,254,0,null,null," Invalid characters that are not ignored result in error.InvalidCharacter.\n Invalid padding results in error.InvalidPadding.\n Decoding more data than can fit in dest results in error.NoSpaceLeft. See also ::calcSizeUpperBound.\n Returns the number of bytes written to dest.",[10882,10883,10884],false],[0,0,0,"decoder_with_ignore",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"source",null,"",null,false],[79,221,0,null,null,null,null,false],[0,0,0,"decoder",null,null,null,false],[79,221,0,null,null,null,null,false],[0,0,0,"char_is_ignored",null,null,null,false],[79,327,0,null,null,null,[],false],[79,363,0,null,null,null,[],false],[79,398,0,null,null,null,[10892,10893,10894],false],[0,0,0,"codecs",null,"",null,false],[0,0,0,"expected_decoded",null,"",null,false],[0,0,0,"expected_encoded",null,"",null,false],[79,425,0,null,null,null,[10896,10897,10898],false],[0,0,0,"codecs",null,"",null,false],[0,0,0,"expected_decoded",null,"",null,false],[0,0,0,"encoded",null,"",null,false],[79,433,0,null,null,null,[10900,10901,10902],false],[0,0,0,"codecs",null,"",null,false],[0,0,0,"encoded",null,"",null,false],[0,0,0,"expected_err",null,"",null,false],[79,448,0,null,null,null,[10904,10905],false],[0,0,0,"codecs",null,"",null,false],[0,0,0,"encoded",null,"",null,false],[0,55,0,null,null,null,null,false],[0,0,0,"bit_set.zig",null," This file defines several variants of bit sets.  A bit set\n is a densely stored set of integers with a known maximum,\n in which each integer gets a single bit.  Bit sets have very\n fast presence checks, update operations, and union and intersection\n operations.  However, if the number of possible items is very\n large and the number of actual items in a given set is usually\n small, they may be less memory efficient than an array set.\n\n There are five variants defined here:\n\n IntegerBitSet:\n   A bit set with static size, which is backed by a single integer.\n   This set is good for sets with a small size, but may generate\n   inefficient code for larger sets, especially in debug mode.\n\n ArrayBitSet:\n   A bit set with static size, which is backed by an array of usize.\n   This set is good for sets with a larger size, but may use\n   more bytes than necessary if your set is small.\n\n StaticBitSet:\n   Picks either IntegerBitSet or ArrayBitSet depending on the requested\n   size.  The interfaces of these two types match exactly, except for fields.\n\n DynamicBitSet:\n   A bit set with runtime-known size, backed by an allocated slice\n   of usize.\n\n DynamicBitSetUnmanaged:\n   A variant of DynamicBitSet which does not store a pointer to its\n   allocator, in order to save space.\n",[],false],[80,32,0,null,null,null,null,false],[80,33,0,null,null,null,null,false],[80,34,0,null,null,null,null,false],[80,41,0,null,null," Returns the optimal static bit set type for the specified number\n of elements: either `IntegerBitSet` or `ArrayBitSet`,\n both of which fulfill the same interface.\n The returned type will perform no allocations,\n can be copied by value, and does not require deinitialization.",[10912],false],[0,0,0,"size",null,"",null,true],[80,52,0,null,null," A bit set with static size, which is backed by a single integer.\n This set is good for sets with a small size, but may generate\n inefficient code for larger sets, especially in debug mode.",[10914],false],[0,0,0,"size",null,"",[11001],true],[80,54,0,null,null,null,null,false],[80,58,0,null,null," The number of items in this bit set",null,false],[80,61,0,null,null," The integer type used to represent a mask in this bit set",null,false],[80,64,0,null,null," The integer type used to shift a mask in this bit set",null,false],[80,70,0,null,null," Creates a bit set with no elements present.",[],false],[80,75,0,null,null," Creates a bit set with all elements present.",[],false],[80,80,0,null,null," Returns the number of bits in this bit set",[10922],false],[0,0,0,"self",null,"",null,false],[80,87,0,null,null," Returns true if the bit at the specified index\n is present in the set, false otherwise.",[10924,10925],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,93,0,null,null," Returns the total number of set bits in this bit set.",[10927],false],[0,0,0,"self",null,"",null,false],[80,99,0,null,null," Changes the value of the specified bit of the bit\n set to match the passed boolean.",[10929,10930,10931],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,108,0,null,null," Adds a specific bit to the bit set",[10933,10934],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,115,0,null,null," Changes the value of all bits in the specified range to\n match the passed boolean.",[10936,10937,10938],false],[0,0,0,"self",null,"",null,false],[0,0,0,"range",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,139,0,null,null," Removes a specific bit from the bit set",[10940,10941],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,147,0,null,null," Flips a specific bit in the bit set",[10943,10944],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,154,0,null,null," Flips all bits in this bit set which are present\n in the toggles bit set.",[10946,10947],false],[0,0,0,"self",null,"",null,false],[0,0,0,"toggles",null,"",null,false],[80,159,0,null,null," Flips every bit in the bit set.",[10949],false],[0,0,0,"self",null,"",null,false],[80,166,0,null,null," Performs a union of two bit sets, and stores the\n result in the first one.  Bits in the result are\n set if the corresponding bits were set in either input.",[10951,10952],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,173,0,null,null," Performs an intersection of two bit sets, and stores\n the result in the first one.  Bits in the result are\n set if the corresponding bits were set in both inputs.",[10954,10955],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,179,0,null,null," Finds the index of the first set bit.\n If no bits are set, returns null.",[10957],false],[0,0,0,"self",null,"",null,false],[80,187,0,null,null," Finds the index of the first set bit, and unsets it.\n If no bits are set, returns null.",[10959],false],[0,0,0,"self",null,"",null,false],[80,197,0,null,null," Returns true iff every corresponding bit in both\n bit sets are the same.",[10961,10962],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,203,0,null,null," Returns true iff the first bit set is the subset\n of the second one.",[10964,10965],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,209,0,null,null," Returns true iff the first bit set is the superset\n of the second one.",[10967,10968],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,215,0,null,null," Returns the complement bit sets. Bits in the result\n are set if the corresponding bits were not set.",[10970],false],[0,0,0,"self",null,"",null,false],[80,224,0,null,null," Returns the union of two bit sets. Bits in the\n result are set if the corresponding bits were set\n in either input.",[10972,10973],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,233,0,null,null," Returns the intersection of two bit sets. Bits in\n the result are set if the corresponding bits were\n set in both inputs.",[10975,10976],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,242,0,null,null," Returns the xor of two bit sets. Bits in the\n result are set if the corresponding bits were\n not the same in both inputs.",[10978,10979],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,251,0,null,null," Returns the difference of two bit sets. Bits in\n the result are set if set in the first but not\n set in the second set.",[10981,10982],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,261,0,null,null," Iterates through the items in the set, according to the options.\n The default options (.{}) will iterate indices of set bits in\n ascending order.  Modifications to the underlying bit set may\n or may not be observed by the iterator.",[10984,10985],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,true],[80,270,0,null,null,null,[10987],false],[0,0,0,"options",null,"",null,true],[80,274,0,null,null,null,[10989],false],[0,0,0,"direction",null,"",[10994],true],[80,276,0,null,null,null,null,false],[80,282,0,null,null," Returns the index of the next unvisited set bit\n in the bit set, in ascending order.",[10992],false],[0,0,0,"self",null,"",null,false],[80,275,0,null,null,null,null,false],[0,0,0,"bits_remain",null,null,null,false],[80,302,0,null,null,null,[10996],false],[0,0,0,"index",null,"",null,false],[80,306,0,null,null,null,[10998,10999],false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,53,0,null,null,null,null,false],[0,0,0,"mask",null," The bit mask, as a single integer",null,false],[80,316,0,null,null," A bit set with static size, which is backed by an array of usize.\n This set is good for sets with a larger size, but may use\n more bytes than necessary if your set is small.",[11003,11004],false],[0,0,0,"MaskIntType",null,"",null,true],[0,0,0,"size",null,"",[11090],true],[80,353,0,null,null,null,null,false],[80,357,0,null,null," The number of items in this bit set",null,false],[80,360,0,null,null," The integer type used to represent a mask in this bit set",null,false],[80,363,0,null,null," The integer type used to shift a mask in this bit set",null,false],[80,366,0,null,null,null,null,false],[80,368,0,null,null,null,null,false],[80,370,0,null,null,null,null,false],[80,374,0,null,null,null,null,false],[80,381,0,null,null," Creates a bit set with no elements present.",[],false],[80,386,0,null,null," Creates a bit set with all elements present.",[],false],[80,395,0,null,null," Returns the number of bits in this bit set",[11016],false],[0,0,0,"self",null,"",null,false],[80,402,0,null,null," Returns true if the bit at the specified index\n is present in the set, false otherwise.",[11018,11019],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,409,0,null,null," Returns the total number of set bits in this bit set.",[11021],false],[0,0,0,"self",null,"",null,false],[80,419,0,null,null," Changes the value of the specified bit of the bit\n set to match the passed boolean.",[11023,11024,11025],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,429,0,null,null," Adds a specific bit to the bit set",[11027,11028],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,437,0,null,null," Changes the value of all bits in the specified range to\n match the passed boolean.",[11030,11031,11032],false],[0,0,0,"self",null,"",null,false],[0,0,0,"range",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,481,0,null,null," Removes a specific bit from the bit set",[11034,11035],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,488,0,null,null," Flips a specific bit in the bit set",[11037,11038],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,496,0,null,null," Flips all bits in this bit set which are present\n in the toggles bit set.",[11040,11041],false],[0,0,0,"self",null,"",null,false],[0,0,0,"toggles",null,"",null,false],[80,503,0,null,null," Flips every bit in the bit set.",[11043],false],[0,0,0,"self",null,"",null,false],[80,517,0,null,null," Performs a union of two bit sets, and stores the\n result in the first one.  Bits in the result are\n set if the corresponding bits were set in either input.",[11045,11046],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,526,0,null,null," Performs an intersection of two bit sets, and stores\n the result in the first one.  Bits in the result are\n set if the corresponding bits were set in both inputs.",[11048,11049],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,534,0,null,null," Finds the index of the first set bit.\n If no bits are set, returns null.",[11051],false],[0,0,0,"self",null,"",null,false],[80,545,0,null,null," Finds the index of the first set bit, and unsets it.\n If no bits are set, returns null.",[11053],false],[0,0,0,"self",null,"",null,false],[80,558,0,null,null," Returns true iff every corresponding bit in both\n bit sets are the same.",[11055,11056],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,569,0,null,null," Returns true iff the first bit set is the subset\n of the second one.",[11058,11059],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,575,0,null,null," Returns true iff the first bit set is the superset\n of the second one.",[11061,11062],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,581,0,null,null," Returns the complement bit sets. Bits in the result\n are set if the corresponding bits were not set.",[11064],false],[0,0,0,"self",null,"",null,false],[80,590,0,null,null," Returns the union of two bit sets. Bits in the\n result are set if the corresponding bits were set\n in either input.",[11066,11067],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,599,0,null,null," Returns the intersection of two bit sets. Bits in\n the result are set if the corresponding bits were\n set in both inputs.",[11069,11070],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,608,0,null,null," Returns the xor of two bit sets. Bits in the\n result are set if the corresponding bits were\n not the same in both inputs.",[11072,11073],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,617,0,null,null," Returns the difference of two bit sets. Bits in\n the result are set if set in the first but not\n set in the second set.",[11075,11076],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,627,0,null,null," Iterates through the items in the set, according to the options.\n The default options (.{}) will iterate indices of set bits in\n ascending order.  Modifications to the underlying bit set may\n or may not be observed by the iterator.",[11078,11079],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,true],[80,631,0,null,null,null,[11081],false],[0,0,0,"options",null,"",null,true],[80,635,0,null,null,null,[11083],false],[0,0,0,"index",null,"",null,false],[80,638,0,null,null,null,[11085],false],[0,0,0,"index",null,"",null,false],[80,641,0,null,null,null,[11087,11088],false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,352,0,null,null,null,null,false],[0,0,0,"masks",null," The bit masks, ordered with lower indices first.\n Padding bits at the end are undefined.",null,false],[80,649,0,null,null," A bit set with runtime-known size, backed by an allocated slice\n of usize.  The allocator must be tracked externally by the user.",[11176,11178],false],[80,650,0,null,null,null,null,false],[80,653,0,null,null," The integer type used to represent a mask in this bit set",null,false],[80,656,0,null,null," The integer type used to shift a mask in this bit set",null,false],[80,673,0,null,null,null,null,false],[80,674,0,null,null,null,null,false],[80,678,0,null,null," Creates a bit set with no elements present.\n If bit_length is not zero, deinit must eventually be called.",[11098,11099],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"bit_length",null,"",null,false],[80,686,0,null,null," Creates a bit set with all elements present.\n If bit_length is not zero, deinit must eventually be called.",[11101,11102],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"bit_length",null,"",null,false],[80,695,0,null,null," Resizes to a new bit_length.  If the new length is larger\n than the old length, fills any added bits with `fill`.\n If new_len is not zero, deinit must eventually be called.",[11104,11105,11106,11107],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"fill",null,"",null,false],[80,758,0,null,null," deinitializes the array and releases its memory.\n The passed allocator must be the same one used for\n init* or resize in the past.",[11109,11110],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[80,763,0,null,null," Creates a duplicate of this bit set, using the new allocator.",[11112,11113],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_allocator",null,"",null,false],[80,772,0,null,null," Returns the number of bits in this bit set",[11115],false],[0,0,0,"self",null,"",null,false],[80,778,0,null,null," Returns true if the bit at the specified index\n is present in the set, false otherwise.",[11117,11118],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,784,0,null,null," Returns the total number of set bits in this bit set.",[11120],false],[0,0,0,"self",null,"",null,false],[80,796,0,null,null," Changes the value of the specified bit of the bit\n set to match the passed boolean.",[11122,11123,11124],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,805,0,null,null," Adds a specific bit to the bit set",[11126,11127],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,812,0,null,null," Changes the value of all bits in the specified range to\n match the passed boolean.",[11129,11130,11131],false],[0,0,0,"self",null,"",null,false],[0,0,0,"range",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,855,0,null,null," Removes a specific bit from the bit set",[11133,11134],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,861,0,null,null," Flips a specific bit in the bit set",[11136,11137],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,869,0,null,null," Flips all bits in this bit set which are present\n in the toggles bit set.  Both sets must have the\n same bit_length.",[11139,11140],false],[0,0,0,"self",null,"",null,false],[0,0,0,"toggles",null,"",null,false],[80,878,0,null,null," Flips every bit in the bit set.",[11142],false],[0,0,0,"self",null,"",null,false],[80,897,0,null,null," Performs a union of two bit sets, and stores the\n result in the first one.  Bits in the result are\n set if the corresponding bits were set in either input.\n The two sets must both be the same bit_length.",[11144,11145],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,909,0,null,null," Performs an intersection of two bit sets, and stores\n the result in the first one.  Bits in the result are\n set if the corresponding bits were set in both inputs.\n The two sets must both be the same bit_length.",[11147,11148],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,919,0,null,null," Finds the index of the first set bit.\n If no bits are set, returns null.",[11150],false],[0,0,0,"self",null,"",null,false],[80,932,0,null,null," Finds the index of the first set bit, and unsets it.\n If no bits are set, returns null.",[11152],false],[0,0,0,"self",null,"",null,false],[80,947,0,null,null," Returns true iff every corresponding bit in both\n bit sets are the same.",[11154,11155],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,962,0,null,null," Returns true iff the first bit set is the subset\n of the second one.",[11157,11158],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,977,0,null,null," Returns true iff the first bit set is the superset\n of the second one.",[11160,11161],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,995,0,null,null," Iterates through the items in the set, according to the options.\n The default options (.{}) will iterate indices of set bits in\n ascending order.  Modifications to the underlying bit set may\n or may not be observed by the iterator.  Resizing the underlying\n bit set invalidates the iterator.",[11163,11164],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,true],[80,1002,0,null,null,null,[11166],false],[0,0,0,"options",null,"",null,true],[80,1006,0,null,null,null,[11168],false],[0,0,0,"index",null,"",null,false],[80,1009,0,null,null,null,[11170],false],[0,0,0,"index",null,"",null,false],[80,1012,0,null,null,null,[11172,11173],false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,1015,0,null,null,null,[11175],false],[0,0,0,"bit_length",null,"",null,false],[0,0,0,"bit_length",null," The number of valid items in this bit set",null,false],[80,649,0,null,null,null,null,false],[0,0,0,"masks",null," The bit masks, ordered with lower indices first.\n Padding bits at the end must be zeroed.",null,false],[80,1023,0,null,null," A bit set with runtime-known size, backed by an allocated slice\n of usize.  Thin wrapper around DynamicBitSetUnmanaged which keeps\n track of the allocator instance.",[11245,11247],false],[80,1024,0,null,null,null,null,false],[80,1027,0,null,null," The integer type used to represent a mask in this bit set",null,false],[80,1030,0,null,null," The integer type used to shift a mask in this bit set",null,false],[80,1039,0,null,null," Creates a bit set with no elements present.",[11184,11185],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"bit_length",null,"",null,false],[80,1047,0,null,null," Creates a bit set with all elements present.",[11187,11188],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"bit_length",null,"",null,false],[80,1056,0,null,null," Resizes to a new length.  If the new length is larger\n than the old length, fills any added bits with `fill`.",[11190,11191,11192],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_len",null,"",null,false],[0,0,0,"fill",null,"",null,false],[80,1063,0,null,null," deinitializes the array and releases its memory.\n The passed allocator must be the same one used for\n init* or resize in the past.",[11194],false],[0,0,0,"self",null,"",null,false],[80,1068,0,null,null," Creates a duplicate of this bit set, using the new allocator.",[11196,11197],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_allocator",null,"",null,false],[80,1076,0,null,null," Returns the number of bits in this bit set",[11199],false],[0,0,0,"self",null,"",null,false],[80,1082,0,null,null," Returns true if the bit at the specified index\n is present in the set, false otherwise.",[11201,11202],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,1087,0,null,null," Returns the total number of set bits in this bit set.",[11204],false],[0,0,0,"self",null,"",null,false],[80,1093,0,null,null," Changes the value of the specified bit of the bit\n set to match the passed boolean.",[11206,11207,11208],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,1098,0,null,null," Adds a specific bit to the bit set",[11210,11211],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,1104,0,null,null," Changes the value of all bits in the specified range to\n match the passed boolean.",[11213,11214,11215],false],[0,0,0,"self",null,"",null,false],[0,0,0,"range",null,"",null,false],[0,0,0,"value",null,"",null,false],[80,1109,0,null,null," Removes a specific bit from the bit set",[11217,11218],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,1114,0,null,null," Flips a specific bit in the bit set",[11220,11221],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[80,1121,0,null,null," Flips all bits in this bit set which are present\n in the toggles bit set.  Both sets must have the\n same bit_length.",[11223,11224],false],[0,0,0,"self",null,"",null,false],[0,0,0,"toggles",null,"",null,false],[80,1126,0,null,null," Flips every bit in the bit set.",[11226],false],[0,0,0,"self",null,"",null,false],[80,1134,0,null,null," Performs a union of two bit sets, and stores the\n result in the first one.  Bits in the result are\n set if the corresponding bits were set in either input.\n The two sets must both be the same bit_length.",[11228,11229],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,1142,0,null,null," Performs an intersection of two bit sets, and stores\n the result in the first one.  Bits in the result are\n set if the corresponding bits were set in both inputs.\n The two sets must both be the same bit_length.",[11231,11232],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,1148,0,null,null," Finds the index of the first set bit.\n If no bits are set, returns null.",[11234],false],[0,0,0,"self",null,"",null,false],[80,1154,0,null,null," Finds the index of the first set bit, and unsets it.\n If no bits are set, returns null.",[11236],false],[0,0,0,"self",null,"",null,false],[80,1160,0,null,null," Returns true iff every corresponding bit in both\n bit sets are the same.",[11238,11239],false],[0,0,0,"self",null,"",null,false],[0,0,0,"other",null,"",null,false],[80,1169,0,null,null," Iterates through the items in the set, according to the options.\n The default options (.{}) will iterate indices of set bits in\n ascending order.  Modifications to the underlying bit set may\n or may not be observed by the iterator.  Resizing the underlying\n bit set invalidates the iterator.",[11241,11242],false],[0,0,0,"self",null,"",null,false],[0,0,0,"options",null,"",null,true],[80,1173,0,null,null,null,null,false],[80,1023,0,null,null,null,null,false],[0,0,0,"allocator",null," The allocator used by this bit set",null,false],[80,1023,0,null,null,null,null,false],[0,0,0,"unmanaged",null," The number of valid items in this bit set",null,false],[80,1177,0,null,null," Options for configuring an iterator over a bit set",[11256,11258],false],[80,1183,0,null,null,null,[11250,11251],false],[0,0,0,"set",null," visit indexes of set bits",null,false],[0,0,0,"unset",null," visit indexes of unset bits",null,false],[80,1190,0,null,null,null,[11253,11254],false],[0,0,0,"forward",null," visit indices in ascending order",null,false],[0,0,0,"reverse",null," visit indices in descending order.\n Note that this may be slightly more expensive than forward iteration.",null,false],[80,1177,0,null,null,null,null,false],[0,0,0,"kind",null," determines which bits should be visited",null,false],[80,1177,0,null,null,null,null,false],[0,0,0,"direction",null," determines the order in which bit indices should be visited",null,false],[80,1200,0,null,null,null,[11260,11261],false],[0,0,0,"MaskInt",null,"",null,true],[0,0,0,"options",null,"",[11272,11274,11275,11277],true],[80,1205,0,null,null,null,null,false],[80,1216,0,null,null,null,[11264,11265],false],[0,0,0,"masks",null,"",null,false],[0,0,0,"last_word_mask",null,"",null,false],[80,1238,0,null,null," Returns the index of the next unvisited set bit\n in the bit set, in ascending order.",[11267],false],[0,0,0,"self",null,"",null,false],[80,1268,0,null,null,null,[11269,11270],false],[0,0,0,"self",null,"",null,false],[0,0,0,"is_first_word",null,"",null,true],[80,1204,0,null,null,null,null,false],[0,0,0,"bits_remain",null,null,null,false],[80,1204,0,null,null,null,null,false],[0,0,0,"words_remain",null,null,null,false],[0,0,0,"bit_offset",null,null,null,false],[80,1204,0,null,null,null,null,false],[0,0,0,"last_word_mask",null,null,null,false],[80,1294,0,null,null," A range of indices within a bitset.",[11279,11280],false],[0,0,0,"start",null," The index of the first bit of interest.",null,false],[0,0,0,"end",null," The index immediately after the last bit of interest.",null,false],[80,1303,0,null,null,null,null,false],[80,1305,0,null,null,null,[11283,11284,11285],false],[0,0,0,"empty",null,"",null,false],[0,0,0,"full",null,"",null,false],[0,0,0,"len",null,"",null,false],[80,1320,0,null,null,null,[11287,11288,11289,11290,11291],false],[0,0,0,"empty",null,"",null,false],[0,0,0,"full",null,"",null,false],[0,0,0,"even",null,"",null,false],[0,0,0,"odd",null,"",null,false],[0,0,0,"len",null,"",null,false],[80,1340,0,null,null,null,[11293,11294,11295,11296,11297],false],[0,0,0,"empty",null,"",null,false],[0,0,0,"full",null,"",null,false],[0,0,0,"even",null,"",null,false],[0,0,0,"odd",null,"",null,false],[0,0,0,"len",null,"",null,false],[80,1360,0,null,null,null,[11299,11300,11301],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"len",null,"",null,false],[80,1558,0,null,null,null,[11303,11304],false],[0,0,0,"set",null,"",null,false],[0,0,0,"len",null,"",null,false],[80,1565,0,null,null,null,[11306,11307],false],[0,0,0,"set",null,"",null,false],[0,0,0,"len",null,"",null,false],[80,1572,0,null,null,null,[11309],false],[0,0,0,"Set",null,"",null,true],[80,1625,0,null,null,null,[11311],false],[0,0,0,"Set",null,"",null,true],[0,56,0,null,null,null,null,false],[0,0,0,"builtin.zig",null,"",[],false],[81,0,0,null,null,null,null,false],[81,6,0,null,null," `explicit_subsystem` is missing when the subsystem is automatically detected,\n so Zig standard library has the subsystem detection logic here. This should generally be\n used rather than `explicit_subsystem`.\n On non-Windows targets, this is `null`.",null,false],[81,30,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11322,11324],false],[81,34,0,null,null,null,[11318,11319,11320,11321],false],[0,0,0,"self",null,"",null,false],[0,0,0,"fmt",null,"",null,true],[0,0,0,"options",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"index",null,null,null,false],[81,30,0,null,null,null,null,false],[0,0,0,"instruction_addresses",null,null,null,false],[81,63,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11326,11327,11328,11329],false],[0,0,0,"Internal",null,null,null,false],[0,0,0,"Strong",null,null,null,false],[0,0,0,"Weak",null,null,null,false],[0,0,0,"LinkOnce",null,null,null,false],[81,72,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11331,11332,11333],false],[0,0,0,"default",null,null,null,false],[0,0,0,"hidden",null,null,null,false],[0,0,0,"protected",null,null,null,false],[81,80,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11335,11336,11337,11338,11339,11340],false],[0,0,0,"Unordered",null,null,null,false],[0,0,0,"Monotonic",null,null,null,false],[0,0,0,"Acquire",null,null,null,false],[0,0,0,"Release",null,null,null,false],[0,0,0,"AcqRel",null,null,null,false],[0,0,0,"SeqCst",null,null,null,false],[81,91,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11342,11343,11344,11345,11346,11347,11348],false],[0,0,0,"And",null,null,null,false],[0,0,0,"Or",null,null,null,false],[0,0,0,"Xor",null,null,null,false],[0,0,0,"Min",null,null,null,false],[0,0,0,"Max",null,null,null,false],[0,0,0,"Add",null,null,null,false],[0,0,0,"Mul",null,null,null,false],[81,103,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11350,11351,11352,11353,11354,11355,11356,11357,11358],false],[0,0,0,"Xchg",null,null,null,false],[0,0,0,"Add",null,null,null,false],[0,0,0,"Sub",null,null,null,false],[0,0,0,"And",null,null,null,false],[0,0,0,"Nand",null,null,null,false],[0,0,0,"Or",null,null,null,false],[0,0,0,"Xor",null,null,null,false],[0,0,0,"Max",null,null,null,false],[0,0,0,"Min",null,null,null,false],[81,121,0,null,null," The code model puts constraints on the location of symbols and the size of code and data.\n The selection of a code model is a trade off on speed and restrictions that needs to be selected on a per application basis to meet its requirements.\n A slightly more detailed explanation can be found in (for example) the [System V Application Binary Interface (x86_64)](https://github.com/hjl-tools/x86-psABI/wiki/x86-64-psABI-1.0.pdf) 3.5.1.\n\n This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11360,11361,11362,11363,11364,11365],false],[0,0,0,"default",null,null,null,false],[0,0,0,"tiny",null,null,null,false],[0,0,0,"small",null,null,null,false],[0,0,0,"kernel",null,null,null,false],[0,0,0,"medium",null,null,null,false],[0,0,0,"large",null,null,null,false],[81,132,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11367,11368,11369,11370],false],[0,0,0,"Debug",null,null,null,false],[0,0,0,"ReleaseSafe",null,null,null,false],[0,0,0,"ReleaseFast",null,null,null,false],[0,0,0,"ReleaseSmall",null,null,null,false],[81,140,0,null,null," Deprecated; use OptimizeMode.",null,false],[81,144,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11373,11374,11375,11376,11377,11378,11379,11380,11381,11382,11383,11384,11385,11386,11387,11388,11389],false],[0,0,0,"Unspecified",null," This is the default Zig calling convention used when not using `export` on `fn`\n and no other calling convention is specified.",null,false],[0,0,0,"C",null," Matches the C ABI for the target.\n This is the default calling convention when using `export` on `fn`\n and no other calling convention is specified.",null,false],[0,0,0,"Naked",null," This makes a function not have any function prologue or epilogue,\n making the function itself uncallable in regular Zig code.\n This can be useful when integrating with assembly.",null,false],[0,0,0,"Async",null," Functions with this calling convention are called asynchronously,\n as if called as `async function()`.",null,false],[0,0,0,"Inline",null," Functions with this calling convention are inlined at all call sites.",null,false],[0,0,0,"Interrupt",null," x86-only.",null,false],[0,0,0,"Signal",null,null,null,false],[0,0,0,"Stdcall",null," x86-only.",null,false],[0,0,0,"Fastcall",null," x86-only.",null,false],[0,0,0,"Vectorcall",null," x86-only.",null,false],[0,0,0,"Thiscall",null," x86-only.",null,false],[0,0,0,"APCS",null," ARM Procedure Call Standard (obsolete)\n ARM-only.",null,false],[0,0,0,"AAPCS",null," ARM Architecture Procedure Call Standard (current standard)\n ARM-only.",null,false],[0,0,0,"AAPCSVFP",null," ARM Architecture Procedure Call Standard Vector Floating-Point\n ARM-only.",null,false],[0,0,0,"SysV",null," x86-64-only.",null,false],[0,0,0,"Win64",null," x86-64-only.",null,false],[0,0,0,"Kernel",null," AMD GPU, NVPTX, or SPIR-V kernel",null,false],[81,191,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11391,11392,11393,11394,11395,11396,11397,11398,11399,11400,11401,11402,11403,11404,11405],false],[0,0,0,"generic",null,null,null,false],[0,0,0,"gs",null,null,null,false],[0,0,0,"fs",null,null,null,false],[0,0,0,"ss",null,null,null,false],[0,0,0,"global",null,null,null,false],[0,0,0,"constant",null,null,null,false],[0,0,0,"param",null,null,null,false],[0,0,0,"shared",null,null,null,false],[0,0,0,"local",null,null,null,false],[0,0,0,"flash",null,null,null,false],[0,0,0,"flash1",null,null,null,false],[0,0,0,"flash2",null,null,null,false],[0,0,0,"flash3",null,null,null,false],[0,0,0,"flash4",null,null,null,false],[0,0,0,"flash5",null,null,null,false],[81,216,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11408,11410,11411,11412],false],[81,216,0,null,null,null,null,false],[0,0,0,"file",null,null,null,false],[81,216,0,null,null,null,null,false],[0,0,0,"fn_name",null,null,null,false],[0,0,0,"line",null,null,null,false],[0,0,0,"column",null,null,null,false],[81,223,0,null,null,null,null,false],[81,227,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11529,11530,11531,11532,11533,11534,11535,11536,11537,11538,11539,11540,11541,11542,11543,11544,11545,11546,11547,11548,11549,11550,11551,11552],false],[81,255,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11417,11418],false],[81,255,0,null,null,null,null,false],[0,0,0,"signedness",null,null,null,false],[0,0,0,"bits",null,null,null,false],[81,262,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11420],false],[0,0,0,"bits",null,null,null,false],[81,268,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11428,11429,11430,11431,11433,11434,11435,11437],false],[81,285,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11423,11424,11425,11426],false],[0,0,0,"One",null,null,null,false],[0,0,0,"Many",null,null,null,false],[0,0,0,"Slice",null,null,null,false],[0,0,0,"C",null,null,null,false],[81,268,0,null,null,null,null,false],[0,0,0,"size",null,null,null,false],[0,0,0,"is_const",null,null,null,false],[0,0,0,"is_volatile",null,null,null,false],[0,0,0,"alignment",null," TODO make this u16 instead of comptime_int",null,false],[81,268,0,null,null,null,null,false],[0,0,0,"address_space",null,null,null,false],[0,0,0,"child",null,null,null,false],[0,0,0,"is_allowzero",null,null,null,false],[81,268,0,null,null,null,null,false],[0,0,0,"sentinel",null," The type of the sentinel is the element type of the pointer, which is\n the value of the `child` field in this struct. However there is no way\n to refer to that type here, so we use pointer to `anyopaque`.",null,false],[81,295,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11439,11440,11442],false],[0,0,0,"len",null,null,null,false],[0,0,0,"child",null,null,null,false],[81,295,0,null,null,null,null,false],[0,0,0,"sentinel",null," The type of the sentinel is the element type of the array, which is\n the value of the `child` field in this struct. However there is no way\n to refer to that type here, so we use pointer to `anyopaque`.",null,false],[81,307,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11444,11445,11446],false],[0,0,0,"Auto",null,null,null,false],[0,0,0,"Extern",null,null,null,false],[0,0,0,"Packed",null,null,null,false],[81,315,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11449,11450,11452,11453,11454],false],[81,315,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"type",null,null,null,false],[81,315,0,null,null,null,null,false],[0,0,0,"default_value",null,null,null,false],[0,0,0,"is_comptime",null,null,null,false],[0,0,0,"alignment",null,null,null,false],[81,325,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11457,11459,11461,11463,11464],false],[81,325,0,null,null,null,null,false],[0,0,0,"layout",null,null,null,false],[81,325,0,null,null,null,null,false],[0,0,0,"backing_integer",null," Only valid if layout is .Packed",null,false],[81,325,0,null,null,null,null,false],[0,0,0,"fields",null,null,null,false],[81,325,0,null,null,null,null,false],[0,0,0,"decls",null,null,null,false],[0,0,0,"is_tuple",null,null,null,false],[81,336,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11466],false],[0,0,0,"child",null,null,null,false],[81,342,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11468,11469],false],[0,0,0,"error_set",null,null,null,false],[0,0,0,"payload",null,null,null,false],[81,349,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11472],false],[81,349,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[81,355,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",null,false],[81,359,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11476,11477],false],[81,359,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"value",null,null,null,false],[81,366,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11479,11481,11483,11484],false],[0,0,0,"tag_type",null,null,null,false],[81,366,0,null,null,null,null,false],[0,0,0,"fields",null,null,null,false],[81,366,0,null,null,null,null,false],[0,0,0,"decls",null,null,null,false],[0,0,0,"is_exhaustive",null,null,null,false],[81,375,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11487,11488,11489],false],[81,375,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"type",null,null,null,false],[0,0,0,"alignment",null,null,null,false],[81,383,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11492,11494,11496,11498],false],[81,383,0,null,null,null,null,false],[0,0,0,"layout",null,null,null,false],[81,383,0,null,null,null,null,false],[0,0,0,"tag_type",null,null,null,false],[81,383,0,null,null,null,null,false],[0,0,0,"fields",null,null,null,false],[81,383,0,null,null,null,null,false],[0,0,0,"decls",null,null,null,false],[81,392,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11506,11507,11508,11509,11511,11513],false],[81,403,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11501,11502,11504],false],[0,0,0,"is_generic",null,null,null,false],[0,0,0,"is_noalias",null,null,null,false],[81,403,0,null,null,null,null,false],[0,0,0,"type",null,null,null,false],[81,392,0,null,null,null,null,false],[0,0,0,"calling_convention",null,null,null,false],[0,0,0,"alignment",null,null,null,false],[0,0,0,"is_generic",null,null,null,false],[0,0,0,"is_var_args",null,null,null,false],[81,392,0,null,null,null,null,false],[0,0,0,"return_type",null," TODO change the language spec to make this not optional.",null,false],[81,392,0,null,null,null,null,false],[0,0,0,"params",null,null,null,false],[81,412,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11516],false],[81,412,0,null,null,null,null,false],[0,0,0,"decls",null,null,null,false],[81,418,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11519],false],[81,418,0,null,null,null,null,false],[0,0,0,"function",null,null,null,false],[81,424,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11522],false],[81,424,0,null,null,null,null,false],[0,0,0,"child",null,null,null,false],[81,430,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11524,11525],false],[0,0,0,"len",null,null,null,false],[0,0,0,"child",null,null,null,false],[81,437,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11528],false],[81,437,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"Type",null,null,null,false],[0,0,0,"Void",null,null,null,false],[0,0,0,"Bool",null,null,null,false],[0,0,0,"NoReturn",null,null,null,false],[0,0,0,"Int",null,null,null,false],[0,0,0,"Float",null,null,null,false],[0,0,0,"Pointer",null,null,null,false],[0,0,0,"Array",null,null,null,false],[0,0,0,"Struct",null,null,null,false],[0,0,0,"ComptimeFloat",null,null,null,false],[0,0,0,"ComptimeInt",null,null,null,false],[0,0,0,"Undefined",null,null,null,false],[0,0,0,"Null",null,null,null,false],[0,0,0,"Optional",null,null,null,false],[0,0,0,"ErrorUnion",null,null,null,false],[0,0,0,"ErrorSet",null,null,null,false],[0,0,0,"Enum",null,null,null,false],[0,0,0,"Union",null,null,null,false],[0,0,0,"Fn",null,null,null,false],[0,0,0,"Opaque",null,null,null,false],[0,0,0,"Frame",null,null,null,false],[0,0,0,"AnyFrame",null,null,null,false],[0,0,0,"Vector",null,null,null,false],[0,0,0,"EnumLiteral",null,null,null,false],[81,444,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11554,11555],false],[0,0,0,"Strict",null,null,null,false],[0,0,0,"Optimized",null,null,null,false],[81,451,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11557,11558],false],[0,0,0,"Big",null,null,null,false],[0,0,0,"Little",null,null,null,false],[81,458,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11560,11561],false],[0,0,0,"signed",null,null,null,false],[0,0,0,"unsigned",null,null,null,false],[81,465,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11563,11564,11565],false],[0,0,0,"Exe",null,null,null,false],[0,0,0,"Lib",null,null,null,false],[0,0,0,"Obj",null,null,null,false],[81,473,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11567,11568],false],[0,0,0,"Static",null,null,null,false],[0,0,0,"Dynamic",null,null,null,false],[81,480,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11570,11571],false],[0,0,0,"command",null,null,null,false],[0,0,0,"reactor",null,null,null,false],[81,487,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11573,11574,11575,11576,11577,11578,11579,11580],false],[0,0,0,"auto",null," Equivalent to function call syntax.",null,false],[0,0,0,"async_kw",null," Equivalent to async keyword used with function call syntax.",null,false],[0,0,0,"never_tail",null," Prevents tail call optimization. This guarantees that the return\n address will point to the callsite, as opposed to the callsite's\n callsite. If the call is otherwise required to be tail-called\n or inlined, a compile error is emitted instead.",null,false],[0,0,0,"never_inline",null," Guarantees that the call will not be inlined. If the call is\n otherwise required to be inlined, a compile error is emitted instead.",null,false],[0,0,0,"no_async",null," Asserts that the function call will not suspend. This allows a\n non-async function to call an async function.",null,false],[0,0,0,"always_tail",null," Guarantees that the call will be generated with tail call optimization.\n If this is not possible, a compile error is emitted instead.",null,false],[0,0,0,"always_inline",null," Guarantees that the call will be inlined at the callsite.\n If this is not possible, a compile error is emitted instead.",null,false],[0,0,0,"compile_time",null," Evaluates the call at compile-time. If the call cannot be completed at\n compile-time, a compile error is emitted instead.",null,false],[81,523,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11583,11585,11587,11588,11589],false],[81,523,0,null,null,null,null,false],[0,0,0,"__stack",null,null,null,false],[81,523,0,null,null,null,null,false],[0,0,0,"__gr_top",null,null,null,false],[81,523,0,null,null,null,null,false],[0,0,0,"__vr_top",null,null,null,false],[0,0,0,"__gr_offs",null,null,null,false],[0,0,0,"__vr_offs",null,null,null,false],[81,533,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11591,11592,11594,11596],false],[0,0,0,"__gpr",null,null,null,false],[0,0,0,"__fpr",null,null,null,false],[81,533,0,null,null,null,null,false],[0,0,0,"__overflow_arg_area",null,null,null,false],[81,533,0,null,null,null,null,false],[0,0,0,"__reg_save_area",null,null,null,false],[81,542,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11598,11599,11600,11602,11604],false],[0,0,0,"gpr",null,null,null,false],[0,0,0,"fpr",null,null,null,false],[0,0,0,"reserved",null,null,null,false],[81,542,0,null,null,null,null,false],[0,0,0,"overflow_arg_area",null,null,null,false],[81,542,0,null,null,null,null,false],[0,0,0,"reg_save_area",null,null,null,false],[81,552,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11607,11609,11611],false],[81,552,0,null,null,null,null,false],[0,0,0,"__current_saved_reg_area_pointer",null,null,null,false],[81,552,0,null,null,null,null,false],[0,0,0,"__saved_reg_area_end_pointer",null,null,null,false],[81,552,0,null,null,null,null,false],[0,0,0,"__overflow_area_pointer",null,null,null,false],[81,560,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11613,11614,11616,11618],false],[0,0,0,"gp_offset",null,null,null,false],[0,0,0,"fp_offset",null,null,null,false],[81,560,0,null,null,null,null,false],[0,0,0,"overflow_arg_area",null,null,null,false],[81,560,0,null,null,null,null,false],[0,0,0,"reg_save_area",null,null,null,false],[81,569,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",null,false],[81,604,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11628,11630,11632],false],[81,618,0,null,null,null,[11622,11623],false],[0,0,0,"read",null,null,null,false],[0,0,0,"write",null,null,null,false],[81,623,0,null,null,null,[11625,11626],false],[0,0,0,"instruction",null,null,null,false],[0,0,0,"data",null,null,null,false],[81,604,0,null,null,null,null,false],[0,0,0,"rw",null," Whether the prefetch should prepare for a read or a write.",null,false],[81,604,0,null,null,null,null,false],[0,0,0,"locality",null," The data's locality in an inclusive range from 0 to 3.\n\n 0 means no temporal locality. That is, the data can be immediately\n dropped from the cache after it is accessed.\n\n 3 means high temporal locality. That is, the data should be kept in\n the cache as it is likely to be accessed again soon.",null,false],[81,604,0,null,null,null,null,false],[0,0,0,"cache",null," The cache that the prefetch should be performed on.",null,false],[81,631,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11635,11637,11639,11641],false],[81,631,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[81,631,0,null,null,null,null,false],[0,0,0,"linkage",null,null,null,false],[81,631,0,null,null,null,null,false],[0,0,0,"section",null,null,null,false],[81,631,0,null,null,null,null,false],[0,0,0,"visibility",null,null,null,false],[81,640,0,null,null," This data structure is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11644,11646,11648,11649],false],[81,640,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[81,640,0,null,null,null,null,false],[0,0,0,"library_name",null,null,null,false],[81,640,0,null,null,null,null,false],[0,0,0,"linkage",null,null,null,false],[0,0,0,"is_thread_local",null,null,null,false],[81,664,0,null,null," This enum is set by the compiler and communicates which compiler backend is\n used to produce machine code.\n Think carefully before deciding to observe this value. Nearly all code should\n be agnostic to the backend that implements the language. The use case\n to use this value is to **work around problems with compiler implementations.**\n\n Avoid failing the compilation if the compiler backend does not match a\n whitelist of backends; rather one should detect that a known problem would\n occur in a blacklist of backends.\n\n The enum is nonexhaustive so that alternate Zig language implementations may\n choose a number as their tag (please use a random number generator rather\n than a \"cute\" number) and codebases can interact with these values even if\n this upstream enum does not have a name for the number. Of course, upstream\n is happy to accept pull requests to add Zig implementations to this enum.\n\n This data structure is part of the Zig language specification.",[11651,11652,11653,11654,11655,11656,11657,11658,11659,11660,11661,11662],false],[0,0,0,"other",null," It is allowed for a compiler implementation to not reveal its identity,\n in which case this value is appropriate. Be cool and make sure your\n code supports `other` Zig compilers!",null,false],[0,0,0,"stage1",null," The original Zig compiler created in 2015 by Andrew Kelley. Implemented\n in C++. Used LLVM. Deleted from the ZSF ziglang/zig codebase on\n December 6th, 2022.",null,false],[0,0,0,"stage2_llvm",null," The reference implementation self-hosted compiler of Zig, using the\n LLVM backend.",null,false],[0,0,0,"stage2_c",null," The reference implementation self-hosted compiler of Zig, using the\n backend that generates C source code.\n Note that one can observe whether the compilation will output C code\n directly with `object_format` value rather than the `compiler_backend` value.",null,false],[0,0,0,"stage2_wasm",null," The reference implementation self-hosted compiler of Zig, using the\n WebAssembly backend.",null,false],[0,0,0,"stage2_arm",null," The reference implementation self-hosted compiler of Zig, using the\n arm backend.",null,false],[0,0,0,"stage2_x86_64",null," The reference implementation self-hosted compiler of Zig, using the\n x86_64 backend.",null,false],[0,0,0,"stage2_aarch64",null," The reference implementation self-hosted compiler of Zig, using the\n aarch64 backend.",null,false],[0,0,0,"stage2_x86",null," The reference implementation self-hosted compiler of Zig, using the\n x86 backend.",null,false],[0,0,0,"stage2_riscv64",null," The reference implementation self-hosted compiler of Zig, using the\n riscv64 backend.",null,false],[0,0,0,"stage2_sparc64",null," The reference implementation self-hosted compiler of Zig, using the\n sparc64 backend.",null,false],[0,0,0,"stage2_spirv64",null," The reference implementation self-hosted compiler of Zig, using the\n spirv backend.",null,false],[81,711,0,null,null," This function type is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11665,11667,11669],false],[81,711,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[81,711,0,null,null,null,[],false],[0,0,0,"func",null,null,null,false],[81,711,0,null,null,null,null,false],[0,0,0,"async_frame_size",null,null,null,false],[81,719,0,null,null," This function type is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11671,11672,11673],false],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[81,723,0,null,null," This function is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",null,false],[81,732,0,null,null," This function is used by the Zig language code generation and\n therefore must be kept in sync with the compiler implementation.",[11676,11677,11678],false],[0,0,0,"msg",null,"",null,false],[0,0,0,"error_return_trace",null,"",null,false],[0,0,0,"ret_addr",null,"",null,false],[81,817,0,null,null,null,[11680,11681],false],[0,0,0,"expected",null,"",null,false],[0,0,0,"actual",null,"",null,false],[81,823,0,null,null,null,[11683,11684],false],[0,0,0,"expected",null,"",null,false],[0,0,0,"actual",null,"",null,false],[81,828,0,null,null,null,[11686,11687],false],[0,0,0,"st",null,"",null,false],[0,0,0,"err",null,"",null,false],[81,833,0,null,null,null,[11689,11690],false],[0,0,0,"index",null,"",null,false],[0,0,0,"len",null,"",null,false],[81,838,0,null,null,null,[11692,11693],false],[0,0,0,"start",null,"",null,false],[0,0,0,"end",null,"",null,false],[81,843,0,null,null,null,[11695,11696],false],[0,0,0,"active",null,"",null,false],[0,0,0,"wanted",null,"",null,false],[81,848,0,null,null,null,[],false],[81,849,0,null,null,null,null,false],[81,850,0,null,null,null,null,false],[81,851,0,null,null,null,null,false],[81,852,0,null,null,null,null,false],[81,853,0,null,null,null,null,false],[81,854,0,null,null,null,null,false],[81,855,0,null,null,null,null,false],[81,856,0,null,null,null,null,false],[81,857,0,null,null,null,null,false],[81,858,0,null,null,null,null,false],[81,859,0,null,null,null,null,false],[81,860,0,null,null,null,null,false],[81,861,0,null,null,null,null,false],[81,862,0,null,null,null,null,false],[81,863,0,null,null,null,null,false],[81,864,0,null,null,null,null,false],[81,865,0,null,null,null,null,false],[81,866,0,null,null,null,null,false],[81,867,0,null,null,null,null,false],[81,868,0,null,null,null,null,false],[81,869,0,null,null,null,null,false],[81,870,0,null,null,null,null,false],[81,871,0,null,null,null,null,false],[81,872,0,null,null,null,null,false],[81,873,0,null,null,null,null,false],[81,876,0,null,null,null,[11724],false],[0,0,0,"st",null,"",null,false],[81,882,0,null,null,null,[11726,11727],false],[0,0,0,"st",null,"",null,false],[0,0,0,"addr",null,"",null,false],[81,889,0,null,null,null,null,false],[81,890,0,null,null,null,null,false],[0,0,0,"(root)",null,"",[],false],[82,1,0,null,null,null,null,false],[82,2,0,null,null,null,null,false],[82,3,0,null,null,null,null,false],[82,5,0,null,null,null,[],false],[82,6,0,null,null,null,null,false],[82,7,0,null,null,null,null,false],[82,10,0,null,null,null,null,false],[82,11,0,null,null,null,null,false],[82,12,0,null,null,null,null,false],[82,14,0,null,null,null,[],false],[82,39,0,null,null,null,[],false],[82,127,0,null,null,null,[],false],[82,213,0,null,null,null,[11744,11745,11746,11747],false],[0,0,0,"message_level",null,"",null,true],[0,0,0,"scope",null,"",null,true],[0,0,0,"format",null,"",null,true],[0,0,0,"args",null,"",null,false],[82,232,0,null,null," Simpler main(), exercising fewer language features, so that\n work-in-progress backends can handle it.",[],false],[0,57,0,null,null,null,null,false],[0,0,0,"c.zig",null,"",[],false],[83,41,0,null,null,null,null,false],[83,62,0,null,null,null,null,false],[83,97,0,null,null,null,null,false],[83,105,0,null,null,null,null,false],[83,410,0,null,null,null,null,false],[83,0,0,null,null,null,null,false],[83,1,0,null,null,null,null,false],[83,2,0,null,null,null,null,false],[83,3,0,null,null,null,null,false],[83,4,0,null,null,null,null,false],[83,5,0,null,null,null,null,false],[83,11,0,null,null,null,null,false],[0,0,0,"c/tokenizer.zig",null,"",[],false],[84,0,0,null,null,null,null,false],[84,2,0,null,null,null,[11899,11900,11901],false],[84,7,0,null,null,null,[11771,11772,11773,11774,11775,11776,11777,11778,11779,11780,11781,11782,11783,11784,11785,11786,11787,11788,11789,11790,11791,11792,11793,11794,11795,11796,11797,11798,11799,11800,11801,11802,11803,11804,11805,11806,11807,11808,11809,11810,11811,11812,11813,11814,11815,11816,11817,11818,11819,11820,11821,11822,11823,11824,11825,11826,11827,11828,11829,11830,11831,11832,11833,11834,11835,11836,11837,11838,11839,11840,11841,11842,11843,11844,11845,11846,11847,11848,11849,11850,11851,11852,11853,11854,11855,11856,11857,11858,11859,11860,11861,11862,11863,11864,11865,11866,11867,11868,11869,11870,11871,11872,11873,11874,11875,11876,11877,11878,11879],false],[84,127,0,null,null,null,[11768],false],[0,0,0,"id",null,"",null,false],[84,131,0,null,null,null,[11770],false],[0,0,0,"id",null,"",null,false],[0,0,0,"Invalid",null,null,null,false],[0,0,0,"Eof",null,null,null,false],[0,0,0,"Nl",null,null,null,false],[0,0,0,"Identifier",null,null,null,false],[0,0,0,"MacroString",null," special case for #include <...>",null,false],[0,0,0,"StringLiteral",null,null,null,false],[0,0,0,"CharLiteral",null,null,null,false],[0,0,0,"IntegerLiteral",null,null,null,false],[0,0,0,"FloatLiteral",null,null,null,false],[0,0,0,"Bang",null,null,null,false],[0,0,0,"BangEqual",null,null,null,false],[0,0,0,"Pipe",null,null,null,false],[0,0,0,"PipePipe",null,null,null,false],[0,0,0,"PipeEqual",null,null,null,false],[0,0,0,"Equal",null,null,null,false],[0,0,0,"EqualEqual",null,null,null,false],[0,0,0,"LParen",null,null,null,false],[0,0,0,"RParen",null,null,null,false],[0,0,0,"LBrace",null,null,null,false],[0,0,0,"RBrace",null,null,null,false],[0,0,0,"LBracket",null,null,null,false],[0,0,0,"RBracket",null,null,null,false],[0,0,0,"Period",null,null,null,false],[0,0,0,"Ellipsis",null,null,null,false],[0,0,0,"Caret",null,null,null,false],[0,0,0,"CaretEqual",null,null,null,false],[0,0,0,"Plus",null,null,null,false],[0,0,0,"PlusPlus",null,null,null,false],[0,0,0,"PlusEqual",null,null,null,false],[0,0,0,"Minus",null,null,null,false],[0,0,0,"MinusMinus",null,null,null,false],[0,0,0,"MinusEqual",null,null,null,false],[0,0,0,"Asterisk",null,null,null,false],[0,0,0,"AsteriskEqual",null,null,null,false],[0,0,0,"Percent",null,null,null,false],[0,0,0,"PercentEqual",null,null,null,false],[0,0,0,"Arrow",null,null,null,false],[0,0,0,"Colon",null,null,null,false],[0,0,0,"Semicolon",null,null,null,false],[0,0,0,"Slash",null,null,null,false],[0,0,0,"SlashEqual",null,null,null,false],[0,0,0,"Comma",null,null,null,false],[0,0,0,"Ampersand",null,null,null,false],[0,0,0,"AmpersandAmpersand",null,null,null,false],[0,0,0,"AmpersandEqual",null,null,null,false],[0,0,0,"QuestionMark",null,null,null,false],[0,0,0,"AngleBracketLeft",null,null,null,false],[0,0,0,"AngleBracketLeftEqual",null,null,null,false],[0,0,0,"AngleBracketAngleBracketLeft",null,null,null,false],[0,0,0,"AngleBracketAngleBracketLeftEqual",null,null,null,false],[0,0,0,"AngleBracketRight",null,null,null,false],[0,0,0,"AngleBracketRightEqual",null,null,null,false],[0,0,0,"AngleBracketAngleBracketRight",null,null,null,false],[0,0,0,"AngleBracketAngleBracketRightEqual",null,null,null,false],[0,0,0,"Tilde",null,null,null,false],[0,0,0,"LineComment",null,null,null,false],[0,0,0,"MultiLineComment",null,null,null,false],[0,0,0,"Hash",null,null,null,false],[0,0,0,"HashHash",null,null,null,false],[0,0,0,"Keyword_auto",null,null,null,false],[0,0,0,"Keyword_break",null,null,null,false],[0,0,0,"Keyword_case",null,null,null,false],[0,0,0,"Keyword_char",null,null,null,false],[0,0,0,"Keyword_const",null,null,null,false],[0,0,0,"Keyword_continue",null,null,null,false],[0,0,0,"Keyword_default",null,null,null,false],[0,0,0,"Keyword_do",null,null,null,false],[0,0,0,"Keyword_double",null,null,null,false],[0,0,0,"Keyword_else",null,null,null,false],[0,0,0,"Keyword_enum",null,null,null,false],[0,0,0,"Keyword_extern",null,null,null,false],[0,0,0,"Keyword_float",null,null,null,false],[0,0,0,"Keyword_for",null,null,null,false],[0,0,0,"Keyword_goto",null,null,null,false],[0,0,0,"Keyword_if",null,null,null,false],[0,0,0,"Keyword_int",null,null,null,false],[0,0,0,"Keyword_long",null,null,null,false],[0,0,0,"Keyword_register",null,null,null,false],[0,0,0,"Keyword_return",null,null,null,false],[0,0,0,"Keyword_short",null,null,null,false],[0,0,0,"Keyword_signed",null,null,null,false],[0,0,0,"Keyword_sizeof",null,null,null,false],[0,0,0,"Keyword_static",null,null,null,false],[0,0,0,"Keyword_struct",null,null,null,false],[0,0,0,"Keyword_switch",null,null,null,false],[0,0,0,"Keyword_typedef",null,null,null,false],[0,0,0,"Keyword_union",null,null,null,false],[0,0,0,"Keyword_unsigned",null,null,null,false],[0,0,0,"Keyword_void",null,null,null,false],[0,0,0,"Keyword_volatile",null,null,null,false],[0,0,0,"Keyword_while",null,null,null,false],[0,0,0,"Keyword_bool",null,null,null,false],[0,0,0,"Keyword_complex",null,null,null,false],[0,0,0,"Keyword_imaginary",null,null,null,false],[0,0,0,"Keyword_inline",null,null,null,false],[0,0,0,"Keyword_restrict",null,null,null,false],[0,0,0,"Keyword_alignas",null,null,null,false],[0,0,0,"Keyword_alignof",null,null,null,false],[0,0,0,"Keyword_atomic",null,null,null,false],[0,0,0,"Keyword_generic",null,null,null,false],[0,0,0,"Keyword_noreturn",null,null,null,false],[0,0,0,"Keyword_static_assert",null,null,null,false],[0,0,0,"Keyword_thread_local",null,null,null,false],[0,0,0,"Keyword_include",null,null,null,false],[0,0,0,"Keyword_define",null,null,null,false],[0,0,0,"Keyword_ifdef",null,null,null,false],[0,0,0,"Keyword_ifndef",null,null,null,false],[0,0,0,"Keyword_error",null,null,null,false],[0,0,0,"Keyword_pragma",null,null,null,false],[84,248,0,null,null,null,null,false],[84,308,0,null,null,null,[11882,11883],false],[0,0,0,"bytes",null,"",null,false],[0,0,0,"pp_directive",null,"",null,false],[84,325,0,null,null,null,[11885,11886,11887,11888,11889,11890,11891],false],[0,0,0,"none",null,null,null,false],[0,0,0,"f",null,null,null,false],[0,0,0,"l",null,null,null,false],[0,0,0,"u",null,null,null,false],[0,0,0,"lu",null,null,null,false],[0,0,0,"ll",null,null,null,false],[0,0,0,"llu",null,null,null,false],[84,335,0,null,null,null,[11893,11894,11895,11896,11897],false],[0,0,0,"none",null,null,null,false],[0,0,0,"wide",null,null,null,false],[0,0,0,"utf_8",null,null,null,false],[0,0,0,"utf_16",null,null,null,false],[0,0,0,"utf_32",null,null,null,false],[84,2,0,null,null,null,null,false],[0,0,0,"id",null,null,null,false],[0,0,0,"start",null,null,null,false],[0,0,0,"end",null,null,null,false],[84,344,0,null,null,null,[11906,11907,11909,11910],false],[84,350,0,null,null,null,[11904],false],[0,0,0,"self",null,"",null,false],[84,344,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[0,0,0,"index",null,null,null,false],[84,344,0,null,null,null,null,false],[0,0,0,"prev_tok_id",null,null,null,false],[0,0,0,"pp_directive",null,null,null,false],[84,1572,0,null,null,null,[11912,11913],false],[0,0,0,"source",null,"",null,false],[0,0,0,"expected_tokens",null,"",null,false],[83,12,0,null,null,null,null,false],[83,13,0,null,null,null,null,false],[83,22,0,null,null," The return type is `type` to force comptime function call execution.\n TODO: https://github.com/ziglang/zig/issues/425\n If not linking libc, returns struct{pub const ok = false;}\n If linking musl libc, returns struct{pub const ok = true;}\n If linking gnu libc (glibc), the `ok` value will be true if the target\n version is greater than or equal to `glibc_version`.\n If linking a libc other than these, returns `false`.",[11917],false],[0,0,0,"glibc_version",null,"",[],true],[83,24,0,null,null,null,null,false],[83,59,0,null,null,null,null,false],[83,113,0,null,null,null,[11921],false],[0,0,0,"rc",null,"",null,false],[83,121,0,null,null,null,null,false],[83,123,0,null,null,null,[11924,11925],false],[0,0,0,"filename",null,"",null,false],[0,0,0,"modes",null,"",null,false],[83,124,0,null,null,null,[11927],false],[0,0,0,"stream",null,"",null,false],[83,125,0,null,null,null,[11929,11930,11931,11932],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"size_of_type",null,"",null,false],[0,0,0,"item_count",null,"",null,false],[0,0,0,"stream",null,"",null,false],[83,126,0,null,null,null,[11934,11935,11936,11937],false],[0,0,0,"ptr",null,"",null,false],[0,0,0,"size_of_type",null,"",null,false],[0,0,0,"item_count",null,"",null,false],[0,0,0,"stream",null,"",null,false],[83,128,0,null,null,null,[11939],false],[0,0,0,"format",null,"",null,false],[83,129,0,null,null,null,[],false],[83,130,0,null,null,null,[11942],false],[0,0,0,"code",null,"",null,false],[83,131,0,null,null,null,[11944],false],[0,0,0,"code",null,"",null,false],[83,132,0,null,null,null,[11946],false],[0,0,0,"fd",null,"",null,false],[83,133,0,null,null,null,[11948],false],[0,0,0,"fd",null,"",null,false],[83,134,0,null,null,null,[11950,11951,11952],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"offset",null,"",null,false],[0,0,0,"whence",null,"",null,false],[83,135,0,null,null,null,[11954,11955],false],[0,0,0,"path",null,"",null,false],[0,0,0,"oflag",null,"",null,false],[83,136,0,null,null,null,[11957,11958,11959],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"path",null,"",null,false],[0,0,0,"oflag",null,"",null,false],[83,137,0,null,null,null,[11961,11962],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"length",null,"",null,false],[83,138,0,null,null,null,[11964],false],[0,0,0,"sig",null,"",null,false],[83,139,0,null,null,null,[11966,11967,11968],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"nbyte",null,"",null,false],[83,140,0,null,null,null,[11970,11971,11972],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"iov",null,"",null,false],[0,0,0,"iovcnt",null,"",null,false],[83,141,0,null,null,null,[11974,11975,11976,11977],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"nbyte",null,"",null,false],[0,0,0,"offset",null,"",null,false],[83,142,0,null,null,null,[11979,11980,11981,11982],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"iov",null,"",null,false],[0,0,0,"iovcnt",null,"",null,false],[0,0,0,"offset",null,"",null,false],[83,143,0,null,null,null,[11984,11985,11986],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"iov",null,"",null,false],[0,0,0,"iovcnt",null,"",null,false],[83,144,0,null,null,null,[11988,11989,11990,11991],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"iov",null,"",null,false],[0,0,0,"iovcnt",null,"",null,false],[0,0,0,"offset",null,"",null,false],[83,145,0,null,null,null,[11993,11994,11995],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"nbyte",null,"",null,false],[83,146,0,null,null,null,[11997,11998,11999,12000],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"nbyte",null,"",null,false],[0,0,0,"offset",null,"",null,false],[83,147,0,null,null,null,[12002,12003,12004,12005,12006,12007],false],[0,0,0,"addr",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"prot",null,"",null,false],[0,0,0,"flags",null,"",null,false],[0,0,0,"fd",null,"",null,false],[0,0,0,"offset",null,"",null,false],[83,148,0,null,null,null,[12009,12010],false],[0,0,0,"addr",null,"",null,false],[0,0,0,"len",null,"",null,false],[83,149,0,null,null,null,[12012,12013,12014],false],[0,0,0,"addr",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"prot",null,"",null,false],[83,150,0,null,null,null,[12016,12017,12018],false],[0,0,0,"oldpath",null,"",null,false],[0,0,0,"newpath",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,151,0,null,null,null,[12020,12021,12022,12023,12024],false],[0,0,0,"oldfd",null,"",null,false],[0,0,0,"oldpath",null,"",null,false],[0,0,0,"newfd",null,"",null,false],[0,0,0,"newpath",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,152,0,null,null,null,[12026],false],[0,0,0,"path",null,"",null,false],[83,153,0,null,null,null,[12028,12029,12030],false],[0,0,0,"dirfd",null,"",null,false],[0,0,0,"path",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,154,0,null,null,null,[12032,12033],false],[0,0,0,"buf",null,"",null,false],[0,0,0,"size",null,"",null,false],[83,155,0,null,null,null,[12035,12036,12037],false],[0,0,0,"pid",null,"",null,false],[0,0,0,"status",null,"",null,false],[0,0,0,"options",null,"",null,false],[83,156,0,null,null,null,[12039,12040,12041,12042],false],[0,0,0,"pid",null,"",null,false],[0,0,0,"status",null,"",null,false],[0,0,0,"options",null,"",null,false],[0,0,0,"ru",null,"",null,false],[83,157,0,null,null,null,[],false],[83,158,0,null,null,null,[12045,12046],false],[0,0,0,"path",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,159,0,null,null,null,[12048,12049,12050,12051],false],[0,0,0,"dirfd",null,"",null,false],[0,0,0,"path",null,"",null,false],[0,0,0,"mode",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,160,0,null,null,null,[12053],false],[0,0,0,"fds",null,"",null,false],[83,161,0,null,null,null,[12055,12056],false],[0,0,0,"path",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,162,0,null,null,null,[12058,12059,12060],false],[0,0,0,"dirfd",null,"",null,false],[0,0,0,"path",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,163,0,null,null,null,[12062,12063],false],[0,0,0,"existing",null,"",null,false],[0,0,0,"new",null,"",null,false],[83,164,0,null,null,null,[12065,12066,12067],false],[0,0,0,"oldpath",null,"",null,false],[0,0,0,"newdirfd",null,"",null,false],[0,0,0,"newpath",null,"",null,false],[83,165,0,null,null,null,[12069,12070],false],[0,0,0,"old",null,"",null,false],[0,0,0,"new",null,"",null,false],[83,166,0,null,null,null,[12072,12073,12074,12075],false],[0,0,0,"olddirfd",null,"",null,false],[0,0,0,"old",null,"",null,false],[0,0,0,"newdirfd",null,"",null,false],[0,0,0,"new",null,"",null,false],[83,167,0,null,null,null,[12077],false],[0,0,0,"path",null,"",null,false],[83,168,0,null,null,null,[12079],false],[0,0,0,"fd",null,"",null,false],[83,169,0,null,null,null,[12081,12082,12083],false],[0,0,0,"path",null,"",null,false],[0,0,0,"argv",null,"",null,false],[0,0,0,"envp",null,"",null,false],[83,170,0,null,null,null,[12085],false],[0,0,0,"fd",null,"",null,false],[83,171,0,null,null,null,[12087,12088],false],[0,0,0,"old_fd",null,"",null,false],[0,0,0,"new_fd",null,"",null,false],[83,172,0,null,null,null,[12090,12091,12092],false],[0,0,0,"path",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"bufsize",null,"",null,false],[83,173,0,null,null,null,[12094,12095,12096,12097],false],[0,0,0,"dirfd",null,"",null,false],[0,0,0,"path",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"bufsize",null,"",null,false],[83,174,0,null,null,null,[12099,12100],false],[0,0,0,"path",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,175,0,null,null,null,[12102,12103],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,176,0,null,null,null,[12105,12106,12107,12108],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"path",null,"",null,false],[0,0,0,"mode",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,177,0,null,null,null,[12110,12111,12112],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"owner",null,"",null,false],[0,0,0,"group",null,"",null,false],[83,178,0,null,null,null,[12114],false],[0,0,0,"mode",null,"",null,false],[83,180,0,null,null,null,[12116],false],[0,0,0,"path",null,"",null,false],[83,181,0,null,null,null,[12118],false],[0,0,0,"name",null,"",null,false],[83,182,0,null,null,null,[12120,12121,12122,12123,12124,12125],false],[0,0,0,"name",null,"",null,false],[0,0,0,"namelen",null,"",null,false],[0,0,0,"oldp",null,"",null,false],[0,0,0,"oldlenp",null,"",null,false],[0,0,0,"newp",null,"",null,false],[0,0,0,"newlen",null,"",null,false],[83,183,0,null,null,null,[12127,12128,12129,12130,12131],false],[0,0,0,"name",null,"",null,false],[0,0,0,"oldp",null,"",null,false],[0,0,0,"oldlenp",null,"",null,false],[0,0,0,"newp",null,"",null,false],[0,0,0,"newlen",null,"",null,false],[83,184,0,null,null,null,[12133,12134,12135],false],[0,0,0,"name",null,"",null,false],[0,0,0,"mibp",null,"",null,false],[0,0,0,"sizep",null,"",null,false],[83,185,0,null,null,null,[12137,12138],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"termios_p",null,"",null,false],[83,186,0,null,null,null,[12140,12141,12142],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"optional_action",null,"",null,false],[0,0,0,"termios_p",null,"",null,false],[83,187,0,null,null,null,[12144,12145],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"cmd",null,"",null,false],[83,188,0,null,null,null,[12147,12148],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"operation",null,"",null,false],[83,189,0,null,null,null,[12150,12151],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"request",null,"",null,false],[83,190,0,null,null,null,[12153],false],[0,0,0,"buf",null,"",null,false],[83,192,0,null,null,null,[12155,12156],false],[0,0,0,"name",null,"",null,false],[0,0,0,"len",null,"",null,false],[83,193,0,null,null,null,[12158,12159],false],[0,0,0,"socket",null,"",null,false],[0,0,0,"how",null,"",null,false],[83,194,0,null,null,null,[12161,12162,12163],false],[0,0,0,"socket",null,"",null,false],[0,0,0,"address",null,"",null,false],[0,0,0,"address_len",null,"",null,false],[83,195,0,null,null,null,[12165,12166,12167,12168],false],[0,0,0,"domain",null,"",null,false],[0,0,0,"sock_type",null,"",null,false],[0,0,0,"protocol",null,"",null,false],[0,0,0,"sv",null,"",null,false],[83,196,0,null,null,null,[12170,12171],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"backlog",null,"",null,false],[83,197,0,null,null,null,[12173,12174,12175],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[83,198,0,null,null,null,[12177,12178,12179],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[83,199,0,null,null,null,[12181,12182,12183],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"sock_addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[83,200,0,null,null,null,[12185,12186,12187],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[83,201,0,null,null,null,[12189,12190,12191,12192],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,202,0,null,null,null,[12194,12195,12196,12197,12198],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"level",null,"",null,false],[0,0,0,"optname",null,"",null,false],[0,0,0,"optval",null,"",null,false],[0,0,0,"optlen",null,"",null,false],[83,203,0,null,null,null,[12200,12201,12202,12203,12204],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"level",null,"",null,false],[0,0,0,"optname",null,"",null,false],[0,0,0,"optval",null,"",null,false],[0,0,0,"optlen",null,"",null,false],[83,204,0,null,null,null,[12206,12207,12208,12209],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,205,0,null,null,null,[12211,12212,12213,12214,12215,12216],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"flags",null,"",null,false],[0,0,0,"dest_addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[83,213,0,null,null,null,[12218,12219,12220],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"msg",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,215,0,null,null,null,[12222,12223,12224,12225],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[83,221,0,null,null,null,[12227,12228,12229,12230,12231,12232],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"buf",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"flags",null,"",null,false],[0,0,0,"src_addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[83,229,0,null,null,null,[12234,12235,12236],false],[0,0,0,"sockfd",null,"",null,false],[0,0,0,"msg",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,231,0,null,null,null,[12238,12239],false],[0,0,0,"pid",null,"",null,false],[0,0,0,"sig",null,"",null,false],[83,232,0,null,null,null,[12241,12242,12243,12244],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"buf_ptr",null,"",null,false],[0,0,0,"nbytes",null,"",null,false],[0,0,0,"basep",null,"",null,false],[83,234,0,null,null,null,[12246],false],[0,0,0,"uid",null,"",null,false],[83,235,0,null,null,null,[12248],false],[0,0,0,"gid",null,"",null,false],[83,236,0,null,null,null,[12250],false],[0,0,0,"euid",null,"",null,false],[83,237,0,null,null,null,[12252],false],[0,0,0,"egid",null,"",null,false],[83,238,0,null,null,null,[12254,12255],false],[0,0,0,"ruid",null,"",null,false],[0,0,0,"euid",null,"",null,false],[83,239,0,null,null,null,[12257,12258],false],[0,0,0,"rgid",null,"",null,false],[0,0,0,"egid",null,"",null,false],[83,240,0,null,null,null,[12260,12261,12262],false],[0,0,0,"ruid",null,"",null,false],[0,0,0,"euid",null,"",null,false],[0,0,0,"suid",null,"",null,false],[83,241,0,null,null,null,[12264,12265,12266],false],[0,0,0,"rgid",null,"",null,false],[0,0,0,"egid",null,"",null,false],[0,0,0,"sgid",null,"",null,false],[83,243,0,null,null,null,[12268],false],[0,0,0,"",null,"",null,false],[83,244,0,null,null,null,[12270,12271],false],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[83,245,0,null,null,null,[12273],false],[0,0,0,"",null,"",null,false],[83,247,0,null,null,null,[12275,12276],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"times",null,"",null,false],[83,248,0,null,null,null,[12278,12279],false],[0,0,0,"path",null,"",null,false],[0,0,0,"times",null,"",null,false],[83,250,0,null,null,null,[12281,12282,12283,12284],false],[0,0,0,"dirfd",null,"",null,false],[0,0,0,"pathname",null,"",null,false],[0,0,0,"times",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,251,0,null,null,null,[12286,12287],false],[0,0,0,"fd",null,"",null,false],[0,0,0,"times",null,"",null,false],[83,253,0,null,null,null,[12289,12290,12291,12293],false],[0,0,0,"newthread",null,"",null,false],[0,0,0,"attr",null,"",null,false],[0,0,0,"start_routine",null,"",[12292],false],[0,0,0,"",null,"",null,false],[0,0,0,"arg",null,"",null,false],[83,259,0,null,null,null,[12295],false],[0,0,0,"attr",null,"",null,false],[83,260,0,null,null,null,[12297,12298,12299],false],[0,0,0,"attr",null,"",null,false],[0,0,0,"stackaddr",null,"",null,false],[0,0,0,"stacksize",null,"",null,false],[83,261,0,null,null,null,[12301,12302],false],[0,0,0,"attr",null,"",null,false],[0,0,0,"stacksize",null,"",null,false],[83,262,0,null,null,null,[12304,12305],false],[0,0,0,"attr",null,"",null,false],[0,0,0,"guardsize",null,"",null,false],[83,263,0,null,null,null,[12307],false],[0,0,0,"attr",null,"",null,false],[83,264,0,null,null,null,[],false],[83,265,0,null,null,null,[12310,12311],false],[0,0,0,"thread",null,"",null,false],[0,0,0,"arg_return",null,"",null,false],[83,266,0,null,null,null,[12313],false],[0,0,0,"thread",null,"",null,false],[83,267,0,null,null,null,[12315,12316,12317],false],[0,0,0,"prepare",null,"",[],false],[0,0,0,"parent",null,"",[],false],[0,0,0,"child",null,"",[],false],[83,272,0,null,null,null,[12319,12320],false],[0,0,0,"key",null,"",null,false],[0,0,0,"destructor",null,"",[12321],false],[0,0,0,"value",null,"",null,false],[83,276,0,null,null,null,[12323],false],[0,0,0,"key",null,"",null,false],[83,277,0,null,null,null,[12325],false],[0,0,0,"key",null,"",null,false],[83,278,0,null,null,null,[12327,12328],false],[0,0,0,"key",null,"",null,false],[0,0,0,"value",null,"",null,false],[83,279,0,null,null,null,[12330,12331,12332],false],[0,0,0,"how",null,"",null,false],[0,0,0,"set",null,"",null,false],[0,0,0,"oldset",null,"",null,false],[83,280,0,null,null,null,[12334,12335,12336],false],[0,0,0,"sem",null,"",null,false],[0,0,0,"pshared",null,"",null,false],[0,0,0,"value",null,"",null,false],[83,281,0,null,null,null,[12338],false],[0,0,0,"sem",null,"",null,false],[83,282,0,null,null,null,[12340,12341,12342,12343],false],[0,0,0,"name",null,"",null,false],[0,0,0,"flag",null,"",null,false],[0,0,0,"mode",null,"",null,false],[0,0,0,"value",null,"",null,false],[83,283,0,null,null,null,[12345],false],[0,0,0,"sem",null,"",null,false],[83,284,0,null,null,null,[12347],false],[0,0,0,"sem",null,"",null,false],[83,285,0,null,null,null,[12349],false],[0,0,0,"sem",null,"",null,false],[83,286,0,null,null,null,[12351],false],[0,0,0,"sem",null,"",null,false],[83,287,0,null,null,null,[12353,12354],false],[0,0,0,"sem",null,"",null,false],[0,0,0,"abs_timeout",null,"",null,false],[83,288,0,null,null,null,[12356,12357],false],[0,0,0,"sem",null,"",null,false],[0,0,0,"sval",null,"",null,false],[83,290,0,null,null,null,[12359,12360,12361],false],[0,0,0,"name",null,"",null,false],[0,0,0,"flag",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,291,0,null,null,null,[12363],false],[0,0,0,"name",null,"",null,false],[83,293,0,null,null,null,[],false],[83,294,0,null,null,null,[12366,12367,12368,12369,12370,12371],false],[0,0,0,"kq",null,"",null,false],[0,0,0,"changelist",null,"",null,false],[0,0,0,"nchanges",null,"",null,false],[0,0,0,"eventlist",null,"",null,false],[0,0,0,"nevents",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[83,303,0,null,null,null,[],false],[83,304,0,null,null,null,[12374,12375,12376,12377,12378],false],[0,0,0,"port",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"object",null,"",null,false],[0,0,0,"events",null,"",null,false],[0,0,0,"user_var",null,"",null,false],[83,311,0,null,null,null,[12380,12381,12382],false],[0,0,0,"port",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"object",null,"",null,false],[83,312,0,null,null,null,[12384,12385,12386],false],[0,0,0,"port",null,"",null,false],[0,0,0,"events",null,"",null,false],[0,0,0,"user_var",null,"",null,false],[83,313,0,null,null,null,[12388,12389,12390,12391,12392],false],[0,0,0,"ports",null,"",null,false],[0,0,0,"errors",null,"",null,false],[0,0,0,"num_ports",null,"",null,false],[0,0,0,"events",null,"",null,false],[0,0,0,"user_var",null,"",null,false],[83,320,0,null,null,null,[12394,12395,12396],false],[0,0,0,"port",null,"",null,false],[0,0,0,"event",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[83,321,0,null,null,null,[12398,12399,12400,12401,12402],false],[0,0,0,"port",null,"",null,false],[0,0,0,"event_list",null,"",null,false],[0,0,0,"max_events",null,"",null,false],[0,0,0,"events_retrieved",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[83,328,0,null,null,null,[12404,12405,12406,12407],false],[0,0,0,"port",null,"",null,false],[0,0,0,"flags",null,"",null,false],[0,0,0,"events",null,"",null,false],[0,0,0,"user_var",null,"",null,false],[83,330,0,null,null,null,[12409,12410,12411,12412],false],[0,0,0,"node",null,"",null,false],[0,0,0,"service",null,"",null,false],[0,0,0,"hints",null,"",null,false],[0,0,0,"res",null," On Linux, `res` will not be modified on error and `freeaddrinfo` will\n potentially crash if you pass it an undefined pointer\n",null,false],[83,339,0,null,null,null,[12414],false],[0,0,0,"res",null,"",null,false],[83,341,0,null,null,null,[12416,12417,12418,12419,12420,12421,12422],false],[0,0,0,"addr",null,"",null,false],[0,0,0,"addrlen",null,"",null,false],[0,0,0,"host",null,"",null,false],[0,0,0,"hostlen",null,"",null,false],[0,0,0,"serv",null,"",null,false],[0,0,0,"servlen",null,"",null,false],[0,0,0,"flags",null,"",null,false],[83,351,0,null,null,null,[12424],false],[0,0,0,"errcode",null,"",null,false],[83,353,0,null,null,null,[12426,12427,12428],false],[0,0,0,"fds",null,"",null,false],[0,0,0,"nfds",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[83,354,0,null,null,null,[12430,12431,12432,12433],false],[0,0,0,"fds",null,"",null,false],[0,0,0,"nfds",null,"",null,false],[0,0,0,"timeout",null,"",null,false],[0,0,0,"sigmask",null,"",null,false],[83,356,0,null,null,null,[12435,12436,12437,12438,12439],false],[0,0,0,"msg",null,"",null,false],[0,0,0,"eomorig",null,"",null,false],[0,0,0,"comp_dn",null,"",null,false],[0,0,0,"exp_dn",null,"",null,false],[0,0,0,"length",null,"",null,false],[83,364,0,null,null,null,null,false],[83,365,0,null,null,null,[12442],false],[0,0,0,"mutex",null,"",null,false],[83,366,0,null,null,null,[12444],false],[0,0,0,"mutex",null,"",null,false],[83,367,0,null,null,null,[12446],false],[0,0,0,"mutex",null,"",null,false],[83,368,0,null,null,null,[12448],false],[0,0,0,"mutex",null,"",null,false],[83,370,0,null,null,null,null,false],[83,371,0,null,null,null,[12451,12452],false],[0,0,0,"cond",null,"",null,false],[0,0,0,"mutex",null,"",null,false],[83,372,0,null,null,null,[12454,12455,12456],false],[0,0,0,"cond",null,"",null,false],[0,0,0,"mutex",null,"",null,false],[0,0,0,"abstime",null,"",null,false],[83,373,0,null,null,null,[12458],false],[0,0,0,"cond",null,"",null,false],[83,374,0,null,null,null,[12460],false],[0,0,0,"cond",null,"",null,false],[83,375,0,null,null,null,[12462],false],[0,0,0,"cond",null,"",null,false],[83,377,0,null,null,null,[12464],false],[0,0,0,"rwl",null,"",null,false],[83,378,0,null,null,null,[12466],false],[0,0,0,"rwl",null,"",null,false],[83,379,0,null,null,null,[12468],false],[0,0,0,"rwl",null,"",null,false],[83,380,0,null,null,null,[12470],false],[0,0,0,"rwl",null,"",null,false],[83,381,0,null,null,null,[12472],false],[0,0,0,"rwl",null,"",null,false],[83,382,0,null,null,null,[12474],false],[0,0,0,"rwl",null,"",null,false],[83,384,0,null,null,null,null,false],[83,385,0,null,null,null,null,false],[83,387,0,null,null,null,[12478,12479],false],[0,0,0,"path",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,388,0,null,null,null,[12481],false],[0,0,0,"handle",null,"",null,false],[83,389,0,null,null,null,[12483,12484],false],[0,0,0,"handle",null,"",null,false],[0,0,0,"symbol",null,"",null,false],[83,391,0,null,null,null,[],false],[83,392,0,null,null,null,[12487],false],[0,0,0,"fd",null,"",null,false],[83,393,0,null,null,null,[12489],false],[0,0,0,"fd",null,"",null,false],[83,394,0,null,null,null,[12491],false],[0,0,0,"fd",null,"",null,false],[83,396,0,null,null,null,[12493],false],[0,0,0,"option",null,"",null,false],[83,398,0,null,null,null,[12495,12496],false],[0,0,0,"resource",null,"",null,false],[0,0,0,"rlim",null,"",null,false],[83,399,0,null,null,null,[12498,12499],false],[0,0,0,"resource",null,"",null,false],[0,0,0,"rlim",null,"",null,false],[83,401,0,null,null,null,[12501,12502,12503],false],[0,0,0,"buf",null,"",null,false],[0,0,0,"size",null,"",null,false],[0,0,0,"mode",null,"",null,false],[83,403,0,null,null,null,[12505,12506],false],[0,0,0,"priority",null,"",null,false],[0,0,0,"message",null,"",null,false],[83,404,0,null,null,null,[12508,12509,12510],false],[0,0,0,"ident",null,"",null,false],[0,0,0,"logopt",null,"",null,false],[0,0,0,"facility",null,"",null,false],[83,405,0,null,null,null,[],false],[83,406,0,null,null,null,[12513],false],[0,0,0,"maskpri",null,"",null,false],[83,408,0,null,null,null,[12515],false],[0,0,0,"",null,"",null,false],[83,417,0,null,null,null,null,false],[0,58,0,null,null,null,null,false],[0,0,0,"coff.zig",null,"",[],false],[85,0,0,null,null,null,null,false],[85,1,0,null,null,null,null,false],[85,2,0,null,null,null,null,false],[85,3,0,null,null,null,null,false],[85,4,0,null,null,null,null,false],[85,5,0,null,null,null,null,false],[85,7,0,null,null,null,[12526,12527,12528,12529,12530,12531,12532,12533,12534,12535,12536,12537,12538,12539,12540,12541],false],[0,0,0,"RELOCS_STRIPPED",null," Image only, Windows CE, and Microsoft Windows NT and later.\n This indicates that the file does not contain base relocations\n and must therefore be loaded at its preferred base address.\n If the base address is not available, the loader reports an error.\n The default behavior of the linker is to strip base relocations\n from executable (EXE) files.",null,false],[0,0,0,"EXECUTABLE_IMAGE",null," Image only. This indicates that the image file is valid and can be run.\n If this flag is not set, it indicates a linker error.",null,false],[0,0,0,"LINE_NUMS_STRIPPED",null," COFF line numbers have been removed. This flag is deprecated and should be zero.",null,false],[0,0,0,"LOCAL_SYMS_STRIPPED",null," COFF symbol table entries for local symbols have been removed.\n This flag is deprecated and should be zero.",null,false],[0,0,0,"AGGRESSIVE_WS_TRIM",null," Obsolete. Aggressively trim working set.\n This flag is deprecated for Windows 2000 and later and must be zero.",null,false],[0,0,0,"LARGE_ADDRESS_AWARE",null," Application can handle > 2-GB addresses.",null,false],[0,0,0,"RESERVED",null," This flag is reserved for future use.",null,false],[0,0,0,"BYTES_REVERSED_LO",null," Little endian: the least significant bit (LSB) precedes the\n most significant bit (MSB) in memory. This flag is deprecated and should be zero.",null,false],[0,0,0,"32BIT_MACHINE",null," Machine is based on a 32-bit-word architecture.",null,false],[0,0,0,"DEBUG_STRIPPED",null," Debugging information is removed from the image file.",null,false],[0,0,0,"REMOVABLE_RUN_FROM_SWAP",null," If the image is on removable media, fully load it and copy it to the swap file.",null,false],[0,0,0,"NET_RUN_FROM_SWAP",null," If the image is on network media, fully load it and copy it to the swap file.",null,false],[0,0,0,"SYSTEM",null," The image file is a system file, not a user program.",null,false],[0,0,0,"DLL",null," The image file is a dynamic-link library (DLL).\n Such files are considered executable files for almost all purposes,\n although they cannot be directly run.",null,false],[0,0,0,"UP_SYSTEM_ONLY",null," The file should be run only on a uniprocessor machine.",null,false],[0,0,0,"BYTES_REVERSED_HI",null," Big endian: the MSB precedes the LSB in memory. This flag is deprecated and should be zero.",null,false],[85,68,0,null,null,null,[12544,12545,12546,12547,12548,12549,12551],false],[85,68,0,null,null,null,null,false],[0,0,0,"machine",null," The number that identifies the type of target machine.",null,false],[0,0,0,"number_of_sections",null," The number of sections. This indicates the size of the section table, which immediately follows the headers.",null,false],[0,0,0,"time_date_stamp",null," The low 32 bits of the number of seconds since 00:00 January 1, 1970 (a C run-time time_t value),\n which indicates when the file was created.",null,false],[0,0,0,"pointer_to_symbol_table",null," The file offset of the COFF symbol table, or zero if no COFF symbol table is present.\n This value should be zero for an image because COFF debugging information is deprecated.",null,false],[0,0,0,"number_of_symbols",null," The number of entries in the symbol table.\n This data can be used to locate the string table, which immediately follows the symbol table.\n This value should be zero for an image because COFF debugging information is deprecated.",null,false],[0,0,0,"size_of_optional_header",null," The size of the optional header, which is required for executable files but not for object files.\n This value should be zero for an object file. For a description of the header format, see Optional Header (Image Only).",null,false],[85,68,0,null,null,null,null,false],[0,0,0,"flags",null," The flags that indicate the attributes of the file.",null,false],[85,98,0,null,null,null,null,false],[85,99,0,null,null,null,null,false],[85,101,0,null,null,null,[12556,12557,12558,12559,12560,12561,12562,12563,12564,12565,12566,12567],false],[85,101,0,null,null,null,null,false],[0,0,0,"_reserved_0",null,null,null,false],[0,0,0,"HIGH_ENTROPY_VA",null," Image can handle a high entropy 64-bit virtual address space.",null,false],[0,0,0,"DYNAMIC_BASE",null," DLL can be relocated at load time.",null,false],[0,0,0,"FORCE_INTEGRITY",null," Code Integrity checks are enforced.",null,false],[0,0,0,"NX_COMPAT",null," Image is NX compatible.",null,false],[0,0,0,"NO_ISOLATION",null," Isolation aware, but do not isolate the image.",null,false],[0,0,0,"NO_SEH",null," Does not use structured exception (SE) handling. No SE handler may be called in this image.",null,false],[0,0,0,"NO_BIND",null," Do not bind the image.",null,false],[0,0,0,"APPCONTAINER",null," Image must execute in an AppContainer.",null,false],[0,0,0,"WDM_DRIVER",null," A WDM driver.",null,false],[0,0,0,"GUARD_CF",null," Image supports Control Flow Guard.",null,false],[0,0,0,"TERMINAL_SERVER_AWARE",null," Terminal Server aware.",null,false],[85,138,0,null,null,null,[12569,12570,12571,12572,12573,12574,12575,12576,12577,12578,12579,12580,12581,12582],false],[0,0,0,"UNKNOWN",null," An unknown subsystem",null,false],[0,0,0,"NATIVE",null," Device drivers and native Windows processes",null,false],[0,0,0,"WINDOWS_GUI",null," The Windows graphical user interface (GUI) subsystem",null,false],[0,0,0,"WINDOWS_CUI",null," The Windows character subsystem",null,false],[0,0,0,"OS2_CUI",null," The OS/2 character subsystem",null,false],[0,0,0,"POSIX_CUI",null," The Posix character subsystem",null,false],[0,0,0,"NATIVE_WINDOWS",null," Native Win9x driver",null,false],[0,0,0,"WINDOWS_CE_GUI",null," Windows CE",null,false],[0,0,0,"EFI_APPLICATION",null," An Extensible Firmware Interface (EFI) application",null,false],[0,0,0,"EFI_BOOT_SERVICE_DRIVER",null," An EFI driver with boot services",null,false],[0,0,0,"EFI_RUNTIME_DRIVER",null," An EFI driver with run-time services",null,false],[0,0,0,"EFI_ROM",null," An EFI ROM image",null,false],[0,0,0,"XBOX",null," XBOX",null,false],[0,0,0,"WINDOWS_BOOT_APPLICATION",null," Windows boot application",null,false],[85,182,0,null,null,null,[12584,12585,12586,12587,12588,12589,12590,12591],false],[0,0,0,"magic",null,null,null,false],[0,0,0,"major_linker_version",null,null,null,false],[0,0,0,"minor_linker_version",null,null,null,false],[0,0,0,"size_of_code",null,null,null,false],[0,0,0,"size_of_initialized_data",null,null,null,false],[0,0,0,"size_of_uninitialized_data",null,null,null,false],[0,0,0,"address_of_entry_point",null,null,null,false],[0,0,0,"base_of_code",null,null,null,false],[85,193,0,null,null,null,[12593,12594,12595,12596,12597,12598,12599,12600,12601,12602,12603,12604,12605,12606,12607,12608,12609,12610,12611,12612,12613,12614,12616,12618,12619,12620,12621,12622,12623,12624],false],[0,0,0,"magic",null,null,null,false],[0,0,0,"major_linker_version",null,null,null,false],[0,0,0,"minor_linker_version",null,null,null,false],[0,0,0,"size_of_code",null,null,null,false],[0,0,0,"size_of_initialized_data",null,null,null,false],[0,0,0,"size_of_uninitialized_data",null,null,null,false],[0,0,0,"address_of_entry_point",null,null,null,false],[0,0,0,"base_of_code",null,null,null,false],[0,0,0,"base_of_data",null,null,null,false],[0,0,0,"image_base",null,null,null,false],[0,0,0,"section_alignment",null,null,null,false],[0,0,0,"file_alignment",null,null,null,false],[0,0,0,"major_operating_system_version",null,null,null,false],[0,0,0,"minor_operating_system_version",null,null,null,false],[0,0,0,"major_image_version",null,null,null,false],[0,0,0,"minor_image_version",null,null,null,false],[0,0,0,"major_subsystem_version",null,null,null,false],[0,0,0,"minor_subsystem_version",null,null,null,false],[0,0,0,"win32_version_value",null,null,null,false],[0,0,0,"size_of_image",null,null,null,false],[0,0,0,"size_of_headers",null,null,null,false],[0,0,0,"checksum",null,null,null,false],[85,193,0,null,null,null,null,false],[0,0,0,"subsystem",null,null,null,false],[85,193,0,null,null,null,null,false],[0,0,0,"dll_flags",null,null,null,false],[0,0,0,"size_of_stack_reserve",null,null,null,false],[0,0,0,"size_of_stack_commit",null,null,null,false],[0,0,0,"size_of_heap_reserve",null,null,null,false],[0,0,0,"size_of_heap_commit",null,null,null,false],[0,0,0,"loader_flags",null,null,null,false],[0,0,0,"number_of_rva_and_sizes",null,null,null,false],[85,226,0,null,null,null,[12626,12627,12628,12629,12630,12631,12632,12633,12634,12635,12636,12637,12638,12639,12640,12641,12642,12643,12644,12645,12646,12648,12650,12651,12652,12653,12654,12655,12656],false],[0,0,0,"magic",null,null,null,false],[0,0,0,"major_linker_version",null,null,null,false],[0,0,0,"minor_linker_version",null,null,null,false],[0,0,0,"size_of_code",null,null,null,false],[0,0,0,"size_of_initialized_data",null,null,null,false],[0,0,0,"size_of_uninitialized_data",null,null,null,false],[0,0,0,"address_of_entry_point",null,null,null,false],[0,0,0,"base_of_code",null,null,null,false],[0,0,0,"image_base",null,null,null,false],[0,0,0,"section_alignment",null,null,null,false],[0,0,0,"file_alignment",null,null,null,false],[0,0,0,"major_operating_system_version",null,null,null,false],[0,0,0,"minor_operating_system_version",null,null,null,false],[0,0,0,"major_image_version",null,null,null,false],[0,0,0,"minor_image_version",null,null,null,false],[0,0,0,"major_subsystem_version",null,null,null,false],[0,0,0,"minor_subsystem_version",null,null,null,false],[0,0,0,"win32_version_value",null,null,null,false],[0,0,0,"size_of_image",null,null,null,false],[0,0,0,"size_of_headers",null,null,null,false],[0,0,0,"checksum",null,null,null,false],[85,226,0,null,null,null,null,false],[0,0,0,"subsystem",null,null,null,false],[85,226,0,null,null,null,null,false],[0,0,0,"dll_flags",null,null,null,false],[0,0,0,"size_of_stack_reserve",null,null,null,false],[0,0,0,"size_of_stack_commit",null,null,null,false],[0,0,0,"size_of_heap_reserve",null,null,null,false],[0,0,0,"size_of_heap_commit",null,null,null,false],[0,0,0,"loader_flags",null,null,null,false],[0,0,0,"number_of_rva_and_sizes",null,null,null,false],[85,258,0,null,null,null,null,false],[85,260,0,null,null,null,[12659,12660,12661,12662,12663,12664,12665,12666,12667,12668,12669,12670,12671,12672,12673],false],[0,0,0,"EXPORT",null," Export Directory",null,false],[0,0,0,"IMPORT",null," Import Directory",null,false],[0,0,0,"RESOURCE",null," Resource Directory",null,false],[0,0,0,"EXCEPTION",null," Exception Directory",null,false],[0,0,0,"SECURITY",null," Security Directory",null,false],[0,0,0,"BASERELOC",null," Base Relocation Table",null,false],[0,0,0,"DEBUG",null," Debug Directory",null,false],[0,0,0,"ARCHITECTURE",null," Architecture Specific Data",null,false],[0,0,0,"GLOBALPTR",null," RVA of GP",null,false],[0,0,0,"TLS",null," TLS Directory",null,false],[0,0,0,"LOAD_CONFIG",null," Load Configuration Directory",null,false],[0,0,0,"BOUND_IMPORT",null," Bound Import Directory in headers",null,false],[0,0,0,"IAT",null," Import Address Table",null,false],[0,0,0,"DELAY_IMPORT",null," Delay Load Import Descriptors",null,false],[0,0,0,"COM_DESCRIPTOR",null," COM Runtime descriptor",null,false],[85,307,0,null,null,null,[12675,12676],false],[0,0,0,"virtual_address",null,null,null,false],[0,0,0,"size",null,null,null,false],[85,312,0,null,null,null,[12678,12679],false],[0,0,0,"page_rva",null," The image base plus the page RVA is added to each offset to create the VA where the base relocation must be applied.",null,false],[0,0,0,"block_size",null," The total number of bytes in the base relocation block, including the Page RVA and Block Size fields and the Type/Offset fields that follow.",null,false],[85,320,0,null,null,null,[12682,12684],false],[85,320,0,null,null,null,null,false],[0,0,0,"offset",null," Stored in the remaining 12 bits of the WORD, an offset from the starting address that was specified in the Page RVA field for the block.\n This offset specifies where the base relocation is to be applied.",null,false],[85,320,0,null,null,null,null,false],[0,0,0,"type",null," Stored in the high 4 bits of the WORD, a value that indicates the type of base relocation to be applied.",null,false],[85,329,0,null,null,null,[12686,12687,12688,12689,12690,12691,12692,12693,12694,12695,12696],false],[0,0,0,"ABSOLUTE",null," The base relocation is skipped. This type can be used to pad a block.",null,false],[0,0,0,"HIGH",null," The base relocation adds the high 16 bits of the difference to the 16-bit field at offset. The 16-bit field represents the high value of a 32-bit word.",null,false],[0,0,0,"LOW",null," The base relocation adds the low 16 bits of the difference to the 16-bit field at offset. The 16-bit field represents the low half of a 32-bit word.",null,false],[0,0,0,"HIGHLOW",null," The base relocation applies all 32 bits of the difference to the 32-bit field at offset.",null,false],[0,0,0,"HIGHADJ",null," The base relocation adds the high 16 bits of the difference to the 16-bit field at offset.\n The 16-bit field represents the high value of a 32-bit word.\n The low 16 bits of the 32-bit value are stored in the 16-bit word that follows this base relocation.\n This means that this base relocation occupies two slots.",null,false],[0,0,0,"MIPS_JMPADDR",null," When the machine type is MIPS, the base relocation applies to a MIPS jump instruction.",null,false],[0,0,0,"RESERVED",null," This relocation is meaningful only when the machine type is ARM or Thumb.\n The base relocation applies the 32-bit address of a symbol across a consecutive MOVW/MOVT instruction pair.\n This relocation is only meaningful when the machine type is RISC-V.\n The base relocation applies to the high 20 bits of a 32-bit absolute address.\n Reserved, must be zero.",null,false],[0,0,0,"THUMB_MOV32",null," This relocation is meaningful only when the machine type is Thumb.\n The base relocation applies the 32-bit address of a symbol to a consecutive MOVW/MOVT instruction pair.",null,false],[0,0,0,"RISCV_LOW12S",null," This relocation is only meaningful when the machine type is RISC-V.\n The base relocation applies to the low 12 bits of a 32-bit absolute address formed in RISC-V I-type instruction format.\n This relocation is only meaningful when the machine type is RISC-V.\n The base relocation applies to the low 12 bits of a 32-bit absolute address formed in RISC-V S-type instruction format.",null,false],[0,0,0,"MIPS_JMPADDR16",null," This relocation is only meaningful when the machine type is LoongArch 32-bit.\n The base relocation applies to a 32-bit absolute address formed in two consecutive instructions.\n This relocation is only meaningful when the machine type is LoongArch 64-bit.\n The base relocation applies to a 64-bit absolute address formed in four consecutive instructions.\n The relocation is only meaningful when the machine type is MIPS.\n The base relocation applies to a MIPS16 jump instruction.",null,false],[0,0,0,"DIR64",null," The base relocation applies the difference to the 64-bit field at offset.",null,false],[85,390,0,null,null,null,[12698,12699,12700,12701,12703,12704,12705,12706],false],[0,0,0,"characteristics",null,null,null,false],[0,0,0,"time_date_stamp",null,null,null,false],[0,0,0,"major_version",null,null,null,false],[0,0,0,"minor_version",null,null,null,false],[85,390,0,null,null,null,null,false],[0,0,0,"type",null,null,null,false],[0,0,0,"size_of_data",null,null,null,false],[0,0,0,"address_of_raw_data",null,null,null,false],[0,0,0,"pointer_to_raw_data",null,null,null,false],[85,401,0,null,null,null,[12708,12709,12710,12711,12712,12713,12714,12715,12716,12717,12718,12719,12720,12721,12722,12723,12724],false],[0,0,0,"UNKNOWN",null,null,null,false],[0,0,0,"COFF",null,null,null,false],[0,0,0,"CODEVIEW",null,null,null,false],[0,0,0,"FPO",null,null,null,false],[0,0,0,"MISC",null,null,null,false],[0,0,0,"EXCEPTION",null,null,null,false],[0,0,0,"FIXUP",null,null,null,false],[0,0,0,"OMAP_TO_SRC",null,null,null,false],[0,0,0,"OMAP_FROM_SRC",null,null,null,false],[0,0,0,"BORLAND",null,null,null,false],[0,0,0,"RESERVED10",null,null,null,false],[0,0,0,"VC_FEATURE",null,null,null,false],[0,0,0,"POGO",null,null,null,false],[0,0,0,"ILTCG",null,null,null,false],[0,0,0,"MPX",null,null,null,false],[0,0,0,"REPRO",null,null,null,false],[0,0,0,"EX_DLLCHARACTERISTICS",null,null,null,false],[85,421,0,null,null,null,[12726,12727,12728,12729,12730],false],[0,0,0,"import_lookup_table_rva",null," The RVA of the import lookup table.\n This table contains a name or ordinal for each import.\n (The name \"Characteristics\" is used in Winnt.h, but no longer describes this field.)",null,false],[0,0,0,"time_date_stamp",null," The stamp that is set to zero until the image is bound.\n After the image is bound, this field is set to the time/data stamp of the DLL.",null,false],[0,0,0,"forwarder_chain",null," The index of the first forwarder reference.",null,false],[0,0,0,"name_rva",null," The address of an ASCII string that contains the name of the DLL.\n This address is relative to the image base.",null,false],[0,0,0,"import_address_table_rva",null," The RVA of the import address table.\n The contents of this table are identical to the contents of the import lookup table until the image is bound.",null,false],[85,443,0,null,null,null,[],false],[85,444,0,null,null,null,[12734,12735],false],[85,444,0,null,null,null,null,false],[0,0,0,"name_table_rva",null,null,null,false],[0,0,0,"flag",null,null,null,false],[85,449,0,null,null,null,[12737,12739,12740],false],[0,0,0,"ordinal_number",null,null,null,false],[85,449,0,null,null,null,null,false],[0,0,0,"unused",null,null,null,false],[0,0,0,"flag",null,null,null,false],[85,455,0,null,null,null,null,false],[85,457,0,null,null,null,[12743],false],[0,0,0,"raw",null,"",null,false],[85,462,0,null,null,null,[12745],false],[0,0,0,"raw",null,"",null,false],[85,468,0,null,null,null,[],false],[85,469,0,null,null,null,[12749,12750,12751],false],[85,469,0,null,null,null,null,false],[0,0,0,"name_table_rva",null,null,null,false],[0,0,0,"unused",null,null,null,false],[0,0,0,"flag",null,null,null,false],[85,475,0,null,null,null,[12753,12755,12756],false],[0,0,0,"ordinal_number",null,null,null,false],[85,475,0,null,null,null,null,false],[0,0,0,"unused",null,null,null,false],[0,0,0,"flag",null,null,null,false],[85,481,0,null,null,null,null,false],[85,483,0,null,null,null,[12759],false],[0,0,0,"raw",null,"",null,false],[85,488,0,null,null,null,[12761],false],[0,0,0,"raw",null,"",null,false],[85,496,0,null,null," Every name ends with a NULL byte. IF the NULL byte does not fall on\n 2byte boundary, the entry structure is padded to ensure 2byte alignment.",[12763,12765],false],[0,0,0,"hint",null," An index into the export name pointer table.\n A match is attempted first with this value. If it fails, a binary search is performed on the DLL's export name pointer table.",null,false],[85,496,0,null,null,null,null,false],[0,0,0,"name",null," Pointer to NULL terminated ASCII name.\n Variable length...",null,false],[85,506,0,null,null,null,[12781,12782,12783,12784,12785,12786,12787,12788,12789,12791],false],[85,518,0,null,null,null,[12768],false],[0,0,0,"self",null,"",null,false],[85,524,0,null,null,null,[12770],false],[0,0,0,"self",null,"",null,false],[85,532,0,null,null," Applicable only to section headers in COFF objects.",[12772],false],[0,0,0,"self",null,"",null,false],[85,537,0,null,null,null,[12774,12775],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_alignment",null,"",null,false],[85,542,0,null,null,null,[12777],false],[0,0,0,"self",null,"",null,false],[85,546,0,null,null,null,[12779],false],[0,0,0,"self",null,"",null,false],[85,506,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"virtual_size",null,null,null,false],[0,0,0,"virtual_address",null,null,null,false],[0,0,0,"size_of_raw_data",null,null,null,false],[0,0,0,"pointer_to_raw_data",null,null,null,false],[0,0,0,"pointer_to_relocations",null,null,null,false],[0,0,0,"pointer_to_linenumbers",null,null,null,false],[0,0,0,"number_of_relocations",null,null,null,false],[0,0,0,"number_of_linenumbers",null,null,null,false],[85,506,0,null,null,null,null,false],[0,0,0,"flags",null,null,null,false],[85,551,0,null,null,null,[12794,12795,12796,12797,12798,12799,12800,12801,12802,12803,12804,12806,12807,12808,12809,12810,12811,12813,12814,12815,12816,12817,12818,12819,12820,12821],false],[85,551,0,null,null,null,null,false],[0,0,0,"_reserved_0",null,null,null,false],[0,0,0,"TYPE_NO_PAD",null," The section should not be padded to the next boundary.\n This flag is obsolete and is replaced by IMAGE_SCN_ALIGN_1BYTES.\n This is valid only for object files.",null,false],[0,0,0,"_reserved_1",null,null,null,false],[0,0,0,"CNT_CODE",null," The section contains executable code.",null,false],[0,0,0,"CNT_INITIALIZED_DATA",null," The section contains initialized data.",null,false],[0,0,0,"CNT_UNINITIALIZED_DATA",null," The section contains uninitialized data.",null,false],[0,0,0,"LNK_OTHER",null," Reserved for future use.",null,false],[0,0,0,"LNK_INFO",null," The section contains comments or other information.\n The .drectve section has this type.\n This is valid for object files only.",null,false],[0,0,0,"_reserverd_2",null,null,null,false],[0,0,0,"LNK_REMOVE",null," The section will not become part of the image.\n This is valid only for object files.",null,false],[0,0,0,"LNK_COMDAT",null," The section contains COMDAT data.\n For more information, see COMDAT Sections (Object Only).\n This is valid only for object files.",null,false],[85,551,0,null,null,null,null,false],[0,0,0,"_reserved_3",null,null,null,false],[0,0,0,"GPREL",null," The section contains data referenced through the global pointer (GP).",null,false],[0,0,0,"MEM_PURGEABLE",null," Reserved for future use.",null,false],[0,0,0,"MEM_16BIT",null," Reserved for future use.",null,false],[0,0,0,"MEM_LOCKED",null," Reserved for future use.",null,false],[0,0,0,"MEM_PRELOAD",null," Reserved for future use.",null,false],[85,551,0,null,null,null,null,false],[0,0,0,"ALIGN",null," Takes on multiple values according to flags:\n pub const IMAGE_SCN_ALIGN_1BYTES: u32 = 0x100000;\n pub const IMAGE_SCN_ALIGN_2BYTES: u32 = 0x200000;\n pub const IMAGE_SCN_ALIGN_4BYTES: u32 = 0x300000;\n pub const IMAGE_SCN_ALIGN_8BYTES: u32 = 0x400000;\n pub const IMAGE_SCN_ALIGN_16BYTES: u32 = 0x500000;\n pub const IMAGE_SCN_ALIGN_32BYTES: u32 = 0x600000;\n pub const IMAGE_SCN_ALIGN_64BYTES: u32 = 0x700000;\n pub const IMAGE_SCN_ALIGN_128BYTES: u32 = 0x800000;\n pub const IMAGE_SCN_ALIGN_256BYTES: u32 = 0x900000;\n pub const IMAGE_SCN_ALIGN_512BYTES: u32 = 0xA00000;\n pub const IMAGE_SCN_ALIGN_1024BYTES: u32 = 0xB00000;\n pub const IMAGE_SCN_ALIGN_2048BYTES: u32 = 0xC00000;\n pub const IMAGE_SCN_ALIGN_4096BYTES: u32 = 0xD00000;\n pub const IMAGE_SCN_ALIGN_8192BYTES: u32 = 0xE00000;",null,false],[0,0,0,"LNK_NRELOC_OVFL",null," The section contains extended relocations.",null,false],[0,0,0,"MEM_DISCARDABLE",null," The section can be discarded as needed.",null,false],[0,0,0,"MEM_NOT_CACHED",null," The section cannot be cached.",null,false],[0,0,0,"MEM_NOT_PAGED",null," The section is not pageable.",null,false],[0,0,0,"MEM_SHARED",null," The section can be shared in memory.",null,false],[0,0,0,"MEM_EXECUTE",null," The section can be executed as code.",null,false],[0,0,0,"MEM_READ",null," The section can be read.",null,false],[0,0,0,"MEM_WRITE",null," The section can be written to.",null,false],[85,648,0,null,null,null,[12829,12830,12832,12834,12836,12837],false],[85,656,0,null,null,null,[],false],[85,660,0,null,null,null,[12825],false],[0,0,0,"self",null,"",null,false],[85,666,0,null,null,null,[12827],false],[0,0,0,"self",null,"",null,false],[85,648,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"value",null,null,null,false],[85,648,0,null,null,null,null,false],[0,0,0,"section_number",null,null,null,false],[85,648,0,null,null,null,null,false],[0,0,0,"type",null,null,null,false],[85,648,0,null,null,null,null,false],[0,0,0,"storage_class",null,null,null,false],[0,0,0,"number_of_aux_symbols",null,null,null,false],[85,673,0,null,null,null,[12839,12840,12841],false],[0,0,0,"UNDEFINED",null," The symbol record is not yet assigned a section.\n A value of zero indicates that a reference to an external symbol is defined elsewhere.\n A value of non-zero is a common symbol with a size that is specified by the value.",null,false],[0,0,0,"ABSOLUTE",null," The symbol has an absolute (non-relocatable) value and is not an address.",null,false],[0,0,0,"DEBUG",null," The symbol provides general type or debugging information but does not correspond to a section.\n Microsoft tools use this setting along with .file records (storage class FILE).",null,false],[85,688,0,null,null,null,[12844,12846],false],[85,688,0,null,null,null,null,false],[0,0,0,"complex_type",null,null,null,false],[85,688,0,null,null,null,null,false],[0,0,0,"base_type",null,null,null,false],[85,693,0,null,null,null,[12848,12849,12850,12851,12852,12853,12854,12855,12856,12857,12858,12859,12860,12861,12862,12863],false],[0,0,0,"NULL",null," No type information or unknown base type. Microsoft tools use this setting",null,false],[0,0,0,"VOID",null," No valid type; used with void pointers and functions",null,false],[0,0,0,"CHAR",null," A character (signed byte)",null,false],[0,0,0,"SHORT",null," A 2-byte signed integer",null,false],[0,0,0,"INT",null," A natural integer type (normally 4 bytes in Windows)",null,false],[0,0,0,"LONG",null," A 4-byte signed integer",null,false],[0,0,0,"FLOAT",null," A 4-byte floating-point number",null,false],[0,0,0,"DOUBLE",null," An 8-byte floating-point number",null,false],[0,0,0,"STRUCT",null," A structure",null,false],[0,0,0,"UNION",null," A union",null,false],[0,0,0,"ENUM",null," An enumerated type",null,false],[0,0,0,"MOE",null," A member of enumeration (a specified value)",null,false],[0,0,0,"BYTE",null," A byte; unsigned 1-byte integer",null,false],[0,0,0,"WORD",null," A word; unsigned 2-byte integer",null,false],[0,0,0,"UINT",null," An unsigned integer of natural size (normally, 4 bytes)",null,false],[0,0,0,"DWORD",null," An unsigned 4-byte integer",null,false],[85,743,0,null,null,null,[12865,12866,12867,12868],false],[0,0,0,"NULL",null," No derived type; the symbol is a simple scalar variable.",null,false],[0,0,0,"POINTER",null," The symbol is a pointer to base type.",null,false],[0,0,0,"FUNCTION",null," The symbol is a function that returns a base type.",null,false],[0,0,0,"ARRAY",null," The symbol is an array of base type.",null,false],[85,757,0,null,null,null,[12870,12871,12872,12873,12874,12875,12876,12877,12878,12879,12880,12881,12882,12883,12884,12885,12886,12887,12888,12889,12890,12891,12892,12893,12894,12895,12896],false],[0,0,0,"END_OF_FUNCTION",null," A special symbol that represents the end of function, for debugging purposes.",null,false],[0,0,0,"NULL",null," No assigned storage class.",null,false],[0,0,0,"AUTOMATIC",null," The automatic (stack) variable. The Value field specifies the stack frame offset.",null,false],[0,0,0,"EXTERNAL",null," A value that Microsoft tools use for external symbols.\n The Value field indicates the size if the section number is IMAGE_SYM_UNDEFINED (0).\n If the section number is not zero, then the Value field specifies the offset within the section.",null,false],[0,0,0,"STATIC",null," The offset of the symbol within the section.\n If the Value field is zero, then the symbol represents a section name.",null,false],[0,0,0,"REGISTER",null," A register variable.\n The Value field specifies the register number.",null,false],[0,0,0,"EXTERNAL_DEF",null," A symbol that is defined externally.",null,false],[0,0,0,"LABEL",null," A code label that is defined within the module.\n The Value field specifies the offset of the symbol within the section.",null,false],[0,0,0,"UNDEFINED_LABEL",null," A reference to a code label that is not defined.",null,false],[0,0,0,"MEMBER_OF_STRUCT",null," The structure member. The Value field specifies the n th member.",null,false],[0,0,0,"ARGUMENT",null," A formal argument (parameter) of a function. The Value field specifies the n th argument.",null,false],[0,0,0,"STRUCT_TAG",null," The structure tag-name entry.",null,false],[0,0,0,"MEMBER_OF_UNION",null," A union member. The Value field specifies the n th member.",null,false],[0,0,0,"UNION_TAG",null," The Union tag-name entry.",null,false],[0,0,0,"TYPE_DEFINITION",null," A Typedef entry.",null,false],[0,0,0,"UNDEFINED_STATIC",null," A static data declaration.",null,false],[0,0,0,"ENUM_TAG",null," An enumerated type tagname entry.",null,false],[0,0,0,"MEMBER_OF_ENUM",null," A member of an enumeration. The Value field specifies the n th member.",null,false],[0,0,0,"REGISTER_PARAM",null," A register parameter.",null,false],[0,0,0,"BIT_FIELD",null," A bit-field reference. The Value field specifies the n th bit in the bit field.",null,false],[0,0,0,"BLOCK",null," A .bb (beginning of block) or .eb (end of block) record.\n The Value field is the relocatable address of the code location.",null,false],[0,0,0,"FUNCTION",null," A value that Microsoft tools use for symbol records that define the extent of a function: begin function (.bf ), end function ( .ef ), and lines in function ( .lf ).\n For .lf records, the Value field gives the number of source lines in the function.\n For .ef records, the Value field gives the size of the function code.",null,false],[0,0,0,"END_OF_STRUCT",null," An end-of-structure entry.",null,false],[0,0,0,"FILE",null," A value that Microsoft tools, as well as traditional COFF format, use for the source-file symbol record.\n The symbol is followed by auxiliary records that name the file.",null,false],[0,0,0,"SECTION",null," A definition of a section (Microsoft tools use STATIC storage class instead).",null,false],[0,0,0,"WEAK_EXTERNAL",null," A weak external. For more information, see Auxiliary Format 3: Weak Externals.",null,false],[0,0,0,"CLR_TOKEN",null," A CLR token symbol. The name is an ASCII string that consists of the hexadecimal value of the token.\n For more information, see CLR Token Definition (Object Only).",null,false],[85,850,0,null,null,null,[12898,12899,12900,12901,12903],false],[0,0,0,"tag_index",null," The symbol-table index of the corresponding .bf (begin function) symbol record.",null,false],[0,0,0,"total_size",null," The size of the executable code for the function itself.\n If the function is in its own section, the SizeOfRawData in the section header is greater or equal to this field,\n depending on alignment considerations.",null,false],[0,0,0,"pointer_to_linenumber",null," The file offset of the first COFF line-number entry for the function, or zero if none exists.",null,false],[0,0,0,"pointer_to_next_function",null," The symbol-table index of the record for the next function.\n If the function is the last in the symbol table, this field is set to zero.",null,false],[85,850,0,null,null,null,null,false],[0,0,0,"unused",null,null,null,false],[85,869,0,null,null,null,[12905,12906,12907,12908,12909,12911,12913],false],[0,0,0,"length",null," The size of section data; the same as SizeOfRawData in the section header.",null,false],[0,0,0,"number_of_relocations",null," The number of relocation entries for the section.",null,false],[0,0,0,"number_of_linenumbers",null," The number of line-number entries for the section.",null,false],[0,0,0,"checksum",null," The checksum for communal data. It is applicable if the IMAGE_SCN_LNK_COMDAT flag is set in the section header.",null,false],[0,0,0,"number",null," One-based index into the section table for the associated section. This is used when the COMDAT selection setting is 5.",null,false],[85,869,0,null,null,null,null,false],[0,0,0,"selection",null," The COMDAT selection number. This is applicable if the section is a COMDAT section.",null,false],[85,869,0,null,null,null,null,false],[0,0,0,"unused",null,null,null,false],[85,891,0,null,null,null,[12918],false],[85,896,0,null,null,null,[12916],false],[0,0,0,"self",null,"",null,false],[85,891,0,null,null,null,null,false],[0,0,0,"file_name",null," An ANSI string that gives the name of the source file.\n This is padded with nulls if it is less than the maximum length.",null,false],[85,902,0,null,null,null,[12920,12922,12924],false],[0,0,0,"tag_index",null," The symbol-table index of sym2, the symbol to be linked if sym1 is not found.",null,false],[85,902,0,null,null,null,null,false],[0,0,0,"flag",null," A value of IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY indicates that no library search for sym1 should be performed.\n A value of IMAGE_WEAK_EXTERN_SEARCH_LIBRARY indicates that a library search for sym1 should be performed.\n A value of IMAGE_WEAK_EXTERN_SEARCH_ALIAS indicates that sym1 is an alias for sym2.",null,false],[85,902,0,null,null,null,null,false],[0,0,0,"unused",null,null,null,false],[85,915,0,null,null,null,[12926,12927,12928,12929],false],[0,0,0,"SEARCH_NOLIBRARY",null,null,null,false],[0,0,0,"SEARCH_LIBRARY",null,null,null,false],[0,0,0,"SEARCH_ALIAS",null,null,null,false],[0,0,0,"ANTI_DEPENDENCY",null,null,null,false],[85,922,0,null,null,null,[12931,12932,12933,12934,12935,12936,12937],false],[0,0,0,"NONE",null," Not a COMDAT section.",null,false],[0,0,0,"NODUPLICATES",null," If this symbol is already defined, the linker issues a \"multiply defined symbol\" error.",null,false],[0,0,0,"ANY",null," Any section that defines the same COMDAT symbol can be linked; the rest are removed.",null,false],[0,0,0,"SAME_SIZE",null," The linker chooses an arbitrary section among the definitions for this symbol.\n If all definitions are not the same size, a \"multiply defined symbol\" error is issued.",null,false],[0,0,0,"EXACT_MATCH",null," The linker chooses an arbitrary section among the definitions for this symbol.\n If all definitions do not match exactly, a \"multiply defined symbol\" error is issued.",null,false],[0,0,0,"ASSOCIATIVE",null," The section is linked if a certain other COMDAT section is linked.\n This other section is indicated by the Number field of the auxiliary symbol record for the section definition.\n This setting is useful for definitions that have components in multiple sections\n (for example, code in one and data in another), but where all must be linked or discarded as a set.\n The other section this section is associated with must be a COMDAT section, which can be another\n associative COMDAT section. An associative COMDAT section's section association chain can't form a loop.\n The section association chain must eventually come to a COMDAT section that doesn't have IMAGE_COMDAT_SELECT_ASSOCIATIVE set.",null,false],[0,0,0,"LARGEST",null," The linker chooses the largest definition from among all of the definitions for this symbol.\n If multiple definitions have this size, the choice between them is arbitrary.",null,false],[85,954,0,null,null,null,[12940,12941,12943,12944,12946],false],[85,954,0,null,null,null,null,false],[0,0,0,"unused_1",null,null,null,false],[0,0,0,"linenumber",null," The actual ordinal line number (1, 2, 3, and so on) within the source file, corresponding to the .bf or .ef record.",null,false],[85,954,0,null,null,null,null,false],[0,0,0,"unused_2",null,null,null,false],[0,0,0,"pointer_to_next_function",null," The symbol-table index of the next .bf symbol record.\n If the function is the last in the symbol table, this field is set to zero.\n It is not used for .ef records.",null,false],[85,954,0,null,null,null,null,false],[0,0,0,"unused_3",null,null,null,false],[85,970,0,null,null,null,[12952,12953,12954,12955,12956,12957,12958,12959,12960,12961,12962,12963,12964,12965,12966,12967,12968,12969,12970,12971,12972,12973,12974,12975,12976],false],[85,1021,0,null,null,null,[12949],false],[0,0,0,"arch",null,"",null,false],[85,1036,0,null,null,null,[12951],false],[0,0,0,"machine_type",null,"",null,false],[0,0,0,"Unknown",null,null,null,false],[0,0,0,"AM33",null," Matsushita AM33",null,false],[0,0,0,"X64",null," x64",null,false],[0,0,0,"ARM",null," ARM little endian",null,false],[0,0,0,"ARM64",null," ARM64 little endian",null,false],[0,0,0,"ARMNT",null," ARM Thumb-2 little endian",null,false],[0,0,0,"EBC",null," EFI byte code",null,false],[0,0,0,"I386",null," Intel 386 or later processors and compatible processors",null,false],[0,0,0,"IA64",null," Intel Itanium processor family",null,false],[0,0,0,"M32R",null," Mitsubishi M32R little endian",null,false],[0,0,0,"MIPS16",null," MIPS16",null,false],[0,0,0,"MIPSFPU",null," MIPS with FPU",null,false],[0,0,0,"MIPSFPU16",null," MIPS16 with FPU",null,false],[0,0,0,"POWERPC",null," Power PC little endian",null,false],[0,0,0,"POWERPCFP",null," Power PC with floating point support",null,false],[0,0,0,"R4000",null," MIPS little endian",null,false],[0,0,0,"RISCV32",null," RISC-V 32-bit address space",null,false],[0,0,0,"RISCV64",null," RISC-V 64-bit address space",null,false],[0,0,0,"RISCV128",null," RISC-V 128-bit address space",null,false],[0,0,0,"SH3",null," Hitachi SH3",null,false],[0,0,0,"SH3DSP",null," Hitachi SH3 DSP",null,false],[0,0,0,"SH4",null," Hitachi SH4",null,false],[0,0,0,"SH5",null," Hitachi SH5",null,false],[0,0,0,"Thumb",null," Thumb",null,false],[0,0,0,"WCEMIPSV2",null," MIPS little-endian WCE v2",null,false],[85,1052,0,null,null,null,null,false],[85,1062,0,null,null,null,[13023,13024,13025,13027,13028],false],[85,1071,0,null,null,null,[12980],false],[0,0,0,"data",null,"",null,false],[85,1103,0,null,null,null,[12982,12983],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[85,1147,0,null,null,null,[12985],false],[0,0,0,"self",null,"",null,false],[85,1151,0,null,null,null,[12987],false],[0,0,0,"self",null,"",null,false],[85,1157,0,null,null,null,[12989],false],[0,0,0,"self",null,"",null,false],[85,1163,0,null,null,null,[12991],false],[0,0,0,"self",null,"",null,false],[85,1169,0,null,null,null,[12993],false],[0,0,0,"self",null,"",null,false],[85,1178,0,null,null,null,[12995],false],[0,0,0,"self",null,"",null,false],[85,1187,0,null,null,null,[12997],false],[0,0,0,"self",null,"",null,false],[85,1198,0,null,null,null,[12999],false],[0,0,0,"self",null,"",null,false],[85,1207,0,null,null,null,[13001],false],[0,0,0,"self",null,"",null,false],[85,1218,0,null,null,null,[13003],false],[0,0,0,"self",null,"",null,false],[85,1223,0,null,null,null,[13005],false],[0,0,0,"self",null,"",null,false],[85,1229,0,null,null,null,[13007,13008],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[85,1239,0,null,null,null,[13010,13011],false],[0,0,0,"self",null,"",null,false],[0,0,0,"sect_hdr",null,"",null,false],[85,1248,0,null,null,null,[13013,13014],false],[0,0,0,"self",null,"",null,false],[0,0,0,"name",null,"",null,true],[85,1260,0,null,null,null,[13016,13017],false],[0,0,0,"self",null,"",null,false],[0,0,0,"sec",null,"",null,false],[85,1264,0,null,null,null,[13019,13020,13021],false],[0,0,0,"self",null,"",null,false],[0,0,0,"sec",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[85,1062,0,null,null,null,null,false],[0,0,0,"data",null,null,null,false],[0,0,0,"is_image",null,null,null,false],[0,0,0,"coff_header_offset",null,null,null,false],[85,1062,0,null,null,null,null,false],[0,0,0,"guid",null,null,null,false],[0,0,0,"age",null,null,null,false],[85,1270,0,null,null,null,[13074],false],[85,1273,0,null,null,null,[13031],false],[0,0,0,"self",null,"",null,false],[85,1277,0,null,null,null,[13033,13034,13035,13036,13037,13038],false],[0,0,0,"symbol",null,null,null,false],[0,0,0,"func_def",null,null,null,false],[0,0,0,"debug_info",null,null,null,false],[0,0,0,"weak_ext",null,null,null,false],[0,0,0,"file_def",null,null,null,false],[0,0,0,"sect_def",null,null,null,false],[85,1286,0,null,null,null,[13040,13041,13042,13043,13044,13045],false],[0,0,0,"symbol",null,null,null,false],[0,0,0,"debug_info",null,null,null,false],[0,0,0,"func_def",null,null,null,false],[0,0,0,"weak_ext",null,null,null,false],[0,0,0,"file_def",null,null,null,false],[0,0,0,"sect_def",null,null,null,false],[85,1296,0,null,null," Lives as long as Symtab instance.",[13047,13048,13049],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"tag",null,"",null,false],[85,1309,0,null,null,null,[13051],false],[0,0,0,"raw",null,"",null,false],[85,1320,0,null,null,null,[13053],false],[0,0,0,"raw",null,"",null,false],[85,1330,0,null,null,null,[13055],false],[0,0,0,"raw",null,"",null,false],[85,1340,0,null,null,null,[13057],false],[0,0,0,"raw",null,"",null,false],[85,1348,0,null,null,null,[13059],false],[0,0,0,"raw",null,"",null,false],[85,1354,0,null,null,null,[13061],false],[0,0,0,"raw",null,"",null,false],[85,1366,0,null,null,null,[13066,13067,13068],false],[85,1372,0,null,null," Lives as long as Symtab instance.",[13064],false],[0,0,0,"self",null,"",null,false],[85,1366,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[0,0,0,"num",null,null,null,false],[0,0,0,"count",null,null,null,false],[85,1381,0,null,null,null,[13070,13071,13072],false],[0,0,0,"self",null,"",null,false],[0,0,0,"start",null,"",null,false],[0,0,0,"end",null,"",null,false],[85,1270,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[85,1389,0,null,null,null,[13080],false],[85,1392,0,null,null,null,[13077,13078],false],[0,0,0,"self",null,"",null,false],[0,0,0,"off",null,"",null,false],[85,1389,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[0,59,0,null,null,null,null,false],[0,0,0,"compress.zig",null,"",[],false],[86,0,0,null,null,null,null,false],[86,2,0,null,null,null,null,false],[0,0,0,"compress/deflate.zig",null," The deflate package is a translation of the Go code of the compress/flate package from\n https://go.googlesource.com/go/+/refs/tags/go1.17/src/compress/flate/\n",[],false],[87,3,0,null,null,null,null,false],[0,0,0,"deflate/compressor.zig",null,"",[],false],[88,0,0,null,null,null,null,false],[88,1,0,null,null,null,null,false],[88,2,0,null,null,null,null,false],[88,3,0,null,null,null,null,false],[88,4,0,null,null,null,null,false],[88,5,0,null,null,null,null,false],[88,7,0,null,null,null,null,false],[88,9,0,null,null,null,null,false],[0,0,0,"deflate_const.zig",null,"",[],false],[89,3,0,null,null,null,null,false],[89,5,0,null,null,null,null,false],[89,10,0,null,null,null,null,false],[89,12,0,null,null,null,null,false],[89,14,0,null,null,null,null,false],[89,16,0,null,null,null,null,false],[89,21,0,null,null,null,null,false],[89,25,0,null,null,null,null,false],[89,27,0,null,null,null,null,false],[88,10,0,null,null,null,null,false],[0,0,0,"deflate_fast.zig",null,"",[],false],[90,3,0,null,null,null,null,false],[90,4,0,null,null,null,null,false],[90,5,0,null,null,null,null,false],[90,7,0,null,null,null,null,false],[90,9,0,null,null,null,null,false],[90,10,0,null,null,null,null,false],[90,11,0,null,null,null,null,false],[0,0,0,"token.zig",null,"",[],false],[91,3,0,null,null,null,null,false],[91,4,0,null,null,null,null,false],[91,5,0,null,null,null,null,false],[91,6,0,null,null,null,null,false],[91,10,0,null,null,null,null,false],[91,39,0,null,null,null,null,false],[91,58,0,null,null,null,null,false],[91,61,0,null,null,null,[13124],false],[0,0,0,"lit",null,"",null,false],[91,66,0,null,null,null,[13126,13127],false],[0,0,0,"xlength",null,"",null,false],[0,0,0,"xoffset",null,"",null,false],[91,71,0,null,null,null,[13129],false],[0,0,0,"t",null,"",null,false],[91,76,0,null,null,null,[13131],false],[0,0,0,"t",null,"",null,false],[91,80,0,null,null,null,[13133],false],[0,0,0,"t",null,"",null,false],[91,84,0,null,null,null,[13135],false],[0,0,0,"len",null,"",null,false],[91,89,0,null,null,null,[13137],false],[0,0,0,"off",null,"",null,false],[90,13,0,null,null,null,null,false],[90,14,0,null,null,null,null,false],[90,15,0,null,null,null,null,false],[90,16,0,null,null,null,null,false],[90,17,0,null,null,null,null,false],[90,19,0,null,null,null,null,false],[90,20,0,null,null,null,null,false],[90,21,0,null,null,null,null,false],[90,22,0,null,null,null,null,false],[90,29,0,null,null,null,null,false],[90,31,0,null,null,null,[13149,13150],false],[0,0,0,"b",null,"",null,false],[0,0,0,"i",null,"",null,false],[90,39,0,null,null,null,[13152,13153],false],[0,0,0,"b",null,"",null,false],[0,0,0,"i",null,"",null,false],[90,51,0,null,null,null,[13155],false],[0,0,0,"u",null,"",null,false],[90,59,0,null,null,null,null,false],[90,60,0,null,null,null,null,false],[90,62,0,null,null,null,[13159,13160],false],[0,0,0,"val",null,null,null,false],[0,0,0,"offset",null,null,null,false],[90,67,0,null,null,null,[],false],[90,79,0,null,null,null,[13188,13190,13191,13192,13194],false],[90,86,0,null,null,null,null,false],[90,88,0,null,null,null,[13165,13166],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[90,94,0,null,null,null,[13168],false],[0,0,0,"self",null,"",null,false],[90,100,0,null,null,null,[13170,13171,13172,13173],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dst",null,"",null,false],[0,0,0,"tokens_count",null,"",null,false],[0,0,0,"src",null,"",null,false],[90,243,0,null,null,null,[13175,13176,13177],false],[0,0,0,"dst",null,"",null,false],[0,0,0,"tokens_count",null,"",null,false],[0,0,0,"lit",null,"",null,false],[90,254,0,null,null,null,[13179,13180,13181,13182],false],[0,0,0,"self",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"t",null,"",null,false],[0,0,0,"src",null,"",null,false],[90,313,0,null,null,null,[13184],false],[0,0,0,"self",null,"",null,false],[90,329,0,null,null,null,[13186],false],[0,0,0,"self",null,"",null,false],[90,79,0,null,null,null,null,false],[0,0,0,"table",null,null,null,false],[90,79,0,null,null,null,null,false],[0,0,0,"prev",null,null,null,false],[0,0,0,"prev_len",null,null,null,false],[0,0,0,"cur",null,null,null,false],[90,79,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[88,11,0,null,null,null,null,false],[0,0,0,"huffman_bit_writer.zig",null,"",[],false],[92,0,0,null,null,null,null,false],[92,1,0,null,null,null,null,false],[92,2,0,null,null,null,null,false],[92,4,0,null,null,null,null,false],[92,6,0,null,null,null,null,false],[92,7,0,null,null,null,null,false],[0,0,0,"huffman_code.zig",null,"",[],false],[93,0,0,null,null,null,null,false],[93,1,0,null,null,null,null,false],[93,2,0,null,null,null,null,false],[93,3,0,null,null,null,null,false],[93,4,0,null,null,null,null,false],[93,5,0,null,null,null,null,false],[93,7,0,null,null,null,null,false],[93,9,0,null,null,null,null,false],[0,0,0,"bits_utils.zig",null,"",[],false],[94,0,0,null,null,null,null,false],[94,3,0,null,null,null,[13215,13216,13217],false],[0,0,0,"T",null,"",null,true],[0,0,0,"value",null,"",null,false],[0,0,0,"N",null,"",null,false],[93,10,0,null,null,null,null,false],[93,12,0,null,null,null,null,false],[93,14,0,null,null,null,[13221,13222],false],[0,0,0,"literal",null,null,null,false],[0,0,0,"freq",null,null,null,false],[93,20,0,null,null,null,[13224,13225,13226,13227,13228],false],[0,0,0,"level",null,null,null,false],[0,0,0,"last_freq",null,null,null,false],[0,0,0,"next_char_freq",null,null,null,false],[0,0,0,"next_pair_freq",null,null,null,false],[0,0,0,"needed",null,null,null,false],[93,40,0,null,null,null,[13234,13235],false],[93,45,0,null,null,null,[13231,13232,13233],false],[0,0,0,"self",null,"",null,false],[0,0,0,"code",null,"",null,false],[0,0,0,"length",null,"",null,false],[0,0,0,"code",null,null,null,false],[0,0,0,"len",null,null,null,false],[93,51,0,null,null,null,[13255,13257,13259,13261,13263,13265],false],[93,59,0,null,null,null,[13238],false],[0,0,0,"self",null,"",null,false],[93,68,0,null,null,null,[13240,13241,13242],false],[0,0,0,"self",null,"",null,false],[0,0,0,"freq",null,"",null,false],[0,0,0,"max_bits",null,"",null,false],[93,103,0,null,null,null,[13244,13245],false],[0,0,0,"self",null,"",null,false],[0,0,0,"freq",null,"",null,false],[93,128,0,null,null,null,[13247,13248,13249],false],[0,0,0,"self",null,"",null,false],[0,0,0,"list",null,"",null,false],[0,0,0,"max_bits_to_use",null,"",null,false],[93,256,0,null,null,null,[13251,13252,13253],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit_count",null,"",null,false],[0,0,0,"list_arg",null,"",null,false],[93,51,0,null,null,null,null,false],[0,0,0,"codes",null,null,null,false],[93,51,0,null,null,null,null,false],[0,0,0,"freq_cache",null,null,null,false],[93,51,0,null,null,null,null,false],[0,0,0,"bit_count",null,null,null,false],[93,51,0,null,null,null,null,false],[0,0,0,"lns",null,null,null,false],[93,51,0,null,null,null,null,false],[0,0,0,"lfs",null,null,null,false],[93,51,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[93,286,0,null,null,null,[],false],[93,293,0,null,null,null,[13268,13269],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"size",null,"",null,false],[93,304,0,null,null,null,[13271],false],[0,0,0,"allocator",null,"",null,false],[93,339,0,null,null,null,[13273],false],[0,0,0,"allocator",null,"",null,false],[93,348,0,null,null,null,[13275,13276,13277],false],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[93,353,0,null,null,null,[13279,13280,13281],false],[0,0,0,"context",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[92,8,0,null,null,null,null,false],[92,11,0,null,null,null,null,false],[92,14,0,null,null,null,null,false],[92,15,0,null,null,null,null,false],[92,21,0,null,null,null,null,false],[92,26,0,null,null,null,null,false],[92,29,0,null,null,null,null,false],[92,37,0,null,null,null,null,false],[92,44,0,null,null,null,null,false],[92,50,0,null,null,null,null,false],[92,60,0,null,null,null,null,false],[92,62,0,null,null,null,[13294],false],[0,0,0,"WriterType",null,"",[13372,13373,13374,13375,13377,13379,13380,13382,13384,13386,13388,13390,13392,13393,13395,13397,13399,13401],true],[92,64,0,null,null,null,null,false],[92,65,0,null,null,null,null,false],[92,93,0,null,null,null,[13298,13299],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_writer",null,"",null,false],[92,102,0,null,null,null,[13301],false],[0,0,0,"self",null,"",null,false],[92,123,0,null,null,null,[13303,13304],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[92,130,0,null,null,null,[13306,13307,13308],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"nb",null,"",null,false],[92,157,0,null,null,null,[13310,13311],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[92,192,0,null,null,null,[13313,13314,13315,13316,13317],false],[0,0,0,"self",null,"",null,false],[0,0,0,"num_literals",null,"",null,false],[0,0,0,"num_offsets",null,"",null,false],[0,0,0,"lit_enc",null,"",null,false],[0,0,0,"off_enc",null,"",null,false],[92,288,0,null,null,null,[13319,13320,13321,13322],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lit_enc",null,"",null,false],[0,0,0,"off_enc",null,"",null,false],[0,0,0,"extra_bits",null,"",null,false],[92,315,0,null,null,null,[13324,13325],false],[0,0,0,"self",null,"",null,false],[0,0,0,"extra_bits",null,"",null,false],[92,325,0,null,null,null,[13327],false],[0,0,0,"in",null,"",null,false],[92,335,0,null,null,null,[13329,13330],false],[0,0,0,"self",null,"",null,false],[0,0,0,"c",null,"",null,false],[92,368,0,null,null,null,[13332,13333,13334,13335,13336],false],[0,0,0,"self",null,"",null,false],[0,0,0,"num_literals",null,"",null,false],[0,0,0,"num_offsets",null,"",null,false],[0,0,0,"num_codegens",null,"",null,false],[0,0,0,"is_eof",null,"",null,false],[92,420,0,null,null,null,[13338,13339,13340],false],[0,0,0,"self",null,"",null,false],[0,0,0,"length",null,"",null,false],[0,0,0,"is_eof",null,"",null,false],[92,434,0,null,null,null,[13342,13343],false],[0,0,0,"self",null,"",null,false],[0,0,0,"is_eof",null,"",null,false],[92,451,0,null,null,null,[13345,13346,13347,13348],false],[0,0,0,"self",null,"",null,false],[0,0,0,"tokens",null,"",null,false],[0,0,0,"eof",null,"",null,false],[0,0,0,"input",null,"",null,false],[92,544,0,null,null,null,[13350,13351,13352,13353],false],[0,0,0,"self",null,"",null,false],[0,0,0,"tokens",null,"",null,false],[0,0,0,"eof",null,"",null,false],[0,0,0,"input",null,"",null,false],[92,589,0,null,null,null,[13355,13356],false],[0,0,0,"num_literals",null,null,null,false],[0,0,0,"num_offsets",null,null,null,false],[92,598,0,null,null,null,[13358,13359],false],[0,0,0,"self",null,"",null,false],[0,0,0,"tokens",null,"",null,false],[92,648,0,null,null,null,[13361,13362,13363,13364],false],[0,0,0,"self",null,"",null,false],[0,0,0,"tokens",null,"",null,false],[0,0,0,"le_codes",null,"",null,false],[0,0,0,"oe_codes",null,"",null,false],[92,687,0,null,null,null,[13366,13367,13368],false],[0,0,0,"self",null,"",null,false],[0,0,0,"eof",null,"",null,false],[0,0,0,"input",null,"",null,false],[92,774,0,null,null,null,[13370],false],[0,0,0,"self",null,"",null,false],[92,63,0,null,null,null,null,false],[0,0,0,"inner_writer",null,null,null,false],[0,0,0,"bytes_written",null,null,null,false],[0,0,0,"bits",null,null,null,false],[0,0,0,"nbits",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"codegen_freq",null,null,null,false],[0,0,0,"nbytes",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"literal_freq",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"offset_freq",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"codegen",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"literal_encoding",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"offset_encoding",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"codegen_encoding",null,null,null,false],[0,0,0,"err",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"fixed_literal_encoding",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"fixed_offset_encoding",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[92,63,0,null,null,null,null,false],[0,0,0,"huff_offset",null,null,null,false],[92,788,0,null,null,null,[13403,13404],false],[0,0,0,"size",null,null,null,false],[0,0,0,"num_codegens",null,null,null,false],[92,793,0,null,null,null,[13406,13407],false],[0,0,0,"size",null,null,null,false],[0,0,0,"storable",null,null,null,false],[92,798,0,null,null,null,[13409,13410],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"writer",null,"",null,false],[92,830,0,null,null,null,[13412,13413],false],[0,0,0,"b",null,"",null,false],[0,0,0,"h",null,"",null,false],[92,838,0,null,null,null,null,false],[92,839,0,null,null,null,null,false],[92,840,0,null,null,null,null,false],[92,841,0,null,null,null,null,false],[92,842,0,null,null,null,null,false],[92,844,0,null,null,null,null,false],[92,888,0,null,null,null,[13421,13422],false],[0,0,0,"in_name",null,"",null,true],[0,0,0,"want_name",null,"",null,true],[92,916,0,null,null,null,[13425,13427,13429,13431],false],[92,916,0,null,null,null,null,false],[0,0,0,"tokens",null,null,null,false],[92,916,0,null,null,null,null,false],[0,0,0,"input",null,null,null,false],[92,916,0,null,null,null,null,false],[0,0,0,"want",null,null,null,false],[92,916,0,null,null,null,null,false],[0,0,0,"want_no_input",null,null,null,false],[92,923,0,null,null,null,null,false],[92,925,0,null,null,null,null,false],[92,1556,0,null,null,null,[13437,13438,13439],false],[92,1561,0,null,null,null,[13436],false],[0,0,0,"self",null,"",null,false],[0,0,0,"write_block",null,null,null,false],[0,0,0,"write_dyn_block",null,null,null,false],[0,0,0,"write_huffman_block",null,null,null,false],[92,1602,0,null,null,null,[13441,13442],false],[0,0,0,"ht",null,"",null,true],[0,0,0,"ttype",null,"",null,true],[92,1658,0,null,null,null,[13444,13445,13446,13447],false],[0,0,0,"ttype",null,"",null,false],[0,0,0,"bw",null,"",null,false],[0,0,0,"tok",null,"",null,false],[0,0,0,"input",null,"",null,false],[92,1668,0,null,null,null,[13449,13450,13451],false],[0,0,0,"ttype",null,"",null,false],[0,0,0,"ht_tokens",null,"",null,false],[0,0,0,"input",null,"",null,false],[88,12,0,null,null,null,null,false],[88,14,0,null,null,null,[13454,13455,13456,13457,13458,13459,13460,13461,13462,13463,13464,13465],false],[0,0,0,"huffman_only",null," huffman_only disables Lempel-Ziv match searching and only performs Huffman\n entropy encoding. This mode is useful in compressing data that has\n already been compressed with an LZ style algorithm (e.g. Snappy or LZ4)\n that lacks an entropy encoder. Compression gains are achieved when\n certain bytes in the input stream occur more frequently than others.\n\n Note that huffman_only produces a compressed output that is\n RFC 1951 compliant. That is, any valid DEFLATE decompressor will\n continue to be able to decompress this output.",null,false],[0,0,0,"default_compression",null," Same as level_6",null,false],[0,0,0,"no_compression",null," Does not attempt any compression; only adds the necessary DEFLATE framing.",null,false],[0,0,0,"best_speed",null," Prioritizes speed over output size, based on Snappy's LZ77-style encoder",null,false],[0,0,0,"level_2",null,null,null,false],[0,0,0,"level_3",null,null,null,false],[0,0,0,"level_4",null,null,null,false],[0,0,0,"level_5",null,null,null,false],[0,0,0,"level_6",null,null,null,false],[0,0,0,"level_7",null,null,null,false],[0,0,0,"level_8",null,null,null,false],[0,0,0,"best_compression",null," Prioritizes smaller output size over speed",null,false],[88,42,0,null,null,null,null,false],[88,43,0,null,null,null,null,false],[88,44,0,null,null,null,null,false],[88,52,0,null,null,null,null,false],[88,53,0,null,null,null,null,false],[88,54,0,null,null,null,null,false],[88,55,0,null,null,null,null,false],[88,56,0,null,null,null,null,false],[88,60,0,null,null,null,null,false],[88,61,0,null,null,null,null,false],[88,62,0,null,null,null,null,false],[88,63,0,null,null,null,null,false],[88,64,0,null,null,null,null,false],[88,65,0,null,null,null,null,false],[88,67,0,null,null,null,null,false],[88,69,0,null,null,null,[13482,13483,13484,13485,13486],false],[0,0,0,"good",null,null,null,false],[0,0,0,"lazy",null,null,null,false],[0,0,0,"nice",null,null,null,false],[0,0,0,"chain",null,null,null,false],[0,0,0,"fast_skip_hashshing",null,null,null,false],[88,77,0,null,null,null,[13488],false],[0,0,0,"compression",null,"",null,false],[88,157,0,null,null,null,[13490,13491,13492],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"max",null,"",null,false],[88,168,0,null,null,null,null,false],[88,173,0,null,null,null,[13495],false],[0,0,0,"b",null,"",null,false],[88,182,0,null,null,null,[13497,13498],false],[0,0,0,"b",null,"",null,false],[0,0,0,"dst",null,"",null,false],[88,203,0,null,null,null,[13501,13503],false],[88,203,0,null,null,null,null,false],[0,0,0,"level",null,null,null,false],[88,203,0,null,null,null,null,false],[0,0,0,"dictionary",null,null,null,false],[88,224,0,null,null," Returns a new Compressor compressing data at the given level.\n Following zlib, levels range from 1 (best_speed) to 9 (best_compression);\n higher levels typically run slower but compress more. Level 0\n (no_compression) does not attempt any compression; it only adds the\n necessary DEFLATE framing.\n Level -1 (default_compression) uses the default compression level.\n Level -2 (huffman_only) will use Huffman compression only, giving\n a very fast compression for all types of input, but sacrificing considerable\n compression efficiency.\n\n `dictionary` is optional and initializes the new `Compressor` with a preset dictionary.\n The returned Compressor behaves as if the dictionary had been written to it without producing\n any compressed output. The compressed data written to hm_bw can only be decompressed by a\n Decompressor initialized with the same dictionary.\n\n The compressed data will be passed to the provided `writer`, see `writer()` and `write()`.",[13505,13506,13507],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"options",null,"",null,false],[88,232,0,null,null,null,[13509],false],[0,0,0,"WriterType",null,"",[13575,13577,13579,13581,13585,13586,13588,13589,13591,13593,13594,13595,13597,13598,13599,13600,13602,13603,13604,13605,13606,13607,13608,13610,13612],true],[88,234,0,null,null,null,null,false],[88,238,0,null,null," A Writer takes data written to it and writes the compressed\n form of that data to an underlying writer.",null,false],[88,242,0,null,null," Returns a Writer that takes data written to it and writes the compressed\n form of that data to an underlying writer.",[13513],false],[0,0,0,"self",null,"",null,false],[88,246,0,null,null,null,null,false],[88,294,0,null,null,null,[13516,13517],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[88,334,0,null,null,null,[13519,13520,13521],false],[0,0,0,"self",null,"",null,false],[0,0,0,"tokens",null,"",null,false],[0,0,0,"index",null,"",null,false],[88,351,0,null,null,null,[13523,13524],false],[0,0,0,"self",null,"",null,false],[0,0,0,"in_b",null,"",null,false],[88,409,0,null,null,null,[13526,13527,13528],false],[0,0,0,"length",null,null,null,false],[0,0,0,"offset",null,null,null,false],[0,0,0,"ok",null,null,null,false],[88,417,0,null,null,null,[13530,13531,13532,13533,13534],false],[0,0,0,"self",null,"",null,false],[0,0,0,"pos",null,"",null,false],[0,0,0,"prev_head",null,"",null,false],[0,0,0,"prev_length",null,"",null,false],[0,0,0,"lookahead",null,"",null,false],[88,486,0,null,null,null,[13536,13537],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buf",null,"",null,false],[88,493,0,null,null,null,[13539],false],[0,0,0,"self",null,"",null,false],[88,539,0,null,null,null,[13541],false],[0,0,0,"self",null,"",null,false],[88,554,0,null,null,null,[13543],false],[0,0,0,"self",null,"",null,false],[88,706,0,null,null,null,[13545,13546],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[88,712,0,null,null,null,[13548],false],[0,0,0,"self",null,"",null,false],[88,721,0,null,null,null,[13550],false],[0,0,0,"self",null,"",null,false],[88,730,0,null,null,null,[13552],false],[0,0,0,"self",null,"",null,false],[88,735,0,null,null," Writes the compressed form of `input` to the underlying writer.",[13554,13555],false],[0,0,0,"self",null,"",null,false],[0,0,0,"input",null,"",null,false],[88,758,0,null,null," Flushes any pending data to the underlying writer.\n It is useful mainly in compressed network protocols, to ensure that\n a remote reader has enough data to reconstruct a packet.\n Flush does not return until the data has been written.\n Calling `flush()` when there is no pending data still causes the Writer\n to emit a sync marker of at least 4 bytes.\n If the underlying writer returns an error, `flush()` returns that error.\n\n In the terminology of the zlib library, Flush is equivalent to Z_SYNC_FLUSH.",[13557],false],[0,0,0,"self",null,"",null,false],[88,767,0,null,null,null,[13559],false],[0,0,0,"self",null,"",null,false],[88,785,0,null,null,null,[13561,13562],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[88,803,0,null,null,null,[13564,13565,13566],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"in_writer",null,"",null,false],[0,0,0,"options",null,"",null,false],[88,897,0,null,null," Release all allocated memory.",[13568],false],[0,0,0,"self",null,"",null,false],[88,912,0,null,null," Reset discards the inner writer's state and replace the inner writer with new_writer.\n new_writer must be of the same type as the previous writer.",[13570,13571],false],[0,0,0,"self",null,"",null,false],[0,0,0,"new_writer",null,"",null,false],[88,958,0,null,null," Writes any pending data to the underlying writer.",[13573],false],[0,0,0,"self",null,"",null,false],[88,233,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"compression",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"compression_level",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"hm_bw",null,null,null,false],[88,233,0,null,null,null,[13583,13584],false],[0,0,0,"",null,"",null,false],[0,0,0,"",null,"",null,false],[0,0,0,"bulk_hasher",null,null,null,false],[0,0,0,"sync",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"best_speed_enc",null,null,null,false],[0,0,0,"chain_head",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"hash_head",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"hash_prev",null,null,null,false],[0,0,0,"hash_offset",null,null,null,false],[0,0,0,"index",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"window",null,null,null,false],[0,0,0,"window_end",null,null,null,false],[0,0,0,"block_start",null,null,null,false],[0,0,0,"byte_available",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"tokens",null,null,null,false],[0,0,0,"tokens_count",null,null,null,false],[0,0,0,"length",null,null,null,false],[0,0,0,"offset",null,null,null,false],[0,0,0,"hash",null,null,null,false],[0,0,0,"max_insert_index",null,null,null,false],[0,0,0,"err",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"hash_match",null,null,null,false],[88,233,0,null,null,null,null,false],[0,0,0,"dictionary",null,null,null,false],[88,970,0,null,null,null,null,false],[88,971,0,null,null,null,null,false],[88,973,0,null,null,null,null,false],[88,975,0,null,null,null,[13618,13620,13622],false],[88,975,0,null,null,null,null,false],[0,0,0,"in",null,null,null,false],[88,975,0,null,null,null,null,false],[0,0,0,"level",null,null,null,false],[88,975,0,null,null,null,null,false],[0,0,0,"out",null,null,null,false],[88,981,0,null,null,null,null,false],[87,4,0,null,null,null,null,false],[0,0,0,"deflate/decompressor.zig",null,"",[],false],[95,0,0,null,null,null,null,false],[95,1,0,null,null,null,null,false],[95,2,0,null,null,null,null,false],[95,3,0,null,null,null,null,false],[95,5,0,null,null,null,null,false],[95,6,0,null,null,null,null,false],[95,8,0,null,null,null,null,false],[95,9,0,null,null,null,null,false],[0,0,0,"dict_decoder.zig",null,"",[],false],[96,0,0,null,null,null,null,false],[96,1,0,null,null,null,null,false],[96,2,0,null,null,null,null,false],[96,4,0,null,null,null,null,false],[96,26,0,null,null,null,[13676,13678,13679,13680,13681],false],[96,27,0,null,null,null,null,false],[96,41,0,null,null,null,[13642,13643,13644,13645],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"size",null,"",null,false],[0,0,0,"dict",null,"",null,false],[96,61,0,null,null,null,[13647],false],[0,0,0,"self",null,"",null,false],[96,66,0,null,null,null,[13649],false],[0,0,0,"self",null,"",null,false],[96,74,0,null,null,null,[13651],false],[0,0,0,"self",null,"",null,false],[96,79,0,null,null,null,[13653],false],[0,0,0,"self",null,"",null,false],[96,86,0,null,null,null,[13655],false],[0,0,0,"self",null,"",null,false],[96,93,0,null,null,null,[13657,13658],false],[0,0,0,"self",null,"",null,false],[0,0,0,"count",null,"",null,false],[96,101,0,null,null,null,[13660,13661],false],[0,0,0,"self",null,"",null,false],[0,0,0,"byte",null,"",null,false],[96,109,0,null,null," TODO: eliminate this function because the callsites should care about whether\n or not their arguments alias and then they should directly call `@memcpy` or\n `mem.copyForwards`.",[13663,13664],false],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[96,123,0,null,null,null,[13666,13667,13668],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dist",null,"",null,false],[0,0,0,"length",null,"",null,false],[96,175,0,null,null,null,[13670,13671,13672],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dist",null,"",null,false],[0,0,0,"length",null,"",null,false],[96,196,0,null,null,null,[13674],false],[0,0,0,"self",null,"",null,false],[96,26,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[96,26,0,null,null,null,null,false],[0,0,0,"hist",null,null,null,false],[0,0,0,"wr_pos",null,null,null,false],[0,0,0,"rd_pos",null,null,null,false],[0,0,0,"full",null,null,null,false],[95,10,0,null,null,null,null,false],[95,12,0,null,null,null,null,false],[95,13,0,null,null,null,null,false],[95,15,0,null,null,null,null,false],[95,19,0,null,null,null,null,false],[95,20,0,null,null,null,null,false],[95,21,0,null,null,null,null,false],[95,23,0,null,null,null,null,false],[95,25,0,null,null,null,null,false],[95,53,0,null,null,null,null,false],[95,54,0,null,null,null,null,false],[95,55,0,null,null,null,null,false],[95,56,0,null,null,null,null,false],[95,58,0,null,null,null,[13704,13705,13707,13709,13710,13711,13713],false],[95,59,0,null,null,null,null,false],[95,75,0,null,null,null,[13698,13699,13700],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"lengths",null,"",null,false],[95,242,0,null,null," Release all allocated memory.",[13702],false],[0,0,0,"self",null,"",null,false],[95,58,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[0,0,0,"min",null,null,null,false],[95,58,0,null,null,null,null,false],[0,0,0,"chunks",null,null,null,false],[95,58,0,null,null,null,null,false],[0,0,0,"links",null,null,null,false],[0,0,0,"link_mask",null,null,null,false],[0,0,0,"initialized",null,null,null,false],[95,58,0,null,null,null,null,false],[0,0,0,"sub_chunks",null,null,null,false],[95,254,0,null,null,null,null,false],[95,256,0,null,null,null,[13716],false],[0,0,0,"allocator",null,"",null,false],[95,282,0,null,null,null,[13718,13719],false],[0,0,0,"init",null,null,null,false],[0,0,0,"dict",null,null,null,false],[95,294,0,null,null," Returns a new Decompressor that can be used to read the uncompressed version of `reader`.\n `dictionary` is optional and initializes the Decompressor with a preset dictionary.\n The returned Decompressor behaves as if the uncompressed data stream started with the given\n dictionary, which has already been read. Use the same `dictionary` as the compressor used to\n compress the data.\n This decompressor may use at most 300 KiB of heap memory from the provided allocator.\n The uncompressed data will be written into the provided buffer, see `reader()` and `read()`.",[13721,13722,13723],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"dictionary",null,"",null,false],[95,298,0,null,null,null,[13725],false],[0,0,0,"ReaderType",null,"",[13765,13767,13768,13769,13770,13772,13774,13776,13778,13780,13782,13785,13787,13788,13790,13792,13794,13796,13797,13798],true],[95,300,0,null,null,null,null,false],[95,302,0,null,null,null,null,false],[95,307,0,null,null,null,null,false],[95,349,0,null,null," Returns a Reader that reads compressed data from an underlying reader and outputs\n uncompressed data.",[13730],false],[0,0,0,"self",null,"",null,false],[95,353,0,null,null,null,[13732,13733,13734],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"in_reader",null,"",null,false],[0,0,0,"dict",null,"",null,false],[95,401,0,null,null," Release all allocated memory.",[13736],false],[0,0,0,"self",null,"",null,false],[95,409,0,null,null,null,[13738],false],[0,0,0,"self",null,"",null,false],[95,449,0,null,null," Reads compressed data from the underlying reader and outputs uncompressed data into\n `output`.",[13740,13741],false],[0,0,0,"self",null,"",null,false],[0,0,0,"output",null,"",null,false],[95,479,0,null,null,null,[13743],false],[0,0,0,"self",null,"",null,false],[95,489,0,null,null,null,null,false],[95,491,0,null,null,null,[13746],false],[0,0,0,"self",null,"",null,false],[95,615,0,null,null,null,[13748],false],[0,0,0,"self",null,"",null,false],[95,752,0,null,null,null,[13750],false],[0,0,0,"self",null,"",null,false],[95,785,0,null,null,null,[13752],false],[0,0,0,"self",null,"",null,false],[95,810,0,null,null,null,[13754],false],[0,0,0,"self",null,"",null,false],[95,820,0,null,null,null,[13756],false],[0,0,0,"self",null,"",null,false],[95,834,0,null,null,null,[13758,13759],false],[0,0,0,"self",null,"",null,false],[0,0,0,"h",null,"",null,false],[95,882,0,null,null," Replaces the inner reader and dictionary with new_reader and new_dict.\n new_reader must be of the same type as the reader being replaced.",[13761,13762,13763],false],[0,0,0,"s",null,"",null,false],[0,0,0,"new_reader",null,"",null,false],[0,0,0,"new_dict",null,"",null,false],[95,299,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"inner_reader",null,null,null,false],[0,0,0,"roffset",null,null,null,false],[0,0,0,"b",null,null,null,false],[0,0,0,"nb",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"hd1",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"hd2",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"bits",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"codebits",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"dict",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"buf",null,null,null,false],[95,299,0,null,null,null,[13784],false],[0,0,0,"",null,"",null,false],[0,0,0,"step",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"step_state",null,null,null,false],[0,0,0,"final",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"err",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"to_read",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"hl",null,null,null,false],[95,299,0,null,null,null,null,false],[0,0,0,"hd",null,null,null,false],[0,0,0,"copy_len",null,null,null,false],[0,0,0,"copy_dist",null,null,null,false],[95,896,0,null,null,null,null,false],[95,897,0,null,null,null,null,false],[95,898,0,null,null,null,null,false],[95,1083,0,null,null,null,[13803],false],[0,0,0,"input",null,"",null,false],[87,6,0,null,null,null,null,false],[87,7,0,null,null,null,null,false],[87,8,0,null,null,null,null,false],[87,9,0,null,null,null,null,false],[87,11,0,null,null,null,null,false],[87,12,0,null,null,null,null,false],[87,18,0,null,null," Copies elements from a source `src` slice into a destination `dst` slice.\n The copy never returns an error but might not be complete if the destination is too small.\n Returns the number of elements copied, which will be the minimum of `src.len` and `dst.len`.\n TODO: remove this smelly function",[13811,13812],false],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[86,3,0,null,null,null,null,false],[0,0,0,"compress/gzip.zig",null,"",[],false],[97,3,0,null,null,null,null,false],[97,4,0,null,null,null,null,false],[97,5,0,null,null,null,null,false],[97,6,0,null,null,null,null,false],[97,7,0,null,null,null,null,false],[97,8,0,null,null,null,null,false],[97,11,0,null,null,null,null,false],[97,12,0,null,null,null,null,false],[97,13,0,null,null,null,null,false],[97,14,0,null,null,null,null,false],[97,15,0,null,null,null,null,false],[97,17,0,null,null,null,null,false],[97,19,0,null,null,null,[13828],false],[0,0,0,"ReaderType",null,"",[13843,13845,13847,13849,13850,13860],true],[97,21,0,null,null,null,null,false],[97,23,0,null,null,null,null,false],[97,26,0,null,null,null,null,false],[97,42,0,null,null,null,[13833,13834],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"source",null,"",null,false],[97,111,0,null,null,null,[13836],false],[0,0,0,"self",null,"",null,false],[97,122,0,null,null,null,[13838,13839],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[97,147,0,null,null,null,[13841],false],[0,0,0,"self",null,"",null,false],[97,20,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[97,20,0,null,null,null,null,false],[0,0,0,"inflater",null,null,null,false],[97,20,0,null,null,null,null,false],[0,0,0,"in_reader",null,null,null,false],[97,20,0,null,null,null,null,false],[0,0,0,"hasher",null,null,null,false],[0,0,0,"read_amt",null,null,null,false],[97,20,0,null,null,null,[13853,13855,13857,13858,13859],false],[97,34,0,null,null,null,null,false],[0,0,0,"extra",null,null,null,false],[97,34,0,null,null,null,null,false],[0,0,0,"filename",null,null,null,false],[97,34,0,null,null,null,null,false],[0,0,0,"comment",null,null,null,false],[0,0,0,"modification_time",null,null,null,false],[0,0,0,"operating_system",null,null,null,false],[0,0,0,"info",null,null,null,false],[97,153,0,null,null,null,[13862,13863],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[97,157,0,null,null,null,[13865,13866],false],[0,0,0,"data",null,"",null,false],[0,0,0,"expected",null,"",null,true],[86,4,0,null,null,null,null,false],[0,0,0,"compress/lzma.zig",null,"",[],false],[98,0,0,null,null,null,null,false],[98,1,0,null,null,null,null,false],[98,2,0,null,null,null,null,false],[98,3,0,null,null,null,null,false],[98,5,0,null,null,null,null,false],[0,0,0,"lzma/decode.zig",null,"",[],false],[99,0,0,null,null,null,null,false],[99,1,0,null,null,null,null,false],[99,2,0,null,null,null,null,false],[99,3,0,null,null,null,null,false],[99,5,0,null,null,null,null,false],[0,0,0,"decode/lzbuffer.zig",null,"",[],false],[100,0,0,null,null,null,null,false],[100,1,0,null,null,null,null,false],[100,2,0,null,null,null,null,false],[100,3,0,null,null,null,null,false],[100,4,0,null,null,null,null,false],[100,7,0,null,null," An accumulating buffer for LZ sequences",[13921,13922,13923],false],[100,17,0,null,null,null,null,false],[100,19,0,null,null,null,[13889],false],[0,0,0,"memlimit",null,"",null,false],[100,27,0,null,null,null,[13891,13892,13893],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"byte",null,"",null,false],[100,33,0,null,null," Reset the internal dictionary",[13895,13896],false],[0,0,0,"self",null,"",null,false],[0,0,0,"writer",null,"",null,false],[100,40,0,null,null," Retrieve the last byte or return a default",[13898,13899],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lit",null,"",null,false],[100,49,0,null,null," Retrieve the n-th last byte",[13901,13902],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dist",null,"",null,false],[100,59,0,null,null," Append a literal",[13904,13905,13906,13907],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"lit",null,"",null,false],[0,0,0,"writer",null,"",null,false],[100,74,0,null,null," Fetch an LZ sequence (length, distance) from inside the buffer",[13909,13910,13911,13912,13913],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"dist",null,"",null,false],[0,0,0,"writer",null,"",null,false],[100,98,0,null,null,null,[13915,13916],false],[0,0,0,"self",null,"",null,false],[0,0,0,"writer",null,"",null,false],[100,103,0,null,null,null,[13918,13919],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[100,7,0,null,null,null,null,false],[0,0,0,"buf",null," Buffer",null,false],[0,0,0,"memlimit",null," Buffer memory limit",null,false],[0,0,0,"len",null," Total number of bytes sent through the buffer",null,false],[100,110,0,null,null," A circular buffer for LZ sequences",[13961,13962,13963,13964,13965],false],[100,126,0,null,null,null,null,false],[100,128,0,null,null,null,[13927,13928],false],[0,0,0,"dict_size",null,"",null,false],[0,0,0,"memlimit",null,"",null,false],[100,138,0,null,null,null,[13930,13931],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[100,145,0,null,null,null,[13933,13934,13935,13936],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"value",null,"",null,false],[100,157,0,null,null," Retrieve the last byte or return a default",[13938,13939],false],[0,0,0,"self",null,"",null,false],[0,0,0,"lit",null,"",null,false],[100,165,0,null,null," Retrieve the n-th last byte",[13941,13942],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dist",null,"",null,false],[100,175,0,null,null," Append a literal",[13944,13945,13946,13947],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"lit",null,"",null,false],[0,0,0,"writer",null,"",null,false],[100,193,0,null,null," Fetch an LZ sequence (length, distance) from inside the buffer",[13949,13950,13951,13952,13953],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"len",null,"",null,false],[0,0,0,"dist",null,"",null,false],[0,0,0,"writer",null,"",null,false],[100,216,0,null,null,null,[13955,13956],false],[0,0,0,"self",null,"",null,false],[0,0,0,"writer",null,"",null,false],[100,223,0,null,null,null,[13958,13959],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[100,110,0,null,null,null,null,false],[0,0,0,"buf",null," Circular buffer",null,false],[0,0,0,"dict_size",null," Length of the buffer",null,false],[0,0,0,"memlimit",null," Buffer memory limit",null,false],[0,0,0,"cursor",null," Current position",null,false],[0,0,0,"len",null," Total number of bytes sent through the buffer",null,false],[99,6,0,null,null,null,null,false],[0,0,0,"decode/rangecoder.zig",null,"",[],false],[101,0,0,null,null,null,null,false],[101,1,0,null,null,null,null,false],[101,3,0,null,null,null,[14010,14011],false],[101,7,0,null,null,null,[13972],false],[0,0,0,"reader",null,"",null,false],[101,18,0,null,null,null,[13974,13975],false],[0,0,0,"range",null,"",null,false],[0,0,0,"code",null,"",null,false],[101,28,0,null,null,null,[13977,13978,13979],false],[0,0,0,"self",null,"",null,false],[0,0,0,"range",null,"",null,false],[0,0,0,"code",null,"",null,false],[101,33,0,null,null,null,[13981],false],[0,0,0,"self",null,"",null,false],[101,37,0,null,null,null,[13983,13984],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[101,44,0,null,null,null,[13986,13987],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[101,55,0,null,null,null,[13989,13990,13991],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"count",null,"",null,false],[101,63,0,null,null,null,[13993,13994,13995,13996],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"prob",null,"",null,false],[0,0,0,"update",null,"",null,false],[101,84,0,null,null,null,[13998,13999,14000,14001,14002],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"num_bits",null,"",null,false],[0,0,0,"probs",null,"",null,false],[0,0,0,"update",null,"",null,false],[101,100,0,null,null,null,[14004,14005,14006,14007,14008,14009],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"num_bits",null,"",null,false],[0,0,0,"probs",null,"",null,false],[0,0,0,"offset",null,"",null,false],[0,0,0,"update",null,"",null,false],[0,0,0,"range",null,null,null,false],[0,0,0,"code",null,null,null,false],[101,120,0,null,null,null,[14013],false],[0,0,0,"num_bits",null,"",[14028],true],[101,124,0,null,null,null,null,false],[101,126,0,null,null,null,[14016,14017,14018,14019],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"update",null,"",null,false],[101,135,0,null,null,null,[14021,14022,14023,14024],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"update",null,"",null,false],[101,144,0,null,null,null,[14026],false],[0,0,0,"self",null,"",null,false],[101,121,0,null,null,null,null,false],[0,0,0,"probs",null,null,null,false],[101,150,0,null,null,null,[14038,14039,14041,14043,14045],false],[101,157,0,null,null,null,[14031,14032,14033,14034,14035],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"pos_state",null,"",null,false],[0,0,0,"update",null,"",null,false],[101,173,0,null,null,null,[14037],false],[0,0,0,"self",null,"",null,false],[0,0,0,"choice",null,null,null,false],[0,0,0,"choice2",null,null,null,false],[101,150,0,null,null,null,null,false],[0,0,0,"low_coder",null,null,null,false],[101,150,0,null,null,null,null,false],[0,0,0,"mid_coder",null,null,null,false],[101,150,0,null,null,null,null,false],[0,0,0,"high_coder",null,null,null,false],[99,8,0,null,null,null,null,false],[99,9,0,null,null,null,null,false],[99,10,0,null,null,null,null,false],[99,11,0,null,null,null,null,false],[99,12,0,null,null,null,null,false],[0,0,0,"vec2d.zig",null,"",[],false],[102,0,0,null,null,null,null,false],[102,1,0,null,null,null,null,false],[102,2,0,null,null,null,null,false],[102,3,0,null,null,null,null,false],[102,5,0,null,null,null,[14057],false],[0,0,0,"T",null,"",[14081,14082],true],[102,10,0,null,null,null,null,false],[102,12,0,null,null,null,[14060,14061,14062],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"value",null,"",null,false],[0,0,0,"size",null,"",[14063,14064],false],[0,0,0,"",null,null,null,false],[0,0,0,"",null,null,null,false],[102,22,0,null,null,null,[14066,14067],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[102,27,0,null,null,null,[14069,14070],false],[0,0,0,"self",null,"",null,false],[0,0,0,"value",null,"",null,false],[102,31,0,null,null,null,[14072,14073],false],[0,0,0,"self",null,"",null,false],[0,0,0,"row",null,"",null,false],[102,37,0,null,null,null,[14075,14076],false],[0,0,0,"self",null,"",null,false],[0,0,0,"row",null,"",null,false],[102,41,0,null,null,null,[14078,14079],false],[0,0,0,"self",null,"",null,false],[0,0,0,"row",null,"",null,false],[102,6,0,null,null,null,null,false],[0,0,0,"data",null,null,null,false],[0,0,0,"cols",null,null,null,false],[102,47,0,null,null,null,null,false],[102,48,0,null,null,null,null,false],[102,49,0,null,null,null,null,false],[99,14,0,null,null,null,[14088,14090,14091],false],[99,14,0,null,null,null,null,false],[0,0,0,"unpacked_size",null,null,null,false],[99,14,0,null,null,null,null,false],[0,0,0,"memlimit",null,null,null,false],[0,0,0,"allow_incomplete",null,null,null,false],[99,20,0,null,null,null,[14093,14094,14095],false],[0,0,0,"read_from_header",null,null,null,false],[0,0,0,"read_header_but_use_provided",null,null,null,false],[0,0,0,"use_provided",null,null,null,false],[99,26,0,null,null,null,[14097,14098],false],[0,0,0,"continue_",null,null,null,false],[0,0,0,"finished",null,null,null,false],[99,31,0,null,null,null,[14103,14105,14107],false],[99,36,0,null,null,null,[14101],false],[0,0,0,"self",null,"",null,false],[99,31,0,null,null,null,null,false],[0,0,0,"lc",null,null,null,false],[99,31,0,null,null,null,null,false],[0,0,0,"lp",null,null,null,false],[99,31,0,null,null,null,null,false],[0,0,0,"pb",null,null,null,false],[99,43,0,null,null,null,[14113,14114,14116],false],[99,48,0,null,null,null,[14110,14111],false],[0,0,0,"reader",null,"",null,false],[0,0,0,"options",null,"",null,false],[99,43,0,null,null,null,null,false],[0,0,0,"properties",null,null,null,false],[0,0,0,"dict_size",null,null,null,false],[99,43,0,null,null,null,null,false],[0,0,0,"unpacked_size",null,null,null,false],[99,87,0,null,null,null,[14164,14166,14168,14170,14172,14174,14176,14178,14180,14182,14184,14186,14187,14189,14191,14193],false],[99,105,0,null,null,null,[14119,14120,14121],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"lzma_props",null,"",null,false],[0,0,0,"unpacked_size",null,"",null,false],[99,130,0,null,null,null,[14123,14124],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[99,135,0,null,null,null,[14126,14127,14128],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"new_props",null,"",null,false],[99,160,0,null,null,null,[14130,14131,14132,14133,14134,14135,14136],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"update",null,"",null,false],[99,264,0,null,null,null,[14138,14139,14140,14141,14142,14143],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[99,275,0,null,null,null,[14145,14146,14147,14148,14149,14150],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[99,307,0,null,null,null,[14152,14153,14154,14155,14156],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"update",null,"",null,false],[99,347,0,null,null,null,[14158,14159,14160,14161,14162],false],[0,0,0,"self",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"decoder",null,"",null,false],[0,0,0,"length",null,"",null,false],[0,0,0,"update",null,"",null,false],[99,87,0,null,null,null,null,false],[0,0,0,"lzma_props",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"unpacked_size",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"literal_probs",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"pos_slot_decoder",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"align_decoder",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"pos_decoders",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"is_match",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"is_rep",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"is_rep_g0",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"is_rep_g1",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"is_rep_g2",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"is_rep_0long",null,null,null,false],[0,0,0,"state",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"rep",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"len_decoder",null,null,null,false],[99,87,0,null,null,null,null,false],[0,0,0,"rep_len_decoder",null,null,null,false],[98,7,0,null,null,null,[14195,14196],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[98,14,0,null,null,null,[14198,14199,14200],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"options",null,"",null,false],[98,23,0,null,null,null,[14202],false],[0,0,0,"ReaderType",null,"",[14219,14221,14223,14225,14227,14229],true],[98,25,0,null,null,null,null,false],[98,27,0,null,null,null,null,false],[98,32,0,null,null,null,null,false],[98,42,0,null,null,null,[14207,14208,14209,14210],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"params",null,"",null,false],[0,0,0,"memlimit",null,"",null,false],[98,54,0,null,null,null,[14212],false],[0,0,0,"self",null,"",null,false],[98,58,0,null,null,null,[14214],false],[0,0,0,"self",null,"",null,false],[98,65,0,null,null,null,[14216,14217],false],[0,0,0,"self",null,"",null,false],[0,0,0,"output",null,"",null,false],[98,24,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[98,24,0,null,null,null,null,false],[0,0,0,"in_reader",null,null,null,false],[98,24,0,null,null,null,null,false],[0,0,0,"to_read",null,null,null,false],[98,24,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[98,24,0,null,null,null,null,false],[0,0,0,"decoder",null,null,null,false],[98,24,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[86,5,0,null,null,null,null,false],[0,0,0,"compress/lzma2.zig",null,"",[],false],[103,0,0,null,null,null,null,false],[103,1,0,null,null,null,null,false],[103,3,0,null,null,null,null,false],[0,0,0,"lzma2/decode.zig",null,"",[],false],[104,0,0,null,null,null,null,false],[104,1,0,null,null,null,null,false],[104,3,0,null,null,null,null,false],[104,4,0,null,null,null,null,false],[104,5,0,null,null,null,null,false],[104,6,0,null,null,null,null,false],[104,7,0,null,null,null,null,false],[104,9,0,null,null,null,[14268],false],[104,12,0,null,null,null,[14245],false],[0,0,0,"allocator",null,"",null,false],[104,26,0,null,null,null,[14247,14248],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[104,31,0,null,null,null,[14250,14251,14252,14253],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[104,54,0,null,null,null,[14255,14256,14257,14258,14259,14260],false],[0,0,0,"self",null,"",null,false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"accum",null,"",null,false],[0,0,0,"status",null,"",null,false],[104,150,0,null,null,null,[14262,14263,14264,14265,14266],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"accum",null,"",null,false],[0,0,0,"reset_dict",null,"",null,false],[104,9,0,null,null,null,null,false],[0,0,0,"lzma_state",null,null,null,false],[103,5,0,null,null,null,[14270,14271,14272],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"writer",null,"",null,false],[86,6,0,null,null,null,null,false],[0,0,0,"compress/xz.zig",null,"",[],false],[105,0,0,null,null,null,null,false],[105,1,0,null,null,null,null,false],[0,0,0,"xz/block.zig",null,"",[],false],[106,0,0,null,null,null,null,false],[106,1,0,null,null,null,null,false],[106,2,0,null,null,null,null,false],[106,3,0,null,null,null,null,false],[106,4,0,null,null,null,null,false],[106,5,0,null,null,null,null,false],[106,6,0,null,null,null,null,false],[106,7,0,null,null,null,null,false],[106,9,0,null,null,null,null,false],[106,18,0,null,null,null,[14288,14289,14290],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"check",null,"",null,false],[106,22,0,null,null,null,[14292],false],[0,0,0,"ReaderType",null,"",[14310,14312,14314,14316,14318,14319],true],[106,24,0,null,null,null,null,false],[106,25,0,null,null,null,null,false],[106,29,0,null,null,null,null,false],[106,38,0,null,null,null,[14297,14298,14299],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"in_reader",null,"",null,false],[0,0,0,"check",null,"",null,false],[106,49,0,null,null,null,[14301],false],[0,0,0,"self",null,"",null,false],[106,53,0,null,null,null,[14303],false],[0,0,0,"self",null,"",null,false],[106,57,0,null,null,null,[14305,14306],false],[0,0,0,"self",null,"",null,false],[0,0,0,"output",null,"",null,false],[106,85,0,null,null,null,[14308],false],[0,0,0,"self",null,"",null,false],[106,23,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[106,23,0,null,null,null,null,false],[0,0,0,"inner_reader",null,null,null,false],[106,23,0,null,null,null,null,false],[0,0,0,"check",null,null,null,false],[106,23,0,null,null,null,null,false],[0,0,0,"err",null,null,null,false],[106,23,0,null,null,null,null,false],[0,0,0,"to_read",null,null,null,false],[0,0,0,"block_count",null,null,null,false],[105,2,0,null,null,null,null,false],[105,3,0,null,null,null,null,false],[105,5,0,null,null,null,[14323,14324,14325,14326],false],[0,0,0,"none",null,null,null,false],[0,0,0,"crc32",null,null,null,false],[0,0,0,"crc64",null,null,null,false],[0,0,0,"sha256",null,null,null,false],[105,13,0,null,null,null,[14328,14329],false],[0,0,0,"reader",null,"",null,false],[0,0,0,"check",null,"",null,false],[105,27,0,null,null,null,[14331,14332],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[105,31,0,null,null,null,[14334],false],[0,0,0,"ReaderType",null,"",[14349,14351,14353],true],[105,33,0,null,null,null,null,false],[105,35,0,null,null,null,null,false],[105,36,0,null,null,null,null,false],[105,42,0,null,null,null,[14339,14340],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"source",null,"",null,false],[105,65,0,null,null,null,[14342],false],[0,0,0,"self",null,"",null,false],[105,69,0,null,null,null,[14344],false],[0,0,0,"self",null,"",null,false],[105,73,0,null,null,null,[14346,14347],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[105,32,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[105,32,0,null,null,null,null,false],[0,0,0,"block_decoder",null,null,null,false],[105,32,0,null,null,null,null,false],[0,0,0,"in_reader",null,null,null,false],[86,7,0,null,null,null,null,false],[0,0,0,"compress/zlib.zig",null,"",[],false],[107,3,0,null,null,null,null,false],[107,4,0,null,null,null,null,false],[107,5,0,null,null,null,null,false],[107,6,0,null,null,null,null,false],[107,7,0,null,null,null,null,false],[107,8,0,null,null,null,null,false],[107,11,0,null,null,null,[14366,14367,14369,14371,14373],false],[107,18,0,null,null,null,null,false],[107,19,0,null,null,null,null,false],[107,11,0,null,null,null,null,false],[0,0,0,"checksum",null,null,null,false],[0,0,0,"preset_dict",null,null,null,false],[107,11,0,null,null,null,null,false],[0,0,0,"compression_level",null,null,null,false],[107,11,0,null,null,null,null,false],[0,0,0,"compression_method",null,null,null,false],[107,11,0,null,null,null,null,false],[0,0,0,"compression_info",null,null,null,false],[107,22,0,null,null,null,[14375],false],[0,0,0,"ReaderType",null,"",[14390,14392,14394,14396],true],[107,24,0,null,null,null,null,false],[107,26,0,null,null,null,null,false],[107,29,0,null,null,null,null,false],[107,36,0,null,null,null,[14380,14381],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"source",null,"",null,false],[107,66,0,null,null,null,[14383],false],[0,0,0,"self",null,"",null,false],[107,71,0,null,null,null,[14385,14386],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[107,90,0,null,null,null,[14388],false],[0,0,0,"self",null,"",null,false],[107,23,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[107,23,0,null,null,null,null,false],[0,0,0,"inflater",null,null,null,false],[107,23,0,null,null,null,null,false],[0,0,0,"in_reader",null,null,null,false],[107,23,0,null,null,null,null,false],[0,0,0,"hasher",null,null,null,false],[107,96,0,null,null,null,[14398,14399],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[107,100,0,null,null,null,[14401,14402,14403,14404],false],[0,0,0,"no_compression",null,null,null,false],[0,0,0,"fastest",null,null,null,false],[0,0,0,"default",null,null,null,false],[0,0,0,"maximum",null,null,null,false],[107,107,0,null,null,null,[14407],false],[107,107,0,null,null,null,null,false],[0,0,0,"level",null,null,null,false],[107,111,0,null,null,null,[14409],false],[0,0,0,"WriterType",null,"",[14427,14429,14431,14433],true],[107,113,0,null,null,null,null,false],[107,115,0,null,null,null,null,false],[107,117,0,null,null,null,null,false],[107,124,0,null,null,null,[14414,14415,14416],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"options",null,"",null,false],[107,151,0,null,null,null,[14418,14419],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[107,162,0,null,null,null,[14421],false],[0,0,0,"self",null,"",null,false],[107,166,0,null,null,null,[14423],false],[0,0,0,"self",null,"",null,false],[107,170,0,null,null,null,[14425],false],[0,0,0,"self",null,"",null,false],[107,112,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[107,112,0,null,null,null,null,false],[0,0,0,"deflator",null,null,null,false],[107,112,0,null,null,null,null,false],[0,0,0,"in_writer",null,null,null,false],[107,112,0,null,null,null,null,false],[0,0,0,"hasher",null,null,null,false],[107,178,0,null,null,null,[14435,14436,14437],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"writer",null,"",null,false],[0,0,0,"options",null,"",null,false],[107,182,0,null,null,null,[14439,14440],false],[0,0,0,"data",null,"",null,false],[0,0,0,"expected",null,"",null,false],[86,8,0,null,null,null,null,false],[0,0,0,"compress/zstandard.zig",null,"",[],false],[108,0,0,null,null,null,null,false],[108,1,0,null,null,null,null,false],[108,2,0,null,null,null,null,false],[108,4,0,null,null,null,null,false],[0,0,0,"zstandard/types.zig",null,"",[],false],[109,0,0,null,null,null,[],false],[109,1,0,null,null,null,[14450,14451],false],[0,0,0,"zstandard",null,null,null,false],[0,0,0,"skippable",null,null,null,false],[109,3,0,null,null,null,[14485,14487,14489],false],[109,4,0,null,null,null,null,false],[109,10,0,null,null,null,[14465,14467,14469,14471],false],[109,16,0,null,null,null,[14457,14458,14459,14460,14461,14463],false],[109,16,0,null,null,null,null,false],[0,0,0,"dictionary_id_flag",null,null,null,false],[0,0,0,"content_checksum_flag",null,null,null,false],[0,0,0,"reserved",null,null,null,false],[0,0,0,"unused",null,null,null,false],[0,0,0,"single_segment_flag",null,null,null,false],[109,16,0,null,null,null,null,false],[0,0,0,"content_size_flag",null,null,null,false],[109,10,0,null,null,null,null,false],[0,0,0,"descriptor",null,null,null,false],[109,10,0,null,null,null,null,false],[0,0,0,"window_descriptor",null,null,null,false],[109,10,0,null,null,null,null,false],[0,0,0,"dictionary_id",null,null,null,false],[109,10,0,null,null,null,null,false],[0,0,0,"content_size",null,null,null,false],[109,26,0,null,null,null,[],false],[109,27,0,null,null,null,[14474,14476,14478],false],[0,0,0,"last_block",null,null,null,false],[109,27,0,null,null,null,null,false],[0,0,0,"block_type",null,null,null,false],[109,27,0,null,null,null,null,false],[0,0,0,"block_size",null,null,null,false],[109,33,0,null,null,null,[14480,14481,14482,14483],false],[0,0,0,"raw",null,null,null,false],[0,0,0,"rle",null,null,null,false],[0,0,0,"compressed",null,null,null,false],[0,0,0,"reserved",null,null,null,false],[109,3,0,null,null,null,null,false],[0,0,0,"header",null,null,null,false],[109,3,0,null,null,null,null,false],[0,0,0,"data_blocks",null,null,null,false],[109,3,0,null,null,null,null,false],[0,0,0,"checksum",null,null,null,false],[109,42,0,null,null,null,[],false],[109,43,0,null,null,null,null,false],[109,44,0,null,null,null,null,false],[109,46,0,null,null,null,[14494,14495],false],[0,0,0,"magic_number",null,null,null,false],[0,0,0,"frame_size",null,null,null,false],[109,53,0,null,null,null,[],false],[109,54,0,null,null,null,[14543,14545,14547],false],[109,59,0,null,null,null,[14499,14500],false],[0,0,0,"one",null,null,null,false],[0,0,0,"four",null,null,null,false],[109,64,0,null,null,null,[14503,14505,14507,14509],false],[109,64,0,null,null,null,null,false],[0,0,0,"block_type",null,null,null,false],[109,64,0,null,null,null,null,false],[0,0,0,"size_format",null,null,null,false],[109,64,0,null,null,null,null,false],[0,0,0,"regenerated_size",null,null,null,false],[109,64,0,null,null,null,null,false],[0,0,0,"compressed_size",null,null,null,false],[109,71,0,null,null,null,[14511,14512,14513,14514],false],[0,0,0,"raw",null,null,null,false],[0,0,0,"rle",null,null,null,false],[0,0,0,"compressed",null,null,null,false],[0,0,0,"treeless",null,null,null,false],[109,78,0,null,null,null,[14532,14533,14535],false],[109,83,0,null,null,null,[14517,14518,14520],false],[0,0,0,"symbol",null,null,null,false],[0,0,0,"prefix",null,null,null,false],[109,83,0,null,null,null,null,false],[0,0,0,"weight",null,null,null,false],[109,89,0,null,null,null,[14522,14523],false],[0,0,0,"symbol",null,null,null,false],[0,0,0,"index",null,null,null,false],[109,94,0,null,null,null,[14525,14526,14527],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[0,0,0,"prefix",null,"",null,false],[109,107,0,null,null,null,[14529,14530],false],[0,0,0,"weight",null,"",null,false],[0,0,0,"max_bit_count",null,"",null,false],[109,78,0,null,null,null,null,false],[0,0,0,"max_bit_count",null,null,null,false],[0,0,0,"symbol_count_minus_one",null,null,null,false],[109,78,0,null,null,null,null,false],[0,0,0,"nodes",null,null,null,false],[109,112,0,null,null,null,[14537,14538],false],[0,0,0,"one",null,null,null,false],[0,0,0,"four",null,null,null,false],[109,113,0,null,null,null,[14540,14541],false],[0,0,0,"size_format",null,"",null,false],[0,0,0,"block_type",null,"",null,false],[109,54,0,null,null,null,null,false],[0,0,0,"header",null,null,null,false],[109,54,0,null,null,null,null,false],[0,0,0,"huffman_tree",null,null,null,false],[109,54,0,null,null,null,null,false],[0,0,0,"streams",null,null,null,false],[109,121,0,null,null,null,[14564,14566,14568,14570],false],[109,127,0,null,null,null,[14556,14558,14560,14562],false],[109,133,0,null,null,null,[14551,14552,14553,14554],false],[0,0,0,"predefined",null,null,null,false],[0,0,0,"rle",null,null,null,false],[0,0,0,"fse",null,null,null,false],[0,0,0,"repeat",null,null,null,false],[109,127,0,null,null,null,null,false],[0,0,0,"sequence_count",null,null,null,false],[109,127,0,null,null,null,null,false],[0,0,0,"match_lengths",null,null,null,false],[109,127,0,null,null,null,null,false],[0,0,0,"offsets",null,null,null,false],[109,127,0,null,null,null,null,false],[0,0,0,"literal_lengths",null,null,null,false],[109,121,0,null,null,null,null,false],[0,0,0,"header",null,null,null,false],[109,121,0,null,null,null,null,false],[0,0,0,"literals_length_table",null,null,null,false],[109,121,0,null,null,null,null,false],[0,0,0,"offset_table",null,null,null,false],[109,121,0,null,null,null,null,false],[0,0,0,"match_length_table",null,null,null,false],[109,142,0,null,null,null,[14576,14577],false],[109,146,0,null,null,null,[14573,14574,14575],false],[0,0,0,"symbol",null,null,null,false],[0,0,0,"baseline",null,null,null,false],[0,0,0,"bits",null,null,null,false],[0,0,0,"fse",null,null,null,false],[0,0,0,"rle",null,null,null,false],[109,153,0,null,null,null,[14579,14581],false],[0,0,0,"",null,null,null,false],[109,153,0,null,null,null,null,false],[0,0,0,"",null,null,null,false],[109,165,0,null,null,null,[14583,14585],false],[0,0,0,"",null,null,null,false],[109,165,0,null,null,null,null,false],[0,0,0,"",null,null,null,false],[109,177,0,null,null,null,null,false],[109,183,0,null,null,null,null,false],[109,190,0,null,null,null,null,false],[109,195,0,null,null,null,null,false],[109,264,0,null,null,null,null,false],[109,333,0,null,null,null,null,false],[109,369,0,null,null,null,null,false],[109,370,0,null,null,null,null,false],[109,371,0,null,null,null,null,false],[109,373,0,null,null,null,[],false],[109,374,0,null,null,null,null,false],[109,375,0,null,null,null,null,false],[109,376,0,null,null,null,null,false],[109,379,0,null,null,null,[],false],[109,380,0,null,null,null,null,false],[109,381,0,null,null,null,null,false],[109,382,0,null,null,null,null,false],[109,385,0,null,null,null,[],false],[109,386,0,null,null,null,null,false],[109,387,0,null,null,null,null,false],[109,388,0,null,null,null,null,false],[109,390,0,null,null,null,[],false],[109,391,0,null,null,null,null,false],[109,392,0,null,null,null,null,false],[109,393,0,null,null,null,null,false],[108,5,0,null,null,null,null,false],[108,6,0,null,null,null,null,false],[108,8,0,null,null,null,null,false],[0,0,0,"zstandard/decompress.zig",null,"",[],false],[110,0,0,null,null,null,null,false],[110,1,0,null,null,null,null,false],[110,2,0,null,null,null,null,false],[110,3,0,null,null,null,null,false],[110,5,0,null,null,null,null,false],[110,6,0,null,null,null,null,false],[110,7,0,null,null,null,null,false],[110,8,0,null,null,null,null,false],[110,9,0,null,null,null,null,false],[110,10,0,null,null,null,null,false],[110,11,0,null,null,null,null,false],[110,13,0,null,null,null,null,false],[0,0,0,"decode/block.zig",null,"",[],false],[111,0,0,null,null,null,null,false],[111,1,0,null,null,null,null,false],[111,2,0,null,null,null,null,false],[111,4,0,null,null,null,null,false],[111,5,0,null,null,null,null,false],[111,6,0,null,null,null,null,false],[111,7,0,null,null,null,null,false],[111,8,0,null,null,null,null,false],[111,10,0,null,null,null,null,false],[0,0,0,"huffman.zig",null,"",[],false],[112,0,0,null,null,null,null,false],[112,2,0,null,null,null,null,false],[112,3,0,null,null,null,null,false],[112,4,0,null,null,null,null,false],[112,6,0,null,null,null,null,false],[0,0,0,"../readers.zig",null,"",[],false],[113,0,0,null,null,null,null,false],[113,2,0,null,null,null,[14654,14656],false],[113,6,0,null,null,null,null,false],[113,8,0,null,null,null,[14648],false],[0,0,0,"bytes",null,"",null,false],[113,15,0,null,null,null,[14650],false],[0,0,0,"self",null,"",null,false],[113,19,0,null,null,null,[14652,14653],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[0,0,0,"remaining_bytes",null,null,null,false],[113,2,0,null,null,null,null,false],[0,0,0,"bytes",null,null,null,false],[113,31,0,null,null," A bit reader for reading the reversed bit streams used to encode\n FSE compressed data.",[14675,14677],false],[113,35,0,null,null,null,[14659,14660],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[113,44,0,null,null,null,[14662,14663,14664],false],[0,0,0,"self",null,"",null,false],[0,0,0,"U",null,"",null,true],[0,0,0,"num_bits",null,"",null,false],[113,48,0,null,null,null,[14666,14667,14668,14669],false],[0,0,0,"self",null,"",null,false],[0,0,0,"U",null,"",null,true],[0,0,0,"num_bits",null,"",null,false],[0,0,0,"out_bits",null,"",null,false],[113,52,0,null,null,null,[14671],false],[0,0,0,"self",null,"",null,false],[113,56,0,null,null,null,[14673],false],[0,0,0,"self",null,"",null,false],[113,31,0,null,null,null,null,false],[0,0,0,"byte_reader",null,null,null,false],[113,31,0,null,null,null,null,false],[0,0,0,"bit_reader",null,null,null,false],[113,61,0,null,null,null,[14679],false],[0,0,0,"Reader",null,"",[14692],true],[113,65,0,null,null,null,[14681,14682,14683],false],[0,0,0,"self",null,"",null,false],[0,0,0,"U",null,"",null,true],[0,0,0,"num_bits",null,"",null,false],[113,69,0,null,null,null,[14685,14686,14687,14688],false],[0,0,0,"self",null,"",null,false],[0,0,0,"U",null,"",null,true],[0,0,0,"num_bits",null,"",null,false],[0,0,0,"out_bits",null,"",null,false],[113,73,0,null,null,null,[14690],false],[0,0,0,"self",null,"",null,false],[113,62,0,null,null,null,null,false],[0,0,0,"underlying",null,null,null,false],[113,79,0,null,null,null,[14694],false],[0,0,0,"reader",null,"",null,false],[112,8,0,null,null,null,null,false],[0,0,0,"fse.zig",null,"",[],false],[114,0,0,null,null,null,null,false],[114,1,0,null,null,null,null,false],[114,3,0,null,null,null,null,false],[114,4,0,null,null,null,null,false],[114,6,0,null,null,null,[14702,14703,14704,14705],false],[0,0,0,"bit_reader",null,"",null,false],[0,0,0,"expected_symbol_count",null,"",null,false],[0,0,0,"max_accuracy_log",null,"",null,false],[0,0,0,"entries",null,"",null,false],[114,70,0,null,null,null,[14707,14708],false],[0,0,0,"values",null,"",null,false],[0,0,0,"entries",null,"",null,false],[114,124,0,"buildFseTable","test buildFseTable {\n    const literals_length_default_values = [36]u16{\n        5, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2,\n        3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 2, 2, 2, 2, 2,\n        0, 0, 0, 0,\n    };\n\n    const match_lengths_default_values = [53]u16{\n        2, 5, 4, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2,\n        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,\n        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0,\n        0, 0, 0, 0, 0,\n    };\n\n    const offset_codes_default_values = [29]u16{\n        2, 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2,\n        2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0,\n    };\n\n    var entries: [64]Table.Fse = undefined;\n    try buildFseTable(&literals_length_default_values, &entries);\n    try std.testing.expectEqualSlices(Table.Fse, types.compressed_block.predefined_literal_fse_table.fse, &entries);\n\n    try buildFseTable(&match_lengths_default_values, &entries);\n    try std.testing.expectEqualSlices(Table.Fse, types.compressed_block.predefined_match_fse_table.fse, &entries);\n\n    try buildFseTable(&offset_codes_default_values, entries[0..32]);\n    try std.testing.expectEqualSlices(Table.Fse, types.compressed_block.predefined_offset_fse_table.fse, entries[0..32]);\n}",null,null,false],[112,10,0,null,null,null,null,false],[112,17,0,null,null,null,[14712,14713,14714,14715],false],[0,0,0,"source",null,"",null,false],[0,0,0,"compressed_size",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[0,0,0,"weights",null,"",null,false],[112,41,0,null,null,null,[14717,14718,14719],false],[0,0,0,"src",null,"",null,false],[0,0,0,"compressed_size",null,"",null,false],[0,0,0,"weights",null,"",null,false],[112,63,0,null,null,null,[14721,14722,14723,14724],false],[0,0,0,"huff_bits",null,"",null,false],[0,0,0,"accuracy_log",null,"",null,false],[0,0,0,"entries",null,"",null,false],[0,0,0,"weights",null,"",null,false],[112,107,0,null,null,null,[14726,14727,14728],false],[0,0,0,"source",null,"",null,false],[0,0,0,"encoded_symbol_count",null,"",null,false],[0,0,0,"weights",null,"",null,false],[112,117,0,null,null,null,[14730,14731],false],[0,0,0,"weight_sorted_prefixed_symbols",null,"",null,false],[0,0,0,"weights",null,"",null,false],[112,163,0,null,null,null,[14733,14734],false],[0,0,0,"weights",null,"",null,false],[0,0,0,"symbol_count",null,"",null,false],[112,187,0,null,null,null,[14736,14737],false],[0,0,0,"source",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[112,202,0,null,null,null,[14739,14740],false],[0,0,0,"src",null,"",null,false],[0,0,0,"consumed_count",null,"",null,false],[112,224,0,null,null,null,[14742,14743,14744],false],[0,0,0,"weights",null,"",null,false],[0,0,0,"lhs",null,"",null,false],[0,0,0,"rhs",null,"",null,false],[111,11,0,null,null,null,null,false],[111,13,0,null,null,null,null,false],[111,15,0,null,null,null,null,false],[111,17,0,null,null,null,null,false],[111,25,0,null,null,null,[14844,14846,14848,14850,14852,14854,14856,14857,14859,14860,14862,14864,14866,14867,14868],false],[111,47,0,null,null,null,[14751],false],[0,0,0,"max_accuracy_log",null,"",[14754,14756,14757],true],[111,53,0,null,null,null,null,false],[111,48,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[111,48,0,null,null,null,null,false],[0,0,0,"table",null,null,null,false],[0,0,0,"accuracy_log",null,null,null,false],[111,57,0,null,null,null,[14759,14760,14761],false],[0,0,0,"literal_fse_buffer",null,"",null,false],[0,0,0,"match_fse_buffer",null,"",null,false],[0,0,0,"offset_fse_buffer",null,"",null,false],[111,105,0,null,null," Prepare the decoder to decode a compressed block. Loads the literals\n stream and Huffman tree from `literals` and reads the FSE tables from\n `source`.\n\n Errors returned:\n   - `error.BitStreamHasNoStartBit` if the (reversed) literal bitstream's\n     first byte does not have any bits set\n   - `error.TreelessLiteralsFirst` `literals` is a treeless literals\n     section and the decode state does not have a Huffman tree from a\n     previous block\n   - `error.RepeatModeFirst` on the first call if one of the sequence FSE\n     tables is set to repeat mode\n   - `error.MalformedAccuracyLog` if an FSE table has an invalid accuracy\n   - `error.MalformedFseTable` if there are errors decoding an FSE table\n   - `error.EndOfStream` if `source` ends before all FSE tables are read",[14763,14764,14765,14766],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"literals",null,"",null,false],[0,0,0,"sequences_header",null,"",null,false],[111,144,0,null,null," Read initial FSE states for sequence decoding.\n\n Errors returned:\n   - `error.EndOfStream` if `bit_reader` does not contain enough bits.",[14768,14769],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit_reader",null,"",null,false],[111,150,0,null,null,null,[14771,14772],false],[0,0,0,"self",null,"",null,false],[0,0,0,"offset",null,"",null,false],[111,156,0,null,null,null,[14774,14775],false],[0,0,0,"self",null,"",null,false],[0,0,0,"index",null,"",null,false],[111,166,0,null,null,null,[14777,14778,14779],false],[0,0,0,"offset",null,null,null,false],[0,0,0,"match",null,null,null,false],[0,0,0,"literal",null,null,null,false],[111,168,0,null,null,null,[14781,14782,14783],false],[0,0,0,"self",null,"",null,false],[0,0,0,"choice",null,"",null,true],[0,0,0,"bit_reader",null,"",null,false],[111,188,0,null,null,null,null,false],[111,195,0,null,null,null,[14786,14787,14788,14789],false],[0,0,0,"self",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"choice",null,"",null,true],[0,0,0,"mode",null,"",null,false],[111,232,0,null,null,null,[14791,14792,14793],false],[0,0,0,"literal_length",null,null,null,false],[0,0,0,"match_length",null,null,null,false],[0,0,0,"offset",null,null,null,false],[111,238,0,null,null,null,[14795,14796],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit_reader",null,"",null,false],[111,285,0,null,null,null,[14798,14799,14800,14801],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"write_pos",null,"",null,false],[0,0,0,"sequence",null,"",null,false],[111,302,0,null,null,null,[14803,14804,14805],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"sequence",null,"",null,false],[111,318,0,null,null,null,null,false],[111,341,0,null,null," Decode one sequence from `bit_reader` into `dest`, written starting at\n `write_pos` and update FSE states if `last_sequence` is `false`.\n `prepare()` must be called for the block before attempting to decode\n sequences.\n\n Errors returned:\n   - `error.MalformedSequence` if the decompressed sequence would be\n     longer than `sequence_size_limit` or the sequence's offset is too\n     large\n   - `error.UnexpectedEndOfLiteralStream` if the decoder state's literal\n     streams do not contain enough literals for the sequence (this may\n     mean the literal stream or the sequence is malformed).\n   - `error.InvalidBitStream` if the FSE sequence bitstream is malformed\n   - `error.EndOfStream` if `bit_reader` does not contain enough bits\n   - `error.DestTooSmall` if `dest` is not large enough to holde the\n     decompressed sequence",[14808,14809,14810,14811,14812,14813],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"write_pos",null,"",null,false],[0,0,0,"bit_reader",null,"",null,false],[0,0,0,"sequence_size_limit",null,"",null,false],[0,0,0,"last_sequence",null,"",null,false],[111,365,0,null,null," Decode one sequence from `bit_reader` into `dest`; see\n `decodeSequenceSlice`.",[14815,14816,14817,14818,14819],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"bit_reader",null,"",null,false],[0,0,0,"sequence_size_limit",null,"",null,false],[0,0,0,"last_sequence",null,"",null,false],[111,385,0,null,null,null,[14821],false],[0,0,0,"self",null,"",null,false],[111,392,0,null,null,null,[14823,14824],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[111,396,0,null,null,null,[14826],false],[0,0,0,"self",null,"",null,false],[111,403,0,null,null,null,null,false],[111,407,0,null,null,null,[14829,14830],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bit_count_to_read",null,"",null,false],[111,422,0,null,null,null,null,false],[111,435,0,null,null," Decode `len` bytes of literals into `dest`.\n\n Errors returned:\n   - `error.MalformedLiteralsLength` if the number of literal bytes\n     decoded by `self` plus `len` is greater than the regenerated size of\n     `literals`\n   - `error.UnexpectedEndOfLiteralStream` and `error.NotFound` if there\n     are problems decoding Huffman compressed literals",[14833,14834,14835],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"len",null,"",null,false],[111,507,0,null,null," Decode literals into `dest`; see `decodeLiteralsSlice()`.",[14837,14838,14839],false],[0,0,0,"self",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"len",null,"",null,false],[111,575,0,null,null,null,[14841,14842],false],[0,0,0,"self",null,"",null,false],[0,0,0,"choice",null,"",null,true],[111,25,0,null,null,null,null,false],[0,0,0,"repeat_offsets",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"offset",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"match",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"literal",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"offset_fse_buffer",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"match_fse_buffer",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"literal_fse_buffer",null,null,null,false],[0,0,0,"fse_tables_undefined",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"literal_stream_reader",null,null,null,false],[0,0,0,"literal_stream_index",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"literal_streams",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"literal_header",null,null,null,false],[111,25,0,null,null,null,null,false],[0,0,0,"huffman_tree",null,null,null,false],[0,0,0,"literal_written_count",null,null,null,false],[0,0,0,"written_count",null,null,null,false],[111,600,0,null,null," Decode a single block from `src` into `dest`. The beginning of `src` must be\n the start of the block content (i.e. directly after the block header).\n Increments `consumed_count` by the number of bytes read from `src` to decode\n the block and returns the decompressed size of the block.\n\n Errors returned:\n\n   - `error.BlockSizeOverMaximum` if block's size is larger than 1 << 17 or\n     `dest[written_count..].len`\n   - `error.MalformedBlockSize` if `src.len` is smaller than the block size\n     and the block is a raw or compressed block\n   - `error.ReservedBlock` if the block is a reserved block\n   - `error.MalformedRleBlock` if the block is an RLE block and `src.len < 1`\n   - `error.MalformedCompressedBlock` if there are errors decoding a\n     compressed block\n   - `error.DestTooSmall` is `dest` is not large enough to hold the\n     decompressed block",[14870,14871,14872,14873,14874,14875,14876],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"block_header",null,"",null,false],[0,0,0,"decode_state",null,"",null,false],[0,0,0,"consumed_count",null,"",null,false],[0,0,0,"block_size_max",null,"",null,false],[0,0,0,"written_count",null,"",null,false],[111,704,0,null,null," Decode a single block from `src` into `dest`; see `decodeBlock()`. Returns\n the size of the decompressed block, which can be used with `dest.sliceLast()`\n to get the decompressed bytes. `error.BlockSizeOverMaximum` is returned if\n the block's compressed or decompressed size is larger than `block_size_max`.",[14878,14879,14880,14881,14882,14883],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"block_header",null,"",null,false],[0,0,0,"decode_state",null,"",null,false],[0,0,0,"consumed_count",null,"",null,false],[0,0,0,"block_size_max",null,"",null,false],[111,805,0,null,null," Decode a single block from `source` into `dest`. Literal and sequence data\n from the block is copied into `literals_buffer` and `sequence_buffer`, which\n must be large enough or `error.LiteralsBufferTooSmall` and\n `error.SequenceBufferTooSmall` are returned (the maximum block size is an\n upper bound for the size of both buffers). See `decodeBlock`\n and `decodeBlockRingBuffer` for function that can decode a block without\n these extra copies. `error.EndOfStream` is returned if `source` does not\n contain enough bytes.",[14885,14886,14887,14888,14889,14890,14891],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"source",null,"",null,false],[0,0,0,"block_header",null,"",null,false],[0,0,0,"decode_state",null,"",null,false],[0,0,0,"block_size_max",null,"",null,false],[0,0,0,"literals_buffer",null,"",null,false],[0,0,0,"sequence_buffer",null,"",null,false],[111,894,0,null,null," Decode the header of a block.",[14893],false],[0,0,0,"src",null,"",null,false],[111,909,0,null,null," Decode the header of a block.\n\n Errors returned:\n   - `error.EndOfStream` if `src.len < 3`",[14895],false],[0,0,0,"src",null,"",null,false],[111,925,0,null,null," Decode a `LiteralsSection` from `src`, incrementing `consumed_count` by the\n number of bytes the section uses.\n\n Errors returned:\n   - `error.MalformedLiteralsHeader` if the header is invalid\n   - `error.MalformedLiteralsSection` if there are decoding errors\n   - `error.MalformedAccuracyLog` if compressed literals have invalid\n     accuracy\n   - `error.MalformedFseTable` if compressed literals have invalid FSE table\n   - `error.MalformedHuffmanTree` if there are errors decoding a Huffamn tree\n   - `error.EndOfStream` if there are not enough bytes in `src`",[14897,14898],false],[0,0,0,"src",null,"",null,false],[0,0,0,"consumed_count",null,"",null,false],[111,982,0,null,null," Decode a `LiteralsSection` from `src`, incrementing `consumed_count` by the\n number of bytes the section uses. See `decodeLiterasSectionSlice()`.",[14900,14901],false],[0,0,0,"source",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[111,1028,0,null,null,null,[14903,14904],false],[0,0,0,"size_format",null,"",null,false],[0,0,0,"stream_data",null,"",null,false],[111,1058,0,null,null," Decode a literals section header.\n\n Errors returned:\n   - `error.EndOfStream` if there are not enough bytes in `source`",[14906],false],[0,0,0,"source",null,"",null,false],[111,1111,0,null,null," Decode a sequences section header.\n\n Errors returned:\n   - `error.ReservedBitSet` if the reserved bit is set\n   - `error.EndOfStream` if there are not enough bytes in `source`",[14908],false],[0,0,0,"source",null,"",null,false],[110,15,0,null,null,null,null,false],[110,17,0,null,null,null,null,false],[110,18,0,null,null,null,null,false],[110,21,0,null,null," Returns `true` is `magic` is a valid magic number for a skippable frame",[14913],false],[0,0,0,"magic",null,"",null,false],[110,32,0,null,null," Returns the kind of frame at the beginning of `source`.\n\n Errors returned:\n   - `error.BadMagic` if `source` begins with bytes not equal to the\n     Zstandard frame magic number, or outside the range of magic numbers for\n     skippable frames.\n   - `error.EndOfStream` if `source` contains fewer than 4 bytes",[14915],false],[0,0,0,"source",null,"",null,false],[110,41,0,null,null," Returns the kind of frame associated to `magic`.\n\n Errors returned:\n   - `error.BadMagic` if `magic` is not a valid magic number.",[14917],false],[0,0,0,"magic",null,"",null,false],[110,50,0,null,null,null,[14919,14920],false],[0,0,0,"zstandard",null,null,null,false],[0,0,0,"skippable",null,null,null,false],[110,55,0,null,null,null,null,false],[110,66,0,null,null," Returns the header of the frame at the beginning of `source`.\n\n Errors returned:\n   - `error.BadMagic` if `source` begins with bytes not equal to the\n     Zstandard frame magic number, or outside the range of magic numbers for\n     skippable frames.\n   - `error.EndOfStream` if `source` contains fewer than 4 bytes\n   - `error.ReservedBitSet` if the frame is a Zstandard frame and any of the\n     reserved bits are set",[14923],false],[0,0,0,"source",null,"",null,false],[110,80,0,null,null,null,[14925,14926],false],[0,0,0,"read_count",null,null,null,false],[0,0,0,"write_count",null,null,null,false],[110,96,0,null,null," Decodes frames from `src` into `dest`; returns the length of the result.\n The stream should not have extra trailing bytes - either all bytes in `src`\n will be decoded, or an error will be returned. An error will be returned if\n a Zstandard frame in `src` does not declare its content size.\n\n Errors returned:\n   - `error.DictionaryIdFlagUnsupported` if a `src` contains a frame that\n     uses a dictionary\n   - `error.MalformedFrame` if a frame in `src` is invalid\n   - `error.UnknownContentSizeUnsupported` if a frame in `src` does not\n     declare its content size",[14928,14929,14930],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"verify_checksum",null,"",null,false],[110,126,0,null,null," Decodes a stream of frames from `src`; returns the decoded bytes. The stream\n should not have extra trailing bytes - either all bytes in `src` will be\n decoded, or an error will be returned.\n\n Errors returned:\n   - `error.DictionaryIdFlagUnsupported` if a `src` contains a frame that\n     uses a dictionary\n   - `error.MalformedFrame` if a frame in `src` is invalid\n   - `error.OutOfMemory` if `allocator` cannot allocate enough memory",[14932,14933,14934,14935],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"verify_checksum",null,"",null,false],[0,0,0,"window_size_max",null,"",null,false],[110,178,0,null,null," Decodes the frame at the start of `src` into `dest`. Returns the number of\n bytes read from `src` and written to `dest`. This function can only decode\n frames that declare the decompressed content size.\n\n Errors returned:\n   - `error.BadMagic` if the first 4 bytes of `src` is not a valid magic\n     number for a Zstandard or skippable frame\n   - `error.UnknownContentSizeUnsupported` if the frame does not declare the\n     uncompressed content size\n   - `error.WindowSizeUnknown` if the frame does not have a valid window size\n   - `error.ContentTooLarge` if `dest` is smaller than the uncompressed data\n     size declared by the frame header\n   - `error.ContentSizeTooLarge` if the frame header indicates a content size\n     that is larger than `std.math.maxInt(usize)`\n   - `error.DictionaryIdFlagUnsupported` if the frame uses a dictionary\n   - `error.ChecksumFailure` if `verify_checksum` is true and the frame\n     contains a checksum that does not match the checksum of the decompressed\n     data\n   - `error.ReservedBitSet` if any of the reserved bits of the frame header\n     are set\n   - `error.EndOfStream` if `src` does not contain a complete frame\n   - `error.BadContentSize` if the content size declared by the frame does\n     not equal the actual size of decompressed data\n   - an error in `block.Error` if there are errors decoding a block\n   - `error.SkippableSizeTooLarge` if the frame is skippable and reports a\n     size greater than `src.len`",[14937,14938,14939],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"verify_checksum",null,"",null,false],[110,231,0,null,null," Decodes the frame at the start of `src` into `dest`. Returns the number of\n bytes read from `src`.\n\n Errors returned:\n   - `error.BadMagic` if the first 4 bytes of `src` is not a valid magic\n     number for a Zstandard or skippable frame\n   - `error.WindowSizeUnknown` if the frame does not have a valid window size\n   - `error.WindowTooLarge` if the window size is larger than\n     `window_size_max`\n   - `error.ContentSizeTooLarge` if the frame header indicates a content size\n     that is larger than `std.math.maxInt(usize)`\n   - `error.DictionaryIdFlagUnsupported` if the frame uses a dictionary\n   - `error.ChecksumFailure` if `verify_checksum` is true and the frame\n     contains a checksum that does not match the checksum of the decompressed\n     data\n   - `error.ReservedBitSet` if any of the reserved bits of the frame header\n     are set\n   - `error.EndOfStream` if `src` does not contain a complete frame\n   - `error.BadContentSize` if the content size declared by the frame does\n     not equal the actual size of decompressed data\n   - `error.OutOfMemory` if `allocator` cannot allocate enough memory\n   - an error in `block.Error` if there are errors decoding a block\n   - `error.SkippableSizeTooLarge` if the frame is skippable and reports a\n     size greater than `src.len`",[14941,14942,14943,14944,14945],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"verify_checksum",null,"",null,false],[0,0,0,"window_size_max",null,"",null,false],[110,260,0,null,null," Returns the frame checksum corresponding to the data fed into `hasher`",[14947],false],[0,0,0,"hasher",null,"",null,false],[110,265,0,null,null,null,null,false],[110,293,0,null,null," Decode a Zstandard frame from `src` into `dest`, returning the number of\n bytes read from `src` and written to `dest`. The first four bytes of `src`\n must be the magic number for a Zstandard frame.\n\n Error returned:\n   - `error.UnknownContentSizeUnsupported` if the frame does not declare the\n     uncompressed content size\n   - `error.ContentTooLarge` if `dest` is smaller than the uncompressed data\n     size declared by the frame header\n   - `error.WindowSizeUnknown` if the frame does not have a valid window size\n   - `error.DictionaryIdFlagUnsupported` if the frame uses a dictionary\n   - `error.ContentSizeTooLarge` if the frame header indicates a content size\n     that is larger than `std.math.maxInt(usize)`\n   - `error.ChecksumFailure` if `verify_checksum` is true and the frame\n     contains a checksum that does not match the checksum of the decompressed\n     data\n   - `error.ReservedBitSet` if the reserved bit of the frame header is set\n   - `error.EndOfStream` if `src` does not contain a complete frame\n   - an error in `block.Error` if there are errors decoding a block\n   - `error.BadContentSize` if the content size declared by the frame does\n     not equal the actual size of decompressed data",[14950,14951,14952],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"verify_checksum",null,"",null,false],[110,332,0,null,null,null,[14954,14955,14956],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"frame_context",null,"",null,false],[110,365,0,null,null,null,[14964,14965,14966,14967,14969],false],[110,372,0,null,null,null,null,false],[110,388,0,null,null," Validates `frame_header` and returns the associated `FrameContext`.\n\n Errors returned:\n   - `error.DictionaryIdFlagUnsupported` if the frame uses a dictionary\n   - `error.WindowSizeUnknown` if the frame does not have a valid window\n     size\n   - `error.WindowTooLarge` if the window size is larger than\n     `window_size_max`\n   - `error.ContentSizeTooLarge` if the frame header indicates a content\n     size larger than `std.math.maxInt(usize)`",[14960,14961,14962],false],[0,0,0,"frame_header",null,"",null,false],[0,0,0,"window_size_max",null,"",null,false],[0,0,0,"verify_checksum",null,"",null,false],[110,365,0,null,null,null,null,false],[0,0,0,"hasher_opt",null,null,null,false],[0,0,0,"window_size",null,null,null,false],[0,0,0,"has_checksum",null,null,null,false],[0,0,0,"block_size_max",null,null,null,false],[110,365,0,null,null,null,null,false],[0,0,0,"content_size",null,null,null,false],[110,440,0,null,null," Decode a Zstandard from from `src` and return number of bytes read; see\n `decodeZstandardFrame()`. The first four bytes of `src` must be the magic\n number for a Zstandard frame.\n\n Errors returned:\n   - `error.WindowSizeUnknown` if the frame does not have a valid window size\n   - `error.WindowTooLarge` if the window size is larger than\n     `window_size_max`\n   - `error.DictionaryIdFlagUnsupported` if the frame uses a dictionary\n   - `error.ContentSizeTooLarge` if the frame header indicates a content size\n     that is larger than `std.math.maxInt(usize)`\n   - `error.ChecksumFailure` if `verify_checksum` is true and the frame\n     contains a checksum that does not match the checksum of the decompressed\n     data\n   - `error.ReservedBitSet` if the reserved bit of the frame header is set\n   - `error.EndOfStream` if `src` does not contain a complete frame\n   - `error.OutOfMemory` if `allocator` cannot allocate enough memory\n   - an error in `block.Error` if there are errors decoding a block\n   - `error.BadContentSize` if the content size declared by the frame does\n     not equal the size of decompressed data",[14971,14972,14973,14974,14975],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"verify_checksum",null,"",null,false],[0,0,0,"window_size_max",null,"",null,false],[110,467,0,null,null,null,[14977,14978,14979,14980],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"frame_context",null,"",null,false],[110,531,0,null,null,null,[14982,14983,14984,14985,14986],false],[0,0,0,"dest",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"consumed_count",null,"",null,false],[0,0,0,"hash",null,"",null,false],[0,0,0,"block_size_max",null,"",null,false],[110,570,0,null,null," Decode the header of a skippable frame. The first four bytes of `src` must\n be a valid magic number for a skippable frame.",[14988],false],[0,0,0,"src",null,"",null,false],[110,582,0,null,null," Returns the window size required to decompress a frame, or `null` if it\n cannot be determined (which indicates a malformed frame header).",[14990],false],[0,0,0,"header",null,"",null,false],[110,598,0,null,null," Decode the header of a Zstandard frame.\n\n Errors returned:\n   - `error.ReservedBitSet` if any of the reserved bits of the header are set\n   - `error.EndOfStream` if `source` does not contain a complete header",[14992],false],[0,0,0,"source",null,"",null,false],[108,10,0,null,null,null,[14994,14995],false],[0,0,0,"verify_checksum",null,null,null,false],[0,0,0,"window_size_max",null,null,null,false],[108,15,0,null,null,null,[14997,14998],false],[0,0,0,"ReaderType",null,"",null,true],[0,0,0,"options",null,"",[15018,15020,15025,15027,15029,15031,15033,15035,15037,15039,15041,15043,15044],true],[108,20,0,null,null,null,null,false],[108,36,0,null,null,null,null,false],[108,44,0,null,null,null,null,false],[108,46,0,null,null,null,[15003,15004],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"source",null,"",null,false],[108,64,0,null,null,null,[15006],false],[0,0,0,"self",null,"",null,false],[108,130,0,null,null,null,[15008],false],[0,0,0,"self",null,"",null,false],[108,140,0,null,null,null,[15010],false],[0,0,0,"self",null,"",null,false],[108,144,0,null,null,null,[15012,15013],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[108,166,0,null,null,null,[15015,15016],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buffer",null,"",null,false],[108,19,0,null,null,null,null,false],[0,0,0,"allocator",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"source",null,null,null,false],[108,19,0,null,null,null,[15022,15023,15024],false],[0,0,0,"NewFrame",null,null,null,false],[0,0,0,"InFrame",null,null,null,false],[0,0,0,"LastBlock",null,null,null,false],[0,0,0,"state",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"decode_state",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"frame_context",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"buffer",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"literal_fse_buffer",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"match_fse_buffer",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"offset_fse_buffer",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"literals_buffer",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"sequence_buffer",null,null,null,false],[108,19,0,null,null,null,null,false],[0,0,0,"checksum",null,null,null,false],[0,0,0,"current_frame_decompressed_size",null,null,null,false],[108,238,0,null,null,null,[15046,15047,15048],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[0,0,0,"options",null,"",null,true],[108,246,0,null,null,null,[15050,15051],false],[0,0,0,"allocator",null,"",null,false],[0,0,0,"reader",null,"",null,false],[108,253,0,null,null,null,[15053],false],[0,0,0,"data",null,"",null,false],[108,261,0,null,null,null,[15055,15056],false],[0,0,0,"data",null,"",null,false],[0,0,0,"expected",null,"",null,true],[86,10,0,null,null,null,[15058,15059],false],[0,0,0,"ReaderType",null,"",null,true],[0,0,0,"HasherType",null,"",[15068,15070],true],[86,18,0,null,null,null,null,false],[86,19,0,null,null,null,null,false],[86,21,0,null,null,null,[15063,15064],false],[0,0,0,"self",null,"",null,false],[0,0,0,"buf",null,"",null,false],[86,27,0,null,null,null,[15066],false],[0,0,0,"self",null,"",null,false],[86,14,0,null,null,null,null,false],[0,0,0,"child_reader",null,null,null,false],[86,14,0,null,null,null,null,false],[0,0,0,"hasher",null,null,null,false],[86,33,0,null,null,null,[15072,15073],false],[0,0,0,"reader",null,"",null,false],[0,0,0,"hasher",null,"",null,false],[0,60,0,null,null,null,null,false],[0,0,0,"crypto.zig",null,"",[],false],[115,0,0,null,null,null,null,false],[115,3,0,null,null," Authenticated Encryption with Associated Data",[],false],[115,4,0,null,null,null,[],false],[115,5,0,null,null,null,null,false],[0,0,0,"crypto/aegis.zig",null," AEGIS is a very fast authenticated encryption system built on top of the core AES function.\n\n The AEGIS-128L variant has a 128 bit key, a 128 bit nonce, and processes 256 bit message blocks.\n The AEGIS-256  variant has a 256 bit key, a 256 bit nonce, and processes 128 bit message blocks.\n\n The AEGIS cipher family offers performance that significantly exceeds that of AES-GCM with\n hardware support for parallelizable AES block encryption.\n\n Unlike with AES-GCM, nonces can be safely chosen at random with no practical limit when using AEGIS-256.\n AEGIS-128L also allows for more messages to be safely encrypted when using random nonces.\n\n AEGIS is believed to be key-committing, making it a safer choice than most other AEADs\n when the key has low entropy, or can be controlled by an attacker.\n\n Finally, leaking the state does not leak the key.\n\n https://datatracker.ietf.org/doc/draft-irtf-cfrg-aegis-aead/\n",[],false],[116,18,0,null,null,null,null,false],[116,19,0,null,null,null,null,false],[116,20,0,null,null,null,null,false],[116,21,0,null,null,null,null,false],[116,22,0,null,null,null,null,false],[116,25,0,null,null," AEGIS-128L with a 128-bit authentication tag.",null,false],[116,28,0,null,null," AEGIS-128L with a 256-bit authentication tag.",null,false],[116,31,0,null,null," AEGIS-256 with a 128-bit authentication tag.",null,false],[116,34,0,null,null," AEGIS-256 with a 256-bit authentication tag.",null,false],[116,36,0,null,null,null,[15115],false],[116,39,0,null,null,null,[15092,15093],false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[116,62,0,null,null,null,[15095,15096,15097],false],[0,0,0,"state",null,"",null,false],[0,0,0,"d1",null,"",null,false],[0,0,0,"d2",null,"",null,false],[116,74,0,null,null,null,[15099,15100],false],[0,0,0,"state",null,"",null,false],[0,0,0,"src",null,"",null,false],[116,80,0,null,null,null,[15102,15103,15104],false],[0,0,0,"state",null,"",null,false],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[116,93,0,null,null,null,[15106,15107,15108],false],[0,0,0,"state",null,"",null,false],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[116,104,0,null,null,null,[15110,15111,15112,15113],false],[0,0,0,"state",null,"",null,false],[0,0,0,"tag_bits",null,"",null,true],[0,0,0,"adlen",null,"",null,false],[0,0,0,"mlen",null,"",null,false],[116,36,0,null,null,null,null,false],[0,0,0,"blocks",null,null,null,false],[116,127,0,null,null,null,[15117],false],[0,0,0,"tag_bits",null,"",[],true],[116,131,0,null,null,null,null,false],[116,132,0,null,null,null,null,false],[116,133,0,null,null,null,null,false],[116,134,0,null,null,null,null,false],[116,136,0,null,null,null,null,false],[116,144,0,null,null," c: ciphertext: output buffer should be of size m.len\n tag: authentication tag: output MAC\n m: message\n ad: Associated Data\n npub: public nonce\n k: private key",[15124,15125,15126,15127,15128,15129],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[116,177,0,null,null," m: message: output buffer should be of size c.len\n c: ciphertext\n tag: authentication tag\n ad: Associated Data\n npub: public nonce\n k: private key",[15131,15132,15133,15134,15135,15136],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[116,218,0,null,null,null,[15161],false],[116,221,0,null,null,null,[15139,15140],false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[116,249,0,null,null,null,[15142,15143],false],[0,0,0,"state",null,"",null,false],[0,0,0,"d",null,"",null,false],[116,259,0,null,null,null,[15145,15146],false],[0,0,0,"state",null,"",null,false],[0,0,0,"src",null,"",null,false],[116,264,0,null,null,null,[15148,15149,15150],false],[0,0,0,"state",null,"",null,false],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[116,273,0,null,null,null,[15152,15153,15154],false],[0,0,0,"state",null,"",null,false],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[116,281,0,null,null,null,[15156,15157,15158,15159],false],[0,0,0,"state",null,"",null,false],[0,0,0,"tag_bits",null,"",null,true],[0,0,0,"adlen",null,"",null,false],[0,0,0,"mlen",null,"",null,false],[116,218,0,null,null,null,null,false],[0,0,0,"blocks",null,null,null,false],[116,309,0,null,null," AEGIS is a very fast authenticated encryption system built on top of the core AES function.\n\n The 256 bit variant of AEGIS has a 256 bit key, a 256 bit nonce, and processes 128 bit message blocks.\n\n https://datatracker.ietf.org/doc/draft-irtf-cfrg-aegis-aead/",[15163],false],[0,0,0,"tag_bits",null,"",[],true],[116,313,0,null,null,null,null,false],[116,314,0,null,null,null,null,false],[116,315,0,null,null,null,null,false],[116,316,0,null,null,null,null,false],[116,318,0,null,null,null,null,false],[116,326,0,null,null," c: ciphertext: output buffer should be of size m.len\n tag: authentication tag: output MAC\n m: message\n ad: Associated Data\n npub: public nonce\n k: private key",[15170,15171,15172,15173,15174,15175],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[116,359,0,null,null," m: message: output buffer should be of size c.len\n c: ciphertext\n tag: authentication tag\n ad: Associated Data\n npub: public nonce\n k: private key",[15177,15178,15179,15180,15181,15182],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[116,406,0,null,null," The `Aegis128LMac` message authentication function outputs 256 bit tags.\n In addition to being extremely fast, its large state, non-linearity\n and non-invertibility provides the following properties:\n - 128 bit security, stronger than GHash/Polyval/Poly1305.\n - Recovering the secret key from the state would require ~2^128 attempts,\n   which is infeasible for any practical adversary.\n - It has a large security margin against internal collisions.",null,false],[116,417,0,null,null," The `Aegis256Mac` message authentication function has a 256-bit key size,\n and outputs 256 bit tags. Unless theoretical multi-target attacks are a\n concern, the AEGIS-128L variant should be preferred.\n AEGIS' large state, non-linearity and non-invertibility provides the\n following properties:\n - More than 128 bit security against forgery.\n - Recovering the secret key from the state would require ~2^256 attempts,\n   which is infeasible for any practical adversary.\n - It has a large security margin against internal collisions.",null,false],[116,424,0,null,null," Aegis128L MAC with a 128-bit output.\n A MAC with a 128-bit output is not safe unless the number of messages\n authenticated with the same key remains small.\n After 2^48 messages, the probability of a collision is already ~ 2^-33.\n If unsure, use the  Aegis128LMac type, that has a 256 bit output.",null,false],[116,431,0,null,null," Aegis256 MAC with a 128-bit output.\n A MAC with a 128-bit output is not safe unless the number of messages\n authenticated with the same key remains small.\n After 2^48 messages, the probability of a collision is already ~ 2^-33.\n If unsure, use the  Aegis256Mac type, that has a 256 bit output.",null,false],[116,433,0,null,null,null,[15188],false],[0,0,0,"T",null,"",[15213,15215,15216,15217],true],[116,435,0,null,null,null,null,false],[116,437,0,null,null,null,null,false],[116,438,0,null,null,null,null,false],[116,439,0,null,null,null,null,false],[116,447,0,null,null," Initialize a state for the MAC function",[15194],false],[0,0,0,"key",null,"",null,false],[116,455,0,null,null," Add data to the state",[15196,15197],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[116,478,0,null,null," Return an authentication tag for the current state",[15199,15200],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[116,488,0,null,null," Return an authentication tag for a message and a key",[15202,15203,15204],false],[0,0,0,"out",null,"",null,false],[0,0,0,"msg",null,"",null,false],[0,0,0,"key",null,"",null,false],[116,494,0,null,null,null,null,false],[116,495,0,null,null,null,null,false],[116,497,0,null,null,null,[15208,15209],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[116,502,0,null,null,null,[15211],false],[0,0,0,"self",null,"",null,false],[116,434,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[116,434,0,null,null,null,null,false],[0,0,0,"buf",null,null,null,false],[0,0,0,"off",null,null,null,false],[0,0,0,"msg_len",null,null,null,false],[116,508,0,null,null,null,null,false],[0,0,0,"test.zig",null,"",[],false],[117,0,0,null,null,null,null,false],[117,1,0,null,null,null,null,false],[117,2,0,null,null,null,null,false],[117,5,0,null,null,null,[15224,15225,15226],false],[0,0,0,"Hasher",null,"",null,true],[0,0,0,"expected_hex",null,"",null,true],[0,0,0,"input",null,"",null,false],[117,13,0,null,null,null,[15228,15229],false],[0,0,0,"expected_hex",null,"",null,true],[0,0,0,"input",null,"",null,false],[116,509,0,null,null,null,null,false],[115,6,0,null,null,null,null,false],[115,7,0,null,null,null,null,false],[115,8,0,null,null,null,null,false],[115,11,0,null,null,null,[],false],[115,12,0,null,null,null,null,false],[0,0,0,"crypto/aes_gcm.zig",null,"",[],false],[118,0,0,null,null,null,null,false],[118,1,0,null,null,null,null,false],[118,2,0,null,null,null,null,false],[118,3,0,null,null,null,null,false],[118,4,0,null,null,null,null,false],[118,5,0,null,null,null,null,false],[118,6,0,null,null,null,null,false],[118,7,0,null,null,null,null,false],[118,8,0,null,null,null,null,false],[118,10,0,null,null,null,null,false],[118,11,0,null,null,null,null,false],[118,13,0,null,null,null,[15249],false],[0,0,0,"Aes",null,"",[],true],[118,17,0,null,null,null,null,false],[118,18,0,null,null,null,null,false],[118,19,0,null,null,null,null,false],[118,21,0,null,null,null,null,false],[118,23,0,null,null,null,[15255,15256,15257,15258,15259,15260],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[118,57,0,null,null,null,[15262,15263,15264,15265,15266,15267],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[118,103,0,null,null,null,null,false],[118,104,0,null,null,null,null,false],[115,13,0,null,null,null,null,false],[115,16,0,null,null,null,[],false],[115,17,0,null,null,null,null,false],[0,0,0,"crypto/aes_ocb.zig",null,"",[],false],[119,0,0,null,null,null,null,false],[119,1,0,null,null,null,null,false],[119,2,0,null,null,null,null,false],[119,3,0,null,null,null,null,false],[119,4,0,null,null,null,null,false],[119,5,0,null,null,null,null,false],[119,6,0,null,null,null,null,false],[119,7,0,null,null,null,null,false],[119,9,0,null,null,null,null,false],[119,10,0,null,null,null,null,false],[119,12,0,null,null,null,null,false],[119,15,0,null,null," AES-OCB (RFC 7253 - https://competitions.cr.yp.to/round3/ocbv11.pdf)",[15286],false],[0,0,0,"Aes",null,"",[],true],[119,20,0,null,null,null,null,false],[119,21,0,null,null,null,null,false],[119,22,0,null,null,null,null,false],[119,24,0,null,null,null,[15299,15301,15303,15304],false],[119,30,0,null,null,null,[15292],false],[0,0,0,"l",null,"",null,false],[119,38,0,null,null,null,[15294,15295],false],[0,0,0,"lx",null,"",null,false],[0,0,0,"upto",null,"",null,false],[119,49,0,null,null,null,[15297],false],[0,0,0,"aes_enc_ctx",null,"",null,false],[119,24,0,null,null,null,null,false],[0,0,0,"star",null,null,null,false],[119,24,0,null,null,null,null,false],[0,0,0,"dol",null,null,null,false],[119,24,0,null,null,null,null,false],[0,0,0,"table",null,null,null,false],[0,0,0,"upto",null,null,null,false],[119,60,0,null,null,null,[15306,15307,15308],false],[0,0,0,"aes_enc_ctx",null,"",null,false],[0,0,0,"lx",null,"",null,false],[0,0,0,"a",null,"",null,false],[119,86,0,null,null,null,[15310,15311],false],[0,0,0,"aes_enc_ctx",null,"",null,false],[0,0,0,"npub",null,"",null,false],[119,103,0,null,null,null,null,false],[119,104,0,null,null,null,null,false],[119,105,0,null,null,null,null,false],[119,113,0,null,null," c: ciphertext: output buffer should be of size m.len\n tag: authentication tag: output MAC\n m: message\n ad: Associated Data\n npub: public nonce\n k: secret key",[15316,15317,15318,15319,15320,15321],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[119,176,0,null,null," m: message: output buffer should be of size c.len\n c: ciphertext\n tag: authentication tag\n ad: Associated Data\n npub: public nonce\n k: secret key",[15323,15324,15325,15326,15327,15328],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[119,242,0,null,null,null,[15330,15331],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[119,250,0,null,null,null,[15333,15334],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[119,256,0,null,null,null,null,false],[115,18,0,null,null,null,null,false],[115,21,0,null,null,null,[],false],[115,22,0,null,null,null,null,false],[0,0,0,"crypto/chacha20.zig",null,"",[],false],[120,2,0,null,null,null,null,false],[120,3,0,null,null,null,null,false],[120,4,0,null,null,null,null,false],[120,5,0,null,null,null,null,false],[120,6,0,null,null,null,null,false],[120,7,0,null,null,null,null,false],[120,8,0,null,null,null,null,false],[120,9,0,null,null,null,null,false],[120,10,0,null,null,null,null,false],[120,13,0,null,null," IETF-variant of the ChaCha20 stream cipher, as designed for TLS.",null,false],[120,18,0,null,null," IETF-variant of the ChaCha20 stream cipher, reduced to 12 rounds.\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,23,0,null,null," IETF-variant of the ChaCha20 stream cipher, reduced to 8 rounds.\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,26,0,null,null," Original ChaCha20 stream cipher.",null,false],[120,31,0,null,null," Original ChaCha20 stream cipher, reduced to 12 rounds.\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,36,0,null,null," Original ChaCha20 stream cipher, reduced to 8 rounds.\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,39,0,null,null," XChaCha20 (nonce-extended version of the IETF ChaCha20 variant) stream cipher",null,false],[120,44,0,null,null," XChaCha20 (nonce-extended version of the IETF ChaCha20 variant) stream cipher, reduced to 12 rounds\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,49,0,null,null," XChaCha20 (nonce-extended version of the IETF ChaCha20 variant) stream cipher, reduced to 8 rounds\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,52,0,null,null," ChaCha20-Poly1305 authenticated cipher, as designed for TLS",null,false],[120,57,0,null,null," ChaCha20-Poly1305 authenticated cipher, reduced to 12 rounds\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,62,0,null,null," ChaCha20-Poly1305 authenticated cipher, reduced to 8 rounds\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,65,0,null,null," XChaCha20-Poly1305 authenticated cipher",null,false],[120,70,0,null,null," XChaCha20-Poly1305 authenticated cipher\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,75,0,null,null," XChaCha20-Poly1305 authenticated cipher\n Reduced-rounds versions are faster than the full-round version, but have a lower security margin.\n However, ChaCha is still believed to have a comfortable security even with only 8 rounds.",null,false],[120,78,0,null,null,null,[15365,15366],false],[0,0,0,"rounds_nb",null,"",null,true],[0,0,0,"degree",null,"",[],true],[120,80,0,null,null,null,null,false],[120,81,0,null,null,null,null,false],[120,83,0,null,null,null,[15370,15371],false],[0,0,0,"key",null,"",null,false],[0,0,0,"d",null,"",null,false],[120,152,0,null,null,null,[15373,15374],false],[0,0,0,"x",null,"",null,false],[0,0,0,"input",null,"",null,false],[120,216,0,null,null,null,[15376,15377,15378],false],[0,0,0,"dm",null,"",null,true],[0,0,0,"out",null,"",null,false],[0,0,0,"x",null,"",null,false],[120,227,0,null,null,null,[15380,15381],false],[0,0,0,"x",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[120,234,0,null,null,null,[15383,15384,15385,15386,15387],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce_and_counter",null,"",null,false],[0,0,0,"count64",null,"",null,true],[120,277,0,null,null,null,[15389,15390,15391,15392],false],[0,0,0,"out",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce_and_counter",null,"",null,false],[0,0,0,"count64",null,"",null,true],[120,307,0,null,null,null,[15394,15395],false],[0,0,0,"input",null,"",null,false],[0,0,0,"key",null,"",null,false],[120,330,0,null,null,null,[15397],false],[0,0,0,"rounds_nb",null,"",[],true],[120,332,0,null,null,null,null,false],[120,334,0,null,null,null,[15400,15401],false],[0,0,0,"key",null,"",null,false],[0,0,0,"d",null,"",null,false],[120,350,0,null,null,null,[15403,15404,15405,15406],false],[0,0,0,"a",null,null,null,false],[0,0,0,"b",null,null,null,false],[0,0,0,"c",null,null,null,false],[0,0,0,"d",null,null,null,false],[120,357,0,null,null,null,[15408,15409,15410,15411],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"d",null,"",null,false],[120,366,0,null,null,null,[15413,15414],false],[0,0,0,"x",null,"",null,false],[0,0,0,"input",null,"",null,false],[120,395,0,null,null,null,[15416,15417],false],[0,0,0,"out",null,"",null,false],[0,0,0,"x",null,"",null,false],[120,404,0,null,null,null,[15419,15420],false],[0,0,0,"x",null,"",null,false],[0,0,0,"ctx",null,"",null,false],[120,410,0,null,null,null,[15422,15423,15424,15425,15426],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce_and_counter",null,"",null,false],[0,0,0,"count64",null,"",null,true],[120,449,0,null,null,null,[15428,15429,15430,15431],false],[0,0,0,"out",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce_and_counter",null,"",null,false],[0,0,0,"count64",null,"",null,true],[120,475,0,null,null,null,[15433,15434],false],[0,0,0,"input",null,"",null,false],[0,0,0,"key",null,"",null,false],[120,497,0,null,null,null,[15436],false],[0,0,0,"rounds_nb",null,"",null,true],[120,515,0,null,null,null,[15438],false],[0,0,0,"key",null,"",null,false],[120,523,0,null,null,null,[15440,15441,15442],false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[0,0,0,"rounds_nb",null,"",[15444,15446],true],[120,523,0,null,null,null,null,false],[0,0,0,"key",null,null,null,false],[120,523,0,null,null,null,null,false],[0,0,0,"nonce",null,null,null,false],[120,533,0,null,null,null,[15448],false],[0,0,0,"rounds_nb",null,"",[],true],[120,536,0,null,null," Nonce length in bytes.",null,false],[120,538,0,null,null," Key length in bytes.",null,false],[120,540,0,null,null," Block length in bytes.",null,false],[120,545,0,null,null," Add the output of the ChaCha20 stream cipher to `in` and stores the result into `out`.\n WARNING: This function doesn't provide authenticated encryption.\n Using the AEAD or one of the `box` versions is usually preferred.",[15453,15454,15455,15456,15457],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[120,558,0,null,null," Write the output of the ChaCha20 stream cipher into `out`.",[15459,15460,15461,15462],false],[0,0,0,"out",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[120,571,0,null,null,null,[15464],false],[0,0,0,"rounds_nb",null,"",[],true],[120,574,0,null,null," Nonce length in bytes.",null,false],[120,576,0,null,null," Key length in bytes.",null,false],[120,578,0,null,null," Block length in bytes.",null,false],[120,583,0,null,null," Add the output of the ChaCha20 stream cipher to `in` and stores the result into `out`.\n WARNING: This function doesn't provide authenticated encryption.\n Using the AEAD or one of the `box` versions is usually preferred.",[15469,15470,15471,15472,15473],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[120,597,0,null,null," Write the output of the ChaCha20 stream cipher into `out`.",[15475,15476,15477,15478],false],[0,0,0,"out",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[120,611,0,null,null,null,[15480],false],[0,0,0,"rounds_nb",null,"",[],true],[120,614,0,null,null," Nonce length in bytes.",null,false],[120,616,0,null,null," Key length in bytes.",null,false],[120,618,0,null,null," Block length in bytes.",null,false],[120,623,0,null,null," Add the output of the XChaCha20 stream cipher to `in` and stores the result into `out`.\n WARNING: This function doesn't provide authenticated encryption.\n Using the AEAD or one of the `box` versions is usually preferred.",[15485,15486,15487,15488,15489],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[120,629,0,null,null," Write the output of the XChaCha20 stream cipher into `out`.",[15491,15492,15493,15494],false],[0,0,0,"out",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[120,636,0,null,null,null,[15496],false],[0,0,0,"rounds_nb",null,"",[],true],[120,638,0,null,null,null,null,false],[120,639,0,null,null,null,null,false],[120,640,0,null,null,null,null,false],[120,648,0,null,null," c: ciphertext: output buffer should be of size m.len\n tag: authentication tag: output MAC\n m: message\n ad: Associated Data\n npub: public nonce\n k: private key",[15501,15502,15503,15504,15505,15506],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[120,684,0,null,null," m: message: output buffer should be of size c.len\n c: ciphertext\n tag: authentication tag\n ad: Associated Data\n npub: public nonce\n k: private key\n NOTE: the check of the authentication tag is currently not done in constant time",[15508,15509,15510,15511,15512,15513],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[120,723,0,null,null,null,[15515],false],[0,0,0,"rounds_nb",null,"",[],true],[120,725,0,null,null,null,null,false],[120,726,0,null,null,null,null,false],[120,727,0,null,null,null,null,false],[120,735,0,null,null," c: ciphertext: output buffer should be of size m.len\n tag: authentication tag: output MAC\n m: message\n ad: Associated Data\n npub: public nonce\n k: private key",[15520,15521,15522,15523,15524,15525],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[120,746,0,null,null," m: message: output buffer should be of size c.len\n c: ciphertext\n tag: authentication tag\n ad: Associated Data\n npub: public nonce\n k: private key",[15527,15528,15529,15530,15531,15532],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[115,23,0,null,null,null,null,false],[115,24,0,null,null,null,null,false],[115,25,0,null,null,null,null,false],[115,26,0,null,null,null,null,false],[115,27,0,null,null,null,null,false],[115,30,0,null,null,null,null,false],[0,0,0,"crypto/isap.zig",null,"",[],false],[121,0,0,null,null,null,null,false],[121,1,0,null,null,null,null,false],[121,2,0,null,null,null,null,false],[121,3,0,null,null,null,null,false],[121,4,0,null,null,null,null,false],[121,5,0,null,null,null,null,false],[121,6,0,null,null,null,null,false],[121,7,0,null,null,null,null,false],[121,20,0,null,null," ISAPv2 is an authenticated encryption system hardened against side channels and fault attacks.\n https://csrc.nist.gov/CSRC/media/Projects/lightweight-cryptography/documents/round-2/spec-doc-rnd2/isap-spec-round2.pdf\n\n Note that ISAP is not suitable for high-performance applications.\n\n However:\n - if allowing physical access to the device is part of your threat model,\n - or if you need resistance against microcode/hardware-level side channel attacks,\n - or if software-induced fault attacks such as rowhammer are a concern,\n\n then you may consider ISAP for highly sensitive data.",[15588],false],[121,21,0,null,null,null,null,false],[121,22,0,null,null,null,null,false],[121,23,0,null,null,null,null,false],[121,25,0,null,null,null,null,false],[121,26,0,null,null,null,null,false],[121,27,0,null,null,null,null,false],[121,31,0,null,null,null,[15556,15557],false],[0,0,0,"isap",null,"",null,false],[0,0,0,"m",null,"",null,false],[121,54,0,null,null,null,[15559,15560,15561,15562],false],[0,0,0,"k",null,"",null,false],[0,0,0,"iv",null,"",null,false],[0,0,0,"y",null,"",null,false],[0,0,0,"out_len",null,"",null,true],[121,84,0,null,null,null,[15564,15565,15566,15567],false],[0,0,0,"c",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[121,112,0,null,null,null,[15569,15570,15571,15572],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[121,144,0,null,null,null,[15574,15575,15576,15577,15578,15579],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[121,149,0,null,null,null,[15581,15582,15583,15584,15585,15586],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"key",null,"",null,false],[121,20,0,null,null,null,null,false],[0,0,0,"st",null,null,null,false],[115,32,0,null,null,null,[],false],[115,33,0,null,null,null,null,false],[0,0,0,"crypto/salsa20.zig",null,"",[],false],[122,0,0,null,null,null,null,false],[122,1,0,null,null,null,null,false],[122,2,0,null,null,null,null,false],[122,3,0,null,null,null,null,false],[122,4,0,null,null,null,null,false],[122,5,0,null,null,null,null,false],[122,6,0,null,null,null,null,false],[122,8,0,null,null,null,null,false],[122,9,0,null,null,null,null,false],[122,10,0,null,null,null,null,false],[122,12,0,null,null,null,null,false],[122,13,0,null,null,null,null,false],[122,14,0,null,null,null,null,false],[122,17,0,null,null," The Salsa cipher with 20 rounds.",null,false],[122,20,0,null,null," The XSalsa cipher with 20 rounds.",null,false],[122,22,0,null,null,null,[15608],false],[0,0,0,"rounds",null,"",[],true],[122,24,0,null,null,null,null,false],[122,25,0,null,null,null,null,false],[122,26,0,null,null,null,null,false],[122,28,0,null,null,null,[15613,15614],false],[0,0,0,"key",null,"",null,false],[0,0,0,"d",null,"",null,false],[122,44,0,null,null,null,[15616,15617,15618],false],[0,0,0,"x",null,"",null,false],[0,0,0,"input",null,"",null,false],[0,0,0,"feedback",null,"",null,true],[122,111,0,null,null,null,[15620,15621],false],[0,0,0,"out",null,"",null,false],[0,0,0,"x",null,"",null,false],[122,121,0,null,null,null,[15623,15624,15625,15626],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"d",null,"",null,false],[122,157,0,null,null,null,[15628,15629],false],[0,0,0,"input",null,"",null,false],[0,0,0,"key",null,"",null,false],[122,179,0,null,null,null,[15631],false],[0,0,0,"rounds",null,"",[],true],[122,181,0,null,null,null,null,false],[122,183,0,null,null,null,[15634,15635],false],[0,0,0,"key",null,"",null,false],[0,0,0,"d",null,"",null,false],[122,199,0,null,null,null,[15637,15638,15639,15641],false],[0,0,0,"a",null,null,null,false],[0,0,0,"b",null,null,null,false],[0,0,0,"c",null,null,null,false],[122,199,0,null,null,null,null,false],[0,0,0,"d",null,null,null,false],[122,206,0,null,null,null,[15643,15644,15645,15646],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"d",null,"",null,false],[122,215,0,null,null,null,[15648,15649,15650],false],[0,0,0,"x",null,"",null,false],[0,0,0,"input",null,"",null,false],[0,0,0,"feedback",null,"",null,true],[122,241,0,null,null,null,[15652,15653],false],[0,0,0,"out",null,"",null,false],[0,0,0,"x",null,"",null,false],[122,247,0,null,null,null,[15655,15656,15657,15658],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"d",null,"",null,false],[122,282,0,null,null,null,[15660,15661],false],[0,0,0,"input",null,"",null,false],[0,0,0,"key",null,"",null,false],[122,304,0,null,null,null,null,false],[122,306,0,null,null,null,[15664],false],[0,0,0,"key",null,"",null,false],[122,315,0,null,null,null,[15666,15667,15668],false],[0,0,0,"rounds",null,"",null,true],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",[15670,15672],false],[122,315,0,null,null,null,null,false],[0,0,0,"key",null,null,null,false],[122,315,0,null,null,null,null,false],[0,0,0,"nonce",null,null,null,false],[122,323,0,null,null," The Salsa stream cipher.",[15674],false],[0,0,0,"rounds",null,"",[],true],[122,326,0,null,null," Nonce length in bytes.",null,false],[122,328,0,null,null," Key length in bytes.",null,false],[122,333,0,null,null," Add the output of the Salsa stream cipher to `in` and stores the result into `out`.\n WARNING: This function doesn't provide authenticated encryption.\n Using the AEAD or one of the `box` versions is usually preferred.",[15678,15679,15680,15681,15682],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[122,347,0,null,null," The XSalsa stream cipher.",[15684],false],[0,0,0,"rounds",null,"",[],true],[122,350,0,null,null," Nonce length in bytes.",null,false],[122,352,0,null,null," Key length in bytes.",null,false],[122,357,0,null,null," Add the output of the XSalsa stream cipher to `in` and stores the result into `out`.\n WARNING: This function doesn't provide authenticated encryption.\n Using the AEAD or one of the `box` versions is usually preferred.",[15688,15689,15690,15691,15692],false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[0,0,0,"counter",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"nonce",null,"",null,false],[122,365,0,null,null," The XSalsa stream cipher, combined with the Poly1305 MAC",[],false],[122,367,0,null,null," Authentication tag length in bytes.",null,false],[122,369,0,null,null," Nonce length in bytes.",null,false],[122,371,0,null,null," Key length in bytes.",null,false],[122,373,0,null,null,null,null,false],[122,381,0,null,null," c: ciphertext: output buffer should be of size m.len\n tag: authentication tag: output MAC\n m: message\n ad: Associated Data\n npub: public nonce\n k: private key",[15699,15700,15701,15702,15703,15704],false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[122,402,0,null,null," m: message: output buffer should be of size c.len\n c: ciphertext\n tag: authentication tag\n ad: Associated Data\n npub: public nonce\n k: private key",[15706,15707,15708,15709,15710,15711],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"tag",null,"",null,false],[0,0,0,"ad",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[122,433,0,null,null," NaCl-compatible secretbox API.\n\n A secretbox contains both an encrypted message and an authentication tag to verify that it hasn't been tampered with.\n A secret key shared by all the recipients must be already known in order to use this API.\n\n Nonces are 192-bit large and can safely be chosen with a random number generator.",[],false],[122,435,0,null,null," Key length in bytes.",null,false],[122,437,0,null,null," Nonce length in bytes.",null,false],[122,439,0,null,null," Authentication tag length in bytes.",null,false],[122,443,0,null,null," Encrypt and authenticate `m` using a nonce `npub` and a key `k`.\n `c` must be exactly `tag_length` longer than `m`, as it will store both the ciphertext and the authentication tag.",[15717,15718,15719,15720],false],[0,0,0,"c",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[122,450,0,null,null," Verify and decrypt `c` using a nonce `npub` and a key `k`.\n `m` must be exactly `tag_length` smaller than `c`, as `c` includes an authentication tag in addition to the encrypted message.",[15722,15723,15724,15725],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"k",null,"",null,false],[122,467,0,null,null," NaCl-compatible box API.\n\n A secretbox contains both an encrypted message and an authentication tag to verify that it hasn't been tampered with.\n This construction uses public-key cryptography. A shared secret doesn't have to be known in advance by both parties.\n Instead, a message is encrypted using a sender's secret key and a recipient's public key,\n and is decrypted using the recipient's secret key and the sender's public key.\n\n Nonces are 192-bit large and can safely be chosen with a random number generator.",[],false],[122,469,0,null,null," Public key length in bytes.",null,false],[122,471,0,null,null," Secret key length in bytes.",null,false],[122,473,0,null,null," Shared key length in bytes.",null,false],[122,475,0,null,null," Seed (for key pair creation) length in bytes.",null,false],[122,477,0,null,null," Nonce length in bytes.",null,false],[122,479,0,null,null," Authentication tag length in bytes.",null,false],[122,482,0,null,null," A key pair.",null,false],[122,485,0,null,null," Compute a secret suitable for `secretbox` given a recipent's public key and a sender's secret key.",[15735,15736],false],[0,0,0,"public_key",null,"",null,false],[0,0,0,"secret_key",null,"",null,false],[122,492,0,null,null," Encrypt and authenticate a message using a recipient's public key `public_key` and a sender's `secret_key`.",[15738,15739,15740,15741,15742],false],[0,0,0,"c",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"public_key",null,"",null,false],[0,0,0,"secret_key",null,"",null,false],[122,498,0,null,null," Verify and decrypt a message using a recipient's secret key `public_key` and a sender's `public_key`.",[15744,15745,15746,15747,15748],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"npub",null,"",null,false],[0,0,0,"public_key",null,"",null,false],[0,0,0,"secret_key",null,"",null,false],[122,511,0,null,null," libsodium-compatible sealed boxes\n\n Sealed boxes are designed to anonymously send messages to a recipient given their public key.\n Only the recipient can decrypt these messages, using their private key.\n While the recipient can verify the integrity of the message, it cannot verify the identity of the sender.\n\n A message is encrypted using an ephemeral key pair, whose secret part is destroyed right after the encryption process.",[],false],[122,512,0,null,null,null,null,false],[122,513,0,null,null,null,null,false],[122,514,0,null,null,null,null,false],[122,515,0,null,null,null,null,false],[122,518,0,null,null," A key pair.",null,false],[122,520,0,null,null,null,[15756,15757],false],[0,0,0,"pk1",null,"",null,false],[0,0,0,"pk2",null,"",null,false],[122,531,0,null,null," Encrypt a message `m` for a recipient whose public key is `public_key`.\n `c` must be `seal_length` bytes larger than `m`, so that the required metadata can be added.",[15759,15760,15761],false],[0,0,0,"c",null,"",null,false],[0,0,0,"m",null,"",null,false],[0,0,0,"public_key",null,"",null,false],[122,542,0,null,null," Decrypt a message using a key pair.\n `m` must be exactly `seal_length` bytes smaller than `c`, as `c` also includes metadata.",[15763,15764,15765],false],[0,0,0,"m",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"keypair",null,"",null,false],[122,552,0,null,null,null,null,false],[115,38,0,null,null," Authentication (MAC) functions.",[],false],[115,39,0,null,null,null,null,false],[0,0,0,"crypto/hmac.zig",null,"",[],false],[123,0,0,null,null,null,null,false],[123,1,0,null,null,null,null,false],[123,2,0,null,null,null,null,false],[123,3,0,null,null,null,null,false],[123,5,0,null,null,null,null,false],[123,6,0,null,null,null,null,false],[123,8,0,null,null,null,[],false],[123,9,0,null,null,null,null,false],[123,10,0,null,null,null,null,false],[123,11,0,null,null,null,null,false],[123,12,0,null,null,null,null,false],[123,15,0,null,null,null,[15782],false],[0,0,0,"Hash",null,"",[15800,15802],true],[123,17,0,null,null,null,null,false],[123,18,0,null,null,null,null,false],[123,19,0,null,null,null,null,false],[123,20,0,null,null,null,null,false],[123,26,0,null,null,null,[15788,15789,15790],false],[0,0,0,"out",null,"",null,false],[0,0,0,"msg",null,"",null,false],[0,0,0,"key",null,"",null,false],[123,32,0,null,null,null,[15792],false],[0,0,0,"key",null,"",null,false],[123,61,0,null,null,null,[15794,15795],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"msg",null,"",null,false],[123,65,0,null,null,null,[15797,15798],false],[0,0,0,"ctx",null,"",null,false],[0,0,0,"out",null,"",null,false],[123,16,0,null,null,null,null,false],[0,0,0,"o_key_pad",null,null,null,false],[123,16,0,null,null,null,null,false],[0,0,0,"hash",null,null,null,false],[123,76,0,null,null,null,null,false],[115,40,0,null,null,null,null,false],[0,0,0,"crypto/siphash.zig",null,"",[],false],[124,8,0,null,null,null,null,false],[124,9,0,null,null,null,null,false],[124,10,0,null,null,null,null,false],[124,11,0,null,null,null,null,false],[124,12,0,null,null,null,null,false],[124,24,0,null,null," SipHash function with 64-bit output.\n\n Recommended parameters are:\n - (c_rounds=4, d_rounds=8) for conservative security; regular hash functions such as BLAKE2 or BLAKE3 are usually a better alternative.\n - (c_rounds=2, d_rounds=4) standard parameters.\n - (c_rounds=1, d_rounds=3) reduced-round function. Faster, no known implications on its practical security level.\n - (c_rounds=1, d_rounds=2) fastest option, but the output may be distinguishable from random data with related keys or non-uniform input - not suitable as a PRF.\n\n SipHash is not a traditional hash function. If the input includes untrusted content, a secret key is absolutely necessary.\n And due to its small output size, collisions in SipHash64 can be found with an exhaustive search.",[15812,15813],false],[0,0,0,"c_rounds",null,"",null,true],[0,0,0,"d_rounds",null,"",null,true],[124,38,0,null,null," SipHash function with 128-bit output.\n\n Recommended parameters are:\n - (c_rounds=4, d_rounds=8) for conservative security; regular hash functions such as BLAKE2 or BLAKE3 are usually a better alternative.\n - (c_rounds=2, d_rounds=4) standard parameters.\n - (c_rounds=1, d_rounds=4) reduced-round function. Recommended to hash very short, similar strings, when a 128-bit PRF output is still required.\n - (c_rounds=1, d_rounds=3) reduced-round function. Faster, no known implications on its practical security level.\n - (c_rounds=1, d_rounds=2) fastest option, but the output may be distinguishable from random data with related keys or non-uniform input - not suitable as a PRF.\n\n SipHash is not a traditional hash function. If the input includes untrusted content, a secret key is absolutely necessary.",[15815,15816],false],[0,0,0,"c_rounds",null,"",null,true],[0,0,0,"d_rounds",null,"",null,true],[124,42,0,null,null,null,[15818,15819,15820],false],[0,0,0,"T",null,"",null,true],[0,0,0,"c_rounds",null,"",null,true],[0,0,0,"d_rounds",null,"",[15840,15841,15842,15843,15844],true],[124,47,0,null,null,null,null,false],[124,48,0,null,null,null,null,false],[124,49,0,null,null,null,null,false],[124,57,0,null,null,null,[15825],false],[0,0,0,"key",null,"",null,false],[124,76,0,null,null,null,[15827,15828],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[124,88,0,null,null,null,[15830,15831],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[124,125,0,null,null,null,[15833,15834],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[124,137,0,null,null,null,[15836],false],[0,0,0,"d",null,"",null,false],[124,154,0,null,null,null,[15838,15839],false],[0,0,0,"msg",null,"",null,false],[0,0,0,"key",null,"",null,false],[0,0,0,"v0",null,null,null,false],[0,0,0,"v1",null,null,null,false],[0,0,0,"v2",null,null,null,false],[0,0,0,"v3",null,null,null,false],[0,0,0,"msg_len",null,null,null,false],[124,163,0,null,null,null,[15846,15847,15848],false],[0,0,0,"T",null,"",null,true],[0,0,0,"c_rounds",null,"",null,true],[0,0,0,"d_rounds",null,"",[15883,15885,15886],true],[124,168,0,null,null,null,null,false],[124,169,0,null,null,null,null,false],[124,170,0,null,null,null,null,false],[124,171,0,null,null,null,null,false],[124,172,0,null,null,null,null,false],[124,179,0,null,null," Initialize a state for a SipHash function",[15855],false],[0,0,0,"key",null,"",null,false],[124,188,0,null,null," Add data to the state",[15857,15858],false],[0,0,0,"self",null,"",null,false],[0,0,0,"b",null,"",null,false],[124,207,0,null,null,null,[15860],false],[0,0,0,"self",null,"",null,false],[124,214,0,null,null," Return an authentication tag for the current state\n Assumes `out` is less than or equal to `mac_length`.",[15862,15863],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[124,218,0,null,null,null,[15865],false],[0,0,0,"self",null,"",null,false],[124,225,0,null,null," Return an authentication tag for a message and a key",[15867,15868,15869],false],[0,0,0,"out",null,"",null,false],[0,0,0,"msg",null,"",null,false],[0,0,0,"key",null,"",null,false],[124,232,0,null,null," Return an authentication tag for the current state, as an integer",[15871],false],[0,0,0,"self",null,"",null,false],[124,237,0,null,null," Return an authentication tag for a message and a key, as an integer",[15873,15874],false],[0,0,0,"msg",null,"",null,false],[0,0,0,"key",null,"",null,false],[124,241,0,null,null,null,null,false],[124,242,0,null,null,null,null,false],[124,244,0,null,null,null,[15878,15879],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[124,249,0,null,null,null,[15881],false],[0,0,0,"self",null,"",null,false],[124,167,0,null,null,null,null,false],[0,0,0,"state",null,null,null,false],[124,167,0,null,null,null,null,false],[0,0,0,"buf",null,null,null,false],[0,0,0,"buf_len",null,null,null,false],[124,257,0,null,null,null,null,false],[115,41,0,null,null,null,[],false],[115,42,0,null,null,null,null,false],[115,43,0,null,null,null,null,false],[115,44,0,null,null,null,null,false],[115,45,0,null,null,null,null,false],[115,47,0,null,null,null,null,false],[0,0,0,"crypto/cmac.zig",null,"",[],false],[125,0,0,null,null,null,null,false],[125,1,0,null,null,null,null,false],[125,2,0,null,null,null,null,false],[125,5,0,null,null," CMAC with AES-128 - RFC 4493 https://www.rfc-editor.org/rfc/rfc4493",null,false],[125,9,0,null,null," NIST Special Publication 800-38B - The CMAC Mode for Authentication\n https://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-38b.pdf",[15900],false],[0,0,0,"BlockCipher",null,"",[15920,15922,15924,15926,15927],true],[125,14,0,null,null,null,null,false],[125,15,0,null,null,null,null,false],[125,16,0,null,null,null,null,false],[125,17,0,null,null,null,null,false],[125,25,0,null,null,null,[15906,15907,15908],false],[0,0,0,"out",null,"",null,false],[0,0,0,"msg",null,"",null,false],[0,0,0,"key",null,"",null,false],[125,31,0,null,null,null,[15910],false],[0,0,0,"key",null,"",null,false],[125,44,0,null,null,null,[15912,15913],false],[0,0,0,"self",null,"",null,false],[0,0,0,"msg",null,"",null,false],[125,65,0,null,null,null,[15915,15916],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[125,75,0,null,null,null,[15918],false],[0,0,0,"l",null,"",null,false],[125,13,0,null,null,null,null,false],[0,0,0,"cipher_ctx",null,null,null,false],[125,13,0,null,null,null,null,false],[0,0,0,"k1",null,null,null,false],[125,13,0,null,null,null,null,false],[0,0,0,"k2",null,null,null,false],[125,13,0,null,null,null,null,false],[0,0,0,"buf",null,null,null,false],[0,0,0,"pos",null,null,null,false],[125,92,0,null,null,null,null,false],[115,51,0,null,null," Core functions, that should rarely be used directly by applications.",[],false],[115,52,0,null,null,null,null,false],[0,0,0,"crypto/aes.zig",null,"",[],false],[126,0,0,null,null,null,null,false],[126,1,0,null,null,null,null,false],[126,2,0,null,null,null,null,false],[126,4,0,null,null,null,null,false],[126,5,0,null,null,null,null,false],[126,6,0,null,null,null,null,false],[126,8,0,null,null,null,null,false],[126,19,0,null,null," `true` if AES is backed by hardware (AES-NI on x86_64, ARM Crypto Extensions on AArch64).\n Software implementations are much slower, and should be avoided if possible.",null,false],[126,23,0,null,null,null,null,false],[126,24,0,null,null,null,null,false],[126,25,0,null,null,null,null,false],[126,26,0,null,null,null,null,false],[126,27,0,null,null,null,null,false],[115,53,0,null,null,null,null,false],[0,0,0,"crypto/keccak_p.zig",null,"",[],false],[127,0,0,null,null,null,null,false],[127,1,0,null,null,null,null,false],[127,2,0,null,null,null,null,false],[127,3,0,null,null,null,null,false],[127,6,0,null,null," The Keccak-f permutation.",[15952],false],[0,0,0,"f",null,"",[15995],true],[127,16,0,null,null,null,null,false],[127,19,0,null,null," Number of bytes in the state.",null,false],[127,22,0,null,null," Maximum number of rounds for the given f parameter.",null,false],[127,25,0,null,null,null,null,false],[127,42,0,null,null," Initialize the state from a slice of bytes.",[15958],false],[0,0,0,"bytes",null,"",null,false],[127,51,0,null,null," A representation of the state as bytes. The byte order is architecture-dependent.",[15960],false],[0,0,0,"self",null,"",null,false],[127,56,0,null,null," Byte-swap the entire state if the architecture doesn't match the required endianness.",[15962],false],[0,0,0,"self",null,"",null,false],[127,63,0,null,null," Set bytes starting at the beginning of the state.",[15964,15965],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[127,76,0,null,null," XOR a byte into the state at a given offset.",[15967,15968,15969],false],[0,0,0,"self",null,"",null,false],[0,0,0,"byte",null,"",null,false],[0,0,0,"offset",null,"",null,false],[127,82,0,null,null," XOR bytes into the beginning of the state.",[15971,15972],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[127,95,0,null,null," Extract the first bytes of the state.",[15974,15975],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[127,108,0,null,null," XOR the first bytes of the state into a slice of bytes.",[15977,15978,15979],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[127,126,0,null,null," Set the words storing the bytes of a given range to zero.",[15981,15982,15983],false],[0,0,0,"self",null,"",null,false],[0,0,0,"from",null,"",null,false],[0,0,0,"to",null,"",null,false],[127,131,0,null,null," Clear the entire state, disabling compiler optimizations.",[15985],false],[0,0,0,"self",null,"",null,false],[127,135,0,null,null,null,[15987,15988],false],[0,0,0,"self",null,"",null,false],[0,0,0,"rc",null,"",null,false],[127,175,0,null,null," Apply a (possibly) reduced-round permutation to the state.",[15990,15991],false],[0,0,0,"self",null,"",null,false],[0,0,0,"rounds",null,"",null,true],[127,188,0,null,null," Apply a full-round permutation to the state.",[15993],false],[0,0,0,"self",null,"",null,false],[127,15,0,null,null,null,null,false],[0,0,0,"st",null,null,null,false],[127,195,0,null,null," A generic Keccak-P state.",[15997,15998,15999,16000],false],[0,0,0,"f",null,"",null,true],[0,0,0,"capacity",null,"",null,true],[0,0,0,"delim",null,"",null,true],[0,0,0,"rounds",null,"",[16012,16014,16016],true],[127,200,0,null,null,null,null,false],[127,203,0,null,null," The block length, or rate, in bytes.",null,false],[127,205,0,null,null," Keccak does not have any options.",[],false],[127,213,0,null,null," Absorb a slice of bytes into the sponge.",[16005,16006],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes_",null,"",null,false],[127,239,0,null,null," Mark the end of the input.",[16008],false],[0,0,0,"self",null,"",null,false],[127,248,0,null,null," Squeeze a slice of bytes from the sponge.",[16010,16011],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[0,0,0,"offset",null,null,null,false],[127,199,0,null,null,null,null,false],[0,0,0,"buf",null,null,null,false],[127,199,0,null,null,null,null,false],[0,0,0,"st",null,null,null,false],[115,55,0,null,null,null,null,false],[0,0,0,"crypto/ascon.zig",null," Ascon is a 320-bit permutation, selected as new standard for lightweight cryptography\n in the NIST Lightweight Cryptography competition (2019–2023).\n https://csrc.nist.gov/News/2023/lightweight-cryptography-nist-selects-ascon\n\n The permutation is compact, and optimized for timing and side channel resistance,\n making it a good choice for embedded applications.\n\n It is not meant to be used directly, but as a building block for symmetric cryptography.\n",[],false],[128,9,0,null,null,null,null,false],[128,10,0,null,null,null,null,false],[128,11,0,null,null,null,null,false],[128,12,0,null,null,null,null,false],[128,13,0,null,null,null,null,false],[128,14,0,null,null,null,null,false],[128,22,0,null,null," An Ascon state.\n\n The state is represented as 5 64-bit words.\n\n The NIST submission (v1.2) serializes these words as big-endian,\n but software implementations are free to use native endianness.",[16026],false],[0,0,0,"endian",null,"",[16076],true],[128,24,0,null,null,null,null,false],[128,27,0,null,null," Number of bytes in the state.",null,false],[128,29,0,null,null,null,null,false],[128,34,0,null,null," Initialize the state from a slice of bytes.",[16031],false],[0,0,0,"initial_state",null,"",null,false],[128,42,0,null,null," Initialize the state from u64 words in native endianness.",[16033],false],[0,0,0,"initial_state",null,"",null,false],[128,48,0,null,null," Initialize the state for Ascon XOF",[],false],[128,59,0,null,null," Initialize the state for Ascon XOFa",[],false],[128,70,0,null,null," A representation of the state as bytes. The byte order is architecture-dependent.",[16037],false],[0,0,0,"self",null,"",null,false],[128,75,0,null,null," Byte-swap the entire state if the architecture doesn't match the required endianness.",[16039],false],[0,0,0,"self",null,"",null,false],[128,82,0,null,null," Set bytes starting at the beginning of the state.",[16041,16042],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[128,95,0,null,null," XOR a byte into the state at a given offset.",[16044,16045,16046],false],[0,0,0,"self",null,"",null,false],[0,0,0,"byte",null,"",null,false],[0,0,0,"offset",null,"",null,false],[128,104,0,null,null," XOR bytes into the beginning of the state.",[16048,16049],false],[0,0,0,"self",null,"",null,false],[0,0,0,"bytes",null,"",null,false],[128,117,0,null,null," Extract the first bytes of the state.",[16051,16052],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[128,130,0,null,null," XOR the first bytes of the state into a slice of bytes.",[16054,16055,16056],false],[0,0,0,"self",null,"",null,false],[0,0,0,"out",null,"",null,false],[0,0,0,"in",null,"",null,false],[128,148,0,null,null," Set the words storing the bytes of a given range to zero.",[16058,16059,16060],false],[0,0,0,"self",null,"",null,false],[0,0,0,"from",null,"",null,false],[0,0,0,"to",null,"",null,false],[128,153,0,null,null," Clear the entire state, disabling compiler optimizations.",[16062],false],[0,0,0,"self",null,"",null,false],[128,158,0,null,null," Apply a reduced-round permutation to the state.",[16064,16065],false],[0,0,0,"state",null,"",null,false],[0,0,0,"rounds",null,"",null,true],[128,166,0,null,null," Apply a full-round permutation to the state.",[16067],false],[0,0,0,"state",null,"",null,false],[128,172,0,null,null," Apply a permutation to the state and prevent backtracking.\n The rate is expressed in bytes and must be a multiple of the word size (8).",[16069,16070,16071],false],[0,0,0,"state",null,"",null,false],[0,0,0,"rounds",null,"",null,true],[0,0,0,"rate",null,"",null,true],[128,182,0,null,null,null,[16073,16074],false],[0,0,0,"state",null,"",null,false],[0,0,0,"rk",null,"",null,false],[128,23,0,null,null,null,null,false],[0,0,0,"st",null,null,null,false],[115,62,0,null,null," Modes are generic compositions to construct encryption/decryption functions from block ciphers and permutations.\n\n These modes are designed to be building blocks for higher-level constructions, and should generally not be used directly by applications, as they may not provide the expected properties and security guarantees.\n\n Most applications may want to use AEADs instead.",null,false],[0,0,0,"crypto/modes.zig",null,"",[],false],[129,2,0,null,null,null,null,false],[129,3,0,null,null,null,null,false],[129,4,0,null,null,null,null,false],[129,12,0,null,null," Counter mode.\n\n This mode creates a key stream by encrypting an incrementing counter using a block cipher, and adding it to the source material.\n\n Important: the counter mode doesn't provide authenticated encryption: the ciphertext can be trivially modified without this being detected.\n As a result, applications should generally never use it directly, but only in a construction that includes a MAC.",[16083,16084,16085,16086,16087,16088],false],[0,0,0,"BlockCipher",null,"",null,true],[0,0,0,"block_cipher",null,"",null,false],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"iv",null,"",null,false],[0,0,0,"endian",null,"",null,false],[115,66,0,null,null," Diffie-Hellman key exchange functions.",[],false],[115,67,0,null,null,null,null,false],[0,0,0,"crypto/25519/x25519.zig",null,"",[],false],[130,0,0,null,null,null,null,false],[130,1,0,null,null,null,null,false],[130,2,0,null,null,null,null,false],[130,3,0,null,null,null,null,false],[130,5,0,null,null,null,null,false],[130,7,0,null,null,null,null,false],[130,8,0,null,null,null,null,false],[130,9,0,null,null,null,null,false],[130,12,0,null,null," X25519 DH function.",[],false],[130,14,0,null,null," The underlying elliptic curve.",null,false],[0,0,0,"curve25519.zig",null,"",[],false],[131,0,0,null,null,null,null,false],[131,1,0,null,null,null,null,false],[131,3,0,null,null,null,null,false],[131,4,0,null,null,null,null,false],[131,5,0,null,null,null,null,false],[131,8,0,null,null," Group operations over Curve25519.",[16305],false],[131,10,0,null,null," The underlying prime field.",null,false],[0,0,0,"field.zig",null,"",[],false],[132,0,0,null,null,null,null,false],[132,1,0,null,null,null,null,false],[132,2,0,null,null,null,null,false],[132,3,0,null,null,null,null,false],[132,4,0,null,null,null,null,false],[132,6,0,null,null,null,null,false],[132,7,0,null,null,null,null,false],[132,10,0,null,null,null,null,false],[132,15,0,null,null,null,[16201],false],[132,18,0,null,null,null,null,false],[132,21,0,null,null," 0",null,false],[132,24,0,null,null," 1",null,false],[132,27,0,null,null," sqrt(-1)",null,false],[132,30,0,null,null," The Curve25519 base point",null,false],[132,33,0,null,null," Edwards25519 d = 37095705934669439343138083508754565189542113879843219016388785533085940283555",null,false],[132,36,0,null,null," Edwards25519 2d",null,false],[132,39,0,null,null," Edwards25519 1/sqrt(a-d)",null,false],[132,42,0,null,null," Edwards25519 1-d^2",null,false],[132,45,0,null,null," Edwards25519 (d-1)^2",null,false],[132,48,0,null,null," Edwards25519 sqrt(ad-1) with a = -1 (mod p)",null,false],[132,51,0,null,null," Edwards25519 A, as a single limb",null,false],[132,54,0,null,null," Edwards25519 A",null,false],[132,57,0,null,null," Edwards25519 sqrt(A-2)",null,false],[132,60,0,null,null," Return true if the field element is zero",[16135],false],[0,0,0,"fe",null,"",null,false],[132,68,0,null,null," Return true if both field elements are equivalent",[16137,16138],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[132,73,0,null,null," Unpack a field element",[16140],false],[0,0,0,"s",null,"",null,false],[132,85,0,null,null," Pack a field element",[16142],false],[0,0,0,"fe",null,"",null,false],[132,98,0,null,null," Map a 64 bytes big endian string into a field element",[16144],false],[0,0,0,"s",null,"",null,false],[132,120,0,null,null," Reject non-canonical encodings of an element, possibly ignoring the top bit",[16146,16147],false],[0,0,0,"s",null,"",null,false],[0,0,0,"ignore_extra_bit",null,"",null,true],[132,135,0,null,null," Reduce a field element mod 2^255-19",[16149],false],[0,0,0,"fe",null,"",null,false],[132,172,0,null,null," Add a field element",[16151,16152],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[132,182,0,null,null," Subtract a field element",[16154,16155],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[132,201,0,null,null," Negate a field element",[16157],false],[0,0,0,"a",null,"",null,false],[132,206,0,null,null," Return true if a field element is negative",[16159],false],[0,0,0,"a",null,"",null,false],[132,211,0,null,null," Conditonally replace a field element with `a` if `c` is positive",[16161,16162,16163],false],[0,0,0,"fe",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"c",null,"",null,false],[132,229,0,null,null," Conditionally swap two pairs of field elements if `c` is positive",[16165,16166,16167,16168,16169],false],[0,0,0,"a0",null,"",null,false],[0,0,0,"b0",null,"",null,false],[0,0,0,"a1",null,"",null,false],[0,0,0,"b1",null,"",null,false],[0,0,0,"c",null,"",null,false],[132,252,0,null,null,null,[16171],false],[0,0,0,"r",null,"",null,false],[132,273,0,null,null," Multiply two field elements",[16173,16174],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[132,296,0,null,null,null,[16176,16177],false],[0,0,0,"a",null,"",null,false],[0,0,0,"double",null,"",null,true],[132,325,0,null,null," Square a field element",[16179],false],[0,0,0,"a",null,"",null,false],[132,330,0,null,null," Square and double a field element",[16181],false],[0,0,0,"a",null,"",null,false],[132,335,0,null,null," Multiply a field element with a small (32-bit) integer",[16183,16184],false],[0,0,0,"a",null,"",null,false],[0,0,0,"n",null,"",null,true],[132,350,0,null,null," Square a field element `n` times",[16186,16187],false],[0,0,0,"a",null,"",null,false],[0,0,0,"n",null,"",null,false],[132,360,0,null,null," Return the inverse of a field element, or 0 if a=0.",[16189],false],[0,0,0,"a",null,"",null,false],[132,375,0,null,null," Return a^((p-5)/8) = a^(2^252-3)\n Used to compute square roots since we have p=5 (mod 8); see Cohen and Frey.",[16191],false],[0,0,0,"a",null,"",null,false],[132,387,0,null,null," Return the absolute value of a field element",[16193],false],[0,0,0,"a",null,"",null,false],[132,394,0,null,null," Return true if the field element is a square",[16195],false],[0,0,0,"a",null,"",null,false],[132,407,0,null,null,null,[16197],false],[0,0,0,"x2",null,"",null,false],[132,419,0,null,null," Compute the square root of `x2`, returning `error.NotSquare` if `x2` was not a square",[16199],false],[0,0,0,"x2",null,"",null,false],[132,15,0,null,null,null,null,false],[0,0,0,"limbs",null,null,null,false],[131,12,0,null,null," Field arithmetic mod the order of the main subgroup.",null,false],[0,0,0,"scalar.zig",null,"",[],false],[133,0,0,null,null,null,null,false],[133,1,0,null,null,null,null,false],[133,2,0,null,null,null,null,false],[133,4,0,null,null,null,null,false],[133,7,0,null,null," The scalar field order.",null,false],[133,10,0,null,null," A compressed scalar",null,false],[133,13,0,null,null," Zero",null,false],[133,15,0,null,null,null,null,false],[133,22,0,null,null," Reject a scalar whose encoding is not canonical.",[16213],false],[0,0,0,"s",null,"",null,false],[133,39,0,null,null," Reduce a scalar to the field size.",[16215],false],[0,0,0,"s",null,"",null,false],[133,45,0,null,null," Reduce a 64-bytes scalar to the field size.",[16217],false],[0,0,0,"s",null,"",null,false],[133,52,0,null,null," Perform the X25519 \"clamping\" operation.\n The scalar is then guaranteed to be a multiple of the cofactor.",[16219],false],[0,0,0,"s",null,"",null,false],[133,58,0,null,null," Return a*b (mod L)",[16221,16222],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[133,63,0,null,null," Return a*b+c (mod L)",[16224,16225,16226],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"c",null,"",null,false],[133,68,0,null,null," Return a*8 (mod L)",[16228],false],[0,0,0,"s",null,"",null,false],[133,77,0,null,null," Return a+b (mod L)",[16230,16231],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[133,82,0,null,null," Return -s (mod L)",[16233],false],[0,0,0,"s",null,"",null,false],[133,98,0,null,null," Return (a-b) (mod L)",[16235,16236],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[133,103,0,null,null," Return a random scalar < L",[],false],[133,108,0,null,null," A scalar in unpacked representation",[16267],false],[133,109,0,null,null,null,null,false],[133,113,0,null,null," Unpack a 32-byte representation of a scalar",[16241],false],[0,0,0,"bytes",null,"",null,false],[133,119,0,null,null," Unpack a 64-byte representation of a scalar",[16243],false],[0,0,0,"bytes",null,"",null,false],[133,125,0,null,null," Pack a scalar into bytes",[16245],false],[0,0,0,"expanded",null,"",null,false],[133,136,0,null,null," Return true if the scalar is zero",[16247],false],[0,0,0,"n",null,"",null,false],[133,142,0,null,null," Return x+y (mod L)",[16249,16250],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[133,199,0,null,null," Return x*r (mod L)",[16252,16253],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[133,511,0,null,null," Return x^2 (mod L)",[16255],false],[0,0,0,"x",null,"",null,false],[133,516,0,null,null," Square a scalar `n` times",[16257,16258],false],[0,0,0,"x",null,"",null,false],[0,0,0,"n",null,"",null,true],[133,526,0,null,null," Square and multiply",[16260,16261,16262],false],[0,0,0,"x",null,"",null,false],[0,0,0,"n",null,"",null,true],[0,0,0,"y",null,"",null,false],[133,531,0,null,null," Return the inverse of a scalar (mod L), or 0 if x=0.",[16264],false],[0,0,0,"x",null,"",null,false],[133,562,0,null,null," Return a random scalar < L.",[],false],[133,108,0,null,null,null,null,false],[0,0,0,"limbs",null,null,null,false],[133,574,0,null,null,null,[16280],false],[133,575,0,null,null,null,null,false],[133,578,0,null,null,null,[16271],false],[0,0,0,"bytes",null,"",null,false],[133,588,0,null,null,null,[16273],false],[0,0,0,"bytes",null,"",null,false],[133,599,0,null,null,null,[16275],false],[0,0,0,"expanded_double",null,"",null,false],[133,604,0,null,null," Barrett reduction",[16277,16278],false],[0,0,0,"expanded",null,"",null,false],[0,0,0,"limbs_count",null,"",null,true],[133,574,0,null,null,null,null,false],[0,0,0,"limbs",null,null,null,false],[131,17,0,null,null," Decode a Curve25519 point from its compressed (X) coordinates.",[16282],false],[0,0,0,"s",null,"",null,false],[131,22,0,null,null," Encode a Curve25519 point.",[16284],false],[0,0,0,"p",null,"",null,false],[131,27,0,null,null," The Curve25519 base point.",null,false],[131,30,0,null,null," Check that the encoding of a Curve25519 point is canonical.",[16287],false],[0,0,0,"s",null,"",null,false],[131,35,0,null,null," Reject the neutral element.",[16289],false],[0,0,0,"p",null,"",null,false],[131,42,0,null,null," Multiply a point by the cofactor, returning WeakPublicKey if the element is in a small-order group.",[16291],false],[0,0,0,"p",null,"",null,false],[131,47,0,null,null,null,[16293,16294,16295],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"bits",null,"",null,true],[131,88,0,null,null," Multiply a Curve25519 point by a scalar after \"clamping\" it.\n Clamping forces the scalar to be a multiple of the cofactor in\n order to prevent small subgroups attacks. This is the standard\n way to use Curve25519 for a DH operation.\n Return error.IdentityElement if the resulting point is\n the identity element.",[16297,16298],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s",null,"",null,false],[131,98,0,null,null," Multiply a Curve25519 point by a scalar without clamping it.\n Return error.IdentityElement if the resulting point is\n the identity element or error.WeakPublicKey if the public\n key is a low-order point.",[16300,16301],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s",null,"",null,false],[131,104,0,null,null," Compute the Curve25519 equivalent to an Edwards25519 point.",[16303],false],[0,0,0,"p",null,"",null,false],[131,8,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[130,16,0,null,null," Length (in bytes) of a secret key.",null,false],[130,18,0,null,null," Length (in bytes) of a public key.",null,false],[130,20,0,null,null," Length (in bytes) of the output of the DH function.",null,false],[130,22,0,null,null," Seed (for key pair creation) length in bytes.",null,false],[130,25,0,null,null," An X25519 key pair.",[16316,16318],false],[130,32,0,null,null," Create a new key pair using an optional seed.",[16312],false],[0,0,0,"seed",null,"",null,false],[130,45,0,null,null," Create a key pair from an Ed25519 key pair",[16314],false],[0,0,0,"ed25519_key_pair",null,"",null,false],[130,25,0,null,null,null,null,false],[0,0,0,"public_key",null," Public part.",null,false],[130,25,0,null,null,null,null,false],[0,0,0,"secret_key",null," Secret part.",null,false],[130,60,0,null,null," Compute the public key for a given private key.",[16320],false],[0,0,0,"secret_key",null,"",null,false],[130,66,0,null,null," Compute the X25519 equivalent to an Ed25519 public eky.",[16322],false],[0,0,0,"ed25519_public_key",null,"",null,false],[130,75,0,null,null," Compute the scalar product of a public key and a secret scalar.\n Note that the output should not be used as a shared secret without\n hashing it first.",[16324,16325],false],[0,0,0,"secret_key",null,"",null,false],[0,0,0,"public_key",null,"",null,false],[130,81,0,null,null,null,null,false],[115,71,0,null,null," Key Encapsulation Mechanisms.",[],false],[115,72,0,null,null,null,null,false],[0,0,0,"crypto/kyber_d00.zig",null," Implementation of the IND-CCA2 post-quantum secure key encapsulation\n mechanism (KEM) CRYSTALS-Kyber, as submitted to the third round of the NIST\n Post-Quantum Cryptography (v3.02/\"draft00\"), and selected for standardisation.\n\n Kyber will likely change before final standardisation.\n\n The namespace suffix (currently `_d00`) refers to the version currently\n implemented, in accordance with the draft. It may not be updated if new\n versions of the draft only include editorial changes.\n\n The suffix will eventually be removed once Kyber is finalized.\n\n Quoting from the CFRG I-D:\n\n Kyber is not a Diffie-Hellman (DH) style non-interactive key\n agreement, but instead, Kyber is a Key Encapsulation Method (KEM).\n In essence, a KEM is a Public-Key Encryption (PKE) scheme where the\n plaintext cannot be specified, but is generated as a random key as\n part of the encryption. A KEM can be transformed into an unrestricted\n PKE using HPKE (RFC9180). On its own, a KEM can be used as a key\n agreement method in TLS.\n\n Kyber is an IND-CCA2 secure KEM. It is constructed by applying a\n Fujisaki--Okamato style transformation on InnerPKE, which is the\n underlying IND-CPA secure Public Key Encryption scheme. We cannot\n use InnerPKE directly, as its ciphertexts are malleable.\n\n ```\n                     F.O. transform\n     InnerPKE   ---------------------->   Kyber\n     IND-CPA                              IND-CCA2\n ```\n\n Kyber is a lattice-based scheme.  More precisely, its security is\n based on the learning-with-errors-and-rounding problem in module\n lattices (MLWER).  The underlying polynomial ring R (defined in\n Section 5) is chosen such that multiplication is very fast using the\n number theoretic transform (NTT, see Section 5.1.3).\n\n An InnerPKE private key is a vector _s_ over R of length k which is\n _small_ in a particular way.  Here k is a security parameter akin to\n the size of a prime modulus.  For Kyber512, which targets AES-128's\n security level, the value of k is 2.\n\n The public key consists of two values:\n\n * _A_ a uniformly sampled k by k matrix over R _and_\n\n * _t = A s + e_, where e is a suitably small masking vector.\n\n Distinguishing between such A s + e and a uniformly sampled t is the\n module learning-with-errors (MLWE) problem.  If that is hard, then it\n is also hard to recover the private key from the public key as that\n would allow you to distinguish between those two.\n\n To save space in the public key, A is recomputed deterministically\n from a seed _rho_.\n\n A ciphertext for a message m under this public key is a pair (c_1,\n c_2) computed roughly as follows:\n\n c_1 = Compress(A^T r + e_1, d_u)\n c_2 = Compress(t^T r + e_2 + Decompress(m, 1), d_v)\n\n where\n\n * e_1, e_2 and r are small blinds;\n\n * Compress(-, d) removes some information, leaving d bits per\n   coefficient and Decompress is such that Compress after Decompress\n   does nothing and\n\n * d_u, d_v are scheme parameters.\n\n Distinguishing such a ciphertext and uniformly sampled (c_1, c_2) is\n an example of the full MLWER problem, see section 4.4 of [KyberV302].\n\n To decrypt the ciphertext, one computes\n\n m = Compress(Decompress(c_2, d_v) - s^T Decompress(c_1, d_u), 1).\n\n It it not straight-forward to see that this formula is correct.  In\n fact, there is negligible but non-zero probability that a ciphertext\n does not decrypt correctly given by the DFP column in Table 4.  This\n failure probability can be computed by a careful automated analysis\n of the probabilities involved, see kyber_failure.py of [SecEst].\n\n [KyberV302](https://pq-crystals.org/kyber/data/kyber-specification-round3-20210804.pdf)\n [I-D](https://github.com/bwesterb/draft-schwabe-cfrg-kyber)\n [SecEst](https://github.com/pq-crystals/security-estimates)\n",[],false],[134,104,0,null,null,null,null,false],[134,105,0,null,null,null,null,false],[134,107,0,null,null,null,null,false],[134,108,0,null,null,null,null,false],[134,109,0,null,null,null,null,false],[134,110,0,null,null,null,null,false],[134,111,0,null,null,null,null,false],[134,112,0,null,null,null,null,false],[134,113,0,null,null,null,null,false],[134,116,0,null,null,null,null,false],[134,119,0,null,null,null,null,false],[134,122,0,null,null,null,null,false],[134,125,0,null,null,null,null,false],[134,127,0,null,null,null,[16345,16346,16347,16348,16349],false],[134,127,0,null,null,null,null,false],[0,0,0,"name",null,null,null,false],[0,0,0,"k",null,null,null,false],[0,0,0,"eta1",null,null,null,false],[0,0,0,"du",null,null,null,false],[0,0,0,"dv",null,null,null,false],[134,145,0,null,null,null,null,false],[134,153,0,null,null,null,null,false],[134,161,0,null,null,null,null,false],[134,169,0,null,null,null,null,false],[134,170,0,null,null,null,null,false],[134,171,0,null,null,null,null,false],[134,172,0,null,null,null,null,false],[134,173,0,null,null,null,null,false],[134,175,0,null,null,null,[16359],false],[0,0,0,"p",null,"",[],true],[134,178,0,null,null,null,null,false],[134,180,0,null,null,null,null,false],[134,181,0,null,null,null,null,false],[134,182,0,null,null,null,null,false],[134,185,0,null,null," Length (in bytes) of a shared secret.",null,false],[134,187,0,null,null," Length (in bytes) of a seed for deterministic encapsulation.",null,false],[134,189,0,null,null," Length (in bytes) of a seed for key generation.",null,false],[134,191,0,null,null," Algorithm name.",null,false],[134,194,0,null,null," A shared secret, and an encapsulated (encrypted) representation of it.",[16370,16372],false],[134,194,0,null,null,null,null,false],[0,0,0,"shared_secret",null,null,null,false],[134,194,0,null,null,null,null,false],[0,0,0,"ciphertext",null,null,null,false],[134,200,0,null,null," A Kyber public key.",[16383,16385],false],[134,207,0,null,null," Size of a serialized representation of the key, in bytes.",null,false],[134,212,0,null,null," Generates a shared secret, and encapsulates it for the public key.\n If `seed` is `null`, a random seed is used. This is recommended.\n If `seed` is set, encapsulation is deterministic.",[16376,16377],false],[0,0,0,"pk",null,"",null,false],[0,0,0,"seed_",null,"",null,false],[134,254,0,null,null," Serializes the key into a byte array.",[16379],false],[0,0,0,"pk",null,"",null,false],[134,259,0,null,null," Deserializes the key from a byte array.",[16381],false],[0,0,0,"buf",null,"",null,false],[134,200,0,null,null,null,null,false],[0,0,0,"pk",null,null,null,false],[134,200,0,null,null,null,null,false],[0,0,0,"hpk",null,null,null,false],[134,271,0,null,null," A Kyber secret key.",[16396,16398,16400,16402],false],[134,278,0,null,null," Size of a serialized representation of the key, in bytes.",null,false],[134,282,0,null,null," Decapsulates the shared secret within ct using the private key.",[16389,16390],false],[0,0,0,"sk",null,"",null,false],[0,0,0,"ct",null,"",null,false],[134,313,0,null,null," Serializes the key into a byte array.",[16392],false],[0,0,0,"sk",null,"",null,false],[134,318,0,null,null," Deserializes the key from a byte array.",[16394],false],[0,0,0,"buf",null,"",null,false],[134,271,0,null,null,null,null,false],[0,0,0,"sk",null,null,null,false],[134,271,0,null,null,null,null,false],[0,0,0,"pk",null,null,null,false],[134,271,0,null,null,null,null,false],[0,0,0,"hpk",null,null,null,false],[134,271,0,null,null,null,null,false],[0,0,0,"z",null,null,null,false],[134,333,0,null,null," A Kyber key pair.",[16407,16409],false],[134,340,0,null,null," Create a new key pair.\n If seed is null, a random seed will be generated.\n If a seed is provided, the key pair will be determinsitic.",[16405],false],[0,0,0,"seed_",null,"",null,false],[134,333,0,null,null,null,null,false],[0,0,0,"secret_key",null,null,null,false],[134,333,0,null,null,null,null,false],[0,0,0,"public_key",null,null,null,false],[134,371,0,null,null,null,null,false],[134,373,0,null,null,null,[16422,16424,16426],false],[134,380,0,null,null,null,null,false],[134,382,0,null,null,null,[16414,16415,16416],false],[0,0,0,"pk",null,"",null,false],[0,0,0,"pt",null,"",null,false],[0,0,0,"seed",null,"",null,false],[134,413,0,null,null,null,[16418],false],[0,0,0,"pk",null,"",null,false],[134,417,0,null,null,null,[16420],false],[0,0,0,"buf",null,"",null,false],[134,373,0,null,null,null,null,false],[0,0,0,"rho",null,null,null,false],[134,373,0,null,null,null,null,false],[0,0,0,"th",null,null,null,false],[134,373,0,null,null,null,null,false],[0,0,0,"aT",null,null,null,false],[134,427,0,null,null,null,[16437],false],[134,429,0,null,null,null,null,false],[134,431,0,null,null,null,[16430,16431],false],[0,0,0,"sk",null,"",null,false],[0,0,0,"ct",null,"",null,false],[134,443,0,null,null,null,[16433],false],[0,0,0,"sk",null,"",null,false],[134,447,0,null,null,null,[16435],false],[0,0,0,"buf",null,"",null,false],[134,427,0,null,null,null,null,false],[0,0,0,"sh",null,null,null,false],[134,455,0,null,null,null,[16439,16440,16441],false],[0,0,0,"seed",null,"",null,false],[0,0,0,"pk",null,"",null,false],[0,0,0,"sk",null,"",null,false],[134,490,0,null,null,null,null,false],[134,493,0,null,null,null,null,false],[134,496,0,null,null,null,null,false],[134,499,0,null,null,null,null,false],[134,507,0,null,null,null,null,false],[134,518,0,null,null,null,null,false],[134,590,0,null,null,null,[16449,16450],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,598,0,null,null,null,[16452],false],[0,0,0,"T",null,"",[16454,16456,16458],true],[134,599,0,null,null,null,null,false],[0,0,0,"gcd",null,null,null,false],[134,599,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[134,599,0,null,null,null,null,false],[0,0,0,"y",null,null,null,false],[134,603,0,null,null,null,[16460,16461],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,609,0,null,null,null,[16463,16464],false],[0,0,0,"a",null,"",null,false],[0,0,0,"p",null,"",null,false],[134,616,0,null,null,null,[16466],false],[0,0,0,"x",null,"",null,false],[134,625,0,null,null,null,[16468],false],[0,0,0,"x",null,"",null,false],[134,669,0,null,null,null,[16470],false],[0,0,0,"x",null,"",null,false],[134,687,0,null,null,null,[16472],false],[0,0,0,"x",null,"",null,false],[134,721,0,null,null,null,[16474],false],[0,0,0,"x",null,"",null,false],[134,741,0,null,null,null,[16476,16477,16478],false],[0,0,0,"a",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"p",null,"",null,false],[134,760,0,null,null,null,[],false],[134,777,0,null,null,null,[16527],false],[134,780,0,null,null,null,null,false],[134,781,0,null,null,null,null,false],[134,783,0,null,null,null,[16484,16485],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,791,0,null,null,null,[16487,16488],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,801,0,null,null,null,[16490],false],[0,0,0,"rnd",null,"",null,false],[134,810,0,null,null,null,[16492],false],[0,0,0,"rnd",null,"",null,false],[134,824,0,null,null,null,[16494],false],[0,0,0,"a",null,"",null,false],[134,907,0,null,null,null,[16496],false],[0,0,0,"a",null,"",null,false],[134,964,0,null,null,null,[16498],false],[0,0,0,"a",null,"",null,false],[134,973,0,null,null,null,[16500],false],[0,0,0,"a",null,"",null,false],[134,984,0,null,null,null,[16502],false],[0,0,0,"a",null,"",null,false],[134,992,0,null,null,null,[16504],false],[0,0,0,"d",null,"",null,true],[134,999,0,null,null,null,[16506,16507],false],[0,0,0,"p",null,"",null,false],[0,0,0,"d",null,"",null,true],[134,1055,0,null,null,null,[16509,16510],false],[0,0,0,"d",null,"",null,true],[0,0,0,"in",null,"",null,false],[134,1112,0,null,null,null,[16512,16513],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,1155,0,null,null,null,[16515,16516,16517],false],[0,0,0,"eta",null,"",null,true],[0,0,0,"nonce",null,"",null,false],[0,0,0,"seed",null,"",null,false],[134,1221,0,null,null,null,[16519,16520,16521],false],[0,0,0,"seed",null,"",null,false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[134,1265,0,null,null,null,[16523],false],[0,0,0,"p",null,"",null,false],[134,1280,0,null,null,null,[16525],false],[0,0,0,"buf",null,"",null,false],[134,777,0,null,null,null,null,false],[0,0,0,"cs",null,null,null,false],[134,1294,0,null,null,null,[16529],false],[0,0,0,"K",null,"",[16566],true],[134,1298,0,null,null,null,null,false],[134,1299,0,null,null,null,null,false],[134,1301,0,null,null,null,[16533],false],[0,0,0,"d",null,"",null,true],[134,1305,0,null,null,null,[16535],false],[0,0,0,"a",null,"",null,false],[134,1313,0,null,null,null,[16537],false],[0,0,0,"a",null,"",null,false],[134,1321,0,null,null,null,[16539],false],[0,0,0,"a",null,"",null,false],[134,1329,0,null,null,null,[16541],false],[0,0,0,"a",null,"",null,false],[134,1337,0,null,null,null,[16543,16544],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,1345,0,null,null,null,[16546,16547],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,1355,0,null,null,null,[16549,16550,16551],false],[0,0,0,"eta",null,"",null,true],[0,0,0,"nonce",null,"",null,false],[0,0,0,"seed",null,"",null,false],[134,1371,0,null,null,null,[16553,16554],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,1379,0,null,null,null,[16556,16557],false],[0,0,0,"v",null,"",null,false],[0,0,0,"d",null,"",null,true],[134,1388,0,null,null,null,[16559,16560],false],[0,0,0,"d",null,"",null,true],[0,0,0,"buf",null,"",null,false],[134,1398,0,null,null," Serializes the key into a byte array.",[16562],false],[0,0,0,"v",null,"",null,false],[134,1407,0,null,null," Deserializes the key from a byte array.",[16564],false],[0,0,0,"buf",null,"",null,false],[134,1295,0,null,null,null,null,false],[0,0,0,"ps",null,null,null,false],[134,1420,0,null,null,null,[16568],false],[0,0,0,"K",null,"",[16576],true],[134,1422,0,null,null,null,null,false],[134,1425,0,null,null,null,[16571,16572],false],[0,0,0,"seed",null,"",null,false],[0,0,0,"transposed",null,"",null,true],[134,1442,0,null,null,null,[16574],false],[0,0,0,"m",null,"",null,false],[134,1421,0,null,null,null,null,false],[0,0,0,"vs",null,null,null,false],[134,1455,0,null,null,null,[16578,16579,16580],false],[0,0,0,"len",null,"",null,true],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,1460,0,null,null,null,[16582,16583,16584,16585],false],[0,0,0,"len",null,"",null,true],[0,0,0,"dst",null,"",null,false],[0,0,0,"src",null,"",null,false],[0,0,0,"b",null,"",null,false],[134,1666,0,null,null,null,null,false],[134,1715,0,null,null,null,[16599,16601],false],[134,1719,0,null,null,null,[16589],false],[0,0,0,"g",null,"",null,false],[134,1732,0,null,null,null,[16591,16592],false],[0,0,0,"g",null,"",null,false],[0,0,0,"pd",null,"",null,false],[134,1752,0,null,null,null,[16594,16595],false],[0,0,0,"g",null,"",null,false],[0,0,0,"out",null,"",null,false],[134,1770,0,null,null,null,[16597],false],[0,0,0,"seed",null,"",null,false],[134,1715,0,null,null,null,null,false],[0,0,0,"key",null,null,null,false],[134,1715,0,null,null,null,null,false],[0,0,0,"v",null,null,null,false],[115,76,0,null,null," Elliptic-curve arithmetic.",[],false],[115,77,0,null,null,null,null,false],[115,78,0,null,null,null,null,false],[0,0,0,"crypto/25519/edwards25519.zig",null,"",[],false],[135,0,0,null,null,null,null,false],[135,1,0,null,null,null,null,false],[135,2,0,null,null,null,null,false],[135,3,0,null,null,null,null,false],[135,4,0,null,null,null,null,false],[135,6,0,null,null,null,null,false],[135,7,0,null,null,null,null,false],[135,8,0,null,null,null,null,false],[135,9,0,null,null,null,null,false],[135,10,0,null,null,null,null,false],[135,13,0,null,null," Group operations over Edwards25519.",[16709,16711,16713,16715,16716],false],[135,15,0,null,null," The underlying prime field.",null,false],[135,17,0,null,null," Field arithmetic mod the order of the main subgroup.",null,false],[135,19,0,null,null," Length in bytes of a compressed representation of a point.",null,false],[135,29,0,null,null," Decode an Edwards25519 point from its compressed (Y+sign) coordinates.",[16621],false],[0,0,0,"s",null,"",null,false],[135,50,0,null,null," Encode an Edwards25519 point.",[16623],false],[0,0,0,"p",null,"",null,false],[135,58,0,null,null," Check that the encoding of a point is canonical.",[16625],false],[0,0,0,"s",null,"",null,false],[135,63,0,null,null," The edwards25519 base point.",null,false],[135,71,0,null,null,null,null,false],[135,74,0,null,null," Reject the neutral element.",[16629],false],[0,0,0,"p",null,"",null,false],[135,81,0,null,null," Multiply a point by the cofactor",[16631],false],[0,0,0,"p",null,"",null,false],[135,87,0,null,null," Check that the point does not generate a low-order group.\n Return a `WeakPublicKey` error if it does.",[16633],false],[0,0,0,"p",null,"",null,false],[135,99,0,null,null," Flip the sign of the X coordinate.",[16635],false],[0,0,0,"p",null,"",null,false],[135,104,0,null,null," Double an Edwards25519 point.",[16637],false],[0,0,0,"p",null,"",null,false],[135,121,0,null,null," Add two Edwards25519 points.",[16639,16640],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[135,140,0,null,null," Subtract two Edwards25519 points.",[16642,16643],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[135,144,0,null,null,null,[16645,16646,16647],false],[0,0,0,"p",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"c",null,"",null,false],[135,151,0,null,null,null,[16649,16650,16651],false],[0,0,0,"n",null,"",null,true],[0,0,0,"pc",null,"",null,false],[0,0,0,"b",null,"",null,false],[135,160,0,null,null,null,[16653],false],[0,0,0,"s",null,"",null,false],[135,184,0,null,null,null,[16655,16656,16657],false],[0,0,0,"pc",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"vartime",null,"",null,true],[135,204,0,null,null,null,[16659,16660,16661],false],[0,0,0,"pc",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"vartime",null,"",null,true],[135,223,0,null,null,null,[16663,16664],false],[0,0,0,"p",null,"",null,false],[0,0,0,"count",null,"",null,true],[135,234,0,null,null,null,null,false],[135,242,0,null,null," Multiply an Edwards25519 point by a scalar without clamping it.\n Return error.WeakPublicKey if the base generates a small-order group,\n and error.IdentityElement if the result is the identity element.",[16667,16668],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s",null,"",null,false],[135,253,0,null,null," Multiply an Edwards25519 point by a *PUBLIC* scalar *IN VARIABLE TIME*\n This can be used for signature verification.",[16670,16671],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s",null,"",null,false],[135,265,0,null,null," Double-base multiplication of public parameters - Compute (p1*s1)+(p2*s2) *IN VARIABLE TIME*\n This can be used for signature verification.",[16673,16674,16675,16676],false],[0,0,0,"p1",null,"",null,false],[0,0,0,"s1",null,"",null,false],[0,0,0,"p2",null,"",null,false],[0,0,0,"s2",null,"",null,false],[135,304,0,null,null," Multiscalar multiplication *IN VARIABLE TIME* for public data\n Computes ps0*ss0 + ps1*ss1 + ps2*ss2... faster than doing many of these operations individually",[16678,16679,16680],false],[0,0,0,"count",null,"",null,true],[0,0,0,"ps",null,"",null,false],[0,0,0,"ss",null,"",null,false],[135,346,0,null,null," Multiply an Edwards25519 point by a scalar after \"clamping\" it.\n Clamping forces the scalar to be a multiple of the cofactor in\n order to prevent small subgroups attacks.\n This is strongly recommended for DH operations.\n Return error.WeakPublicKey if the resulting point is\n the identity element.",[16682,16683],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s",null,"",null,false],[135,353,0,null,null,null,[16685],false],[0,0,0,"x",null,"",null,false],[135,361,0,null,null,null,[16687,16688],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[135,382,0,null,null," Elligator2 map - Returns Montgomery affine coordinates",[16690],false],[0,0,0,"r",null,"",[16692,16694,16695],false],[135,382,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[135,382,0,null,null,null,null,false],[0,0,0,"y",null,null,null,false],[0,0,0,"not_square",null,null,null,false],[135,404,0,null,null," Map a 64-bit hash into an Edwards25519 point",[16697],false],[0,0,0,"h",null,"",null,false],[135,414,0,null,null,null,[16699,16700,16701],false],[0,0,0,"n",null,"",null,true],[0,0,0,"ctx",null,"",null,false],[0,0,0,"s",null,"",null,false],[135,471,0,null,null," Hash a context `ctx` and a string `s` into an Edwards25519 point\n\n This function implements the edwards25519_XMD:SHA-512_ELL2_RO_ and edwards25519_XMD:SHA-512_ELL2_NU_\n methods from the \"Hashing to Elliptic Curves\" standard document.\n\n Although not strictly required by the standard, it is recommended to avoid NUL characters in\n the context in order to be compatible with other implementations.",[16703,16704,16705],false],[0,0,0,"random_oracle",null,"",null,true],[0,0,0,"ctx",null,"",null,false],[0,0,0,"s",null,"",null,false],[135,481,0,null,null," Map a 32 bit uniform bit string into an edwards25519 point",[16707],false],[0,0,0,"r",null,"",null,false],[135,13,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[135,13,0,null,null,null,null,false],[0,0,0,"y",null,null,null,false],[135,13,0,null,null,null,null,false],[0,0,0,"z",null,null,null,false],[135,13,0,null,null,null,null,false],[0,0,0,"t",null,null,null,false],[0,0,0,"is_base",null,null,null,false],[135,493,0,null,null,null,null,false],[115,79,0,null,null,null,null,false],[0,0,0,"crypto/pcurves/p256.zig",null,"",[],false],[136,0,0,null,null,null,null,false],[136,1,0,null,null,null,null,false],[136,2,0,null,null,null,null,false],[136,3,0,null,null,null,null,false],[136,5,0,null,null,null,null,false],[136,6,0,null,null,null,null,false],[136,7,0,null,null,null,null,false],[136,8,0,null,null,null,null,false],[136,11,0,null,null," Group operations over P256.",[17170,17172,17174,17175],false],[136,13,0,null,null," The underlying prime field.",null,false],[0,0,0,"p256/field.zig",null,"",[],false],[137,0,0,null,null,null,null,false],[137,1,0,null,null,null,null,false],[0,0,0,"../common.zig",null,"",[],false],[138,0,0,null,null,null,null,false],[138,1,0,null,null,null,null,false],[138,2,0,null,null,null,null,false],[138,3,0,null,null,null,null,false],[138,4,0,null,null,null,null,false],[138,6,0,null,null,null,null,false],[138,7,0,null,null,null,null,false],[138,10,0,null,null," Parameters to create a finite field type.",[16742,16743,16744,16745,16746],false],[0,0,0,"fiat",null,null,null,false],[0,0,0,"field_order",null,null,null,false],[0,0,0,"field_bits",null,null,null,false],[0,0,0,"saturated_bits",null,null,null,false],[0,0,0,"encoded_length",null,null,null,false],[138,19,0,null,null," A field element, internally stored in Montgomery domain.",[16748],false],[0,0,0,"params",null,"",[16814],true],[138,25,0,null,null,null,null,false],[138,30,0,null,null," Field size.",null,false],[138,33,0,null,null," Number of bits to represent the set of all elements.",null,false],[138,36,0,null,null," Number of bits that can be saturated without overflowing.",null,false],[138,39,0,null,null," Number of bytes required to encode an element.",null,false],[138,42,0,null,null," Zero.",null,false],[138,45,0,null,null," One.",null,false],[138,52,0,null,null," Reject non-canonical encodings of an element.",[16757,16758],false],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[138,65,0,null,null," Swap the endianness of an encoded element.",[16760],false],[0,0,0,"s",null,"",null,false],[138,72,0,null,null," Unpack a field element.",[16762,16763],false],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[138,83,0,null,null," Pack a field element.",[16765,16766],false],[0,0,0,"fe",null,"",null,false],[0,0,0,"endian",null,"",null,false],[138,92,0,null,null," Element as an integer.",null,false],[138,95,0,null,null," Create a field element from an integer.",[16769],false],[0,0,0,"x",null,"",null,true],[138,102,0,null,null," Return the field element as an integer.",[16771],false],[0,0,0,"fe",null,"",null,false],[138,108,0,null,null," Return true if the field element is zero.",[16773],false],[0,0,0,"fe",null,"",null,false],[138,115,0,null,null," Return true if both field elements are equivalent.",[16775,16776],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[138,120,0,null,null," Return true if the element is odd.",[16778],false],[0,0,0,"fe",null,"",null,false],[138,126,0,null,null," Conditonally replace a field element with `a` if `c` is positive.",[16780,16781,16782],false],[0,0,0,"fe",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"c",null,"",null,false],[138,131,0,null,null," Add field elements.",[16784,16785],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[138,138,0,null,null," Subtract field elements.",[16787,16788],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[138,145,0,null,null," Double a field element.",[16790],false],[0,0,0,"a",null,"",null,false],[138,152,0,null,null," Multiply field elements.",[16792,16793],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[138,159,0,null,null," Square a field element.",[16795],false],[0,0,0,"a",null,"",null,false],[138,166,0,null,null," Square a field element n times.",[16797,16798],false],[0,0,0,"a",null,"",null,false],[0,0,0,"n",null,"",null,true],[138,176,0,null,null," Compute a^n.",[16800,16801,16802],false],[0,0,0,"a",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"n",null,"",null,true],[138,190,0,null,null," Negate a field element.",[16804],false],[0,0,0,"a",null,"",null,false],[138,198,0,null,null," Return the inverse of a field element, or 0 if a=0.",[16806],false],[0,0,0,"a",null,"",null,false],[138,248,0,null,null," Return true if the field element is a square.",[16808],false],[0,0,0,"x2",null,"",null,false],[138,278,0,null,null,null,[16810],false],[0,0,0,"x2",null,"",null,false],[138,314,0,null,null," Compute the square root of `x2`, returning `error.NotSquare` if `x2` was not a square.",[16812],false],[0,0,0,"x2",null,"",null,false],[138,24,0,null,null,null,null,false],[0,0,0,"limbs",null,null,null,false],[137,3,0,null,null,null,null,false],[137,5,0,null,null,null,null,false],[0,0,0,"p256_64.zig",null,"",[],false],[139,50,0,null,null,null,null,false],[139,51,0,null,null,null,null,false],[139,55,0,null,null,null,null,false],[139,59,0,null,null,null,null,false],[139,74,0,null,null," The function addcarryxU64 is an addition with carry.\n\n Postconditions:\n   out1 = (arg1 + arg2 + arg3) mod 2^64\n   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[16823,16824,16825,16826,16827],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[139,96,0,null,null," The function subborrowxU64 is a subtraction with borrow.\n\n Postconditions:\n   out1 = (-arg1 + arg2 + -arg3) mod 2^64\n   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[16829,16830,16831,16832,16833],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[139,117,0,null,null," The function mulxU64 is a multiplication, returning the full double-width result.\n\n Postconditions:\n   out1 = (arg1 * arg2) mod 2^64\n   out2 = ⌊arg1 * arg2 / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0xffffffffffffffff]",[16835,16836,16837,16838],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[139,136,0,null,null," The function cmovznzU64 is a single-word conditional move.\n\n Postconditions:\n   out1 = (if arg1 = 0 then arg2 else arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[16840,16841,16842,16843],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[139,152,0,null,null," The function mul multiplies two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[16845,16846,16847],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[139,444,0,null,null," The function square squares a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m\n   0 ≤ eval out1 < m\n",[16849,16850],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[139,737,0,null,null," The function add adds two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[16852,16853,16854],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[139,790,0,null,null," The function sub subtracts two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[16856,16857,16858],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[139,833,0,null,null," The function opp negates a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m\n   0 ≤ eval out1 < m\n",[16860,16861],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[139,876,0,null,null," The function fromMontgomery translates a field element out of the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m\n   0 ≤ eval out1 < m\n",[16863,16864],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[139,1029,0,null,null," The function toMontgomery translates a field element into the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = eval arg1 mod m\n   0 ≤ eval out1 < m\n",[16866,16867],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[139,1304,0,null,null," The function nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[16869,16870],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[139,1322,0,null,null," The function selectznz is a multi-limb conditional select.\n\n Postconditions:\n   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16872,16873,16874,16875],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[139,1350,0,null,null," The function toBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]",[16877,16878],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[139,1459,0,null,null," The function fromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.\n\n Preconditions:\n   0 ≤ bytes_eval arg1 < m\n Postconditions:\n   eval out1 mod m = bytes_eval arg1 mod m\n   0 ≤ eval out1 < m\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16880,16881],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[139,1534,0,null,null," The function setOne returns the field element one in the Montgomery domain.\n\n Postconditions:\n   eval (from_montgomery out1) mod m = 1 mod m\n   0 ≤ eval out1 < m\n",[16883],false],[0,0,0,"out1",null,"",null,false],[139,1551,0,null,null," The function msat returns the saturated representation of the prime modulus.\n\n Postconditions:\n   twos_complement_eval out1 = m\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16885],false],[0,0,0,"out1",null,"",null,false],[139,1589,0,null,null," The function divstep computes a divstep.\n\n Preconditions:\n   0 ≤ eval arg4 < m\n   0 ≤ eval arg5 < m\n Postconditions:\n   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)\n   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)\n   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)\n   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)\n   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)\n   0 ≤ eval out5 < m\n   0 ≤ eval out5 < m\n   0 ≤ eval out2 < m\n   0 ≤ eval out3 < m\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16887,16888,16889,16890,16891,16892,16893,16894,16895,16896],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"out3",null,"",null,false],[0,0,0,"out4",null,"",null,false],[0,0,0,"out5",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[0,0,0,"arg4",null,"",null,false],[0,0,0,"arg5",null,"",null,false],[139,1823,0,null,null," The function divstepPrecomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).\n\n Postconditions:\n   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16898],false],[0,0,0,"out1",null,"",null,false],[136,15,0,null,null," Field arithmetic mod the order of the main subgroup.",null,false],[0,0,0,"p256/scalar.zig",null,"",[],false],[140,0,0,null,null,null,null,false],[140,1,0,null,null,null,null,false],[140,2,0,null,null,null,null,false],[140,3,0,null,null,null,null,false],[140,4,0,null,null,null,null,false],[140,5,0,null,null,null,null,false],[140,7,0,null,null,null,null,false],[140,9,0,null,null,null,null,false],[140,10,0,null,null,null,null,false],[140,13,0,null,null," Number of bytes required to encode a scalar.",null,false],[140,16,0,null,null," A compressed scalar, in canonical form.",null,false],[140,18,0,null,null,null,null,false],[0,0,0,"p256_scalar_64.zig",null,"",[],false],[141,50,0,null,null,null,null,false],[141,51,0,null,null,null,null,false],[141,55,0,null,null,null,null,false],[141,59,0,null,null,null,null,false],[141,74,0,null,null," The function addcarryxU64 is an addition with carry.\n\n Postconditions:\n   out1 = (arg1 + arg2 + arg3) mod 2^64\n   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[16919,16920,16921,16922,16923],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[141,96,0,null,null," The function subborrowxU64 is a subtraction with borrow.\n\n Postconditions:\n   out1 = (-arg1 + arg2 + -arg3) mod 2^64\n   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[16925,16926,16927,16928,16929],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[141,117,0,null,null," The function mulxU64 is a multiplication, returning the full double-width result.\n\n Postconditions:\n   out1 = (arg1 * arg2) mod 2^64\n   out2 = ⌊arg1 * arg2 / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0xffffffffffffffff]",[16931,16932,16933,16934],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[141,136,0,null,null," The function cmovznzU64 is a single-word conditional move.\n\n Postconditions:\n   out1 = (if arg1 = 0 then arg2 else arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[16936,16937,16938,16939],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[141,152,0,null,null," The function mul multiplies two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[16941,16942,16943],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[141,492,0,null,null," The function square squares a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m\n   0 ≤ eval out1 < m\n",[16945,16946],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[141,833,0,null,null," The function add adds two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[16948,16949,16950],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[141,886,0,null,null," The function sub subtracts two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[16952,16953,16954],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[141,929,0,null,null," The function opp negates a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m\n   0 ≤ eval out1 < m\n",[16956,16957],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[141,972,0,null,null," The function fromMontgomery translates a field element out of the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m\n   0 ≤ eval out1 < m\n",[16959,16960],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[141,1185,0,null,null," The function toMontgomery translates a field element into the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = eval arg1 mod m\n   0 ≤ eval out1 < m\n",[16962,16963],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[141,1508,0,null,null," The function nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[16965,16966],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[141,1526,0,null,null," The function selectznz is a multi-limb conditional select.\n\n Postconditions:\n   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16968,16969,16970,16971],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[141,1554,0,null,null," The function toBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]",[16973,16974],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[141,1663,0,null,null," The function fromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.\n\n Preconditions:\n   0 ≤ bytes_eval arg1 < m\n Postconditions:\n   eval out1 mod m = bytes_eval arg1 mod m\n   0 ≤ eval out1 < m\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16976,16977],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[141,1738,0,null,null," The function setOne returns the field element one in the Montgomery domain.\n\n Postconditions:\n   eval (from_montgomery out1) mod m = 1 mod m\n   0 ≤ eval out1 < m\n",[16979],false],[0,0,0,"out1",null,"",null,false],[141,1755,0,null,null," The function msat returns the saturated representation of the prime modulus.\n\n Postconditions:\n   twos_complement_eval out1 = m\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16981],false],[0,0,0,"out1",null,"",null,false],[141,1793,0,null,null," The function divstep computes a divstep.\n\n Preconditions:\n   0 ≤ eval arg4 < m\n   0 ≤ eval arg5 < m\n Postconditions:\n   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)\n   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)\n   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)\n   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)\n   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)\n   0 ≤ eval out5 < m\n   0 ≤ eval out5 < m\n   0 ≤ eval out2 < m\n   0 ≤ eval out3 < m\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16983,16984,16985,16986,16987,16988,16989,16990,16991,16992],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"out3",null,"",null,false],[0,0,0,"out4",null,"",null,false],[0,0,0,"out5",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[0,0,0,"arg4",null,"",null,false],[0,0,0,"arg5",null,"",null,false],[141,2027,0,null,null," The function divstepPrecomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).\n\n Postconditions:\n   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[16994],false],[0,0,0,"out1",null,"",null,false],[140,27,0,null,null," The scalar field order.",null,false],[140,30,0,null,null," Reject a scalar whose encoding is not canonical.",[16997,16998],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,35,0,null,null," Reduce a 48-bytes scalar to the field size.",[17000,17001],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,40,0,null,null," Reduce a 64-bytes scalar to the field size.",[17003,17004],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,45,0,null,null," Return a*b (mod L)",[17006,17007,17008],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,50,0,null,null," Return a*b+c (mod L)",[17010,17011,17012,17013],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,55,0,null,null," Return a+b (mod L)",[17015,17016,17017],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,60,0,null,null," Return -s (mod L)",[17019,17020],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,65,0,null,null," Return (a-b) (mod L)",[17022,17023,17024],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,70,0,null,null," Return a random scalar",[17026],false],[0,0,0,"endian",null,"",null,false],[140,75,0,null,null," A scalar in unpacked representation.",[17076],false],[140,79,0,null,null," Zero.",null,false],[140,82,0,null,null," One.",null,false],[140,85,0,null,null," Unpack a serialized representation of a scalar.",[17031,17032],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,90,0,null,null," Reduce a 384 bit input to the field size.",[17034,17035],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,96,0,null,null," Reduce a 512 bit input to the field size.",[17037,17038],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,102,0,null,null," Pack a scalar into bytes.",[17040,17041],false],[0,0,0,"n",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,107,0,null,null," Return true if the scalar is zero..",[17043],false],[0,0,0,"n",null,"",null,false],[140,112,0,null,null," Return true if the scalar is odd.",[17045],false],[0,0,0,"n",null,"",null,false],[140,117,0,null,null," Return true if a and b are equivalent.",[17047,17048],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[140,122,0,null,null," Compute x+y (mod L)",[17050,17051],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[140,127,0,null,null," Compute x-y (mod L)",[17053,17054],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[140,132,0,null,null," Compute 2n (mod L)",[17056],false],[0,0,0,"n",null,"",null,false],[140,137,0,null,null," Compute x*y (mod L)",[17058,17059],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[140,142,0,null,null," Compute x^2 (mod L)",[17061],false],[0,0,0,"n",null,"",null,false],[140,147,0,null,null," Compute x^n (mod L)",[17063,17064,17065],false],[0,0,0,"a",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"n",null,"",null,true],[140,152,0,null,null," Compute -x (mod L)",[17067],false],[0,0,0,"n",null,"",null,false],[140,157,0,null,null," Compute x^-1 (mod L)",[17069],false],[0,0,0,"n",null,"",null,false],[140,162,0,null,null," Return true if n is a quadratic residue mod L.",[17071],false],[0,0,0,"n",null,"",null,false],[140,167,0,null,null," Return the square root of L, or NotSquare if there isn't any solutions.",[17073],false],[0,0,0,"n",null,"",null,false],[140,172,0,null,null," Return a random scalar < L.",[],false],[140,75,0,null,null,null,null,false],[0,0,0,"fe",null,null,null,false],[140,184,0,null,null,null,[17086,17088,17090],false],[140,189,0,null,null,null,[17079,17080,17081],false],[0,0,0,"bits",null,"",null,true],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[140,218,0,null,null,null,[17083,17084],false],[0,0,0,"expanded",null,"",null,false],[0,0,0,"bits",null,"",null,true],[140,184,0,null,null,null,null,false],[0,0,0,"x1",null,null,null,false],[140,184,0,null,null,null,null,false],[0,0,0,"x2",null,null,null,false],[140,184,0,null,null,null,null,false],[0,0,0,"x3",null,null,null,false],[136,24,0,null,null," The P256 base point.",null,false],[136,32,0,null,null," The P256 neutral element.",null,false],[136,34,0,null,null,null,null,false],[136,37,0,null,null," Reject the neutral element.",[17095],false],[0,0,0,"p",null,"",null,false],[136,46,0,null,null," Create a point from affine coordinates after checking that they match the curve equation.",[17097],false],[0,0,0,"p",null,"",null,false],[136,62,0,null,null," Create a point from serialized affine coordinates.",[17099,17100,17101],false],[0,0,0,"xs",null,"",null,false],[0,0,0,"ys",null,"",null,false],[0,0,0,"endian",null,"",null,false],[136,69,0,null,null," Recover the Y coordinate from the X coordinate.",[17103,17104],false],[0,0,0,"x",null,"",null,false],[0,0,0,"is_odd",null,"",null,false],[136,78,0,null,null," Deserialize a SEC1-encoded point.",[17106],false],[0,0,0,"s",null,"",null,false],[136,105,0,null,null," Serialize a point using the compressed SEC-1 format.",[17108],false],[0,0,0,"p",null,"",null,false],[136,114,0,null,null," Serialize a point using the uncompressed SEC-1 format.",[17110],false],[0,0,0,"p",null,"",null,false],[136,124,0,null,null," Return a random point.",[],false],[136,130,0,null,null," Flip the sign of the X coordinate.",[17113],false],[0,0,0,"p",null,"",null,false],[136,136,0,null,null," Double a P256 point.",[17115],false],[0,0,0,"p",null,"",null,false],[136,179,0,null,null," Add P256 points, the second being specified using affine coordinates.",[17117,17118],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[136,227,0,null,null," Add P256 points.",[17120,17121],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[136,279,0,null,null," Subtract P256 points.",[17123,17124],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[136,284,0,null,null," Subtract P256 points, the second being specified using affine coordinates.",[17126,17127],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[136,289,0,null,null," Return affine coordinates.",[17129],false],[0,0,0,"p",null,"",null,false],[136,302,0,null,null," Return true if both coordinate sets represent the same point.",[17131,17132],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[136,310,0,null,null,null,[17134,17135,17136],false],[0,0,0,"p",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"c",null,"",null,false],[136,316,0,null,null,null,[17138,17139,17140],false],[0,0,0,"n",null,"",null,true],[0,0,0,"pc",null,"",null,false],[0,0,0,"b",null,"",null,false],[136,325,0,null,null,null,[17142],false],[0,0,0,"s",null,"",null,false],[136,345,0,null,null,null,[17144,17145,17146],false],[0,0,0,"pc",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"vartime",null,"",null,true],[136,364,0,null,null,null,[17148,17149,17150],false],[0,0,0,"pc",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"vartime",null,"",null,true],[136,383,0,null,null,null,[17152,17153],false],[0,0,0,"p",null,"",null,false],[0,0,0,"count",null,"",null,true],[136,394,0,null,null,null,null,false],[136,401,0,null,null," Multiply an elliptic curve point by a scalar.\n Return error.IdentityElement if the result is the identity element.",[17156,17157,17158],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[136,413,0,null,null," Multiply an elliptic curve point by a *PUBLIC* scalar *IN VARIABLE TIME*\n This can be used for signature verification.",[17160,17161,17162],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[136,425,0,null,null," Double-base multiplication of public parameters - Compute (p1*s1)+(p2*s2) *IN VARIABLE TIME*\n This can be used for signature verification.",[17164,17165,17166,17167,17168],false],[0,0,0,"p1",null,"",null,false],[0,0,0,"s1_",null,"",null,false],[0,0,0,"p2",null,"",null,false],[0,0,0,"s2_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[136,11,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[136,11,0,null,null,null,null,false],[0,0,0,"y",null,null,null,false],[136,11,0,null,null,null,null,false],[0,0,0,"z",null,null,null,false],[0,0,0,"is_base",null,null,null,false],[136,466,0,null,null," A point in affine coordinates.",[17183,17185],false],[136,471,0,null,null," Identity element in affine coordinates.",null,false],[136,473,0,null,null,null,[17179,17180,17181],false],[0,0,0,"p",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"c",null,"",null,false],[136,466,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[136,466,0,null,null,null,null,false],[0,0,0,"y",null,null,null,false],[115,80,0,null,null,null,null,false],[0,0,0,"crypto/pcurves/p384.zig",null,"",[],false],[142,0,0,null,null,null,null,false],[142,1,0,null,null,null,null,false],[142,2,0,null,null,null,null,false],[142,3,0,null,null,null,null,false],[142,5,0,null,null,null,null,false],[142,6,0,null,null,null,null,false],[142,7,0,null,null,null,null,false],[142,8,0,null,null,null,null,false],[142,11,0,null,null," Group operations over P384.",[17548,17550,17552,17553],false],[142,13,0,null,null," The underlying prime field.",null,false],[0,0,0,"p384/field.zig",null,"",[],false],[143,0,0,null,null,null,null,false],[143,1,0,null,null,null,null,false],[143,3,0,null,null,null,null,false],[143,5,0,null,null,null,null,false],[0,0,0,"p384_64.zig",null,"",[],false],[144,19,0,null,null,null,null,false],[144,20,0,null,null,null,null,false],[144,24,0,null,null,null,null,false],[144,28,0,null,null,null,null,false],[144,43,0,null,null," The function addcarryxU64 is an addition with carry.\n\n Postconditions:\n   out1 = (arg1 + arg2 + arg3) mod 2^64\n   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[17209,17210,17211,17212,17213],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[144,65,0,null,null," The function subborrowxU64 is a subtraction with borrow.\n\n Postconditions:\n   out1 = (-arg1 + arg2 + -arg3) mod 2^64\n   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[17215,17216,17217,17218,17219],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[144,86,0,null,null," The function mulxU64 is a multiplication, returning the full double-width result.\n\n Postconditions:\n   out1 = (arg1 * arg2) mod 2^64\n   out2 = ⌊arg1 * arg2 / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0xffffffffffffffff]",[17221,17222,17223,17224],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[144,105,0,null,null," The function cmovznzU64 is a single-word conditional move.\n\n Postconditions:\n   out1 = (if arg1 = 0 then arg2 else arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[17226,17227,17228,17229],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[144,121,0,null,null," The function mul multiplies two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[17231,17232,17233],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[144,841,0,null,null," The function square squares a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m\n   0 ≤ eval out1 < m\n",[17235,17236],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[144,1562,0,null,null," The function add adds two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[17238,17239,17240],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[144,1633,0,null,null," The function sub subtracts two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[17242,17243,17244],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[144,1690,0,null,null," The function opp negates a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m\n   0 ≤ eval out1 < m\n",[17246,17247],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[144,1747,0,null,null," The function fromMontgomery translates a field element out of the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^6) mod m\n   0 ≤ eval out1 < m\n",[17249,17250],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[144,2232,0,null,null," The function toMontgomery translates a field element into the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = eval arg1 mod m\n   0 ≤ eval out1 < m\n",[17252,17253],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[144,2869,0,null,null," The function nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[17255,17256],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[144,2887,0,null,null," The function selectznz is a multi-limb conditional select.\n\n Postconditions:\n   out1 = (if arg1 = 0 then arg2 else arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17258,17259,17260,17261],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[144,2921,0,null,null," The function toBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]",[17263,17264],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[144,3076,0,null,null," The function fromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.\n\n Preconditions:\n   0 ≤ bytes_eval arg1 < m\n Postconditions:\n   eval out1 mod m = bytes_eval arg1 mod m\n   0 ≤ eval out1 < m\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17266,17267],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[144,3183,0,null,null," The function setOne returns the field element one in the Montgomery domain.\n\n Postconditions:\n   eval (from_montgomery out1) mod m = 1 mod m\n   0 ≤ eval out1 < m\n",[17269],false],[0,0,0,"out1",null,"",null,false],[144,3202,0,null,null," The function msat returns the saturated representation of the prime modulus.\n\n Postconditions:\n   twos_complement_eval out1 = m\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17271],false],[0,0,0,"out1",null,"",null,false],[144,3242,0,null,null," The function divstep computes a divstep.\n\n Preconditions:\n   0 ≤ eval arg4 < m\n   0 ≤ eval arg5 < m\n Postconditions:\n   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)\n   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)\n   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)\n   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)\n   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)\n   0 ≤ eval out5 < m\n   0 ≤ eval out5 < m\n   0 ≤ eval out2 < m\n   0 ≤ eval out3 < m\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17273,17274,17275,17276,17277,17278,17279,17280,17281,17282],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"out3",null,"",null,false],[0,0,0,"out4",null,"",null,false],[0,0,0,"out5",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[0,0,0,"arg4",null,"",null,false],[0,0,0,"arg5",null,"",null,false],[144,3568,0,null,null," The function divstepPrecomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).\n\n Postconditions:\n   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17284],false],[0,0,0,"out1",null,"",null,false],[142,15,0,null,null," Field arithmetic mod the order of the main subgroup.",null,false],[0,0,0,"p384/scalar.zig",null,"",[],false],[145,0,0,null,null,null,null,false],[145,1,0,null,null,null,null,false],[145,2,0,null,null,null,null,false],[145,3,0,null,null,null,null,false],[145,4,0,null,null,null,null,false],[145,5,0,null,null,null,null,false],[145,7,0,null,null,null,null,false],[145,9,0,null,null,null,null,false],[145,10,0,null,null,null,null,false],[145,13,0,null,null," Number of bytes required to encode a scalar.",null,false],[145,16,0,null,null," A compressed scalar, in canonical form.",null,false],[145,18,0,null,null,null,null,false],[0,0,0,"p384_scalar_64.zig",null,"",[],false],[146,19,0,null,null,null,null,false],[146,20,0,null,null,null,null,false],[146,24,0,null,null,null,null,false],[146,28,0,null,null,null,null,false],[146,43,0,null,null," The function addcarryxU64 is an addition with carry.\n\n Postconditions:\n   out1 = (arg1 + arg2 + arg3) mod 2^64\n   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[17305,17306,17307,17308,17309],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[146,65,0,null,null," The function subborrowxU64 is a subtraction with borrow.\n\n Postconditions:\n   out1 = (-arg1 + arg2 + -arg3) mod 2^64\n   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[17311,17312,17313,17314,17315],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[146,86,0,null,null," The function mulxU64 is a multiplication, returning the full double-width result.\n\n Postconditions:\n   out1 = (arg1 * arg2) mod 2^64\n   out2 = ⌊arg1 * arg2 / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0xffffffffffffffff]",[17317,17318,17319,17320],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[146,105,0,null,null," The function cmovznzU64 is a single-word conditional move.\n\n Postconditions:\n   out1 = (if arg1 = 0 then arg2 else arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[17322,17323,17324,17325],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[146,121,0,null,null," The function mul multiplies two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[17327,17328,17329],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[146,841,0,null,null," The function square squares a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m\n   0 ≤ eval out1 < m\n",[17331,17332],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[146,1562,0,null,null," The function add adds two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[17334,17335,17336],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[146,1633,0,null,null," The function sub subtracts two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[17338,17339,17340],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[146,1690,0,null,null," The function opp negates a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m\n   0 ≤ eval out1 < m\n",[17342,17343],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[146,1747,0,null,null," The function fromMontgomery translates a field element out of the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^6) mod m\n   0 ≤ eval out1 < m\n",[17345,17346],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[146,2232,0,null,null," The function toMontgomery translates a field element into the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = eval arg1 mod m\n   0 ≤ eval out1 < m\n",[17348,17349],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[146,2923,0,null,null," The function nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[17351,17352],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[146,2941,0,null,null," The function selectznz is a multi-limb conditional select.\n\n Postconditions:\n   out1 = (if arg1 = 0 then arg2 else arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17354,17355,17356,17357],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[146,2975,0,null,null," The function toBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]",[17359,17360],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[146,3130,0,null,null," The function fromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.\n\n Preconditions:\n   0 ≤ bytes_eval arg1 < m\n Postconditions:\n   eval out1 mod m = bytes_eval arg1 mod m\n   0 ≤ eval out1 < m\n\n Input Bounds:\n   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17362,17363],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[146,3237,0,null,null," The function setOne returns the field element one in the Montgomery domain.\n\n Postconditions:\n   eval (from_montgomery out1) mod m = 1 mod m\n   0 ≤ eval out1 < m\n",[17365],false],[0,0,0,"out1",null,"",null,false],[146,3256,0,null,null," The function msat returns the saturated representation of the prime modulus.\n\n Postconditions:\n   twos_complement_eval out1 = m\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17367],false],[0,0,0,"out1",null,"",null,false],[146,3296,0,null,null," The function divstep computes a divstep.\n\n Preconditions:\n   0 ≤ eval arg4 < m\n   0 ≤ eval arg5 < m\n Postconditions:\n   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)\n   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)\n   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)\n   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)\n   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)\n   0 ≤ eval out5 < m\n   0 ≤ eval out5 < m\n   0 ≤ eval out2 < m\n   0 ≤ eval out3 < m\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]\n   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17369,17370,17371,17372,17373,17374,17375,17376,17377,17378],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"out3",null,"",null,false],[0,0,0,"out4",null,"",null,false],[0,0,0,"out5",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[0,0,0,"arg4",null,"",null,false],[0,0,0,"arg5",null,"",null,false],[146,3622,0,null,null," The function divstepPrecomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).\n\n Postconditions:\n   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)\n   0 ≤ eval out1 < m\n\n Output Bounds:\n   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]",[17380],false],[0,0,0,"out1",null,"",null,false],[145,27,0,null,null," The scalar field order.",null,false],[145,30,0,null,null," Reject a scalar whose encoding is not canonical.",[17383,17384],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,35,0,null,null," Reduce a 64-bytes scalar to the field size.",[17386,17387],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,40,0,null,null," Return a*b (mod L)",[17389,17390,17391],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,45,0,null,null," Return a*b+c (mod L)",[17393,17394,17395,17396],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"c",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,50,0,null,null," Return a+b (mod L)",[17398,17399,17400],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,55,0,null,null," Return -s (mod L)",[17402,17403],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,60,0,null,null," Return (a-b) (mod L)",[17405,17406,17407],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,65,0,null,null," Return a random scalar",[17409],false],[0,0,0,"endian",null,"",null,false],[145,70,0,null,null," A scalar in unpacked representation.",[17456],false],[145,74,0,null,null," Zero.",null,false],[145,77,0,null,null," One.",null,false],[145,80,0,null,null," Unpack a serialized representation of a scalar.",[17414,17415],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,85,0,null,null," Reduce a 512 bit input to the field size.",[17417,17418],false],[0,0,0,"s",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,91,0,null,null," Pack a scalar into bytes.",[17420,17421],false],[0,0,0,"n",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,96,0,null,null," Return true if the scalar is zero..",[17423],false],[0,0,0,"n",null,"",null,false],[145,101,0,null,null," Return true if the scalar is odd.",[17425],false],[0,0,0,"n",null,"",null,false],[145,106,0,null,null," Return true if a and b are equivalent.",[17427,17428],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[145,111,0,null,null," Compute x+y (mod L)",[17430,17431],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[145,116,0,null,null," Compute x-y (mod L)",[17433,17434],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[145,121,0,null,null," Compute 2n (mod L)",[17436],false],[0,0,0,"n",null,"",null,false],[145,126,0,null,null," Compute x*y (mod L)",[17438,17439],false],[0,0,0,"x",null,"",null,false],[0,0,0,"y",null,"",null,false],[145,131,0,null,null," Compute x^2 (mod L)",[17441],false],[0,0,0,"n",null,"",null,false],[145,136,0,null,null," Compute x^n (mod L)",[17443,17444,17445],false],[0,0,0,"a",null,"",null,false],[0,0,0,"T",null,"",null,true],[0,0,0,"n",null,"",null,true],[145,141,0,null,null," Compute -x (mod L)",[17447],false],[0,0,0,"n",null,"",null,false],[145,146,0,null,null," Compute x^-1 (mod L)",[17449],false],[0,0,0,"n",null,"",null,false],[145,151,0,null,null," Return true if n is a quadratic residue mod L.",[17451],false],[0,0,0,"n",null,"",null,false],[145,156,0,null,null," Return the square root of L, or NotSquare if there isn't any solutions.",[17453],false],[0,0,0,"n",null,"",null,false],[145,161,0,null,null," Return a random scalar < L.",[],false],[145,70,0,null,null,null,null,false],[0,0,0,"fe",null,null,null,false],[145,173,0,null,null,null,[17466,17468],false],[145,177,0,null,null,null,[17459,17460,17461],false],[0,0,0,"bits",null,"",null,true],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[145,200,0,null,null,null,[17463,17464],false],[0,0,0,"expanded",null,"",null,false],[0,0,0,"bits",null,"",null,true],[145,173,0,null,null,null,null,false],[0,0,0,"x1",null,null,null,false],[145,173,0,null,null,null,null,false],[0,0,0,"x2",null,null,null,false],[142,24,0,null,null," The P384 base point.",null,false],[142,32,0,null,null," The P384 neutral element.",null,false],[142,34,0,null,null,null,null,false],[142,37,0,null,null," Reject the neutral element.",[17473],false],[0,0,0,"p",null,"",null,false],[142,46,0,null,null," Create a point from affine coordinates after checking that they match the curve equation.",[17475],false],[0,0,0,"p",null,"",null,false],[142,62,0,null,null," Create a point from serialized affine coordinates.",[17477,17478,17479],false],[0,0,0,"xs",null,"",null,false],[0,0,0,"ys",null,"",null,false],[0,0,0,"endian",null,"",null,false],[142,69,0,null,null," Recover the Y coordinate from the X coordinate.",[17481,17482],false],[0,0,0,"x",null,"",null,false],[0,0,0,"is_odd",null,"",null,false],[142,78,0,null,null," Deserialize a SEC1-encoded point.",[17484],false],[0,0,0,"s",null,"",null,false],[142,105,0,null,null," Serialize a point using the compressed SEC-1 format.",[17486],false],[0,0,0,"p",null,"",null,false],[142,114,0,null,null," Serialize a point using the uncompressed SEC-1 format.",[17488],false],[0,0,0,"p",null,"",null,false],[142,124,0,null,null," Return a random point.",[],false],[142,130,0,null,null," Flip the sign of the X coordinate.",[17491],false],[0,0,0,"p",null,"",null,false],[142,136,0,null,null," Double a P384 point.",[17493],false],[0,0,0,"p",null,"",null,false],[142,179,0,null,null," Add P384 points, the second being specified using affine coordinates.",[17495,17496],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[142,227,0,null,null," Add P384 points.",[17498,17499],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[142,279,0,null,null," Subtract P384 points.",[17501,17502],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[142,284,0,null,null," Subtract P384 points, the second being specified using affine coordinates.",[17504,17505],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[142,289,0,null,null," Return affine coordinates.",[17507],false],[0,0,0,"p",null,"",null,false],[142,302,0,null,null," Return true if both coordinate sets represent the same point.",[17509,17510],false],[0,0,0,"a",null,"",null,false],[0,0,0,"b",null,"",null,false],[142,310,0,null,null,null,[17512,17513,17514],false],[0,0,0,"p",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"c",null,"",null,false],[142,316,0,null,null,null,[17516,17517,17518],false],[0,0,0,"n",null,"",null,true],[0,0,0,"pc",null,"",null,false],[0,0,0,"b",null,"",null,false],[142,325,0,null,null,null,[17520],false],[0,0,0,"s",null,"",null,false],[142,345,0,null,null,null,[17522,17523,17524],false],[0,0,0,"pc",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"vartime",null,"",null,true],[142,364,0,null,null,null,[17526,17527,17528],false],[0,0,0,"pc",null,"",null,false],[0,0,0,"s",null,"",null,false],[0,0,0,"vartime",null,"",null,true],[142,383,0,null,null,null,[17530,17531],false],[0,0,0,"p",null,"",null,false],[0,0,0,"count",null,"",null,true],[142,394,0,null,null,null,null,false],[142,401,0,null,null," Multiply an elliptic curve point by a scalar.\n Return error.IdentityElement if the result is the identity element.",[17534,17535,17536],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[142,413,0,null,null," Multiply an elliptic curve point by a *PUBLIC* scalar *IN VARIABLE TIME*\n This can be used for signature verification.",[17538,17539,17540],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[142,425,0,null,null," Double-base multiplication of public parameters - Compute (p1*s1)+(p2*s2) *IN VARIABLE TIME*\n This can be used for signature verification.",[17542,17543,17544,17545,17546],false],[0,0,0,"p1",null,"",null,false],[0,0,0,"s1_",null,"",null,false],[0,0,0,"p2",null,"",null,false],[0,0,0,"s2_",null,"",null,false],[0,0,0,"endian",null,"",null,false],[142,11,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[142,11,0,null,null,null,null,false],[0,0,0,"y",null,null,null,false],[142,11,0,null,null,null,null,false],[0,0,0,"z",null,null,null,false],[0,0,0,"is_base",null,null,null,false],[142,466,0,null,null," A point in affine coordinates.",[17561,17563],false],[142,471,0,null,null," Identity element in affine coordinates.",null,false],[142,473,0,null,null,null,[17557,17558,17559],false],[0,0,0,"p",null,"",null,false],[0,0,0,"a",null,"",null,false],[0,0,0,"c",null,"",null,false],[142,466,0,null,null,null,null,false],[0,0,0,"x",null,null,null,false],[142,466,0,null,null,null,null,false],[0,0,0,"y",null,null,null,false],[115,81,0,null,null,null,null,false],[0,0,0,"crypto/25519/ristretto255.zig",null,"",[],false],[147,0,0,null,null,null,null,false],[147,1,0,null,null,null,null,false],[147,3,0,null,null,null,null,false],[147,4,0,null,null,null,null,false],[147,5,0,null,null,null,null,false],[147,6,0,null,null,null,null,false],[147,9,0,null,null," Group operations over Edwards25519.",[17608],false],[147,11,0,null,null," The underlying elliptic curve.",null,false],[147,13,0,null,null," The underlying prime field.",null,false],[147,15,0,null,null," Field arithmetic mod the order of the main subgroup.",null,false],[147,17,0,null,null," Length in byte of an encoded element.",null,false],[147,21,0,null,null,null,[17578,17579],false],[0,0,0,"u",null,"",null,false],[0,0,0,"v",null,"",[17580,17582],false],[0,0,0,"ratio_is_square",null,null,null,false],[147,21,0,null,null,null,null,false],[0,0,0,"root",null,null,null,false],[147,36,0,null,null,null,[17584],false],[0,0,0,"s",null,"",null,false],[147,44,0,null,null," Reject the neutral element.",[17586],false],[0,0,0,"p",null,"",null,false],[147,49,0,null,null," The base point (Ristretto is a curve in desguise).",null,false],[147,52,0,null,null," Decode a Ristretto255 representative.",[17589],false],[0,0,0,"s",null,"",null,false],[147,82,0,null,null," Encode to a Ristretto255 representative.",[17591],false],[0,0,0,"e",null,"",null,false],[147,113,0,null,null,null,[17593],false],[0,0,0,"t",null,"",null,false],[147,136,0,null,null," Map a 64-bit string into a Ristretto255 group element",[17595],false],[0,0,0,"h",null,"",null,false],[147,143,0,null,null," Double a Ristretto255 element.",[17597],false],[0,0,0,"p",null,"",null,false],[147,148,0,null,null," Add two Ristretto255 elements.",[17599,17600],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[147,155,0,null,null," Multiply a Ristretto255 element with a scalar.\n Return error.WeakPublicKey if the resulting element is\n the identity element.",[17602,17603],false],[0,0,0,"p",null,"",null,false],[0,0,0,"s",null,"",null,false],[147,160,0,null,null," Return true if two Ristretto255 elements are equivalent",[17605,17606],false],[0,0,0,"p",null,"",null,false],[0,0,0,"q",null,"",null,false],[147,9,0,null,null,null,null,false],[0,0,0,"p",null,null,null,false],[115,82,0,null,null,null,null,false],[0,0,0,"crypto/pcurves/secp256k1.zig",null,"",[],false],[148,0,0,null,null,null,null,false],[148,1,0,null,null,null,null,false],[148,2,0,null,null,null,null,false],[148,3,0,null,null,null,null,false],[148,4,0,null,null,null,null,false],[148,6,0,null,null,null,null,false],[148,7,0,null,null,null,null,false],[148,8,0,null,null,null,null,false],[148,9,0,null,null,null,null,false],[148,12,0,null,null," Group operations over secp256k1.",[17997,17999,18001,18002],false],[148,14,0,null,null," The underlying prime field.",null,false],[0,0,0,"secp256k1/field.zig",null,"",[],false],[149,0,0,null,null,null,null,false],[149,1,0,null,null,null,null,false],[149,3,0,null,null,null,null,false],[149,5,0,null,null,null,null,false],[0,0,0,"secp256k1_64.zig",null,"",[],false],[150,19,0,null,null,null,null,false],[150,20,0,null,null,null,null,false],[150,24,0,null,null,null,null,false],[150,28,0,null,null,null,null,false],[150,43,0,null,null," The function addcarryxU64 is an addition with carry.\n\n Postconditions:\n   out1 = (arg1 + arg2 + arg3) mod 2^64\n   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[17633,17634,17635,17636,17637],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[150,65,0,null,null," The function subborrowxU64 is a subtraction with borrow.\n\n Postconditions:\n   out1 = (-arg1 + arg2 + -arg3) mod 2^64\n   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0x1]",[17639,17640,17641,17642,17643],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[150,86,0,null,null," The function mulxU64 is a multiplication, returning the full double-width result.\n\n Postconditions:\n   out1 = (arg1 * arg2) mod 2^64\n   out2 = ⌊arg1 * arg2 / 2^64⌋\n\n Input Bounds:\n   arg1: [0x0 ~> 0xffffffffffffffff]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]\n   out2: [0x0 ~> 0xffffffffffffffff]",[17645,17646,17647,17648],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"out2",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[150,105,0,null,null," The function cmovznzU64 is a single-word conditional move.\n\n Postconditions:\n   out1 = (if arg1 = 0 then arg2 else arg3)\n\n Input Bounds:\n   arg1: [0x0 ~> 0x1]\n   arg2: [0x0 ~> 0xffffffffffffffff]\n   arg3: [0x0 ~> 0xffffffffffffffff]\n Output Bounds:\n   out1: [0x0 ~> 0xffffffffffffffff]",[17650,17651,17652,17653],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[0,0,0,"arg3",null,"",null,false],[150,121,0,null,null," The function mul multiplies two field elements in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n   0 ≤ eval arg2 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m\n   0 ≤ eval out1 < m\n",[17655,17656,17657],false],[0,0,0,"out1",null,"",null,false],[0,0,0,"arg1",null,"",null,false],[0,0,0,"arg2",null,"",null,false],[150,461,0,null,null," The function square squares a field element in the Montgomery domain.\n\n Preconditions:\n   0 ≤ eval arg1 < m\n Postconditions:\n   eval (from_montgomery out1) mod m = (eval (fro