// Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Zig --internal-static --public-function-case camelCase --private-function-case camelCase --public-type-case UpperCamelCase --private-type-case UpperCamelCase --no-prefix-fiat --package-name secp256k1_scalar '' 64 '2^256 - 432420386565659656852420866394968145599' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
// curve description (via package name): secp256k1_scalar
// machine_wordsize = 64 (from "64")
// requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
// m = 0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141 (from "2^256 - 432420386565659656852420866394968145599")
//
// NOTE: In addition to the bounds specified above each function, all
//   functions synthesized for this Montgomery arithmetic require the
//   input to be strictly less than the prime modulus (m), and also
//   require the input to be in the unique saturated representation.
//   All functions also ensure that these two properties are true of
//   return values.
//
// Computed values:
//   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)
//   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in
//                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

const std = @import("std");
const mode = @import("builtin").mode; // Checked arithmetic is disabled in non-debug modes to avoid side channels

// The type MontgomeryDomainFieldElement is a field element in the Montgomery domain.
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub const MontgomeryDomainFieldElement = [4]u64;

// The type NonMontgomeryDomainFieldElement is a field element NOT in the Montgomery domain.
// Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub const NonMontgomeryDomainFieldElement = [4]u64;

/// The function addcarryxU64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
inline fn addcarryxU64(out1: *u64, out2: *u1, arg1: u1, arg2: u64, arg3: u64) void {
    @setRuntimeSafety(mode == .Debug);

    const ov1 = @addWithOverflow(arg2, arg3);
    const ov2 = @addWithOverflow(ov1[0], arg1);
    out1.* = ov2[0];
    out2.* = ov1[1] | ov2[1];
}

/// The function subborrowxU64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
inline fn subborrowxU64(out1: *u64, out2: *u1, arg1: u1, arg2: u64, arg3: u64) void {
    @setRuntimeSafety(mode == .Debug);

    const ov1 = @subWithOverflow(arg2, arg3);
    const ov2 = @subWithOverflow(ov1[0], arg1);
    out1.* = ov2[0];
    out2.* = ov1[1] | ov2[1];
}

/// The function mulxU64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
inline fn mulxU64(out1: *u64, out2: *u64, arg1: u64, arg2: u64) void {
    @setRuntimeSafety(mode == .Debug);

    const x = @as(u128, arg1) * @as(u128, arg2);
    out1.* = @as(u64, @truncate(x));
    out2.* = @as(u64, @truncate(x >> 64));
}

/// The function cmovznzU64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
inline fn cmovznzU64(out1: *u64, arg1: u1, arg2: u64, arg3: u64) void {
    @setRuntimeSafety(mode == .Debug);

    const mask = 0 -% @as(u64, arg1);
    out1.* = (mask & arg3) | ((~mask) & arg2);
}

/// The function mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
pub fn mul(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement, arg2: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[1]);
    const x2 = (arg1[2]);
    const x3 = (arg1[3]);
    const x4 = (arg1[0]);
    var x5: u64 = undefined;
    var x6: u64 = undefined;
    mulxU64(&x5, &x6, x4, (arg2[3]));
    var x7: u64 = undefined;
    var x8: u64 = undefined;
    mulxU64(&x7, &x8, x4, (arg2[2]));
    var x9: u64 = undefined;
    var x10: u64 = undefined;
    mulxU64(&x9, &x10, x4, (arg2[1]));
    var x11: u64 = undefined;
    var x12: u64 = undefined;
    mulxU64(&x11, &x12, x4, (arg2[0]));
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    addcarryxU64(&x13, &x14, 0x0, x12, x9);
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    addcarryxU64(&x15, &x16, x14, x10, x7);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    addcarryxU64(&x17, &x18, x16, x8, x5);
    const x19 = (@as(u64, x18) + x6);
    var x20: u64 = undefined;
    var x21: u64 = undefined;
    mulxU64(&x20, &x21, x11, 0x4b0dff665588b13f);
    var x22: u64 = undefined;
    var x23: u64 = undefined;
    mulxU64(&x22, &x23, x20, 0xffffffffffffffff);
    var x24: u64 = undefined;
    var x25: u64 = undefined;
    mulxU64(&x24, &x25, x20, 0xfffffffffffffffe);
    var x26: u64 = undefined;
    var x27: u64 = undefined;
    mulxU64(&x26, &x27, x20, 0xbaaedce6af48a03b);
    var x28: u64 = undefined;
    var x29: u64 = undefined;
    mulxU64(&x28, &x29, x20, 0xbfd25e8cd0364141);
    var x30: u64 = undefined;
    var x31: u1 = undefined;
    addcarryxU64(&x30, &x31, 0x0, x29, x26);
    var x32: u64 = undefined;
    var x33: u1 = undefined;
    addcarryxU64(&x32, &x33, x31, x27, x24);
    var x34: u64 = undefined;
    var x35: u1 = undefined;
    addcarryxU64(&x34, &x35, x33, x25, x22);
    const x36 = (@as(u64, x35) + x23);
    var x37: u64 = undefined;
    var x38: u1 = undefined;
    addcarryxU64(&x37, &x38, 0x0, x11, x28);
    var x39: u64 = undefined;
    var x40: u1 = undefined;
    addcarryxU64(&x39, &x40, x38, x13, x30);
    var x41: u64 = undefined;
    var x42: u1 = undefined;
    addcarryxU64(&x41, &x42, x40, x15, x32);
    var x43: u64 = undefined;
    var x44: u1 = undefined;
    addcarryxU64(&x43, &x44, x42, x17, x34);
    var x45: u64 = undefined;
    var x46: u1 = undefined;
    addcarryxU64(&x45, &x46, x44, x19, x36);
    var x47: u64 = undefined;
    var x48: u64 = undefined;
    mulxU64(&x47, &x48, x1, (arg2[3]));
    var x49: u64 = undefined;
    var x50: u64 = undefined;
    mulxU64(&x49, &x50, x1, (arg2[2]));
    var x51: u64 = undefined;
    var x52: u64 = undefined;
    mulxU64(&x51, &x52, x1, (arg2[1]));
    var x53: u64 = undefined;
    var x54: u64 = undefined;
    mulxU64(&x53, &x54, x1, (arg2[0]));
    var x55: u64 = undefined;
    var x56: u1 = undefined;
    addcarryxU64(&x55, &x56, 0x0, x54, x51);
    var x57: u64 = undefined;
    var x58: u1 = undefined;
    addcarryxU64(&x57, &x58, x56, x52, x49);
    var x59: u64 = undefined;
    var x60: u1 = undefined;
    addcarryxU64(&x59, &x60, x58, x50, x47);
    const x61 = (@as(u64, x60) + x48);
    var x62: u64 = undefined;
    var x63: u1 = undefined;
    addcarryxU64(&x62, &x63, 0x0, x39, x53);
    var x64: u64 = undefined;
    var x65: u1 = undefined;
    addcarryxU64(&x64, &x65, x63, x41, x55);
    var x66: u64 = undefined;
    var x67: u1 = undefined;
    addcarryxU64(&x66, &x67, x65, x43, x57);
    var x68: u64 = undefined;
    var x69: u1 = undefined;
    addcarryxU64(&x68, &x69, x67, x45, x59);
    var x70: u64 = undefined;
    var x71: u1 = undefined;
    addcarryxU64(&x70, &x71, x69, @as(u64, x46), x61);
    var x72: u64 = undefined;
    var x73: u64 = undefined;
    mulxU64(&x72, &x73, x62, 0x4b0dff665588b13f);
    var x74: u64 = undefined;
    var x75: u64 = undefined;
    mulxU64(&x74, &x75, x72, 0xffffffffffffffff);
    var x76: u64 = undefined;
    var x77: u64 = undefined;
    mulxU64(&x76, &x77, x72, 0xfffffffffffffffe);
    var x78: u64 = undefined;
    var x79: u64 = undefined;
    mulxU64(&x78, &x79, x72, 0xbaaedce6af48a03b);
    var x80: u64 = undefined;
    var x81: u64 = undefined;
    mulxU64(&x80, &x81, x72, 0xbfd25e8cd0364141);
    var x82: u64 = undefined;
    var x83: u1 = undefined;
    addcarryxU64(&x82, &x83, 0x0, x81, x78);
    var x84: u64 = undefined;
    var x85: u1 = undefined;
    addcarryxU64(&x84, &x85, x83, x79, x76);
    var x86: u64 = undefined;
    var x87: u1 = undefined;
    addcarryxU64(&x86, &x87, x85, x77, x74);
    const x88 = (@as(u64, x87) + x75);
    var x89: u64 = undefined;
    var x90: u1 = undefined;
    addcarryxU64(&x89, &x90, 0x0, x62, x80);
    var x91: u64 = undefined;
    var x92: u1 = undefined;
    addcarryxU64(&x91, &x92, x90, x64, x82);
    var x93: u64 = undefined;
    var x94: u1 = undefined;
    addcarryxU64(&x93, &x94, x92, x66, x84);
    var x95: u64 = undefined;
    var x96: u1 = undefined;
    addcarryxU64(&x95, &x96, x94, x68, x86);
    var x97: u64 = undefined;
    var x98: u1 = undefined;
    addcarryxU64(&x97, &x98, x96, x70, x88);
    const x99 = (@as(u64, x98) + @as(u64, x71));
    var x100: u64 = undefined;
    var x101: u64 = undefined;
    mulxU64(&x100, &x101, x2, (arg2[3]));
    var x102: u64 = undefined;
    var x103: u64 = undefined;
    mulxU64(&x102, &x103, x2, (arg2[2]));
    var x104: u64 = undefined;
    var x105: u64 = undefined;
    mulxU64(&x104, &x105, x2, (arg2[1]));
    var x106: u64 = undefined;
    var x107: u64 = undefined;
    mulxU64(&x106, &x107, x2, (arg2[0]));
    var x108: u64 = undefined;
    var x109: u1 = undefined;
    addcarryxU64(&x108, &x109, 0x0, x107, x104);
    var x110: u64 = undefined;
    var x111: u1 = undefined;
    addcarryxU64(&x110, &x111, x109, x105, x102);
    var x112: u64 = undefined;
    var x113: u1 = undefined;
    addcarryxU64(&x112, &x113, x111, x103, x100);
    const x114 = (@as(u64, x113) + x101);
    var x115: u64 = undefined;
    var x116: u1 = undefined;
    addcarryxU64(&x115, &x116, 0x0, x91, x106);
    var x117: u64 = undefined;
    var x118: u1 = undefined;
    addcarryxU64(&x117, &x118, x116, x93, x108);
    var x119: u64 = undefined;
    var x120: u1 = undefined;
    addcarryxU64(&x119, &x120, x118, x95, x110);
    var x121: u64 = undefined;
    var x122: u1 = undefined;
    addcarryxU64(&x121, &x122, x120, x97, x112);
    var x123: u64 = undefined;
    var x124: u1 = undefined;
    addcarryxU64(&x123, &x124, x122, x99, x114);
    var x125: u64 = undefined;
    var x126: u64 = undefined;
    mulxU64(&x125, &x126, x115, 0x4b0dff665588b13f);
    var x127: u64 = undefined;
    var x128: u64 = undefined;
    mulxU64(&x127, &x128, x125, 0xffffffffffffffff);
    var x129: u64 = undefined;
    var x130: u64 = undefined;
    mulxU64(&x129, &x130, x125, 0xfffffffffffffffe);
    var x131: u64 = undefined;
    var x132: u64 = undefined;
    mulxU64(&x131, &x132, x125, 0xbaaedce6af48a03b);
    var x133: u64 = undefined;
    var x134: u64 = undefined;
    mulxU64(&x133, &x134, x125, 0xbfd25e8cd0364141);
    var x135: u64 = undefined;
    var x136: u1 = undefined;
    addcarryxU64(&x135, &x136, 0x0, x134, x131);
    var x137: u64 = undefined;
    var x138: u1 = undefined;
    addcarryxU64(&x137, &x138, x136, x132, x129);
    var x139: u64 = undefined;
    var x140: u1 = undefined;
    addcarryxU64(&x139, &x140, x138, x130, x127);
    const x141 = (@as(u64, x140) + x128);
    var x142: u64 = undefined;
    var x143: u1 = undefined;
    addcarryxU64(&x142, &x143, 0x0, x115, x133);
    var x144: u64 = undefined;
    var x145: u1 = undefined;
    addcarryxU64(&x144, &x145, x143, x117, x135);
    var x146: u64 = undefined;
    var x147: u1 = undefined;
    addcarryxU64(&x146, &x147, x145, x119, x137);
    var x148: u64 = undefined;
    var x149: u1 = undefined;
    addcarryxU64(&x148, &x149, x147, x121, x139);
    var x150: u64 = undefined;
    var x151: u1 = undefined;
    addcarryxU64(&x150, &x151, x149, x123, x141);
    const x152 = (@as(u64, x151) + @as(u64, x124));
    var x153: u64 = undefined;
    var x154: u64 = undefined;
    mulxU64(&x153, &x154, x3, (arg2[3]));
    var x155: u64 = undefined;
    var x156: u64 = undefined;
    mulxU64(&x155, &x156, x3, (arg2[2]));
    var x157: u64 = undefined;
    var x158: u64 = undefined;
    mulxU64(&x157, &x158, x3, (arg2[1]));
    var x159: u64 = undefined;
    var x160: u64 = undefined;
    mulxU64(&x159, &x160, x3, (arg2[0]));
    var x161: u64 = undefined;
    var x162: u1 = undefined;
    addcarryxU64(&x161, &x162, 0x0, x160, x157);
    var x163: u64 = undefined;
    var x164: u1 = undefined;
    addcarryxU64(&x163, &x164, x162, x158, x155);
    var x165: u64 = undefined;
    var x166: u1 = undefined;
    addcarryxU64(&x165, &x166, x164, x156, x153);
    const x167 = (@as(u64, x166) + x154);
    var x168: u64 = undefined;
    var x169: u1 = undefined;
    addcarryxU64(&x168, &x169, 0x0, x144, x159);
    var x170: u64 = undefined;
    var x171: u1 = undefined;
    addcarryxU64(&x170, &x171, x169, x146, x161);
    var x172: u64 = undefined;
    var x173: u1 = undefined;
    addcarryxU64(&x172, &x173, x171, x148, x163);
    var x174: u64 = undefined;
    var x175: u1 = undefined;
    addcarryxU64(&x174, &x175, x173, x150, x165);
    var x176: u64 = undefined;
    var x177: u1 = undefined;
    addcarryxU64(&x176, &x177, x175, x152, x167);
    var x178: u64 = undefined;
    var x179: u64 = undefined;
    mulxU64(&x178, &x179, x168, 0x4b0dff665588b13f);
    var x180: u64 = undefined;
    var x181: u64 = undefined;
    mulxU64(&x180, &x181, x178, 0xffffffffffffffff);
    var x182: u64 = undefined;
    var x183: u64 = undefined;
    mulxU64(&x182, &x183, x178, 0xfffffffffffffffe);
    var x184: u64 = undefined;
    var x185: u64 = undefined;
    mulxU64(&x184, &x185, x178, 0xbaaedce6af48a03b);
    var x186: u64 = undefined;
    var x187: u64 = undefined;
    mulxU64(&x186, &x187, x178, 0xbfd25e8cd0364141);
    var x188: u64 = undefined;
    var x189: u1 = undefined;
    addcarryxU64(&x188, &x189, 0x0, x187, x184);
    var x190: u64 = undefined;
    var x191: u1 = undefined;
    addcarryxU64(&x190, &x191, x189, x185, x182);
    var x192: u64 = undefined;
    var x193: u1 = undefined;
    addcarryxU64(&x192, &x193, x191, x183, x180);
    const x194 = (@as(u64, x193) + x181);
    var x195: u64 = undefined;
    var x196: u1 = undefined;
    addcarryxU64(&x195, &x196, 0x0, x168, x186);
    var x197: u64 = undefined;
    var x198: u1 = undefined;
    addcarryxU64(&x197, &x198, x196, x170, x188);
    var x199: u64 = undefined;
    var x200: u1 = undefined;
    addcarryxU64(&x199, &x200, x198, x172, x190);
    var x201: u64 = undefined;
    var x202: u1 = undefined;
    addcarryxU64(&x201, &x202, x200, x174, x192);
    var x203: u64 = undefined;
    var x204: u1 = undefined;
    addcarryxU64(&x203, &x204, x202, x176, x194);
    const x205 = (@as(u64, x204) + @as(u64, x177));
    var x206: u64 = undefined;
    var x207: u1 = undefined;
    subborrowxU64(&x206, &x207, 0x0, x197, 0xbfd25e8cd0364141);
    var x208: u64 = undefined;
    var x209: u1 = undefined;
    subborrowxU64(&x208, &x209, x207, x199, 0xbaaedce6af48a03b);
    var x210: u64 = undefined;
    var x211: u1 = undefined;
    subborrowxU64(&x210, &x211, x209, x201, 0xfffffffffffffffe);
    var x212: u64 = undefined;
    var x213: u1 = undefined;
    subborrowxU64(&x212, &x213, x211, x203, 0xffffffffffffffff);
    var x214: u64 = undefined;
    var x215: u1 = undefined;
    subborrowxU64(&x214, &x215, x213, x205, 0x0);
    var x216: u64 = undefined;
    cmovznzU64(&x216, x215, x206, x197);
    var x217: u64 = undefined;
    cmovznzU64(&x217, x215, x208, x199);
    var x218: u64 = undefined;
    cmovznzU64(&x218, x215, x210, x201);
    var x219: u64 = undefined;
    cmovznzU64(&x219, x215, x212, x203);
    out1[0] = x216;
    out1[1] = x217;
    out1[2] = x218;
    out1[3] = x219;
}

/// The function square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
pub fn square(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[1]);
    const x2 = (arg1[2]);
    const x3 = (arg1[3]);
    const x4 = (arg1[0]);
    var x5: u64 = undefined;
    var x6: u64 = undefined;
    mulxU64(&x5, &x6, x4, (arg1[3]));
    var x7: u64 = undefined;
    var x8: u64 = undefined;
    mulxU64(&x7, &x8, x4, (arg1[2]));
    var x9: u64 = undefined;
    var x10: u64 = undefined;
    mulxU64(&x9, &x10, x4, (arg1[1]));
    var x11: u64 = undefined;
    var x12: u64 = undefined;
    mulxU64(&x11, &x12, x4, (arg1[0]));
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    addcarryxU64(&x13, &x14, 0x0, x12, x9);
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    addcarryxU64(&x15, &x16, x14, x10, x7);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    addcarryxU64(&x17, &x18, x16, x8, x5);
    const x19 = (@as(u64, x18) + x6);
    var x20: u64 = undefined;
    var x21: u64 = undefined;
    mulxU64(&x20, &x21, x11, 0x4b0dff665588b13f);
    var x22: u64 = undefined;
    var x23: u64 = undefined;
    mulxU64(&x22, &x23, x20, 0xffffffffffffffff);
    var x24: u64 = undefined;
    var x25: u64 = undefined;
    mulxU64(&x24, &x25, x20, 0xfffffffffffffffe);
    var x26: u64 = undefined;
    var x27: u64 = undefined;
    mulxU64(&x26, &x27, x20, 0xbaaedce6af48a03b);
    var x28: u64 = undefined;
    var x29: u64 = undefined;
    mulxU64(&x28, &x29, x20, 0xbfd25e8cd0364141);
    var x30: u64 = undefined;
    var x31: u1 = undefined;
    addcarryxU64(&x30, &x31, 0x0, x29, x26);
    var x32: u64 = undefined;
    var x33: u1 = undefined;
    addcarryxU64(&x32, &x33, x31, x27, x24);
    var x34: u64 = undefined;
    var x35: u1 = undefined;
    addcarryxU64(&x34, &x35, x33, x25, x22);
    const x36 = (@as(u64, x35) + x23);
    var x37: u64 = undefined;
    var x38: u1 = undefined;
    addcarryxU64(&x37, &x38, 0x0, x11, x28);
    var x39: u64 = undefined;
    var x40: u1 = undefined;
    addcarryxU64(&x39, &x40, x38, x13, x30);
    var x41: u64 = undefined;
    var x42: u1 = undefined;
    addcarryxU64(&x41, &x42, x40, x15, x32);
    var x43: u64 = undefined;
    var x44: u1 = undefined;
    addcarryxU64(&x43, &x44, x42, x17, x34);
    var x45: u64 = undefined;
    var x46: u1 = undefined;
    addcarryxU64(&x45, &x46, x44, x19, x36);
    var x47: u64 = undefined;
    var x48: u64 = undefined;
    mulxU64(&x47, &x48, x1, (arg1[3]));
    var x49: u64 = undefined;
    var x50: u64 = undefined;
    mulxU64(&x49, &x50, x1, (arg1[2]));
    var x51: u64 = undefined;
    var x52: u64 = undefined;
    mulxU64(&x51, &x52, x1, (arg1[1]));
    var x53: u64 = undefined;
    var x54: u64 = undefined;
    mulxU64(&x53, &x54, x1, (arg1[0]));
    var x55: u64 = undefined;
    var x56: u1 = undefined;
    addcarryxU64(&x55, &x56, 0x0, x54, x51);
    var x57: u64 = undefined;
    var x58: u1 = undefined;
    addcarryxU64(&x57, &x58, x56, x52, x49);
    var x59: u64 = undefined;
    var x60: u1 = undefined;
    addcarryxU64(&x59, &x60, x58, x50, x47);
    const x61 = (@as(u64, x60) + x48);
    var x62: u64 = undefined;
    var x63: u1 = undefined;
    addcarryxU64(&x62, &x63, 0x0, x39, x53);
    var x64: u64 = undefined;
    var x65: u1 = undefined;
    addcarryxU64(&x64, &x65, x63, x41, x55);
    var x66: u64 = undefined;
    var x67: u1 = undefined;
    addcarryxU64(&x66, &x67, x65, x43, x57);
    var x68: u64 = undefined;
    var x69: u1 = undefined;
    addcarryxU64(&x68, &x69, x67, x45, x59);
    var x70: u64 = undefined;
    var x71: u1 = undefined;
    addcarryxU64(&x70, &x71, x69, @as(u64, x46), x61);
    var x72: u64 = undefined;
    var x73: u64 = undefined;
    mulxU64(&x72, &x73, x62, 0x4b0dff665588b13f);
    var x74: u64 = undefined;
    var x75: u64 = undefined;
    mulxU64(&x74, &x75, x72, 0xffffffffffffffff);
    var x76: u64 = undefined;
    var x77: u64 = undefined;
    mulxU64(&x76, &x77, x72, 0xfffffffffffffffe);
    var x78: u64 = undefined;
    var x79: u64 = undefined;
    mulxU64(&x78, &x79, x72, 0xbaaedce6af48a03b);
    var x80: u64 = undefined;
    var x81: u64 = undefined;
    mulxU64(&x80, &x81, x72, 0xbfd25e8cd0364141);
    var x82: u64 = undefined;
    var x83: u1 = undefined;
    addcarryxU64(&x82, &x83, 0x0, x81, x78);
    var x84: u64 = undefined;
    var x85: u1 = undefined;
    addcarryxU64(&x84, &x85, x83, x79, x76);
    var x86: u64 = undefined;
    var x87: u1 = undefined;
    addcarryxU64(&x86, &x87, x85, x77, x74);
    const x88 = (@as(u64, x87) + x75);
    var x89: u64 = undefined;
    var x90: u1 = undefined;
    addcarryxU64(&x89, &x90, 0x0, x62, x80);
    var x91: u64 = undefined;
    var x92: u1 = undefined;
    addcarryxU64(&x91, &x92, x90, x64, x82);
    var x93: u64 = undefined;
    var x94: u1 = undefined;
    addcarryxU64(&x93, &x94, x92, x66, x84);
    var x95: u64 = undefined;
    var x96: u1 = undefined;
    addcarryxU64(&x95, &x96, x94, x68, x86);
    var x97: u64 = undefined;
    var x98: u1 = undefined;
    addcarryxU64(&x97, &x98, x96, x70, x88);
    const x99 = (@as(u64, x98) + @as(u64, x71));
    var x100: u64 = undefined;
    var x101: u64 = undefined;
    mulxU64(&x100, &x101, x2, (arg1[3]));
    var x102: u64 = undefined;
    var x103: u64 = undefined;
    mulxU64(&x102, &x103, x2, (arg1[2]));
    var x104: u64 = undefined;
    var x105: u64 = undefined;
    mulxU64(&x104, &x105, x2, (arg1[1]));
    var x106: u64 = undefined;
    var x107: u64 = undefined;
    mulxU64(&x106, &x107, x2, (arg1[0]));
    var x108: u64 = undefined;
    var x109: u1 = undefined;
    addcarryxU64(&x108, &x109, 0x0, x107, x104);
    var x110: u64 = undefined;
    var x111: u1 = undefined;
    addcarryxU64(&x110, &x111, x109, x105, x102);
    var x112: u64 = undefined;
    var x113: u1 = undefined;
    addcarryxU64(&x112, &x113, x111, x103, x100);
    const x114 = (@as(u64, x113) + x101);
    var x115: u64 = undefined;
    var x116: u1 = undefined;
    addcarryxU64(&x115, &x116, 0x0, x91, x106);
    var x117: u64 = undefined;
    var x118: u1 = undefined;
    addcarryxU64(&x117, &x118, x116, x93, x108);
    var x119: u64 = undefined;
    var x120: u1 = undefined;
    addcarryxU64(&x119, &x120, x118, x95, x110);
    var x121: u64 = undefined;
    var x122: u1 = undefined;
    addcarryxU64(&x121, &x122, x120, x97, x112);
    var x123: u64 = undefined;
    var x124: u1 = undefined;
    addcarryxU64(&x123, &x124, x122, x99, x114);
    var x125: u64 = undefined;
    var x126: u64 = undefined;
    mulxU64(&x125, &x126, x115, 0x4b0dff665588b13f);
    var x127: u64 = undefined;
    var x128: u64 = undefined;
    mulxU64(&x127, &x128, x125, 0xffffffffffffffff);
    var x129: u64 = undefined;
    var x130: u64 = undefined;
    mulxU64(&x129, &x130, x125, 0xfffffffffffffffe);
    var x131: u64 = undefined;
    var x132: u64 = undefined;
    mulxU64(&x131, &x132, x125, 0xbaaedce6af48a03b);
    var x133: u64 = undefined;
    var x134: u64 = undefined;
    mulxU64(&x133, &x134, x125, 0xbfd25e8cd0364141);
    var x135: u64 = undefined;
    var x136: u1 = undefined;
    addcarryxU64(&x135, &x136, 0x0, x134, x131);
    var x137: u64 = undefined;
    var x138: u1 = undefined;
    addcarryxU64(&x137, &x138, x136, x132, x129);
    var x139: u64 = undefined;
    var x140: u1 = undefined;
    addcarryxU64(&x139, &x140, x138, x130, x127);
    const x141 = (@as(u64, x140) + x128);
    var x142: u64 = undefined;
    var x143: u1 = undefined;
    addcarryxU64(&x142, &x143, 0x0, x115, x133);
    var x144: u64 = undefined;
    var x145: u1 = undefined;
    addcarryxU64(&x144, &x145, x143, x117, x135);
    var x146: u64 = undefined;
    var x147: u1 = undefined;
    addcarryxU64(&x146, &x147, x145, x119, x137);
    var x148: u64 = undefined;
    var x149: u1 = undefined;
    addcarryxU64(&x148, &x149, x147, x121, x139);
    var x150: u64 = undefined;
    var x151: u1 = undefined;
    addcarryxU64(&x150, &x151, x149, x123, x141);
    const x152 = (@as(u64, x151) + @as(u64, x124));
    var x153: u64 = undefined;
    var x154: u64 = undefined;
    mulxU64(&x153, &x154, x3, (arg1[3]));
    var x155: u64 = undefined;
    var x156: u64 = undefined;
    mulxU64(&x155, &x156, x3, (arg1[2]));
    var x157: u64 = undefined;
    var x158: u64 = undefined;
    mulxU64(&x157, &x158, x3, (arg1[1]));
    var x159: u64 = undefined;
    var x160: u64 = undefined;
    mulxU64(&x159, &x160, x3, (arg1[0]));
    var x161: u64 = undefined;
    var x162: u1 = undefined;
    addcarryxU64(&x161, &x162, 0x0, x160, x157);
    var x163: u64 = undefined;
    var x164: u1 = undefined;
    addcarryxU64(&x163, &x164, x162, x158, x155);
    var x165: u64 = undefined;
    var x166: u1 = undefined;
    addcarryxU64(&x165, &x166, x164, x156, x153);
    const x167 = (@as(u64, x166) + x154);
    var x168: u64 = undefined;
    var x169: u1 = undefined;
    addcarryxU64(&x168, &x169, 0x0, x144, x159);
    var x170: u64 = undefined;
    var x171: u1 = undefined;
    addcarryxU64(&x170, &x171, x169, x146, x161);
    var x172: u64 = undefined;
    var x173: u1 = undefined;
    addcarryxU64(&x172, &x173, x171, x148, x163);
    var x174: u64 = undefined;
    var x175: u1 = undefined;
    addcarryxU64(&x174, &x175, x173, x150, x165);
    var x176: u64 = undefined;
    var x177: u1 = undefined;
    addcarryxU64(&x176, &x177, x175, x152, x167);
    var x178: u64 = undefined;
    var x179: u64 = undefined;
    mulxU64(&x178, &x179, x168, 0x4b0dff665588b13f);
    var x180: u64 = undefined;
    var x181: u64 = undefined;
    mulxU64(&x180, &x181, x178, 0xffffffffffffffff);
    var x182: u64 = undefined;
    var x183: u64 = undefined;
    mulxU64(&x182, &x183, x178, 0xfffffffffffffffe);
    var x184: u64 = undefined;
    var x185: u64 = undefined;
    mulxU64(&x184, &x185, x178, 0xbaaedce6af48a03b);
    var x186: u64 = undefined;
    var x187: u64 = undefined;
    mulxU64(&x186, &x187, x178, 0xbfd25e8cd0364141);
    var x188: u64 = undefined;
    var x189: u1 = undefined;
    addcarryxU64(&x188, &x189, 0x0, x187, x184);
    var x190: u64 = undefined;
    var x191: u1 = undefined;
    addcarryxU64(&x190, &x191, x189, x185, x182);
    var x192: u64 = undefined;
    var x193: u1 = undefined;
    addcarryxU64(&x192, &x193, x191, x183, x180);
    const x194 = (@as(u64, x193) + x181);
    var x195: u64 = undefined;
    var x196: u1 = undefined;
    addcarryxU64(&x195, &x196, 0x0, x168, x186);
    var x197: u64 = undefined;
    var x198: u1 = undefined;
    addcarryxU64(&x197, &x198, x196, x170, x188);
    var x199: u64 = undefined;
    var x200: u1 = undefined;
    addcarryxU64(&x199, &x200, x198, x172, x190);
    var x201: u64 = undefined;
    var x202: u1 = undefined;
    addcarryxU64(&x201, &x202, x200, x174, x192);
    var x203: u64 = undefined;
    var x204: u1 = undefined;
    addcarryxU64(&x203, &x204, x202, x176, x194);
    const x205 = (@as(u64, x204) + @as(u64, x177));
    var x206: u64 = undefined;
    var x207: u1 = undefined;
    subborrowxU64(&x206, &x207, 0x0, x197, 0xbfd25e8cd0364141);
    var x208: u64 = undefined;
    var x209: u1 = undefined;
    subborrowxU64(&x208, &x209, x207, x199, 0xbaaedce6af48a03b);
    var x210: u64 = undefined;
    var x211: u1 = undefined;
    subborrowxU64(&x210, &x211, x209, x201, 0xfffffffffffffffe);
    var x212: u64 = undefined;
    var x213: u1 = undefined;
    subborrowxU64(&x212, &x213, x211, x203, 0xffffffffffffffff);
    var x214: u64 = undefined;
    var x215: u1 = undefined;
    subborrowxU64(&x214, &x215, x213, x205, 0x0);
    var x216: u64 = undefined;
    cmovznzU64(&x216, x215, x206, x197);
    var x217: u64 = undefined;
    cmovznzU64(&x217, x215, x208, x199);
    var x218: u64 = undefined;
    cmovznzU64(&x218, x215, x210, x201);
    var x219: u64 = undefined;
    cmovznzU64(&x219, x215, x212, x203);
    out1[0] = x216;
    out1[1] = x217;
    out1[2] = x218;
    out1[3] = x219;
}

/// The function add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
pub fn add(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement, arg2: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    addcarryxU64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    var x3: u64 = undefined;
    var x4: u1 = undefined;
    addcarryxU64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    var x5: u64 = undefined;
    var x6: u1 = undefined;
    addcarryxU64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    var x7: u64 = undefined;
    var x8: u1 = undefined;
    addcarryxU64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    var x9: u64 = undefined;
    var x10: u1 = undefined;
    subborrowxU64(&x9, &x10, 0x0, x1, 0xbfd25e8cd0364141);
    var x11: u64 = undefined;
    var x12: u1 = undefined;
    subborrowxU64(&x11, &x12, x10, x3, 0xbaaedce6af48a03b);
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    subborrowxU64(&x13, &x14, x12, x5, 0xfffffffffffffffe);
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    subborrowxU64(&x15, &x16, x14, x7, 0xffffffffffffffff);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    subborrowxU64(&x17, &x18, x16, @as(u64, x8), 0x0);
    var x19: u64 = undefined;
    cmovznzU64(&x19, x18, x9, x1);
    var x20: u64 = undefined;
    cmovznzU64(&x20, x18, x11, x3);
    var x21: u64 = undefined;
    cmovznzU64(&x21, x18, x13, x5);
    var x22: u64 = undefined;
    cmovznzU64(&x22, x18, x15, x7);
    out1[0] = x19;
    out1[1] = x20;
    out1[2] = x21;
    out1[3] = x22;
}

/// The function sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
pub fn sub(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement, arg2: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    subborrowxU64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    var x3: u64 = undefined;
    var x4: u1 = undefined;
    subborrowxU64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    var x5: u64 = undefined;
    var x6: u1 = undefined;
    subborrowxU64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    var x7: u64 = undefined;
    var x8: u1 = undefined;
    subborrowxU64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    var x9: u64 = undefined;
    cmovznzU64(&x9, x8, 0x0, 0xffffffffffffffff);
    var x10: u64 = undefined;
    var x11: u1 = undefined;
    addcarryxU64(&x10, &x11, 0x0, x1, (x9 & 0xbfd25e8cd0364141));
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, x11, x3, (x9 & 0xbaaedce6af48a03b));
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, x13, x5, (x9 & 0xfffffffffffffffe));
    var x16: u64 = undefined;
    var x17: u1 = undefined;
    addcarryxU64(&x16, &x17, x15, x7, x9);
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/// The function opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
pub fn opp(out1: *MontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    subborrowxU64(&x1, &x2, 0x0, 0x0, (arg1[0]));
    var x3: u64 = undefined;
    var x4: u1 = undefined;
    subborrowxU64(&x3, &x4, x2, 0x0, (arg1[1]));
    var x5: u64 = undefined;
    var x6: u1 = undefined;
    subborrowxU64(&x5, &x6, x4, 0x0, (arg1[2]));
    var x7: u64 = undefined;
    var x8: u1 = undefined;
    subborrowxU64(&x7, &x8, x6, 0x0, (arg1[3]));
    var x9: u64 = undefined;
    cmovznzU64(&x9, x8, 0x0, 0xffffffffffffffff);
    var x10: u64 = undefined;
    var x11: u1 = undefined;
    addcarryxU64(&x10, &x11, 0x0, x1, (x9 & 0xbfd25e8cd0364141));
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, x11, x3, (x9 & 0xbaaedce6af48a03b));
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, x13, x5, (x9 & 0xfffffffffffffffe));
    var x16: u64 = undefined;
    var x17: u1 = undefined;
    addcarryxU64(&x16, &x17, x15, x7, x9);
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/// The function fromMontgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
///   0 ≤ eval out1 < m
///
pub fn fromMontgomery(out1: *NonMontgomeryDomainFieldElement, arg1: MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[0]);
    var x2: u64 = undefined;
    var x3: u64 = undefined;
    mulxU64(&x2, &x3, x1, 0x4b0dff665588b13f);
    var x4: u64 = undefined;
    var x5: u64 = undefined;
    mulxU64(&x4, &x5, x2, 0xffffffffffffffff);
    var x6: u64 = undefined;
    var x7: u64 = undefined;
    mulxU64(&x6, &x7, x2, 0xfffffffffffffffe);
    var x8: u64 = undefined;
    var x9: u64 = undefined;
    mulxU64(&x8, &x9, x2, 0xbaaedce6af48a03b);
    var x10: u64 = undefined;
    var x11: u64 = undefined;
    mulxU64(&x10, &x11, x2, 0xbfd25e8cd0364141);
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, 0x0, x11, x8);
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, x13, x9, x6);
    var x16: u64 = undefined;
    var x17: u1 = undefined;
    addcarryxU64(&x16, &x17, x15, x7, x4);
    var x18: u64 = undefined;
    var x19: u1 = undefined;
    addcarryxU64(&x18, &x19, 0x0, x1, x10);
    var x20: u64 = undefined;
    var x21: u1 = undefined;
    addcarryxU64(&x20, &x21, x19, 0x0, x12);
    var x22: u64 = undefined;
    var x23: u1 = undefined;
    addcarryxU64(&x22, &x23, x21, 0x0, x14);
    var x24: u64 = undefined;
    var x25: u1 = undefined;
    addcarryxU64(&x24, &x25, x23, 0x0, x16);
    var x26: u64 = undefined;
    var x27: u1 = undefined;
    addcarryxU64(&x26, &x27, x25, 0x0, (@as(u64, x17) + x5));
    var x28: u64 = undefined;
    var x29: u1 = undefined;
    addcarryxU64(&x28, &x29, 0x0, x20, (arg1[1]));
    var x30: u64 = undefined;
    var x31: u1 = undefined;
    addcarryxU64(&x30, &x31, x29, x22, 0x0);
    var x32: u64 = undefined;
    var x33: u1 = undefined;
    addcarryxU64(&x32, &x33, x31, x24, 0x0);
    var x34: u64 = undefined;
    var x35: u1 = undefined;
    addcarryxU64(&x34, &x35, x33, x26, 0x0);
    var x36: u64 = undefined;
    var x37: u64 = undefined;
    mulxU64(&x36, &x37, x28, 0x4b0dff665588b13f);
    var x38: u64 = undefined;
    var x39: u64 = undefined;
    mulxU64(&x38, &x39, x36, 0xffffffffffffffff);
    var x40: u64 = undefined;
    var x41: u64 = undefined;
    mulxU64(&x40, &x41, x36, 0xfffffffffffffffe);
    var x42: u64 = undefined;
    var x43: u64 = undefined;
    mulxU64(&x42, &x43, x36, 0xbaaedce6af48a03b);
    var x44: u64 = undefined;
    var x45: u64 = undefined;
    mulxU64(&x44, &x45, x36, 0xbfd25e8cd0364141);
    var x46: u64 = undefined;
    var x47: u1 = undefined;
    addcarryxU64(&x46, &x47, 0x0, x45, x42);
    var x48: u64 = undefined;
    var x49: u1 = undefined;
    addcarryxU64(&x48, &x49, x47, x43, x40);
    var x50: u64 = undefined;
    var x51: u1 = undefined;
    addcarryxU64(&x50, &x51, x49, x41, x38);
    var x52: u64 = undefined;
    var x53: u1 = undefined;
    addcarryxU64(&x52, &x53, 0x0, x28, x44);
    var x54: u64 = undefined;
    var x55: u1 = undefined;
    addcarryxU64(&x54, &x55, x53, x30, x46);
    var x56: u64 = undefined;
    var x57: u1 = undefined;
    addcarryxU64(&x56, &x57, x55, x32, x48);
    var x58: u64 = undefined;
    var x59: u1 = undefined;
    addcarryxU64(&x58, &x59, x57, x34, x50);
    var x60: u64 = undefined;
    var x61: u1 = undefined;
    addcarryxU64(&x60, &x61, x59, (@as(u64, x35) + @as(u64, x27)), (@as(u64, x51) + x39));
    var x62: u64 = undefined;
    var x63: u1 = undefined;
    addcarryxU64(&x62, &x63, 0x0, x54, (arg1[2]));
    var x64: u64 = undefined;
    var x65: u1 = undefined;
    addcarryxU64(&x64, &x65, x63, x56, 0x0);
    var x66: u64 = undefined;
    var x67: u1 = undefined;
    addcarryxU64(&x66, &x67, x65, x58, 0x0);
    var x68: u64 = undefined;
    var x69: u1 = undefined;
    addcarryxU64(&x68, &x69, x67, x60, 0x0);
    var x70: u64 = undefined;
    var x71: u64 = undefined;
    mulxU64(&x70, &x71, x62, 0x4b0dff665588b13f);
    var x72: u64 = undefined;
    var x73: u64 = undefined;
    mulxU64(&x72, &x73, x70, 0xffffffffffffffff);
    var x74: u64 = undefined;
    var x75: u64 = undefined;
    mulxU64(&x74, &x75, x70, 0xfffffffffffffffe);
    var x76: u64 = undefined;
    var x77: u64 = undefined;
    mulxU64(&x76, &x77, x70, 0xbaaedce6af48a03b);
    var x78: u64 = undefined;
    var x79: u64 = undefined;
    mulxU64(&x78, &x79, x70, 0xbfd25e8cd0364141);
    var x80: u64 = undefined;
    var x81: u1 = undefined;
    addcarryxU64(&x80, &x81, 0x0, x79, x76);
    var x82: u64 = undefined;
    var x83: u1 = undefined;
    addcarryxU64(&x82, &x83, x81, x77, x74);
    var x84: u64 = undefined;
    var x85: u1 = undefined;
    addcarryxU64(&x84, &x85, x83, x75, x72);
    var x86: u64 = undefined;
    var x87: u1 = undefined;
    addcarryxU64(&x86, &x87, 0x0, x62, x78);
    var x88: u64 = undefined;
    var x89: u1 = undefined;
    addcarryxU64(&x88, &x89, x87, x64, x80);
    var x90: u64 = undefined;
    var x91: u1 = undefined;
    addcarryxU64(&x90, &x91, x89, x66, x82);
    var x92: u64 = undefined;
    var x93: u1 = undefined;
    addcarryxU64(&x92, &x93, x91, x68, x84);
    var x94: u64 = undefined;
    var x95: u1 = undefined;
    addcarryxU64(&x94, &x95, x93, (@as(u64, x69) + @as(u64, x61)), (@as(u64, x85) + x73));
    var x96: u64 = undefined;
    var x97: u1 = undefined;
    addcarryxU64(&x96, &x97, 0x0, x88, (arg1[3]));
    var x98: u64 = undefined;
    var x99: u1 = undefined;
    addcarryxU64(&x98, &x99, x97, x90, 0x0);
    var x100: u64 = undefined;
    var x101: u1 = undefined;
    addcarryxU64(&x100, &x101, x99, x92, 0x0);
    var x102: u64 = undefined;
    var x103: u1 = undefined;
    addcarryxU64(&x102, &x103, x101, x94, 0x0);
    var x104: u64 = undefined;
    var x105: u64 = undefined;
    mulxU64(&x104, &x105, x96, 0x4b0dff665588b13f);
    var x106: u64 = undefined;
    var x107: u64 = undefined;
    mulxU64(&x106, &x107, x104, 0xffffffffffffffff);
    var x108: u64 = undefined;
    var x109: u64 = undefined;
    mulxU64(&x108, &x109, x104, 0xfffffffffffffffe);
    var x110: u64 = undefined;
    var x111: u64 = undefined;
    mulxU64(&x110, &x111, x104, 0xbaaedce6af48a03b);
    var x112: u64 = undefined;
    var x113: u64 = undefined;
    mulxU64(&x112, &x113, x104, 0xbfd25e8cd0364141);
    var x114: u64 = undefined;
    var x115: u1 = undefined;
    addcarryxU64(&x114, &x115, 0x0, x113, x110);
    var x116: u64 = undefined;
    var x117: u1 = undefined;
    addcarryxU64(&x116, &x117, x115, x111, x108);
    var x118: u64 = undefined;
    var x119: u1 = undefined;
    addcarryxU64(&x118, &x119, x117, x109, x106);
    var x120: u64 = undefined;
    var x121: u1 = undefined;
    addcarryxU64(&x120, &x121, 0x0, x96, x112);
    var x122: u64 = undefined;
    var x123: u1 = undefined;
    addcarryxU64(&x122, &x123, x121, x98, x114);
    var x124: u64 = undefined;
    var x125: u1 = undefined;
    addcarryxU64(&x124, &x125, x123, x100, x116);
    var x126: u64 = undefined;
    var x127: u1 = undefined;
    addcarryxU64(&x126, &x127, x125, x102, x118);
    var x128: u64 = undefined;
    var x129: u1 = undefined;
    addcarryxU64(&x128, &x129, x127, (@as(u64, x103) + @as(u64, x95)), (@as(u64, x119) + x107));
    var x130: u64 = undefined;
    var x131: u1 = undefined;
    subborrowxU64(&x130, &x131, 0x0, x122, 0xbfd25e8cd0364141);
    var x132: u64 = undefined;
    var x133: u1 = undefined;
    subborrowxU64(&x132, &x133, x131, x124, 0xbaaedce6af48a03b);
    var x134: u64 = undefined;
    var x135: u1 = undefined;
    subborrowxU64(&x134, &x135, x133, x126, 0xfffffffffffffffe);
    var x136: u64 = undefined;
    var x137: u1 = undefined;
    subborrowxU64(&x136, &x137, x135, x128, 0xffffffffffffffff);
    var x138: u64 = undefined;
    var x139: u1 = undefined;
    subborrowxU64(&x138, &x139, x137, @as(u64, x129), 0x0);
    var x140: u64 = undefined;
    cmovznzU64(&x140, x139, x130, x122);
    var x141: u64 = undefined;
    cmovznzU64(&x141, x139, x132, x124);
    var x142: u64 = undefined;
    cmovznzU64(&x142, x139, x134, x126);
    var x143: u64 = undefined;
    cmovznzU64(&x143, x139, x136, x128);
    out1[0] = x140;
    out1[1] = x141;
    out1[2] = x142;
    out1[3] = x143;
}

/// The function toMontgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
pub fn toMontgomery(out1: *MontgomeryDomainFieldElement, arg1: NonMontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[1]);
    const x2 = (arg1[2]);
    const x3 = (arg1[3]);
    const x4 = (arg1[0]);
    var x5: u64 = undefined;
    var x6: u64 = undefined;
    mulxU64(&x5, &x6, x4, 0x9d671cd581c69bc5);
    var x7: u64 = undefined;
    var x8: u64 = undefined;
    mulxU64(&x7, &x8, x4, 0xe697f5e45bcd07c6);
    var x9: u64 = undefined;
    var x10: u64 = undefined;
    mulxU64(&x9, &x10, x4, 0x741496c20e7cf878);
    var x11: u64 = undefined;
    var x12: u64 = undefined;
    mulxU64(&x11, &x12, x4, 0x896cf21467d7d140);
    var x13: u64 = undefined;
    var x14: u1 = undefined;
    addcarryxU64(&x13, &x14, 0x0, x12, x9);
    var x15: u64 = undefined;
    var x16: u1 = undefined;
    addcarryxU64(&x15, &x16, x14, x10, x7);
    var x17: u64 = undefined;
    var x18: u1 = undefined;
    addcarryxU64(&x17, &x18, x16, x8, x5);
    var x19: u64 = undefined;
    var x20: u64 = undefined;
    mulxU64(&x19, &x20, x11, 0x4b0dff665588b13f);
    var x21: u64 = undefined;
    var x22: u64 = undefined;
    mulxU64(&x21, &x22, x19, 0xffffffffffffffff);
    var x23: u64 = undefined;
    var x24: u64 = undefined;
    mulxU64(&x23, &x24, x19, 0xfffffffffffffffe);
    var x25: u64 = undefined;
    var x26: u64 = undefined;
    mulxU64(&x25, &x26, x19, 0xbaaedce6af48a03b);
    var x27: u64 = undefined;
    var x28: u64 = undefined;
    mulxU64(&x27, &x28, x19, 0xbfd25e8cd0364141);
    var x29: u64 = undefined;
    var x30: u1 = undefined;
    addcarryxU64(&x29, &x30, 0x0, x28, x25);
    var x31: u64 = undefined;
    var x32: u1 = undefined;
    addcarryxU64(&x31, &x32, x30, x26, x23);
    var x33: u64 = undefined;
    var x34: u1 = undefined;
    addcarryxU64(&x33, &x34, x32, x24, x21);
    var x35: u64 = undefined;
    var x36: u1 = undefined;
    addcarryxU64(&x35, &x36, 0x0, x11, x27);
    var x37: u64 = undefined;
    var x38: u1 = undefined;
    addcarryxU64(&x37, &x38, x36, x13, x29);
    var x39: u64 = undefined;
    var x40: u1 = undefined;
    addcarryxU64(&x39, &x40, x38, x15, x31);
    var x41: u64 = undefined;
    var x42: u1 = undefined;
    addcarryxU64(&x41, &x42, x40, x17, x33);
    var x43: u64 = undefined;
    var x44: u1 = undefined;
    addcarryxU64(&x43, &x44, x42, (@as(u64, x18) + x6), (@as(u64, x34) + x22));
    var x45: u64 = undefined;
    var x46: u64 = undefined;
    mulxU64(&x45, &x46, x1, 0x9d671cd581c69bc5);
    var x47: u64 = undefined;
    var x48: u64 = undefined;
    mulxU64(&x47, &x48, x1, 0xe697f5e45bcd07c6);
    var x49: u64 = undefined;
    var x50: u64 = undefined;
    mulxU64(&x49, &x50, x1, 0x741496c20e7cf878);
    var x51: u64 = undefined;
    var x52: u64 = undefined;
    mulxU64(&x51, &x52, x1, 0x896cf21467d7d140);
    var x53: u64 = undefined;
    var x54: u1 = undefined;
    addcarryxU64(&x53, &x54, 0x0, x52, x49);
    var x55: u64 = undefined;
    var x56: u1 = undefined;
    addcarryxU64(&x55, &x56, x54, x50, x47);
    var x57: u64 = undefined;
    var x58: u1 = undefined;
    addcarryxU64(&x57, &x58, x56, x48, x45);
    var x59: u64 = undefined;
    var x60: u1 = undefined;
    addcarryxU64(&x59, &x60, 0x0, x37, x51);
    var x61: u64 = undefined;
    var x62: u1 = undefined;
    addcarryxU64(&x61, &x62, x60, x39, x53);
    var x63: u64 = undefined;
    var x64: u1 = undefined;
    addcarryxU64(&x63, &x64, x62, x41, x55);
    var x65: u64 = undefined;
    var x66: u1 = undefined;
    addcarryxU64(&x65, &x66, x64, x43, x57);
    var x67: u64 = undefined;
    var x68: u64 = undefined;
    mulxU64(&x67, &x68, x59, 0x4b0dff665588b13f);
    var x69: u64 = undefined;
    var x70: u64 = undefined;
    mulxU64(&x69, &x70, x67, 0xffffffffffffffff);
    var x71: u64 = undefined;
    var x72: u64 = undefined;
    mulxU64(&x71, &x72, x67, 0xfffffffffffffffe);
    var x73: u64 = undefined;
    var x74: u64 = undefined;
    mulxU64(&x73, &x74, x67, 0xbaaedce6af48a03b);
    var x75: u64 = undefined;
    var x76: u64 = undefined;
    mulxU64(&x75, &x76, x67, 0xbfd25e8cd0364141);
    var x77: u64 = undefined;
    var x78: u1 = undefined;
    addcarryxU64(&x77, &x78, 0x0, x76, x73);
    var x79: u64 = undefined;
    var x80: u1 = undefined;
    addcarryxU64(&x79, &x80, x78, x74, x71);
    var x81: u64 = undefined;
    var x82: u1 = undefined;
    addcarryxU64(&x81, &x82, x80, x72, x69);
    var x83: u64 = undefined;
    var x84: u1 = undefined;
    addcarryxU64(&x83, &x84, 0x0, x59, x75);
    var x85: u64 = undefined;
    var x86: u1 = undefined;
    addcarryxU64(&x85, &x86, x84, x61, x77);
    var x87: u64 = undefined;
    var x88: u1 = undefined;
    addcarryxU64(&x87, &x88, x86, x63, x79);
    var x89: u64 = undefined;
    var x90: u1 = undefined;
    addcarryxU64(&x89, &x90, x88, x65, x81);
    var x91: u64 = undefined;
    var x92: u1 = undefined;
    addcarryxU64(&x91, &x92, x90, ((@as(u64, x66) + @as(u64, x44)) + (@as(u64, x58) + x46)), (@as(u64, x82) + x70));
    var x93: u64 = undefined;
    var x94: u64 = undefined;
    mulxU64(&x93, &x94, x2, 0x9d671cd581c69bc5);
    var x95: u64 = undefined;
    var x96: u64 = undefined;
    mulxU64(&x95, &x96, x2, 0xe697f5e45bcd07c6);
    var x97: u64 = undefined;
    var x98: u64 = undefined;
    mulxU64(&x97, &x98, x2, 0x741496c20e7cf878);
    var x99: u64 = undefined;
    var x100: u64 = undefined;
    mulxU64(&x99, &x100, x2, 0x896cf21467d7d140);
    var x101: u64 = undefined;
    var x102: u1 = undefined;
    addcarryxU64(&x101, &x102, 0x0, x100, x97);
    var x103: u64 = undefined;
    var x104: u1 = undefined;
    addcarryxU64(&x103, &x104, x102, x98, x95);
    var x105: u64 = undefined;
    var x106: u1 = undefined;
    addcarryxU64(&x105, &x106, x104, x96, x93);
    var x107: u64 = undefined;
    var x108: u1 = undefined;
    addcarryxU64(&x107, &x108, 0x0, x85, x99);
    var x109: u64 = undefined;
    var x110: u1 = undefined;
    addcarryxU64(&x109, &x110, x108, x87, x101);
    var x111: u64 = undefined;
    var x112: u1 = undefined;
    addcarryxU64(&x111, &x112, x110, x89, x103);
    var x113: u64 = undefined;
    var x114: u1 = undefined;
    addcarryxU64(&x113, &x114, x112, x91, x105);
    var x115: u64 = undefined;
    var x116: u64 = undefined;
    mulxU64(&x115, &x116, x107, 0x4b0dff665588b13f);
    var x117: u64 = undefined;
    var x118: u64 = undefined;
    mulxU64(&x117, &x118, x115, 0xffffffffffffffff);
    var x119: u64 = undefined;
    var x120: u64 = undefined;
    mulxU64(&x119, &x120, x115, 0xfffffffffffffffe);
    var x121: u64 = undefined;
    var x122: u64 = undefined;
    mulxU64(&x121, &x122, x115, 0xbaaedce6af48a03b);
    var x123: u64 = undefined;
    var x124: u64 = undefined;
    mulxU64(&x123, &x124, x115, 0xbfd25e8cd0364141);
    var x125: u64 = undefined;
    var x126: u1 = undefined;
    addcarryxU64(&x125, &x126, 0x0, x124, x121);
    var x127: u64 = undefined;
    var x128: u1 = undefined;
    addcarryxU64(&x127, &x128, x126, x122, x119);
    var x129: u64 = undefined;
    var x130: u1 = undefined;
    addcarryxU64(&x129, &x130, x128, x120, x117);
    var x131: u64 = undefined;
    var x132: u1 = undefined;
    addcarryxU64(&x131, &x132, 0x0, x107, x123);
    var x133: u64 = undefined;
    var x134: u1 = undefined;
    addcarryxU64(&x133, &x134, x132, x109, x125);
    var x135: u64 = undefined;
    var x136: u1 = undefined;
    addcarryxU64(&x135, &x136, x134, x111, x127);
    var x137: u64 = undefined;
    var x138: u1 = undefined;
    addcarryxU64(&x137, &x138, x136, x113, x129);
    var x139: u64 = undefined;
    var x140: u1 = undefined;
    addcarryxU64(&x139, &x140, x138, ((@as(u64, x114) + @as(u64, x92)) + (@as(u64, x106) + x94)), (@as(u64, x130) + x118));
    var x141: u64 = undefined;
    var x142: u64 = undefined;
    mulxU64(&x141, &x142, x3, 0x9d671cd581c69bc5);
    var x143: u64 = undefined;
    var x144: u64 = undefined;
    mulxU64(&x143, &x144, x3, 0xe697f5e45bcd07c6);
    var x145: u64 = undefined;
    var x146: u64 = undefined;
    mulxU64(&x145, &x146, x3, 0x741496c20e7cf878);
    var x147: u64 = undefined;
    var x148: u64 = undefined;
    mulxU64(&x147, &x148, x3, 0x896cf21467d7d140);
    var x149: u64 = undefined;
    var x150: u1 = undefined;
    addcarryxU64(&x149, &x150, 0x0, x148, x145);
    var x151: u64 = undefined;
    var x152: u1 = undefined;
    addcarryxU64(&x151, &x152, x150, x146, x143);
    var x153: u64 = undefined;
    var x154: u1 = undefined;
    addcarryxU64(&x153, &x154, x152, x144, x141);
    var x155: u64 = undefined;
    var x156: u1 = undefined;
    addcarryxU64(&x155, &x156, 0x0, x133, x147);
    var x157: u64 = undefined;
    var x158: u1 = undefined;
    addcarryxU64(&x157, &x158, x156, x135, x149);
    var x159: u64 = undefined;
    var x160: u1 = undefined;
    addcarryxU64(&x159, &x160, x158, x137, x151);
    var x161: u64 = undefined;
    var x162: u1 = undefined;
    addcarryxU64(&x161, &x162, x160, x139, x153);
    var x163: u64 = undefined;
    var x164: u64 = undefined;
    mulxU64(&x163, &x164, x155, 0x4b0dff665588b13f);
    var x165: u64 = undefined;
    var x166: u64 = undefined;
    mulxU64(&x165, &x166, x163, 0xffffffffffffffff);
    var x167: u64 = undefined;
    var x168: u64 = undefined;
    mulxU64(&x167, &x168, x163, 0xfffffffffffffffe);
    var x169: u64 = undefined;
    var x170: u64 = undefined;
    mulxU64(&x169, &x170, x163, 0xbaaedce6af48a03b);
    var x171: u64 = undefined;
    var x172: u64 = undefined;
    mulxU64(&x171, &x172, x163, 0xbfd25e8cd0364141);
    var x173: u64 = undefined;
    var x174: u1 = undefined;
    addcarryxU64(&x173, &x174, 0x0, x172, x169);
    var x175: u64 = undefined;
    var x176: u1 = undefined;
    addcarryxU64(&x175, &x176, x174, x170, x167);
    var x177: u64 = undefined;
    var x178: u1 = undefined;
    addcarryxU64(&x177, &x178, x176, x168, x165);
    var x179: u64 = undefined;
    var x180: u1 = undefined;
    addcarryxU64(&x179, &x180, 0x0, x155, x171);
    var x181: u64 = undefined;
    var x182: u1 = undefined;
    addcarryxU64(&x181, &x182, x180, x157, x173);
    var x183: u64 = undefined;
    var x184: u1 = undefined;
    addcarryxU64(&x183, &x184, x182, x159, x175);
    var x185: u64 = undefined;
    var x186: u1 = undefined;
    addcarryxU64(&x185, &x186, x184, x161, x177);
    var x187: u64 = undefined;
    var x188: u1 = undefined;
    addcarryxU64(&x187, &x188, x186, ((@as(u64, x162) + @as(u64, x140)) + (@as(u64, x154) + x142)), (@as(u64, x178) + x166));
    var x189: u64 = undefined;
    var x190: u1 = undefined;
    subborrowxU64(&x189, &x190, 0x0, x181, 0xbfd25e8cd0364141);
    var x191: u64 = undefined;
    var x192: u1 = undefined;
    subborrowxU64(&x191, &x192, x190, x183, 0xbaaedce6af48a03b);
    var x193: u64 = undefined;
    var x194: u1 = undefined;
    subborrowxU64(&x193, &x194, x192, x185, 0xfffffffffffffffe);
    var x195: u64 = undefined;
    var x196: u1 = undefined;
    subborrowxU64(&x195, &x196, x194, x187, 0xffffffffffffffff);
    var x197: u64 = undefined;
    var x198: u1 = undefined;
    subborrowxU64(&x197, &x198, x196, @as(u64, x188), 0x0);
    var x199: u64 = undefined;
    cmovznzU64(&x199, x198, x189, x181);
    var x200: u64 = undefined;
    cmovznzU64(&x200, x198, x191, x183);
    var x201: u64 = undefined;
    cmovznzU64(&x201, x198, x193, x185);
    var x202: u64 = undefined;
    cmovznzU64(&x202, x198, x195, x187);
    out1[0] = x199;
    out1[1] = x200;
    out1[2] = x201;
    out1[3] = x202;
}

/// The function nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
pub fn nonzero(out1: *u64, arg1: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | (arg1[3]))));
    out1.* = x1;
}

/// The function selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn selectznz(out1: *[4]u64, arg1: u1, arg2: [4]u64, arg3: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    cmovznzU64(&x1, arg1, (arg2[0]), (arg3[0]));
    var x2: u64 = undefined;
    cmovznzU64(&x2, arg1, (arg2[1]), (arg3[1]));
    var x3: u64 = undefined;
    cmovznzU64(&x3, arg1, (arg2[2]), (arg3[2]));
    var x4: u64 = undefined;
    cmovznzU64(&x4, arg1, (arg2[3]), (arg3[3]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
}

/// The function toBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
pub fn toBytes(out1: *[32]u8, arg1: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (arg1[3]);
    const x2 = (arg1[2]);
    const x3 = (arg1[1]);
    const x4 = (arg1[0]);
    const x5 = @as(u8, @truncate((x4 & 0xff)));
    const x6 = (x4 >> 8);
    const x7 = @as(u8, @truncate((x6 & 0xff)));
    const x8 = (x6 >> 8);
    const x9 = @as(u8, @truncate((x8 & 0xff)));
    const x10 = (x8 >> 8);
    const x11 = @as(u8, @truncate((x10 & 0xff)));
    const x12 = (x10 >> 8);
    const x13 = @as(u8, @truncate((x12 & 0xff)));
    const x14 = (x12 >> 8);
    const x15 = @as(u8, @truncate((x14 & 0xff)));
    const x16 = (x14 >> 8);
    const x17 = @as(u8, @truncate((x16 & 0xff)));
    const x18 = @as(u8, @truncate((x16 >> 8)));
    const x19 = @as(u8, @truncate((x3 & 0xff)));
    const x20 = (x3 >> 8);
    const x21 = @as(u8, @truncate((x20 & 0xff)));
    const x22 = (x20 >> 8);
    const x23 = @as(u8, @truncate((x22 & 0xff)));
    const x24 = (x22 >> 8);
    const x25 = @as(u8, @truncate((x24 & 0xff)));
    const x26 = (x24 >> 8);
    const x27 = @as(u8, @truncate((x26 & 0xff)));
    const x28 = (x26 >> 8);
    const x29 = @as(u8, @truncate((x28 & 0xff)));
    const x30 = (x28 >> 8);
    const x31 = @as(u8, @truncate((x30 & 0xff)));
    const x32 = @as(u8, @truncate((x30 >> 8)));
    const x33 = @as(u8, @truncate((x2 & 0xff)));
    const x34 = (x2 >> 8);
    const x35 = @as(u8, @truncate((x34 & 0xff)));
    const x36 = (x34 >> 8);
    const x37 = @as(u8, @truncate((x36 & 0xff)));
    const x38 = (x36 >> 8);
    const x39 = @as(u8, @truncate((x38 & 0xff)));
    const x40 = (x38 >> 8);
    const x41 = @as(u8, @truncate((x40 & 0xff)));
    const x42 = (x40 >> 8);
    const x43 = @as(u8, @truncate((x42 & 0xff)));
    const x44 = (x42 >> 8);
    const x45 = @as(u8, @truncate((x44 & 0xff)));
    const x46 = @as(u8, @truncate((x44 >> 8)));
    const x47 = @as(u8, @truncate((x1 & 0xff)));
    const x48 = (x1 >> 8);
    const x49 = @as(u8, @truncate((x48 & 0xff)));
    const x50 = (x48 >> 8);
    const x51 = @as(u8, @truncate((x50 & 0xff)));
    const x52 = (x50 >> 8);
    const x53 = @as(u8, @truncate((x52 & 0xff)));
    const x54 = (x52 >> 8);
    const x55 = @as(u8, @truncate((x54 & 0xff)));
    const x56 = (x54 >> 8);
    const x57 = @as(u8, @truncate((x56 & 0xff)));
    const x58 = (x56 >> 8);
    const x59 = @as(u8, @truncate((x58 & 0xff)));
    const x60 = @as(u8, @truncate((x58 >> 8)));
    out1[0] = x5;
    out1[1] = x7;
    out1[2] = x9;
    out1[3] = x11;
    out1[4] = x13;
    out1[5] = x15;
    out1[6] = x17;
    out1[7] = x18;
    out1[8] = x19;
    out1[9] = x21;
    out1[10] = x23;
    out1[11] = x25;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x39;
    out1[20] = x41;
    out1[21] = x43;
    out1[22] = x45;
    out1[23] = x46;
    out1[24] = x47;
    out1[25] = x49;
    out1[26] = x51;
    out1[27] = x53;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
}

/// The function fromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn fromBytes(out1: *[4]u64, arg1: [32]u8) void {
    @setRuntimeSafety(mode == .Debug);

    const x1 = (@as(u64, (arg1[31])) << 56);
    const x2 = (@as(u64, (arg1[30])) << 48);
    const x3 = (@as(u64, (arg1[29])) << 40);
    const x4 = (@as(u64, (arg1[28])) << 32);
    const x5 = (@as(u64, (arg1[27])) << 24);
    const x6 = (@as(u64, (arg1[26])) << 16);
    const x7 = (@as(u64, (arg1[25])) << 8);
    const x8 = (arg1[24]);
    const x9 = (@as(u64, (arg1[23])) << 56);
    const x10 = (@as(u64, (arg1[22])) << 48);
    const x11 = (@as(u64, (arg1[21])) << 40);
    const x12 = (@as(u64, (arg1[20])) << 32);
    const x13 = (@as(u64, (arg1[19])) << 24);
    const x14 = (@as(u64, (arg1[18])) << 16);
    const x15 = (@as(u64, (arg1[17])) << 8);
    const x16 = (arg1[16]);
    const x17 = (@as(u64, (arg1[15])) << 56);
    const x18 = (@as(u64, (arg1[14])) << 48);
    const x19 = (@as(u64, (arg1[13])) << 40);
    const x20 = (@as(u64, (arg1[12])) << 32);
    const x21 = (@as(u64, (arg1[11])) << 24);
    const x22 = (@as(u64, (arg1[10])) << 16);
    const x23 = (@as(u64, (arg1[9])) << 8);
    const x24 = (arg1[8]);
    const x25 = (@as(u64, (arg1[7])) << 56);
    const x26 = (@as(u64, (arg1[6])) << 48);
    const x27 = (@as(u64, (arg1[5])) << 40);
    const x28 = (@as(u64, (arg1[4])) << 32);
    const x29 = (@as(u64, (arg1[3])) << 24);
    const x30 = (@as(u64, (arg1[2])) << 16);
    const x31 = (@as(u64, (arg1[1])) << 8);
    const x32 = (arg1[0]);
    const x33 = (x31 + @as(u64, x32));
    const x34 = (x30 + x33);
    const x35 = (x29 + x34);
    const x36 = (x28 + x35);
    const x37 = (x27 + x36);
    const x38 = (x26 + x37);
    const x39 = (x25 + x38);
    const x40 = (x23 + @as(u64, x24));
    const x41 = (x22 + x40);
    const x42 = (x21 + x41);
    const x43 = (x20 + x42);
    const x44 = (x19 + x43);
    const x45 = (x18 + x44);
    const x46 = (x17 + x45);
    const x47 = (x15 + @as(u64, x16));
    const x48 = (x14 + x47);
    const x49 = (x13 + x48);
    const x50 = (x12 + x49);
    const x51 = (x11 + x50);
    const x52 = (x10 + x51);
    const x53 = (x9 + x52);
    const x54 = (x7 + @as(u64, x8));
    const x55 = (x6 + x54);
    const x56 = (x5 + x55);
    const x57 = (x4 + x56);
    const x58 = (x3 + x57);
    const x59 = (x2 + x58);
    const x60 = (x1 + x59);
    out1[0] = x39;
    out1[1] = x46;
    out1[2] = x53;
    out1[3] = x60;
}

/// The function setOne returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
pub fn setOne(out1: *MontgomeryDomainFieldElement) void {
    @setRuntimeSafety(mode == .Debug);

    out1[0] = 0x402da1732fc9bebf;
    out1[1] = 0x4551231950b75fc4;
    out1[2] = 0x1;
    out1[3] = 0x0;
}

/// The function msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn msat(out1: *[5]u64) void {
    @setRuntimeSafety(mode == .Debug);

    out1[0] = 0xbfd25e8cd0364141;
    out1[1] = 0xbaaedce6af48a03b;
    out1[2] = 0xfffffffffffffffe;
    out1[3] = 0xffffffffffffffff;
    out1[4] = 0x0;
}

/// The function divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn divstep(out1: *u64, out2: *[5]u64, out3: *[5]u64, out4: *[4]u64, out5: *[4]u64, arg1: u64, arg2: [5]u64, arg3: [5]u64, arg4: [4]u64, arg5: [4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    var x1: u64 = undefined;
    var x2: u1 = undefined;
    addcarryxU64(&x1, &x2, 0x0, (~arg1), 0x1);
    const x3 = (@as(u1, @truncate((x1 >> 63))) & @as(u1, @truncate(((arg3[0]) & 0x1))));
    var x4: u64 = undefined;
    var x5: u1 = undefined;
    addcarryxU64(&x4, &x5, 0x0, (~arg1), 0x1);
    var x6: u64 = undefined;
    cmovznzU64(&x6, x3, arg1, x4);
    var x7: u64 = undefined;
    cmovznzU64(&x7, x3, (arg2[0]), (arg3[0]));
    var x8: u64 = undefined;
    cmovznzU64(&x8, x3, (arg2[1]), (arg3[1]));
    var x9: u64 = undefined;
    cmovznzU64(&x9, x3, (arg2[2]), (arg3[2]));
    var x10: u64 = undefined;
    cmovznzU64(&x10, x3, (arg2[3]), (arg3[3]));
    var x11: u64 = undefined;
    cmovznzU64(&x11, x3, (arg2[4]), (arg3[4]));
    var x12: u64 = undefined;
    var x13: u1 = undefined;
    addcarryxU64(&x12, &x13, 0x0, 0x1, (~(arg2[0])));
    var x14: u64 = undefined;
    var x15: u1 = undefined;
    addcarryxU64(&x14, &x15, x13, 0x0, (~(arg2[1])));
    var x16: u64 = undefined;
    var x17: u1 = undefined;
    addcarryxU64(&x16, &x17, x15, 0x0, (~(arg2[2])));
    var x18: u64 = undefined;
    var x19: u1 = undefined;
    addcarryxU64(&x18, &x19, x17, 0x0, (~(arg2[3])));
    var x20: u64 = undefined;
    var x21: u1 = undefined;
    addcarryxU64(&x20, &x21, x19, 0x0, (~(arg2[4])));
    var x22: u64 = undefined;
    cmovznzU64(&x22, x3, (arg3[0]), x12);
    var x23: u64 = undefined;
    cmovznzU64(&x23, x3, (arg3[1]), x14);
    var x24: u64 = undefined;
    cmovznzU64(&x24, x3, (arg3[2]), x16);
    var x25: u64 = undefined;
    cmovznzU64(&x25, x3, (arg3[3]), x18);
    var x26: u64 = undefined;
    cmovznzU64(&x26, x3, (arg3[4]), x20);
    var x27: u64 = undefined;
    cmovznzU64(&x27, x3, (arg4[0]), (arg5[0]));
    var x28: u64 = undefined;
    cmovznzU64(&x28, x3, (arg4[1]), (arg5[1]));
    var x29: u64 = undefined;
    cmovznzU64(&x29, x3, (arg4[2]), (arg5[2]));
    var x30: u64 = undefined;
    cmovznzU64(&x30, x3, (arg4[3]), (arg5[3]));
    var x31: u64 = undefined;
    var x32: u1 = undefined;
    addcarryxU64(&x31, &x32, 0x0, x27, x27);
    var x33: u64 = undefined;
    var x34: u1 = undefined;
    addcarryxU64(&x33, &x34, x32, x28, x28);
    var x35: u64 = undefined;
    var x36: u1 = undefined;
    addcarryxU64(&x35, &x36, x34, x29, x29);
    var x37: u64 = undefined;
    var x38: u1 = undefined;
    addcarryxU64(&x37, &x38, x36, x30, x30);
    var x39: u64 = undefined;
    var x40: u1 = undefined;
    subborrowxU64(&x39, &x40, 0x0, x31, 0xbfd25e8cd0364141);
    var x41: u64 = undefined;
    var x42: u1 = undefined;
    subborrowxU64(&x41, &x42, x40, x33, 0xbaaedce6af48a03b);
    var x43: u64 = undefined;
    var x44: u1 = undefined;
    subborrowxU64(&x43, &x44, x42, x35, 0xfffffffffffffffe);
    var x45: u64 = undefined;
    var x46: u1 = undefined;
    subborrowxU64(&x45, &x46, x44, x37, 0xffffffffffffffff);
    var x47: u64 = undefined;
    var x48: u1 = undefined;
    subborrowxU64(&x47, &x48, x46, @as(u64, x38), 0x0);
    const x49 = (arg4[3]);
    const x50 = (arg4[2]);
    const x51 = (arg4[1]);
    const x52 = (arg4[0]);
    var x53: u64 = undefined;
    var x54: u1 = undefined;
    subborrowxU64(&x53, &x54, 0x0, 0x0, x52);
    var x55: u64 = undefined;
    var x56: u1 = undefined;
    subborrowxU64(&x55, &x56, x54, 0x0, x51);
    var x57: u64 = undefined;
    var x58: u1 = undefined;
    subborrowxU64(&x57, &x58, x56, 0x0, x50);
    var x59: u64 = undefined;
    var x60: u1 = undefined;
    subborrowxU64(&x59, &x60, x58, 0x0, x49);
    var x61: u64 = undefined;
    cmovznzU64(&x61, x60, 0x0, 0xffffffffffffffff);
    var x62: u64 = undefined;
    var x63: u1 = undefined;
    addcarryxU64(&x62, &x63, 0x0, x53, (x61 & 0xbfd25e8cd0364141));
    var x64: u64 = undefined;
    var x65: u1 = undefined;
    addcarryxU64(&x64, &x65, x63, x55, (x61 & 0xbaaedce6af48a03b));
    var x66: u64 = undefined;
    var x67: u1 = undefined;
    addcarryxU64(&x66, &x67, x65, x57, (x61 & 0xfffffffffffffffe));
    var x68: u64 = undefined;
    var x69: u1 = undefined;
    addcarryxU64(&x68, &x69, x67, x59, x61);
    var x70: u64 = undefined;
    cmovznzU64(&x70, x3, (arg5[0]), x62);
    var x71: u64 = undefined;
    cmovznzU64(&x71, x3, (arg5[1]), x64);
    var x72: u64 = undefined;
    cmovznzU64(&x72, x3, (arg5[2]), x66);
    var x73: u64 = undefined;
    cmovznzU64(&x73, x3, (arg5[3]), x68);
    const x74 = @as(u1, @truncate((x22 & 0x1)));
    var x75: u64 = undefined;
    cmovznzU64(&x75, x74, 0x0, x7);
    var x76: u64 = undefined;
    cmovznzU64(&x76, x74, 0x0, x8);
    var x77: u64 = undefined;
    cmovznzU64(&x77, x74, 0x0, x9);
    var x78: u64 = undefined;
    cmovznzU64(&x78, x74, 0x0, x10);
    var x79: u64 = undefined;
    cmovznzU64(&x79, x74, 0x0, x11);
    var x80: u64 = undefined;
    var x81: u1 = undefined;
    addcarryxU64(&x80, &x81, 0x0, x22, x75);
    var x82: u64 = undefined;
    var x83: u1 = undefined;
    addcarryxU64(&x82, &x83, x81, x23, x76);
    var x84: u64 = undefined;
    var x85: u1 = undefined;
    addcarryxU64(&x84, &x85, x83, x24, x77);
    var x86: u64 = undefined;
    var x87: u1 = undefined;
    addcarryxU64(&x86, &x87, x85, x25, x78);
    var x88: u64 = undefined;
    var x89: u1 = undefined;
    addcarryxU64(&x88, &x89, x87, x26, x79);
    var x90: u64 = undefined;
    cmovznzU64(&x90, x74, 0x0, x27);
    var x91: u64 = undefined;
    cmovznzU64(&x91, x74, 0x0, x28);
    var x92: u64 = undefined;
    cmovznzU64(&x92, x74, 0x0, x29);
    var x93: u64 = undefined;
    cmovznzU64(&x93, x74, 0x0, x30);
    var x94: u64 = undefined;
    var x95: u1 = undefined;
    addcarryxU64(&x94, &x95, 0x0, x70, x90);
    var x96: u64 = undefined;
    var x97: u1 = undefined;
    addcarryxU64(&x96, &x97, x95, x71, x91);
    var x98: u64 = undefined;
    var x99: u1 = undefined;
    addcarryxU64(&x98, &x99, x97, x72, x92);
    var x100: u64 = undefined;
    var x101: u1 = undefined;
    addcarryxU64(&x100, &x101, x99, x73, x93);
    var x102: u64 = undefined;
    var x103: u1 = undefined;
    subborrowxU64(&x102, &x103, 0x0, x94, 0xbfd25e8cd0364141);
    var x104: u64 = undefined;
    var x105: u1 = undefined;
    subborrowxU64(&x104, &x105, x103, x96, 0xbaaedce6af48a03b);
    var x106: u64 = undefined;
    var x107: u1 = undefined;
    subborrowxU64(&x106, &x107, x105, x98, 0xfffffffffffffffe);
    var x108: u64 = undefined;
    var x109: u1 = undefined;
    subborrowxU64(&x108, &x109, x107, x100, 0xffffffffffffffff);
    var x110: u64 = undefined;
    var x111: u1 = undefined;
    subborrowxU64(&x110, &x111, x109, @as(u64, x101), 0x0);
    var x112: u64 = undefined;
    var x113: u1 = undefined;
    addcarryxU64(&x112, &x113, 0x0, x6, 0x1);
    const x114 = ((x80 >> 1) | ((x82 << 63) & 0xffffffffffffffff));
    const x115 = ((x82 >> 1) | ((x84 << 63) & 0xffffffffffffffff));
    const x116 = ((x84 >> 1) | ((x86 << 63) & 0xffffffffffffffff));
    const x117 = ((x86 >> 1) | ((x88 << 63) & 0xffffffffffffffff));
    const x118 = ((x88 & 0x8000000000000000) | (x88 >> 1));
    var x119: u64 = undefined;
    cmovznzU64(&x119, x48, x39, x31);
    var x120: u64 = undefined;
    cmovznzU64(&x120, x48, x41, x33);
    var x121: u64 = undefined;
    cmovznzU64(&x121, x48, x43, x35);
    var x122: u64 = undefined;
    cmovznzU64(&x122, x48, x45, x37);
    var x123: u64 = undefined;
    cmovznzU64(&x123, x111, x102, x94);
    var x124: u64 = undefined;
    cmovznzU64(&x124, x111, x104, x96);
    var x125: u64 = undefined;
    cmovznzU64(&x125, x111, x106, x98);
    var x126: u64 = undefined;
    cmovznzU64(&x126, x111, x108, x100);
    out1.* = x112;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out3[0] = x114;
    out3[1] = x115;
    out3[2] = x116;
    out3[3] = x117;
    out3[4] = x118;
    out4[0] = x119;
    out4[1] = x120;
    out4[2] = x121;
    out4[3] = x122;
    out5[0] = x123;
    out5[1] = x124;
    out5[2] = x125;
    out5[3] = x126;
}

/// The function divstepPrecomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
pub fn divstepPrecomp(out1: *[4]u64) void {
    @setRuntimeSafety(mode == .Debug);

    out1[0] = 0xd7431a4d2b9cb4e9;
    out1[1] = 0xab67d35a32d9c503;
    out1[2] = 0xadf6c7e5859ce35f;
    out1[3] = 0x615441451df6c379;
}
