//! These match the SunOS error numbering scheme.
pub const E = enum(i32) {
    /// No error occurred.
    SUCCESS = 0,

    PERM = 1,
    NOENT = 2,
    SRCH = 3,
    INTR = 4,
    IO = 5,
    NXIO = 6,
    @"2BIG" = 7,
    NOEXEC = 8,
    BADF = 9,
    CHILD = 10,
    /// Also used for WOULDBLOCK
    AGAIN = 11,
    NOMEM = 12,
    ACCES = 13,
    FAULT = 14,
    NOTBLK = 15,
    BUSY = 16,
    EXIST = 17,
    XDEV = 18,
    NODEV = 19,
    NOTDIR = 20,
    ISDIR = 21,
    INVAL = 22,
    NFILE = 23,
    MFILE = 24,
    NOTTY = 25,
    TXTBSY = 26,
    FBIG = 27,
    NOSPC = 28,
    SPIPE = 29,
    ROFS = 30,
    MLINK = 31,
    PIPE = 32,
    DOM = 33,
    RANGE = 34,

    INPROGRESS = 36,
    ALREADY = 37,
    NOTSOCK = 38,
    DESTADDRREQ = 39,
    MSGSIZE = 40,
    PROTOTYPE = 41,
    NOPROTOOPT = 42,
    PROTONOSUPPORT = 43,
    SOCKTNOSUPPORT = 44,
    /// Also used for NOTSUP
    OPNOTSUPP = 45,
    PFNOSUPPORT = 46,
    AFNOSUPPORT = 47,
    ADDRINUSE = 48,
    ADDRNOTAVAIL = 49,
    NETDOWN = 50,
    NETUNREACH = 51,
    NETRESET = 52,
    CONNABORTED = 53,
    CONNRESET = 54,
    NOBUFS = 55,
    ISCONN = 56,
    NOTCONN = 57,
    SHUTDOWN = 58,
    TOOMANYREFS = 59,
    TIMEDOUT = 60,
    CONNREFUSED = 61,
    LOOP = 62,
    NAMETOOLONG = 63,
    HOSTDOWN = 64,
    HOSTUNREACH = 65,
    NOTEMPTY = 66,
    PROCLIM = 67,
    USERS = 68,
    DQUOT = 69,
    STALE = 70,
    REMOTE = 71,
    NOSTR = 72,
    TIME = 73,
    NOSR = 74,
    NOMSG = 75,
    BADMSG = 76,
    IDRM = 77,
    DEADLK = 78,
    NOLCK = 79,
    NONET = 80,
    RREMOTE = 81,
    NOLINK = 82,
    ADV = 83,
    SRMNT = 84,
    COMM = 85,
    PROTO = 86,
    MULTIHOP = 87,
    DOTDOT = 88,
    REMCHG = 89,
    NOSYS = 90,
    STRPIPE = 91,
    OVERFLOW = 92,
    BADFD = 93,
    CHRNG = 94,
    L2NSYNC = 95,
    L3HLT = 96,
    L3RST = 97,
    LNRNG = 98,
    UNATCH = 99,
    NOCSI = 100,
    L2HLT = 101,
    BADE = 102,
    BADR = 103,
    XFULL = 104,
    NOANO = 105,
    BADRQC = 106,
    BADSLT = 107,
    DEADLOCK = 108,
    BFONT = 109,
    LIBEXEC = 110,
    NODATA = 111,
    LIBBAD = 112,
    NOPKG = 113,
    LIBACC = 114,
    NOTUNIQ = 115,
    RESTART = 116,
    UCLEAN = 117,
    NOTNAM = 118,
    NAVAIL = 119,
    ISNAM = 120,
    REMOTEIO = 121,
    ILSEQ = 122,
    LIBMAX = 123,
    LIBSCN = 124,
    NOMEDIUM = 125,
    MEDIUMTYPE = 126,
    CANCELED = 127,
    NOKEY = 128,
    KEYEXPIRED = 129,
    KEYREVOKED = 130,
    KEYREJECTED = 131,
    OWNERDEAD = 132,
    NOTRECOVERABLE = 133,
    RFKILL = 134,
    HWPOISON = 135,
    _,
};
