//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    @"10e60",
    @"2e3",
    @"3e3r1",
    @"3e3r2",
    @"3e3r3",
    @"3e7",
    @"7e10",
    btst16,
    cache,
    ccrt,
    ck801,
    ck802,
    ck803,
    ck803s,
    ck804,
    ck805,
    ck807,
    ck810,
    ck810v,
    ck860,
    ck860v,
    constpool,
    doloop,
    dsp1e2,
    dsp_silan,
    dspe60,
    dspv2,
    e1,
    e2,
    edsp,
    elrw,
    fdivdu,
    float1e2,
    float1e3,
    float3e4,
    float7e60,
    floate1,
    fpuv2_df,
    fpuv2_sf,
    fpuv3_df,
    fpuv3_hf,
    fpuv3_hi,
    fpuv3_sf,
    hard_float,
    hard_float_abi,
    hard_tp,
    high_registers,
    hwdiv,
    istack,
    java,
    mp,
    mp1e2,
    multiple_stld,
    nvic,
    pushpop,
    smart,
    soft_tp,
    stack_size,
    trust,
    vdsp2e3,
    vdsp2e60f,
    vdspv1,
    vdspv2,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.@"10e60")] = .{
        .llvm_name = "10e60",
        .description = "Support CSKY 10e60 instructions",
        .dependencies = featureSet(&[_]Feature{
            .@"7e10",
        }),
    };
    result[@intFromEnum(Feature.@"2e3")] = .{
        .llvm_name = "2e3",
        .description = "Support CSKY 2e3 instructions",
        .dependencies = featureSet(&[_]Feature{
            .e2,
        }),
    };
    result[@intFromEnum(Feature.@"3e3r1")] = .{
        .llvm_name = "3e3r1",
        .description = "Support CSKY 3e3r1 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.@"3e3r2")] = .{
        .llvm_name = "3e3r2",
        .description = "Support CSKY 3e3r2 instructions",
        .dependencies = featureSet(&[_]Feature{
            .@"3e3r1",
            .doloop,
        }),
    };
    result[@intFromEnum(Feature.@"3e3r3")] = .{
        .llvm_name = "3e3r3",
        .description = "Support CSKY 3e3r3 instructions",
        .dependencies = featureSet(&[_]Feature{
            .doloop,
        }),
    };
    result[@intFromEnum(Feature.@"3e7")] = .{
        .llvm_name = "3e7",
        .description = "Support CSKY 3e7 instructions",
        .dependencies = featureSet(&[_]Feature{
            .@"2e3",
        }),
    };
    result[@intFromEnum(Feature.@"7e10")] = .{
        .llvm_name = "7e10",
        .description = "Support CSKY 7e10 instructions",
        .dependencies = featureSet(&[_]Feature{
            .@"3e7",
        }),
    };
    result[@intFromEnum(Feature.btst16)] = .{
        .llvm_name = "btst16",
        .description = "Use the 16-bit btsti instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.cache)] = .{
        .llvm_name = "cache",
        .description = "Enable cache",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ccrt)] = .{
        .llvm_name = "ccrt",
        .description = "Use CSKY compiler runtime",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck801)] = .{
        .llvm_name = "ck801",
        .description = "CSKY ck801 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck802)] = .{
        .llvm_name = "ck802",
        .description = "CSKY ck802 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck803)] = .{
        .llvm_name = "ck803",
        .description = "CSKY ck803 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck803s)] = .{
        .llvm_name = "ck803s",
        .description = "CSKY ck803s processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck804)] = .{
        .llvm_name = "ck804",
        .description = "CSKY ck804 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck805)] = .{
        .llvm_name = "ck805",
        .description = "CSKY ck805 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck807)] = .{
        .llvm_name = "ck807",
        .description = "CSKY ck807 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck810)] = .{
        .llvm_name = "ck810",
        .description = "CSKY ck810 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck810v)] = .{
        .llvm_name = "ck810v",
        .description = "CSKY ck810v processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck860)] = .{
        .llvm_name = "ck860",
        .description = "CSKY ck860 processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ck860v)] = .{
        .llvm_name = "ck860v",
        .description = "CSKY ck860v processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.constpool)] = .{
        .llvm_name = "constpool",
        .description = "Dump the constant pool by compiler",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.doloop)] = .{
        .llvm_name = "doloop",
        .description = "Enable doloop instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.dsp1e2)] = .{
        .llvm_name = "dsp1e2",
        .description = "Support CSKY dsp1e2 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.dsp_silan)] = .{
        .llvm_name = "dsp_silan",
        .description = "Enable DSP Silan instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.dspe60)] = .{
        .llvm_name = "dspe60",
        .description = "Support CSKY dspe60 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.dspv2)] = .{
        .llvm_name = "dspv2",
        .description = "Enable DSP V2.0 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.e1)] = .{
        .llvm_name = "e1",
        .description = "Support CSKY e1 instructions",
        .dependencies = featureSet(&[_]Feature{
            .elrw,
        }),
    };
    result[@intFromEnum(Feature.e2)] = .{
        .llvm_name = "e2",
        .description = "Support CSKY e2 instructions",
        .dependencies = featureSet(&[_]Feature{
            .e1,
        }),
    };
    result[@intFromEnum(Feature.edsp)] = .{
        .llvm_name = "edsp",
        .description = "Enable DSP instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.elrw)] = .{
        .llvm_name = "elrw",
        .description = "Use the extend LRW instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fdivdu)] = .{
        .llvm_name = "fdivdu",
        .description = "Enable float divide instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.float1e2)] = .{
        .llvm_name = "float1e2",
        .description = "Support CSKY float1e2 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.float1e3)] = .{
        .llvm_name = "float1e3",
        .description = "Support CSKY float1e3 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.float3e4)] = .{
        .llvm_name = "float3e4",
        .description = "Support CSKY float3e4 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.float7e60)] = .{
        .llvm_name = "float7e60",
        .description = "Support CSKY float7e60 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.floate1)] = .{
        .llvm_name = "floate1",
        .description = "Support CSKY floate1 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fpuv2_df)] = .{
        .llvm_name = "fpuv2_df",
        .description = "Enable FPUv2 double float instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fpuv2_sf)] = .{
        .llvm_name = "fpuv2_sf",
        .description = "Enable FPUv2 single float instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fpuv3_df)] = .{
        .llvm_name = "fpuv3_df",
        .description = "Enable FPUv3 double float instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fpuv3_hf)] = .{
        .llvm_name = "fpuv3_hf",
        .description = "Enable FPUv3 half precision operate instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fpuv3_hi)] = .{
        .llvm_name = "fpuv3_hi",
        .description = "Enable FPUv3 half word converting instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fpuv3_sf)] = .{
        .llvm_name = "fpuv3_sf",
        .description = "Enable FPUv3 single float instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.hard_float)] = .{
        .llvm_name = "hard-float",
        .description = "Use hard floating point features",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.hard_float_abi)] = .{
        .llvm_name = "hard-float-abi",
        .description = "Use hard floating point ABI to pass args",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.hard_tp)] = .{
        .llvm_name = "hard-tp",
        .description = "Enable TLS Pointer register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.high_registers)] = .{
        .llvm_name = "high-registers",
        .description = "Enable r16-r31 registers",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.hwdiv)] = .{
        .llvm_name = "hwdiv",
        .description = "Enable divide instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.istack)] = .{
        .llvm_name = "istack",
        .description = "Enable interrupt attribute",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.java)] = .{
        .llvm_name = "java",
        .description = "Enable java instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.mp)] = .{
        .llvm_name = "mp",
        .description = "Support CSKY mp instructions",
        .dependencies = featureSet(&[_]Feature{
            .@"2e3",
        }),
    };
    result[@intFromEnum(Feature.mp1e2)] = .{
        .llvm_name = "mp1e2",
        .description = "Support CSKY mp1e2 instructions",
        .dependencies = featureSet(&[_]Feature{
            .@"3e7",
        }),
    };
    result[@intFromEnum(Feature.multiple_stld)] = .{
        .llvm_name = "multiple_stld",
        .description = "Enable multiple load/store instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.nvic)] = .{
        .llvm_name = "nvic",
        .description = "Enable NVIC",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.pushpop)] = .{
        .llvm_name = "pushpop",
        .description = "Enable push/pop instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smart)] = .{
        .llvm_name = "smart",
        .description = "Let CPU work in Smart Mode",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.soft_tp)] = .{
        .llvm_name = "soft-tp",
        .description = "Disable TLS Pointer register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.stack_size)] = .{
        .llvm_name = "stack-size",
        .description = "Output stack size information",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.trust)] = .{
        .llvm_name = "trust",
        .description = "Enable trust instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.vdsp2e3)] = .{
        .llvm_name = "vdsp2e3",
        .description = "Support CSKY vdsp2e3 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.vdsp2e60f)] = .{
        .llvm_name = "vdsp2e60f",
        .description = "Support CSKY vdsp2e60f instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.vdspv1)] = .{
        .llvm_name = "vdspv1",
        .description = "Enable 128bit vdsp-v1 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.vdspv2)] = .{
        .llvm_name = "vdspv2",
        .description = "Enable vdsp-v2 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const c807 = CpuModel{
        .name = "c807",
        .llvm_name = "c807",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const c807f = CpuModel{
        .name = "c807f",
        .llvm_name = "c807f",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .float1e3,
            .float3e4,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const c810 = CpuModel{
        .name = "c810",
        .llvm_name = "c810",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const c810t = CpuModel{
        .name = "c810t",
        .llvm_name = "c810t",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const c810tv = CpuModel{
        .name = "c810tv",
        .llvm_name = "c810tv",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const c810v = CpuModel{
        .name = "c810v",
        .llvm_name = "c810v",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const c860 = CpuModel{
        .name = "c860",
        .llvm_name = "c860",
        .features = featureSet(&[_]Feature{
            .@"10e60",
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .cache,
            .ck860,
            .dspe60,
            .float7e60,
            .fpuv3_df,
            .fpuv3_hf,
            .fpuv3_hi,
            .fpuv3_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const c860v = CpuModel{
        .name = "c860v",
        .llvm_name = "c860v",
        .features = featureSet(&[_]Feature{
            .@"10e60",
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .cache,
            .ck860,
            .ck860v,
            .dspe60,
            .float7e60,
            .fpuv3_df,
            .fpuv3_hf,
            .fpuv3_hi,
            .fpuv3_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdsp2e60f,
            .vdspv2,
        }),
    };
    pub const ck801 = CpuModel{
        .name = "ck801",
        .llvm_name = "ck801",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck801,
            .e1,
            .trust,
        }),
    };
    pub const ck801t = CpuModel{
        .name = "ck801t",
        .llvm_name = "ck801t",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck801,
            .e1,
            .trust,
        }),
    };
    pub const ck802 = CpuModel{
        .name = "ck802",
        .llvm_name = "ck802",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck802,
            .e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck802j = CpuModel{
        .name = "ck802j",
        .llvm_name = "ck802j",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck802,
            .e2,
            .java,
            .nvic,
            .trust,
        }),
    };
    pub const ck802t = CpuModel{
        .name = "ck802t",
        .llvm_name = "ck802t",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck802,
            .e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck803 = CpuModel{
        .name = "ck803",
        .llvm_name = "ck803",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803e = CpuModel{
        .name = "ck803e",
        .llvm_name = "ck803e",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ef = CpuModel{
        .name = "ck803ef",
        .llvm_name = "ck803ef",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efh = CpuModel{
        .name = "ck803efh",
        .llvm_name = "ck803efh",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efhr1 = CpuModel{
        .name = "ck803efhr1",
        .llvm_name = "ck803efhr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efhr2 = CpuModel{
        .name = "ck803efhr2",
        .llvm_name = "ck803efhr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efhr3 = CpuModel{
        .name = "ck803efhr3",
        .llvm_name = "ck803efhr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efht = CpuModel{
        .name = "ck803efht",
        .llvm_name = "ck803efht",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efhtr1 = CpuModel{
        .name = "ck803efhtr1",
        .llvm_name = "ck803efhtr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efhtr2 = CpuModel{
        .name = "ck803efhtr2",
        .llvm_name = "ck803efhtr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efhtr3 = CpuModel{
        .name = "ck803efhtr3",
        .llvm_name = "ck803efhtr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efr1 = CpuModel{
        .name = "ck803efr1",
        .llvm_name = "ck803efr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efr2 = CpuModel{
        .name = "ck803efr2",
        .llvm_name = "ck803efr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803efr3 = CpuModel{
        .name = "ck803efr3",
        .llvm_name = "ck803efr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803eft = CpuModel{
        .name = "ck803eft",
        .llvm_name = "ck803eft",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803eftr1 = CpuModel{
        .name = "ck803eftr1",
        .llvm_name = "ck803eftr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803eftr2 = CpuModel{
        .name = "ck803eftr2",
        .llvm_name = "ck803eftr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803eftr3 = CpuModel{
        .name = "ck803eftr3",
        .llvm_name = "ck803eftr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803eh = CpuModel{
        .name = "ck803eh",
        .llvm_name = "ck803eh",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ehr1 = CpuModel{
        .name = "ck803ehr1",
        .llvm_name = "ck803ehr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ehr2 = CpuModel{
        .name = "ck803ehr2",
        .llvm_name = "ck803ehr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ehr3 = CpuModel{
        .name = "ck803ehr3",
        .llvm_name = "ck803ehr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803eht = CpuModel{
        .name = "ck803eht",
        .llvm_name = "ck803eht",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ehtr1 = CpuModel{
        .name = "ck803ehtr1",
        .llvm_name = "ck803ehtr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ehtr2 = CpuModel{
        .name = "ck803ehtr2",
        .llvm_name = "ck803ehtr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ehtr3 = CpuModel{
        .name = "ck803ehtr3",
        .llvm_name = "ck803ehtr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803er1 = CpuModel{
        .name = "ck803er1",
        .llvm_name = "ck803er1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803er2 = CpuModel{
        .name = "ck803er2",
        .llvm_name = "ck803er2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803er3 = CpuModel{
        .name = "ck803er3",
        .llvm_name = "ck803er3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803et = CpuModel{
        .name = "ck803et",
        .llvm_name = "ck803et",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803etr1 = CpuModel{
        .name = "ck803etr1",
        .llvm_name = "ck803etr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803etr2 = CpuModel{
        .name = "ck803etr2",
        .llvm_name = "ck803etr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803etr3 = CpuModel{
        .name = "ck803etr3",
        .llvm_name = "ck803etr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dsp1e2,
            .dspe60,
            .dspv2,
            .edsp,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803f = CpuModel{
        .name = "ck803f",
        .llvm_name = "ck803f",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803fh = CpuModel{
        .name = "ck803fh",
        .llvm_name = "ck803fh",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803fhr1 = CpuModel{
        .name = "ck803fhr1",
        .llvm_name = "ck803fhr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803fhr2 = CpuModel{
        .name = "ck803fhr2",
        .llvm_name = "ck803fhr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803fhr3 = CpuModel{
        .name = "ck803fhr3",
        .llvm_name = "ck803fhr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803fr1 = CpuModel{
        .name = "ck803fr1",
        .llvm_name = "ck803fr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803fr2 = CpuModel{
        .name = "ck803fr2",
        .llvm_name = "ck803fr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803fr3 = CpuModel{
        .name = "ck803fr3",
        .llvm_name = "ck803fr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ft = CpuModel{
        .name = "ck803ft",
        .llvm_name = "ck803ft",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ftr1 = CpuModel{
        .name = "ck803ftr1",
        .llvm_name = "ck803ftr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ftr2 = CpuModel{
        .name = "ck803ftr2",
        .llvm_name = "ck803ftr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ftr3 = CpuModel{
        .name = "ck803ftr3",
        .llvm_name = "ck803ftr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803h = CpuModel{
        .name = "ck803h",
        .llvm_name = "ck803h",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803hr1 = CpuModel{
        .name = "ck803hr1",
        .llvm_name = "ck803hr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803hr2 = CpuModel{
        .name = "ck803hr2",
        .llvm_name = "ck803hr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803hr3 = CpuModel{
        .name = "ck803hr3",
        .llvm_name = "ck803hr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803ht = CpuModel{
        .name = "ck803ht",
        .llvm_name = "ck803ht",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803htr1 = CpuModel{
        .name = "ck803htr1",
        .llvm_name = "ck803htr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803htr2 = CpuModel{
        .name = "ck803htr2",
        .llvm_name = "ck803htr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803htr3 = CpuModel{
        .name = "ck803htr3",
        .llvm_name = "ck803htr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803r1 = CpuModel{
        .name = "ck803r1",
        .llvm_name = "ck803r1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803r2 = CpuModel{
        .name = "ck803r2",
        .llvm_name = "ck803r2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803r3 = CpuModel{
        .name = "ck803r3",
        .llvm_name = "ck803r3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803s = CpuModel{
        .name = "ck803s",
        .llvm_name = "ck803s",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803se = CpuModel{
        .name = "ck803se",
        .llvm_name = "ck803se",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803sef = CpuModel{
        .name = "ck803sef",
        .llvm_name = "ck803sef",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp1e2,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803sefn = CpuModel{
        .name = "ck803sefn",
        .llvm_name = "ck803sefn",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp1e2,
            .dsp_silan,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803sefnt = CpuModel{
        .name = "ck803sefnt",
        .llvm_name = "ck803sefnt",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp1e2,
            .dsp_silan,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803seft = CpuModel{
        .name = "ck803seft",
        .llvm_name = "ck803seft",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp1e2,
            .dspe60,
            .edsp,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803sen = CpuModel{
        .name = "ck803sen",
        .llvm_name = "ck803sen",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp1e2,
            .dsp_silan,
            .dspe60,
            .edsp,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803sf = CpuModel{
        .name = "ck803sf",
        .llvm_name = "ck803sf",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803sfn = CpuModel{
        .name = "ck803sfn",
        .llvm_name = "ck803sfn",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp_silan,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803sn = CpuModel{
        .name = "ck803sn",
        .llvm_name = "ck803sn",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp_silan,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803snt = CpuModel{
        .name = "ck803snt",
        .llvm_name = "ck803snt",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .dsp_silan,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803st = CpuModel{
        .name = "ck803st",
        .llvm_name = "ck803st",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .btst16,
            .ck803,
            .ck803s,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803t = CpuModel{
        .name = "ck803t",
        .llvm_name = "ck803t",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803tr1 = CpuModel{
        .name = "ck803tr1",
        .llvm_name = "ck803tr1",
        .features = featureSet(&[_]Feature{
            .@"3e3r1",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803tr2 = CpuModel{
        .name = "ck803tr2",
        .llvm_name = "ck803tr2",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck803tr3 = CpuModel{
        .name = "ck803tr3",
        .llvm_name = "ck803tr3",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .dspv2,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804 = CpuModel{
        .name = "ck804",
        .llvm_name = "ck804",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804e = CpuModel{
        .name = "ck804e",
        .llvm_name = "ck804e",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804ef = CpuModel{
        .name = "ck804ef",
        .llvm_name = "ck804ef",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804efh = CpuModel{
        .name = "ck804efh",
        .llvm_name = "ck804efh",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804efht = CpuModel{
        .name = "ck804efht",
        .llvm_name = "ck804efht",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804eft = CpuModel{
        .name = "ck804eft",
        .llvm_name = "ck804eft",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804eh = CpuModel{
        .name = "ck804eh",
        .llvm_name = "ck804eh",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804eht = CpuModel{
        .name = "ck804eht",
        .llvm_name = "ck804eht",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804et = CpuModel{
        .name = "ck804et",
        .llvm_name = "ck804et",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804f = CpuModel{
        .name = "ck804f",
        .llvm_name = "ck804f",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804fh = CpuModel{
        .name = "ck804fh",
        .llvm_name = "ck804fh",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804ft = CpuModel{
        .name = "ck804ft",
        .llvm_name = "ck804ft",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804h = CpuModel{
        .name = "ck804h",
        .llvm_name = "ck804h",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804ht = CpuModel{
        .name = "ck804ht",
        .llvm_name = "ck804ht",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck804t = CpuModel{
        .name = "ck804t",
        .llvm_name = "ck804t",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const ck805 = CpuModel{
        .name = "ck805",
        .llvm_name = "ck805",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck805e = CpuModel{
        .name = "ck805e",
        .llvm_name = "ck805e",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck805ef = CpuModel{
        .name = "ck805ef",
        .llvm_name = "ck805ef",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck805eft = CpuModel{
        .name = "ck805eft",
        .llvm_name = "ck805eft",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck805et = CpuModel{
        .name = "ck805et",
        .llvm_name = "ck805et",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck805f = CpuModel{
        .name = "ck805f",
        .llvm_name = "ck805f",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck805ft = CpuModel{
        .name = "ck805ft",
        .llvm_name = "ck805ft",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck805t = CpuModel{
        .name = "ck805t",
        .llvm_name = "ck805t",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const ck807 = CpuModel{
        .name = "ck807",
        .llvm_name = "ck807",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck807e = CpuModel{
        .name = "ck807e",
        .llvm_name = "ck807e",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck807ef = CpuModel{
        .name = "ck807ef",
        .llvm_name = "ck807ef",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .float1e3,
            .float3e4,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck807f = CpuModel{
        .name = "ck807f",
        .llvm_name = "ck807f",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .float1e3,
            .float3e4,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810 = CpuModel{
        .name = "ck810",
        .llvm_name = "ck810",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810e = CpuModel{
        .name = "ck810e",
        .llvm_name = "ck810e",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810ef = CpuModel{
        .name = "ck810ef",
        .llvm_name = "ck810ef",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810eft = CpuModel{
        .name = "ck810eft",
        .llvm_name = "ck810eft",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810eftv = CpuModel{
        .name = "ck810eftv",
        .llvm_name = "ck810eftv",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck810efv = CpuModel{
        .name = "ck810efv",
        .llvm_name = "ck810efv",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck810et = CpuModel{
        .name = "ck810et",
        .llvm_name = "ck810et",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810etv = CpuModel{
        .name = "ck810etv",
        .llvm_name = "ck810etv",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck810ev = CpuModel{
        .name = "ck810ev",
        .llvm_name = "ck810ev",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck810f = CpuModel{
        .name = "ck810f",
        .llvm_name = "ck810f",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810ft = CpuModel{
        .name = "ck810ft",
        .llvm_name = "ck810ft",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810ftv = CpuModel{
        .name = "ck810ftv",
        .llvm_name = "ck810ftv",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck810fv = CpuModel{
        .name = "ck810fv",
        .llvm_name = "ck810fv",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck810t = CpuModel{
        .name = "ck810t",
        .llvm_name = "ck810t",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck810tv = CpuModel{
        .name = "ck810tv",
        .llvm_name = "ck810tv",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck810v = CpuModel{
        .name = "ck810v",
        .llvm_name = "ck810v",
        .features = featureSet(&[_]Feature{
            .@"7e10",
            .cache,
            .ck810,
            .ck810v,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdspv1,
        }),
    };
    pub const ck860 = CpuModel{
        .name = "ck860",
        .llvm_name = "ck860",
        .features = featureSet(&[_]Feature{
            .@"10e60",
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .cache,
            .ck860,
            .dspe60,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck860f = CpuModel{
        .name = "ck860f",
        .llvm_name = "ck860f",
        .features = featureSet(&[_]Feature{
            .@"10e60",
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .cache,
            .ck860,
            .dspe60,
            .float7e60,
            .fpuv3_df,
            .fpuv3_hf,
            .fpuv3_hi,
            .fpuv3_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const ck860fv = CpuModel{
        .name = "ck860fv",
        .llvm_name = "ck860fv",
        .features = featureSet(&[_]Feature{
            .@"10e60",
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .cache,
            .ck860,
            .ck860v,
            .dspe60,
            .float7e60,
            .fpuv3_df,
            .fpuv3_hf,
            .fpuv3_hi,
            .fpuv3_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdsp2e60f,
            .vdspv2,
        }),
    };
    pub const ck860v = CpuModel{
        .name = "ck860v",
        .llvm_name = "ck860v",
        .features = featureSet(&[_]Feature{
            .@"10e60",
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .cache,
            .ck860,
            .ck860v,
            .dspe60,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
            .vdsp2e60f,
            .vdspv2,
        }),
    };
    pub const e801 = CpuModel{
        .name = "e801",
        .llvm_name = "e801",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck801,
            .e1,
            .trust,
        }),
    };
    pub const e802 = CpuModel{
        .name = "e802",
        .llvm_name = "e802",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck802,
            .e2,
            .nvic,
            .trust,
        }),
    };
    pub const e802t = CpuModel{
        .name = "e802t",
        .llvm_name = "e802t",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck802,
            .e2,
            .nvic,
            .trust,
        }),
    };
    pub const e803 = CpuModel{
        .name = "e803",
        .llvm_name = "e803",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const e803t = CpuModel{
        .name = "e803t",
        .llvm_name = "e803t",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const e804d = CpuModel{
        .name = "e804d",
        .llvm_name = "e804d",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const e804df = CpuModel{
        .name = "e804df",
        .llvm_name = "e804df",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const e804dft = CpuModel{
        .name = "e804dft",
        .llvm_name = "e804dft",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const e804dt = CpuModel{
        .name = "e804dt",
        .llvm_name = "e804dt",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .dspv2,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const e804f = CpuModel{
        .name = "e804f",
        .llvm_name = "e804f",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const e804ft = CpuModel{
        .name = "e804ft",
        .llvm_name = "e804ft",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck804,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const generic = CpuModel{
        .name = "generic",
        .llvm_name = "generic",
        .features = featureSet(&[_]Feature{
            .btst16,
        }),
    };
    pub const @"i805" = CpuModel{
        .name = "i805",
        .llvm_name = "i805",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const i805f = CpuModel{
        .name = "i805f",
        .llvm_name = "i805f",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .ck805,
            .float1e3,
            .floate1,
            .fpuv2_sf,
            .high_registers,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
            .vdsp2e3,
            .vdspv2,
        }),
    };
    pub const r807 = CpuModel{
        .name = "r807",
        .llvm_name = "r807",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const r807f = CpuModel{
        .name = "r807f",
        .llvm_name = "r807f",
        .features = featureSet(&[_]Feature{
            .cache,
            .ck807,
            .dsp1e2,
            .dspe60,
            .edsp,
            .fdivdu,
            .float1e2,
            .float1e3,
            .float3e4,
            .floate1,
            .fpuv2_df,
            .fpuv2_sf,
            .hard_tp,
            .high_registers,
            .hwdiv,
            .mp,
            .mp1e2,
            .nvic,
            .trust,
        }),
    };
    pub const s802 = CpuModel{
        .name = "s802",
        .llvm_name = "s802",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck802,
            .e2,
            .nvic,
            .trust,
        }),
    };
    pub const s802t = CpuModel{
        .name = "s802t",
        .llvm_name = "s802t",
        .features = featureSet(&[_]Feature{
            .btst16,
            .ck802,
            .e2,
            .nvic,
            .trust,
        }),
    };
    pub const s803 = CpuModel{
        .name = "s803",
        .llvm_name = "s803",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
    pub const s803t = CpuModel{
        .name = "s803t",
        .llvm_name = "s803t",
        .features = featureSet(&[_]Feature{
            .@"3e3r2",
            .@"3e3r3",
            .btst16,
            .ck803,
            .hwdiv,
            .mp,
            .nvic,
            .trust,
        }),
    };
};
