// This file is automatically generated.
// See tools/generate_linux_syscalls.zig for more info.

pub const X86 = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    waitpid = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    time = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    @"break" = 17,
    oldstat = 18,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    setuid = 23,
    getuid = 24,
    stime = 25,
    ptrace = 26,
    alarm = 27,
    oldfstat = 28,
    pause = 29,
    utime = 30,
    stty = 31,
    gtty = 32,
    access = 33,
    nice = 34,
    ftime = 35,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    prof = 44,
    brk = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    lock = 53,
    ioctl = 54,
    fcntl = 55,
    mpx = 56,
    setpgid = 57,
    ulimit = 58,
    oldolduname = 59,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sgetmask = 68,
    ssetmask = 69,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrlimit = 76,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    select = 82,
    symlink = 83,
    oldlstat = 84,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    profil = 98,
    statfs = 99,
    fstatfs = 100,
    ioperm = 101,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    olduname = 109,
    iopl = 110,
    vhangup = 111,
    idle = 112,
    vm86old = 113,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    modify_ldt = 123,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    afs_syscall = 137,
    setfsuid = 138,
    setfsgid = 139,
    llseek = 140,
    getdents = 141,
    newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    vm86 = 166,
    query_module = 167,
    poll = 168,
    nfsservctl = 169,
    setresgid = 170,
    getresgid = 171,
    prctl = 172,
    rt_sigreturn = 173,
    rt_sigaction = 174,
    rt_sigprocmask = 175,
    rt_sigpending = 176,
    rt_sigtimedwait = 177,
    rt_sigqueueinfo = 178,
    rt_sigsuspend = 179,
    pread64 = 180,
    pwrite64 = 181,
    chown = 182,
    getcwd = 183,
    capget = 184,
    capset = 185,
    sigaltstack = 186,
    sendfile = 187,
    getpmsg = 188,
    putpmsg = 189,
    vfork = 190,
    ugetrlimit = 191,
    mmap2 = 192,
    truncate64 = 193,
    ftruncate64 = 194,
    stat64 = 195,
    lstat64 = 196,
    fstat64 = 197,
    lchown32 = 198,
    getuid32 = 199,
    getgid32 = 200,
    geteuid32 = 201,
    getegid32 = 202,
    setreuid32 = 203,
    setregid32 = 204,
    getgroups32 = 205,
    setgroups32 = 206,
    fchown32 = 207,
    setresuid32 = 208,
    getresuid32 = 209,
    setresgid32 = 210,
    getresgid32 = 211,
    chown32 = 212,
    setuid32 = 213,
    setgid32 = 214,
    setfsuid32 = 215,
    setfsgid32 = 216,
    pivot_root = 217,
    mincore = 218,
    madvise = 219,
    getdents64 = 220,
    fcntl64 = 221,
    gettid = 224,
    readahead = 225,
    setxattr = 226,
    lsetxattr = 227,
    fsetxattr = 228,
    getxattr = 229,
    lgetxattr = 230,
    fgetxattr = 231,
    listxattr = 232,
    llistxattr = 233,
    flistxattr = 234,
    removexattr = 235,
    lremovexattr = 236,
    fremovexattr = 237,
    tkill = 238,
    sendfile64 = 239,
    futex = 240,
    sched_setaffinity = 241,
    sched_getaffinity = 242,
    set_thread_area = 243,
    get_thread_area = 244,
    io_setup = 245,
    io_destroy = 246,
    io_getevents = 247,
    io_submit = 248,
    io_cancel = 249,
    fadvise64 = 250,
    exit_group = 252,
    lookup_dcookie = 253,
    epoll_create = 254,
    epoll_ctl = 255,
    epoll_wait = 256,
    remap_file_pages = 257,
    set_tid_address = 258,
    timer_create = 259,
    timer_settime = 260,
    timer_gettime = 261,
    timer_getoverrun = 262,
    timer_delete = 263,
    clock_settime = 264,
    clock_gettime = 265,
    clock_getres = 266,
    clock_nanosleep = 267,
    statfs64 = 268,
    fstatfs64 = 269,
    tgkill = 270,
    utimes = 271,
    fadvise64_64 = 272,
    vserver = 273,
    mbind = 274,
    get_mempolicy = 275,
    set_mempolicy = 276,
    mq_open = 277,
    mq_unlink = 278,
    mq_timedsend = 279,
    mq_timedreceive = 280,
    mq_notify = 281,
    mq_getsetattr = 282,
    kexec_load = 283,
    waitid = 284,
    add_key = 286,
    request_key = 287,
    keyctl = 288,
    ioprio_set = 289,
    ioprio_get = 290,
    inotify_init = 291,
    inotify_add_watch = 292,
    inotify_rm_watch = 293,
    migrate_pages = 294,
    openat = 295,
    mkdirat = 296,
    mknodat = 297,
    fchownat = 298,
    futimesat = 299,
    fstatat64 = 300,
    unlinkat = 301,
    renameat = 302,
    linkat = 303,
    symlinkat = 304,
    readlinkat = 305,
    fchmodat = 306,
    faccessat = 307,
    pselect6 = 308,
    ppoll = 309,
    unshare = 310,
    set_robust_list = 311,
    get_robust_list = 312,
    splice = 313,
    sync_file_range = 314,
    tee = 315,
    vmsplice = 316,
    move_pages = 317,
    getcpu = 318,
    epoll_pwait = 319,
    utimensat = 320,
    signalfd = 321,
    timerfd_create = 322,
    eventfd = 323,
    fallocate = 324,
    timerfd_settime = 325,
    timerfd_gettime = 326,
    signalfd4 = 327,
    eventfd2 = 328,
    epoll_create1 = 329,
    dup3 = 330,
    pipe2 = 331,
    inotify_init1 = 332,
    preadv = 333,
    pwritev = 334,
    rt_tgsigqueueinfo = 335,
    perf_event_open = 336,
    recvmmsg = 337,
    fanotify_init = 338,
    fanotify_mark = 339,
    prlimit64 = 340,
    name_to_handle_at = 341,
    open_by_handle_at = 342,
    clock_adjtime = 343,
    syncfs = 344,
    sendmmsg = 345,
    setns = 346,
    process_vm_readv = 347,
    process_vm_writev = 348,
    kcmp = 349,
    finit_module = 350,
    sched_setattr = 351,
    sched_getattr = 352,
    renameat2 = 353,
    seccomp = 354,
    getrandom = 355,
    memfd_create = 356,
    bpf = 357,
    execveat = 358,
    socket = 359,
    socketpair = 360,
    bind = 361,
    connect = 362,
    listen = 363,
    accept4 = 364,
    getsockopt = 365,
    setsockopt = 366,
    getsockname = 367,
    getpeername = 368,
    sendto = 369,
    sendmsg = 370,
    recvfrom = 371,
    recvmsg = 372,
    shutdown = 373,
    userfaultfd = 374,
    membarrier = 375,
    mlock2 = 376,
    copy_file_range = 377,
    preadv2 = 378,
    pwritev2 = 379,
    pkey_mprotect = 380,
    pkey_alloc = 381,
    pkey_free = 382,
    statx = 383,
    arch_prctl = 384,
    io_pgetevents = 385,
    rseq = 386,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const X64 = enum(usize) {
    read = 0,
    write = 1,
    open = 2,
    close = 3,
    stat = 4,
    fstat = 5,
    lstat = 6,
    poll = 7,
    lseek = 8,
    mmap = 9,
    mprotect = 10,
    munmap = 11,
    brk = 12,
    rt_sigaction = 13,
    rt_sigprocmask = 14,
    rt_sigreturn = 15,
    ioctl = 16,
    pread64 = 17,
    pwrite64 = 18,
    readv = 19,
    writev = 20,
    access = 21,
    pipe = 22,
    select = 23,
    sched_yield = 24,
    mremap = 25,
    msync = 26,
    mincore = 27,
    madvise = 28,
    shmget = 29,
    shmat = 30,
    shmctl = 31,
    dup = 32,
    dup2 = 33,
    pause = 34,
    nanosleep = 35,
    getitimer = 36,
    alarm = 37,
    setitimer = 38,
    getpid = 39,
    sendfile = 40,
    socket = 41,
    connect = 42,
    accept = 43,
    sendto = 44,
    recvfrom = 45,
    sendmsg = 46,
    recvmsg = 47,
    shutdown = 48,
    bind = 49,
    listen = 50,
    getsockname = 51,
    getpeername = 52,
    socketpair = 53,
    setsockopt = 54,
    getsockopt = 55,
    clone = 56,
    fork = 57,
    vfork = 58,
    execve = 59,
    exit = 60,
    wait4 = 61,
    kill = 62,
    uname = 63,
    semget = 64,
    semop = 65,
    semctl = 66,
    shmdt = 67,
    msgget = 68,
    msgsnd = 69,
    msgrcv = 70,
    msgctl = 71,
    fcntl = 72,
    flock = 73,
    fsync = 74,
    fdatasync = 75,
    truncate = 76,
    ftruncate = 77,
    getdents = 78,
    getcwd = 79,
    chdir = 80,
    fchdir = 81,
    rename = 82,
    mkdir = 83,
    rmdir = 84,
    creat = 85,
    link = 86,
    unlink = 87,
    symlink = 88,
    readlink = 89,
    chmod = 90,
    fchmod = 91,
    chown = 92,
    fchown = 93,
    lchown = 94,
    umask = 95,
    gettimeofday = 96,
    getrlimit = 97,
    getrusage = 98,
    sysinfo = 99,
    times = 100,
    ptrace = 101,
    getuid = 102,
    syslog = 103,
    getgid = 104,
    setuid = 105,
    setgid = 106,
    geteuid = 107,
    getegid = 108,
    setpgid = 109,
    getppid = 110,
    getpgrp = 111,
    setsid = 112,
    setreuid = 113,
    setregid = 114,
    getgroups = 115,
    setgroups = 116,
    setresuid = 117,
    getresuid = 118,
    setresgid = 119,
    getresgid = 120,
    getpgid = 121,
    setfsuid = 122,
    setfsgid = 123,
    getsid = 124,
    capget = 125,
    capset = 126,
    rt_sigpending = 127,
    rt_sigtimedwait = 128,
    rt_sigqueueinfo = 129,
    rt_sigsuspend = 130,
    sigaltstack = 131,
    utime = 132,
    mknod = 133,
    uselib = 134,
    personality = 135,
    ustat = 136,
    statfs = 137,
    fstatfs = 138,
    sysfs = 139,
    getpriority = 140,
    setpriority = 141,
    sched_setparam = 142,
    sched_getparam = 143,
    sched_setscheduler = 144,
    sched_getscheduler = 145,
    sched_get_priority_max = 146,
    sched_get_priority_min = 147,
    sched_rr_get_interval = 148,
    mlock = 149,
    munlock = 150,
    mlockall = 151,
    munlockall = 152,
    vhangup = 153,
    modify_ldt = 154,
    pivot_root = 155,
    sysctl = 156,
    prctl = 157,
    arch_prctl = 158,
    adjtimex = 159,
    setrlimit = 160,
    chroot = 161,
    sync = 162,
    acct = 163,
    settimeofday = 164,
    mount = 165,
    umount2 = 166,
    swapon = 167,
    swapoff = 168,
    reboot = 169,
    sethostname = 170,
    setdomainname = 171,
    iopl = 172,
    ioperm = 173,
    create_module = 174,
    init_module = 175,
    delete_module = 176,
    get_kernel_syms = 177,
    query_module = 178,
    quotactl = 179,
    nfsservctl = 180,
    getpmsg = 181,
    putpmsg = 182,
    afs_syscall = 183,
    tuxcall = 184,
    security = 185,
    gettid = 186,
    readahead = 187,
    setxattr = 188,
    lsetxattr = 189,
    fsetxattr = 190,
    getxattr = 191,
    lgetxattr = 192,
    fgetxattr = 193,
    listxattr = 194,
    llistxattr = 195,
    flistxattr = 196,
    removexattr = 197,
    lremovexattr = 198,
    fremovexattr = 199,
    tkill = 200,
    time = 201,
    futex = 202,
    sched_setaffinity = 203,
    sched_getaffinity = 204,
    set_thread_area = 205,
    io_setup = 206,
    io_destroy = 207,
    io_getevents = 208,
    io_submit = 209,
    io_cancel = 210,
    get_thread_area = 211,
    lookup_dcookie = 212,
    epoll_create = 213,
    epoll_ctl_old = 214,
    epoll_wait_old = 215,
    remap_file_pages = 216,
    getdents64 = 217,
    set_tid_address = 218,
    restart_syscall = 219,
    semtimedop = 220,
    fadvise64 = 221,
    timer_create = 222,
    timer_settime = 223,
    timer_gettime = 224,
    timer_getoverrun = 225,
    timer_delete = 226,
    clock_settime = 227,
    clock_gettime = 228,
    clock_getres = 229,
    clock_nanosleep = 230,
    exit_group = 231,
    epoll_wait = 232,
    epoll_ctl = 233,
    tgkill = 234,
    utimes = 235,
    vserver = 236,
    mbind = 237,
    set_mempolicy = 238,
    get_mempolicy = 239,
    mq_open = 240,
    mq_unlink = 241,
    mq_timedsend = 242,
    mq_timedreceive = 243,
    mq_notify = 244,
    mq_getsetattr = 245,
    kexec_load = 246,
    waitid = 247,
    add_key = 248,
    request_key = 249,
    keyctl = 250,
    ioprio_set = 251,
    ioprio_get = 252,
    inotify_init = 253,
    inotify_add_watch = 254,
    inotify_rm_watch = 255,
    migrate_pages = 256,
    openat = 257,
    mkdirat = 258,
    mknodat = 259,
    fchownat = 260,
    futimesat = 261,
    fstatat64 = 262,
    unlinkat = 263,
    renameat = 264,
    linkat = 265,
    symlinkat = 266,
    readlinkat = 267,
    fchmodat = 268,
    faccessat = 269,
    pselect6 = 270,
    ppoll = 271,
    unshare = 272,
    set_robust_list = 273,
    get_robust_list = 274,
    splice = 275,
    tee = 276,
    sync_file_range = 277,
    vmsplice = 278,
    move_pages = 279,
    utimensat = 280,
    epoll_pwait = 281,
    signalfd = 282,
    timerfd_create = 283,
    eventfd = 284,
    fallocate = 285,
    timerfd_settime = 286,
    timerfd_gettime = 287,
    accept4 = 288,
    signalfd4 = 289,
    eventfd2 = 290,
    epoll_create1 = 291,
    dup3 = 292,
    pipe2 = 293,
    inotify_init1 = 294,
    preadv = 295,
    pwritev = 296,
    rt_tgsigqueueinfo = 297,
    perf_event_open = 298,
    recvmmsg = 299,
    fanotify_init = 300,
    fanotify_mark = 301,
    prlimit64 = 302,
    name_to_handle_at = 303,
    open_by_handle_at = 304,
    clock_adjtime = 305,
    syncfs = 306,
    sendmmsg = 307,
    setns = 308,
    getcpu = 309,
    process_vm_readv = 310,
    process_vm_writev = 311,
    kcmp = 312,
    finit_module = 313,
    sched_setattr = 314,
    sched_getattr = 315,
    renameat2 = 316,
    seccomp = 317,
    getrandom = 318,
    memfd_create = 319,
    kexec_file_load = 320,
    bpf = 321,
    execveat = 322,
    userfaultfd = 323,
    membarrier = 324,
    mlock2 = 325,
    copy_file_range = 326,
    preadv2 = 327,
    pwritev2 = 328,
    pkey_mprotect = 329,
    pkey_alloc = 330,
    pkey_free = 331,
    statx = 332,
    io_pgetevents = 333,
    rseq = 334,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Arm = enum(usize) {
    const arm_base = 0x0f0000;

    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    lseek = 19,
    getpid = 20,
    mount = 21,
    setuid = 23,
    getuid = 24,
    ptrace = 26,
    pause = 29,
    access = 33,
    nice = 34,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    brk = 45,
    setgid = 46,
    getgid = 47,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    ioctl = 54,
    fcntl = 55,
    setpgid = 57,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    symlink = 83,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    statfs = 99,
    fstatfs = 100,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    vhangup = 111,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    init_module = 128,
    delete_module = 129,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    setfsuid = 138,
    setfsgid = 139,
    llseek = 140,
    getdents = 141,
    newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    poll = 168,
    nfsservctl = 169,
    setresgid = 170,
    getresgid = 171,
    prctl = 172,
    rt_sigreturn = 173,
    rt_sigaction = 174,
    rt_sigprocmask = 175,
    rt_sigpending = 176,
    rt_sigtimedwait = 177,
    rt_sigqueueinfo = 178,
    rt_sigsuspend = 179,
    pread64 = 180,
    pwrite64 = 181,
    chown = 182,
    getcwd = 183,
    capget = 184,
    capset = 185,
    sigaltstack = 186,
    sendfile = 187,
    vfork = 190,
    ugetrlimit = 191,
    mmap2 = 192,
    truncate64 = 193,
    ftruncate64 = 194,
    stat64 = 195,
    lstat64 = 196,
    fstat64 = 197,
    lchown32 = 198,
    getuid32 = 199,
    getgid32 = 200,
    geteuid32 = 201,
    getegid32 = 202,
    setreuid32 = 203,
    setregid32 = 204,
    getgroups32 = 205,
    setgroups32 = 206,
    fchown32 = 207,
    setresuid32 = 208,
    getresuid32 = 209,
    setresgid32 = 210,
    getresgid32 = 211,
    chown32 = 212,
    setuid32 = 213,
    setgid32 = 214,
    setfsuid32 = 215,
    setfsgid32 = 216,
    getdents64 = 217,
    pivot_root = 218,
    mincore = 219,
    madvise = 220,
    fcntl64 = 221,
    gettid = 224,
    readahead = 225,
    setxattr = 226,
    lsetxattr = 227,
    fsetxattr = 228,
    getxattr = 229,
    lgetxattr = 230,
    fgetxattr = 231,
    listxattr = 232,
    llistxattr = 233,
    flistxattr = 234,
    removexattr = 235,
    lremovexattr = 236,
    fremovexattr = 237,
    tkill = 238,
    sendfile64 = 239,
    futex = 240,
    sched_setaffinity = 241,
    sched_getaffinity = 242,
    io_setup = 243,
    io_destroy = 244,
    io_getevents = 245,
    io_submit = 246,
    io_cancel = 247,
    exit_group = 248,
    lookup_dcookie = 249,
    epoll_create = 250,
    epoll_ctl = 251,
    epoll_wait = 252,
    remap_file_pages = 253,
    set_tid_address = 256,
    timer_create = 257,
    timer_settime = 258,
    timer_gettime = 259,
    timer_getoverrun = 260,
    timer_delete = 261,
    clock_settime = 262,
    clock_gettime = 263,
    clock_getres = 264,
    clock_nanosleep = 265,
    statfs64 = 266,
    fstatfs64 = 267,
    tgkill = 268,
    utimes = 269,
    fadvise64_64 = 270,
    pciconfig_iobase = 271,
    pciconfig_read = 272,
    pciconfig_write = 273,
    mq_open = 274,
    mq_unlink = 275,
    mq_timedsend = 276,
    mq_timedreceive = 277,
    mq_notify = 278,
    mq_getsetattr = 279,
    waitid = 280,
    socket = 281,
    bind = 282,
    connect = 283,
    listen = 284,
    accept = 285,
    getsockname = 286,
    getpeername = 287,
    socketpair = 288,
    send = 289,
    sendto = 290,
    recv = 291,
    recvfrom = 292,
    shutdown = 293,
    setsockopt = 294,
    getsockopt = 295,
    sendmsg = 296,
    recvmsg = 297,
    semop = 298,
    semget = 299,
    semctl = 300,
    msgsnd = 301,
    msgrcv = 302,
    msgget = 303,
    msgctl = 304,
    shmat = 305,
    shmdt = 306,
    shmget = 307,
    shmctl = 308,
    add_key = 309,
    request_key = 310,
    keyctl = 311,
    semtimedop = 312,
    vserver = 313,
    ioprio_set = 314,
    ioprio_get = 315,
    inotify_init = 316,
    inotify_add_watch = 317,
    inotify_rm_watch = 318,
    mbind = 319,
    get_mempolicy = 320,
    set_mempolicy = 321,
    openat = 322,
    mkdirat = 323,
    mknodat = 324,
    fchownat = 325,
    futimesat = 326,
    fstatat64 = 327,
    unlinkat = 328,
    renameat = 329,
    linkat = 330,
    symlinkat = 331,
    readlinkat = 332,
    fchmodat = 333,
    faccessat = 334,
    pselect6 = 335,
    ppoll = 336,
    unshare = 337,
    set_robust_list = 338,
    get_robust_list = 339,
    splice = 340,
    sync_file_range = 341,
    tee = 342,
    vmsplice = 343,
    move_pages = 344,
    getcpu = 345,
    epoll_pwait = 346,
    kexec_load = 347,
    utimensat = 348,
    signalfd = 349,
    timerfd_create = 350,
    eventfd = 351,
    fallocate = 352,
    timerfd_settime = 353,
    timerfd_gettime = 354,
    signalfd4 = 355,
    eventfd2 = 356,
    epoll_create1 = 357,
    dup3 = 358,
    pipe2 = 359,
    inotify_init1 = 360,
    preadv = 361,
    pwritev = 362,
    rt_tgsigqueueinfo = 363,
    perf_event_open = 364,
    recvmmsg = 365,
    accept4 = 366,
    fanotify_init = 367,
    fanotify_mark = 368,
    prlimit64 = 369,
    name_to_handle_at = 370,
    open_by_handle_at = 371,
    clock_adjtime = 372,
    syncfs = 373,
    sendmmsg = 374,
    setns = 375,
    process_vm_readv = 376,
    process_vm_writev = 377,
    kcmp = 378,
    finit_module = 379,
    sched_setattr = 380,
    sched_getattr = 381,
    renameat2 = 382,
    seccomp = 383,
    getrandom = 384,
    memfd_create = 385,
    bpf = 386,
    execveat = 387,
    userfaultfd = 388,
    membarrier = 389,
    mlock2 = 390,
    copy_file_range = 391,
    preadv2 = 392,
    pwritev2 = 393,
    pkey_mprotect = 394,
    pkey_alloc = 395,
    pkey_free = 396,
    statx = 397,
    rseq = 398,
    io_pgetevents = 399,
    migrate_pages = 400,
    kexec_file_load = 401,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,

    breakpoint = arm_base + 1,
    cacheflush = arm_base + 2,
    usr26 = arm_base + 3,
    usr32 = arm_base + 4,
    set_tls = arm_base + 5,
    get_tls = arm_base + 6,
};

pub const Sparc = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    wait4 = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execv = 11,
    chdir = 12,
    chown = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    brk = 17,
    perfctr = 18,
    lseek = 19,
    getpid = 20,
    capget = 21,
    capset = 22,
    setuid = 23,
    getuid = 24,
    vmsplice = 25,
    ptrace = 26,
    alarm = 27,
    sigaltstack = 28,
    pause = 29,
    utime = 30,
    lchown32 = 31,
    fchown32 = 32,
    access = 33,
    nice = 34,
    chown32 = 35,
    sync = 36,
    kill = 37,
    stat = 38,
    sendfile = 39,
    lstat = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    getuid32 = 44,
    umount2 = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    getgid32 = 53,
    ioctl = 54,
    reboot = 55,
    mmap2 = 56,
    symlink = 57,
    readlink = 58,
    execve = 59,
    umask = 60,
    chroot = 61,
    fstat = 62,
    fstat64 = 63,
    getpagesize = 64,
    msync = 65,
    vfork = 66,
    pread64 = 67,
    pwrite64 = 68,
    geteuid32 = 69,
    getegid32 = 70,
    mmap = 71,
    setreuid32 = 72,
    munmap = 73,
    mprotect = 74,
    madvise = 75,
    vhangup = 76,
    truncate64 = 77,
    mincore = 78,
    getgroups = 79,
    setgroups = 80,
    getpgrp = 81,
    setgroups32 = 82,
    setitimer = 83,
    ftruncate64 = 84,
    swapon = 85,
    getitimer = 86,
    setuid32 = 87,
    sethostname = 88,
    setgid32 = 89,
    dup2 = 90,
    setfsuid32 = 91,
    fcntl = 92,
    select = 93,
    setfsgid32 = 94,
    fsync = 95,
    setpriority = 96,
    socket = 97,
    connect = 98,
    accept = 99,
    getpriority = 100,
    rt_sigreturn = 101,
    rt_sigaction = 102,
    rt_sigprocmask = 103,
    rt_sigpending = 104,
    rt_sigtimedwait = 105,
    rt_sigqueueinfo = 106,
    rt_sigsuspend = 107,
    setresuid32 = 108,
    getresuid32 = 109,
    setresgid32 = 110,
    getresgid32 = 111,
    setregid32 = 112,
    recvmsg = 113,
    sendmsg = 114,
    getgroups32 = 115,
    gettimeofday = 116,
    getrusage = 117,
    getsockopt = 118,
    getcwd = 119,
    readv = 120,
    writev = 121,
    settimeofday = 122,
    fchown = 123,
    fchmod = 124,
    recvfrom = 125,
    setreuid = 126,
    setregid = 127,
    rename = 128,
    truncate = 129,
    ftruncate = 130,
    flock = 131,
    lstat64 = 132,
    sendto = 133,
    shutdown = 134,
    socketpair = 135,
    mkdir = 136,
    rmdir = 137,
    utimes = 138,
    stat64 = 139,
    sendfile64 = 140,
    getpeername = 141,
    futex = 142,
    gettid = 143,
    getrlimit = 144,
    setrlimit = 145,
    pivot_root = 146,
    prctl = 147,
    pciconfig_read = 148,
    pciconfig_write = 149,
    getsockname = 150,
    inotify_init = 151,
    inotify_add_watch = 152,
    poll = 153,
    getdents64 = 154,
    fcntl64 = 155,
    inotify_rm_watch = 156,
    statfs = 157,
    fstatfs = 158,
    umount = 159,
    sched_set_affinity = 160,
    sched_get_affinity = 161,
    getdomainname = 162,
    setdomainname = 163,
    quotactl = 165,
    set_tid_address = 166,
    mount = 167,
    ustat = 168,
    setxattr = 169,
    lsetxattr = 170,
    fsetxattr = 171,
    getxattr = 172,
    lgetxattr = 173,
    getdents = 174,
    setsid = 175,
    fchdir = 176,
    fgetxattr = 177,
    listxattr = 178,
    llistxattr = 179,
    flistxattr = 180,
    removexattr = 181,
    lremovexattr = 182,
    sigpending = 183,
    query_module = 184,
    setpgid = 185,
    fremovexattr = 186,
    tkill = 187,
    exit_group = 188,
    uname = 189,
    init_module = 190,
    personality = 191,
    remap_file_pages = 192,
    epoll_create = 193,
    epoll_ctl = 194,
    epoll_wait = 195,
    ioprio_set = 196,
    getppid = 197,
    sigaction = 198,
    sgetmask = 199,
    ssetmask = 200,
    sigsuspend = 201,
    oldlstat = 202,
    uselib = 203,
    readdir = 204,
    readahead = 205,
    socketcall = 206,
    syslog = 207,
    lookup_dcookie = 208,
    fadvise64 = 209,
    fadvise64_64 = 210,
    tgkill = 211,
    waitpid = 212,
    swapoff = 213,
    sysinfo = 214,
    ipc = 215,
    sigreturn = 216,
    clone = 217,
    ioprio_get = 218,
    adjtimex = 219,
    sigprocmask = 220,
    create_module = 221,
    delete_module = 222,
    get_kernel_syms = 223,
    getpgid = 224,
    bdflush = 225,
    sysfs = 226,
    afs_syscall = 227,
    setfsuid = 228,
    setfsgid = 229,
    newselect = 230,
    time = 231,
    splice = 232,
    stime = 233,
    statfs64 = 234,
    fstatfs64 = 235,
    llseek = 236,
    mlock = 237,
    munlock = 238,
    mlockall = 239,
    munlockall = 240,
    sched_setparam = 241,
    sched_getparam = 242,
    sched_setscheduler = 243,
    sched_getscheduler = 244,
    sched_yield = 245,
    sched_get_priority_max = 246,
    sched_get_priority_min = 247,
    sched_rr_get_interval = 248,
    nanosleep = 249,
    mremap = 250,
    sysctl = 251,
    getsid = 252,
    fdatasync = 253,
    nfsservctl = 254,
    sync_file_range = 255,
    clock_settime = 256,
    clock_gettime = 257,
    clock_getres = 258,
    clock_nanosleep = 259,
    sched_getaffinity = 260,
    sched_setaffinity = 261,
    timer_settime = 262,
    timer_gettime = 263,
    timer_getoverrun = 264,
    timer_delete = 265,
    timer_create = 266,
    vserver = 267,
    io_setup = 268,
    io_destroy = 269,
    io_submit = 270,
    io_cancel = 271,
    io_getevents = 272,
    mq_open = 273,
    mq_unlink = 274,
    mq_timedsend = 275,
    mq_timedreceive = 276,
    mq_notify = 277,
    mq_getsetattr = 278,
    waitid = 279,
    tee = 280,
    add_key = 281,
    request_key = 282,
    keyctl = 283,
    openat = 284,
    mkdirat = 285,
    mknodat = 286,
    fchownat = 287,
    futimesat = 288,
    fstatat64 = 289,
    unlinkat = 290,
    renameat = 291,
    linkat = 292,
    symlinkat = 293,
    readlinkat = 294,
    fchmodat = 295,
    faccessat = 296,
    pselect6 = 297,
    ppoll = 298,
    unshare = 299,
    set_robust_list = 300,
    get_robust_list = 301,
    migrate_pages = 302,
    mbind = 303,
    get_mempolicy = 304,
    set_mempolicy = 305,
    kexec_load = 306,
    move_pages = 307,
    getcpu = 308,
    epoll_pwait = 309,
    utimensat = 310,
    signalfd = 311,
    timerfd_create = 312,
    eventfd = 313,
    fallocate = 314,
    timerfd_settime = 315,
    timerfd_gettime = 316,
    signalfd4 = 317,
    eventfd2 = 318,
    epoll_create1 = 319,
    dup3 = 320,
    pipe2 = 321,
    inotify_init1 = 322,
    accept4 = 323,
    preadv = 324,
    pwritev = 325,
    rt_tgsigqueueinfo = 326,
    perf_event_open = 327,
    recvmmsg = 328,
    fanotify_init = 329,
    fanotify_mark = 330,
    prlimit64 = 331,
    name_to_handle_at = 332,
    open_by_handle_at = 333,
    clock_adjtime = 334,
    syncfs = 335,
    sendmmsg = 336,
    setns = 337,
    process_vm_readv = 338,
    process_vm_writev = 339,
    kern_features = 340,
    kcmp = 341,
    finit_module = 342,
    sched_setattr = 343,
    sched_getattr = 344,
    renameat2 = 345,
    seccomp = 346,
    getrandom = 347,
    memfd_create = 348,
    bpf = 349,
    execveat = 350,
    membarrier = 351,
    userfaultfd = 352,
    bind = 353,
    listen = 354,
    setsockopt = 355,
    mlock2 = 356,
    copy_file_range = 357,
    preadv2 = 358,
    pwritev2 = 359,
    statx = 360,
    io_pgetevents = 361,
    pkey_mprotect = 362,
    pkey_alloc = 363,
    pkey_free = 364,
    rseq = 365,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Sparc64 = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    wait4 = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execv = 11,
    chdir = 12,
    chown = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    brk = 17,
    perfctr = 18,
    lseek = 19,
    getpid = 20,
    capget = 21,
    capset = 22,
    setuid = 23,
    getuid = 24,
    vmsplice = 25,
    ptrace = 26,
    alarm = 27,
    sigaltstack = 28,
    pause = 29,
    utime = 30,
    access = 33,
    nice = 34,
    sync = 36,
    kill = 37,
    stat = 38,
    sendfile = 39,
    lstat = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    umount2 = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    memory_ordering = 52,
    ioctl = 54,
    reboot = 55,
    symlink = 57,
    readlink = 58,
    execve = 59,
    umask = 60,
    chroot = 61,
    fstat = 62,
    fstat64 = 63,
    getpagesize = 64,
    msync = 65,
    vfork = 66,
    pread64 = 67,
    pwrite64 = 68,
    mmap = 71,
    munmap = 73,
    mprotect = 74,
    madvise = 75,
    vhangup = 76,
    mincore = 78,
    getgroups = 79,
    setgroups = 80,
    getpgrp = 81,
    setitimer = 83,
    swapon = 85,
    getitimer = 86,
    sethostname = 88,
    dup2 = 90,
    fcntl = 92,
    select = 93,
    fsync = 95,
    setpriority = 96,
    socket = 97,
    connect = 98,
    accept = 99,
    getpriority = 100,
    rt_sigreturn = 101,
    rt_sigaction = 102,
    rt_sigprocmask = 103,
    rt_sigpending = 104,
    rt_sigtimedwait = 105,
    rt_sigqueueinfo = 106,
    rt_sigsuspend = 107,
    setresuid = 108,
    getresuid = 109,
    setresgid = 110,
    getresgid = 111,
    recvmsg = 113,
    sendmsg = 114,
    gettimeofday = 116,
    getrusage = 117,
    getsockopt = 118,
    getcwd = 119,
    readv = 120,
    writev = 121,
    settimeofday = 122,
    fchown = 123,
    fchmod = 124,
    recvfrom = 125,
    setreuid = 126,
    setregid = 127,
    rename = 128,
    truncate = 129,
    ftruncate = 130,
    flock = 131,
    lstat64 = 132,
    sendto = 133,
    shutdown = 134,
    socketpair = 135,
    mkdir = 136,
    rmdir = 137,
    utimes = 138,
    stat64 = 139,
    sendfile64 = 140,
    getpeername = 141,
    futex = 142,
    gettid = 143,
    getrlimit = 144,
    setrlimit = 145,
    pivot_root = 146,
    prctl = 147,
    pciconfig_read = 148,
    pciconfig_write = 149,
    getsockname = 150,
    inotify_init = 151,
    inotify_add_watch = 152,
    poll = 153,
    getdents64 = 154,
    inotify_rm_watch = 156,
    statfs = 157,
    fstatfs = 158,
    umount = 159,
    sched_set_affinity = 160,
    sched_get_affinity = 161,
    getdomainname = 162,
    setdomainname = 163,
    utrap_install = 164,
    quotactl = 165,
    set_tid_address = 166,
    mount = 167,
    ustat = 168,
    setxattr = 169,
    lsetxattr = 170,
    fsetxattr = 171,
    getxattr = 172,
    lgetxattr = 173,
    getdents = 174,
    setsid = 175,
    fchdir = 176,
    fgetxattr = 177,
    listxattr = 178,
    llistxattr = 179,
    flistxattr = 180,
    removexattr = 181,
    lremovexattr = 182,
    sigpending = 183,
    query_module = 184,
    setpgid = 185,
    fremovexattr = 186,
    tkill = 187,
    exit_group = 188,
    uname = 189,
    init_module = 190,
    personality = 191,
    remap_file_pages = 192,
    epoll_create = 193,
    epoll_ctl = 194,
    epoll_wait = 195,
    ioprio_set = 196,
    getppid = 197,
    sigaction = 198,
    sgetmask = 199,
    ssetmask = 200,
    sigsuspend = 201,
    oldlstat = 202,
    uselib = 203,
    readdir = 204,
    readahead = 205,
    socketcall = 206,
    syslog = 207,
    lookup_dcookie = 208,
    fadvise64 = 209,
    fadvise64_64 = 210,
    tgkill = 211,
    waitpid = 212,
    swapoff = 213,
    sysinfo = 214,
    ipc = 215,
    sigreturn = 216,
    clone = 217,
    ioprio_get = 218,
    adjtimex = 219,
    sigprocmask = 220,
    create_module = 221,
    delete_module = 222,
    get_kernel_syms = 223,
    getpgid = 224,
    bdflush = 225,
    sysfs = 226,
    afs_syscall = 227,
    setfsuid = 228,
    setfsgid = 229,
    newselect = 230,
    splice = 232,
    stime = 233,
    statfs64 = 234,
    fstatfs64 = 235,
    llseek = 236,
    mlock = 237,
    munlock = 238,
    mlockall = 239,
    munlockall = 240,
    sched_setparam = 241,
    sched_getparam = 242,
    sched_setscheduler = 243,
    sched_getscheduler = 244,
    sched_yield = 245,
    sched_get_priority_max = 246,
    sched_get_priority_min = 247,
    sched_rr_get_interval = 248,
    nanosleep = 249,
    mremap = 250,
    sysctl = 251,
    getsid = 252,
    fdatasync = 253,
    nfsservctl = 254,
    sync_file_range = 255,
    clock_settime = 256,
    clock_gettime = 257,
    clock_getres = 258,
    clock_nanosleep = 259,
    sched_getaffinity = 260,
    sched_setaffinity = 261,
    timer_settime = 262,
    timer_gettime = 263,
    timer_getoverrun = 264,
    timer_delete = 265,
    timer_create = 266,
    vserver = 267,
    io_setup = 268,
    io_destroy = 269,
    io_submit = 270,
    io_cancel = 271,
    io_getevents = 272,
    mq_open = 273,
    mq_unlink = 274,
    mq_timedsend = 275,
    mq_timedreceive = 276,
    mq_notify = 277,
    mq_getsetattr = 278,
    waitid = 279,
    tee = 280,
    add_key = 281,
    request_key = 282,
    keyctl = 283,
    openat = 284,
    mkdirat = 285,
    mknodat = 286,
    fchownat = 287,
    futimesat = 288,
    fstatat64 = 289,
    unlinkat = 290,
    renameat = 291,
    linkat = 292,
    symlinkat = 293,
    readlinkat = 294,
    fchmodat = 295,
    faccessat = 296,
    pselect6 = 297,
    ppoll = 298,
    unshare = 299,
    set_robust_list = 300,
    get_robust_list = 301,
    migrate_pages = 302,
    mbind = 303,
    get_mempolicy = 304,
    set_mempolicy = 305,
    kexec_load = 306,
    move_pages = 307,
    getcpu = 308,
    epoll_pwait = 309,
    utimensat = 310,
    signalfd = 311,
    timerfd_create = 312,
    eventfd = 313,
    fallocate = 314,
    timerfd_settime = 315,
    timerfd_gettime = 316,
    signalfd4 = 317,
    eventfd2 = 318,
    epoll_create1 = 319,
    dup3 = 320,
    pipe2 = 321,
    inotify_init1 = 322,
    accept4 = 323,
    preadv = 324,
    pwritev = 325,
    rt_tgsigqueueinfo = 326,
    perf_event_open = 327,
    recvmmsg = 328,
    fanotify_init = 329,
    fanotify_mark = 330,
    prlimit64 = 331,
    name_to_handle_at = 332,
    open_by_handle_at = 333,
    clock_adjtime = 334,
    syncfs = 335,
    sendmmsg = 336,
    setns = 337,
    process_vm_readv = 338,
    process_vm_writev = 339,
    kern_features = 340,
    kcmp = 341,
    finit_module = 342,
    sched_setattr = 343,
    sched_getattr = 344,
    renameat2 = 345,
    seccomp = 346,
    getrandom = 347,
    memfd_create = 348,
    bpf = 349,
    execveat = 350,
    membarrier = 351,
    userfaultfd = 352,
    bind = 353,
    listen = 354,
    setsockopt = 355,
    mlock2 = 356,
    copy_file_range = 357,
    preadv2 = 358,
    pwritev2 = 359,
    statx = 360,
    io_pgetevents = 361,
    pkey_mprotect = 362,
    pkey_alloc = 363,
    pkey_free = 364,
    rseq = 365,
    semtimedop = 392,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const M68k = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    waitpid = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    time = 13,
    mknod = 14,
    chmod = 15,
    chown = 16,
    oldstat = 18,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    setuid = 23,
    getuid = 24,
    stime = 25,
    ptrace = 26,
    alarm = 27,
    oldfstat = 28,
    pause = 29,
    utime = 30,
    access = 33,
    nice = 34,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    brk = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    ioctl = 54,
    fcntl = 55,
    setpgid = 57,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sgetmask = 68,
    ssetmask = 69,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrlimit = 76,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    select = 82,
    symlink = 83,
    oldlstat = 84,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    statfs = 99,
    fstatfs = 100,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    vhangup = 111,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    cacheflush = 123,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    setfsuid = 138,
    setfsgid = 139,
    llseek = 140,
    getdents = 141,
    newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    getpagesize = 166,
    query_module = 167,
    poll = 168,
    nfsservctl = 169,
    setresgid = 170,
    getresgid = 171,
    prctl = 172,
    rt_sigreturn = 173,
    rt_sigaction = 174,
    rt_sigprocmask = 175,
    rt_sigpending = 176,
    rt_sigtimedwait = 177,
    rt_sigqueueinfo = 178,
    rt_sigsuspend = 179,
    pread64 = 180,
    pwrite64 = 181,
    lchown = 182,
    getcwd = 183,
    capget = 184,
    capset = 185,
    sigaltstack = 186,
    sendfile = 187,
    getpmsg = 188,
    putpmsg = 189,
    vfork = 190,
    ugetrlimit = 191,
    mmap2 = 192,
    truncate64 = 193,
    ftruncate64 = 194,
    stat64 = 195,
    lstat64 = 196,
    fstat64 = 197,
    chown32 = 198,
    getuid32 = 199,
    getgid32 = 200,
    geteuid32 = 201,
    getegid32 = 202,
    setreuid32 = 203,
    setregid32 = 204,
    getgroups32 = 205,
    setgroups32 = 206,
    fchown32 = 207,
    setresuid32 = 208,
    getresuid32 = 209,
    setresgid32 = 210,
    getresgid32 = 211,
    lchown32 = 212,
    setuid32 = 213,
    setgid32 = 214,
    setfsuid32 = 215,
    setfsgid32 = 216,
    pivot_root = 217,
    getdents64 = 220,
    gettid = 221,
    tkill = 222,
    setxattr = 223,
    lsetxattr = 224,
    fsetxattr = 225,
    getxattr = 226,
    lgetxattr = 227,
    fgetxattr = 228,
    listxattr = 229,
    llistxattr = 230,
    flistxattr = 231,
    removexattr = 232,
    lremovexattr = 233,
    fremovexattr = 234,
    futex = 235,
    sendfile64 = 236,
    mincore = 237,
    madvise = 238,
    fcntl64 = 239,
    readahead = 240,
    io_setup = 241,
    io_destroy = 242,
    io_getevents = 243,
    io_submit = 244,
    io_cancel = 245,
    fadvise64 = 246,
    exit_group = 247,
    lookup_dcookie = 248,
    epoll_create = 249,
    epoll_ctl = 250,
    epoll_wait = 251,
    remap_file_pages = 252,
    set_tid_address = 253,
    timer_create = 254,
    timer_settime = 255,
    timer_gettime = 256,
    timer_getoverrun = 257,
    timer_delete = 258,
    clock_settime = 259,
    clock_gettime = 260,
    clock_getres = 261,
    clock_nanosleep = 262,
    statfs64 = 263,
    fstatfs64 = 264,
    tgkill = 265,
    utimes = 266,
    fadvise64_64 = 267,
    mbind = 268,
    get_mempolicy = 269,
    set_mempolicy = 270,
    mq_open = 271,
    mq_unlink = 272,
    mq_timedsend = 273,
    mq_timedreceive = 274,
    mq_notify = 275,
    mq_getsetattr = 276,
    waitid = 277,
    add_key = 279,
    request_key = 280,
    keyctl = 281,
    ioprio_set = 282,
    ioprio_get = 283,
    inotify_init = 284,
    inotify_add_watch = 285,
    inotify_rm_watch = 286,
    migrate_pages = 287,
    openat = 288,
    mkdirat = 289,
    mknodat = 290,
    fchownat = 291,
    futimesat = 292,
    fstatat64 = 293,
    unlinkat = 294,
    renameat = 295,
    linkat = 296,
    symlinkat = 297,
    readlinkat = 298,
    fchmodat = 299,
    faccessat = 300,
    pselect6 = 301,
    ppoll = 302,
    unshare = 303,
    set_robust_list = 304,
    get_robust_list = 305,
    splice = 306,
    sync_file_range = 307,
    tee = 308,
    vmsplice = 309,
    move_pages = 310,
    sched_setaffinity = 311,
    sched_getaffinity = 312,
    kexec_load = 313,
    getcpu = 314,
    epoll_pwait = 315,
    utimensat = 316,
    signalfd = 317,
    timerfd_create = 318,
    eventfd = 319,
    fallocate = 320,
    timerfd_settime = 321,
    timerfd_gettime = 322,
    signalfd4 = 323,
    eventfd2 = 324,
    epoll_create1 = 325,
    dup3 = 326,
    pipe2 = 327,
    inotify_init1 = 328,
    preadv = 329,
    pwritev = 330,
    rt_tgsigqueueinfo = 331,
    perf_event_open = 332,
    get_thread_area = 333,
    set_thread_area = 334,
    atomic_cmpxchg_32 = 335,
    atomic_barrier = 336,
    fanotify_init = 337,
    fanotify_mark = 338,
    prlimit64 = 339,
    name_to_handle_at = 340,
    open_by_handle_at = 341,
    clock_adjtime = 342,
    syncfs = 343,
    setns = 344,
    process_vm_readv = 345,
    process_vm_writev = 346,
    kcmp = 347,
    finit_module = 348,
    sched_setattr = 349,
    sched_getattr = 350,
    renameat2 = 351,
    getrandom = 352,
    memfd_create = 353,
    bpf = 354,
    execveat = 355,
    socket = 356,
    socketpair = 357,
    bind = 358,
    connect = 359,
    listen = 360,
    accept4 = 361,
    getsockopt = 362,
    setsockopt = 363,
    getsockname = 364,
    getpeername = 365,
    sendto = 366,
    sendmsg = 367,
    recvfrom = 368,
    recvmsg = 369,
    shutdown = 370,
    recvmmsg = 371,
    sendmmsg = 372,
    userfaultfd = 373,
    membarrier = 374,
    mlock2 = 375,
    copy_file_range = 376,
    preadv2 = 377,
    pwritev2 = 378,
    statx = 379,
    seccomp = 380,
    pkey_mprotect = 381,
    pkey_alloc = 382,
    pkey_free = 383,
    rseq = 384,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const MipsO32 = enum(usize) {
    const linux_base = 4000;

    syscall = linux_base + 0,
    exit = linux_base + 1,
    fork = linux_base + 2,
    read = linux_base + 3,
    write = linux_base + 4,
    open = linux_base + 5,
    close = linux_base + 6,
    waitpid = linux_base + 7,
    creat = linux_base + 8,
    link = linux_base + 9,
    unlink = linux_base + 10,
    execve = linux_base + 11,
    chdir = linux_base + 12,
    time = linux_base + 13,
    mknod = linux_base + 14,
    chmod = linux_base + 15,
    lchown = linux_base + 16,
    @"break" = linux_base + 17,
    lseek = linux_base + 19,
    getpid = linux_base + 20,
    mount = linux_base + 21,
    umount = linux_base + 22,
    setuid = linux_base + 23,
    getuid = linux_base + 24,
    stime = linux_base + 25,
    ptrace = linux_base + 26,
    alarm = linux_base + 27,
    pause = linux_base + 29,
    utime = linux_base + 30,
    stty = linux_base + 31,
    gtty = linux_base + 32,
    access = linux_base + 33,
    nice = linux_base + 34,
    ftime = linux_base + 35,
    sync = linux_base + 36,
    kill = linux_base + 37,
    rename = linux_base + 38,
    mkdir = linux_base + 39,
    rmdir = linux_base + 40,
    dup = linux_base + 41,
    pipe = linux_base + 42,
    times = linux_base + 43,
    prof = linux_base + 44,
    brk = linux_base + 45,
    setgid = linux_base + 46,
    getgid = linux_base + 47,
    signal = linux_base + 48,
    geteuid = linux_base + 49,
    getegid = linux_base + 50,
    acct = linux_base + 51,
    umount2 = linux_base + 52,
    lock = linux_base + 53,
    ioctl = linux_base + 54,
    fcntl = linux_base + 55,
    mpx = linux_base + 56,
    setpgid = linux_base + 57,
    ulimit = linux_base + 58,
    umask = linux_base + 60,
    chroot = linux_base + 61,
    ustat = linux_base + 62,
    dup2 = linux_base + 63,
    getppid = linux_base + 64,
    getpgrp = linux_base + 65,
    setsid = linux_base + 66,
    sigaction = linux_base + 67,
    sgetmask = linux_base + 68,
    ssetmask = linux_base + 69,
    setreuid = linux_base + 70,
    setregid = linux_base + 71,
    sigsuspend = linux_base + 72,
    sigpending = linux_base + 73,
    sethostname = linux_base + 74,
    setrlimit = linux_base + 75,
    getrlimit = linux_base + 76,
    getrusage = linux_base + 77,
    gettimeofday = linux_base + 78,
    settimeofday = linux_base + 79,
    getgroups = linux_base + 80,
    setgroups = linux_base + 81,
    symlink = linux_base + 83,
    readlink = linux_base + 85,
    uselib = linux_base + 86,
    swapon = linux_base + 87,
    reboot = linux_base + 88,
    readdir = linux_base + 89,
    mmap = linux_base + 90,
    munmap = linux_base + 91,
    truncate = linux_base + 92,
    ftruncate = linux_base + 93,
    fchmod = linux_base + 94,
    fchown = linux_base + 95,
    getpriority = linux_base + 96,
    setpriority = linux_base + 97,
    profil = linux_base + 98,
    statfs = linux_base + 99,
    fstatfs = linux_base + 100,
    ioperm = linux_base + 101,
    socketcall = linux_base + 102,
    syslog = linux_base + 103,
    setitimer = linux_base + 104,
    getitimer = linux_base + 105,
    stat = linux_base + 106,
    lstat = linux_base + 107,
    fstat = linux_base + 108,
    iopl = linux_base + 110,
    vhangup = linux_base + 111,
    idle = linux_base + 112,
    vm86 = linux_base + 113,
    wait4 = linux_base + 114,
    swapoff = linux_base + 115,
    sysinfo = linux_base + 116,
    ipc = linux_base + 117,
    fsync = linux_base + 118,
    sigreturn = linux_base + 119,
    clone = linux_base + 120,
    setdomainname = linux_base + 121,
    uname = linux_base + 122,
    modify_ldt = linux_base + 123,
    adjtimex = linux_base + 124,
    mprotect = linux_base + 125,
    sigprocmask = linux_base + 126,
    create_module = linux_base + 127,
    init_module = linux_base + 128,
    delete_module = linux_base + 129,
    get_kernel_syms = linux_base + 130,
    quotactl = linux_base + 131,
    getpgid = linux_base + 132,
    fchdir = linux_base + 133,
    bdflush = linux_base + 134,
    sysfs = linux_base + 135,
    personality = linux_base + 136,
    afs_syscall = linux_base + 137,
    setfsuid = linux_base + 138,
    setfsgid = linux_base + 139,
    llseek = linux_base + 140,
    getdents = linux_base + 141,
    newselect = linux_base + 142,
    flock = linux_base + 143,
    msync = linux_base + 144,
    readv = linux_base + 145,
    writev = linux_base + 146,
    cacheflush = linux_base + 147,
    cachectl = linux_base + 148,
    sysmips = linux_base + 149,
    getsid = linux_base + 151,
    fdatasync = linux_base + 152,
    sysctl = linux_base + 153,
    mlock = linux_base + 154,
    munlock = linux_base + 155,
    mlockall = linux_base + 156,
    munlockall = linux_base + 157,
    sched_setparam = linux_base + 158,
    sched_getparam = linux_base + 159,
    sched_setscheduler = linux_base + 160,
    sched_getscheduler = linux_base + 161,
    sched_yield = linux_base + 162,
    sched_get_priority_max = linux_base + 163,
    sched_get_priority_min = linux_base + 164,
    sched_rr_get_interval = linux_base + 165,
    nanosleep = linux_base + 166,
    mremap = linux_base + 167,
    accept = linux_base + 168,
    bind = linux_base + 169,
    connect = linux_base + 170,
    getpeername = linux_base + 171,
    getsockname = linux_base + 172,
    getsockopt = linux_base + 173,
    listen = linux_base + 174,
    recv = linux_base + 175,
    recvfrom = linux_base + 176,
    recvmsg = linux_base + 177,
    send = linux_base + 178,
    sendmsg = linux_base + 179,
    sendto = linux_base + 180,
    setsockopt = linux_base + 181,
    shutdown = linux_base + 182,
    socket = linux_base + 183,
    socketpair = linux_base + 184,
    setresuid = linux_base + 185,
    getresuid = linux_base + 186,
    query_module = linux_base + 187,
    poll = linux_base + 188,
    nfsservctl = linux_base + 189,
    setresgid = linux_base + 190,
    getresgid = linux_base + 191,
    prctl = linux_base + 192,
    rt_sigreturn = linux_base + 193,
    rt_sigaction = linux_base + 194,
    rt_sigprocmask = linux_base + 195,
    rt_sigpending = linux_base + 196,
    rt_sigtimedwait = linux_base + 197,
    rt_sigqueueinfo = linux_base + 198,
    rt_sigsuspend = linux_base + 199,
    pread64 = linux_base + 200,
    pwrite64 = linux_base + 201,
    chown = linux_base + 202,
    getcwd = linux_base + 203,
    capget = linux_base + 204,
    capset = linux_base + 205,
    sigaltstack = linux_base + 206,
    sendfile = linux_base + 207,
    getpmsg = linux_base + 208,
    putpmsg = linux_base + 209,
    mmap2 = linux_base + 210,
    truncate64 = linux_base + 211,
    ftruncate64 = linux_base + 212,
    stat64 = linux_base + 213,
    lstat64 = linux_base + 214,
    fstat64 = linux_base + 215,
    pivot_root = linux_base + 216,
    mincore = linux_base + 217,
    madvise = linux_base + 218,
    getdents64 = linux_base + 219,
    fcntl64 = linux_base + 220,
    gettid = linux_base + 222,
    readahead = linux_base + 223,
    setxattr = linux_base + 224,
    lsetxattr = linux_base + 225,
    fsetxattr = linux_base + 226,
    getxattr = linux_base + 227,
    lgetxattr = linux_base + 228,
    fgetxattr = linux_base + 229,
    listxattr = linux_base + 230,
    llistxattr = linux_base + 231,
    flistxattr = linux_base + 232,
    removexattr = linux_base + 233,
    lremovexattr = linux_base + 234,
    fremovexattr = linux_base + 235,
    tkill = linux_base + 236,
    sendfile64 = linux_base + 237,
    futex = linux_base + 238,
    sched_setaffinity = linux_base + 239,
    sched_getaffinity = linux_base + 240,
    io_setup = linux_base + 241,
    io_destroy = linux_base + 242,
    io_getevents = linux_base + 243,
    io_submit = linux_base + 244,
    io_cancel = linux_base + 245,
    exit_group = linux_base + 246,
    lookup_dcookie = linux_base + 247,
    epoll_create = linux_base + 248,
    epoll_ctl = linux_base + 249,
    epoll_wait = linux_base + 250,
    remap_file_pages = linux_base + 251,
    set_tid_address = linux_base + 252,
    restart_syscall = linux_base + 253,
    fadvise64 = linux_base + 254,
    statfs64 = linux_base + 255,
    fstatfs64 = linux_base + 256,
    timer_create = linux_base + 257,
    timer_settime = linux_base + 258,
    timer_gettime = linux_base + 259,
    timer_getoverrun = linux_base + 260,
    timer_delete = linux_base + 261,
    clock_settime = linux_base + 262,
    clock_gettime = linux_base + 263,
    clock_getres = linux_base + 264,
    clock_nanosleep = linux_base + 265,
    tgkill = linux_base + 266,
    utimes = linux_base + 267,
    mbind = linux_base + 268,
    get_mempolicy = linux_base + 269,
    set_mempolicy = linux_base + 270,
    mq_open = linux_base + 271,
    mq_unlink = linux_base + 272,
    mq_timedsend = linux_base + 273,
    mq_timedreceive = linux_base + 274,
    mq_notify = linux_base + 275,
    mq_getsetattr = linux_base + 276,
    vserver = linux_base + 277,
    waitid = linux_base + 278,
    add_key = linux_base + 280,
    request_key = linux_base + 281,
    keyctl = linux_base + 282,
    set_thread_area = linux_base + 283,
    inotify_init = linux_base + 284,
    inotify_add_watch = linux_base + 285,
    inotify_rm_watch = linux_base + 286,
    migrate_pages = linux_base + 287,
    openat = linux_base + 288,
    mkdirat = linux_base + 289,
    mknodat = linux_base + 290,
    fchownat = linux_base + 291,
    futimesat = linux_base + 292,
    fstatat64 = linux_base + 293,
    unlinkat = linux_base + 294,
    renameat = linux_base + 295,
    linkat = linux_base + 296,
    symlinkat = linux_base + 297,
    readlinkat = linux_base + 298,
    fchmodat = linux_base + 299,
    faccessat = linux_base + 300,
    pselect6 = linux_base + 301,
    ppoll = linux_base + 302,
    unshare = linux_base + 303,
    splice = linux_base + 304,
    sync_file_range = linux_base + 305,
    tee = linux_base + 306,
    vmsplice = linux_base + 307,
    move_pages = linux_base + 308,
    set_robust_list = linux_base + 309,
    get_robust_list = linux_base + 310,
    kexec_load = linux_base + 311,
    getcpu = linux_base + 312,
    epoll_pwait = linux_base + 313,
    ioprio_set = linux_base + 314,
    ioprio_get = linux_base + 315,
    utimensat = linux_base + 316,
    signalfd = linux_base + 317,
    timerfd = linux_base + 318,
    eventfd = linux_base + 319,
    fallocate = linux_base + 320,
    timerfd_create = linux_base + 321,
    timerfd_gettime = linux_base + 322,
    timerfd_settime = linux_base + 323,
    signalfd4 = linux_base + 324,
    eventfd2 = linux_base + 325,
    epoll_create1 = linux_base + 326,
    dup3 = linux_base + 327,
    pipe2 = linux_base + 328,
    inotify_init1 = linux_base + 329,
    preadv = linux_base + 330,
    pwritev = linux_base + 331,
    rt_tgsigqueueinfo = linux_base + 332,
    perf_event_open = linux_base + 333,
    accept4 = linux_base + 334,
    recvmmsg = linux_base + 335,
    fanotify_init = linux_base + 336,
    fanotify_mark = linux_base + 337,
    prlimit64 = linux_base + 338,
    name_to_handle_at = linux_base + 339,
    open_by_handle_at = linux_base + 340,
    clock_adjtime = linux_base + 341,
    syncfs = linux_base + 342,
    sendmmsg = linux_base + 343,
    setns = linux_base + 344,
    process_vm_readv = linux_base + 345,
    process_vm_writev = linux_base + 346,
    kcmp = linux_base + 347,
    finit_module = linux_base + 348,
    sched_setattr = linux_base + 349,
    sched_getattr = linux_base + 350,
    renameat2 = linux_base + 351,
    seccomp = linux_base + 352,
    getrandom = linux_base + 353,
    memfd_create = linux_base + 354,
    bpf = linux_base + 355,
    execveat = linux_base + 356,
    userfaultfd = linux_base + 357,
    membarrier = linux_base + 358,
    mlock2 = linux_base + 359,
    copy_file_range = linux_base + 360,
    preadv2 = linux_base + 361,
    pwritev2 = linux_base + 362,
    pkey_mprotect = linux_base + 363,
    pkey_alloc = linux_base + 364,
    pkey_free = linux_base + 365,
    statx = linux_base + 366,
    rseq = linux_base + 367,
    io_pgetevents = linux_base + 368,
    semget = linux_base + 393,
    semctl = linux_base + 394,
    shmget = linux_base + 395,
    shmctl = linux_base + 396,
    shmat = linux_base + 397,
    shmdt = linux_base + 398,
    msgget = linux_base + 399,
    msgsnd = linux_base + 400,
    msgrcv = linux_base + 401,
    msgctl = linux_base + 402,
    clock_gettime64 = linux_base + 403,
    clock_settime64 = linux_base + 404,
    clock_adjtime64 = linux_base + 405,
    clock_getres_time64 = linux_base + 406,
    clock_nanosleep_time64 = linux_base + 407,
    timer_gettime64 = linux_base + 408,
    timer_settime64 = linux_base + 409,
    timerfd_gettime64 = linux_base + 410,
    timerfd_settime64 = linux_base + 411,
    utimensat_time64 = linux_base + 412,
    pselect6_time64 = linux_base + 413,
    ppoll_time64 = linux_base + 414,
    io_pgetevents_time64 = linux_base + 416,
    recvmmsg_time64 = linux_base + 417,
    mq_timedsend_time64 = linux_base + 418,
    mq_timedreceive_time64 = linux_base + 419,
    semtimedop_time64 = linux_base + 420,
    rt_sigtimedwait_time64 = linux_base + 421,
    futex_time64 = linux_base + 422,
    sched_rr_get_interval_time64 = linux_base + 423,
    pidfd_send_signal = linux_base + 424,
    io_uring_setup = linux_base + 425,
    io_uring_enter = linux_base + 426,
    io_uring_register = linux_base + 427,
    open_tree = linux_base + 428,
    move_mount = linux_base + 429,
    fsopen = linux_base + 430,
    fsconfig = linux_base + 431,
    fsmount = linux_base + 432,
    fspick = linux_base + 433,
    pidfd_open = linux_base + 434,
    clone3 = linux_base + 435,
    close_range = linux_base + 436,
    openat2 = linux_base + 437,
    pidfd_getfd = linux_base + 438,
    faccessat2 = linux_base + 439,
    process_madvise = linux_base + 440,
    epoll_pwait2 = linux_base + 441,
    mount_setattr = linux_base + 442,
    quotactl_fd = linux_base + 443,
    landlock_create_ruleset = linux_base + 444,
    landlock_add_rule = linux_base + 445,
    landlock_restrict_self = linux_base + 446,
    process_mrelease = linux_base + 448,
    futex_waitv = linux_base + 449,
    set_mempolicy_home_node = linux_base + 450,
    cachestat = linux_base + 451,
    fchmodat2 = linux_base + 452,
    map_shadow_stack = linux_base + 453,
    futex_wake = linux_base + 454,
    futex_wait = linux_base + 455,
    futex_requeue = linux_base + 456,
};

pub const MipsN64 = enum(usize) {
    const linux_base = 5000;

    read = linux_base + 0,
    write = linux_base + 1,
    open = linux_base + 2,
    close = linux_base + 3,
    stat = linux_base + 4,
    fstat = linux_base + 5,
    lstat = linux_base + 6,
    poll = linux_base + 7,
    lseek = linux_base + 8,
    mmap = linux_base + 9,
    mprotect = linux_base + 10,
    munmap = linux_base + 11,
    brk = linux_base + 12,
    rt_sigaction = linux_base + 13,
    rt_sigprocmask = linux_base + 14,
    ioctl = linux_base + 15,
    pread64 = linux_base + 16,
    pwrite64 = linux_base + 17,
    readv = linux_base + 18,
    writev = linux_base + 19,
    access = linux_base + 20,
    pipe = linux_base + 21,
    newselect = linux_base + 22,
    sched_yield = linux_base + 23,
    mremap = linux_base + 24,
    msync = linux_base + 25,
    mincore = linux_base + 26,
    madvise = linux_base + 27,
    shmget = linux_base + 28,
    shmat = linux_base + 29,
    shmctl = linux_base + 30,
    dup = linux_base + 31,
    dup2 = linux_base + 32,
    pause = linux_base + 33,
    nanosleep = linux_base + 34,
    getitimer = linux_base + 35,
    setitimer = linux_base + 36,
    alarm = linux_base + 37,
    getpid = linux_base + 38,
    sendfile = linux_base + 39,
    socket = linux_base + 40,
    connect = linux_base + 41,
    accept = linux_base + 42,
    sendto = linux_base + 43,
    recvfrom = linux_base + 44,
    sendmsg = linux_base + 45,
    recvmsg = linux_base + 46,
    shutdown = linux_base + 47,
    bind = linux_base + 48,
    listen = linux_base + 49,
    getsockname = linux_base + 50,
    getpeername = linux_base + 51,
    socketpair = linux_base + 52,
    setsockopt = linux_base + 53,
    getsockopt = linux_base + 54,
    clone = linux_base + 55,
    fork = linux_base + 56,
    execve = linux_base + 57,
    exit = linux_base + 58,
    wait4 = linux_base + 59,
    kill = linux_base + 60,
    uname = linux_base + 61,
    semget = linux_base + 62,
    semop = linux_base + 63,
    semctl = linux_base + 64,
    shmdt = linux_base + 65,
    msgget = linux_base + 66,
    msgsnd = linux_base + 67,
    msgrcv = linux_base + 68,
    msgctl = linux_base + 69,
    fcntl = linux_base + 70,
    flock = linux_base + 71,
    fsync = linux_base + 72,
    fdatasync = linux_base + 73,
    truncate = linux_base + 74,
    ftruncate = linux_base + 75,
    getdents = linux_base + 76,
    getcwd = linux_base + 77,
    chdir = linux_base + 78,
    fchdir = linux_base + 79,
    rename = linux_base + 80,
    mkdir = linux_base + 81,
    rmdir = linux_base + 82,
    creat = linux_base + 83,
    link = linux_base + 84,
    unlink = linux_base + 85,
    symlink = linux_base + 86,
    readlink = linux_base + 87,
    chmod = linux_base + 88,
    fchmod = linux_base + 89,
    chown = linux_base + 90,
    fchown = linux_base + 91,
    lchown = linux_base + 92,
    umask = linux_base + 93,
    gettimeofday = linux_base + 94,
    getrlimit = linux_base + 95,
    getrusage = linux_base + 96,
    sysinfo = linux_base + 97,
    times = linux_base + 98,
    ptrace = linux_base + 99,
    getuid = linux_base + 100,
    syslog = linux_base + 101,
    getgid = linux_base + 102,
    setuid = linux_base + 103,
    setgid = linux_base + 104,
    geteuid = linux_base + 105,
    getegid = linux_base + 106,
    setpgid = linux_base + 107,
    getppid = linux_base + 108,
    getpgrp = linux_base + 109,
    setsid = linux_base + 110,
    setreuid = linux_base + 111,
    setregid = linux_base + 112,
    getgroups = linux_base + 113,
    setgroups = linux_base + 114,
    setresuid = linux_base + 115,
    getresuid = linux_base + 116,
    setresgid = linux_base + 117,
    getresgid = linux_base + 118,
    getpgid = linux_base + 119,
    setfsuid = linux_base + 120,
    setfsgid = linux_base + 121,
    getsid = linux_base + 122,
    capget = linux_base + 123,
    capset = linux_base + 124,
    rt_sigpending = linux_base + 125,
    rt_sigtimedwait = linux_base + 126,
    rt_sigqueueinfo = linux_base + 127,
    rt_sigsuspend = linux_base + 128,
    sigaltstack = linux_base + 129,
    utime = linux_base + 130,
    mknod = linux_base + 131,
    personality = linux_base + 132,
    ustat = linux_base + 133,
    statfs = linux_base + 134,
    fstatfs = linux_base + 135,
    sysfs = linux_base + 136,
    getpriority = linux_base + 137,
    setpriority = linux_base + 138,
    sched_setparam = linux_base + 139,
    sched_getparam = linux_base + 140,
    sched_setscheduler = linux_base + 141,
    sched_getscheduler = linux_base + 142,
    sched_get_priority_max = linux_base + 143,
    sched_get_priority_min = linux_base + 144,
    sched_rr_get_interval = linux_base + 145,
    mlock = linux_base + 146,
    munlock = linux_base + 147,
    mlockall = linux_base + 148,
    munlockall = linux_base + 149,
    vhangup = linux_base + 150,
    pivot_root = linux_base + 151,
    sysctl = linux_base + 152,
    prctl = linux_base + 153,
    adjtimex = linux_base + 154,
    setrlimit = linux_base + 155,
    chroot = linux_base + 156,
    sync = linux_base + 157,
    acct = linux_base + 158,
    settimeofday = linux_base + 159,
    mount = linux_base + 160,
    umount2 = linux_base + 161,
    swapon = linux_base + 162,
    swapoff = linux_base + 163,
    reboot = linux_base + 164,
    sethostname = linux_base + 165,
    setdomainname = linux_base + 166,
    create_module = linux_base + 167,
    init_module = linux_base + 168,
    delete_module = linux_base + 169,
    get_kernel_syms = linux_base + 170,
    query_module = linux_base + 171,
    quotactl = linux_base + 172,
    nfsservctl = linux_base + 173,
    getpmsg = linux_base + 174,
    putpmsg = linux_base + 175,
    afs_syscall = linux_base + 176,
    gettid = linux_base + 178,
    readahead = linux_base + 179,
    setxattr = linux_base + 180,
    lsetxattr = linux_base + 181,
    fsetxattr = linux_base + 182,
    getxattr = linux_base + 183,
    lgetxattr = linux_base + 184,
    fgetxattr = linux_base + 185,
    listxattr = linux_base + 186,
    llistxattr = linux_base + 187,
    flistxattr = linux_base + 188,
    removexattr = linux_base + 189,
    lremovexattr = linux_base + 190,
    fremovexattr = linux_base + 191,
    tkill = linux_base + 192,
    futex = linux_base + 194,
    sched_setaffinity = linux_base + 195,
    sched_getaffinity = linux_base + 196,
    cacheflush = linux_base + 197,
    cachectl = linux_base + 198,
    sysmips = linux_base + 199,
    io_setup = linux_base + 200,
    io_destroy = linux_base + 201,
    io_getevents = linux_base + 202,
    io_submit = linux_base + 203,
    io_cancel = linux_base + 204,
    exit_group = linux_base + 205,
    lookup_dcookie = linux_base + 206,
    epoll_create = linux_base + 207,
    epoll_ctl = linux_base + 208,
    epoll_wait = linux_base + 209,
    remap_file_pages = linux_base + 210,
    rt_sigreturn = linux_base + 211,
    set_tid_address = linux_base + 212,
    restart_syscall = linux_base + 213,
    semtimedop = linux_base + 214,
    fadvise64 = linux_base + 215,
    timer_create = linux_base + 216,
    timer_settime = linux_base + 217,
    timer_gettime = linux_base + 218,
    timer_getoverrun = linux_base + 219,
    timer_delete = linux_base + 220,
    clock_settime = linux_base + 221,
    clock_gettime = linux_base + 222,
    clock_getres = linux_base + 223,
    clock_nanosleep = linux_base + 224,
    tgkill = linux_base + 225,
    utimes = linux_base + 226,
    mbind = linux_base + 227,
    get_mempolicy = linux_base + 228,
    set_mempolicy = linux_base + 229,
    mq_open = linux_base + 230,
    mq_unlink = linux_base + 231,
    mq_timedsend = linux_base + 232,
    mq_timedreceive = linux_base + 233,
    mq_notify = linux_base + 234,
    mq_getsetattr = linux_base + 235,
    vserver = linux_base + 236,
    waitid = linux_base + 237,
    add_key = linux_base + 239,
    request_key = linux_base + 240,
    keyctl = linux_base + 241,
    set_thread_area = linux_base + 242,
    inotify_init = linux_base + 243,
    inotify_add_watch = linux_base + 244,
    inotify_rm_watch = linux_base + 245,
    migrate_pages = linux_base + 246,
    openat = linux_base + 247,
    mkdirat = linux_base + 248,
    mknodat = linux_base + 249,
    fchownat = linux_base + 250,
    futimesat = linux_base + 251,
    fstatat64 = linux_base + 252,
    unlinkat = linux_base + 253,
    renameat = linux_base + 254,
    linkat = linux_base + 255,
    symlinkat = linux_base + 256,
    readlinkat = linux_base + 257,
    fchmodat = linux_base + 258,
    faccessat = linux_base + 259,
    pselect6 = linux_base + 260,
    ppoll = linux_base + 261,
    unshare = linux_base + 262,
    splice = linux_base + 263,
    sync_file_range = linux_base + 264,
    tee = linux_base + 265,
    vmsplice = linux_base + 266,
    move_pages = linux_base + 267,
    set_robust_list = linux_base + 268,
    get_robust_list = linux_base + 269,
    kexec_load = linux_base + 270,
    getcpu = linux_base + 271,
    epoll_pwait = linux_base + 272,
    ioprio_set = linux_base + 273,
    ioprio_get = linux_base + 274,
    utimensat = linux_base + 275,
    signalfd = linux_base + 276,
    timerfd = linux_base + 277,
    eventfd = linux_base + 278,
    fallocate = linux_base + 279,
    timerfd_create = linux_base + 280,
    timerfd_gettime = linux_base + 281,
    timerfd_settime = linux_base + 282,
    signalfd4 = linux_base + 283,
    eventfd2 = linux_base + 284,
    epoll_create1 = linux_base + 285,
    dup3 = linux_base + 286,
    pipe2 = linux_base + 287,
    inotify_init1 = linux_base + 288,
    preadv = linux_base + 289,
    pwritev = linux_base + 290,
    rt_tgsigqueueinfo = linux_base + 291,
    perf_event_open = linux_base + 292,
    accept4 = linux_base + 293,
    recvmmsg = linux_base + 294,
    fanotify_init = linux_base + 295,
    fanotify_mark = linux_base + 296,
    prlimit64 = linux_base + 297,
    name_to_handle_at = linux_base + 298,
    open_by_handle_at = linux_base + 299,
    clock_adjtime = linux_base + 300,
    syncfs = linux_base + 301,
    sendmmsg = linux_base + 302,
    setns = linux_base + 303,
    process_vm_readv = linux_base + 304,
    process_vm_writev = linux_base + 305,
    kcmp = linux_base + 306,
    finit_module = linux_base + 307,
    getdents64 = linux_base + 308,
    sched_setattr = linux_base + 309,
    sched_getattr = linux_base + 310,
    renameat2 = linux_base + 311,
    seccomp = linux_base + 312,
    getrandom = linux_base + 313,
    memfd_create = linux_base + 314,
    bpf = linux_base + 315,
    execveat = linux_base + 316,
    userfaultfd = linux_base + 317,
    membarrier = linux_base + 318,
    mlock2 = linux_base + 319,
    copy_file_range = linux_base + 320,
    preadv2 = linux_base + 321,
    pwritev2 = linux_base + 322,
    pkey_mprotect = linux_base + 323,
    pkey_alloc = linux_base + 324,
    pkey_free = linux_base + 325,
    statx = linux_base + 326,
    rseq = linux_base + 327,
    io_pgetevents = linux_base + 328,
    pidfd_send_signal = linux_base + 424,
    io_uring_setup = linux_base + 425,
    io_uring_enter = linux_base + 426,
    io_uring_register = linux_base + 427,
    open_tree = linux_base + 428,
    move_mount = linux_base + 429,
    fsopen = linux_base + 430,
    fsconfig = linux_base + 431,
    fsmount = linux_base + 432,
    fspick = linux_base + 433,
    pidfd_open = linux_base + 434,
    clone3 = linux_base + 435,
    close_range = linux_base + 436,
    openat2 = linux_base + 437,
    pidfd_getfd = linux_base + 438,
    faccessat2 = linux_base + 439,
    process_madvise = linux_base + 440,
    epoll_pwait2 = linux_base + 441,
    mount_setattr = linux_base + 442,
    quotactl_fd = linux_base + 443,
    landlock_create_ruleset = linux_base + 444,
    landlock_add_rule = linux_base + 445,
    landlock_restrict_self = linux_base + 446,
    process_mrelease = linux_base + 448,
    futex_waitv = linux_base + 449,
    set_mempolicy_home_node = linux_base + 450,
    cachestat = linux_base + 451,
    fchmodat2 = linux_base + 452,
    map_shadow_stack = linux_base + 453,
    futex_wake = linux_base + 454,
    futex_wait = linux_base + 455,
    futex_requeue = linux_base + 456,
};

pub const MipsN32 = enum(usize) {
    const linux_base = 6000;

    read = linux_base + 0,
    write = linux_base + 1,
    open = linux_base + 2,
    close = linux_base + 3,
    stat = linux_base + 4,
    fstat = linux_base + 5,
    lstat = linux_base + 6,
    poll = linux_base + 7,
    lseek = linux_base + 8,
    mmap = linux_base + 9,
    mprotect = linux_base + 10,
    munmap = linux_base + 11,
    brk = linux_base + 12,
    rt_sigaction = linux_base + 13,
    rt_sigprocmask = linux_base + 14,
    ioctl = linux_base + 15,
    pread64 = linux_base + 16,
    pwrite64 = linux_base + 17,
    readv = linux_base + 18,
    writev = linux_base + 19,
    access = linux_base + 20,
    pipe = linux_base + 21,
    newselect = linux_base + 22,
    sched_yield = linux_base + 23,
    mremap = linux_base + 24,
    msync = linux_base + 25,
    mincore = linux_base + 26,
    madvise = linux_base + 27,
    shmget = linux_base + 28,
    shmat = linux_base + 29,
    shmctl = linux_base + 30,
    dup = linux_base + 31,
    dup2 = linux_base + 32,
    pause = linux_base + 33,
    nanosleep = linux_base + 34,
    getitimer = linux_base + 35,
    setitimer = linux_base + 36,
    alarm = linux_base + 37,
    getpid = linux_base + 38,
    sendfile = linux_base + 39,
    socket = linux_base + 40,
    connect = linux_base + 41,
    accept = linux_base + 42,
    sendto = linux_base + 43,
    recvfrom = linux_base + 44,
    sendmsg = linux_base + 45,
    recvmsg = linux_base + 46,
    shutdown = linux_base + 47,
    bind = linux_base + 48,
    listen = linux_base + 49,
    getsockname = linux_base + 50,
    getpeername = linux_base + 51,
    socketpair = linux_base + 52,
    setsockopt = linux_base + 53,
    getsockopt = linux_base + 54,
    clone = linux_base + 55,
    fork = linux_base + 56,
    execve = linux_base + 57,
    exit = linux_base + 58,
    wait4 = linux_base + 59,
    kill = linux_base + 60,
    uname = linux_base + 61,
    semget = linux_base + 62,
    semop = linux_base + 63,
    semctl = linux_base + 64,
    shmdt = linux_base + 65,
    msgget = linux_base + 66,
    msgsnd = linux_base + 67,
    msgrcv = linux_base + 68,
    msgctl = linux_base + 69,
    fcntl = linux_base + 70,
    flock = linux_base + 71,
    fsync = linux_base + 72,
    fdatasync = linux_base + 73,
    truncate = linux_base + 74,
    ftruncate = linux_base + 75,
    getdents = linux_base + 76,
    getcwd = linux_base + 77,
    chdir = linux_base + 78,
    fchdir = linux_base + 79,
    rename = linux_base + 80,
    mkdir = linux_base + 81,
    rmdir = linux_base + 82,
    creat = linux_base + 83,
    link = linux_base + 84,
    unlink = linux_base + 85,
    symlink = linux_base + 86,
    readlink = linux_base + 87,
    chmod = linux_base + 88,
    fchmod = linux_base + 89,
    chown = linux_base + 90,
    fchown = linux_base + 91,
    lchown = linux_base + 92,
    umask = linux_base + 93,
    gettimeofday = linux_base + 94,
    getrlimit = linux_base + 95,
    getrusage = linux_base + 96,
    sysinfo = linux_base + 97,
    times = linux_base + 98,
    ptrace = linux_base + 99,
    getuid = linux_base + 100,
    syslog = linux_base + 101,
    getgid = linux_base + 102,
    setuid = linux_base + 103,
    setgid = linux_base + 104,
    geteuid = linux_base + 105,
    getegid = linux_base + 106,
    setpgid = linux_base + 107,
    getppid = linux_base + 108,
    getpgrp = linux_base + 109,
    setsid = linux_base + 110,
    setreuid = linux_base + 111,
    setregid = linux_base + 112,
    getgroups = linux_base + 113,
    setgroups = linux_base + 114,
    setresuid = linux_base + 115,
    getresuid = linux_base + 116,
    setresgid = linux_base + 117,
    getresgid = linux_base + 118,
    getpgid = linux_base + 119,
    setfsuid = linux_base + 120,
    setfsgid = linux_base + 121,
    getsid = linux_base + 122,
    capget = linux_base + 123,
    capset = linux_base + 124,
    rt_sigpending = linux_base + 125,
    rt_sigtimedwait = linux_base + 126,
    rt_sigqueueinfo = linux_base + 127,
    rt_sigsuspend = linux_base + 128,
    sigaltstack = linux_base + 129,
    utime = linux_base + 130,
    mknod = linux_base + 131,
    personality = linux_base + 132,
    ustat = linux_base + 133,
    statfs = linux_base + 134,
    fstatfs = linux_base + 135,
    sysfs = linux_base + 136,
    getpriority = linux_base + 137,
    setpriority = linux_base + 138,
    sched_setparam = linux_base + 139,
    sched_getparam = linux_base + 140,
    sched_setscheduler = linux_base + 141,
    sched_getscheduler = linux_base + 142,
    sched_get_priority_max = linux_base + 143,
    sched_get_priority_min = linux_base + 144,
    sched_rr_get_interval = linux_base + 145,
    mlock = linux_base + 146,
    munlock = linux_base + 147,
    mlockall = linux_base + 148,
    munlockall = linux_base + 149,
    vhangup = linux_base + 150,
    pivot_root = linux_base + 151,
    sysctl = linux_base + 152,
    prctl = linux_base + 153,
    adjtimex = linux_base + 154,
    setrlimit = linux_base + 155,
    chroot = linux_base + 156,
    sync = linux_base + 157,
    acct = linux_base + 158,
    settimeofday = linux_base + 159,
    mount = linux_base + 160,
    umount2 = linux_base + 161,
    swapon = linux_base + 162,
    swapoff = linux_base + 163,
    reboot = linux_base + 164,
    sethostname = linux_base + 165,
    setdomainname = linux_base + 166,
    create_module = linux_base + 167,
    init_module = linux_base + 168,
    delete_module = linux_base + 169,
    get_kernel_syms = linux_base + 170,
    query_module = linux_base + 171,
    quotactl = linux_base + 172,
    nfsservctl = linux_base + 173,
    getpmsg = linux_base + 174,
    putpmsg = linux_base + 175,
    afs_syscall = linux_base + 176,
    gettid = linux_base + 178,
    readahead = linux_base + 179,
    setxattr = linux_base + 180,
    lsetxattr = linux_base + 181,
    fsetxattr = linux_base + 182,
    getxattr = linux_base + 183,
    lgetxattr = linux_base + 184,
    fgetxattr = linux_base + 185,
    listxattr = linux_base + 186,
    llistxattr = linux_base + 187,
    flistxattr = linux_base + 188,
    removexattr = linux_base + 189,
    lremovexattr = linux_base + 190,
    fremovexattr = linux_base + 191,
    tkill = linux_base + 192,
    futex = linux_base + 194,
    sched_setaffinity = linux_base + 195,
    sched_getaffinity = linux_base + 196,
    cacheflush = linux_base + 197,
    cachectl = linux_base + 198,
    sysmips = linux_base + 199,
    io_setup = linux_base + 200,
    io_destroy = linux_base + 201,
    io_getevents = linux_base + 202,
    io_submit = linux_base + 203,
    io_cancel = linux_base + 204,
    exit_group = linux_base + 205,
    lookup_dcookie = linux_base + 206,
    epoll_create = linux_base + 207,
    epoll_ctl = linux_base + 208,
    epoll_wait = linux_base + 209,
    remap_file_pages = linux_base + 210,
    rt_sigreturn = linux_base + 211,
    fcntl64 = linux_base + 212,
    set_tid_address = linux_base + 213,
    restart_syscall = linux_base + 214,
    semtimedop = linux_base + 215,
    fadvise64 = linux_base + 216,
    statfs64 = linux_base + 217,
    fstatfs64 = linux_base + 218,
    sendfile64 = linux_base + 219,
    timer_create = linux_base + 220,
    timer_settime = linux_base + 221,
    timer_gettime = linux_base + 222,
    timer_getoverrun = linux_base + 223,
    timer_delete = linux_base + 224,
    clock_settime = linux_base + 225,
    clock_gettime = linux_base + 226,
    clock_getres = linux_base + 227,
    clock_nanosleep = linux_base + 228,
    tgkill = linux_base + 229,
    utimes = linux_base + 230,
    mbind = linux_base + 231,
    get_mempolicy = linux_base + 232,
    set_mempolicy = linux_base + 233,
    mq_open = linux_base + 234,
    mq_unlink = linux_base + 235,
    mq_timedsend = linux_base + 236,
    mq_timedreceive = linux_base + 237,
    mq_notify = linux_base + 238,
    mq_getsetattr = linux_base + 239,
    vserver = linux_base + 240,
    waitid = linux_base + 241,
    add_key = linux_base + 243,
    request_key = linux_base + 244,
    keyctl = linux_base + 245,
    set_thread_area = linux_base + 246,
    inotify_init = linux_base + 247,
    inotify_add_watch = linux_base + 248,
    inotify_rm_watch = linux_base + 249,
    migrate_pages = linux_base + 250,
    openat = linux_base + 251,
    mkdirat = linux_base + 252,
    mknodat = linux_base + 253,
    fchownat = linux_base + 254,
    futimesat = linux_base + 255,
    fstatat64 = linux_base + 256,
    unlinkat = linux_base + 257,
    renameat = linux_base + 258,
    linkat = linux_base + 259,
    symlinkat = linux_base + 260,
    readlinkat = linux_base + 261,
    fchmodat = linux_base + 262,
    faccessat = linux_base + 263,
    pselect6 = linux_base + 264,
    ppoll = linux_base + 265,
    unshare = linux_base + 266,
    splice = linux_base + 267,
    sync_file_range = linux_base + 268,
    tee = linux_base + 269,
    vmsplice = linux_base + 270,
    move_pages = linux_base + 271,
    set_robust_list = linux_base + 272,
    get_robust_list = linux_base + 273,
    kexec_load = linux_base + 274,
    getcpu = linux_base + 275,
    epoll_pwait = linux_base + 276,
    ioprio_set = linux_base + 277,
    ioprio_get = linux_base + 278,
    utimensat = linux_base + 279,
    signalfd = linux_base + 280,
    timerfd = linux_base + 281,
    eventfd = linux_base + 282,
    fallocate = linux_base + 283,
    timerfd_create = linux_base + 284,
    timerfd_gettime = linux_base + 285,
    timerfd_settime = linux_base + 286,
    signalfd4 = linux_base + 287,
    eventfd2 = linux_base + 288,
    epoll_create1 = linux_base + 289,
    dup3 = linux_base + 290,
    pipe2 = linux_base + 291,
    inotify_init1 = linux_base + 292,
    preadv = linux_base + 293,
    pwritev = linux_base + 294,
    rt_tgsigqueueinfo = linux_base + 295,
    perf_event_open = linux_base + 296,
    accept4 = linux_base + 297,
    recvmmsg = linux_base + 298,
    getdents64 = linux_base + 299,
    fanotify_init = linux_base + 300,
    fanotify_mark = linux_base + 301,
    prlimit64 = linux_base + 302,
    name_to_handle_at = linux_base + 303,
    open_by_handle_at = linux_base + 304,
    clock_adjtime = linux_base + 305,
    syncfs = linux_base + 306,
    sendmmsg = linux_base + 307,
    setns = linux_base + 308,
    process_vm_readv = linux_base + 309,
    process_vm_writev = linux_base + 310,
    kcmp = linux_base + 311,
    finit_module = linux_base + 312,
    sched_setattr = linux_base + 313,
    sched_getattr = linux_base + 314,
    renameat2 = linux_base + 315,
    seccomp = linux_base + 316,
    getrandom = linux_base + 317,
    memfd_create = linux_base + 318,
    bpf = linux_base + 319,
    execveat = linux_base + 320,
    userfaultfd = linux_base + 321,
    membarrier = linux_base + 322,
    mlock2 = linux_base + 323,
    copy_file_range = linux_base + 324,
    preadv2 = linux_base + 325,
    pwritev2 = linux_base + 326,
    pkey_mprotect = linux_base + 327,
    pkey_alloc = linux_base + 328,
    pkey_free = linux_base + 329,
    statx = linux_base + 330,
    rseq = linux_base + 331,
    io_pgetevents = linux_base + 332,
    clock_gettime64 = linux_base + 403,
    clock_settime64 = linux_base + 404,
    clock_adjtime64 = linux_base + 405,
    clock_getres_time64 = linux_base + 406,
    clock_nanosleep_time64 = linux_base + 407,
    timer_gettime64 = linux_base + 408,
    timer_settime64 = linux_base + 409,
    timerfd_gettime64 = linux_base + 410,
    timerfd_settime64 = linux_base + 411,
    utimensat_time64 = linux_base + 412,
    pselect6_time64 = linux_base + 413,
    ppoll_time64 = linux_base + 414,
    io_pgetevents_time64 = linux_base + 416,
    recvmmsg_time64 = linux_base + 417,
    mq_timedsend_time64 = linux_base + 418,
    mq_timedreceive_time64 = linux_base + 419,
    semtimedop_time64 = linux_base + 420,
    rt_sigtimedwait_time64 = linux_base + 421,
    futex_time64 = linux_base + 422,
    sched_rr_get_interval_time64 = linux_base + 423,
    pidfd_send_signal = linux_base + 424,
    io_uring_setup = linux_base + 425,
    io_uring_enter = linux_base + 426,
    io_uring_register = linux_base + 427,
    open_tree = linux_base + 428,
    move_mount = linux_base + 429,
    fsopen = linux_base + 430,
    fsconfig = linux_base + 431,
    fsmount = linux_base + 432,
    fspick = linux_base + 433,
    pidfd_open = linux_base + 434,
    clone3 = linux_base + 435,
    close_range = linux_base + 436,
    openat2 = linux_base + 437,
    pidfd_getfd = linux_base + 438,
    faccessat2 = linux_base + 439,
    process_madvise = linux_base + 440,
    epoll_pwait2 = linux_base + 441,
    mount_setattr = linux_base + 442,
    quotactl_fd = linux_base + 443,
    landlock_create_ruleset = linux_base + 444,
    landlock_add_rule = linux_base + 445,
    landlock_restrict_self = linux_base + 446,
    process_mrelease = linux_base + 448,
    futex_waitv = linux_base + 449,
    set_mempolicy_home_node = linux_base + 450,
    cachestat = linux_base + 451,
    fchmodat2 = linux_base + 452,
    map_shadow_stack = linux_base + 453,
    futex_wake = linux_base + 454,
    futex_wait = linux_base + 455,
    futex_requeue = linux_base + 456,
};

pub const PowerPC = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    waitpid = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    time = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    @"break" = 17,
    oldstat = 18,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    setuid = 23,
    getuid = 24,
    stime = 25,
    ptrace = 26,
    alarm = 27,
    oldfstat = 28,
    pause = 29,
    utime = 30,
    stty = 31,
    gtty = 32,
    access = 33,
    nice = 34,
    ftime = 35,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    prof = 44,
    brk = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    lock = 53,
    ioctl = 54,
    fcntl = 55,
    mpx = 56,
    setpgid = 57,
    ulimit = 58,
    oldolduname = 59,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sgetmask = 68,
    ssetmask = 69,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrlimit = 76,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    select = 82,
    symlink = 83,
    oldlstat = 84,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    profil = 98,
    statfs = 99,
    fstatfs = 100,
    ioperm = 101,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    olduname = 109,
    iopl = 110,
    vhangup = 111,
    idle = 112,
    vm86 = 113,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    modify_ldt = 123,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    afs_syscall = 137,
    setfsuid = 138,
    setfsgid = 139,
    llseek = 140,
    getdents = 141,
    newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    query_module = 166,
    poll = 167,
    nfsservctl = 168,
    setresgid = 169,
    getresgid = 170,
    prctl = 171,
    rt_sigreturn = 172,
    rt_sigaction = 173,
    rt_sigprocmask = 174,
    rt_sigpending = 175,
    rt_sigtimedwait = 176,
    rt_sigqueueinfo = 177,
    rt_sigsuspend = 178,
    pread64 = 179,
    pwrite64 = 180,
    chown = 181,
    getcwd = 182,
    capget = 183,
    capset = 184,
    sigaltstack = 185,
    sendfile = 186,
    getpmsg = 187,
    putpmsg = 188,
    vfork = 189,
    ugetrlimit = 190,
    readahead = 191,
    mmap2 = 192,
    truncate64 = 193,
    ftruncate64 = 194,
    stat64 = 195,
    lstat64 = 196,
    fstat64 = 197,
    pciconfig_read = 198,
    pciconfig_write = 199,
    pciconfig_iobase = 200,
    multiplexer = 201,
    getdents64 = 202,
    pivot_root = 203,
    fcntl64 = 204,
    madvise = 205,
    mincore = 206,
    gettid = 207,
    tkill = 208,
    setxattr = 209,
    lsetxattr = 210,
    fsetxattr = 211,
    getxattr = 212,
    lgetxattr = 213,
    fgetxattr = 214,
    listxattr = 215,
    llistxattr = 216,
    flistxattr = 217,
    removexattr = 218,
    lremovexattr = 219,
    fremovexattr = 220,
    futex = 221,
    sched_setaffinity = 222,
    sched_getaffinity = 223,
    tuxcall = 225,
    sendfile64 = 226,
    io_setup = 227,
    io_destroy = 228,
    io_getevents = 229,
    io_submit = 230,
    io_cancel = 231,
    set_tid_address = 232,
    fadvise64 = 233,
    exit_group = 234,
    lookup_dcookie = 235,
    epoll_create = 236,
    epoll_ctl = 237,
    epoll_wait = 238,
    remap_file_pages = 239,
    timer_create = 240,
    timer_settime = 241,
    timer_gettime = 242,
    timer_getoverrun = 243,
    timer_delete = 244,
    clock_settime = 245,
    clock_gettime = 246,
    clock_getres = 247,
    clock_nanosleep = 248,
    swapcontext = 249,
    tgkill = 250,
    utimes = 251,
    statfs64 = 252,
    fstatfs64 = 253,
    fadvise64_64 = 254,
    rtas = 255,
    sys_debug_setcontext = 256,
    migrate_pages = 258,
    mbind = 259,
    get_mempolicy = 260,
    set_mempolicy = 261,
    mq_open = 262,
    mq_unlink = 263,
    mq_timedsend = 264,
    mq_timedreceive = 265,
    mq_notify = 266,
    mq_getsetattr = 267,
    kexec_load = 268,
    add_key = 269,
    request_key = 270,
    keyctl = 271,
    waitid = 272,
    ioprio_set = 273,
    ioprio_get = 274,
    inotify_init = 275,
    inotify_add_watch = 276,
    inotify_rm_watch = 277,
    spu_run = 278,
    spu_create = 279,
    pselect6 = 280,
    ppoll = 281,
    unshare = 282,
    splice = 283,
    tee = 284,
    vmsplice = 285,
    openat = 286,
    mkdirat = 287,
    mknodat = 288,
    fchownat = 289,
    futimesat = 290,
    fstatat64 = 291,
    unlinkat = 292,
    renameat = 293,
    linkat = 294,
    symlinkat = 295,
    readlinkat = 296,
    fchmodat = 297,
    faccessat = 298,
    get_robust_list = 299,
    set_robust_list = 300,
    move_pages = 301,
    getcpu = 302,
    epoll_pwait = 303,
    utimensat = 304,
    signalfd = 305,
    timerfd_create = 306,
    eventfd = 307,
    sync_file_range = 308,
    fallocate = 309,
    subpage_prot = 310,
    timerfd_settime = 311,
    timerfd_gettime = 312,
    signalfd4 = 313,
    eventfd2 = 314,
    epoll_create1 = 315,
    dup3 = 316,
    pipe2 = 317,
    inotify_init1 = 318,
    perf_event_open = 319,
    preadv = 320,
    pwritev = 321,
    rt_tgsigqueueinfo = 322,
    fanotify_init = 323,
    fanotify_mark = 324,
    prlimit64 = 325,
    socket = 326,
    bind = 327,
    connect = 328,
    listen = 329,
    accept = 330,
    getsockname = 331,
    getpeername = 332,
    socketpair = 333,
    send = 334,
    sendto = 335,
    recv = 336,
    recvfrom = 337,
    shutdown = 338,
    setsockopt = 339,
    getsockopt = 340,
    sendmsg = 341,
    recvmsg = 342,
    recvmmsg = 343,
    accept4 = 344,
    name_to_handle_at = 345,
    open_by_handle_at = 346,
    clock_adjtime = 347,
    syncfs = 348,
    sendmmsg = 349,
    setns = 350,
    process_vm_readv = 351,
    process_vm_writev = 352,
    finit_module = 353,
    kcmp = 354,
    sched_setattr = 355,
    sched_getattr = 356,
    renameat2 = 357,
    seccomp = 358,
    getrandom = 359,
    memfd_create = 360,
    bpf = 361,
    execveat = 362,
    switch_endian = 363,
    userfaultfd = 364,
    membarrier = 365,
    mlock2 = 378,
    copy_file_range = 379,
    preadv2 = 380,
    pwritev2 = 381,
    kexec_file_load = 382,
    statx = 383,
    pkey_alloc = 384,
    pkey_free = 385,
    pkey_mprotect = 386,
    rseq = 387,
    io_pgetevents = 388,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const PowerPC64 = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    waitpid = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    time = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    @"break" = 17,
    oldstat = 18,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    setuid = 23,
    getuid = 24,
    stime = 25,
    ptrace = 26,
    alarm = 27,
    oldfstat = 28,
    pause = 29,
    utime = 30,
    stty = 31,
    gtty = 32,
    access = 33,
    nice = 34,
    ftime = 35,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    prof = 44,
    brk = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    lock = 53,
    ioctl = 54,
    fcntl = 55,
    mpx = 56,
    setpgid = 57,
    ulimit = 58,
    oldolduname = 59,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sgetmask = 68,
    ssetmask = 69,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrlimit = 76,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    select = 82,
    symlink = 83,
    oldlstat = 84,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    profil = 98,
    statfs = 99,
    fstatfs = 100,
    ioperm = 101,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    olduname = 109,
    iopl = 110,
    vhangup = 111,
    idle = 112,
    vm86 = 113,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    modify_ldt = 123,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    afs_syscall = 137,
    setfsuid = 138,
    setfsgid = 139,
    llseek = 140,
    getdents = 141,
    newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    query_module = 166,
    poll = 167,
    nfsservctl = 168,
    setresgid = 169,
    getresgid = 170,
    prctl = 171,
    rt_sigreturn = 172,
    rt_sigaction = 173,
    rt_sigprocmask = 174,
    rt_sigpending = 175,
    rt_sigtimedwait = 176,
    rt_sigqueueinfo = 177,
    rt_sigsuspend = 178,
    pread64 = 179,
    pwrite64 = 180,
    chown = 181,
    getcwd = 182,
    capget = 183,
    capset = 184,
    sigaltstack = 185,
    sendfile = 186,
    getpmsg = 187,
    putpmsg = 188,
    vfork = 189,
    ugetrlimit = 190,
    readahead = 191,
    pciconfig_read = 198,
    pciconfig_write = 199,
    pciconfig_iobase = 200,
    multiplexer = 201,
    getdents64 = 202,
    pivot_root = 203,
    madvise = 205,
    mincore = 206,
    gettid = 207,
    tkill = 208,
    setxattr = 209,
    lsetxattr = 210,
    fsetxattr = 211,
    getxattr = 212,
    lgetxattr = 213,
    fgetxattr = 214,
    listxattr = 215,
    llistxattr = 216,
    flistxattr = 217,
    removexattr = 218,
    lremovexattr = 219,
    fremovexattr = 220,
    futex = 221,
    sched_setaffinity = 222,
    sched_getaffinity = 223,
    tuxcall = 225,
    io_setup = 227,
    io_destroy = 228,
    io_getevents = 229,
    io_submit = 230,
    io_cancel = 231,
    set_tid_address = 232,
    fadvise64 = 233,
    exit_group = 234,
    lookup_dcookie = 235,
    epoll_create = 236,
    epoll_ctl = 237,
    epoll_wait = 238,
    remap_file_pages = 239,
    timer_create = 240,
    timer_settime = 241,
    timer_gettime = 242,
    timer_getoverrun = 243,
    timer_delete = 244,
    clock_settime = 245,
    clock_gettime = 246,
    clock_getres = 247,
    clock_nanosleep = 248,
    swapcontext = 249,
    tgkill = 250,
    utimes = 251,
    statfs64 = 252,
    fstatfs64 = 253,
    rtas = 255,
    sys_debug_setcontext = 256,
    migrate_pages = 258,
    mbind = 259,
    get_mempolicy = 260,
    set_mempolicy = 261,
    mq_open = 262,
    mq_unlink = 263,
    mq_timedsend = 264,
    mq_timedreceive = 265,
    mq_notify = 266,
    mq_getsetattr = 267,
    kexec_load = 268,
    add_key = 269,
    request_key = 270,
    keyctl = 271,
    waitid = 272,
    ioprio_set = 273,
    ioprio_get = 274,
    inotify_init = 275,
    inotify_add_watch = 276,
    inotify_rm_watch = 277,
    spu_run = 278,
    spu_create = 279,
    pselect6 = 280,
    ppoll = 281,
    unshare = 282,
    splice = 283,
    tee = 284,
    vmsplice = 285,
    openat = 286,
    mkdirat = 287,
    mknodat = 288,
    fchownat = 289,
    futimesat = 290,
    fstatat64 = 291,
    unlinkat = 292,
    renameat = 293,
    linkat = 294,
    symlinkat = 295,
    readlinkat = 296,
    fchmodat = 297,
    faccessat = 298,
    get_robust_list = 299,
    set_robust_list = 300,
    move_pages = 301,
    getcpu = 302,
    epoll_pwait = 303,
    utimensat = 304,
    signalfd = 305,
    timerfd_create = 306,
    eventfd = 307,
    sync_file_range = 308,
    fallocate = 309,
    subpage_prot = 310,
    timerfd_settime = 311,
    timerfd_gettime = 312,
    signalfd4 = 313,
    eventfd2 = 314,
    epoll_create1 = 315,
    dup3 = 316,
    pipe2 = 317,
    inotify_init1 = 318,
    perf_event_open = 319,
    preadv = 320,
    pwritev = 321,
    rt_tgsigqueueinfo = 322,
    fanotify_init = 323,
    fanotify_mark = 324,
    prlimit64 = 325,
    socket = 326,
    bind = 327,
    connect = 328,
    listen = 329,
    accept = 330,
    getsockname = 331,
    getpeername = 332,
    socketpair = 333,
    send = 334,
    sendto = 335,
    recv = 336,
    recvfrom = 337,
    shutdown = 338,
    setsockopt = 339,
    getsockopt = 340,
    sendmsg = 341,
    recvmsg = 342,
    recvmmsg = 343,
    accept4 = 344,
    name_to_handle_at = 345,
    open_by_handle_at = 346,
    clock_adjtime = 347,
    syncfs = 348,
    sendmmsg = 349,
    setns = 350,
    process_vm_readv = 351,
    process_vm_writev = 352,
    finit_module = 353,
    kcmp = 354,
    sched_setattr = 355,
    sched_getattr = 356,
    renameat2 = 357,
    seccomp = 358,
    getrandom = 359,
    memfd_create = 360,
    bpf = 361,
    execveat = 362,
    switch_endian = 363,
    userfaultfd = 364,
    membarrier = 365,
    mlock2 = 378,
    copy_file_range = 379,
    preadv2 = 380,
    pwritev2 = 381,
    kexec_file_load = 382,
    statx = 383,
    pkey_alloc = 384,
    pkey_free = 385,
    pkey_mprotect = 386,
    rseq = 387,
    io_pgetevents = 388,
    semtimedop = 392,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const S390x = enum(usize) {
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    restart_syscall = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    mknod = 14,
    chmod = 15,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    ptrace = 26,
    alarm = 27,
    pause = 29,
    utime = 30,
    access = 33,
    nice = 34,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    brk = 45,
    signal = 48,
    acct = 51,
    umount2 = 52,
    ioctl = 54,
    fcntl = 55,
    setpgid = 57,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    symlink = 83,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    getpriority = 96,
    setpriority = 97,
    statfs = 99,
    fstatfs = 100,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    lookup_dcookie = 110,
    vhangup = 111,
    idle = 112,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    afs_syscall = 137,
    getdents = 141,
    select = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    query_module = 167,
    poll = 168,
    nfsservctl = 169,
    prctl = 172,
    rt_sigreturn = 173,
    rt_sigaction = 174,
    rt_sigprocmask = 175,
    rt_sigpending = 176,
    rt_sigtimedwait = 177,
    rt_sigqueueinfo = 178,
    rt_sigsuspend = 179,
    pread64 = 180,
    pwrite64 = 181,
    getcwd = 183,
    capget = 184,
    capset = 185,
    sigaltstack = 186,
    sendfile = 187,
    getpmsg = 188,
    putpmsg = 189,
    vfork = 190,
    getrlimit = 191,
    lchown = 198,
    getuid = 199,
    getgid = 200,
    geteuid = 201,
    getegid = 202,
    setreuid = 203,
    setregid = 204,
    getgroups = 205,
    setgroups = 206,
    fchown = 207,
    setresuid = 208,
    getresuid = 209,
    setresgid = 210,
    getresgid = 211,
    chown = 212,
    setuid = 213,
    setgid = 214,
    setfsuid = 215,
    setfsgid = 216,
    pivot_root = 217,
    mincore = 218,
    madvise = 219,
    getdents64 = 220,
    readahead = 222,
    setxattr = 224,
    lsetxattr = 225,
    fsetxattr = 226,
    getxattr = 227,
    lgetxattr = 228,
    fgetxattr = 229,
    listxattr = 230,
    llistxattr = 231,
    flistxattr = 232,
    removexattr = 233,
    lremovexattr = 234,
    fremovexattr = 235,
    gettid = 236,
    tkill = 237,
    futex = 238,
    sched_setaffinity = 239,
    sched_getaffinity = 240,
    tgkill = 241,
    io_setup = 243,
    io_destroy = 244,
    io_getevents = 245,
    io_submit = 246,
    io_cancel = 247,
    exit_group = 248,
    epoll_create = 249,
    epoll_ctl = 250,
    epoll_wait = 251,
    set_tid_address = 252,
    fadvise64 = 253,
    timer_create = 254,
    timer_settime = 255,
    timer_gettime = 256,
    timer_getoverrun = 257,
    timer_delete = 258,
    clock_settime = 259,
    clock_gettime = 260,
    clock_getres = 261,
    clock_nanosleep = 262,
    statfs64 = 265,
    fstatfs64 = 266,
    remap_file_pages = 267,
    mbind = 268,
    get_mempolicy = 269,
    set_mempolicy = 270,
    mq_open = 271,
    mq_unlink = 272,
    mq_timedsend = 273,
    mq_timedreceive = 274,
    mq_notify = 275,
    mq_getsetattr = 276,
    kexec_load = 277,
    add_key = 278,
    request_key = 279,
    keyctl = 280,
    waitid = 281,
    ioprio_set = 282,
    ioprio_get = 283,
    inotify_init = 284,
    inotify_add_watch = 285,
    inotify_rm_watch = 286,
    migrate_pages = 287,
    openat = 288,
    mkdirat = 289,
    mknodat = 290,
    fchownat = 291,
    futimesat = 292,
    fstatat64 = 293,
    unlinkat = 294,
    renameat = 295,
    linkat = 296,
    symlinkat = 297,
    readlinkat = 298,
    fchmodat = 299,
    faccessat = 300,
    pselect6 = 301,
    ppoll = 302,
    unshare = 303,
    set_robust_list = 304,
    get_robust_list = 305,
    splice = 306,
    sync_file_range = 307,
    tee = 308,
    vmsplice = 309,
    move_pages = 310,
    getcpu = 311,
    epoll_pwait = 312,
    utimes = 313,
    fallocate = 314,
    utimensat = 315,
    signalfd = 316,
    timerfd = 317,
    eventfd = 318,
    timerfd_create = 319,
    timerfd_settime = 320,
    timerfd_gettime = 321,
    signalfd4 = 322,
    eventfd2 = 323,
    inotify_init1 = 324,
    pipe2 = 325,
    dup3 = 326,
    epoll_create1 = 327,
    preadv = 328,
    pwritev = 329,
    rt_tgsigqueueinfo = 330,
    perf_event_open = 331,
    fanotify_init = 332,
    fanotify_mark = 333,
    prlimit64 = 334,
    name_to_handle_at = 335,
    open_by_handle_at = 336,
    clock_adjtime = 337,
    syncfs = 338,
    setns = 339,
    process_vm_readv = 340,
    process_vm_writev = 341,
    s390_runtime_instr = 342,
    kcmp = 343,
    finit_module = 344,
    sched_setattr = 345,
    sched_getattr = 346,
    renameat2 = 347,
    seccomp = 348,
    getrandom = 349,
    memfd_create = 350,
    bpf = 351,
    s390_pci_mmio_write = 352,
    s390_pci_mmio_read = 353,
    execveat = 354,
    userfaultfd = 355,
    membarrier = 356,
    recvmmsg = 357,
    sendmmsg = 358,
    socket = 359,
    socketpair = 360,
    bind = 361,
    connect = 362,
    listen = 363,
    accept4 = 364,
    getsockopt = 365,
    setsockopt = 366,
    getsockname = 367,
    getpeername = 368,
    sendto = 369,
    sendmsg = 370,
    recvfrom = 371,
    recvmsg = 372,
    shutdown = 373,
    mlock2 = 374,
    copy_file_range = 375,
    preadv2 = 376,
    pwritev2 = 377,
    s390_guarded_storage = 378,
    statx = 379,
    s390_sthyi = 380,
    kexec_file_load = 381,
    io_pgetevents = 382,
    rseq = 383,
    pkey_mprotect = 384,
    pkey_alloc = 385,
    pkey_free = 386,
    semtimedop = 392,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Xtensa = enum(usize) {
    spill = 0,
    xtensa = 1,
    open = 8,
    close = 9,
    dup = 10,
    dup2 = 11,
    read = 12,
    write = 13,
    select = 14,
    lseek = 15,
    poll = 16,
    llseek = 17,
    epoll_wait = 18,
    epoll_ctl = 19,
    epoll_create = 20,
    creat = 21,
    truncate = 22,
    ftruncate = 23,
    readv = 24,
    writev = 25,
    fsync = 26,
    fdatasync = 27,
    truncate64 = 28,
    ftruncate64 = 29,
    pread64 = 30,
    pwrite64 = 31,
    link = 32,
    rename = 33,
    symlink = 34,
    readlink = 35,
    mknod = 36,
    pipe = 37,
    unlink = 38,
    rmdir = 39,
    mkdir = 40,
    chdir = 41,
    fchdir = 42,
    getcwd = 43,
    chmod = 44,
    chown = 45,
    stat = 46,
    stat64 = 47,
    lchown = 48,
    lstat = 49,
    lstat64 = 50,
    fchmod = 52,
    fchown = 53,
    fstat = 54,
    fstat64 = 55,
    flock = 56,
    access = 57,
    umask = 58,
    getdents = 59,
    getdents64 = 60,
    fcntl64 = 61,
    fallocate = 62,
    fadvise64_64 = 63,
    utime = 64,
    utimes = 65,
    ioctl = 66,
    fcntl = 67,
    setxattr = 68,
    getxattr = 69,
    listxattr = 70,
    removexattr = 71,
    lsetxattr = 72,
    lgetxattr = 73,
    llistxattr = 74,
    lremovexattr = 75,
    fsetxattr = 76,
    fgetxattr = 77,
    flistxattr = 78,
    fremovexattr = 79,
    mmap2 = 80,
    munmap = 81,
    mprotect = 82,
    brk = 83,
    mlock = 84,
    munlock = 85,
    mlockall = 86,
    munlockall = 87,
    mremap = 88,
    msync = 89,
    mincore = 90,
    madvise = 91,
    shmget = 92,
    shmat = 93,
    shmctl = 94,
    shmdt = 95,
    socket = 96,
    setsockopt = 97,
    getsockopt = 98,
    shutdown = 99,
    bind = 100,
    connect = 101,
    listen = 102,
    accept = 103,
    getsockname = 104,
    getpeername = 105,
    sendmsg = 106,
    recvmsg = 107,
    send = 108,
    recv = 109,
    sendto = 110,
    recvfrom = 111,
    socketpair = 112,
    sendfile = 113,
    sendfile64 = 114,
    sendmmsg = 115,
    clone = 116,
    execve = 117,
    exit = 118,
    exit_group = 119,
    getpid = 120,
    wait4 = 121,
    waitid = 122,
    kill = 123,
    tkill = 124,
    tgkill = 125,
    set_tid_address = 126,
    gettid = 127,
    setsid = 128,
    getsid = 129,
    prctl = 130,
    personality = 131,
    getpriority = 132,
    setpriority = 133,
    setitimer = 134,
    getitimer = 135,
    setuid = 136,
    getuid = 137,
    setgid = 138,
    getgid = 139,
    geteuid = 140,
    getegid = 141,
    setreuid = 142,
    setregid = 143,
    setresuid = 144,
    getresuid = 145,
    setresgid = 146,
    getresgid = 147,
    setpgid = 148,
    getpgid = 149,
    getppid = 150,
    getpgrp = 151,
    times = 154,
    acct = 155,
    sched_setaffinity = 156,
    sched_getaffinity = 157,
    capget = 158,
    capset = 159,
    ptrace = 160,
    semtimedop = 161,
    semget = 162,
    semop = 163,
    semctl = 164,
    msgget = 166,
    msgsnd = 167,
    msgrcv = 168,
    msgctl = 169,
    umount2 = 171,
    mount = 172,
    swapon = 173,
    chroot = 174,
    pivot_root = 175,
    umount = 176,
    swapoff = 177,
    sync = 178,
    syncfs = 179,
    setfsuid = 180,
    setfsgid = 181,
    sysfs = 182,
    ustat = 183,
    statfs = 184,
    fstatfs = 185,
    statfs64 = 186,
    fstatfs64 = 187,
    setrlimit = 188,
    getrlimit = 189,
    getrusage = 190,
    futex = 191,
    gettimeofday = 192,
    settimeofday = 193,
    adjtimex = 194,
    nanosleep = 195,
    getgroups = 196,
    setgroups = 197,
    sethostname = 198,
    setdomainname = 199,
    syslog = 200,
    vhangup = 201,
    uselib = 202,
    reboot = 203,
    quotactl = 204,
    nfsservctl = 205,
    sysctl = 206,
    bdflush = 207,
    uname = 208,
    sysinfo = 209,
    init_module = 210,
    delete_module = 211,
    sched_setparam = 212,
    sched_getparam = 213,
    sched_setscheduler = 214,
    sched_getscheduler = 215,
    sched_get_priority_max = 216,
    sched_get_priority_min = 217,
    sched_rr_get_interval = 218,
    sched_yield = 219,
    restart_syscall = 223,
    sigaltstack = 224,
    rt_sigreturn = 225,
    rt_sigaction = 226,
    rt_sigprocmask = 227,
    rt_sigpending = 228,
    rt_sigtimedwait = 229,
    rt_sigqueueinfo = 230,
    rt_sigsuspend = 231,
    mq_open = 232,
    mq_unlink = 233,
    mq_timedsend = 234,
    mq_timedreceive = 235,
    mq_notify = 236,
    mq_getsetattr = 237,
    io_setup = 239,
    io_destroy = 240,
    io_submit = 241,
    io_getevents = 242,
    io_cancel = 243,
    clock_settime = 244,
    clock_gettime = 245,
    clock_getres = 246,
    clock_nanosleep = 247,
    timer_create = 248,
    timer_delete = 249,
    timer_settime = 250,
    timer_gettime = 251,
    timer_getoverrun = 252,
    lookup_dcookie = 254,
    add_key = 256,
    request_key = 257,
    keyctl = 258,
    readahead = 260,
    remap_file_pages = 261,
    migrate_pages = 262,
    mbind = 263,
    get_mempolicy = 264,
    set_mempolicy = 265,
    unshare = 266,
    move_pages = 267,
    splice = 268,
    tee = 269,
    vmsplice = 270,
    pselect6 = 272,
    ppoll = 273,
    epoll_pwait = 274,
    epoll_create1 = 275,
    inotify_init = 276,
    inotify_add_watch = 277,
    inotify_rm_watch = 278,
    inotify_init1 = 279,
    getcpu = 280,
    kexec_load = 281,
    ioprio_set = 282,
    ioprio_get = 283,
    set_robust_list = 284,
    get_robust_list = 285,
    openat = 288,
    mkdirat = 289,
    mknodat = 290,
    unlinkat = 291,
    renameat = 292,
    linkat = 293,
    symlinkat = 294,
    readlinkat = 295,
    utimensat = 296,
    fchownat = 297,
    futimesat = 298,
    fstatat64 = 299,
    fchmodat = 300,
    faccessat = 301,
    signalfd = 304,
    eventfd = 306,
    recvmmsg = 307,
    setns = 308,
    signalfd4 = 309,
    dup3 = 310,
    pipe2 = 311,
    timerfd_create = 312,
    timerfd_settime = 313,
    timerfd_gettime = 314,
    eventfd2 = 316,
    preadv = 317,
    pwritev = 318,
    fanotify_init = 320,
    fanotify_mark = 321,
    process_vm_readv = 322,
    process_vm_writev = 323,
    name_to_handle_at = 324,
    open_by_handle_at = 325,
    sync_file_range = 326,
    perf_event_open = 327,
    rt_tgsigqueueinfo = 328,
    clock_adjtime = 329,
    prlimit64 = 330,
    kcmp = 331,
    finit_module = 332,
    accept4 = 333,
    sched_setattr = 334,
    sched_getattr = 335,
    renameat2 = 336,
    seccomp = 337,
    getrandom = 338,
    memfd_create = 339,
    bpf = 340,
    execveat = 341,
    userfaultfd = 342,
    membarrier = 343,
    mlock2 = 344,
    copy_file_range = 345,
    preadv2 = 346,
    pwritev2 = 347,
    pkey_mprotect = 348,
    pkey_alloc = 349,
    pkey_free = 350,
    statx = 351,
    rseq = 352,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Arm64 = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    renameat = 38,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs = 43,
    fstatfs = 44,
    truncate = 45,
    ftruncate = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    lseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile64 = 71,
    pselect6 = 72,
    ppoll = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    fstatat64 = 79,
    fstat64 = 80,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime = 86,
    timerfd_gettime = 87,
    utimensat = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime = 108,
    timer_getoverrun = 109,
    timer_settime = 110,
    timer_delete = 111,
    clock_settime = 112,
    clock_gettime = 113,
    clock_getres = 114,
    clock_nanosleep = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrlimit = 163,
    setrlimit = 164,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend = 182,
    mq_timedreceive = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap = 222,
    fadvise64_64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents = 292,
    rseq = 293,
    kexec_file_load = 294,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const RiscV32 = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl64 = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs64 = 43,
    fstatfs64 = 44,
    truncate64 = 45,
    ftruncate64 = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    llseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile64 = 71,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    set_robust_list = 99,
    get_robust_list = 100,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_getoverrun = 109,
    timer_delete = 111,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap2 = 222,
    fadvise64_64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    rseq = 293,
    kexec_file_load = 294,
    clock_gettime = 403,
    clock_settime = 404,
    clock_adjtime = 405,
    clock_getres = 406,
    clock_nanosleep = 407,
    timer_gettime = 408,
    timer_settime = 409,
    timerfd_gettime = 410,
    timerfd_settime = 411,
    utimensat = 412,
    pselect6 = 413,
    ppoll = 414,
    io_pgetevents = 416,
    recvmmsg = 417,
    mq_timedsend = 418,
    mq_timedreceive = 419,
    semtimedop = 420,
    rt_sigtimedwait = 421,
    futex = 422,
    sched_rr_get_interval = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
    riscv_flush_icache = (244 + 15),
    riscv_hwprobe = (244 + 14),
};

pub const RiscV64 = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs = 43,
    fstatfs = 44,
    truncate = 45,
    ftruncate = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    lseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile64 = 71,
    pselect6 = 72,
    ppoll = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    fstatat64 = 79,
    fstat64 = 80,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime = 86,
    timerfd_gettime = 87,
    utimensat = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime = 108,
    timer_getoverrun = 109,
    timer_settime = 110,
    timer_delete = 111,
    clock_settime = 112,
    clock_gettime = 113,
    clock_getres = 114,
    clock_nanosleep = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrlimit = 163,
    setrlimit = 164,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend = 182,
    mq_timedreceive = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap = 222,
    fadvise64_64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents = 292,
    rseq = 293,
    kexec_file_load = 294,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
    riscv_flush_icache = (244 + 15),
    riscv_hwprobe = (244 + 14),
};

pub const LoongArch64 = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs = 43,
    fstatfs = 44,
    truncate = 45,
    ftruncate = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    lseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile64 = 71,
    pselect6 = 72,
    ppoll = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime = 86,
    timerfd_gettime = 87,
    utimensat = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime = 108,
    timer_getoverrun = 109,
    timer_settime = 110,
    timer_delete = 111,
    clock_settime = 112,
    clock_gettime = 113,
    clock_getres = 114,
    clock_nanosleep = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend = 182,
    mq_timedreceive = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap = 222,
    fadvise64_64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents = 292,
    rseq = 293,
    kexec_file_load = 294,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Arc = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents_time32 = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl64 = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    renameat = 38,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs64 = 43,
    fstatfs64 = 44,
    truncate64 = 45,
    ftruncate64 = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    llseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile64 = 71,
    pselect6_time32 = 72,
    ppoll_time32 = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    fstatat64 = 79,
    fstat64 = 80,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime32 = 86,
    timerfd_gettime32 = 87,
    utimensat_time32 = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex_time32 = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep_time32 = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime32 = 108,
    timer_getoverrun = 109,
    timer_settime32 = 110,
    timer_delete = 111,
    clock_settime32 = 112,
    clock_gettime32 = 113,
    clock_getres_time32 = 114,
    clock_nanosleep_time32 = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval_time32 = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait_time32 = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrlimit = 163,
    setrlimit = 164,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex_time32 = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend_time32 = 182,
    mq_timedreceive_time32 = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop_time32 = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap_pgoff = 222,
    fadvise64_64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg_time32 = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime32 = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents_time32 = 292,
    rseq = 293,
    kexec_file_load = 294,
    clock_gettime = 403,
    clock_settime = 404,
    clock_adjtime = 405,
    clock_getres = 406,
    clock_nanosleep = 407,
    timer_gettime = 408,
    timer_settime = 409,
    timerfd_gettime = 410,
    timerfd_settime = 411,
    utimensat = 412,
    pselect6 = 413,
    ppoll = 414,
    io_pgetevents = 416,
    recvmmsg = 417,
    mq_timedsend = 418,
    mq_timedreceive = 419,
    semtimedop = 420,
    rt_sigtimedwait = 421,
    futex = 422,
    sched_rr_get_interval = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
    cacheflush = (244 + 0),
    arc_settls = (244 + 1),
    arc_gettls = (244 + 2),
    arc_usr_cmpxchg = (244 + 4),
    sysfs = (244 + 3),
};

pub const CSky = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents_time32 = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl64 = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs64 = 43,
    fstatfs64 = 44,
    truncate64 = 45,
    ftruncate64 = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    llseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile64 = 71,
    pselect6_time32 = 72,
    ppoll_time32 = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    fstatat64 = 79,
    fstat64 = 80,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime32 = 86,
    timerfd_gettime32 = 87,
    utimensat_time32 = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex_time32 = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep_time32 = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime32 = 108,
    timer_getoverrun = 109,
    timer_settime32 = 110,
    timer_delete = 111,
    clock_settime32 = 112,
    clock_gettime32 = 113,
    clock_getres_time32 = 114,
    clock_nanosleep_time32 = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval_time32 = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait_time32 = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrlimit = 163,
    setrlimit = 164,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex_time32 = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend_time32 = 182,
    mq_timedreceive_time32 = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop_time32 = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap2 = 222,
    fadvise64_64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg_time32 = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime32 = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents_time32 = 292,
    rseq = 293,
    kexec_file_load = 294,
    clock_gettime = 403,
    clock_settime = 404,
    clock_adjtime = 405,
    clock_getres = 406,
    clock_nanosleep = 407,
    timer_gettime = 408,
    timer_settime = 409,
    timerfd_gettime = 410,
    timerfd_settime = 411,
    utimensat = 412,
    pselect6 = 413,
    ppoll = 414,
    io_pgetevents = 416,
    recvmmsg = 417,
    mq_timedsend = 418,
    mq_timedreceive = 419,
    semtimedop = 420,
    rt_sigtimedwait = 421,
    futex = 422,
    sched_rr_get_interval = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
    set_thread_area = (244 + 0),
    cacheflush = (244 + 1),
};

pub const Hexagon = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents_time32 = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl64 = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    renameat = 38,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs64 = 43,
    fstatfs64 = 44,
    truncate64 = 45,
    ftruncate64 = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    llseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile64 = 71,
    pselect6_time32 = 72,
    ppoll_time32 = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    fstatat64 = 79,
    fstat64 = 80,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime32 = 86,
    timerfd_gettime32 = 87,
    utimensat_time32 = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex_time32 = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep_time32 = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime32 = 108,
    timer_getoverrun = 109,
    timer_settime32 = 110,
    timer_delete = 111,
    clock_settime32 = 112,
    clock_gettime32 = 113,
    clock_getres_time32 = 114,
    clock_nanosleep_time32 = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval_time32 = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait_time32 = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrlimit = 163,
    setrlimit = 164,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex_time32 = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend_time32 = 182,
    mq_timedreceive_time32 = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop_time32 = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap_pgoff = 222,
    fadvise64_64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg_time32 = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime32 = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents_time32 = 292,
    rseq = 293,
    kexec_file_load = 294,
    clock_gettime = 403,
    clock_settime = 404,
    clock_adjtime = 405,
    clock_getres = 406,
    clock_nanosleep = 407,
    timer_gettime = 408,
    timer_settime = 409,
    timerfd_gettime = 410,
    timerfd_settime = 411,
    utimensat = 412,
    pselect6 = 413,
    ppoll = 414,
    io_pgetevents = 416,
    recvmmsg = 417,
    mq_timedsend = 418,
    mq_timedreceive = 419,
    semtimedop = 420,
    rt_sigtimedwait = 421,
    futex = 422,
    sched_rr_get_interval = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};
