//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    @"32bit",
    @"64bit",
    a,
    auipc_addi_fusion,
    b,
    c,
    conditional_cmv_fusion,
    d,
    disable_latency_sched_heuristic,
    dlen_factor_2,
    e,
    experimental,
    experimental_rvm23u32,
    experimental_sdext,
    experimental_sdtrig,
    experimental_smctr,
    experimental_ssctr,
    experimental_svukte,
    experimental_xqcia,
    experimental_xqciac,
    experimental_xqcicli,
    experimental_xqcicm,
    experimental_xqcics,
    experimental_xqcicsr,
    experimental_xqciint,
    experimental_xqcilo,
    experimental_xqcilsm,
    experimental_xqcisls,
    experimental_zalasr,
    experimental_zicfilp,
    experimental_zicfiss,
    experimental_zvbc32e,
    experimental_zvkgs,
    f,
    forced_atomics,
    h,
    i,
    ld_add_fusion,
    lui_addi_fusion,
    m,
    mips_p8700,
    no_default_unroll,
    no_rvc_hints,
    no_sink_splat_operands,
    no_trailing_seq_cst_fence,
    optimized_nf2_segment_load_store,
    optimized_nf3_segment_load_store,
    optimized_nf4_segment_load_store,
    optimized_nf5_segment_load_store,
    optimized_nf6_segment_load_store,
    optimized_nf7_segment_load_store,
    optimized_nf8_segment_load_store,
    optimized_zero_stride_load,
    predictable_select_expensive,
    prefer_w_inst,
    relax,
    reserve_x1,
    reserve_x10,
    reserve_x11,
    reserve_x12,
    reserve_x13,
    reserve_x14,
    reserve_x15,
    reserve_x16,
    reserve_x17,
    reserve_x18,
    reserve_x19,
    reserve_x2,
    reserve_x20,
    reserve_x21,
    reserve_x22,
    reserve_x23,
    reserve_x24,
    reserve_x25,
    reserve_x26,
    reserve_x27,
    reserve_x28,
    reserve_x29,
    reserve_x3,
    reserve_x30,
    reserve_x31,
    reserve_x4,
    reserve_x5,
    reserve_x6,
    reserve_x7,
    reserve_x8,
    reserve_x9,
    rva20s64,
    rva20u64,
    rva22s64,
    rva22u64,
    rva23s64,
    rva23u64,
    rvb23s64,
    rvb23u64,
    rvi20u32,
    rvi20u64,
    save_restore,
    sha,
    shcounterenw,
    shgatpa,
    shifted_zextw_fusion,
    short_forward_branch_opt,
    shtvala,
    shvsatpa,
    shvstvala,
    shvstvecd,
    smaia,
    smcdeleg,
    smcsrind,
    smdbltrp,
    smepmp,
    smmpm,
    smnpm,
    smrnmi,
    smstateen,
    ssaia,
    ssccfg,
    ssccptr,
    sscofpmf,
    sscounterenw,
    sscsrind,
    ssdbltrp,
    ssnpm,
    sspm,
    ssqosid,
    ssstateen,
    ssstrict,
    sstc,
    sstvala,
    sstvecd,
    ssu64xl,
    supm,
    svade,
    svadu,
    svbare,
    svinval,
    svnapot,
    svpbmt,
    svvptc,
    tagged_globals,
    unaligned_scalar_mem,
    unaligned_vector_mem,
    use_postra_scheduler,
    v,
    ventana_veyron,
    vxrm_pipeline_flush,
    xcvalu,
    xcvbi,
    xcvbitmanip,
    xcvelw,
    xcvmac,
    xcvmem,
    xcvsimd,
    xmipscmove,
    xmipslsp,
    xsfcease,
    xsfvcp,
    xsfvfnrclipxfqf,
    xsfvfwmaccqqq,
    xsfvqmaccdod,
    xsfvqmaccqoq,
    xsifivecdiscarddlone,
    xsifivecflushdlone,
    xtheadba,
    xtheadbb,
    xtheadbs,
    xtheadcmo,
    xtheadcondmov,
    xtheadfmemidx,
    xtheadmac,
    xtheadmemidx,
    xtheadmempair,
    xtheadsync,
    xtheadvdot,
    xventanacondops,
    xwchc,
    za128rs,
    za64rs,
    zaamo,
    zabha,
    zacas,
    zalrsc,
    zama16b,
    zawrs,
    zba,
    zbb,
    zbc,
    zbkb,
    zbkc,
    zbkx,
    zbs,
    zca,
    zcb,
    zcd,
    zce,
    zcf,
    zcmop,
    zcmp,
    zcmt,
    zdinx,
    zexth_fusion,
    zextw_fusion,
    zfa,
    zfbfmin,
    zfh,
    zfhmin,
    zfinx,
    zhinx,
    zhinxmin,
    zic64b,
    zicbom,
    zicbop,
    zicboz,
    ziccamoa,
    ziccif,
    zicclsm,
    ziccrse,
    zicntr,
    zicond,
    zicsr,
    zifencei,
    zihintntl,
    zihintpause,
    zihpm,
    zimop,
    zk,
    zkn,
    zknd,
    zkne,
    zknh,
    zkr,
    zks,
    zksed,
    zksh,
    zkt,
    zmmul,
    ztso,
    zvbb,
    zvbc,
    zve32f,
    zve32x,
    zve64d,
    zve64f,
    zve64x,
    zvfbfmin,
    zvfbfwma,
    zvfh,
    zvfhmin,
    zvkb,
    zvkg,
    zvkn,
    zvknc,
    zvkned,
    zvkng,
    zvknha,
    zvknhb,
    zvks,
    zvksc,
    zvksed,
    zvksg,
    zvksh,
    zvkt,
    zvl1024b,
    zvl128b,
    zvl16384b,
    zvl2048b,
    zvl256b,
    zvl32768b,
    zvl32b,
    zvl4096b,
    zvl512b,
    zvl64b,
    zvl65536b,
    zvl8192b,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    @setEvalBranchQuota(2000);
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.@"32bit")] = .{
        .llvm_name = "32bit",
        .description = "Implements RV32",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.@"64bit")] = .{
        .llvm_name = "64bit",
        .description = "Implements RV64",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.a)] = .{
        .llvm_name = "a",
        .description = "'A' (Atomic Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zaamo,
            .zalrsc,
        }),
    };
    result[@intFromEnum(Feature.auipc_addi_fusion)] = .{
        .llvm_name = "auipc-addi-fusion",
        .description = "Enable AUIPC+ADDI macrofusion",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.b)] = .{
        .llvm_name = "b",
        .description = "'B' (the collection of the Zba, Zbb, Zbs extensions)",
        .dependencies = featureSet(&[_]Feature{
            .zba,
            .zbb,
            .zbs,
        }),
    };
    result[@intFromEnum(Feature.c)] = .{
        .llvm_name = "c",
        .description = "'C' (Compressed Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.conditional_cmv_fusion)] = .{
        .llvm_name = "conditional-cmv-fusion",
        .description = "Enable branch+c.mv fusion",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.d)] = .{
        .llvm_name = "d",
        .description = "'D' (Double-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@intFromEnum(Feature.disable_latency_sched_heuristic)] = .{
        .llvm_name = "disable-latency-sched-heuristic",
        .description = "Disable latency scheduling heuristic",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.dlen_factor_2)] = .{
        .llvm_name = "dlen-factor-2",
        .description = "Vector unit DLEN(data path width) is half of VLEN",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.e)] = .{
        .llvm_name = "e",
        .description = "'E' (Embedded Instruction Set with 16 GPRs)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental)] = .{
        .llvm_name = "experimental",
        .description = "Experimental intrinsics",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_rvm23u32)] = .{
        .llvm_name = "experimental-rvm23u32",
        .description = "RISC-V experimental-rvm23u32 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"32bit",
            .b,
            .i,
            .m,
            .zce,
            .zcmop,
            .zicbop,
            .zicond,
            .zihintntl,
            .zihintpause,
            .zimop,
        }),
    };
    result[@intFromEnum(Feature.experimental_sdext)] = .{
        .llvm_name = "experimental-sdext",
        .description = "'Sdext' (External debugger)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_sdtrig)] = .{
        .llvm_name = "experimental-sdtrig",
        .description = "'Sdtrig' (Debugger triggers)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_smctr)] = .{
        .llvm_name = "experimental-smctr",
        .description = "'Smctr' (Control Transfer Records Machine Level)",
        .dependencies = featureSet(&[_]Feature{
            .sscsrind,
        }),
    };
    result[@intFromEnum(Feature.experimental_ssctr)] = .{
        .llvm_name = "experimental-ssctr",
        .description = "'Ssctr' (Control Transfer Records Supervisor Level)",
        .dependencies = featureSet(&[_]Feature{
            .sscsrind,
        }),
    };
    result[@intFromEnum(Feature.experimental_svukte)] = .{
        .llvm_name = "experimental-svukte",
        .description = "'Svukte' (Address-Independent Latency of User-Mode Faults to Supervisor Addresses)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_xqcia)] = .{
        .llvm_name = "experimental-xqcia",
        .description = "'Xqcia' (Qualcomm uC Arithmetic Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_xqciac)] = .{
        .llvm_name = "experimental-xqciac",
        .description = "'Xqciac' (Qualcomm uC Load-Store Address Calculation Extension)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
        }),
    };
    result[@intFromEnum(Feature.experimental_xqcicli)] = .{
        .llvm_name = "experimental-xqcicli",
        .description = "'Xqcicli' (Qualcomm uC Conditional Load Immediate Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_xqcicm)] = .{
        .llvm_name = "experimental-xqcicm",
        .description = "'Xqcicm' (Qualcomm uC Conditional Move Extension)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
        }),
    };
    result[@intFromEnum(Feature.experimental_xqcics)] = .{
        .llvm_name = "experimental-xqcics",
        .description = "'Xqcics' (Qualcomm uC Conditional Select Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_xqcicsr)] = .{
        .llvm_name = "experimental-xqcicsr",
        .description = "'Xqcicsr' (Qualcomm uC CSR Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_xqciint)] = .{
        .llvm_name = "experimental-xqciint",
        .description = "'Xqciint' (Qualcomm uC Interrupts Extension)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
        }),
    };
    result[@intFromEnum(Feature.experimental_xqcilo)] = .{
        .llvm_name = "experimental-xqcilo",
        .description = "'Xqcilo' (Qualcomm uC Large Offset Load Store Extension)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
        }),
    };
    result[@intFromEnum(Feature.experimental_xqcilsm)] = .{
        .llvm_name = "experimental-xqcilsm",
        .description = "'Xqcilsm' (Qualcomm uC Load Store Multiple Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_xqcisls)] = .{
        .llvm_name = "experimental-xqcisls",
        .description = "'Xqcisls' (Qualcomm uC Scaled Load Store Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_zalasr)] = .{
        .llvm_name = "experimental-zalasr",
        .description = "'Zalasr' (Load-Acquire and Store-Release Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.experimental_zicfilp)] = .{
        .llvm_name = "experimental-zicfilp",
        .description = "'Zicfilp' (Landing pad)",
        .dependencies = featureSet(&[_]Feature{
            .zicsr,
        }),
    };
    result[@intFromEnum(Feature.experimental_zicfiss)] = .{
        .llvm_name = "experimental-zicfiss",
        .description = "'Zicfiss' (Shadow stack)",
        .dependencies = featureSet(&[_]Feature{
            .zicsr,
            .zimop,
        }),
    };
    result[@intFromEnum(Feature.experimental_zvbc32e)] = .{
        .llvm_name = "experimental-zvbc32e",
        .description = "'Zvbc32e' (Vector Carryless Multiplication with 32-bits elements)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.experimental_zvkgs)] = .{
        .llvm_name = "experimental-zvkgs",
        .description = "'Zvkgs' (Vector-Scalar GCM instructions for Cryptography)",
        .dependencies = featureSet(&[_]Feature{
            .zvkg,
        }),
    };
    result[@intFromEnum(Feature.f)] = .{
        .llvm_name = "f",
        .description = "'F' (Single-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .zicsr,
        }),
    };
    result[@intFromEnum(Feature.forced_atomics)] = .{
        .llvm_name = "forced-atomics",
        .description = "Assume that lock-free native-width atomics are available",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.h)] = .{
        .llvm_name = "h",
        .description = "'H' (Hypervisor)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.i)] = .{
        .llvm_name = "i",
        .description = "'I' (Base Integer Instruction Set)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ld_add_fusion)] = .{
        .llvm_name = "ld-add-fusion",
        .description = "Enable LD+ADD macrofusion",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lui_addi_fusion)] = .{
        .llvm_name = "lui-addi-fusion",
        .description = "Enable LUI+ADDI macro fusion",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.m)] = .{
        .llvm_name = "m",
        .description = "'M' (Integer Multiplication and Division)",
        .dependencies = featureSet(&[_]Feature{
            .zmmul,
        }),
    };
    result[@intFromEnum(Feature.mips_p8700)] = .{
        .llvm_name = "mips-p8700",
        .description = "MIPS p8700 processor",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_default_unroll)] = .{
        .llvm_name = "no-default-unroll",
        .description = "Disable default unroll preference.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_rvc_hints)] = .{
        .llvm_name = "no-rvc-hints",
        .description = "Disable RVC Hint Instructions.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_sink_splat_operands)] = .{
        .llvm_name = "no-sink-splat-operands",
        .description = "Disable sink splat operands to enable .vx, .vf,.wx, and .wf instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_trailing_seq_cst_fence)] = .{
        .llvm_name = "no-trailing-seq-cst-fence",
        .description = "Disable trailing fence for seq-cst store.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_nf2_segment_load_store)] = .{
        .llvm_name = "optimized-nf2-segment-load-store",
        .description = "vlseg2eN.v and vsseg2eN.v areimplemented as a wide memory op and shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_nf3_segment_load_store)] = .{
        .llvm_name = "optimized-nf3-segment-load-store",
        .description = "vlseg3eN.v and vsseg3eN.v areimplemented as a wide memory op and shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_nf4_segment_load_store)] = .{
        .llvm_name = "optimized-nf4-segment-load-store",
        .description = "vlseg4eN.v and vsseg4eN.v areimplemented as a wide memory op and shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_nf5_segment_load_store)] = .{
        .llvm_name = "optimized-nf5-segment-load-store",
        .description = "vlseg5eN.v and vsseg5eN.v areimplemented as a wide memory op and shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_nf6_segment_load_store)] = .{
        .llvm_name = "optimized-nf6-segment-load-store",
        .description = "vlseg6eN.v and vsseg6eN.v areimplemented as a wide memory op and shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_nf7_segment_load_store)] = .{
        .llvm_name = "optimized-nf7-segment-load-store",
        .description = "vlseg7eN.v and vsseg7eN.v areimplemented as a wide memory op and shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_nf8_segment_load_store)] = .{
        .llvm_name = "optimized-nf8-segment-load-store",
        .description = "vlseg8eN.v and vsseg8eN.v areimplemented as a wide memory op and shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.optimized_zero_stride_load)] = .{
        .llvm_name = "optimized-zero-stride-load",
        .description = "Optimized (perform fewer memory operations)zero-stride vector load",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.predictable_select_expensive)] = .{
        .llvm_name = "predictable-select-expensive",
        .description = "Prefer likely predicted branches over selects",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_w_inst)] = .{
        .llvm_name = "prefer-w-inst",
        .description = "Prefer instructions with W suffix",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.relax)] = .{
        .llvm_name = "relax",
        .description = "Enable Linker relaxation.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x1)] = .{
        .llvm_name = "reserve-x1",
        .description = "Reserve X1",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x10)] = .{
        .llvm_name = "reserve-x10",
        .description = "Reserve X10",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x11)] = .{
        .llvm_name = "reserve-x11",
        .description = "Reserve X11",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x12)] = .{
        .llvm_name = "reserve-x12",
        .description = "Reserve X12",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x13)] = .{
        .llvm_name = "reserve-x13",
        .description = "Reserve X13",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x14)] = .{
        .llvm_name = "reserve-x14",
        .description = "Reserve X14",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x15)] = .{
        .llvm_name = "reserve-x15",
        .description = "Reserve X15",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x16)] = .{
        .llvm_name = "reserve-x16",
        .description = "Reserve X16",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x17)] = .{
        .llvm_name = "reserve-x17",
        .description = "Reserve X17",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x18)] = .{
        .llvm_name = "reserve-x18",
        .description = "Reserve X18",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x19)] = .{
        .llvm_name = "reserve-x19",
        .description = "Reserve X19",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x2)] = .{
        .llvm_name = "reserve-x2",
        .description = "Reserve X2",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x20)] = .{
        .llvm_name = "reserve-x20",
        .description = "Reserve X20",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x21)] = .{
        .llvm_name = "reserve-x21",
        .description = "Reserve X21",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x22)] = .{
        .llvm_name = "reserve-x22",
        .description = "Reserve X22",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x23)] = .{
        .llvm_name = "reserve-x23",
        .description = "Reserve X23",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x24)] = .{
        .llvm_name = "reserve-x24",
        .description = "Reserve X24",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x25)] = .{
        .llvm_name = "reserve-x25",
        .description = "Reserve X25",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x26)] = .{
        .llvm_name = "reserve-x26",
        .description = "Reserve X26",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x27)] = .{
        .llvm_name = "reserve-x27",
        .description = "Reserve X27",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x28)] = .{
        .llvm_name = "reserve-x28",
        .description = "Reserve X28",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x29)] = .{
        .llvm_name = "reserve-x29",
        .description = "Reserve X29",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x3)] = .{
        .llvm_name = "reserve-x3",
        .description = "Reserve X3",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x30)] = .{
        .llvm_name = "reserve-x30",
        .description = "Reserve X30",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x31)] = .{
        .llvm_name = "reserve-x31",
        .description = "Reserve X31",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x4)] = .{
        .llvm_name = "reserve-x4",
        .description = "Reserve X4",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x5)] = .{
        .llvm_name = "reserve-x5",
        .description = "Reserve X5",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x6)] = .{
        .llvm_name = "reserve-x6",
        .description = "Reserve X6",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x7)] = .{
        .llvm_name = "reserve-x7",
        .description = "Reserve X7",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x8)] = .{
        .llvm_name = "reserve-x8",
        .description = "Reserve X8",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reserve_x9)] = .{
        .llvm_name = "reserve-x9",
        .description = "Reserve X9",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.rva20s64)] = .{
        .llvm_name = "rva20s64",
        .description = "RISC-V rva20s64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .ssccptr,
            .sstvala,
            .sstvecd,
            .svade,
            .svbare,
            .za128rs,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zifencei,
        }),
    };
    result[@intFromEnum(Feature.rva20u64)] = .{
        .llvm_name = "rva20u64",
        .description = "RISC-V rva20u64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .za128rs,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
        }),
    };
    result[@intFromEnum(Feature.rva22s64)] = .{
        .llvm_name = "rva22s64",
        .description = "RISC-V rva22s64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .d,
            .i,
            .m,
            .ssccptr,
            .sscounterenw,
            .sstvala,
            .sstvecd,
            .svade,
            .svbare,
            .svinval,
            .svpbmt,
            .za64rs,
            .zfhmin,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zifencei,
            .zihintpause,
            .zihpm,
            .zkt,
        }),
    };
    result[@intFromEnum(Feature.rva22u64)] = .{
        .llvm_name = "rva22u64",
        .description = "RISC-V rva22u64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .d,
            .i,
            .m,
            .za64rs,
            .zfhmin,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zihintpause,
            .zihpm,
            .zkt,
        }),
    };
    result[@intFromEnum(Feature.rva23s64)] = .{
        .llvm_name = "rva23s64",
        .description = "RISC-V rva23s64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .i,
            .m,
            .sha,
            .ssccptr,
            .sscofpmf,
            .sscounterenw,
            .ssnpm,
            .sstc,
            .sstvala,
            .sstvecd,
            .ssu64xl,
            .supm,
            .svade,
            .svbare,
            .svinval,
            .svnapot,
            .svpbmt,
            .v,
            .za64rs,
            .zawrs,
            .zcb,
            .zcmop,
            .zfa,
            .zfhmin,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zicond,
            .zifencei,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zimop,
            .zkt,
            .zvbb,
            .zvfhmin,
            .zvkt,
        }),
    };
    result[@intFromEnum(Feature.rva23u64)] = .{
        .llvm_name = "rva23u64",
        .description = "RISC-V rva23u64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .i,
            .m,
            .supm,
            .v,
            .za64rs,
            .zawrs,
            .zcb,
            .zcmop,
            .zfa,
            .zfhmin,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zicond,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zimop,
            .zkt,
            .zvbb,
            .zvfhmin,
            .zvkt,
        }),
    };
    result[@intFromEnum(Feature.rvb23s64)] = .{
        .llvm_name = "rvb23s64",
        .description = "RISC-V rvb23s64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .d,
            .i,
            .m,
            .ssccptr,
            .sscofpmf,
            .sscounterenw,
            .sstc,
            .sstvala,
            .sstvecd,
            .ssu64xl,
            .svade,
            .svbare,
            .svinval,
            .svnapot,
            .svpbmt,
            .za64rs,
            .zawrs,
            .zcb,
            .zcmop,
            .zfa,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zicond,
            .zifencei,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zimop,
            .zkt,
        }),
    };
    result[@intFromEnum(Feature.rvb23u64)] = .{
        .llvm_name = "rvb23u64",
        .description = "RISC-V rvb23u64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .d,
            .i,
            .m,
            .za64rs,
            .zawrs,
            .zcb,
            .zcmop,
            .zfa,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zicond,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zimop,
            .zkt,
        }),
    };
    result[@intFromEnum(Feature.rvi20u32)] = .{
        .llvm_name = "rvi20u32",
        .description = "RISC-V rvi20u32 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"32bit",
            .i,
        }),
    };
    result[@intFromEnum(Feature.rvi20u64)] = .{
        .llvm_name = "rvi20u64",
        .description = "RISC-V rvi20u64 profile",
        .dependencies = featureSet(&[_]Feature{
            .@"64bit",
            .i,
        }),
    };
    result[@intFromEnum(Feature.save_restore)] = .{
        .llvm_name = "save-restore",
        .description = "Enable save/restore.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sha)] = .{
        .llvm_name = "sha",
        .description = "'Sha' (Augmented Hypervisor)",
        .dependencies = featureSet(&[_]Feature{
            .h,
            .shcounterenw,
            .shgatpa,
            .shtvala,
            .shvsatpa,
            .shvstvala,
            .shvstvecd,
            .ssstateen,
        }),
    };
    result[@intFromEnum(Feature.shcounterenw)] = .{
        .llvm_name = "shcounterenw",
        .description = "'Shcounterenw' (Support writeable hcounteren enable bit for any hpmcounter that is not read-only zero)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.shgatpa)] = .{
        .llvm_name = "shgatpa",
        .description = "'Shgatpa' (SvNNx4 mode supported for all modes supported by satp, as well as Bare)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.shifted_zextw_fusion)] = .{
        .llvm_name = "shifted-zextw-fusion",
        .description = "Enable SLLI+SRLI to be fused when computing (shifted) word zero extension",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.short_forward_branch_opt)] = .{
        .llvm_name = "short-forward-branch-opt",
        .description = "Enable short forward branch optimization",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.shtvala)] = .{
        .llvm_name = "shtvala",
        .description = "'Shtvala' (htval provides all needed values)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.shvsatpa)] = .{
        .llvm_name = "shvsatpa",
        .description = "'Shvsatpa' (vsatp supports all modes supported by satp)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.shvstvala)] = .{
        .llvm_name = "shvstvala",
        .description = "'Shvstvala' (vstval provides all needed values)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.shvstvecd)] = .{
        .llvm_name = "shvstvecd",
        .description = "'Shvstvecd' (vstvec supports Direct mode)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smaia)] = .{
        .llvm_name = "smaia",
        .description = "'Smaia' (Advanced Interrupt Architecture Machine Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smcdeleg)] = .{
        .llvm_name = "smcdeleg",
        .description = "'Smcdeleg' (Counter Delegation Machine Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smcsrind)] = .{
        .llvm_name = "smcsrind",
        .description = "'Smcsrind' (Indirect CSR Access Machine Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smdbltrp)] = .{
        .llvm_name = "smdbltrp",
        .description = "'Smdbltrp' (Double Trap Machine Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smepmp)] = .{
        .llvm_name = "smepmp",
        .description = "'Smepmp' (Enhanced Physical Memory Protection)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smmpm)] = .{
        .llvm_name = "smmpm",
        .description = "'Smmpm' (Machine-level Pointer Masking for M-mode)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smnpm)] = .{
        .llvm_name = "smnpm",
        .description = "'Smnpm' (Machine-level Pointer Masking for next lower privilege mode)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smrnmi)] = .{
        .llvm_name = "smrnmi",
        .description = "'Smrnmi' (Resumable Non-Maskable Interrupts)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smstateen)] = .{
        .llvm_name = "smstateen",
        .description = "'Smstateen' (Machine-mode view of the state-enable extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssaia)] = .{
        .llvm_name = "ssaia",
        .description = "'Ssaia' (Advanced Interrupt Architecture Supervisor Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssccfg)] = .{
        .llvm_name = "ssccfg",
        .description = "'Ssccfg' (Counter Configuration Supervisor Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssccptr)] = .{
        .llvm_name = "ssccptr",
        .description = "'Ssccptr' (Main memory supports page table reads)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sscofpmf)] = .{
        .llvm_name = "sscofpmf",
        .description = "'Sscofpmf' (Count Overflow and Mode-Based Filtering)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sscounterenw)] = .{
        .llvm_name = "sscounterenw",
        .description = "'Sscounterenw' (Support writeable scounteren enable bit for any hpmcounter that is not read-only zero)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sscsrind)] = .{
        .llvm_name = "sscsrind",
        .description = "'Sscsrind' (Indirect CSR Access Supervisor Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssdbltrp)] = .{
        .llvm_name = "ssdbltrp",
        .description = "'Ssdbltrp' (Double Trap Supervisor Level)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssnpm)] = .{
        .llvm_name = "ssnpm",
        .description = "'Ssnpm' (Supervisor-level Pointer Masking for next lower privilege mode)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sspm)] = .{
        .llvm_name = "sspm",
        .description = "'Sspm' (Indicates Supervisor-mode Pointer Masking)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssqosid)] = .{
        .llvm_name = "ssqosid",
        .description = "'Ssqosid' (Quality-of-Service (QoS) Identifiers)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssstateen)] = .{
        .llvm_name = "ssstateen",
        .description = "'Ssstateen' (Supervisor-mode view of the state-enable extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssstrict)] = .{
        .llvm_name = "ssstrict",
        .description = "'Ssstrict' (No non-conforming extensions are present)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sstc)] = .{
        .llvm_name = "sstc",
        .description = "'Sstc' (Supervisor-mode timer interrupts)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sstvala)] = .{
        .llvm_name = "sstvala",
        .description = "'Sstvala' (stval provides all needed values)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sstvecd)] = .{
        .llvm_name = "sstvecd",
        .description = "'Sstvecd' (stvec supports Direct mode)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssu64xl)] = .{
        .llvm_name = "ssu64xl",
        .description = "'Ssu64xl' (UXLEN=64 supported)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.supm)] = .{
        .llvm_name = "supm",
        .description = "'Supm' (Indicates User-mode Pointer Masking)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.svade)] = .{
        .llvm_name = "svade",
        .description = "'Svade' (Raise exceptions on improper A/D bits)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.svadu)] = .{
        .llvm_name = "svadu",
        .description = "'Svadu' (Hardware A/D updates)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.svbare)] = .{
        .llvm_name = "svbare",
        .description = "'Svbare' (satp mode Bare supported)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.svinval)] = .{
        .llvm_name = "svinval",
        .description = "'Svinval' (Fine-Grained Address-Translation Cache Invalidation)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.svnapot)] = .{
        .llvm_name = "svnapot",
        .description = "'Svnapot' (NAPOT Translation Contiguity)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.svpbmt)] = .{
        .llvm_name = "svpbmt",
        .description = "'Svpbmt' (Page-Based Memory Types)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.svvptc)] = .{
        .llvm_name = "svvptc",
        .description = "'Svvptc' (Obviating Memory-Management Instructions after Marking PTEs Valid)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.tagged_globals)] = .{
        .llvm_name = "tagged-globals",
        .description = "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.unaligned_scalar_mem)] = .{
        .llvm_name = "unaligned-scalar-mem",
        .description = "Has reasonably performant unaligned scalar loads and stores",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.unaligned_vector_mem)] = .{
        .llvm_name = "unaligned-vector-mem",
        .description = "Has reasonably performant unaligned vector loads and stores",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.use_postra_scheduler)] = .{
        .llvm_name = "use-postra-scheduler",
        .description = "Schedule again after register allocation",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.v)] = .{
        .llvm_name = "v",
        .description = "'V' (Vector Extension for Application Processors)",
        .dependencies = featureSet(&[_]Feature{
            .zve64d,
            .zvl128b,
        }),
    };
    result[@intFromEnum(Feature.ventana_veyron)] = .{
        .llvm_name = "ventana-veyron",
        .description = "Ventana Veyron-Series processors",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.vxrm_pipeline_flush)] = .{
        .llvm_name = "vxrm-pipeline-flush",
        .description = "VXRM writes causes pipeline flush",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xcvalu)] = .{
        .llvm_name = "xcvalu",
        .description = "'XCValu' (CORE-V ALU Operations)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xcvbi)] = .{
        .llvm_name = "xcvbi",
        .description = "'XCVbi' (CORE-V Immediate Branching)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xcvbitmanip)] = .{
        .llvm_name = "xcvbitmanip",
        .description = "'XCVbitmanip' (CORE-V Bit Manipulation)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xcvelw)] = .{
        .llvm_name = "xcvelw",
        .description = "'XCVelw' (CORE-V Event Load Word)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xcvmac)] = .{
        .llvm_name = "xcvmac",
        .description = "'XCVmac' (CORE-V Multiply-Accumulate)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xcvmem)] = .{
        .llvm_name = "xcvmem",
        .description = "'XCVmem' (CORE-V Post-incrementing Load & Store)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xcvsimd)] = .{
        .llvm_name = "xcvsimd",
        .description = "'XCVsimd' (CORE-V SIMD ALU)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xmipscmove)] = .{
        .llvm_name = "xmipscmove",
        .description = "'XMIPSCMove' (MIPS conditional move instruction(s) (ccmov))",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xmipslsp)] = .{
        .llvm_name = "xmipslsp",
        .description = "'XMIPSLSP' (MIPS optimization for hardware load-store bonding)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xsfcease)] = .{
        .llvm_name = "xsfcease",
        .description = "'XSfcease' (SiFive sf.cease Instruction)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xsfvcp)] = .{
        .llvm_name = "xsfvcp",
        .description = "'XSfvcp' (SiFive Custom Vector Coprocessor Interface Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.xsfvfnrclipxfqf)] = .{
        .llvm_name = "xsfvfnrclipxfqf",
        .description = "'XSfvfnrclipxfqf' (SiFive FP32-to-int8 Ranged Clip Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zve32f,
        }),
    };
    result[@intFromEnum(Feature.xsfvfwmaccqqq)] = .{
        .llvm_name = "xsfvfwmaccqqq",
        .description = "'XSfvfwmaccqqq' (SiFive Matrix Multiply Accumulate Instruction and 4-by-4))",
        .dependencies = featureSet(&[_]Feature{
            .zvfbfmin,
        }),
    };
    result[@intFromEnum(Feature.xsfvqmaccdod)] = .{
        .llvm_name = "xsfvqmaccdod",
        .description = "'XSfvqmaccdod' (SiFive Int8 Matrix Multiplication Instructions (2-by-8 and 8-by-2))",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.xsfvqmaccqoq)] = .{
        .llvm_name = "xsfvqmaccqoq",
        .description = "'XSfvqmaccqoq' (SiFive Int8 Matrix Multiplication Instructions (4-by-8 and 8-by-4))",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.xsifivecdiscarddlone)] = .{
        .llvm_name = "xsifivecdiscarddlone",
        .description = "'XSiFivecdiscarddlone' (SiFive sf.cdiscard.d.l1 Instruction)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xsifivecflushdlone)] = .{
        .llvm_name = "xsifivecflushdlone",
        .description = "'XSiFivecflushdlone' (SiFive sf.cflush.d.l1 Instruction)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadba)] = .{
        .llvm_name = "xtheadba",
        .description = "'XTHeadBa' (T-Head address calculation instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadbb)] = .{
        .llvm_name = "xtheadbb",
        .description = "'XTHeadBb' (T-Head basic bit-manipulation instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadbs)] = .{
        .llvm_name = "xtheadbs",
        .description = "'XTHeadBs' (T-Head single-bit instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadcmo)] = .{
        .llvm_name = "xtheadcmo",
        .description = "'XTHeadCmo' (T-Head cache management instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadcondmov)] = .{
        .llvm_name = "xtheadcondmov",
        .description = "'XTHeadCondMov' (T-Head conditional move instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadfmemidx)] = .{
        .llvm_name = "xtheadfmemidx",
        .description = "'XTHeadFMemIdx' (T-Head FP Indexed Memory Operations)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadmac)] = .{
        .llvm_name = "xtheadmac",
        .description = "'XTHeadMac' (T-Head Multiply-Accumulate Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadmemidx)] = .{
        .llvm_name = "xtheadmemidx",
        .description = "'XTHeadMemIdx' (T-Head Indexed Memory Operations)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadmempair)] = .{
        .llvm_name = "xtheadmempair",
        .description = "'XTHeadMemPair' (T-Head two-GPR Memory Operations)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadsync)] = .{
        .llvm_name = "xtheadsync",
        .description = "'XTHeadSync' (T-Head multicore synchronization instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xtheadvdot)] = .{
        .llvm_name = "xtheadvdot",
        .description = "'XTHeadVdot' (T-Head Vector Extensions for Dot)",
        .dependencies = featureSet(&[_]Feature{
            .v,
        }),
    };
    result[@intFromEnum(Feature.xventanacondops)] = .{
        .llvm_name = "xventanacondops",
        .description = "'XVentanaCondOps' (Ventana Conditional Ops)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xwchc)] = .{
        .llvm_name = "xwchc",
        .description = "'Xwchc' (WCH/QingKe additional compressed opcodes)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.za128rs)] = .{
        .llvm_name = "za128rs",
        .description = "'Za128rs' (Reservation Set Size of at Most 128 Bytes)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.za64rs)] = .{
        .llvm_name = "za64rs",
        .description = "'Za64rs' (Reservation Set Size of at Most 64 Bytes)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zaamo)] = .{
        .llvm_name = "zaamo",
        .description = "'Zaamo' (Atomic Memory Operations)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zabha)] = .{
        .llvm_name = "zabha",
        .description = "'Zabha' (Byte and Halfword Atomic Memory Operations)",
        .dependencies = featureSet(&[_]Feature{
            .zaamo,
        }),
    };
    result[@intFromEnum(Feature.zacas)] = .{
        .llvm_name = "zacas",
        .description = "'Zacas' (Atomic Compare-And-Swap Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zaamo,
        }),
    };
    result[@intFromEnum(Feature.zalrsc)] = .{
        .llvm_name = "zalrsc",
        .description = "'Zalrsc' (Load-Reserved/Store-Conditional)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zama16b)] = .{
        .llvm_name = "zama16b",
        .description = "'Zama16b' (Atomic 16-byte misaligned loads, stores and AMOs)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zawrs)] = .{
        .llvm_name = "zawrs",
        .description = "'Zawrs' (Wait on Reservation Set)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zba)] = .{
        .llvm_name = "zba",
        .description = "'Zba' (Address Generation Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zbb)] = .{
        .llvm_name = "zbb",
        .description = "'Zbb' (Basic Bit-Manipulation)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zbc)] = .{
        .llvm_name = "zbc",
        .description = "'Zbc' (Carry-Less Multiplication)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zbkb)] = .{
        .llvm_name = "zbkb",
        .description = "'Zbkb' (Bitmanip instructions for Cryptography)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zbkc)] = .{
        .llvm_name = "zbkc",
        .description = "'Zbkc' (Carry-less multiply instructions for Cryptography)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zbkx)] = .{
        .llvm_name = "zbkx",
        .description = "'Zbkx' (Crossbar permutation instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zbs)] = .{
        .llvm_name = "zbs",
        .description = "'Zbs' (Single-Bit Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zca)] = .{
        .llvm_name = "zca",
        .description = "'Zca' (part of the C extension, excluding compressed floating point loads/stores)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zcb)] = .{
        .llvm_name = "zcb",
        .description = "'Zcb' (Compressed basic bit manipulation instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
        }),
    };
    result[@intFromEnum(Feature.zcd)] = .{
        .llvm_name = "zcd",
        .description = "'Zcd' (Compressed Double-Precision Floating-Point Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .d,
            .zca,
        }),
    };
    result[@intFromEnum(Feature.zce)] = .{
        .llvm_name = "zce",
        .description = "'Zce' (Compressed extensions for microcontrollers)",
        .dependencies = featureSet(&[_]Feature{
            .zcb,
            .zcmp,
            .zcmt,
        }),
    };
    result[@intFromEnum(Feature.zcf)] = .{
        .llvm_name = "zcf",
        .description = "'Zcf' (Compressed Single-Precision Floating-Point Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .f,
            .zca,
        }),
    };
    result[@intFromEnum(Feature.zcmop)] = .{
        .llvm_name = "zcmop",
        .description = "'Zcmop' (Compressed May-Be-Operations)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
        }),
    };
    result[@intFromEnum(Feature.zcmp)] = .{
        .llvm_name = "zcmp",
        .description = "'Zcmp' (sequenced instructions for code-size reduction)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
        }),
    };
    result[@intFromEnum(Feature.zcmt)] = .{
        .llvm_name = "zcmt",
        .description = "'Zcmt' (table jump instructions for code-size reduction)",
        .dependencies = featureSet(&[_]Feature{
            .zca,
            .zicsr,
        }),
    };
    result[@intFromEnum(Feature.zdinx)] = .{
        .llvm_name = "zdinx",
        .description = "'Zdinx' (Double in Integer)",
        .dependencies = featureSet(&[_]Feature{
            .zfinx,
        }),
    };
    result[@intFromEnum(Feature.zexth_fusion)] = .{
        .llvm_name = "zexth-fusion",
        .description = "Enable SLLI+SRLI to be fused to zero extension of halfword",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zextw_fusion)] = .{
        .llvm_name = "zextw-fusion",
        .description = "Enable SLLI+SRLI to be fused to zero extension of word",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zfa)] = .{
        .llvm_name = "zfa",
        .description = "'Zfa' (Additional Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@intFromEnum(Feature.zfbfmin)] = .{
        .llvm_name = "zfbfmin",
        .description = "'Zfbfmin' (Scalar BF16 Converts)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@intFromEnum(Feature.zfh)] = .{
        .llvm_name = "zfh",
        .description = "'Zfh' (Half-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .zfhmin,
        }),
    };
    result[@intFromEnum(Feature.zfhmin)] = .{
        .llvm_name = "zfhmin",
        .description = "'Zfhmin' (Half-Precision Floating-Point Minimal)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@intFromEnum(Feature.zfinx)] = .{
        .llvm_name = "zfinx",
        .description = "'Zfinx' (Float in Integer)",
        .dependencies = featureSet(&[_]Feature{
            .zicsr,
        }),
    };
    result[@intFromEnum(Feature.zhinx)] = .{
        .llvm_name = "zhinx",
        .description = "'Zhinx' (Half Float in Integer)",
        .dependencies = featureSet(&[_]Feature{
            .zhinxmin,
        }),
    };
    result[@intFromEnum(Feature.zhinxmin)] = .{
        .llvm_name = "zhinxmin",
        .description = "'Zhinxmin' (Half Float in Integer Minimal)",
        .dependencies = featureSet(&[_]Feature{
            .zfinx,
        }),
    };
    result[@intFromEnum(Feature.zic64b)] = .{
        .llvm_name = "zic64b",
        .description = "'Zic64b' (Cache Block Size Is 64 Bytes)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zicbom)] = .{
        .llvm_name = "zicbom",
        .description = "'Zicbom' (Cache-Block Management Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zicbop)] = .{
        .llvm_name = "zicbop",
        .description = "'Zicbop' (Cache-Block Prefetch Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zicboz)] = .{
        .llvm_name = "zicboz",
        .description = "'Zicboz' (Cache-Block Zero Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ziccamoa)] = .{
        .llvm_name = "ziccamoa",
        .description = "'Ziccamoa' (Main Memory Supports All Atomics in A)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ziccif)] = .{
        .llvm_name = "ziccif",
        .description = "'Ziccif' (Main Memory Supports Instruction Fetch with Atomicity Requirement)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zicclsm)] = .{
        .llvm_name = "zicclsm",
        .description = "'Zicclsm' (Main Memory Supports Misaligned Loads/Stores)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ziccrse)] = .{
        .llvm_name = "ziccrse",
        .description = "'Ziccrse' (Main Memory Supports Forward Progress on LR/SC Sequences)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zicntr)] = .{
        .llvm_name = "zicntr",
        .description = "'Zicntr' (Base Counters and Timers)",
        .dependencies = featureSet(&[_]Feature{
            .zicsr,
        }),
    };
    result[@intFromEnum(Feature.zicond)] = .{
        .llvm_name = "zicond",
        .description = "'Zicond' (Integer Conditional Operations)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zicsr)] = .{
        .llvm_name = "zicsr",
        .description = "'Zicsr' (CSRs)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zifencei)] = .{
        .llvm_name = "zifencei",
        .description = "'Zifencei' (fence.i)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zihintntl)] = .{
        .llvm_name = "zihintntl",
        .description = "'Zihintntl' (Non-Temporal Locality Hints)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zihintpause)] = .{
        .llvm_name = "zihintpause",
        .description = "'Zihintpause' (Pause Hint)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zihpm)] = .{
        .llvm_name = "zihpm",
        .description = "'Zihpm' (Hardware Performance Counters)",
        .dependencies = featureSet(&[_]Feature{
            .zicsr,
        }),
    };
    result[@intFromEnum(Feature.zimop)] = .{
        .llvm_name = "zimop",
        .description = "'Zimop' (May-Be-Operations)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zk)] = .{
        .llvm_name = "zk",
        .description = "'Zk' (Standard scalar cryptography extension)",
        .dependencies = featureSet(&[_]Feature{
            .zkn,
            .zkr,
            .zkt,
        }),
    };
    result[@intFromEnum(Feature.zkn)] = .{
        .llvm_name = "zkn",
        .description = "'Zkn' (NIST Algorithm Suite)",
        .dependencies = featureSet(&[_]Feature{
            .zbkb,
            .zbkc,
            .zbkx,
            .zknd,
            .zkne,
            .zknh,
        }),
    };
    result[@intFromEnum(Feature.zknd)] = .{
        .llvm_name = "zknd",
        .description = "'Zknd' (NIST Suite: AES Decryption)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zkne)] = .{
        .llvm_name = "zkne",
        .description = "'Zkne' (NIST Suite: AES Encryption)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zknh)] = .{
        .llvm_name = "zknh",
        .description = "'Zknh' (NIST Suite: Hash Function Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zkr)] = .{
        .llvm_name = "zkr",
        .description = "'Zkr' (Entropy Source Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zks)] = .{
        .llvm_name = "zks",
        .description = "'Zks' (ShangMi Algorithm Suite)",
        .dependencies = featureSet(&[_]Feature{
            .zbkb,
            .zbkc,
            .zbkx,
            .zksed,
            .zksh,
        }),
    };
    result[@intFromEnum(Feature.zksed)] = .{
        .llvm_name = "zksed",
        .description = "'Zksed' (ShangMi Suite: SM4 Block Cipher Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zksh)] = .{
        .llvm_name = "zksh",
        .description = "'Zksh' (ShangMi Suite: SM3 Hash Function Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zkt)] = .{
        .llvm_name = "zkt",
        .description = "'Zkt' (Data Independent Execution Latency)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zmmul)] = .{
        .llvm_name = "zmmul",
        .description = "'Zmmul' (Integer Multiplication)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ztso)] = .{
        .llvm_name = "ztso",
        .description = "'Ztso' (Memory Model - Total Store Order)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zvbb)] = .{
        .llvm_name = "zvbb",
        .description = "'Zvbb' (Vector basic bit-manipulation instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zvkb,
        }),
    };
    result[@intFromEnum(Feature.zvbc)] = .{
        .llvm_name = "zvbc",
        .description = "'Zvbc' (Vector Carryless Multiplication)",
        .dependencies = featureSet(&[_]Feature{
            .zve64x,
        }),
    };
    result[@intFromEnum(Feature.zve32f)] = .{
        .llvm_name = "zve32f",
        .description = "'Zve32f' (Vector Extensions for Embedded Processors with maximal 32 EEW and F extension)",
        .dependencies = featureSet(&[_]Feature{
            .f,
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.zve32x)] = .{
        .llvm_name = "zve32x",
        .description = "'Zve32x' (Vector Extensions for Embedded Processors with maximal 32 EEW)",
        .dependencies = featureSet(&[_]Feature{
            .zicsr,
            .zvl32b,
        }),
    };
    result[@intFromEnum(Feature.zve64d)] = .{
        .llvm_name = "zve64d",
        .description = "'Zve64d' (Vector Extensions for Embedded Processors with maximal 64 EEW, F and D extension)",
        .dependencies = featureSet(&[_]Feature{
            .d,
            .zve64f,
        }),
    };
    result[@intFromEnum(Feature.zve64f)] = .{
        .llvm_name = "zve64f",
        .description = "'Zve64f' (Vector Extensions for Embedded Processors with maximal 64 EEW and F extension)",
        .dependencies = featureSet(&[_]Feature{
            .zve32f,
            .zve64x,
        }),
    };
    result[@intFromEnum(Feature.zve64x)] = .{
        .llvm_name = "zve64x",
        .description = "'Zve64x' (Vector Extensions for Embedded Processors with maximal 64 EEW)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
            .zvl64b,
        }),
    };
    result[@intFromEnum(Feature.zvfbfmin)] = .{
        .llvm_name = "zvfbfmin",
        .description = "'Zvfbfmin' (Vector BF16 Converts)",
        .dependencies = featureSet(&[_]Feature{
            .zve32f,
        }),
    };
    result[@intFromEnum(Feature.zvfbfwma)] = .{
        .llvm_name = "zvfbfwma",
        .description = "'Zvfbfwma' (Vector BF16 widening mul-add)",
        .dependencies = featureSet(&[_]Feature{
            .zfbfmin,
            .zvfbfmin,
        }),
    };
    result[@intFromEnum(Feature.zvfh)] = .{
        .llvm_name = "zvfh",
        .description = "'Zvfh' (Vector Half-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .zfhmin,
            .zvfhmin,
        }),
    };
    result[@intFromEnum(Feature.zvfhmin)] = .{
        .llvm_name = "zvfhmin",
        .description = "'Zvfhmin' (Vector Half-Precision Floating-Point Minimal)",
        .dependencies = featureSet(&[_]Feature{
            .zve32f,
        }),
    };
    result[@intFromEnum(Feature.zvkb)] = .{
        .llvm_name = "zvkb",
        .description = "'Zvkb' (Vector Bit-manipulation used in Cryptography)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.zvkg)] = .{
        .llvm_name = "zvkg",
        .description = "'Zvkg' (Vector GCM instructions for Cryptography)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.zvkn)] = .{
        .llvm_name = "zvkn",
        .description = "'Zvkn' (shorthand for 'Zvkned', 'Zvknhb', 'Zvkb', and 'Zvkt')",
        .dependencies = featureSet(&[_]Feature{
            .zvkb,
            .zvkned,
            .zvknhb,
            .zvkt,
        }),
    };
    result[@intFromEnum(Feature.zvknc)] = .{
        .llvm_name = "zvknc",
        .description = "'Zvknc' (shorthand for 'Zvknc' and 'Zvbc')",
        .dependencies = featureSet(&[_]Feature{
            .zvbc,
            .zvkn,
        }),
    };
    result[@intFromEnum(Feature.zvkned)] = .{
        .llvm_name = "zvkned",
        .description = "'Zvkned' (Vector AES Encryption & Decryption (Single Round))",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.zvkng)] = .{
        .llvm_name = "zvkng",
        .description = "'Zvkng' (shorthand for 'Zvkn' and 'Zvkg')",
        .dependencies = featureSet(&[_]Feature{
            .zvkg,
            .zvkn,
        }),
    };
    result[@intFromEnum(Feature.zvknha)] = .{
        .llvm_name = "zvknha",
        .description = "'Zvknha' (Vector SHA-2 (SHA-256 only))",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.zvknhb)] = .{
        .llvm_name = "zvknhb",
        .description = "'Zvknhb' (Vector SHA-2 (SHA-256 and SHA-512))",
        .dependencies = featureSet(&[_]Feature{
            .zve64x,
        }),
    };
    result[@intFromEnum(Feature.zvks)] = .{
        .llvm_name = "zvks",
        .description = "'Zvks' (shorthand for 'Zvksed', 'Zvksh', 'Zvkb', and 'Zvkt')",
        .dependencies = featureSet(&[_]Feature{
            .zvkb,
            .zvksed,
            .zvksh,
            .zvkt,
        }),
    };
    result[@intFromEnum(Feature.zvksc)] = .{
        .llvm_name = "zvksc",
        .description = "'Zvksc' (shorthand for 'Zvks' and 'Zvbc')",
        .dependencies = featureSet(&[_]Feature{
            .zvbc,
            .zvks,
        }),
    };
    result[@intFromEnum(Feature.zvksed)] = .{
        .llvm_name = "zvksed",
        .description = "'Zvksed' (SM4 Block Cipher Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.zvksg)] = .{
        .llvm_name = "zvksg",
        .description = "'Zvksg' (shorthand for 'Zvks' and 'Zvkg')",
        .dependencies = featureSet(&[_]Feature{
            .zvkg,
            .zvks,
        }),
    };
    result[@intFromEnum(Feature.zvksh)] = .{
        .llvm_name = "zvksh",
        .description = "'Zvksh' (SM3 Hash Function Instructions)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@intFromEnum(Feature.zvkt)] = .{
        .llvm_name = "zvkt",
        .description = "'Zvkt' (Vector Data-Independent Execution Latency)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zvl1024b)] = .{
        .llvm_name = "zvl1024b",
        .description = "'Zvl1024b' (Minimum Vector Length 1024)",
        .dependencies = featureSet(&[_]Feature{
            .zvl512b,
        }),
    };
    result[@intFromEnum(Feature.zvl128b)] = .{
        .llvm_name = "zvl128b",
        .description = "'Zvl128b' (Minimum Vector Length 128)",
        .dependencies = featureSet(&[_]Feature{
            .zvl64b,
        }),
    };
    result[@intFromEnum(Feature.zvl16384b)] = .{
        .llvm_name = "zvl16384b",
        .description = "'Zvl16384b' (Minimum Vector Length 16384)",
        .dependencies = featureSet(&[_]Feature{
            .zvl8192b,
        }),
    };
    result[@intFromEnum(Feature.zvl2048b)] = .{
        .llvm_name = "zvl2048b",
        .description = "'Zvl2048b' (Minimum Vector Length 2048)",
        .dependencies = featureSet(&[_]Feature{
            .zvl1024b,
        }),
    };
    result[@intFromEnum(Feature.zvl256b)] = .{
        .llvm_name = "zvl256b",
        .description = "'Zvl256b' (Minimum Vector Length 256)",
        .dependencies = featureSet(&[_]Feature{
            .zvl128b,
        }),
    };
    result[@intFromEnum(Feature.zvl32768b)] = .{
        .llvm_name = "zvl32768b",
        .description = "'Zvl32768b' (Minimum Vector Length 32768)",
        .dependencies = featureSet(&[_]Feature{
            .zvl16384b,
        }),
    };
    result[@intFromEnum(Feature.zvl32b)] = .{
        .llvm_name = "zvl32b",
        .description = "'Zvl32b' (Minimum Vector Length 32)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.zvl4096b)] = .{
        .llvm_name = "zvl4096b",
        .description = "'Zvl4096b' (Minimum Vector Length 4096)",
        .dependencies = featureSet(&[_]Feature{
            .zvl2048b,
        }),
    };
    result[@intFromEnum(Feature.zvl512b)] = .{
        .llvm_name = "zvl512b",
        .description = "'Zvl512b' (Minimum Vector Length 512)",
        .dependencies = featureSet(&[_]Feature{
            .zvl256b,
        }),
    };
    result[@intFromEnum(Feature.zvl64b)] = .{
        .llvm_name = "zvl64b",
        .description = "'Zvl64b' (Minimum Vector Length 64)",
        .dependencies = featureSet(&[_]Feature{
            .zvl32b,
        }),
    };
    result[@intFromEnum(Feature.zvl65536b)] = .{
        .llvm_name = "zvl65536b",
        .description = "'Zvl65536b' (Minimum Vector Length 65536)",
        .dependencies = featureSet(&[_]Feature{
            .zvl32768b,
        }),
    };
    result[@intFromEnum(Feature.zvl8192b)] = .{
        .llvm_name = "zvl8192b",
        .description = "'Zvl8192b' (Minimum Vector Length 8192)",
        .dependencies = featureSet(&[_]Feature{
            .zvl4096b,
        }),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const baseline_rv32: CpuModel = .{
        .name = "baseline_rv32",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .d,
            .i,
            .m,
        }),
    };
    pub const baseline_rv64: CpuModel = .{
        .name = "baseline_rv64",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
        }),
    };
    pub const generic: CpuModel = .{
        .name = "generic",
        .llvm_name = "generic",
        .features = featureSet(&[_]Feature{}),
    };
    pub const generic_rv32: CpuModel = .{
        .name = "generic_rv32",
        .llvm_name = "generic-rv32",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .i,
            .optimized_nf2_segment_load_store,
        }),
    };
    pub const generic_rv64: CpuModel = .{
        .name = "generic_rv64",
        .llvm_name = "generic-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .i,
            .optimized_nf2_segment_load_store,
        }),
    };
    pub const mips_p8700: CpuModel = .{
        .name = "mips_p8700",
        .llvm_name = "mips-p8700",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .mips_p8700,
            .xmipscmove,
            .xmipslsp,
            .zba,
            .zbb,
            .zifencei,
        }),
    };
    pub const rocket: CpuModel = .{
        .name = "rocket",
        .llvm_name = "rocket",
        .features = featureSet(&[_]Feature{}),
    };
    pub const rocket_rv32: CpuModel = .{
        .name = "rocket_rv32",
        .llvm_name = "rocket-rv32",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .i,
            .zicsr,
            .zifencei,
        }),
    };
    pub const rocket_rv64: CpuModel = .{
        .name = "rocket_rv64",
        .llvm_name = "rocket-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .i,
            .zicsr,
            .zifencei,
        }),
    };
    pub const rp2350_hazard3: CpuModel = .{
        .name = "rp2350_hazard3",
        .llvm_name = "rp2350-hazard3",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .i,
            .m,
            .zba,
            .zbb,
            .zbkb,
            .zbs,
            .zcb,
            .zcmp,
            .zicsr,
            .zifencei,
        }),
    };
    pub const sifive_7_series: CpuModel = .{
        .name = "sifive_7_series",
        .llvm_name = "sifive-7-series",
        .features = featureSet(&[_]Feature{
            .no_default_unroll,
            .short_forward_branch_opt,
            .use_postra_scheduler,
        }),
    };
    pub const sifive_e20: CpuModel = .{
        .name = "sifive_e20",
        .llvm_name = "sifive-e20",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .c,
            .i,
            .m,
            .zicsr,
            .zifencei,
        }),
    };
    pub const sifive_e21: CpuModel = .{
        .name = "sifive_e21",
        .llvm_name = "sifive-e21",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .i,
            .m,
            .zicsr,
            .zifencei,
        }),
    };
    pub const sifive_e24: CpuModel = .{
        .name = "sifive_e24",
        .llvm_name = "sifive-e24",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .f,
            .i,
            .m,
            .zifencei,
        }),
    };
    pub const sifive_e31: CpuModel = .{
        .name = "sifive_e31",
        .llvm_name = "sifive-e31",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .i,
            .m,
            .zicsr,
            .zifencei,
        }),
    };
    pub const sifive_e34: CpuModel = .{
        .name = "sifive_e34",
        .llvm_name = "sifive-e34",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .f,
            .i,
            .m,
            .zifencei,
        }),
    };
    pub const sifive_e76: CpuModel = .{
        .name = "sifive_e76",
        .llvm_name = "sifive-e76",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .f,
            .i,
            .m,
            .no_default_unroll,
            .short_forward_branch_opt,
            .use_postra_scheduler,
            .zifencei,
        }),
    };
    pub const sifive_p450: CpuModel = .{
        .name = "sifive_p450",
        .llvm_name = "sifive-p450",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .auipc_addi_fusion,
            .b,
            .c,
            .conditional_cmv_fusion,
            .d,
            .i,
            .lui_addi_fusion,
            .m,
            .no_default_unroll,
            .unaligned_scalar_mem,
            .unaligned_vector_mem,
            .use_postra_scheduler,
            .za64rs,
            .zfhmin,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zifencei,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zkt,
        }),
    };
    pub const sifive_p470: CpuModel = .{
        .name = "sifive_p470",
        .llvm_name = "sifive-p470",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .auipc_addi_fusion,
            .b,
            .c,
            .conditional_cmv_fusion,
            .i,
            .lui_addi_fusion,
            .m,
            .no_default_unroll,
            .no_sink_splat_operands,
            .unaligned_scalar_mem,
            .unaligned_vector_mem,
            .use_postra_scheduler,
            .v,
            .vxrm_pipeline_flush,
            .xsifivecdiscarddlone,
            .xsifivecflushdlone,
            .za64rs,
            .zfhmin,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zifencei,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zkt,
            .zvbb,
            .zvknc,
            .zvkng,
            .zvksc,
            .zvksg,
        }),
    };
    pub const sifive_p550: CpuModel = .{
        .name = "sifive_p550",
        .llvm_name = "sifive-p550",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .auipc_addi_fusion,
            .c,
            .conditional_cmv_fusion,
            .d,
            .i,
            .lui_addi_fusion,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .zba,
            .zbb,
            .zifencei,
        }),
    };
    pub const sifive_p670: CpuModel = .{
        .name = "sifive_p670",
        .llvm_name = "sifive-p670",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .auipc_addi_fusion,
            .b,
            .c,
            .conditional_cmv_fusion,
            .i,
            .lui_addi_fusion,
            .m,
            .no_default_unroll,
            .no_sink_splat_operands,
            .unaligned_scalar_mem,
            .unaligned_vector_mem,
            .use_postra_scheduler,
            .v,
            .vxrm_pipeline_flush,
            .za64rs,
            .zfhmin,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zifencei,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zkt,
            .zvbb,
            .zvknc,
            .zvkng,
            .zvksc,
            .zvksg,
        }),
    };
    pub const sifive_s21: CpuModel = .{
        .name = "sifive_s21",
        .llvm_name = "sifive-s21",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .i,
            .m,
            .zicsr,
            .zifencei,
        }),
    };
    pub const sifive_s51: CpuModel = .{
        .name = "sifive_s51",
        .llvm_name = "sifive-s51",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .i,
            .m,
            .zicsr,
            .zifencei,
        }),
    };
    pub const sifive_s54: CpuModel = .{
        .name = "sifive_s54",
        .llvm_name = "sifive-s54",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .zifencei,
        }),
    };
    pub const sifive_s76: CpuModel = .{
        .name = "sifive_s76",
        .llvm_name = "sifive-s76",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .no_default_unroll,
            .short_forward_branch_opt,
            .use_postra_scheduler,
            .zifencei,
            .zihintpause,
        }),
    };
    pub const sifive_u54: CpuModel = .{
        .name = "sifive_u54",
        .llvm_name = "sifive-u54",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .zifencei,
        }),
    };
    pub const sifive_u74: CpuModel = .{
        .name = "sifive_u74",
        .llvm_name = "sifive-u74",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .no_default_unroll,
            .short_forward_branch_opt,
            .use_postra_scheduler,
            .zifencei,
        }),
    };
    pub const sifive_x280: CpuModel = .{
        .name = "sifive_x280",
        .llvm_name = "sifive-x280",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .dlen_factor_2,
            .i,
            .m,
            .no_default_unroll,
            .optimized_nf2_segment_load_store,
            .optimized_zero_stride_load,
            .short_forward_branch_opt,
            .use_postra_scheduler,
            .v,
            .zba,
            .zbb,
            .zfh,
            .zifencei,
            .zvfh,
            .zvl512b,
        }),
    };
    pub const spacemit_x60: CpuModel = .{
        .name = "spacemit_x60",
        .llvm_name = "spacemit-x60",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .dlen_factor_2,
            .i,
            .m,
            .optimized_nf2_segment_load_store,
            .optimized_nf3_segment_load_store,
            .optimized_nf4_segment_load_store,
            .ssccptr,
            .sscofpmf,
            .sscounterenw,
            .sstc,
            .sstvala,
            .sstvecd,
            .svade,
            .svbare,
            .svinval,
            .svnapot,
            .svpbmt,
            .unaligned_scalar_mem,
            .v,
            .vxrm_pipeline_flush,
            .za64rs,
            .zbc,
            .zbkc,
            .zfh,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zicond,
            .zifencei,
            .zihintpause,
            .zihpm,
            .zkt,
            .zvfh,
            .zvkt,
            .zvl256b,
        }),
    };
    pub const syntacore_scr1_base: CpuModel = .{
        .name = "syntacore_scr1_base",
        .llvm_name = "syntacore-scr1-base",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .c,
            .i,
            .no_default_unroll,
            .zicsr,
            .zifencei,
        }),
    };
    pub const syntacore_scr1_max: CpuModel = .{
        .name = "syntacore_scr1_max",
        .llvm_name = "syntacore-scr1-max",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .c,
            .i,
            .m,
            .no_default_unroll,
            .zicsr,
            .zifencei,
        }),
    };
    pub const syntacore_scr3_rv32: CpuModel = .{
        .name = "syntacore_scr3_rv32",
        .llvm_name = "syntacore-scr3-rv32",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .c,
            .i,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .zicsr,
            .zifencei,
        }),
    };
    pub const syntacore_scr3_rv64: CpuModel = .{
        .name = "syntacore_scr3_rv64",
        .llvm_name = "syntacore-scr3-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .i,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .zicsr,
            .zifencei,
        }),
    };
    pub const syntacore_scr4_rv32: CpuModel = .{
        .name = "syntacore_scr4_rv32",
        .llvm_name = "syntacore-scr4-rv32",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .c,
            .d,
            .i,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .zifencei,
        }),
    };
    pub const syntacore_scr4_rv64: CpuModel = .{
        .name = "syntacore_scr4_rv64",
        .llvm_name = "syntacore-scr4-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .zifencei,
        }),
    };
    pub const syntacore_scr5_rv32: CpuModel = .{
        .name = "syntacore_scr5_rv32",
        .llvm_name = "syntacore-scr5-rv32",
        .features = featureSet(&[_]Feature{
            .@"32bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .zifencei,
        }),
    };
    pub const syntacore_scr5_rv64: CpuModel = .{
        .name = "syntacore_scr5_rv64",
        .llvm_name = "syntacore-scr5-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .zifencei,
        }),
    };
    pub const syntacore_scr7: CpuModel = .{
        .name = "syntacore_scr7",
        .llvm_name = "syntacore-scr7",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .i,
            .m,
            .no_default_unroll,
            .use_postra_scheduler,
            .v,
            .zba,
            .zbb,
            .zbc,
            .zbs,
            .zifencei,
            .zkn,
        }),
    };
    pub const tt_ascalon_d8: CpuModel = .{
        .name = "tt_ascalon_d8",
        .llvm_name = "tt-ascalon-d8",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .b,
            .c,
            .i,
            .m,
            .no_default_unroll,
            .optimized_zero_stride_load,
            .sha,
            .smaia,
            .ssaia,
            .ssccptr,
            .sscofpmf,
            .sscounterenw,
            .ssnpm,
            .ssstrict,
            .sstc,
            .sstvala,
            .sstvecd,
            .ssu64xl,
            .supm,
            .svade,
            .svbare,
            .svinval,
            .svnapot,
            .svpbmt,
            .unaligned_scalar_mem,
            .unaligned_vector_mem,
            .use_postra_scheduler,
            .v,
            .za64rs,
            .zawrs,
            .zcb,
            .zcmop,
            .zfa,
            .zfh,
            .zic64b,
            .zicbom,
            .zicbop,
            .zicboz,
            .ziccamoa,
            .ziccif,
            .zicclsm,
            .ziccrse,
            .zicntr,
            .zicond,
            .zifencei,
            .zihintntl,
            .zihintpause,
            .zihpm,
            .zimop,
            .zkt,
            .zvbb,
            .zvbc,
            .zvfbfwma,
            .zvfh,
            .zvkng,
            .zvl256b,
        }),
    };
    pub const veyron_v1: CpuModel = .{
        .name = "veyron_v1",
        .llvm_name = "veyron-v1",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .auipc_addi_fusion,
            .c,
            .d,
            .i,
            .ld_add_fusion,
            .lui_addi_fusion,
            .m,
            .shifted_zextw_fusion,
            .ventana_veyron,
            .xventanacondops,
            .zba,
            .zbb,
            .zbc,
            .zbs,
            .zexth_fusion,
            .zextw_fusion,
            .zicbom,
            .zicbop,
            .zicboz,
            .zicntr,
            .zifencei,
            .zihintpause,
            .zihpm,
        }),
    };
    pub const xiangshan_nanhu: CpuModel = .{
        .name = "xiangshan_nanhu",
        .llvm_name = "xiangshan-nanhu",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .i,
            .m,
            .no_default_unroll,
            .shifted_zextw_fusion,
            .svinval,
            .zba,
            .zbb,
            .zbc,
            .zbs,
            .zexth_fusion,
            .zextw_fusion,
            .zicbom,
            .zicboz,
            .zifencei,
            .zkn,
            .zksed,
            .zksh,
        }),
    };
};
