/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2002 Maxime Henrion <mux@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SYS_KENV_H_
#define _SYS_KENV_H_

/*
 * Constants for the kenv(2) syscall
 */
#define KENV_GET		0
#define KENV_SET		1
#define KENV_UNSET		2
#define KENV_DUMP		3
#define KENV_DUMP_LOADER	4
#define KENV_DUMP_STATIC	5

#define KENV_MNAMELEN	128	/* Maximum name length (for the syscall) */
#define KENV_MVALLEN	128	/* Maximum value length (for the syscall) */

#ifdef _KERNEL
/*
 * Most of these variables should be const.
 */
extern bool dynamic_kenv;
extern struct mtx kenv_lock;
extern char *kern_envp;
extern char *md_envp;
extern char static_env[];
extern char static_hints[];	/* by config for now */

extern char **kenvp;
#endif /* _KERNEL */

#endif /* !_SYS_KENV_H_ */